﻿using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationCURELSearch2018
{
    /// <summary>
    /// CURELSearch
    /// </summary>
    [DataContract(Name = "CURELSearch", Namespace = "http://www.sbr.gov.au/ato/curelsearch")]
    public class CURELSearch
    {

        [DataMember(EmitDefaultValue = false, Order = 1)]
        public INT INT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public RP RP { get; set; }
    }

    /// <summary>
    /// Intermediary
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/curelsearch")]
    public class INT
    {

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Registered Agent Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string TaxAgentNumberId { get; set; }

        /// <summary>
        /// Acting as a Payroll provider
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public bool? InteractionPayrollProviderI { get; set; }
    }

    /// <summary>
    /// Reporting Party
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/curelsearch")]
    public class RP
    {

        /// <summary>
        /// Tax File Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Withholding Payer Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string WithholdingPayerNumberId { get; set; }

        /// <summary>
        /// Excise Identification Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string ExciseIdentificationNumberId { get; set; }

        /// <summary>
        /// Australian Taxation Office Reference Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AustralianTaxationOfficeReferenceNumberId { get; set; }

        /// <summary>
        /// Entity name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string PartyEntityNameT { get; set; }

        /// <summary>
        /// Individual date of birth
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public DateTime? PersonDemographicDetailsBirthD { get; set; }
    }
}

