using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationCURELAddRemove2018
{
    /// <summary>
    /// CURELAddRemove
    /// </summary>
    [DataContract(Name = "CURELAddRemove", Namespace = "http://www.sbr.gov.au/ato/cureladdremove")]
    public class CURELAddRemove
    {

        [DataMember(EmitDefaultValue = false, Order = 1)]
        public INT INT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public RP RP { get; set; }
    }

    /// <summary>
    /// Intermediary Declaration
    /// </summary>
    [DataContract(Name = "Declaration", Namespace = "http://www.sbr.gov.au/ato/cureladdremove")]
    public class Declaration
    {

        /// <summary>
        /// Intermediary signature indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public bool StatementAcceptedI { get; set; }

        /// <summary>
        /// Intermediary identifier
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string SignatoryIdentifierT { get; set; }
    }

    /// <summary>
    /// Intermediary
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/cureladdremove")]
    public class INT
    {

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Registered Agent Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string TaxAgentNumberId { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public Declaration Declaration { get; set; }
    }

    /// <summary>
    /// Relationship Detail
    /// </summary>
    [CollectionDataContract(Name = "RelationshipDetailCollection", Namespace = "http://www.sbr.gov.au/ato/cureladdremove", ItemName = "RelationshipDetail")]
    public class RelationshipDetailCollection : List<RelationshipDetail> { }

    /// <summary>
    /// Relationship Detail
    /// </summary>
    [DataContract(Name = "RelationshipDetail", Namespace = "http://www.sbr.gov.au/ato/cureladdremove")]
    public class RelationshipDetail
    {

        /// <summary>
        /// Relationship update action
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string InteractionClientRelationshipUpdateC { get; set; }

        /// <summary>
        /// Client account identifier
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string TaxAccountId { get; set; }

        /// <summary>
        /// Client account sequence number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? TaxAccountSequenceN { get; set; }

        /// <summary>
        /// Role type
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string TaxRoleTypeC { get; set; }

        /// <summary>
        /// Relationship start date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public DateTime? PartyAgentRelationshipStartD { get; set; }
    }

    /// <summary>
    /// Reporting Party
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/cureladdremove")]
    public class RP
    {

        /// <summary>
        /// Tax File Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Withholding Payer Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string WithholdingPayerNumberId { get; set; }

        /// <summary>
        /// Excise Identification Nnumber
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string ExciseIdentificationNumberId { get; set; }

        /// <summary>
        /// Australian Taxation Office Reference Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AustralianTaxationOfficeReferenceNumberId { get; set; }

        /// <summary>
        /// Individual date of birth
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public DateTime? PersonDemographicDetailsBirthD { get; set; }

        /// <summary>
        /// Entity name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string PartyEntityNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 8)]
        public RelationshipDetailCollection RelationshipDetailCollection { get; set; }
    }
}

