using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationCURELList2018
{
    /// <summary>
    /// CURELList
    /// </summary>
    [DataContract(Name = "CURELList", Namespace = "http://www.sbr.gov.au/ato/curellist")]
    public class CURELList
    {

        [DataMember(EmitDefaultValue = false, Order = 1)]
        public INT INT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public RP RP { get; set; }
    }

    /// <summary>
    /// Pagination
    /// </summary>
    [DataContract(Name = "Pagination", Namespace = "http://www.sbr.gov.au/ato/curellist")]
    public class Pagination
    {

        /// <summary>
        /// Record limit
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal InteractionRecordLimitCt { get; set; }

        /// <summary>
        /// Record start number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal InteractionRecordListIndexN { get; set; }
    }

    /// <summary>
    /// Intermediary
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/curellist")]
    public class INT
    {

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Tax Agent Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string TaxAgentNumberId { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public Pagination Pagination { get; set; }
    }

    /// <summary>
    /// Reporting Party
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/curellist")]
    public class RP
    {

        /// <summary>
        /// Tax File Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Withholding Payer Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string WithholdingPayerNumberId { get; set; }

        /// <summary>
        /// Excise Identification Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string ExciseIdentificationNumberId { get; set; }

        /// <summary>
        /// Australian Taxation Office Reference Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AustralianTaxationOfficeReferenceNumberId { get; set; }

        /// <summary>
        /// Relationship Type
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string PartyEntityRelationshipTypeC { get; set; }
    }
}