using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationFBT2026
{
    /// <summary>
    /// FBT
    /// </summary>
    [DataContract(Name = "FBT", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class FBT
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public RP RP { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public INT INT { get; set; }
    }

    /// <summary>
    /// IndividualDetail
    /// </summary>
    [DataContract(Name = "IndividualDetail", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class IndividualDetail
    {
        /// <summary>
        /// Trustee or senior partner current individual name - Title
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PersonNameDetailsTitleT { get; set; }

        /// <summary>
        /// Trustee or senior partner current individual name - Suffix
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string PersonNameDetailsNameSuffixT { get; set; }

        /// <summary>
        /// Trustee or senior partner current individual name - Family name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PersonNameDetailsFamilyNameT { get; set; }

        /// <summary>
        /// Trustee or senior partner current individual name - First name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PersonNameDetailsGivenNameT { get; set; }

        /// <summary>
        /// Trustee or senior partner current individual name - Other given names
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PersonNameDetailsOtherGivenNameT { get; set; }
    }

    /// <summary>
    /// CurrentTrusteeOrSeniorPartner
    /// </summary>
    [DataContract(Name = "CurrentTrusteeOrSeniorPartner", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class CurrentTrusteeOrSeniorPartner
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public IndividualDetail IndividualDetail { get; set; }

        /// <summary>
        /// Trustee or senior partner current non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }
    }

    /// <summary>
    /// PreviousTrusteeOrSeniorPartner
    /// </summary>
    [DataContract(Name = "PreviousTrusteeOrSeniorPartner", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class PreviousTrusteeOrSeniorPartner
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public IndividualDetail IndividualDetail { get; set; }

        /// <summary>
        /// Trustee or senior partner previous non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }
    }

    /// <summary>
    /// AddressDetails
    /// </summary>
    [DataContract(Name = "AddressDetails", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class AddressDetails
    {
        /// <summary>
        /// Employer current postal address - Overseas address indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public bool OverseasAddressI { get; set; }

        /// <summary>
        /// Employer current postal address - Line 1
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string Line1T { get; set; }

        /// <summary>
        /// Employer current postal address - Line 2
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string Line2T { get; set; }

        /// <summary>
        /// Employer current postal address - Suburb/town/locality
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string LocalityNameT { get; set; }

        /// <summary>
        /// Employer current postal address - Postcode
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PostcodeT { get; set; }

        /// <summary>
        /// Employer current postal address - State/territory
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string StateOrTerritoryC { get; set; }

        /// <summary>
        /// Employer current postal address - Country code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string CountryC { get; set; }
    }

    /// <summary>
    /// CurrentEmployer
    /// </summary>
    [DataContract(Name = "CurrentEmployer", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class CurrentEmployer
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public IndividualDetail IndividualDetail { get; set; }

        /// <summary>
        /// Employer current non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public AddressDetails AddressDetails { get; set; }
    }

    /// <summary>
    /// PreviousEmployer
    /// </summary>
    [DataContract(Name = "PreviousEmployer", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class PreviousEmployer
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public IndividualDetail IndividualDetail { get; set; }

        /// <summary>
        /// Employer previous non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public AddressDetails AddressDetails { get; set; }
    }

    /// <summary>
    /// BusinessTradingDetails
    /// </summary>
    [DataContract(Name = "BusinessTradingDetails", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class BusinessTradingDetails
    {
        /// <summary>
        /// Business/trading name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        /// <summary>
        /// Business/trading address - Overseas indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool AddressDetailsOverseasAddressI { get; set; }

        /// <summary>
        /// Business/trading address - Line 1
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string AddressDetailsLine1T { get; set; }

        /// <summary>
        /// Business/trading address - Line 2
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string AddressDetailsLine2T { get; set; }

        /// <summary>
        /// Business/trading address - Suburb/town/locality
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AddressDetailsLocalityNameT { get; set; }

        /// <summary>
        /// Business/trading address - Postcode
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string AddressDetailsPostcodeT { get; set; }

        /// <summary>
        /// Business/trading address - State/territory
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string AddressDetailsStateOrTerritoryC { get; set; }

        /// <summary>
        /// Business/trading address - Country code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 8)]
        public string AddressDetailsCountryC { get; set; }
    }

    /// <summary>
    /// ContactDetails
    /// </summary>
    [DataContract(Name = "ContactDetails", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class ContactDetails
    {
        /// <summary>
        /// Contact person name - Title
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PersonNameDetailsTitleT { get; set; }

        /// <summary>
        /// Contact person name - Suffix
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string PersonNameDetailsNameSuffixT { get; set; }

        /// <summary>
        /// Contact person name - Family name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PersonNameDetailsFamilyNameT { get; set; }

        /// <summary>
        /// Contact person name - First name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PersonNameDetailsGivenNameT { get; set; }

        /// <summary>
        /// Contact person name - Other given names
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PersonNameDetailsOtherGivenNameT { get; set; }

        /// <summary>
        /// Contact person telephone area code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string ElectronicContactTelephoneAreaC { get; set; }

        /// <summary>
        /// Contact person telephone number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string ElectronicContactTelephoneMinimalN { get; set; }

        /// <summary>
        /// Contact person email address
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 8)]
        public string ElectronicContactElectronicMailAddressT { get; set; }
    }

    /// <summary>
    /// BankDetails
    /// </summary>
    [DataContract(Name = "BankDetails", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class BankDetails
    {
        /// <summary>
        /// Bank State Branch number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string FinancialInstitutionAccountBankStateBranchN { get; set; }

        /// <summary>
        /// Account number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountN { get; set; }

        /// <summary>
        /// Account name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountNameT { get; set; }
    }

    /// <summary>
    /// ReturnCalculationDetails
    /// </summary>
    [DataContract(Name = "ReturnCalculationDetails", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class ReturnCalculationDetails
    {
        /// <summary>
        /// Type 1 aggregate amount
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsType1AggregateA { get; set; }

        /// <summary>
        /// Type 1 aggregate factored amount
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? FringeBenefitsTaxType1AggregateA { get; set; }

        /// <summary>
        /// Type 2 aggregate amount
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsType2AggregateA { get; set; }

        /// <summary>
        /// Type 2 aggregate factored amount
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal? FringeBenefitsTaxType2AggregateA { get; set; }

        /// <summary>
        /// Aggregate Non-exempt amount (hospitals, ambulances, public benevolent institutions and health promotion charities only)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public decimal? RemunerationFringeBenefitsAggregateNonExemptA { get; set; }

        /// <summary>
        /// Fringe benefits taxable amount (A + B) or C
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public decimal RemunerationFringeBenefitsTaxableTotalA { get; set; }

        /// <summary>
        /// Amount of tax payable
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public decimal FringeBenefitsTaxPayableA { get; set; }

        /// <summary>
        /// Aggregate non rebatable amount
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 8)]
        public decimal? FringeBenefitsTaxNonRebatableAggregateA { get; set; }

        /// <summary>
        /// Amount of rebate
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 9)]
        public decimal? FringeBenefitsTaxRebateA { get; set; }

        /// <summary>
        /// Sub - total
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 10)]
        public decimal FringeBenefitsTaxLiabilityA { get; set; }

        /// <summary>
        /// Less instalment amounts reported on activity statements
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 11)]
        public decimal? FringeBenefitsTaxLiabilityInstalmentsTotalA { get; set; }

        /// <summary>
        /// Payment or credit due
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 12)]
        public decimal FringeBenefitsTaxAdjustmentDueA { get; set; }
    }

    /// <summary>
    /// CarStatutoryFormula
    /// </summary>
    [DataContract(Name = "CarStatutoryFormula", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class CarStatutoryFormula
    {
        /// <summary>
        /// Cars - statutory formula - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsItemsProvidedN { get; set; }

        /// <summary>
        /// Cars - statutory formula - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Cars - statutory formula - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Cars - statutory formula - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// CarOperatingCostMethod
    /// </summary>
    [DataContract(Name = "CarOperatingCostMethod", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class CarOperatingCostMethod
    {
        /// <summary>
        /// Cars - operating cost method - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsItemsProvidedN { get; set; }

        /// <summary>
        /// Cars - operating cost method- Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Cars - operating cost method - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Cars - operating cost method - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// LoansGranted
    /// </summary>
    [DataContract(Name = "LoansGranted", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class LoansGranted
    {
        /// <summary>
        /// Loans granted - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsItemsProvidedN { get; set; }

        /// <summary>
        /// Loans granted - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Loans granted - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Loans granted - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// DebtWaiver
    /// </summary>
    [DataContract(Name = "DebtWaiver", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class DebtWaiver
    {
        /// <summary>
        /// Debt waiver - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Debt waiver - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// ExpensePayments
    /// </summary>
    [DataContract(Name = "ExpensePayments", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class ExpensePayments
    {
        /// <summary>
        /// Expense payments - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Expense payments - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Expense payments - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Expense payments - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// Housing
    /// </summary>
    [DataContract(Name = "Housing", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class Housing
    {
        /// <summary>
        /// Housing - units of accommodation provided - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsItemsProvidedN { get; set; }

        /// <summary>
        /// Housing - units of accommodation provided - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Housing - units of accommodation provided - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Housing - units of accommodation provided - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// LAFHA
    /// </summary>
    [DataContract(Name = "LAFHA", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class LAFHA
    {
        /// <summary>
        /// Employees receiving living-away-from-home allowance - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsItemsProvidedN { get; set; }

        /// <summary>
        /// Employees receiving living-away-from-home allowance - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Employees receiving living-away-from-home allowance - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Employees receiving living-away-from-home allowance - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// Board
    /// </summary>
    [DataContract(Name = "Board", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class Board
    {
        /// <summary>
        /// Board - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Board - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Board - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Board - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// Property
    /// </summary>
    [DataContract(Name = "Property", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class Property
    {
        /// <summary>
        /// Property - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Property - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Property - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Property - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// ITExemptBodyEntertainment
    /// </summary>
    [DataContract(Name = "ITExemptBodyEntertainment", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class ITExemptBodyEntertainment
    {
        /// <summary>
        /// Income tax exempt body - entertainment - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Income tax exempt body - entertainment - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// OtherBenefits
    /// </summary>
    [DataContract(Name = "OtherBenefits", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class OtherBenefits
    {
        /// <summary>
        /// Other benefits (residual) - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Other benefits (residual) - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Other benefits (residual) - Value of reductions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal? RemunerationFringeBenefitsReductionA { get; set; }

        /// <summary>
        /// Other benefits (residual) - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// CarParking
    /// </summary>
    [DataContract(Name = "CarParking", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class CarParking
    {
        /// <summary>
        /// Car parking - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Car parking - Employee contribution
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal? RemunerationFringeBenefitsEmployeeContributionA { get; set; }

        /// <summary>
        /// Car parking - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// MealEntertainment
    /// </summary>
    [DataContract(Name = "MealEntertainment", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class MealEntertainment
    {
        /// <summary>
        /// Meal entertainment - Gross taxable value
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public decimal? RemunerationFringeBenefitsBenefitGrossTaxableA { get; set; }

        /// <summary>
        /// Meal entertainment - Taxable value of benefits
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public decimal RemunerationFringeBenefitsBenefitNetTaxableA { get; set; }
    }

    /// <summary>
    /// Declaration
    /// </summary>
    [DataContract(Name = "Declaration", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class Declaration
    {
        /// <summary>
        /// Reporting Party Statement Type Code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string StatementTypeC { get; set; }

        /// <summary>
        /// Reporting Party Statement Accepted Indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool StatementAcceptedI { get; set; }

        /// <summary>
        /// Reporting Party Signature Date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public DateTime SignatureD { get; set; }

        /// <summary>
        /// Reporting Party Signatory Identifier Text
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string SignatoryIdentifierT { get; set; }
    }

    /// <summary>
    /// RP
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class RP
    {
        /// <summary>
        /// Tax file number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Year of return
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public int LodgmentPeriodYearY { get; set; }

        /// <summary>
        /// Amended Indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public bool? AmendmentI { get; set; }

        /// <summary>
        /// Amendment Sequence - Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public decimal? AmendmentSequenceN { get; set; }

        /// <summary>
        /// Amendment Type Code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string AmendmentTypeC { get; set; }

        /// <summary>
        /// Amendment Reason
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string AmendmentReasonT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 8)]
        public CurrentTrusteeOrSeniorPartner CurrentTrusteeOrSeniorPartner { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 9)]
        public PreviousTrusteeOrSeniorPartner PreviousTrusteeOrSeniorPartner { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 10)]
        public CurrentEmployer CurrentEmployer { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 11)]
        public PreviousEmployer PreviousEmployer { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 12)]
        public BusinessTradingDetails BusinessTradingDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 13)]
        public ContactDetails ContactDetails { get; set; }

        /// <summary>
        /// Number of employees receiving fringe benefits during the year between 1 April and 31 March
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 14)]
        public decimal? RemunerationFringeBenefitsRecipientsCt { get; set; }

        /// <summary>
        /// Hours taken to prepare and complete this form
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 15)]
        public decimal? CompletionHoursN { get; set; }

        /// <summary>
        /// Do you expect to lodge FBT returns in future years?
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 16)]
        public bool LodgmentFutureReturnI { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 17)]
        public BankDetails BankDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 18)]
        public ReturnCalculationDetails ReturnCalculationDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 19)]
        public CarStatutoryFormula CarStatutoryFormula { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 20)]
        public CarOperatingCostMethod CarOperatingCostMethod { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 21)]
        public LoansGranted LoansGranted { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 22)]
        public DebtWaiver DebtWaiver { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 23)]
        public ExpensePayments ExpensePayments { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 24)]
        public Housing Housing { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 25)]
        public LAFHA LAFHA { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 26)]
        public Board Board { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 27)]
        public Property Property { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 28)]
        public ITExemptBodyEntertainment ITExemptBodyEntertainment { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 29)]
        public OtherBenefits OtherBenefits { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 30)]
        public CarParking CarParking { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 31)]
        public MealEntertainment MealEntertainment { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 32)]
        public Declaration Declaration { get; set; }

        /// <summary>
        /// Additional Information
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 33)]
        public string RegulatoryDisclosuresGeneralInformationAboutFinancialStatementsT { get; set; }
    }

    /// <summary>
    /// INT
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/fbt")]
    public class INT
    {
        /// <summary>
        /// Intermediary contact name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PersonUnstructuredNameFullNameT { get; set; }

        /// <summary>
        /// Australian Business Number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Intermediary telephone area code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string ElectronicContactTelephoneAreaC { get; set; }

        /// <summary>
        /// Intermediary telephone number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string ElectronicContactTelephoneMinimalN { get; set; }

        /// <summary>
        /// Tax Agent number (TAN)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string TaxAgentNumberId { get; set; }

        /// <summary>
        /// Client's reference
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string TaxAgentClientReferenceT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 7)]
        public Declaration Declaration { get; set; }
    }
}