using System;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationFVSSubmitRequest2026
{
    /// <summary>
    /// FVSSubmitRequest
    /// </summary>
    [DataContract(Name = "FVSSubmitRequest", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class FVSSubmitRequest
    {
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public INT INT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public RP RP { get; set; }
    }

    /// <summary>
    /// Intermediary
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class INT
    {
        /// <summary>
        /// Intermediary ABN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Intermediary business name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }
    }

    /// <summary>
    /// New Fund Details
    /// </summary>
    [DataContract(Name = "NewFundDetails", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class NewFundDetails
    {
        /// <summary>
        /// New fund ABN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// New fund USI
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string SuperannuationFundDetailsUniqueSuperannuationIdentifierId { get; set; }
    }

    /// <summary>
    /// Contributions Details
    /// </summary>
    [DataContract(Name = "ContributionDetails", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class ContributionDetails
    {
        /// <summary>
        /// Electronic Service Address
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string ElectronicContactElectronicServiceAddressT { get; set; }

        /// <summary>
        /// NPP indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool SuperannuationPaymentNewPaymentPlatformI { get; set; }

        /// <summary>
        /// NPP PayID
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PaymentMechanismPayIDId { get; set; }

        /// <summary>
        /// BSB
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string FinancialInstitutionAccountBankStateBranchN { get; set; }

        /// <summary>
        /// Account number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountN { get; set; }

        /// <summary>
        /// Account name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountNameT { get; set; }

        /// <summary>
        /// BPAY details
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string PaymentMechanismBpayBillerC { get; set; }
    }

    /// <summary>
    /// Rollover Details
    /// </summary>
    [DataContract(Name = "RolloverDetails", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class RolloverDetails
    {
        /// <summary>
        /// Electronic Service Address
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string ElectronicContactElectronicServiceAddressT { get; set; }

        /// <summary>
        /// NPP indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool SuperannuationPaymentNewPaymentPlatformI { get; set; }

        /// <summary>
        /// NPP PayID
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PaymentMechanismPayIDId { get; set; }

        /// <summary>
        /// BSB
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string FinancialInstitutionAccountBankStateBranchN { get; set; }

        /// <summary>
        /// Account number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountN { get; set; }

        /// <summary>
        /// Account name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string FinancialInstitutionAccountFinancialInstitutionAccountNameT { get; set; }
    }

    /// <summary>
    /// Technical Assistance Contact Details
    /// </summary>
    [DataContract(Name = "TechnicalAssistanceContactDetails", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class TechnicalAssistanceContactDetails
    {
        /// <summary>
        /// Contact name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PersonUnstructuredNameFullNameT { get; set; }

        /// <summary>
        /// Contact phone number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string ElectronicContactTelephoneMinimalN { get; set; }

        /// <summary>
        /// Contact email address
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string ElectronicContactElectronicMailAddressT { get; set; }

        /// <summary>
        /// Website address
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string ElectronicContactWebUniformResourceLocatorT { get; set; }
    }

    /// <summary>
    /// Product (USI) Information
    /// </summary>
    [DataContract(Name = "ProductUSIInformation", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class ProductUSIInformation
    {
        /// <summary>
        /// Unique Superannuation Identifier (USI)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string SuperannuationFundDetailsUniqueSuperannuationIdentifierId { get; set; }

        /// <summary>
        /// Contribution restrictions
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool SuperannuationProductDetailsEmployerContributionRestrictionI { get; set; }

        /// <summary>
        /// Superannuation product name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string SuperannuationProductDetailsNameT { get; set; }

        /// <summary>
        /// USI close reason
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string SuperannuationFundDetailsClosedUniqueSuperannuationIdentifierReasonC { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 5)]
        public NewFundDetails NewFundDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 6)]
        public ContributionDetails ContributionDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 7)]
        public RolloverDetails RolloverDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 8)]
        public TechnicalAssistanceContactDetails TechnicalAssistanceContactDetails { get; set; }
    }

    /// <summary>
    /// Reporting Party
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/fvssubmitrequest")]
    public class RP
    {
        /// <summary>
        /// Effective date (from)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public DateTime PeriodStartD { get; set; }

        /// <summary>
        /// Effective date (to)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public DateTime PeriodEndD { get; set; }

        /// <summary>
        /// Super Fund ABN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// The name of the superannuation entity
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        /// <summary>
        /// The standard and version the fund is certified for.
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string ElectronicContactWebServicesConformanceToStandardT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 6)]
        public ProductUSIInformation ProductUSIInformation { get; set; }
    }
}