﻿using Ato.EN.IntegrationServices.CodeGenerationINCDTLS;
using DataContracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;

namespace Ato.EN.IntegrationServices.CodeGenerationIITR
{
    using GovernmentBenefit = INCDTLS2026.Rp_Income.Rp_Income_GovernmentBenefit;

    public partial class IITR2026CrossformValidator
    {
        private const decimal SlsUntaxedPlanCapThreshold = 1780000;
        private const decimal SlsLifetimeCapThreshold = 245000;
        private static readonly List<string> australianCountryCodes = new List<string> { "au", "cc", "cx", "nf", "hm", null };

        /// <summary>
        /// Takes a report to validate against all INCDTLS rules and store the results in the response paramaeter object.
        /// </summary>
        /// <param name="report">Document to be validated with INCDTLS rules.</param>
        /// <param name="response">Response to add error codes to.</param>
        public static void ValidateINCDTLS(IITR2026Crossform report, List<ProcessMessageDocument> response)
        {
            INCDTLS2026 incdtlsChildDocument = Count(report.incdtlsChildDocuments) == 0 ? null : report.incdtlsChildDocuments[0];

            int incdtlsChildCount = Count(report.incdtlsChildDocuments);

            #region INCDTLS Child Present

            if (incdtlsChildCount == 1)
            {
                AddProcessMessage(VR_ATO_IITR_730050(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730051(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730052(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730053(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730054(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730055(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730056(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730057(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730058(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730059(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730060(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730061(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730062(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730063(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730064(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730065(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730066(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730067(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730068(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730069(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730070(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730071(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730072(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730073(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730074(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730076(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730077(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730078(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730079(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730080(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730081(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730082(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730083(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730084(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730085(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730086(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730087(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730088(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730089(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730090(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730091(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730092(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730093(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730094(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730095(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730096(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730097(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730150(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730151(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730152(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730153(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730154(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730155(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730156(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730157(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730158(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730159(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730164(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730165(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730175(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730176(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730177(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730178(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730179(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730180(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730181(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730182(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730183(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730184(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730185(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730186(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730187(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730188(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730189(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730190(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730191(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730192(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730193(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730194(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730195(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730196(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730197(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730198(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730199(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730230(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730231(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730232(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730233(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730234(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730235(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730236(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730237(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730238(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730239(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730240(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730241(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730242(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730243(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730244(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730245(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730246(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730247(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730248(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730249(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730250(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730251(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730252(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730253(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730254(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730255(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730256(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730257(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730258(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730259(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730260(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730327(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730328(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730353(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730354(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730355(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730356(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730275(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730276(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730277(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730278(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730279(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730280(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730281(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730282(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730283(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730284(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730285(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730286(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730287(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730288(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730289(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730290(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730291(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730297(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730298(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730299(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730357(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730358(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730359(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730380(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730381(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730406(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730407(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730402(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730403(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730404(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730405(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730408(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730409(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730410(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730411(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730412(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730413(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730414(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730415(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730416(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730417(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730450(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730451(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730452(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730453(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730454(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730455(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730292(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730293(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730294(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730295(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730296(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730374(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730375(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730376(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730377(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730378(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730379(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730456(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730457(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730418(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730419(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730420(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730421(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730422(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730423(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730460(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730461(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730462(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730463(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730464(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730465(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730430(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730431(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730432(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730433(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730468(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730469(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730470(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730471(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730472(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730473(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730474(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730475(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730476(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730477(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730478(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730479(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730424(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730425(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730426(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730427(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730428(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730429(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730434(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730436(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730437(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730480(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730481(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730482(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730485(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730486(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730487(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730491(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730492(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730493(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730494(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730495(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_730496(report, incdtlsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_W00002(report, incdtlsChildDocument), response);
            }

            #endregion // INCDTLS Child Present

            AddProcessMessage(VR_ATO_IITR_300087(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_600097(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_730064(report, null), response);
            AddProcessMessage(VR_ATO_IITR_730264(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_300105(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_300106(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_730488(report, incdtlsChildDocument), response);
            AddProcessMessage(VR_ATO_IITR_800005(report, incdtlsChildDocument), response);
        }

        #region INCDTLS Helper Functions

        // Government Benefit
        internal static List<GovernmentBenefit> GetAllGovernmentBenefitTuples(INCDTLS2026 report)
        {
            List<GovernmentBenefit> response = new List<GovernmentBenefit>();

            if (report != null && Count(report.Rp_IncomeCollection) != 0)
            {
                response = report.Rp_IncomeCollection.SelectMany(income => income.Rp_Income_GovernmentBenefitCollection ?? new List<GovernmentBenefit>()).Distinct().ToList();
            }

            return response;
        }

        /*
         * Helper class to store an ABN and calculated amounts so that the amounts don't need to be recalculated on multiple iterations of loops
         * Helper class assists calculations for Validation rules VR.ATO.IITR.730190, VR.ATO.IITR.730191, VR.ATO.IITR.730192.
        */
        public class CalculatedABNAmounts
        {
            public string Abn { get; set; }
            public decimal SumINCDTLS329 { get; set; }
            public decimal SumINCDTLS331 { get; set; }

            /*
         * Helper method to calculate and store amounts for each ABN once so that the amounts don't need to be recalculated again and again on multiple iterations of loops
         * Helper method assists calculations for Validation rules VR.ATO.IITR.730190, VR.ATO.IITR.730191, VR.ATO.IITR.730192.
        */
            public static List<CalculatedABNAmounts> GetListOfCalculatedAmountsForEachABN(INCDTLS2026 incdtlschilddoc)
            {
                List<string> distinctABNs = incdtlschilddoc.Rp_IncomeCollection.Select(income => income.INCDTLS307)
                    .Where(abn => !string.IsNullOrWhiteSpace(abn))
                    .Distinct()
                    .ToList();

                List<CalculatedABNAmounts> calculatedABNAmounts = new List<CalculatedABNAmounts>();

                if (incdtlschilddoc.Rp_IncomeCollection != null)
                {
                    foreach (string abn in distinctABNs)
                    {
                        List<INCDTLS2026.Rp_Income> localIncomeTuplesAbn = incdtlschilddoc.Rp_IncomeCollection
                            .FindAll(
                                iterationTuple => iterationTuple.INCDTLS307 == abn && iterationTuple.INCDTLS330.GetValueOrDefault() == 0
                            );

                        decimal sumUntaxedElement = localIncomeTuplesAbn
                            .Sum(iterationTuple => iterationTuple.INCDTLS331.GetValueOrDefault());

                        decimal sumCreditTaxWitheldAmount = localIncomeTuplesAbn
                            .Sum(iterationTuple => iterationTuple.INCDTLS329.GetValueOrDefault());

                        calculatedABNAmounts.Add(new CalculatedABNAmounts
                        {
                            Abn = abn,
                            SumINCDTLS329 = sumCreditTaxWitheldAmount,
                            SumINCDTLS331 = sumUntaxedElement
                        });
                    }
                }

                // Return the list of calculated amounts to the calling function.
                return calculatedABNAmounts;
            }
        }

        #endregion

        #region VR.ATO.IITR.300087

        /* VR.ATO.IITR.300087
            Taxpayer is ineligible to make deposits and claim deductions for deductible deposits because taxpayer's non-primary production income exceeded the threshold amount.

        Legacy Rule Format:
            (^IITR302 > 0) AND ((^IITR157 + ^IITR154 + ^IITR156 - ^IITR311 - (^IITR242 + ^IITR243 - ^IITR245 - ^IITR246 + ^IITR281 + ^IITR299 + ^IITR306) - ConditionalValue(CountDocument('INCDTLS') = 1,Sum(ConditionalValue(InSet(^INCDTLS138, '"D","B","N"'),^INCDTLS140,0)),0) - Sum(ConditionalValue((CountDocument('INCDTLS') = 1) AND (^INCDTLS333 = FALSE),(^INCDTLS330 + ^INCDTLS331),0))) > 100000)

        Technical Business Rule Format:
            (^IITR302 > 0) AND ((^IITR157 + ^IITR154 + ^IITR156 - ^IITR311 - (^IITR242 + ^IITR243 - ^IITR245 - ^IITR246 + ^IITR281 + ^IITR299 + ^IITR306) - ConditionalValue(CountDocument('INCDTLS') = 1,Sum(ConditionalValue(InSet(^INCDTLS138, '"D","B","N"'),^INCDTLS140,0)),0) - Sum(ConditionalValue((CountDocument('INCDTLS') = 1) AND (^INCDTLS333 = FALSE),(^INCDTLS330 + ^INCDTLS331),0))) > 100000)

        Data Elements:
    
        ^IITR302 = RP:IncomeTax.Deduction.FarmManagementDeposits.Amount
    
        ^IITR154 = RP:IncomeTax.LossesClaimedPrimaryProduction.Amount
    
        ^IITR156 = RP:IncomeTax.LossesClaimedNonPrimaryProduction.Amount
    
        ^IITR157 = RP:Income.Taxable.Amount
    
        ^IITR242 = RP:Income.PartnershipPrimaryProductionShare.Amount
    
        ^IITR243 = RP:Income.TrustPrimaryProductionNetShare.Amount
    
        ^IITR245 = RP.Partnership:Expense.LandcareOperationsAcceleratedDepreciation.Amount
    
        ^IITR246 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
    
        ^IITR281 = RP:Income.PrimaryProductionNet.Amount
    
        ^IITR299 = RP:Tax.Losses.DeferredNonCommercialPrimaryProduction.Amount
    
        ^IITR306 = RP:Income.FarmManagementDepositsOrRepaymentsNet.Amount
    
        ^IITR311 = RP:Capital.Gains.Net.Amount
    
        ^INCDTLS138 = INCDTLS138
    
        ^INCDTLS140 = INCDTLS140
    
        ^INCDTLS330 = INCDTLS330
    
        ^INCDTLS331 = INCDTLS331
    
        ^INCDTLS333 = INCDTLS333
        */
        public static ProcessMessageDocument VR_ATO_IITR_300087(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            List<INCDTLS2026.Rp_Income> incomeTuples = new List<INCDTLS2026.Rp_Income>();

            if (Count(report.incdtlsChildDocuments) != 0 && report.incdtlsChildDocuments[0].Rp_IncomeCollection != null)
            {
                incomeTuples = report.incdtlsChildDocuments[0].Rp_IncomeCollection;
            }

            bool incdtlsChildCountisOne = (report.incdtlsChildDocuments != null && report.incdtlsChildDocuments.Count == 1);

            // Condition 1: (^IITR302 > 0)
            bool iitr302GreaterThanZero = report.iitrParentDocument.IITR302.GetValueOrDefault() > 0;

            // Sum of ETP amounts
            decimal totalETPAmounts = incomeTuples.FindAll(tuple => IsMatch(tuple.INCDTLS138, @"^(D|B|N)$")).Sum(f => f.INCDTLS140.GetValueOrDefault());

            // Sum of SLS amounts
            decimal totalSLSAmounts = (incomeTuples.FindAll(tuple => tuple.INCDTLS333 == false).Sum(f => f.INCDTLS330.GetValueOrDefault() + f.INCDTLS331.GetValueOrDefault()));

            // Calculation of amounts in the sum
            decimal calculatedSum = report.iitrParentDocument.IITR157.GetValueOrDefault() - (report.iitrParentDocument.IITR242.GetValueOrDefault() + report.iitrParentDocument.IITR243.GetValueOrDefault() - report.iitrParentDocument.IITR245.GetValueOrDefault() - report.iitrParentDocument.IITR246.GetValueOrDefault() + report.iitrParentDocument.IITR281.GetValueOrDefault() + report.iitrParentDocument.IITR299.GetValueOrDefault() + report.iitrParentDocument.IITR306.GetValueOrDefault()) - (totalETPAmounts) - (totalSLSAmounts) - report.iitrParentDocument.IITR311.GetValueOrDefault() + report.iitrParentDocument.IITR154.GetValueOrDefault() + report.iitrParentDocument.IITR156.GetValueOrDefault();

            // Condition 2: Calculated Sum > 100000
            bool calculatedSumExceedsThreshold = calculatedSum > 100000;

            assertion = (iitr302GreaterThanZero && calculatedSumExceedsThreshold);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.300087",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Taxpayer is ineligible to make deposits and claim deductions for deductible deposits",
                    LongDescription = @"Taxpayer is ineligible to make deposits and claim deductions for deductible deposits because taxpayer's non-primary production income exceeded the threshold amount",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.FarmManagementDeposits.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.300087" },
                        new ProcessMessageParameter() { Name = "IITR302", Value = report.iitrParentDocument.IITR302.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR157", Value = report.iitrParentDocument.IITR157.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR154", Value = report.iitrParentDocument.IITR154.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR156", Value = report.iitrParentDocument.IITR156.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR311", Value = report.iitrParentDocument.IITR311.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR242", Value = report.iitrParentDocument.IITR242.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR243", Value = report.iitrParentDocument.IITR243.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR245", Value = report.iitrParentDocument.IITR245.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR246", Value = report.iitrParentDocument.IITR246.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR281", Value = report.iitrParentDocument.IITR281.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR299", Value = report.iitrParentDocument.IITR299.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR306", Value = report.iitrParentDocument.IITR306.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Calculated SLS Amount", Value = totalSLSAmounts.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated ETP Amount", Value = totalETPAmounts.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated Total", Value = calculatedSum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.600097

        /* VR.ATO.IITR.600097
        When a Working holiday maker net income amount above zero is provided, at least one of the following income amounts must be provided: a salary and wage associated with working holiday maker income; Share of net income from trusts less capital gains, foreign income and franked distributions; Net non-Primary Production income/loss; or Net small business income

        Legacy Rule Format:
            (^IITR499 > 0 AND (CountDocument('INCDTLS') = 0 OR AllOccurrences(^INCDTLS310, InSet(^INCDTLS310, 'NULL,FALSE'))) AND ^IITR255 = NULL AND ^IITR285 = NULL AND ^IITR557 = NULL)

        Technical Business Rule Format:
            (^IITR499 > 0 AND (CountDocument('INCDTLS') = 0 OR AllOccurrences(^INCDTLS310, InSet(^INCDTLS310, 'NULL,FALSE'))) AND ^IITR255 = NULL AND ^IITR285 = NULL AND ^IITR557 = NULL)

        Data Elements:
    
        ^IITR499 = RP.WHM:Income.Net.Amount
    
        ^IITR255 = RP:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount
    
        ^IITR285 = RP:Income.NonPrimaryProductionNet.Amount
    
        ^IITR557 = RP:Income.SmallBusinessEntityNet.Amount
    
        ^INCDTLS310 = INCDTLS310
        */
        public static ProcessMessageDocument VR_ATO_IITR_600097(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool allOccurrences310FalseOrNull = false;
            bool incomeAmountsProvided = false;
            bool assertion = false;

            // Check if Net income is greater than 0 and continue
            if (report.iitrParentDocument.IITR499 > 0)
            {
                incomeAmountsProvided = report.iitrParentDocument.IITR255 == null && report.iitrParentDocument.IITR285 == null && report.iitrParentDocument.IITR557 == null;

                // if there are no Income schedule, throw the CMN.ATO.IITR.600097 error
                if (incdtlschilddoc == null || incdtlschilddoc.Rp_IncomeCollection == null)
                    assertion = incomeAmountsProvided;
                else
                {
                    // check if all occurrences of INCDTLS310 are null or false - set the condition to true
                    allOccurrences310FalseOrNull = incdtlschilddoc.Rp_IncomeCollection.All(tuple => tuple.INCDTLS310 == null || tuple.INCDTLS310 == false);
                    // ALL OCCURRENCES OF([incdtls310]) = SET(NULL,FALSE)) AND [iitr255] = NULL [iitr285] = NULL AND [iitr557] = NULL
                    assertion = ((allOccurrences310FalseOrNull && incomeAmountsProvided));
                }

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.600097",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Working holiday maker income amount details are incomplete",
                        LongDescription = @"When a Working holiday maker net income amount above zero is provided, at least one of the following income amounts must be provided; a salary and wage associated with working holiday maker income; Share of net income from trusts less capital gains, foreign income and franked distributions; Net non-Primary Production income/loss; or Net small business income",
                        Location = "/xbrli:xbrl/tns:Income.Net.Amount",
                        Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.600097" },
                        new ProcessMessageParameter() { Name = "IITR499", Value = report.iitrParentDocument.IITR499.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR255", Value = report.iitrParentDocument.IITR255.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR285", Value = report.iitrParentDocument.IITR285.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR557", Value = report.iitrParentDocument.IITR557.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ALL OCCURRENCES OF([incdtls310]) = SET(NULL,FALSE))", Value = "true" }
                    }
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.600097

        #region VR.ATO.IITR.730050

        /* VR.ATO.IITR.730050
        Where any Superannuation income stream tax withheld or Annuity tax withheld amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income stream tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR91 = NULL AND CountDocument('INCDTLS') = 1 AND ((AnyOccurrence(^INCDTLS112, ^INCDTLS112 <> NULL)) OR (AnyOccurrence(^INCDTLS146, ^INCDTLS146 <> NULL)))

        Technical Business Rule Format:
            ^IITR91 = NULL AND CountDocument('INCDTLS') = 1 AND ((AnyOccurrence(^INCDTLS112, ^INCDTLS112 <> NULL)) OR (AnyOccurrence(^INCDTLS146, ^INCDTLS146 <> NULL)))

        Data Elements:
    
        ^IITR91 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount
    
        ^INCDTLS112 = INCDTLS112
    
        ^INCDTLS146 = INCDTLS146
        */
        public static ProcessMessageDocument VR_ATO_IITR_730050(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            bool anyINCDTLS112NotNull = false;
            bool anyINCDTLS146NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS112 or INCDTLS146 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
            {
                anyINCDTLS112NotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS112 != null);
                anyINCDTLS146NotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS146 != null);
            }

            assertion = report.iitrParentDocument.IITR91 == null && (anyINCDTLS112NotNull || anyINCDTLS146NotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730050",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income stream tax withheld amount must be provided",
                    LongDescription = @"Where any Superannuation income stream tax withheld or Annuity tax withheld amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income stream tax withheld amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730050" },
                        new ProcessMessageParameter() { Name = "IITR91", Value = report.iitrParentDocument.IITR91.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS112", Value = anyINCDTLS112NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS112", Value = anyINCDTLS146NotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730050

        #region VR.ATO.IITR.730051

        /* VR.ATO.IITR.730051
        The Australian annuities and superannuation income stream tax withheld amount must equal the sum of all Superannuation income stream tax withheld and Annuity tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR91 <> NULL AND ^IITR91 <> (Sum(^INCDTLS112) + RoundDown(Sum(^INCDTLS146),0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR91 <> NULL AND ^IITR91 <> (Sum(^INCDTLS112) + RoundDown(Sum(^INCDTLS146),0))

        Data Elements:
    
        ^IITR91 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount
    
        ^INCDTLS112 = INCDTLS112
    
        ^INCDTLS146 = INCDTLS146
        */
        public static ProcessMessageDocument VR_ATO_IITR_730051(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumINCDTLS112 = 0;
            decimal sumINCDTLS146 = 0;
            decimal totalSum = 0;

            if (!report.iitrParentDocument.IITR91.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumINCDTLS112 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS112.GetValueOrDefault());
                sumINCDTLS146 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS146.GetValueOrDefault());
            }

            // [iitr91] <> (SUM([incdtls112]) + RoundDown(SUM([incdtls146]),0))
            totalSum = sumINCDTLS112 + Math.Truncate(sumINCDTLS146);

            // Condition 3: [iitr91] <> (SUM([incdtls112]) + RoundDown(SUM([incdtls146]),0))
            assertion = report.iitrParentDocument.IITR91.GetValueOrDefault() != totalSum;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730051",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income stream tax withheld amount is incorrect",
                    LongDescription = @"The Australian annuities and superannuation income stream tax withheld amount must equal the sum of all Superannuation income stream tax withheld and Annuity tax withheld amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount",
                    Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730051" },
                            new ProcessMessageParameter() { Name = "IITR91", Value = report.iitrParentDocument.IITR91.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS112", Value = sumINCDTLS112.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS146", Value = sumINCDTLS146.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sum of INCDTLS112 and INCDTLS146", Value = totalSum.ToString() }
                        }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730051

        #region VR.ATO.IITR.730052

        /* VR.ATO.IITR.730052
        Where any Superannuation income stream taxable component taxed element amounts are present in the attached Income Details schedule, and there is no assessable amount from a capped defined benefit income stream, the Australian annuities and superannuation income streams Taxable component "Taxed element" amount must be provided

        Legacy Rule Format:
            ^IITR92 = NULL AND (^IITR505 = NULL) AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS113, ^INCDTLS113 <> NULL)

        Technical Business Rule Format:
            ^IITR92 = NULL AND (^IITR505 = NULL) AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS113, ^INCDTLS113 <> NULL)

        Data Elements:
    
        ^IITR92 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount
        ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount
    
        ^INCDTLS113 = INCDTLS113
        */
        public static ProcessMessageDocument VR_ATO_IITR_730052(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyINCDTLS113NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS113 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                anyINCDTLS113NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS113 != null));

            bool assertion = (report.iitrParentDocument.IITR92 == null && report.iitrParentDocument.IITR505 == null && anyINCDTLS113NotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731052",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Taxable component ""Taxed element"" amount must be provided",
                    LongDescription = @"Where any Superannuation income stream taxable component taxed element amounts are present in the attached Income Details schedule, and there is no assessable amount from a capped defined benefit income stream, the Australian annuities and superannuation income streams Taxable component ""Taxed element"" amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730052" },
                        new ProcessMessageParameter() { Name = "IITR92", Value = report.iitrParentDocument.IITR92.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR505", Value = report.iitrParentDocument.IITR505.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730052

        #region VR.ATO.IITR.730053

        /* VR.ATO.IITR.730053
        The Australian annuities and superannuation income streams Taxable component "Taxed element" amount must equal the sum of all Superannuation income stream taxable component taxed element amounts provided in the attached Income Details schedule, unless there is an assessable amount from a capped defined benefit income stream

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR92 <> NULL AND (^IITR505 = NULL) AND ^IITR92 <> Sum(^INCDTLS113)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR92 <> NULL AND (^IITR505 = NULL) AND ^IITR92 <> Sum(^INCDTLS113)

        Data Elements:
    
        ^IITR92 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount
        ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount
    
        ^INCDTLS113 = INCDTLS113
        */
        public static ProcessMessageDocument VR_ATO_IITR_730053(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumIncDet113 = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumIncDet113 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS113.GetValueOrDefault());
            bool assertion = (report.iitrParentDocument.IITR92 != null && report.iitrParentDocument.IITR505 == null && report.iitrParentDocument.IITR92.GetValueOrDefault() != sumIncDet113);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731053",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Taxable component ""Taxed element"" amount is incorrect",
                    LongDescription = @"The Australian annuities and superannuation income streams Taxable component ""Taxed element"" amount must equal the sum of all Superannuation income stream taxable component taxed element amounts provided in the attached Income Details schedule, unless there is an assessable amount from a capped defined benefit income stream",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730053" },
                        new ProcessMessageParameter() { Name = "IITR92", Value = report.iitrParentDocument.IITR92.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR505", Value = report.iitrParentDocument.IITR505.GetValueOrDefault().ToString() }
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730053

        #region VR.ATO.IITR.730054

        /* VR.ATO.IITR.730054
            Where any Superannuation income stream taxable component untaxed element or Annuity gross amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income streams Taxable component "Untaxed element" amount must be provided

        Legacy Rule Format:
            (^IITR93 = NULL AND CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS114, ^INCDTLS114 <> NULL) OR AnyOccurrence(^INCDTLS147, ^INCDTLS147 <> NULL))

        Technical Business Rule Format:
            (^IITR93 = NULL AND CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS114, ^INCDTLS114 <> NULL) OR AnyOccurrence(^INCDTLS147, ^INCDTLS147 <> NULL))

        Data Elements:
    
            ^IITR93 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS114 = INCDTLS114
    
            ^INCDTLS147 = INCDTLS147
        */

        public static ProcessMessageDocument VR_ATO_IITR_730054(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyINCDTLS114NotNull = false;
            bool anyINCDTLS147NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS114 & INCDTLS147 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
            {
                anyINCDTLS114NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS114 != null));
                anyINCDTLS147NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS147 != null));
            }

            bool assertion = (report.iitrParentDocument.IITR93 == null && (anyINCDTLS114NotNull || anyINCDTLS147NotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730054",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Taxable component ""Untaxed element"" amount must be provided",
                    LongDescription = @"Where any Superannuation income stream taxable component untaxed element or Annuity gross amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income streams Taxable component ""Untaxed element"" amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730054" },
                        new ProcessMessageParameter() { Name = "IITR93", Value = report.iitrParentDocument.IITR93.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730054

        #region VR.ATO.IITR.730055

        /* VR.ATO.IITR.730055
                    The Australian annuities and superannuation income streams Taxable component "Untaxed element" amount must equal; the sum of all Superannuation income stream lump sum in arrears taxable component untaxed element amounts, plus the sum of all Annuity gross amounts, less the sum of all Annuity deductible amounts of undeducted purchase price provided in the attached Income Details schedule

                Legacy Rule Format:
                    (CountDocument('INCDTLS') = 1) AND ^IITR93 <> NULL AND ^IITR93 <> (Sum(^INCDTLS114) + (Sum(^INCDTLS147) - Sum(^INCDTLS148)))

            Technical Business Rule Format:
                    (CountDocument('INCDTLS') = 1) AND ^IITR93 <> NULL AND ^IITR93 <> (Sum(^INCDTLS114) + (Sum(^INCDTLS147) - Sum(^INCDTLS148)))

        Data Elements:
    
            ^IITR93 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS114 = INCDTLS114
    
            ^INCDTLS147 = INCDTLS147
    
            ^INCDTLS148 = INCDTLS148
            */
        public static ProcessMessageDocument VR_ATO_IITR_730055(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumIncDetValues = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumIncDetValues = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS114.GetValueOrDefault()) + incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS147.GetValueOrDefault()) - incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS148.GetValueOrDefault());

            bool assertion = (report.iitrParentDocument.IITR93 != null && report.iitrParentDocument.IITR93.GetValueOrDefault() != sumIncDetValues);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730055",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Taxable component ""Untaxed element"" amount is incorrect",
                    LongDescription = @"The Australian annuities and superannuation income streams Taxable component ""Untaxed element"" amount must equal; the sum of all Superannuation income stream lump sum in arrears taxable component untaxed element amounts, plus the sum of all Annuity gross amounts, less the sum of all Annuity deductible amounts of undeducted purchase price provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730055" },
                        new ProcessMessageParameter() { Name = "IITR93", Value = report.iitrParentDocument.IITR93.GetValueOrDefault().ToString() }
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730055

        #region VR.ATO.IITR.730056

        /* VR.ATO.IITR.730056
                    When the taxpayer is over the age of 60 on the 30th of June for the Year of return and any Australian superannuation income stream payment summary instances are present in the attached Income Details schedule, the answer to the question "Are you under 60 years of age and a death benefits dependant, where the deceased died at 60 years or over?" must not be 'yes' (true)

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS109, ^INCDTLS109 = TRUE) AND ^IITR29 <= ConvertToDate(30,6, ^IITR10 - 61)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS109, ^INCDTLS109 = TRUE) AND ^IITR29 <= ConvertToDate(30,6, ^IITR10 - 61)

        Data Elements:
    
            ^INCDTLS109 = INCDTLS109
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
            */
        public static ProcessMessageDocument VR_ATO_IITR_730056(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;


            bool assertion = (report.iitrParentDocument.IITR29.GetValueOrDefault() <= ConvertToDate(30, 6, report.iitrParentDocument.IITR10.GetValueOrDefault() - 61) && (incdtlschilddoc.Rp_IncomeCollection != null && incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS109.GetValueOrDefault())));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730056",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Answer to ""Are you under 60 years of age and a death benefits dependant, where the deceased died at 60 years or over?"" is incorrect",
                    LongDescription = @"When the taxpayer is over the age of 60 on the 30th of June for the Year of return and any Australian superannuation income stream payment summary instances are present in the attached Income Details schedule, the answer to the question ""Are you under 60 years of age and a death benefits dependant, where the deceased died at 60 years or over?"" must not be 'yes' (true)",
                    Location = "/tns:INCDTLS/tns:Rp/tns:IncomeCollection/tns:Income/tns:OrganisationNameDetails/tns:AnnuitiesAndSuperannuationCollection/tns:AnnuitiesAndSuperannuation/tns:ReversionaryIncomeStreamI",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730056" },
                        new ProcessMessageParameter() { Name = "IITR10", Value = report.iitrParentDocument.IITR10.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS109", Value = "true" }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730056

        #region VR.ATO.IITR.730057

        /* VR.ATO.IITR.730057
                    When the taxpayer is under the age of 60 on the 30th of June for the Year of return and the answer to the question "Are you under 60 years of age and a death benefits dependant, where the deceased died at 60 years or over?" is 'no' (false) for all Australian superannuation income stream payment summary instances in the attached Income Details schedule, a positive Assessable amount from capped defined benefit income stream amount must not be provided

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR505 > 0 AND ^IITR29 > ConvertToDate(30,6, ^IITR10 - 60) AND AllOccurrences(^INCDTLS109, ^INCDTLS109 = FALSE)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR505 > 0 AND ^IITR29 > ConvertToDate(30,6, ^IITR10 - 60) AND AllOccurrences(^INCDTLS109, ^INCDTLS109 = FALSE)

        Data Elements:
    
            ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
    
            ^INCDTLS109 = INCDTLS109
            */
        public static ProcessMessageDocument VR_ATO_IITR_730057(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: [iitr505] > 0
            bool condition1_IITR505GreaterThan0 = report.iitrParentDocument.IITR505.GetValueOrDefault() > 0;

            // Condition 2: [iitr29] > ConvertToDate(30,6, [iitr10] - 60)
            bool condition2_Under60YearsOld = report.iitrParentDocument.IITR29.GetValueOrDefault() > ConvertToDate(30, 6, report.iitrParentDocument.IITR10.GetValueOrDefault() - 60);

            // Condition 3: ALL OCCURRENCES OF([incdtls109]) = FALSE
            bool condition3_AllINCDTLS109IsFalse = (incdtlschilddoc.Rp_IncomeCollection != null && incdtlschilddoc.Rp_IncomeCollection.All(tuple => tuple.INCDTLS109 == false));

            bool assertion = (condition1_IITR505GreaterThan0 && condition2_Under60YearsOld && condition3_AllINCDTLS109IsFalse);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730057",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable amount from capped defined benefit income stream amount is incorrect",
                    LongDescription = "When the taxpayer is under the age of 60 on the 30th of June for the Year of return and the answer to the question \"Are you under 60 years of age and a death benefits dependant, where the deceased died at 60 years or over?\" is 'no' (false) for all Australian superannuation income stream payment summary instances in the attached Income Details schedule, a positive Assessable amount from capped defined benefit income stream amount must not be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730057" },
                        new ProcessMessageParameter() { Name = "IITR505", Value = report.iitrParentDocument.IITR505.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR10", Value = report.iitrParentDocument.IITR10.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS109", Value = "false" }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730057

        #region VR.ATO.IITR.730058

        /* VR.ATO.IITR.730058
                    The Australian superannuation income stream amount must be greater than or equal to the sum of all Superannuation income stream tax offset amounts in the attached Income Details schedule

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR166 <> NULL AND ^IITR166 < Sum(^INCDTLS116)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR166 <> NULL AND ^IITR166 < Sum(^INCDTLS116)

        Data Elements:
    
            ^IITR166 = RP:TaxOffsetClaim.SuperannuationIncomeStream.Amount
    
            ^INCDTLS116 = INCDTLS116
            */
        public static ProcessMessageDocument VR_ATO_IITR_730058(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumINCDTLS116 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumINCDTLS116 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS116.GetValueOrDefault());

            bool assertion = (report.iitrParentDocument.IITR166 != null && report.iitrParentDocument.IITR166.GetValueOrDefault() < sumINCDTLS116);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730058",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian superannuation income stream amount is incorrect",
                    LongDescription = @"The Australian superannuation income stream amount must be greater than or equal to the sum of all Superannuation income stream tax offset amounts in the attached Income Details schedule",
                    Location = "tns:TaxOffsetClaim.SuperannuationIncomeStream.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730058" },
                        new ProcessMessageParameter() { Name = "IITR166", Value = report.iitrParentDocument.IITR166.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum of INCDTLS116", Value = sumINCDTLS116.ToString() },
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730058

        #region VR.ATO.IITR.730059

        /* VR.ATO.IITR.730059
                    Where any Superannuation income stream tax offset amounts are present in the attached Income Details schedule, the Australian superannuation income stream amount must be provided

                Legacy Rule Format:
                    ^IITR166 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS116, ^INCDTLS116 <> NULL)

            Technical Business Rule Format:
                    ^IITR166 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS116, ^INCDTLS116 <> NULL)

        Data Elements:
    
            ^IITR166 = RP:TaxOffsetClaim.SuperannuationIncomeStream.Amount
    
            ^INCDTLS116 = INCDTLS116
            */
        public static ProcessMessageDocument VR_ATO_IITR_730059(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyINCDTLS116NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS116 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                anyINCDTLS116NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS116 != null));

            bool assertion = (report.iitrParentDocument.IITR166 == null && anyINCDTLS116NotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730059",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian superannuation income stream amount must be provided",
                    LongDescription = @"Where any Superannuation income stream tax offset amounts are present in the attached Income Details schedule, the Australian superannuation income stream amount must be provided",
                    Location = "/xbrli:xbrl/tns:TaxOffsetClaim.SuperannuationIncomeStream.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730059" },
                        new ProcessMessageParameter() { Name = "IITR166", Value = report.iitrParentDocument.IITR166.GetValueOrDefault().ToString() },
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730059

        #region VR.ATO.IITR.730060

        /* VR.ATO.IITR.730060
        Where any Superannuation income stream lump sum in arrears taxable component taxed element amounts are present in the attached Income Details schedule, and there is no assessable amount from a capped defined benefit income stream, the Australian annuities and superannuation income streams Lump sum in arrears "Taxed element" amount must be provided

        Legacy Rule Format:
            ^IITR94 = NULL AND (^IITR505 = NULL) AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS117, ^INCDTLS117 <> NULL)

        Technical Business Rule Format:
            ^IITR94 = NULL AND (^IITR505 = NULL) AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS117, ^INCDTLS117 <> NULL)

        Data Elements:
    
            ^IITR94 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount
            ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount
    
            ^INCDTLS117 = INCDTLS117
            */
        public static ProcessMessageDocument VR_ATO_IITR_730060(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyINCDTLS117NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS117 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                anyINCDTLS117NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS117 != null));

            bool assertion = (report.iitrParentDocument.IITR94 == null && report.iitrParentDocument.IITR505 == null && anyINCDTLS117NotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731060",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Lump sum in arrears ""Taxed element"" amount must be provided",
                    LongDescription = @"Where any Superannuation income stream lump sum in arrears taxable component taxed element amounts are present in the attached Income Details schedule, and there is no assessable amount from a capped defined benefit income stream, the Australian annuities and superannuation income streams Lump sum in arrears ""Taxed element"" amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730060" },
                        new ProcessMessageParameter() { Name = "IITR94", Value = report.iitrParentDocument.IITR94.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730060

        #region VR.ATO.IITR.730061

        /* VR.ATO.IITR.730061
        The Australian annuities and superannuation income streams Lump sum in arrears "Taxed element" amount must equal the sum of all Superannuation income stream lump sum in arrears taxable component taxed element amounts provided in the attached Income Details schedule, unless there is an assessable amount from a capped defined benefit income stream

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR94 <> NULL AND (^IITR505 = NULL) AND ^IITR94 <> Sum(^INCDTLS117)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR94 <> NULL AND (^IITR505 = NULL) AND ^IITR94 <> Sum(^INCDTLS117)
       
        Data Elements:
    
            ^IITR94 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount
            ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount
    
            ^INCDTLS117 = INCDTLS117
            */
        public static ProcessMessageDocument VR_ATO_IITR_730061(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumIncDet117 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumIncDet117 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS117.GetValueOrDefault());
            bool assertion = (report.iitrParentDocument.IITR94 != null && report.iitrParentDocument.IITR505 == null && report.iitrParentDocument.IITR94.GetValueOrDefault() != sumIncDet117);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731061",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Lump sum in arrears ""Taxed element"" amount is incorrect",
                    LongDescription = @"The Australian annuities and superannuation income streams Lump sum in arrears ""Taxed element"" amount must equal the sum of all Superannuation income stream lump sum in arrears taxable component taxed element amounts provided in the attached Income Details schedule, unless there is an assessable amount from a capped defined benefit income stream",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730061" },
                        new ProcessMessageParameter() { Name = "IITR94", Value = report.iitrParentDocument.IITR94.GetValueOrDefault().ToString() }
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730061

        #region VR.ATO.IITR.730062

        /* VR.ATO.IITR.730062
                    Where any Superannuation income stream lump sum in arrears taxable component untaxed element amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income streams Lump sum in arrears "Untaxed element" amount must be provided

                Legacy Rule Format:
                    ^IITR95 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS118, ^INCDTLS118 <> NULL)

            Technical Business Rule Format:
                    ^IITR95 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS118, ^INCDTLS118 <> NULL)

        Data Elements:
    
            ^IITR95 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS118 = INCDTLS118
            */
        public static ProcessMessageDocument VR_ATO_IITR_730062(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyINCDTLS118NotNull = false;

            // If the Income Tuple exists, check if any occurrences of INCDTLS118 are not Null.
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                anyINCDTLS118NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS118 != null));

            bool assertion = (report.iitrParentDocument.IITR95 == null && anyINCDTLS118NotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730062",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Lump sum in arrears ""Untaxed element"" amount must be provided",
                    LongDescription = @"Where any Superannuation income stream lump sum in arrears taxable component untaxed element amounts are present in the attached Income Details schedule, the Australian annuities and superannuation income streams Lump sum in arrears ""Untaxed element"" amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730062" },
                        new ProcessMessageParameter() { Name = "IITR95", Value = report.iitrParentDocument.IITR95.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730062

        #region VR.ATO.IITR.730063

        /* VR.ATO.IITR.730063
                    The Australian annuities and superannuation income streams Lump sum in arrears "Untaxed element" amount must equal the sum of all Superannuation income stream lump sum in arrears taxable component untaxed element amounts provided in the attached Income Details schedule

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR95 <> NULL AND ^IITR95 <> Sum(^INCDTLS118)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR95 <> NULL AND ^IITR95 <> Sum(^INCDTLS118)

        Data Elements:
    
            ^IITR95 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS118 = INCDTLS118
            */
        public static ProcessMessageDocument VR_ATO_IITR_730063(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumIncDet118 = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumIncDet118 = (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS118.GetValueOrDefault()));
            bool assertion = (report.iitrParentDocument.IITR95 != null && report.iitrParentDocument.IITR95.GetValueOrDefault() != sumIncDet118);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730063",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian annuities and superannuation income streams Lump sum in arrears ""Untaxed element"" amount is incorrect",
                    LongDescription = @"The Australian annuities and superannuation income streams Lump sum in arrears ""Untaxed element"" amount must equal the sum of all Superannuation income stream lump sum in arrears taxable component untaxed element amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730063" },
                        new ProcessMessageParameter() { Name = "IITR95", Value = report.iitrParentDocument.IITR95.GetValueOrDefault().ToString() }
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730063

        #region VR.ATO.IITR.730064

        /* VR.ATO.IITR.730064
                    The number of Income Details schedules must not exceed 1

                Legacy Rule Format:
                    CountDocument('INCDTLS') > 1

            Technical Business Rule Format:
                    CountDocument('INCDTLS') > 1

        Data Elements:
        */

        public static ProcessMessageDocument VR_ATO_IITR_730064(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = Count(report.incdtlsChildDocuments) > 1;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730064",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The number of Income Details schedules must not exceed 1",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730064" } },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730064

        #region VR.ATO.IITR.730065

        /* VR.ATO.IITR.730065
                    The TFN provided for the Income Details schedule must be the same as the TFN of the parent form

                Legacy Rule Format:
                    (CountDocument('INCDTLS') = 1) AND (^INCDTLS102 <> ^RP:TFN)

            Technical Business Rule Format:
                    (CountDocument('INCDTLS') = 1) AND (^INCDTLS102 <> ^RP:TFN)

        Data Elements:
    
            ^INCDTLS102 = INCDTLS102
    
            ^TFN = TFN
            */
        public static ProcessMessageDocument VR_ATO_IITR_730065(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = incdtlschilddoc.INCDTLS102 != report.iitrParentDocument.RPIdentifierTFN;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730065",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax file number invalid",
                    LongDescription = @"The TFN provided for the Income Details schedule must be the same as the TFN of the parent form",
                    Location = $"/xbrli:xbrl/xbrli:context[@id='{report.iitrParentDocument.RPId}']/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730065" } },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730065

        #region VR.ATO.IITR.730066

        /* VR.ATO.IITR.730066
                    Period start date for the Income Details schedule must be the same as the Period start date of the parent form

                Legacy Rule Format:
                    (CountDocument('INCDTLS') = 1) AND (^INCDTLS100 <> ^RP:StartDate)

            Technical Business Rule Format:
                    (CountDocument('INCDTLS') = 1) AND (^INCDTLS100 <> ^RP:StartDate)

        Data Elements:
    
            ^INCDTLS100 = INCDTLS100
    
            ^StartDate = StartDate
            */
        public static ProcessMessageDocument VR_ATO_IITR_730066(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = incdtlschilddoc.INCDTLS100 != report.iitrParentDocument.RPStartDate;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730066",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Period start date for the Income Details schedule is invalid",
                    LongDescription = @"Period start date for the Income Details schedule must be the same as the Period start date of the parent form",
                    Location = $"/xbrli:xbrl/xbrli:context[@id='{report.iitrParentDocument.RPId}']/xbrli:period/xbrli:startDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730066" } },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730066

        #region VR.ATO.IITR.730067

        /* VR.ATO.IITR.730067
                     Period end date for the Income Details schedule must be the same as the Period end date of the parent form

                 Legacy Rule Format:
                     (CountDocument('INCDTLS') = 1) AND (^INCDTLS101 <> ^RP:EndDate)

             Technical Business Rule Format:
                     (CountDocument('INCDTLS') = 1) AND (^INCDTLS101 <> ^RP:EndDate)

         Data Elements:

             ^EndDate = EndDate

             ^INCDTLS101 = INCDTLS101
             */
        public static ProcessMessageDocument VR_ATO_IITR_730067(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = incdtlschilddoc.INCDTLS101 != report.iitrParentDocument.RPEndDate;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730067",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Period end date for the Income Details schedule is invalid",
                    LongDescription = @"Period end date for the Income Details schedule must be the same as the Period end date of the parent form",
                    Location = $"/xbrli:xbrl/xbrli:context[@id='{report.iitrParentDocument.RPId}']/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730067" } },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730067

        #region VR.ATO.IITR.730068

        /* VR.ATO.IITR.730068
                    When "Allowance" (Australian government Newstart, Youth Allowance or Austudy payment) is selected for an Australian government benefit type with a corresponding tax withheld amount, both on the attached Income Details schedule, Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment amount must be provided

                Legacy Rule Format:
                    ^IITR85 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS129, ^INCDTLS129 <> NULL) WHERE ^INCDTLS126 = 'Allowance')

            Technical Business Rule Format:
                    ^IITR85 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS129, ^INCDTLS129 <> NULL) WHERE ^INCDTLS126 = 'Allowance')

        Data Elements:
    
            ^IITR85 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentAllowancesAndPayments.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS129 = INCDTLS129
            */
        public static ProcessMessageDocument VR_ATO_IITR_730068(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            List<GovernmentBenefit> governmentBenefitTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);

            bool assertion = (report.iitrParentDocument.IITR85 == null && (governmentBenefitTuples.Any(tuple => tuple.INCDTLS129 != null && tuple.INCDTLS126 == "Allowance")));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730068",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment must be provided",
                    LongDescription = @"When ""Allowance"" (Australian government Newstart, Youth Allowance or Austudy payment) is selected for an Australian government benefit type with a corresponding tax withheld amount, both on the attached Income Details schedule, Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentAllowancesAndPayments.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730068" },
                        new ProcessMessageParameter() { Name = "IITR85", Value = report.iitrParentDocument.IITR85.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730068

        #region VR.ATO.IITR.730069

        /* VR.ATO.IITR.730069
                    The Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment amount must equal the sum of all Australian government benefit tax withheld amounts provided in the attached Income Details schedule, where the corresponding benefit type is "Allowance" (Australian government Newstart, Youth Allowance or Austudy payment)

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR85 <> NULL AND ^IITR85 <> Sum(ConditionalValue(^INCDTLS126 = 'Allowance', ^INCDTLS129, 0))

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR85 <> NULL AND ^IITR85 <> Sum(ConditionalValue(^INCDTLS126 = 'Allowance', ^INCDTLS129, 0))

        Data Elements:
    
            ^IITR85 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentAllowancesAndPayments.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS129 = INCDTLS129
            */
        public static ProcessMessageDocument VR_ATO_IITR_730069(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion = (report.iitrParentDocument.IITR85 != null && (report.iitrParentDocument.IITR85.GetValueOrDefault() != (Count(govTuples) > 0 ? govTuples.Where(tuple => tuple.INCDTLS126 == "Allowance").Sum(tuple => tuple.INCDTLS129.GetValueOrDefault()) : 0)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730069",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment is incorrect",
                    LongDescription = @"The Tax withheld from Australian Government allowances and payments like newstart, youth allowance and austudy payment amount must equal the sum of all Australian government benefit tax withheld amounts provided in the attached Income Details schedule, where the corresponding benefit type is ""Allowance"" (Australian government Newstart, Youth Allowance or Austudy payment)",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentAllowancesAndPayments.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730069" },
                        new ProcessMessageParameter() { Name = "IITR85", Value = report.iitrParentDocument.IITR85.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730069

        #region VR.ATO.IITR.730070

        /* VR.ATO.IITR.730070
                    When "Pension" (Australian government pension or carer payment) is selected for an Australian government benefit type with a corresponding tax withheld amount, both on the attached Income Details schedule, Tax withheld from Australian Government pensions and allowances amount must be provided

                Legacy Rule Format:
                    ^IITR88 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS129, ^INCDTLS129 <> NULL) WHERE ^INCDTLS126 = 'Pension')

            Technical Business Rule Format:
                    ^IITR88 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS129, ^INCDTLS129 <> NULL) WHERE ^INCDTLS126 = 'Pension')

        Data Elements:
    
            ^IITR88 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS129 = INCDTLS129
            */
        public static ProcessMessageDocument VR_ATO_IITR_730070(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion =
                (
                    report.iitrParentDocument.IITR88 == null &&
                    (
                        govTuples != null
                        ? govTuples.Any
                            (
                                tuple => tuple.INCDTLS129 != null &&
                                tuple.INCDTLS126 == "Pension"
                             ) : false
                    )
                );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730070",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from Australian Government pensions and allowances amount must be provided",
                    LongDescription = @"When ""Pension"" (Australian government pension or carer payment) is selected for an Australian government benefit type with a corresponding tax withheld amount, both on the attached Income Details schedule, Tax withheld from Australian Government pensions and allowances amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730070" },
                        new ProcessMessageParameter() { Name = "IITR88", Value = report.iitrParentDocument.IITR88.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730070

        #region VR.ATO.IITR.730071

        /* VR.ATO.IITR.730071
                    The Tax withheld from Australian Government pensions and allowances amount must equal the sum of all Australian government benefit tax withheld amounts provided in the attached Income Details schedule, where the corresponding benefit type is "Pension" (Australian government pension or carer payment)

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR88 <> NULL AND ^IITR88 <> Sum(ConditionalValue(^INCDTLS126 = 'Pension', ^INCDTLS129, 0))

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR88 <> NULL AND ^IITR88 <> Sum(ConditionalValue(^INCDTLS126 = 'Pension', ^INCDTLS129, 0))

        Data Elements:
    
            ^IITR88 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS129 = INCDTLS129
            */
        public static ProcessMessageDocument VR_ATO_IITR_730071(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion =
                (
                    report.iitrParentDocument.IITR88 != null &&
                    (
                        report.iitrParentDocument.IITR88.GetValueOrDefault() !=
                        (
                            Count
                            (govTuples) > 0
                            ? govTuples.Where
                            (
                                    tuple => tuple.INCDTLS126 == "Pension"
                            ).Sum
                            (
                                tuple => tuple.INCDTLS129.GetValueOrDefault()
                            ) : 0
                        )
                    )
                );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730071",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from Australian Government pensions and allowances amount is incorrect",
                    LongDescription = @"The Tax withheld from Australian Government pensions and allowances amount must equal the sum of all Australian government benefit tax withheld amounts provided in the attached Income Details schedule, where the corresponding benefit type is ""Pension"" (Australian government pension or carer payment)",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730071" },
                        new ProcessMessageParameter() { Name = "IITR88", Value = report.iitrParentDocument.IITR88.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730071

        #region VR.ATO.IITR.730072

        /* VR.ATO.IITR.730072
                    When "Pension" (Australian government pension or carer payment) is selected for an Australian government benefit type with a corresponding taxable amount present, both on the attached Income Details schedule, Amount of Australian Government pensions and allowances must be provided

                Legacy Rule Format:
                    ^IITR89 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE ^INCDTLS126 = 'Pension')

            Technical Business Rule Format:
                    ^IITR89 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE ^INCDTLS126 = 'Pension')

        Data Elements:
    
            ^IITR89 = RP:Pension.Total.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS128 = INCDTLS128
            */
        public static ProcessMessageDocument VR_ATO_IITR_730072(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion = (
                    report.iitrParentDocument.IITR89 == null &&
                    (
                        govTuples != null
                        ? govTuples.Any
                            (
                                tuple => tuple.INCDTLS128 != null &&
                                tuple.INCDTLS126 == "Pension"
                             ) : false
                    )
                );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730072",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Amount of Australian Government pensions and allowances must be provided",
                    LongDescription = @"When ""Pension"" (Australian government pension or carer payment) is selected for an Australian government benefit type with a corresponding taxable amount present, both on the attached Income Details schedule, Amount of Australian Government pensions and allowances must be provided",
                    Location = "/xbrli:xbrl/tns:Pension.Total.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730072" },
                        new ProcessMessageParameter() { Name = "IITR89", Value = report.iitrParentDocument.IITR89.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730072

        #region VR.ATO.IITR.730073

        /* VR.ATO.IITR.730073
            The Amount of Australian Government pensions and allowances must equal the sum of all Australian government benefit taxable amounts provided in the attached Income Details schedule, where the corresponding benefit type is "Pension" (Australian government pension or carer payment)

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR89 <> NULL AND ^IITR89 <> RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Pension', ^INCDTLS128, 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR89 <> NULL AND ^IITR89 <> RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Pension', ^INCDTLS128, 0)), 0)

        Data Elements:
    
            ^IITR89 = RP:Pension.Total.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS128 = INCDTLS128
        */

        public static ProcessMessageDocument VR_ATO_IITR_730073(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion = (
                    report.iitrParentDocument.IITR89 != null &&
                    (
                        report.iitrParentDocument.IITR89.GetValueOrDefault() !=
                        (
                            Count
                            (govTuples) > 0
                            ? Math.Floor
                            (
                                govTuples.Where
                                (
                                    tuple => tuple.INCDTLS126 == "Pension"
                                ).Sum
                                (
                                    tuple => tuple.INCDTLS128.GetValueOrDefault()
                                )
                            ) : 0
                        )
                    )
                );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730073",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Amount of Australian Government pensions and allowances is incorrect",
                    LongDescription = @"The Amount of Australian Government pensions and allowances must equal the sum of all Australian government benefit taxable amounts provided in the attached Income Details schedule, where the corresponding benefit type is ""Pension"" (Australian government pension or carer payment)",
                    Location = "/xbrli:xbrl/tns:Pension.Total.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730073" },
                        new ProcessMessageParameter() { Name = "IITR89", Value = report.iitrParentDocument.IITR89.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730073

        #region VR.ATO.IITR.730074

        /* VR.ATO.IITR.730074
            When "Allowance" (Australian government Newstart, Youth Allowance or Austudy payment) is selected for an Australian government benefit type with a corresponding taxable amount present, both on the attached Income Details schedule, the Australian Government allowances and payments like Newstart, youth allowance and austudy payment amount must be provided

        Legacy Rule Format:
            ^IITR86 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE ^INCDTLS126 = 'Allowance')

        Technical Business Rule Format:
                ^IITR86 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE ^INCDTLS126 = 'Allowance')

        Data Elements:
    
            ^IITR86 = RP:Income.AustralianGovernmentAllowancesAndPayments.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS128 = INCDTLS128
        */

        public static ProcessMessageDocument VR_ATO_IITR_730074(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);
            bool assertion = (
                    report.iitrParentDocument.IITR86 == null &&
                    (
                        govTuples.Any
                            (
                                tuple => tuple.INCDTLS128 != null && tuple.INCDTLS126 == "Allowance"
                            )
                    )
                );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730074",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian Government allowances and payments like Newstart, youth allowance and austudy payment must be provided",
                    LongDescription = @"When ""Allowance"" (Australian government Newstart, Youth Allowance or Austudy payment) is selected for an Australian government benefit type with a corresponding taxable amount present, both on the attached Income Details schedule, the Australian Government allowances and payments like Newstart, youth allowance and austudy payment amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.AustralianGovernmentAllowancesAndPayments.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730074" },
                        new ProcessMessageParameter() { Name = "IITR86", Value = "null" }
                    },
                };

            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730074

        #region VR.ATO.IITR.730076

        /* VR.ATO.IITR.730076
            The Australian Government allowances and payments like Newstart, youth allowance and austudy payment amount must equal the (total) Community Development Employment Project (CDEP) amount plus the sum of all Australian government benefit taxable amounts provided in the attached Income Details schedule, where the corresponding benefit type is "Allowance" (Australian government Newstart, Youth Allowance or Austudy payment)

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR86 <> NULL AND ^IITR86 <> (RoundDown(^IITR602, 0) + RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Allowance', ^INCDTLS128, 0)),0))

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND ^IITR86 <> NULL AND ^IITR86 <> (RoundDown(^IITR602, 0) + RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Allowance', ^INCDTLS128, 0)),0))

         Data Elements:

             ^IITR86 = RP:Income.AustralianGovernmentAllowancesAndPayments.Amount

             ^IITR602 = RP:Income.CommunityDevelopmentEmploymentProject.Amount

             ^INCDTLS126 = INCDTLS126

             ^INCDTLS128 = INCDTLS128
        */

        public static ProcessMessageDocument VR_ATO_IITR_730076(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // RoundDown([iitr602], 0)
            decimal sumOfINCDTLS602 = Math.Truncate(report.iitrParentDocument.IITR602.GetValueOrDefault());

            // RoundDown(SUM(ConditionalValue([incdtls126] = "Allowance", [incdtls128], 0)),0)
            decimal sumOfINCDTLS128 = 0;

            // Gets a list of all GovernmentBenefit tuple that exist in the incdtlschilddoc
            List<GovernmentBenefit> govTuples = GetAllGovernmentBenefitTuples(incdtlschilddoc);

            // Checks to see whether GovernmentBenefit tuples exists, if so then sum the 
            sumOfINCDTLS128 = Math.Truncate(Count(govTuples) > 0 ? govTuples.Sum(tuple => tuple.INCDTLS126 == "Allowance" ? tuple.INCDTLS128.GetValueOrDefault() : 0) : 0);

            // (RoundDown([iitr602], 0) + RoundDown(SUM(ConditionalValue([incdtls126] = "Allowance", [incdtls128], 0)), 0))
            decimal sumOfINCDTLS602AndINCDTLS128 = sumOfINCDTLS602 + sumOfINCDTLS128;

            bool assertion = report.iitrParentDocument.IITR86 != null && report.iitrParentDocument.IITR86.GetValueOrDefault() != sumOfINCDTLS602AndINCDTLS128;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730076",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian Government allowances and payments like Newstart, youth allowance and austudy payment is incorrect",
                    LongDescription = @"The Australian Government allowances and payments like Newstart, youth allowance and austudy payment amount must equal the (total) Community Development Employment Project (CDEP) amount plus the sum of all Australian government benefit taxable amounts provided in the attached Income Details schedule, where the corresponding benefit type is ""Allowance"" (Australian government Newstart, Youth Allowance or Austudy payment)",
                    Location = "/xbrli:xbrl/tns:Income.AustralianGovernmentAllowancesAndPayments.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730076" },
                        new ProcessMessageParameter() { Name = "IITR86", Value = report.iitrParentDocument.IITR86.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown([iitr602], 0)", Value = sumOfINCDTLS602.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue([incdtls126] = \"Allowance\", [incdtls128], 0)), 0)", Value = sumOfINCDTLS128.ToString() },
                        new ProcessMessageParameter() { Name = "(RoundDown([iitr602], 0) + RoundDown(SUM(ConditionalValue([incdtls126] = \"Allowance\", [incdtls128], 0)), 0))", Value = sumOfINCDTLS602AndINCDTLS128.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730076

        #region VR.ATO.IITR.730077

        /* VR.ATO.IITR.730077
            Where any ETP tax withheld amounts are present in the attached Income Details schedule, the Employment termination payment tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR625 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS139, ^INCDTLS139 <> NULL)

        Technical Business Rule Format:
            ^IITR625 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS139, ^INCDTLS139 <> NULL)

        Data Elements:
    
            ^IITR625 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount
    
            ^INCDTLS139 = INCDTLS139
        */

        public static ProcessMessageDocument VR_ATO_IITR_730077(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS139NotNull = false;

            if (report.iitrParentDocument.IITR625 == null)
            {
                // If the Income Tuple exists, check if any occurrences of INCDTLS139 contain a value.
                if (incdtlschilddoc.Rp_IncomeCollection != null)
                    anyINCDTLS139NotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS139 != null);
            }

            // Only check if INCDTLS139 is not null as it can only be true if INCDTLS625 is null.
            bool assertion = (anyINCDTLS139NotNull);

            if (!assertion)
                return null;

            return new ProcessMessageDocument()
            {
                Code = "CMN.ATO.IITR.730077",
                Severity = ProcessMessageSeverity.Error,
                Description = @"Employment termination payment tax withheld amount must be provided",
                LongDescription = @"Where any ETP tax withheld amounts are present in the attached Income Details schedule, the Employment termination payment tax withheld amount must be provided",
                Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount",
                Parameters = new ProcessMessageParameters()
                {
                    new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730077" },
                    new ProcessMessageParameter() { Name = "IITR625", Value = report.iitrParentDocument.IITR625.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "AnyOccurrence(^INCDTLS139, ^INCDTLS139 <> NULL)", Value = anyINCDTLS139NotNull.ToString() },
                }
            };
        }

        #endregion // VR.ATO.IITR.730077

        #region VR.ATO.IITR.730078

        /* VR.ATO.IITR.730078
            The Employment termination payment tax withheld amount must equal the sum of all ETP tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR625 <> NULL AND ^IITR625 <> Sum(^INCDTLS139)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR625 <> NULL AND ^IITR625 <> Sum(^INCDTLS139)

        Data Elements:
    
            ^IITR625 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount
    
            ^INCDTLS139 = INCDTLS139
        */

        public static ProcessMessageDocument VR_ATO_IITR_730078(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumETP139 = 0;

            if (report.iitrParentDocument.IITR625 != null && incdtlschilddoc.Rp_IncomeCollection != null)
                sumETP139 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS139.GetValueOrDefault());

            bool assertion = (report.iitrParentDocument.IITR625 != null && report.iitrParentDocument.IITR625 != sumETP139);

            if (assertion)
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730078",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Employment termination payment tax withheld amount is incorrect",
                    LongDescription = @"The Employment termination payment tax withheld amount must equal the sum of all ETP tax withheld amounts provided in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730078" },
                            new ProcessMessageParameter() { Name = "IITR625", Value = report.iitrParentDocument.IITR625.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum(^INCDTLS139)", Value = sumETP139.ToString() },
                        }
                };

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730078

        #region VR.ATO.IITR.730079

        /* VR.ATO.IITR.730079
            Where any ETP taxable component amounts are present in the attached Income Details schedule, the Employment termination payment taxable component amount must be provided

        Legacy Rule Format:
            ^IITR626 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS140, ^INCDTLS140 <> NULL)

        Technical Business Rule Format:
            ^IITR626 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS140, ^INCDTLS140 <> NULL)

        Data Elements:
    
            ^IITR626 = RP:Income.EmploymentTerminationPaymentTaxable.Amount
    
            ^INCDTLS140 = INCDTLS140
        */

        public static ProcessMessageDocument VR_ATO_IITR_730079(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS140NotNull = false;

            if (report.iitrParentDocument.IITR626 == null)
            {
                // If the Income Tuple exists, check if any occurrences of INCDTLS140 contain a value.
                if (incdtlschilddoc.Rp_IncomeCollection != null)
                    anyINCDTLS140NotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS140 != null);
            }

            // Only check if INCDTLS140 is not null as it can only be true if INCDTLS626 is null.
            bool assertion = (anyINCDTLS140NotNull);

            if (!assertion)
                return null;

            return new ProcessMessageDocument()
            {
                Code = "CMN.ATO.IITR.730079",
                Severity = ProcessMessageSeverity.Error,
                Description = @"Employment termination payment taxable component must be provided",
                LongDescription = @"Where any ETP taxable component amounts are present in the attached Income Details schedule, the Employment termination payment taxable component amount must be provided",
                Location = "/xbrli:xbrl/tns:Income.EmploymentTerminationPaymentTaxable.Amount",
                Parameters = new ProcessMessageParameters()
                {
                    new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730079" },
                    new ProcessMessageParameter() { Name = "IITR626", Value = report.iitrParentDocument.IITR626.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "AnyOccurrence(^INCDTLS140, ^INCDTLS140 <> NULL)", Value = anyINCDTLS140NotNull.ToString() },
                }
            };
        }

        #endregion // VR.ATO.IITR.730079

        #region VR.ATO.IITR.730080

        /* VR.ATO.IITR.730080
            The Employment termination payment taxable component amount must equal the sum of all ETP taxable component amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR626 <> NULL AND ^IITR626 <> Sum(^INCDTLS140)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR626 <> NULL AND ^IITR626 <> Sum(^INCDTLS140)

        Data Elements:
    
            ^IITR626 = RP:Income.EmploymentTerminationPaymentTaxable.Amount
    
            ^INCDTLS140 = INCDTLS140
        */

        public static ProcessMessageDocument VR_ATO_IITR_730080(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumINCDTLS140 = 0;

            if (report.iitrParentDocument.IITR626 != null && incdtlschilddoc.Rp_IncomeCollection != null)
                sumINCDTLS140 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS140.GetValueOrDefault());

            bool assertion = (report.iitrParentDocument.IITR626 != null && report.iitrParentDocument.IITR626 != sumINCDTLS140);

            if (assertion)
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730080",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Employment termination payment taxable component is incorrect",
                    LongDescription = @"The Employment termination payment taxable component amount must equal the sum of all ETP taxable component amounts provided in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:Income.EmploymentTerminationPaymentTaxable.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730080" },
                            new ProcessMessageParameter() { Name = "IITR626", Value = report.iitrParentDocument.IITR626.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum(^INCDTLS140)", Value = sumINCDTLS140.ToString() },
                        }
                };
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730080

        #region VR.ATO.IITR.730081

        /* VR.ATO.IITR.730081
            Any Lump sum in arrears year provided on the attached Income Details schedule must not be more than 30 years prior to the Year of return on the parent form

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS153, ^INCDTLS153 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS523, ^INCDTLS523 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS526, ^INCDTLS526 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS529, ^INCDTLS529 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS532, ^INCDTLS532 < (^IITR10 - 30)))

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS153, ^INCDTLS153 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS523, ^INCDTLS523 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS526, ^INCDTLS526 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS529, ^INCDTLS529 < (^IITR10 - 30)) OR AnyOccurrence(^INCDTLS532, ^INCDTLS532 < (^IITR10 - 30)))

        Data Elements:
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^INCDTLS153 = INCDTLS153
    
            ^INCDTLS523 = INCDTLS523
    
            ^INCDTLS526 = INCDTLS526
    
            ^INCDTLS529 = INCDTLS529
    
            ^INCDTLS532 = INCDTLS532
        */

        public static ProcessMessageDocument VR_ATO_IITR_730081(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            int iitr10Minus30 = report.iitrParentDocument.IITR10.GetValueOrDefault() - 30;
            bool condition1AnyINCDTLS153LessThanIITR10Minus30 = false;
            bool condition2AnyINCDTLS523LessThanIITR10Minus30 = false;
            bool condition3AnyINCDTLS526LessThanIITR10Minus30 = false;
            bool condition4AnyINCDTLS529LessThanIITR10Minus30 = false;
            bool condition5AnyINCDTLS532LessThanIITR10Minus30 = false;

            ProcessMessageDocument processMessage = null;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                // Condition 1: ANY OCCURRENCE OF([incdtls153]) < ([iitr10] - 30)
                condition1AnyINCDTLS153LessThanIITR10Minus30 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollection.Any(lumpSumTuple => lumpSumTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollection != null && lumpSumTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS153 != null && tuple.INCDTLS153 < iitr10Minus30)));

                // Condition 2: ANY OCCURRENCE OF([incdtls523]) < ([iitr10] - 30)
                condition2AnyINCDTLS523LessThanIITR10Minus30 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS523 != null && tuple.INCDTLS523 < iitr10Minus30));

                // Condition 3: ANY OCCURRENCE OF([incdtls526]) < ([iitr10] - 30)
                condition3AnyINCDTLS526LessThanIITR10Minus30 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS526 != null && tuple.INCDTLS526 < iitr10Minus30));
            }

            // Condition 4: ANY OCCURRENCE OF([incdtls529]) < ([iitr10] - 30)
            if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
            {
                condition4AnyINCDTLS529LessThanIITR10Minus30 = incdtlschilddoc.Rp_ForeignIncomeCollection.Any(foreignIncome => foreignIncome.Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollection != null && foreignIncome.Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollection.Any(paymentTuple => paymentTuple.INCDTLS529 != null && paymentTuple.INCDTLS529 < iitr10Minus30));
            }

            // Condition 5: ANY OCCURRENCE OF([incdtls532]) < ([iitr10] - 30)
            if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
            {
                condition5AnyINCDTLS532LessThanIITR10Minus30 = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Any(foreignPA => foreignPA.Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollection != null && foreignPA.Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollection.Any(paymentTuple => paymentTuple.INCDTLS532 != null && paymentTuple.INCDTLS532 < iitr10Minus30));
            }

            bool assertion = condition1AnyINCDTLS153LessThanIITR10Minus30 || condition2AnyINCDTLS523LessThanIITR10Minus30 || condition3AnyINCDTLS526LessThanIITR10Minus30 || condition4AnyINCDTLS529LessThanIITR10Minus30 || condition5AnyINCDTLS532LessThanIITR10Minus30;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730081",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Lump sum in arrears year is invalid",
                    LongDescription = @"Any Lump sum in arrears year provided on the attached Income Details schedule must not be more than 30 years prior to the Year of return on the parent form",
                    Location = $"/xbrli:xbrl/tns:Report.TargetFinancial.Year[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730081" },
                        new ProcessMessageParameter() { Name = "IITR10", Value = report.iitrParentDocument.IITR10.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls153]) < ([iitr10] - 30)", Value = condition1AnyINCDTLS153LessThanIITR10Minus30.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls523]) < ([iitr10] - 30)", Value = condition2AnyINCDTLS523LessThanIITR10Minus30.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls526]) < ([iitr10] - 30)", Value = condition3AnyINCDTLS526LessThanIITR10Minus30.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls529]) < ([iitr10] - 30)", Value = condition4AnyINCDTLS529LessThanIITR10Minus30.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls532]) < ([iitr10] - 30)", Value = condition5AnyINCDTLS532LessThanIITR10Minus30.ToString() },
                    }
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730081

        #region VR.ATO.IITR.730082

        /* VR.ATO.IITR.730082
            Any Lump sum in arrears year provided on the attached Income Details schedule must not exceed the Year of return on the parent form

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS153, ^INCDTLS153 > ^IITR10) OR AnyOccurrence(^INCDTLS523, ^INCDTLS523 > ^IITR10) OR AnyOccurrence(^INCDTLS526, ^INCDTLS526 > ^IITR10) OR AnyOccurrence(^INCDTLS529, ^INCDTLS529 > ^IITR10) OR AnyOccurrence(^INCDTLS532, ^INCDTLS532 > ^IITR10))

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS153, ^INCDTLS153 > ^IITR10) OR AnyOccurrence(^INCDTLS523, ^INCDTLS523 > ^IITR10) OR AnyOccurrence(^INCDTLS526, ^INCDTLS526 > ^IITR10) OR AnyOccurrence(^INCDTLS529, ^INCDTLS529 > ^IITR10) OR AnyOccurrence(^INCDTLS532, ^INCDTLS532 > ^IITR10))

        Data Elements:
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^INCDTLS153 = INCDTLS153
    
            ^INCDTLS523 = INCDTLS523
    
            ^INCDTLS526 = INCDTLS526
    
            ^INCDTLS529 = INCDTLS529
    
            ^INCDTLS532 = INCDTLS532
            */

        public static ProcessMessageDocument VR_ATO_IITR_730082(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            int iitr10 = report.iitrParentDocument.IITR10.GetValueOrDefault();
            bool condition1AnyINCDTLS153GreaterThanIITR10 = false;
            bool condition2AnyINCDTLS523GreaterThanIITR10 = false;
            bool condition3AnyINCDTLS526GreaterThanIITR10 = false;
            bool condition4AnyINCDTLS529GreaterThanIITR10 = false;
            bool condition5AnyINCDTLS532GreaterThanIITR10 = false;

            ProcessMessageDocument processMessage = null;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                // Condition 1: ANY OCCURRENCE OF([incdtls153]) > [iitr10]
                condition1AnyINCDTLS153GreaterThanIITR10 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollection.Any(lumpSumTuple => lumpSumTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollection != null && lumpSumTuple.Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS153 != null && tuple.INCDTLS153 > iitr10)));

                // Condition 2: ANY OCCURRENCE OF([incdtls523]) > [iitr10]
                condition2AnyINCDTLS523GreaterThanIITR10 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS523 != null && tuple.INCDTLS523 > iitr10));

                // Condition 3: ANY OCCURRENCE OF([incdtls526]) > [iitr10]
                condition3AnyINCDTLS526GreaterThanIITR10 = incdtlschilddoc.Rp_IncomeCollection.Any(incomeTuple => incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollection != null && incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollection.Any(tuple => tuple.INCDTLS526 != null && tuple.INCDTLS526 > iitr10));
            }

            // Condition 4: ANY OCCURRENCE OF([incdtls529]) > [iitr10]
            if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
            {
                condition4AnyINCDTLS529GreaterThanIITR10 = incdtlschilddoc.Rp_ForeignIncomeCollection.Any(foreignIncome => foreignIncome.Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollection != null && foreignIncome.Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollection.Any(paymentTuple => paymentTuple.INCDTLS529 != null && paymentTuple.INCDTLS529 > iitr10));
            }

            // Condition 5: ANY OCCURRENCE OF([incdtls532]) > [iitr10]
            if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
            {
                condition5AnyINCDTLS532GreaterThanIITR10 = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Any(foreignPA => foreignPA.Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollection != null && foreignPA.Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollection.Any(paymentTuple => paymentTuple.INCDTLS532 != null && paymentTuple.INCDTLS532 > iitr10));
            }

            bool assertion = condition1AnyINCDTLS153GreaterThanIITR10 || condition2AnyINCDTLS523GreaterThanIITR10 || condition3AnyINCDTLS526GreaterThanIITR10 || condition4AnyINCDTLS529GreaterThanIITR10 || condition5AnyINCDTLS532GreaterThanIITR10;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730082",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Lump sum in arrears year is invalid",
                    LongDescription = @"Any Lump sum in arrears year provided on the attached Income Details schedule must not exceed the Year of return on the parent form",
                    Location = $"/xbrli:xbrl/tns:Report.TargetFinancial.Year[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730082" },
                        new ProcessMessageParameter() { Name = "IITR10", Value = report.iitrParentDocument.IITR10.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls153]) > [iitr10]", Value = condition1AnyINCDTLS153GreaterThanIITR10.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls523]) > [iitr10]", Value = condition2AnyINCDTLS523GreaterThanIITR10.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls526]) > [iitr10]", Value = condition3AnyINCDTLS526GreaterThanIITR10.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls529]) > [iitr10]", Value = condition4AnyINCDTLS529GreaterThanIITR10.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls532]) > [iitr10]", Value = condition5AnyINCDTLS532GreaterThanIITR10.ToString() }
                    }
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730082

        #region VR.ATO.IITR.730083

        /* VR.ATO.IITR.730083
            Where any Total gross interest amounts are present where the Country of residence for tax purposes when interest was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands" on the Income Details schedule, the Gross interest amount must be provided

        Legacy Rule Format:
            ^IITR115 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS359, ^INCDTLS359 <> NULL) WHERE (^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')))

        Technical Business Rule Format:
            ^IITR115 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS359, ^INCDTLS359 <> NULL) WHERE (^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')))

        Data Elements:
    
            ^IITR115 = RP:Income.Interest.Gross.Amount
    
            ^INCDTLS354 = INCDTLS354
    
            ^INCDTLS359 = INCDTLS359
        */

        public static ProcessMessageDocument VR_ATO_IITR_730083(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            if (incdtlschilddoc.Rp_InterestCollection != null)
            {
                bool assertion;

                assertion = (report.iitrParentDocument.IITR115 == null && (incdtlschilddoc.Rp_InterestCollection.Where(t => t.INCDTLS359 != null && australianCountryCodes.Contains(t.INCDTLS354)).Count() != 0));
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730083",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Gross interest amount must be provided",
                        LongDescription = @"Where any Total gross interest amounts are present where the Country of residence for tax purposes when interest was paid or credited is ""Australia"", ""Christmas Island"", ""Norfolk Island"", ""Cocos(Keeling) Islands"" or ""Heard and McDonald Islands"" on the Income Details schedule, the Gross interest amount must be provided",
                        Location = $"/xbrli:xbrl/tns:Income.Interest.Gross.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730083" },
                        new ProcessMessageParameter() { Name = "IITR115", Value = "null" }},
                    };
                }
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730083

        #region VR.ATO.IITR.730084

        /* VR.ATO.IITR.730084
            The Gross interest amount must equal the sum of the following amounts on the Income Details schedule, where the Country of residence for tax purposes when interest was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands": all Gross interest amounts for individually owned accounts; and all Your share of gross interest amounts for joint accounts

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR115 <> NULL AND ^IITR115 <> RoundDown(Sum(ConditionalValue((^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS353 > 1, ^INCDTLS362, ^INCDTLS359), 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR115 <> NULL AND ^IITR115 <> RoundDown(Sum(ConditionalValue((^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS353 > 1, ^INCDTLS362, ^INCDTLS359), 0)), 0)

        Data Elements:
    
            ^IITR115 = RP:Income.Interest.Gross.Amount
    
            ^INCDTLS353 = INCDTLS353
    
            ^INCDTLS354 = INCDTLS354
    
            ^INCDTLS359 = INCDTLS359
    
            ^INCDTLS362 = INCDTLS362
        */

        public static ProcessMessageDocument VR_ATO_IITR_730084(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumCalculatedFields = 0;
            if (incdtlschilddoc.Rp_InterestCollection != null)
            {
                foreach (INCDTLS2026.Rp_Interest interest in incdtlschilddoc.Rp_InterestCollection)
                {
                    if (australianCountryCodes.Contains(interest.INCDTLS354))
                    {
                        if (interest.INCDTLS353 > 1)
                            sumCalculatedFields += interest.INCDTLS362.GetValueOrDefault();
                        else
                            sumCalculatedFields += interest.INCDTLS359.GetValueOrDefault();
                    }
                }
            }
            bool assertion;

            assertion = (report.iitrParentDocument.IITR115 != null && (report.iitrParentDocument.IITR115 != Math.Floor(sumCalculatedFields)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730084",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross interest amount is incorrect",
                    LongDescription = @"The Gross interest amount must equal the sum of the following amounts on the Income Details schedule, where the Country of residence for tax purposes when interest was paid or credited is ""Australia"", ""Christmas Island"", ""Norfolk Island"", ""Cocos(Keeling) Islands"" or ""Heard and McDonald Islands"": all Gross interest amounts for individually owned accounts; and all Your share of gross interest amounts for joint accounts",
                    Location = $"/xbrli:xbrl/tns:Income.Interest.Gross.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730084" },
                        new ProcessMessageParameter() { Name = "IITR115", Value = report.iitrParentDocument.IITR115.GetValueOrDefault().ToString() }},
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730084

        #region VR.ATO.IITR.730085

        /* VR.ATO.IITR.730085
            The TFN amounts withheld from gross interest must equal the sum of the following amounts on the Income Details schedule, where the Country of residence for tax purposes when interest was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands": all Total TFN amounts withheld from gross interest for individually owned accounts; and all Your share of TFN amounts withheld from gross interest for joint accounts

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR116 <> NULL AND ^IITR116 <> Sum(ConditionalValue((^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS353 > 1, ^INCDTLS361, ^INCDTLS358), 0))

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND ^IITR116 <> NULL AND ^IITR116 <> Sum(ConditionalValue((^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS353 > 1, ^INCDTLS361, ^INCDTLS358), 0))

        Data Elements:
    
            ^IITR116 = RP:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
    
            ^INCDTLS353 = INCDTLS353
    
            ^INCDTLS354 = INCDTLS354
    
            ^INCDTLS358 = INCDTLS358
    
            ^INCDTLS361 = INCDTLS361
        */

        public static ProcessMessageDocument VR_ATO_IITR_730085(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumCalculatedFields = 0;

            if (incdtlschilddoc.Rp_InterestCollection != null)
            {
                foreach (INCDTLS2026.Rp_Interest interest in incdtlschilddoc.Rp_InterestCollection)
                {
                    if (australianCountryCodes.Contains(interest.INCDTLS354))
                    {
                        if (interest.INCDTLS353 > 1)
                            sumCalculatedFields += interest.INCDTLS361.GetValueOrDefault();
                        else
                            sumCalculatedFields += interest.INCDTLS358.GetValueOrDefault();
                    }
                }
            }

            bool assertion = (report.iitrParentDocument.IITR116 != null && (report.iitrParentDocument.IITR116 != sumCalculatedFields));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730085",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"TFN amounts withheld from gross interest is incorrect",
                    LongDescription = @"The TFN amounts withheld from gross interest must equal the sum of the following amounts on the Income Details schedule, where the Country of residence for tax purposes when interest was paid or credited is ""Australia"", ""Christmas Island"", ""Norfolk Island"", ""Cocos(Keeling) Islands"" or ""Heard and McDonald Islands"": all Total TFN amounts withheld from gross interest for individually owned accounts; and all Your share of TFN amounts withheld from gross interest for joint accounts",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730085" },
                        new ProcessMessageParameter() { Name = "IITR116", Value = report.iitrParentDocument.IITR116.GetValueOrDefault().ToString()  },
                        new ProcessMessageParameter() { Name = "Sum of Calculated INCDTLS fields", Value = sumCalculatedFields.ToString()  }},
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730085

        #region VR.ATO.IITR.730086

        /* VR.ATO.IITR.730086
            The (total) Exempt foreign employment income amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Exempt foreign income amounts less Foreign income deductible expenses; and all Exempt foreign employment income amounts. If the (total) Exempt foreign employment income amount results in a loss, it must be set to zero.

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR330 <> NULL AND ^IITR330 <> ConditionalValue(RoundDown(Sum(ConditionalValue(^INCDTLS193 <> NULL, ^INCDTLS193 - ^INCDTLS187, 0)) + Sum(^INCDTLS335), 0) > 0, RoundDown(Sum(ConditionalValue(^INCDTLS193 <> NULL, ^INCDTLS193 - ^INCDTLS187, 0)) + Sum(^INCDTLS335), 0), 0)

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND ^IITR330 <> NULL AND ^IITR330 <> ConditionalValue(RoundDown(Sum(ConditionalValue(^INCDTLS193 <> NULL, ^INCDTLS193 - ^INCDTLS187, 0)) + Sum(^INCDTLS335), 0) > 0, RoundDown(Sum(ConditionalValue(^INCDTLS193 <> NULL, ^INCDTLS193 - ^INCDTLS187, 0)) + Sum(^INCDTLS335), 0), 0)

        Data Elements:
    
            ^IITR330 = RP:InternationalDealings.ExemptForeignEmploymentIncome.Amount
    
            ^INCDTLS187 = INCDTLS187
    
            ^INCDTLS193 = INCDTLS193
    
            ^INCDTLS335 = INCDTLS335
        */

        public static ProcessMessageDocument VR_ATO_IITR_730086(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumINCDTLS193 = 0;
            decimal sumINCDTLS187 = 0;
            decimal sumINCDTLS193MinusINCDTLS187 = 0;
            decimal sumINCDTLS335 = 0;
            decimal totalSum = 0;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1 (In order for this this rule to fire, INCDTLS is provided so this will always be true)

            // Condition 2: [iitr330] <> NULL
            // If this field is not provided, skips over the rest of assertion 
            if (report.iitrParentDocument.IITR330 != null)
            {
                // Condition 3: [iitr330] <> ConditionalValue(RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0) > 0, RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0), 0)
                // Condition 3a: 
                if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
                {
                    if (incdtlschilddoc.Rp_ForeignIncomeCollection.Any(tuple => tuple.INCDTLS193 != null))
                    {
                        sumINCDTLS193 = incdtlschilddoc.Rp_ForeignIncomeCollection.Sum(tuple => tuple.INCDTLS193.GetValueOrDefault());
                        sumINCDTLS187 = incdtlschilddoc.Rp_ForeignIncomeCollection.Sum(tuple => tuple.INCDTLS193 != null ? tuple.INCDTLS187.GetValueOrDefault() : 0);

                        sumINCDTLS193MinusINCDTLS187 = sumINCDTLS193 - sumINCDTLS187;
                    }
                }

                // Condition 3b: SUM([incdtls335])
                if (incdtlschilddoc.Rp_IncomeCollection != null)
                    sumINCDTLS335 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS335.GetValueOrDefault());

                // Condition: ConditionalValue(RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0) > 0, RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0), 0)
                totalSum = Math.Truncate(sumINCDTLS193MinusINCDTLS187 + sumINCDTLS335);

                // [iitr330] <> ConditionalValue(RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0) > 0, RoundDown(SUM(ConditionalValue([incdtls193] <> NULL, [incdtls193] - [incdtls187], 0)) + SUM([incdtls335]), 0), 0)
                assertion = report.iitrParentDocument.IITR330 != (totalSum > 0 ? totalSum : 0);

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730086",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Exempt foreign employment income amount is incorrect",
                        LongDescription = @"The (total) Exempt foreign employment income amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Exempt foreign income amounts less Foreign income deductible expenses; and all Exempt foreign employment income amounts. If the (total) Exempt foreign employment income amount results in a loss, it must be set to zero.",
                        Location = $"/xbrli:xbrl/tns:InternationalDealings.ExemptForeignEmploymentIncome.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters() {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730086" },
                            new ProcessMessageParameter() { Name = "IITR330", Value = report.iitrParentDocument.IITR330.GetValueOrDefault().ToString()  },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS335", Value = sumINCDTLS335.ToString()  },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS193", Value = sumINCDTLS193.ToString()  },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS187", Value = sumINCDTLS187.ToString()  },
                            new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString()  }
                        },
                    };
                }
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730086

        #region VR.ATO.IITR.730087

        /* VR.ATO.IITR.730087
            Where any Exempt foreign income amounts or Exempt foreign employment income amounts are present in the attached Income Details schedule, the (total) Exempt foreign employment income amount must be provided

        Legacy Rule Format:
            ^IITR330 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS193, ^INCDTLS193 <> NULL) OR AnyOccurrence(^INCDTLS335, ^INCDTLS335 <> NULL))

        Technical Business Rule Format:
                ^IITR330 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS193, ^INCDTLS193 <> NULL) OR AnyOccurrence(^INCDTLS335, ^INCDTLS335 <> NULL))

        Data Elements:
    
            ^IITR330 = RP:InternationalDealings.ExemptForeignEmploymentIncome.Amount
    
            ^INCDTLS193 = INCDTLS193
    
            ^INCDTLS335 = INCDTLS335
        */

        public static ProcessMessageDocument VR_ATO_IITR_730087(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool isIITR330Null = (report.iitrParentDocument.IITR330 == null);
            bool anyOccurrenceOfINCDTLS193NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_ForeignIncomeCollection != null ? incdtlschilddoc.Rp_ForeignIncomeCollection.Any(tuple => tuple.INCDTLS193.HasValue) : false);
            bool anyOccurrenceOfINCDTLS335NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS335.HasValue) : false);

            bool assertion = (isIITR330Null && (anyOccurrenceOfINCDTLS193NotNull || anyOccurrenceOfINCDTLS335NotNull));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730087",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Exempt foreign employment income amount must be provided",
                    LongDescription = @"Where any Exempt foreign income amounts or Exempt foreign employment income amounts are present in the attached Income Details schedule, the (total) Exempt foreign employment income amount must be provided",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.ExemptForeignEmploymentIncome.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730087" },
                    new ProcessMessageParameter() { Name = "IITR330", Value = "null" },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS193 or INCDTLS335 is not equal to null", Value = "true" },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730087

        #region VR.ATO.IITR.730088

        /* VR.ATO.IITR.730088
            The Assessable foreign source income amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign income gross amounts; all Foreign pension or annuity gross amounts; all Foreign rental income gross amounts; all Foreign financial investment gross amounts; all Other foreign income gross amounts; all Your share of assessable foreign income from managed fund amounts where there is more than one account holder; all Total assessable foreign income from managed fund amounts where there is a single account holder; and all Other assessable foreign source income - Beneficiary share

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR320 <> NULL AND ^IITR320 <> RoundDown(Sum(^INCDTLS189) + Sum(^INCDTLS209) + Sum(^INCDTLS219) + Sum(^INCDTLS222) + Sum(^INCDTLS226) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS428, ^INCDTLS398)) + Sum(^INCDTLS563), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR320 <> NULL AND ^IITR320 <> RoundDown(Sum(^INCDTLS189) + Sum(^INCDTLS209) + Sum(^INCDTLS219) + Sum(^INCDTLS222) + Sum(^INCDTLS226) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS428, ^INCDTLS398)) + Sum(^INCDTLS563), 0)

        Data Elements:
    
            ^IITR320 = RP:InternationalDealings.ForeignIncomeGross.Amount
    
            ^INCDTLS189 = INCDTLS189
    
            ^INCDTLS209 = INCDTLS209
    
            ^INCDTLS219 = INCDTLS219
    
            ^INCDTLS222 = INCDTLS222
    
            ^INCDTLS226 = INCDTLS226
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS398 = INCDTLS398
    
            ^INCDTLS428 = INCDTLS428

            ^INCDTLS563 = INCDTLS563
        */

        public static ProcessMessageDocument VR_ATO_IITR_730088(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            decimal sumIncdtls189 = 0;
            decimal sumIncdtls209 = 0;
            decimal sumIncdtls219 = 0;
            decimal sumIncdtls222 = 0;
            decimal sumIncdtls226 = 0;
            decimal sumConditionalIncdtls428Incdtls398 = 0;
            decimal sumIncdtls563 = 0;
            decimal totalSum = 0;

            // Only perform the rule if the first condition (IITR320 is not Null)
            if (report.iitrParentDocument.IITR320 != null)
            {
                // Loop through the ForeignIncomeCollection
                if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
                    sumIncdtls189 = incdtlschilddoc.Rp_ForeignIncomeCollection.Sum(foreignIncome => foreignIncome.INCDTLS189.GetValueOrDefault());

                // Loop through the ForeignPensionsOrAnnuitiesCollection
                if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
                    sumIncdtls209 = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Sum(foreignPoA => foreignPoA.INCDTLS209.GetValueOrDefault());

                // Loop through the OtherForeignIncomeCollection
                if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                {
                    sumIncdtls226 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS226.GetValueOrDefault());
                    sumIncdtls219 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS219.GetValueOrDefault());
                    sumIncdtls222 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS222.GetValueOrDefault());
                }

                // Loop through the ManageFundsCollection and Evaluate the ConditionalValue collecting the sum where true.
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                {
                    sumConditionalIncdtls428Incdtls398 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(managedFund =>
                        managedFund.INCDTLS387.GetValueOrDefault() > 1 ?
                        managedFund.INCDTLS428.GetValueOrDefault() :
                        managedFund.INCDTLS398.GetValueOrDefault());
                }

                // Loop through the TrustIncomeCollection
                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumIncdtls563 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(trustIncome => trustIncome.INCDTLS563.GetValueOrDefault());

                // Sum all the values and Truncate the total.
                totalSum = Math.Truncate(sumIncdtls189 + sumIncdtls209 + sumIncdtls219 + sumIncdtls222 + sumIncdtls226 + sumConditionalIncdtls428Incdtls398 + sumIncdtls563);

                assertion = (report.iitrParentDocument.IITR320.GetValueOrDefault() != totalSum);
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730088",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable foreign source income amount is incorrect",
                    LongDescription = @"The Assessable foreign source income amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign income gross amounts; all Foreign pension or annuity gross amounts; all Foreign rental income gross amounts; all Foreign financial investment gross amounts; all Other foreign income gross amounts; all Your share of assessable foreign income from managed fund amounts where there is more than one account holder; all Total assessable foreign income from managed fund amounts where there is a single account holder; and all Other assessable foreign source income - Beneficiary share",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignIncomeGross.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730088" },
                        new ProcessMessageParameter { Name = "IITR320", Value = (report.iitrParentDocument.IITR320 != null ? report.iitrParentDocument.IITR320.GetValueOrDefault().ToString() : "null") },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS189)", Value = sumIncdtls189.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS209)", Value = sumIncdtls209.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS219)", Value = sumIncdtls219.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS222)", Value = sumIncdtls222.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS226)", Value = sumIncdtls226.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS387 > 1, INCDTLS428, INCDTLS398))", Value = sumConditionalIncdtls428Incdtls398.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS563)", Value = sumIncdtls563.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730088

        #region VR.ATO.IITR.730089

        /* VR.ATO.IITR.730089
            Where any Foreign income gross amounts, Foreign pension or annuity gross amounts, Foreign rental income gross amounts, Foreign financial investment gross amounts, Other foreign income gross amounts, Total assessable foreign income from managed fund amounts, or Other assessable foreign source income - Beneficiary share are present in the attached Income Details schedule, the Assessable foreign source income amount must be provided

        Legacy Rule Format:
            ^IITR320 = NULL AND CountDocument('INCDTLS') = 1 AND(AnyOccurrence(^INCDTLS189, ^INCDTLS189<> NULL) OR AnyOccurrence(^INCDTLS209, ^INCDTLS209<> NULL) OR AnyOccurrence(^INCDTLS219, ^INCDTLS219<> NULL) OR AnyOccurrence(^INCDTLS222, ^INCDTLS222<> NULL) OR AnyOccurrence(^INCDTLS226, ^INCDTLS226<> NULL) OR AnyOccurrence(^INCDTLS398, ^INCDTLS398<> NULL)) OR AnyOccurrence(^INCDTLS563, ^INCDTLS563<> NULL))

        Technical Business Rule Format:
            ^IITR320 = NULL AND CountDocument('INCDTLS') = 1 AND(AnyOccurrence(^INCDTLS189, ^INCDTLS189<> NULL) OR AnyOccurrence(^INCDTLS209, ^INCDTLS209<> NULL) OR AnyOccurrence(^INCDTLS219, ^INCDTLS219<> NULL) OR AnyOccurrence(^INCDTLS222, ^INCDTLS222<> NULL) OR AnyOccurrence(^INCDTLS226, ^INCDTLS226<> NULL) OR AnyOccurrence(^INCDTLS398, ^INCDTLS398<> NULL)) OR AnyOccurrence(^INCDTLS563, ^INCDTLS563<> NULL))

        Data Elements:
    
            ^IITR320 = RP:InternationalDealings.ForeignIncomeGross.Amount
    
            ^INCDTLS189 = INCDTLS189
    
            ^INCDTLS209 = INCDTLS209
    
            ^INCDTLS219 = INCDTLS219
    
            ^INCDTLS222 = INCDTLS222
    
            ^INCDTLS226 = INCDTLS226
    
            ^INCDTLS398 = INCDTLS398

            ^INCDTLS563 = INCDTLS563
        */
        public static ProcessMessageDocument VR_ATO_IITR_730089(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool isIITR320Null = (report.iitrParentDocument.IITR320 == null);
            bool anyOccurrenceOfIncdtls189NotNull = (incdtlschilddoc?.Rp_ForeignIncomeCollection?.Any(tuple => tuple.INCDTLS189.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls209NotNull = (incdtlschilddoc?.Rp_ForeignPensionsOrAnnuitiesCollection?.Any(tuple => tuple.INCDTLS209.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls219NotNull = (incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(tuple => tuple.INCDTLS219.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls226NotNull = (incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(tuple => tuple.INCDTLS226.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls222NotNull = (incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(tuple => tuple.INCDTLS222.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls398NotNull = (incdtlschilddoc?.Rp_ManagedFundsCollection?.Any(tuple => tuple.INCDTLS398.HasValue) ?? false);
            bool anyOccurrenceOfIncdtls563NotNull = (incdtlschilddoc?.Rp_TrustIncomeCollection?.Any(tuple => tuple.INCDTLS563.HasValue) ?? false);

            bool assertion = (isIITR320Null && (anyOccurrenceOfIncdtls189NotNull || anyOccurrenceOfIncdtls209NotNull || anyOccurrenceOfIncdtls219NotNull || anyOccurrenceOfIncdtls222NotNull || anyOccurrenceOfIncdtls226NotNull || anyOccurrenceOfIncdtls398NotNull || anyOccurrenceOfIncdtls563NotNull));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730089",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable foreign source income must be provided",
                    LongDescription = @"Where any Foreign income gross amounts, Foreign pension or annuity gross amounts, Foreign rental income gross amounts, Foreign financial investment gross amounts, Other foreign income gross amounts, Total assessable foreign income from managed fund amounts, or Other assessable foreign source income - Beneficiary share are present in the attached Income Details schedule, the Assessable foreign source income amount must be provided",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.ForeignIncomeGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730089" },
                    new ProcessMessageParameter() { Name = "IITR320", Value = "null" },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS189 is not equal to null", Value = anyOccurrenceOfIncdtls189NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS209 is not equal to null", Value = anyOccurrenceOfIncdtls209NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS219 is not equal to null", Value = anyOccurrenceOfIncdtls219NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS222 is not equal to null", Value = anyOccurrenceOfIncdtls222NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS226 is not equal to null", Value = anyOccurrenceOfIncdtls226NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS398 is not equal to null", Value = anyOccurrenceOfIncdtls398NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS563 is not equal to null", Value = anyOccurrenceOfIncdtls563NotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730089

        #region VR.ATO.IITR.730090

        /* VR.ATO.IITR.730090
            The Other net foreign employment income amount must equal the sum of all Foreign income gross amounts, less the sum of all related Foreign income deductible expenses provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR321 <> NULL AND ^IITR321 <> RoundDown(Sum(ConditionalValue(^INCDTLS189 > 0, ^INCDTLS189 - ^INCDTLS187, 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR321 <> NULL AND ^IITR321 <> RoundDown(Sum(ConditionalValue(^INCDTLS189 > 0, ^INCDTLS189 - ^INCDTLS187, 0)), 0)

        Data Elements:
    
            ^IITR321 = RP:InternationalDealings.ForeignEmploymentIncomeOther.Amount
    
            ^INCDTLS187 = INCDTLS187
    
            ^INCDTLS189 = INCDTLS189
        */

        public static ProcessMessageDocument VR_ATO_IITR_730090(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumCalculatedFields = 0;

            if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
            {
                foreach (INCDTLS2026.Rp_ForeignIncome foreign in incdtlschilddoc.Rp_ForeignIncomeCollection)
                {
                    if (foreign.INCDTLS189 != null && foreign.INCDTLS189 > 0)
                        sumCalculatedFields += foreign.INCDTLS189.GetValueOrDefault() - foreign.INCDTLS187.GetValueOrDefault();
                }
            }

            bool assertion = (report.iitrParentDocument.IITR321 != null && (report.iitrParentDocument.IITR321 != Math.Truncate(sumCalculatedFields)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730090",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other net foreign employment income amount is incorrect",
                    LongDescription = @"The Other net foreign employment income amount must equal the sum of all Foreign income gross amounts, less the sum of all related Foreign income deductible expenses provided in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignEmploymentIncomeOther.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730090" },
                        new ProcessMessageParameter() { Name = "IITR321", Value = report.iitrParentDocument.IITR321.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS189 > 1, INCDTLS189 - INCDTLS187, 0))", Value = sumCalculatedFields.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730090

        #region VR.ATO.IITR.730091

        /* VR.ATO.IITR.730091
            Where any Foreign income gross amounts are present in the attached Income Details schedule, the Other net foreign employment income amount must be provided

        Legacy Rule Format:
             ^IITR321 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS189, ^INCDTLS189 <> NULL)

        Technical Business Rule Format:
            ^IITR321 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS189, ^INCDTLS189 <> NULL)

        Data Elements:
    
            ^IITR321 = RP:InternationalDealings.ForeignEmploymentIncomeOther.Amount
    
            ^INCDTLS189 = INCDTLS189
        */

        public static ProcessMessageDocument VR_ATO_IITR_730091(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool isIITR321Null = (report.iitrParentDocument.IITR321 == null);

            bool anyOccurrenceOfINCDTLS189NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_ForeignIncomeCollection != null ? incdtlschilddoc.Rp_ForeignIncomeCollection.Any(tuple => tuple.INCDTLS189 != null) : false);

            assertion = (isIITR321Null && anyOccurrenceOfINCDTLS189NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730091",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other net foreign employment income must be provided",
                    LongDescription = @"Where any Foreign income gross amounts are present in the attached Income Details schedule, the Other net foreign employment income amount must be provided",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.ForeignEmploymentIncomeOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730091" },
                    new ProcessMessageParameter() { Name = "IITR321", Value = (isIITR321Null ? "null" : report.iitrParentDocument.IITR321.ToString()) },
                    new ProcessMessageParameter() { Name = "Any Occurrences of INCDTLS189 are not equal to null", Value = anyOccurrenceOfINCDTLS189NotNull.ToString() },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730091

        #region VR.ATO.IITR.730092

        /*  VR.ATO.IITR.730092
                    The Net foreign rent amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign rental income gross amounts, less all related Other foreign income deductible expenses; all Your share of net foreign rent from managed fund amounts where there is more than one account holder; and all Total net foreign rent from managed fund amounts where there is a single account holder

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR324 <> NULL AND ^IITR324 <> RoundDown(Sum(ConditionalValue(^INCDTLS218 <> NULL, ^INCDTLS219 - ^INCDTLS217, 0)) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS441, ^INCDTLS413)), 0)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 1 AND ^IITR324 <> NULL AND ^IITR324 <> RoundDown(Sum(ConditionalValue(^INCDTLS218 <> NULL, ^INCDTLS219 - ^INCDTLS217, 0)) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS441, ^INCDTLS413)), 0)

        Data Elements:
    
            ^IITR324 = RP:InternationalDealings.ForeignRent.Amount
    
            ^INCDTLS217 = INCDTLS217
    
            ^INCDTLS218 = INCDTLS218
    
            ^INCDTLS219 = INCDTLS219
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS413 = INCDTLS413
    
            ^INCDTLS441 = INCDTLS441
         */

        public static ProcessMessageDocument VR_ATO_IITR_730092(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumCalculated219 = 0;
            decimal sumCalculated387 = 0;

            if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
            {
                foreach (INCDTLS2026.Rp_OtherForeignIncome otherForeign in incdtlschilddoc.Rp_OtherForeignIncomeCollection)
                {
                    if (otherForeign.INCDTLS219 != null) // && otherForeign.INCDTLS219 > 0)
                        sumCalculated219 += otherForeign.INCDTLS219.GetValueOrDefault() - otherForeign.INCDTLS217.GetValueOrDefault();
                }
            }

            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                foreach (INCDTLS2026.Rp_ManagedFunds managed in incdtlschilddoc.Rp_ManagedFundsCollection)
                {
                    if (managed.INCDTLS387 != null && managed.INCDTLS387 > 1)
                        sumCalculated387 += managed.INCDTLS441.GetValueOrDefault();
                    else
                        sumCalculated387 += managed.INCDTLS413.GetValueOrDefault();
                }
            }

            bool assertion = (report.iitrParentDocument.IITR324 != null && (report.iitrParentDocument.IITR324 != Math.Truncate(sumCalculated219 + sumCalculated387)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730092",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net foreign rent amount is incorrect",
                    LongDescription = @"The Net foreign rent amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign rental income gross amounts, less all related Other foreign income deductible expenses; all Your share of net foreign rent from managed fund amounts where there is more than one account holder; and all Total net foreign rent from managed fund amounts where there is a single account holder",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignRent.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730092" },
                        new ProcessMessageParameter() { Name = "IITR324", Value = report.iitrParentDocument.IITR324.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS219 > 0, INCDTLS219 - INCDTLS217, 0))", Value = sumCalculated219.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS387 > 1, INCDTLS441, INCDTLS413))", Value = sumCalculated387.ToString() }
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730092

        #region VR.ATO.IITR.730093

        /* VR.ATO.IITR.730093
            Where any Foreign rental income gross amounts or Total net foreign rent from managed fund amounts are present in the attached Income Details schedule, the Net foreign rent amount must be provided

        Legacy Rule Format:
            ^IITR324 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS219, ^INCDTLS219 <> NULL) OR AnyOccurrence(^INCDTLS413, ^INCDTLS413 <> NULL))

        Technical Business Rule Format:
            ^IITR324 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS219, ^INCDTLS219 <> NULL) OR AnyOccurrence(^INCDTLS413, ^INCDTLS413 <> NULL))

        Data Elements:
    
            ^IITR324 = RP:InternationalDealings.ForeignRent.Amount
    
            ^INCDTLS219 = INCDTLS219
    
            ^INCDTLS413 = INCDTLS413
        */

        public static ProcessMessageDocument VR_ATO_IITR_730093(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool isIITR324Null = (report.iitrParentDocument.IITR324 == null);
            bool anyOccurrenceOfINCDTLS219NotNull = incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(tuple => tuple.INCDTLS219.HasValue) ?? false;
            bool anyOccurrenceOfINCDTLS413NotNull = incdtlschilddoc?.Rp_ManagedFundsCollection?.Any(tuple => tuple.INCDTLS413.HasValue) ?? false;

            bool assertion = (isIITR324Null && (anyOccurrenceOfINCDTLS219NotNull || anyOccurrenceOfINCDTLS413NotNull));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730093",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net foreign rent must be provided",
                    LongDescription = @"Where any Foreign rental income gross amounts or Total net foreign rent from managed fund amounts are present in the attached Income Details schedule, the Net foreign rent amount must be provided",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.ForeignRent.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730093" },
                    new ProcessMessageParameter() { Name = "IITR330", Value = "null" },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS219 is not equal to null", Value = anyOccurrenceOfINCDTLS219NotNull.ToString() },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS219 is not equal to null", Value = anyOccurrenceOfINCDTLS413NotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730093

        #region VR.ATO.IITR.730094

        /* VR.ATO.IITR.730094
            Where any Foreign financial investment gross amounts or Total other foreign income from managed fund amounts are present in the attached Income Details schedule, the Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount must be provided

        Legacy Rule Format:
            ^IITR325 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS222, ^INCDTLS222 <> NULL) OR AnyOccurrence(^INCDTLS399, ^INCDTLS399 <> NULL))

        Technical Business Rule Format:
            ^IITR325 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS222, ^INCDTLS222 <> NULL) OR AnyOccurrence(^INCDTLS399, ^INCDTLS399 <> NULL))

        Data Elements:
    
            ^IITR325 = RP:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount
    
            ^INCDTLS222 = INCDTLS222
    
            ^INCDTLS399 = INCDTLS399
        */

        public static ProcessMessageDocument VR_ATO_IITR_730094(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool anyOccurrenceIncdtls222NotNull = false;
            bool anyOccurrenceIncdtls399NotNull = false;
            bool assertion = false;

            if (!report.iitrParentDocument.IITR325.HasValue)
            {
                if (incdtlschilddoc != null)
                {
                    if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                        anyOccurrenceIncdtls222NotNull = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Any(foreignIncome => foreignIncome.INCDTLS222 != null);

                    if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                        anyOccurrenceIncdtls399NotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(managedFund => managedFund.INCDTLS399 != null);
                }

                assertion = anyOccurrenceIncdtls222NotNull || anyOccurrenceIncdtls399NotNull;
            }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730094",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount must be provided",
                    LongDescription = "Where any Foreign financial investment gross amounts or Total other foreign income from managed fund amounts are present in the attached Income Details schedule, the Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount must be provided",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730094" },
                        new ProcessMessageParameter() { Name = "IITR325", Value = report.iitrParentDocument.IITR325 != null ? report.iitrParentDocument.IITR325.ToString() : "null" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls222) <> NULL", Value = anyOccurrenceIncdtls222NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls399) <> NULL", Value = anyOccurrenceIncdtls399NotNull.ToString() }
                    }
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730094

        #region VR.ATO.IITR.730095

        /* VR.ATO.IITR.730095
            The Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign financial investment gross amounts less all related Other foreign income deductible expenses; all Your share of other foreign income from managed fund amounts where there is more than one account holder; and all Total other foreign income from managed fund amounts where there is a single account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR325 <> NULL AND ^IITR325 <> RoundDown(Sum(^INCDTLS222) - Sum(ConditionalValue(^INCDTLS221 <> NULL, ^INCDTLS217, 0)) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS429, ^INCDTLS399)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR325 <> NULL AND ^IITR325 <> RoundDown(Sum(^INCDTLS222) - Sum(ConditionalValue(^INCDTLS221 <> NULL, ^INCDTLS217, 0)) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS429, ^INCDTLS399)), 0)

        Data Elements:
    
            ^IITR325 = RP:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount
    
            ^INCDTLS217 = INCDTLS217
    
            ^INCDTLS221 = INCDTLS221
    
            ^INCDTLS222 = INCDTLS222
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS399 = INCDTLS399
    
            ^INCDTLS429 = INCDTLS429
        */

        public static ProcessMessageDocument VR_ATO_IITR_730095(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumINCDTLS222 = 0;
            decimal sumINCDTLS217WhereINCDTLS221Exists = 0;
            decimal sumConditionalINCDTLS387 = 0;
            decimal totalSum = 0;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1 (In order for this this rule to fire, INCDTLS is provided so this will always be true)

            // Condition 2: [iitr325] <> NULL
            // If this field is not provided, skips over the rest of assertion 
            if (report.iitrParentDocument.IITR325 != null)
            {
                // Condition 3: [iitr325] <> RoundDown(SUM([incdtls222]) - SUM(ConditionalValue(INCDTLS221 <> NULL, INCDTLS217, 0)) + SUM(ConditionalValue([incdtls387] > 1, [incdtls429], [incdtls399])), 0)

                // Condition 3a & Condition 3b
                if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                {
                    // Condition 3a: SUM([incdtls222])
                    sumINCDTLS222 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(tuple => tuple.INCDTLS222.GetValueOrDefault());

                    // Condition 3b: SUM(ConditionalValue(INCDTLS221 <> NULL, INCDTLS217, 0))
                    sumINCDTLS217WhereINCDTLS221Exists = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(tuple => tuple.Rp_OtherForeignIncome_ForeignFinancialInvestmentDetailsCollectionExists ? tuple.INCDTLS217.GetValueOrDefault() : 0);
                }

                // Condition 3c: SUM(ConditionalValue([incdtls387] > 1, [incdtls429], [incdtls399]))
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                {
                    sumConditionalINCDTLS387 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() > 1 ? tuple.INCDTLS429.GetValueOrDefault() : tuple.INCDTLS399.GetValueOrDefault());
                }

                // RoundDown(SUM([incdtls222]) - SUM(ConditionalValue(INCDTLS221 <> NULL, INCDTLS217, 0)) + SUM(ConditionalValue([incdtls387] > 1, [incdtls429], [incdtls399])), 0)
                totalSum = Math.Truncate(sumINCDTLS222 - sumINCDTLS217WhereINCDTLS221Exists + sumConditionalINCDTLS387);

                assertion = report.iitrParentDocument.IITR325.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730095",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount is incorrect",
                        LongDescription = @"The Other net foreign source income - dividend income or managed investment scheme income from foreign companies - including from foreign partnerships amount must equal the sum of the following amounts provided in the attached Income Details schedule: all Foreign financial investment gross amounts less all related Other foreign income deductible expenses; all Your share of other foreign income from managed fund amounts where there is more than one account holder; and all Total other foreign income from managed fund amounts where there is a single account holder",
                        Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730095" },
                        new ProcessMessageParameter() { Name = "IITR325", Value = report.iitrParentDocument.IITR325.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS222)", Value = sumINCDTLS222.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS221 <> NULL, INCDTLS217, 0))", Value = sumINCDTLS217WhereINCDTLS221Exists.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(INCDTLS387 > 1, INCDTLS429, INCDTLS399))", Value = sumConditionalINCDTLS387.ToString() },
                        new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString() },
                    },
                    };
                }
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730095

        #region VR.ATO.IITR.730096

        /* VR.ATO.IITR.730096
            Where any Other foreign income gross amounts or Other assessable foreign source income - Beneficiary share are present in the attached Income Details schedule, the Other foreign source income amount must be provided

        Legacy Rule Format:
            ^IITR326 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS226, ^INCDTLS226 <> NULL)) OR (AnyOccurrence(^INCDTLS563, ^INCDTLS563 <> NULL))

        Technical Business Rule Format:
            ^IITR326 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS226, ^INCDTLS226 <> NULL)) OR (AnyOccurrence(^INCDTLS563, ^INCDTLS563 <> NULL))

        Data Elements:
    
            ^IITR326 = RP:InternationalDealings.ForeignSourceIncomeOther.Amount
    
            ^INCDTLS226 = INCDTLS226

            ^INCDTLS563 = INCDTLS563
        */

        public static ProcessMessageDocument VR_ATO_IITR_730096(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            decimal? iitr326 = report?.iitrParentDocument?.IITR326;
            bool anyOccurrenceIncdtls226NotNull = false;
            bool anyOccurrenceIncdtls563NotNull = false;

            if (!iitr326.HasValue)
            {
                anyOccurrenceIncdtls226NotNull = incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(foreignIncome => foreignIncome.INCDTLS226.HasValue) ?? false;
                anyOccurrenceIncdtls563NotNull = incdtlschilddoc?.Rp_TrustIncomeCollection?.Any(trustIncome => trustIncome.INCDTLS563.HasValue) ?? false;
                assertion = (anyOccurrenceIncdtls226NotNull || anyOccurrenceIncdtls563NotNull);
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730096",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other foreign source income amount must be provided",
                    LongDescription = @"Where any Other foreign income gross amounts or Other assessable foreign source income - Beneficiary share are present in the attached Income Details schedule, the Other foreign source income amount must be provided",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignSourceIncomeOther.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730096" },
                        new ProcessMessageParameter() { Name = "IITR326", Value = iitr326.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS226 <> NULL", Value = anyOccurrenceIncdtls226NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS563 <> NULL", Value = anyOccurrenceIncdtls563NotNull.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730096

        #region VR.ATO.IITR.730097

        /* VR.ATO.IITR.730097
            The Other foreign source income amount must equal the sum of all Other foreign income gross amounts, and all Other assessable foreign source income - Beneficiary share, less all related Other foreign income deductible expenses provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR326 <> NULL AND ^IITR326 <> RoundDown(Sum(^INCDTLS226) + Sum(^INCDTLS563) - Sum(ConditionalValue(^INCDTLS225 <> NULL, ^INCDTLS217, 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR326 <> NULL AND ^IITR326 <> RoundDown(Sum(^INCDTLS226) + Sum(^INCDTLS563) - Sum(ConditionalValue(^INCDTLS225 <> NULL, ^INCDTLS217, 0)), 0)

        Data Elements:
    
            ^IITR326 = RP:InternationalDealings.ForeignSourceIncomeOther.Amount
    
            ^INCDTLS217 = INCDTLS217
    
            ^INCDTLS225 = INCDTLS225
    
            ^INCDTLS226 = INCDTLS226

            ^INCDTLS563 = INCDTLS563
        */

        public static ProcessMessageDocument VR_ATO_IITR_730097(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumINCDTLS226 = 0;
            decimal sumINCDTLS563 = 0;
            decimal sumINCDTLS217WhereINCDTLS225Exists = 0;
            decimal totalSum = 0;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1 (In order for this this rule to fire, INCDTLS is provided so this will always be true)

            // Condition 2: [iitr326] <> NULL
            // If this field is not provided, skips over the rest of assertion 
            if (report.iitrParentDocument.IITR326 != null)
            {
                // Condition 3: [iitr326] <> RoundDown(SUM([incdtls226]) - SUM(ConditionalValue(INCDTLS225 <> NULL, INCDTLS217, 0)), 0)
                if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                {
                    // Condition 3a: SUM([incdtls226])
                    sumINCDTLS226 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(tuple => tuple.INCDTLS226.GetValueOrDefault());

                    // Condition 3c: SUM(ConditionalValue(INCDTLS225 <> NULL, INCDTLS217, 0))
                    sumINCDTLS217WhereINCDTLS225Exists = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(tuple => tuple.Rp_OtherForeignIncome_OtherForeignIncomeDetailsCollectionExists ? tuple.INCDTLS217.GetValueOrDefault() : 0);
                }

                // Loop through the TrustIncomeCollection (Condition 3b: SUM([incdtls563])
                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumINCDTLS563 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(trustIncome => trustIncome.INCDTLS563.GetValueOrDefault());

                // RoundDown(SUM([incdtls226]) + SUM([incdtls563]) - SUM(ConditionalValue(INCDTLS225 <> NULL, INCDTLS217, 0)), 0)
                totalSum = Math.Truncate(sumINCDTLS226 + sumINCDTLS563 - sumINCDTLS217WhereINCDTLS225Exists);

                // [iitr326] <> RoundDown(SUM([incdtls226]) - SUM(ConditionalValue(INCDTLS225 <> NULL, INCDTLS217, 0)), 0)
                bool assertion = report.iitrParentDocument.IITR326.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730097",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Other foreign source income amount is incorrect",
                        LongDescription = @"The Other foreign source income amount must equal the sum of all Other foreign income gross amounts, and all Other assessable foreign source income - Beneficiary shares, less all related Other foreign income deductible expenses provided in the attached Income Details schedule",
                        Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignSourceIncomeOther.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730097" },
                            new ProcessMessageParameter() { Name = "IITR326", Value = report.iitrParentDocument.IITR326.ToString() },
                            new ProcessMessageParameter() { Name = "SUM(incdtls226)", Value = sumINCDTLS226.ToString() },
                            new ProcessMessageParameter() { Name = "SUM(incdtls563)", Value = sumINCDTLS563.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS225", Value = sumINCDTLS217WhereINCDTLS225Exists.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString() },
                        },
                    };
                }
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730097

        #region VR.ATO.IITR.730150

        /* VR.ATO.IITR.730150
            When the answer to the question "Did you earn this income while you held a Working Holiday visa (subclass 417) or Work and Holiday visa (subclass 462)?" is 'yes' (true) for any Individual non-business payment summary instance in the Income Details Schedule, the Working holiday maker net income must be provided

        Legacy Rule Format:
            ^IITR499 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS310, ^INCDTLS310 = TRUE)

        Technical Business Rule Format:
            ^IITR499 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS310, ^INCDTLS310 = TRUE)

        Data Elements:
    
            ^IITR499 = RP.WHM:Income.Net.Amount
    
            ^INCDTLS310 = INCDTLS310
        */

        public static ProcessMessageDocument VR_ATO_IITR_730150(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR499 == null && (incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS310.GetValueOrDefault()) : false));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730150",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Working holiday maker net income must be provided",
                    LongDescription = @"When the answer to the question ""Did you earn this income while you held a Working Holiday visa (subclass 417) or Work and Holiday visa (subclass 462)?"" is 'yes' (true) for any Individual non-business payment summary instance in the Income Details Schedule, the Working holiday maker net income must be provided",
                    Location = "/xbrli:xbrl/tns:Income.Net.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730150" },
                        new ProcessMessageParameter() { Name = "IITR499", Value = report.iitrParentDocument.IITR499.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730150

        #region VR.ATO.IITR.730151

        /* VR.ATO.IITR.730151
            Where any Allowances including commissions, director's fees, bonuses, tips or consultation fees etc amounts are present in the attached Income Details schedule, the Amount of allowances, earnings, tips, director's fees, etc must be provided

        Legacy Rule Format:
            ^IITR65 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS313, ^INCDTLS313 <> NULL)

        Technical Business Rule Format:
            ^IITR65 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS313, ^INCDTLS313 <> NULL)

        Data Elements:
    
            ^IITR65 = RP:Income.AllowancesEarningsTipsDirectorsFees.Amount
    
            ^INCDTLS313 = INCDTLS313
        */

        public static ProcessMessageDocument VR_ATO_IITR_730151(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            assertion = (report.iitrParentDocument.IITR65 == null && (incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS313 != null) : false));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730151",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Amount of allowances, earnings, tips, director's fees, etc must be provided",
                    LongDescription = @"Where any Allowances including commissions, director's fees, bonuses, tips or consultation fees etc amounts are present in the attached Income Details schedule, the Amount of allowances, earnings, tips, director's fees, etc must be provided",
                    Location = "/xbrli:xbrl/tns:Income.AllowancesEarningsTipsDirectorsFees.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730151" },
                        new ProcessMessageParameter() { Name = "IITR65", Value = report.iitrParentDocument.IITR65.GetValueOrDefault().ToString() } },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730151 

        #region VR.ATO.IITR.730152

        /* VR.ATO.IITR.730152
            The Amount of allowances, earnings, tips, director's fees, etc must equal the sum of all Allowances including commissions, director's fees, bonuses, tips or consultation fees etc amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR65 <> NULL AND ^IITR65 <> Sum(^INCDTLS313)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR65 <> NULL AND ^IITR65 <> Sum(^INCDTLS313)

        Data Elements:
    
            ^IITR65 = RP:Income.AllowancesEarningsTipsDirectorsFees.Amount
    
            ^INCDTLS313 = INCDTLS313
        */

        public static ProcessMessageDocument VR_ATO_IITR_730152(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            decimal sumSoW313 = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumSoW313 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS313.GetValueOrDefault());
            bool assertion;

            assertion = (report.iitrParentDocument.IITR65 != null && (report.iitrParentDocument.IITR65.GetValueOrDefault() != sumSoW313));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730152",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Amount of allowances, earnings, tips, director's fees, etc is incorrect",
                    LongDescription = @"The Amount of allowances, earnings, tips, director's fees, etc must equal the sum of all Allowances including commissions, director's fees, bonuses, tips or consultation fees etc amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.AllowancesEarningsTipsDirectorsFees.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730152" },
                        new ProcessMessageParameter() { Name = "IITR65", Value = report.iitrParentDocument.IITR65.GetValueOrDefault().ToString() }},
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730152

        #region VR.ATO.IITR.730156

        /* VR.ATO.IITR.730156
            The Salary or wages tax withheld amount must equal; the sum of all Salary or wages tax withheld amounts, plus the sum of all Foreign employment income tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocuments('INCDTLS') = 1 AND ^IITR600 <> NULL AND ^IITR600 <> (Sum(^INCDTLS311) +  Sum(^INCDTLS167))

        Technical Business Rule Format:
            CountDocuments('INCDTLS') = 1 AND ^IITR600 <> NULL AND ^IITR600 <> (Sum(^INCDTLS311) +  Sum(^INCDTLS167))

        Data Elements:
    
            ^IITR600 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount
    
            ^INCDTLS167 = INCDTLS167
    
            ^INCDTLS311 = INCDTLS311
        */

        public static ProcessMessageDocument VR_ATO_IITR_730156(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // SUM([incdtls311])
            decimal sumOfINCDTLS311 = 0;
            // SUM([incdtls167])
            decimal sumOfINCDTLS167 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS311 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS311.GetValueOrDefault());
                sumOfINCDTLS167 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS167.GetValueOrDefault());
            }

            bool assertion = report.iitrParentDocument.IITR600 != null && report.iitrParentDocument.IITR600 != (sumOfINCDTLS311 + sumOfINCDTLS167);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730156",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages tax withheld amount is incorrect",
                    LongDescription = @"The Salary or wages tax withheld amount must equal; the sum of all Salary or wages tax withheld amounts, plus the sum of all Foreign employment income tax withheld amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730156" },
                        new ProcessMessageParameter() { Name = "IITR600", Value = report.iitrParentDocument.IITR600.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls311])", Value = sumOfINCDTLS311.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls167])", Value = sumOfINCDTLS167.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls311] + SUM([incdtls167]))", Value = (sumOfINCDTLS311 + sumOfINCDTLS167).ToString() }
                    },
                };

            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730156

        #region VR.ATO.IITR.730157

        /* VR.ATO.IITR.730157
            Where any Salary or wages tax withheld or Foreign employment income tax withheld amounts are present in the attached Income Details schedule, the Salary or wages tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR600 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS311, ^INCDTLS311 <> NULL) OR AnyOccurrence(^INCDTLS167, ^INCDTLS167 <> NULL))

        Technical Business Rule Format:
            ^IITR600 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS311, ^INCDTLS311 <> NULL) OR AnyOccurrence(^INCDTLS167, ^INCDTLS167 <> NULL))

        Data Elements:
    
            ^IITR600 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount
    
            ^INCDTLS167 = INCDTLS167
    
            ^INCDTLS311 = INCDTLS311
        */

        public static ProcessMessageDocument VR_ATO_IITR_730157(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // ANY OCCURRENCE OF([incdtls311]) <> NULL or ANY OCCURRENCE OF([incdtls167]) <> NULL
            bool anyOccurence311or167IsNotNull = incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS311.HasValue || tuple.INCDTLS167.HasValue) : false;

            bool assertion = report.iitrParentDocument.IITR600 == null && anyOccurence311or167IsNotNull;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730157",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages tax withheld amount must be provided",
                    LongDescription = @"Where any Salary or wages tax withheld or Foreign employment income tax withheld amounts are present in the attached Income Details schedule, the Salary or wages tax withheld amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730157" },
                        new ProcessMessageParameter() { Name = "IITR600", Value = "null" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls311]) <> NULL OR ANY OCCURRENCE OF ([incdtls167]) <> NULL", Value = "true" }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730157

        #region VR.ATO.IITR.730158

        /* VR.ATO.IITR.730158
            The Salary or wages gross income amount must equal; the sum of all Salary or wages gross income amounts, plus the sum of all Foreign employment income gross amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR601 <> NULL AND ^IITR601 <> RoundDown((Sum(^INCDTLS312) + Sum(^INCDTLS168)),0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR601 <> NULL AND ^IITR601 <> RoundDown((Sum(^INCDTLS312) + Sum(^INCDTLS168)),0)

        Data Elements:
    
            ^IITR601 = RP:Income.SalaryOrWages.Amount
    
            ^INCDTLS168 = INCDTLS168
    
            ^INCDTLS312 = INCDTLS312
        */

        public static ProcessMessageDocument VR_ATO_IITR_730158(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // SUM([incdtls312])
            decimal sumOfINCDTLS312 = 0;

            // SUM([incdtls168])
            decimal sumOfINCDTLS168 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS312 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS312.GetValueOrDefault());
                sumOfINCDTLS168 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS168.GetValueOrDefault());
            }

            // RoundDown((SUM([incdtls312]) + SUM([incdtls168])), 0)
            decimal sumOfINCDTLS312AndINCDTLS168 = Math.Truncate(sumOfINCDTLS312 + sumOfINCDTLS168);

            bool assertion = report.iitrParentDocument.IITR601 != null && report.iitrParentDocument.IITR601 != sumOfINCDTLS312AndINCDTLS168;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730158",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages gross income amount is incorrect",
                    LongDescription = @"The Salary or wages gross income amount must equal; the sum of all Salary or wages gross income amounts, plus the sum of all Foreign employment income gross amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.SalaryOrWages.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730158" },
                        new ProcessMessageParameter() { Name = "IITR601", Value = report.iitrParentDocument.IITR601.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls312])", Value = sumOfINCDTLS312.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls168])", Value = sumOfINCDTLS168.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown((SUM([incdtls312]) + SUM([incdtls168])), 0)", Value = sumOfINCDTLS312AndINCDTLS168.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730158

        #region VR.ATO.IITR.730159

        /* VR.ATO.IITR.730159
            Where any Salary or wages gross income or Foreign employment income gross amounts are present in the attached Income Details schedule, the Salary or wages gross income amount must be provided

        Legacy Rule Format:
            ^IITR601 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS312, ^INCDTLS312 <> NULL) OR AnyOccurrence(^INCDTLS168, ^INCDTLS168 <> NULL))

        Technical Business Rule Format:
            ^IITR601 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS312, ^INCDTLS312 <> NULL) OR AnyOccurrence(^INCDTLS168, ^INCDTLS168 <> NULL))

        Data Elements:
    
            ^IITR601 = RP:Income.SalaryOrWages.Amount
    
            ^INCDTLS168 = INCDTLS168
    
            ^INCDTLS312 = INCDTLS312
        */

        public static ProcessMessageDocument VR_ATO_IITR_730159(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // ANY OCCURRENCE OF([incdtls311]) <> NULL or AnyOccurrence(^incdtls168, ^incdtls168 <> NULL)
            bool anyOccurence312or168IsNotNull = incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS312 != null || tuple.INCDTLS168 != null) : false;

            assertion = report.iitrParentDocument.IITR601 == null && anyOccurence312or168IsNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730159",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages gross income amount must be provided",
                    LongDescription = @"Where any Salary or wages gross income or Foreign employment income gross amounts are present in the attached Income Details schedule, the Salary or wages gross income amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.SalaryOrWages.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730159" },
                        new ProcessMessageParameter() { Name = "IITR601", Value = "null" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls312]) <> NULL or AnyOccurrence(^INCDTLS168, ^INCDTLS168 <> NULL)", Value = anyOccurence312or168IsNotNull.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730159

        #region VR.ATO.IITR.730153

    /* VR.ATO.IITR.730153
        Total reportable fringe benefits amount from employers exempt under section 57A must equal the sum of all Reportable fringe benefits and all Foreign employment income reportable fringe benefits amounts in the attached Income Details schedule, where the employer is reported as being exempt under section 57A

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR490 <> NULL AND ^IITR490 <> (Sum(ConditionalValue(^INCDTLS315 = TRUE, ^INCDTLS314, 0)) + Sum(ConditionalValue(^INCDTLS180 = TRUE, ^INCDTLS170, 0)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR490 <> NULL AND ^IITR490 <> (Sum(ConditionalValue(^INCDTLS315 = TRUE, ^INCDTLS314, 0)) + Sum(ConditionalValue(^INCDTLS180 = TRUE, ^INCDTLS170, 0)))

        Data Elements:
    
            ^IITR490 = RP.Eligible:Income.FringeBenefitsReportable.Amount
    
            ^INCDTLS170 = INCDTLS170
    
            ^INCDTLS180 = INCDTLS180
    
            ^INCDTLS314 = INCDTLS314
    
            ^INCDTLS315 = INCDTLS315
        */

        public static ProcessMessageDocument VR_ATO_IITR_730153(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;
            decimal? iitr490 = report?.iitrParentDocument?.IITR490;
            decimal sumOfINCDTLS314WhereINCDTLS315IsTrue = 0;
            decimal sumOfINCDTLS170WhereINCDTLS180IsTrue = 0;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // Condition 2: IITR490 <> NULL
            if (iitr490.HasValue)
            {
                List<INCDTLS2026.Rp_Income> incomes = incdtlschilddoc?.Rp_IncomeCollection;

                if (incomes != null)
                {
                    sumOfINCDTLS314WhereINCDTLS315IsTrue = incomes.Sum(income => income.INCDTLS315.GetValueOrDefault() ? income.INCDTLS314.GetValueOrDefault() : 0);
                    sumOfINCDTLS170WhereINCDTLS180IsTrue = incomes.Sum(income => income.INCDTLS180.GetValueOrDefault() ? income.INCDTLS170.GetValueOrDefault() : 0);

                    // Condition 3: IITR490 <> SUM(CONDITIONALVALUE([INCDTLS315] = TRUE, [INCDTLS314], 0)) + SUM(CONDITIONALVALUE([INCDTLS180] = TRUE, [INCDTLS170], 0))
                    assertion = iitr490 != sumOfINCDTLS314WhereINCDTLS315IsTrue + sumOfINCDTLS170WhereINCDTLS180IsTrue;
                }
            }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730153",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total reportable fringe benefits amount from employers exempt under section 57A is incorrect",
                    LongDescription = @"Total reportable fringe benefits amount from employers exempt under section 57A must equal the sum of all Reportable fringe benefits and all Foreign employment income reportable fringe benefits amounts in the attached Income Details schedule, where the employer is reported as being exempt under section 57A",
                    Location = "/xbrli:xbrl/tns:Income.FringeBenefitsReportable.Amount[@contextRef='" + report.iitrParentDocument.RPEligibleId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730153" },
                        new ProcessMessageParameter() { Name = "IITR490", Value = iitr490.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue([incdtls315] = TRUE, [incdtls314], 0))", Value = sumOfINCDTLS314WhereINCDTLS315IsTrue.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue([incdtls180] = TRUE, [incdtls170], 0))", Value = sumOfINCDTLS170WhereINCDTLS180IsTrue.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730153

        #region VR.ATO.IITR.730154

        /* VR.ATO.IITR.730154
            Where any Reportable fringe benefits or Foreign employment income reportable fringe benefits amounts are present in the attached Income Details schedule, the Total reportable fringe benefits amount from employers exempt under section 57A and Total reportable fringe benefits amount from employers not exempt under section 57A must be provided

        Legacy Rule Format:
            ^IITR13 = 'Short' AND (^IITR490 = NULL OR ^IITR491 = NULL) AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS314, ^INCDTLS314 <> NULL) OR AnyOccurrence(^INCDTLS170, ^INCDTLS170 <> NULL))

        Technical Business Rule Format:
            ^IITR13 = 'Short' AND (^IITR490 = NULL OR ^IITR491 = NULL) AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS314, ^INCDTLS314 <> NULL) OR AnyOccurrence(^INCDTLS170, ^INCDTLS170 <> NULL))

        Data Elements:
    
            ^IITR490 = RP.Eligible:Income.FringeBenefitsReportable.Amount
    
            ^IITR13 = RP:IncomeTax.ReturnType.Code
    
            ^IITR491 = RP.Ineligible:Income.FringeBenefitsReportable.Amount
    
            ^INCDTLS170 = INCDTLS170
    
            ^INCDTLS314 = INCDTLS314
        */

        public static ProcessMessageDocument VR_ATO_IITR_730154(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;


            // Condition 1: [iitr13] = "Short"
            bool cond1_iitr13IsShort = ((report != null && report.iitrParentDocument != null && report.iitrParentDocument.IITR13 != null && report.iitrParentDocument.IITR13 == "Short") ? true : false);

            // Condition 2: [iitr490] = NULL OR [iitr491] = NULL
            bool cond2_iitr490Or491IsNull = ((report != null && report.iitrParentDocument != null && (report.iitrParentDocument.IITR490 == null || report.iitrParentDocument.IITR491 == null)) ? true : false);

            // Condition 3: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // Condition 4: 
            //ANY OCCURRENCE OF ([incdtls314]) <> NULL
            bool cond4_isAnyINCDTLS314NotNull = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => !tuple.INCDTLS314.Equals(null))) : false);
            //ANY OCCURRENCE OF([incdtls170]) <> NULL            
            bool cond4_isAnyINCDTLS170NotNull = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => !tuple.INCDTLS170.Equals(null))) : false);

            // Evaluate the condition
            assertion = (cond1_iitr13IsShort && cond2_iitr490Or491IsNull && (cond4_isAnyINCDTLS314NotNull || cond4_isAnyINCDTLS170NotNull));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730154",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total reportable fringe benefits amounts from employers exempt and not exempt under section 57A must be provided",
                    LongDescription = @"Where any Reportable fringe benefits or Foreign employment income reportable fringe benefits amounts are present in the attached Income Details schedule, the Total reportable fringe benefits amount from employers exempt under section 57A and Total reportable fringe benefits amount from employers not exempt under section 57A must be provided",
                    Location = "/xbrli:xbrl/tns:Income.FringeBenefitsReportable.Amount[@contextRef='" + report.iitrParentDocument.RPEligibleId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730154" },
                        new ProcessMessageParameter() { Name = "iitr13", Value = ((report != null && report.iitrParentDocument != null && report.iitrParentDocument.IITR13 != null) ? report.iitrParentDocument.IITR13 : "null") },
                        new ProcessMessageParameter() { Name = "iitr490", Value = ((report != null && report.iitrParentDocument != null && report.iitrParentDocument.IITR490 != null) ? report.iitrParentDocument.IITR490.ToString() : "null") },
                        new ProcessMessageParameter() { Name = "iitr491", Value = ((report != null && report.iitrParentDocument != null && report.iitrParentDocument.IITR491 != null) ? report.iitrParentDocument.IITR491.ToString() : "null") },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF ([incdtls314]) <> NULL", Value = cond4_isAnyINCDTLS314NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF ([incdtls170]) <> NULL", Value = cond4_isAnyINCDTLS170NotNull.ToString() },
                    }
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730154

        #region VR.ATO.IITR.730155

        /* VR.ATO.IITR.730155
            Total reportable fringe benefits amount from employers not exempt under section 57A must equal the sum of all Reportable fringe benefits and all Foreign employment income reportable fringe benefits amounts in the attached Income Details schedule, where the employer is reported as being not exempt under section 57A

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR491 <> NULL AND ^IITR491 <> (Sum(ConditionalValue(^INCDTLS315 = FALSE, ^INCDTLS314, 0)) + Sum(ConditionalValue(^INCDTLS180 = FALSE, ^INCDTLS170, 0)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR491 <> NULL AND ^IITR491 <> (Sum(ConditionalValue(^INCDTLS315 = FALSE, ^INCDTLS314, 0)) + Sum(ConditionalValue(^INCDTLS180 = FALSE, ^INCDTLS170, 0)))

        Data Elements:
    
            ^IITR491 = RP.Ineligible:Income.FringeBenefitsReportable.Amount
    
            ^INCDTLS170 = INCDTLS170
    
            ^INCDTLS180 = INCDTLS180
    
            ^INCDTLS314 = INCDTLS314
    
            ^INCDTLS315 = INCDTLS315
        */

        public static ProcessMessageDocument VR_ATO_IITR_730155(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;
            decimal? iitr491 = report?.iitrParentDocument?.IITR491;
            decimal sumOfINCDTLS314WhereINCDTLS315IsFalse = 0;
            decimal sumOfINCDTLS170WhereINCDTLS180IsFalse = 0;

            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // Condition 2: IITR491 <> NULL
            if (iitr491.HasValue)
            {
                List<INCDTLS2026.Rp_Income> incomes = incdtlschilddoc?.Rp_IncomeCollection;

                if (incomes != null)
                {
                    sumOfINCDTLS314WhereINCDTLS315IsFalse = incomes.Sum(income => income.INCDTLS315 == false ? income.INCDTLS314.GetValueOrDefault() : 0);
                    sumOfINCDTLS170WhereINCDTLS180IsFalse = incomes.Sum(income => income.INCDTLS180 == false ? income.INCDTLS170.GetValueOrDefault() : 0);

                    // Condition 3: IITR491 <> SUM(CONDITIONALVALUE([INCDTLS315] = FALSE, [INCDTLS314], 0)) + SUM(CONDITIONALVALUE([INCDTLS180] = FALSE, [INCDTLS170], 0))
                    assertion = iitr491 != sumOfINCDTLS314WhereINCDTLS315IsFalse + sumOfINCDTLS170WhereINCDTLS180IsFalse;
                }
            }
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730155",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total reportable fringe benefits amount from employers not exempt under section 57A is incorrect",
                    LongDescription = @"Total reportable fringe benefits amount from employers not exempt under section 57A must equal the sum of all Reportable fringe benefits and all Foreign employment income reportable fringe benefits amounts in the attached Income Details schedule, where the employer is reported as being not exempt under section 57A",
                    Location = "/xbrli:xbrl/tns:Income.FringeBenefitsReportable.Amount[@contextRef='" + report.iitrParentDocument.RPIneligibleId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730155" },
                        new ProcessMessageParameter() { Name = "IITR491", Value = iitr491.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue([incdtls315] = FALSE, [incdtls314], 0))", Value = sumOfINCDTLS314WhereINCDTLS315IsFalse.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue([incdtls180] = FALSE, [incdtls170], 0))", Value = sumOfINCDTLS170WhereINCDTLS180IsFalse.ToString() }                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730155

        #region VR.ATO.IITR.730164

        /* VR.ATO.IITR.730164
            The Community Development Employment Project (CDEP) amount must equal the sum of all CDEP amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR602 <> NULL AND ^IITR602 <> Sum(^INCDTLS316))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR602 <> NULL AND ^IITR602 <> Sum(^INCDTLS316))

        Data Elements:
    
            ^IITR602 = RP:Income.CommunityDevelopmentEmploymentProject.Amount
    
            ^INCDTLS316 = INCDTLS316
        */

        public static ProcessMessageDocument VR_ATO_IITR_730164(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;


            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // Condition 2: [iitr602] <> NULL
            bool cond2_iitr602IsNotNull = ((report != null && report.iitrParentDocument != null && report.iitrParentDocument.IITR602 != null) ? true : false);

            // Condition 3: [iitr602] <> SUM([incdtls316])
            decimal? sumOfINCDTLS316 = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS316.GetValueOrDefault())) : 0);
            bool cond3_IITR602NotEqualToSumINCDTLS316 = (cond2_iitr602IsNotNull ? (report.iitrParentDocument.IITR602 != sumOfINCDTLS316) : false);

            assertion = (cond2_iitr602IsNotNull && cond3_IITR602NotEqualToSumINCDTLS316);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730164",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Community Development Employment Project (CDEP) amount is incorrect",
                    LongDescription = @"The Community Development Employment Project (CDEP) amount must equal the sum of all CDEP amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.CommunityDevelopmentEmploymentProject.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730164" },
                        new ProcessMessageParameter() { Name = "iitr602", Value = (cond2_iitr602IsNotNull ? report.iitrParentDocument.IITR602.ToString() : "null") },
                        new ProcessMessageParameter() { Name = "SUM([incdtls316])", Value = sumOfINCDTLS316.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730164

        #region VR.ATO.IITR.730165

        /* VR.ATO.IITR.730165
            Where any Community Development Employment Project (CDEP) amounts are present in the attached Income Details schedule, the CDEP amount must be provided

        Legacy Rule Format:
            ^IITR602 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS316, ^INCDTLS316 <> NULL)

        Technical Business Rule Format:
            ^IITR602 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS316, ^INCDTLS316 <> NULL)

        Data Elements:
    
            ^IITR602 = RP:Income.CommunityDevelopmentEmploymentProject.Amount
    
            ^INCDTLS316 = INCDTLS316
        */

        public static ProcessMessageDocument VR_ATO_IITR_730165(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;


            // Condition 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been checked outside the IF statement in which this function has been called.

            // Condition 2: [iitr602] = NULL
            bool cond2_iitr602IsNull = ((report != null && report.iitrParentDocument != null) ? ((report.iitrParentDocument.IITR602 == null) ? true : false) : true);

            // Condition 3: ANY OCCURRENCE OF([incdtls316]) <> NULL
            bool cond3_AnyOccurrenceOfINCDTLS316NotNull = (incdtlschilddoc != null ? (incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS316 != null) : false) : false);

            assertion = (cond2_iitr602IsNull && cond3_AnyOccurrenceOfINCDTLS316NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730165",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Community Development Employment Project (CDEP) amount must be provided",
                    LongDescription = @"Where any Community Development Employment Project (CDEP) amounts are present in the attached Income Details schedule, the CDEP amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.CommunityDevelopmentEmploymentProject.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730165" },
                    new ProcessMessageParameter() { Name = "iitr602", Value = (cond2_iitr602IsNull ? "null" : report.iitrParentDocument.IITR602.ToString()) },
                    new ProcessMessageParameter() { Name = "Any Occurrences of INCDTLS316 are not equal to null", Value = cond3_AnyOccurrenceOfINCDTLS316NotNull.ToString() },
                    },

                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730165

        #region VR.ATO.IITR.730175

        /* VR.ATO.IITR.730175
            Where any Salary or wages lump sum A tax withheld amounts are present in the attached Income Details schedule, the Salary or wages lump sum A tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR606 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS320, ^INCDTLS320 <> NULL)

        Technical Business Rule Format:
            ^IITR606 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS320, ^INCDTLS320 <> NULL)

        Data Elements:
    
            ^IITR606 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^INCDTLS320 = INCDTLS320
        */

        public static ProcessMessageDocument VR_ATO_IITR_730175(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool isIITR606Null = (report.iitrParentDocument.IITR606 == null);

            bool anyOccurrenceOfINCDTLS320NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS320 != null) : false);

            assertion = (isIITR606Null && anyOccurrenceOfINCDTLS320NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730175",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum A tax withheld amount must be provided",
                    LongDescription = @"Where any Salary or wages lump sum A tax withheld amounts are present in the attached Income Details schedule, the Salary or wages lump sum A tax withheld amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730175" },
                    new ProcessMessageParameter() { Name = "IITR606", Value = (isIITR606Null ? "null" : report.iitrParentDocument.IITR606.ToString()) },
                    new ProcessMessageParameter() { Name = "Any Occurrences of INCDTLS320 are not equal to null", Value = anyOccurrenceOfINCDTLS320NotNull.ToString() },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730175

        #region VR.ATO.IITR.730176

        /* VR.ATO.IITR.730176
            The Salary or wages lump sum A tax withheld amount must equal the sum of all Salary or wages lump sum A tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR606 <> NULL AND ^IITR606 <> Sum(^INCDTLS320)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR606 <> NULL AND ^IITR606 <> Sum(^INCDTLS320)

        Data Elements:
    
            ^IITR606 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^INCDTLS320 = INCDTLS320
        */

        public static ProcessMessageDocument VR_ATO_IITR_730176(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // SUM([incdtls320])
            decimal sumOfINCDTLS320 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS320 = incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS320 != null).Sum(tuple => tuple.INCDTLS320.GetValueOrDefault());
            }

            assertion = report.iitrParentDocument.IITR606 != null && report.iitrParentDocument.IITR606 != sumOfINCDTLS320;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730176",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum A tax withheld amount is incorrect",
                    LongDescription = @"The Salary or wages lump sum A tax withheld amount must equal the sum of all Salary or wages lump sum A tax withheld amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730176" },
                    new ProcessMessageParameter() { Name = "IITR606", Value = report.iitrParentDocument.IITR606.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "Sum of INCDTLS320", Value = sumOfINCDTLS320.ToString() } },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730176

        #region VR.ATO.IITR.730177

        /* VR.ATO.IITR.730177
            Where any Salary or wages lump sum A or Foreign employment income lump sum A amounts are present in the attached Income Details schedule, the Salary or wages lump sum A amount must be provided

        Legacy Rule Format:
            ^IITR607 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS321, ^INCDTLS321 <> NULL) OR AnyOccurrence(^INCDTLS174, ^INCDTLS174 <> NULL))

        Technical Business Rule Format:
            ^IITR607 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS321, ^INCDTLS321 <> NULL) OR AnyOccurrence(^INCDTLS174, ^INCDTLS174 <> NULL))

        Data Elements:
    
            ^IITR607 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^INCDTLS174 = INCDTLS174
    
            ^INCDTLS321 = INCDTLS321
        */

        public static ProcessMessageDocument VR_ATO_IITR_730177(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool isIITR607Null = (report.iitrParentDocument.IITR607 == null);
            bool anyOccurrenceOfINCDTLS321or174NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS321.HasValue || tuple.INCDTLS174.HasValue) : false);

            bool assertion = (isIITR607Null && anyOccurrenceOfINCDTLS321or174NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730177",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum A amount must be provided",
                    LongDescription = @"Where any Salary or wages lump sum A or Foreign employment income lump sum A amounts are present in the attached Income Details schedule, the Salary or wages lump sum A amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730177" },
                    new ProcessMessageParameter() { Name = "IITR607", Value = "null" },
                    new ProcessMessageParameter() { Name = "Any Occurrence of INCDTLS321 or INCDTLS174 is not equal to null", Value = "true" },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730177

        #region VR.ATO.IITR.730178

        /* VR.ATO.IITR.730178
            The Salary or wages lump sum A amount must equal; the sum of all Salary or wages lump sum A amounts, plus the sum of all Foreign employment income lump sum A amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR607 <> NULL AND ^IITR607 <> (RoundDown(Sum(^INCDTLS321),0) + RoundDown(Sum(^INCDTLS174),0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR607 <> NULL AND ^IITR607 <> (RoundDown(Sum(^INCDTLS321),0) + RoundDown(Sum(^INCDTLS174),0))

        Data Elements:
    
            ^IITR607 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^INCDTLS174 = INCDTLS174
    
            ^INCDTLS321 = INCDTLS321
        */

        public static ProcessMessageDocument VR_ATO_IITR_730178(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // SUM([incdtls321])
            decimal sumOfINCDTLS321 = 0;
            // SUM([incdtls174])
            decimal sumOfINCDTLS174 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS321 = Math.Truncate(incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS321.GetValueOrDefault()));
                sumOfINCDTLS174 = Math.Truncate(incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS174.GetValueOrDefault()));
            }

            bool assertion = report.iitrParentDocument.IITR607 != null && report.iitrParentDocument.IITR607 != (sumOfINCDTLS321 + sumOfINCDTLS174);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730178",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum A amount is incorrect",
                    LongDescription = @"The Salary or wages lump sum A amount must equal; the sum of all Salary or wages lump sum A amounts, plus the sum of all Foreign employment income lump sum A amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730178" },
                    new ProcessMessageParameter() { Name = "IITR607", Value = report.iitrParentDocument.IITR607.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "RoundDown(Sum(INCDTLS321)) + RoundDown(Sum(INCDTLS174))", Value = (sumOfINCDTLS321 + sumOfINCDTLS174).ToString() } },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730178

        #region VR.ATO.IITR.730179

        /* VR.ATO.IITR.730179
            Where any Salary or wages lump sum B tax withheld amounts are present in the attached Income Details schedule, the Salary or wages lump sum B tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR608 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS323, ^INCDTLS323 <> NULL)

        Technical Business Rule Format:
            ^IITR608 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS323, ^INCDTLS323 <> NULL)

        Data Elements:
    
            ^IITR608 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^INCDTLS323 = INCDTLS323
        */

        public static ProcessMessageDocument VR_ATO_IITR_730179(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;


            bool isIITR608Null = (report.iitrParentDocument.IITR608 == null);
            bool anyOccurrenceOfINCDTLS323NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS323 != null) : false);

            assertion = (isIITR608Null && anyOccurrenceOfINCDTLS323NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730179",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum B tax withheld amount must be provided",
                    LongDescription = @"Where any Salary or wages lump sum B tax withheld amounts are present in the attached Income Details schedule, the Salary or wages lump sum B tax withheld amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730179" },
                    new ProcessMessageParameter() { Name = "IITR608", Value = (isIITR608Null ? "null" : report.iitrParentDocument.IITR608.ToString()) },
                    new ProcessMessageParameter() { Name = "Any Occurrences of INCDTLS323 are not equal to null", Value = anyOccurrenceOfINCDTLS323NotNull.ToString() },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730179

        #region VR.ATO.IITR.730180

        /* VR.ATO.IITR.730180
            The Salary or wages lump sum B tax withheld amount must equal the sum of all Salary or wages lump sum B tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR608 <> NULL AND ^IITR608 <> Sum(^INCDTLS323)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR608 <> NULL AND ^IITR608 <> Sum(^INCDTLS323)

        Data Elements:
    
            ^IITR608 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^INCDTLS323 = INCDTLS323
        */

        public static ProcessMessageDocument VR_ATO_IITR_730180(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // SUM([incdtls323])
            decimal sumOfINCDTLS323 = 0;

            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS323 = incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS323 != null).Sum(tuple => tuple.INCDTLS323.GetValueOrDefault());
            }

            assertion = report.iitrParentDocument.IITR608 != null && report.iitrParentDocument.IITR608 != sumOfINCDTLS323;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730180",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum B tax withheld amount is incorrect",
                    LongDescription = @"The Salary or wages lump sum B tax withheld amount must equal the sum of all Salary or wages lump sum B tax withheld amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730180" },
                    new ProcessMessageParameter() { Name = "IITR608", Value = report.iitrParentDocument.IITR608.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "Sum of INCDTLS323", Value = sumOfINCDTLS323.ToString() } },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730180

        #region VR.ATO.IITR.730181

        /* VR.ATO.IITR.730181
            Where any Salary or wages lump sum B amounts are present in the attached Income Details schedule, the Salary or wages lump sum B amount must be provided

        Legacy Rule Format:
            ^IITR609 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS324, ^INCDTLS324 <> NULL)

        Technical Business Rule Format:
            ^IITR609 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS324, ^INCDTLS324 <> NULL)

        Data Elements:
    
            ^IITR609 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^INCDTLS324 = INCDTLS324
        */

        public static ProcessMessageDocument VR_ATO_IITR_730181(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;


            bool isIITR609Null = (report.iitrParentDocument.IITR609 == null);
            bool anyOccurrenceOfINCDTLS324NotNull = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS324 != null) : false);

            assertion = (isIITR609Null && anyOccurrenceOfINCDTLS324NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730181",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum B amount must be provided",
                    LongDescription = @"Where any Salary or wages lump sum B amounts are present in the attached Income Details schedule, the Salary or wages lump sum B amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730181" },
                    new ProcessMessageParameter() { Name = "IITR609", Value = (isIITR609Null ? "null" : report.iitrParentDocument.IITR609.ToString()) },
                    new ProcessMessageParameter() { Name = "Any Occurrences of INCDTLS324 are not equal to null", Value = anyOccurrenceOfINCDTLS324NotNull.ToString() },},
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730181

        #region VR.ATO.IITR.730182

        /* VR.ATO.IITR.730182
            The Salary or wages lump sum B amount must equal the sum of all Salary or wages lump sum B amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR609 <> NULL AND ^IITR609 <> RoundDown(Sum(^INCDTLS324),0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR609 <> NULL AND ^IITR609 <> RoundDown(Sum(^INCDTLS324),0)

        Data Elements:
    
            ^IITR609 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^INCDTLS324 = INCDTLS324
        */

        public static ProcessMessageDocument VR_ATO_IITR_730182(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // SUM([incdtls324])
            decimal sumOfINCDTLS324 = 0;


            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                sumOfINCDTLS324 = Math.Truncate(incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS324 != null).Sum(tuple => tuple.INCDTLS324.GetValueOrDefault()));
            }

            assertion = report.iitrParentDocument.IITR609 != null && report.iitrParentDocument.IITR609 != sumOfINCDTLS324;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730182",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages lump sum B amount is incorrect",
                    LongDescription = @"The Salary or wages lump sum B amount must equal the sum of all Salary or wages lump sum B amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730182" },
                    new ProcessMessageParameter() { Name = "IITR609", Value = report.iitrParentDocument.IITR609.GetValueOrDefault().ToString() },
                    new ProcessMessageParameter() { Name = "Sum of INCDTLS324", Value = sumOfINCDTLS324.ToString() } },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730182

        #region VR.ATO.IITR.730183

        /* VR.ATO.IITR.730183
            Where an Australian Superannuation Lump Sum Payment that is not a death benefit is paid on or after the lodger's 60th birthday the relevant SLS taxed element must not be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND AnyOccurrence(^INCDTLS328, ^INCDTLS328 > = ConvertToDate(Day(^IITR29), MonthAsInt(^IITR29),  Year(^IITR29) + 60) WHERE ((^INCDTLS330 > 0) AND (^INCDTLS333 = FALSE)))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND AnyOccurrence(^INCDTLS328, ^INCDTLS328 > = ConvertToDate(Day(^IITR29), MonthAsInt(^IITR29),  Year(^IITR29) + 60) WHERE ((^INCDTLS330 > 0) AND (^INCDTLS333 = FALSE)))

        Data Elements:
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
    
            ^INCDTLS328 = INCDTLS328
    
            ^INCDTLS330 = INCDTLS330
    
            ^INCDTLS333 = INCDTLS333
        */

        public static ProcessMessageDocument VR_ATO_IITR_730183(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Only attempt to fire the Validation rule if IITR29 exists
            if (report.iitrParentDocument.IITR29 != null)
            {
                // CONDITION 1: (COUNT(SCHEDULE = "INCDTLS") = 1)
                // This has already been determined in the IF statement which surrounds the call to this validation rule.

                // Get the DateTime of iitr29 and add 60 years to it.
                DateTime? iitr29Plus60Years = report.iitrParentDocument.IITR29.Value.AddYears(60);

                // CONDITION 2: If there's at least one SuperannuationLumpSumPayment tuple, then check if any occurrence of INCDTLS328 >= IITR29 where INCDTLS330 > 0 and INCDTLS333 = false:
                bool cond2_incdtls328GreaterThaniitr29Plus60 = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null && incdtlschilddoc.Rp_IncomeCollection.Count > 0) ? incdtlschilddoc.Rp_IncomeCollection.Any(tuple => ((tuple.INCDTLS328 >= iitr29Plus60Years) && (tuple.INCDTLS330 > 0 && tuple.INCDTLS333 == false))) : false);

                assertion = cond2_incdtls328GreaterThaniitr29Plus60;
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730183",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"An SLS taxed element must not be provided",
                        LongDescription = @"Where an Australian Superannuation Lump Sum Payment that is not a death benefit is paid on or after the lodger's 60th birthday the relevant SLS taxed element must not be provided",
                        Location = "/xbrli:xbrl/tns:PersonDemographicDetails.Birth.Date[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters() {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730183" },
                            new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29 != null ? report.iitrParentDocument.IITR29.ToString() : "null" },
                            new ProcessMessageParameter() { Name = "Any INCDTLS328 greater than " + report.iitrParentDocument.IITR29.Value.AddYears(60).ToString() + " where (INCDTLS330 > 0 and INCDTLS333 = false): ", Value = cond2_incdtls328GreaterThaniitr29Plus60.ToString() },
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730183

        #region VR.ATO.IITR.730184

        /* VR.ATO.IITR.730184
            Where any Superannuation lump sum tax withheld amounts are present in the attached Income Details schedule, the Superannuation lump sum tax withheld amount must be provided

        Legacy Rule Format:
            ^IITR610 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS329, ^INCDTLS329 <> NULL)

        Technical Business Rule Format:
            ^IITR610 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS329, ^INCDTLS329 <> NULL)

        Data Elements:
    
            ^IITR610 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount
    
            ^INCDTLS329 = INCDTLS329
        */

        public static ProcessMessageDocument VR_ATO_IITR_730184(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: Determine whether [iitr610] = NULL.
            bool cond1_iitr610IsNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR610 == null) ? true : false);

            // CONDITION 2: COUNT(SCHEDULE = "INCDTLS") = 1 
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // Only process the remainder of the rule if we know that Condition 1 is true
            if (cond1_iitr610IsNull)
            {
                // CONDITION 3: ANY OCCURRENCE OF([incdtls329]) <> NULL
                bool cond3_anyOccurrenceOfINCDTLS329NotNull = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS329 != null)) : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_anyOccurrenceOfINCDTLS329NotNull);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730184",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum tax withheld amount must be provided",
                        LongDescription = @"Where any Superannuation lump sum tax withheld amounts are present in the attached Income Details schedule, the Superannuation lump sum tax withheld amount must be provided",
                        Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730184" },
                        new ProcessMessageParameter() { Name = "IITR610", Value = report.iitrParentDocument.IITR610 == null ? "null" : report.iitrParentDocument.IITR610.Value.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls329]) <> NULL", Value = cond3_anyOccurrenceOfINCDTLS329NotNull.ToString() },
                    },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730184

        #region VR.ATO.IITR.730185

        /* VR.ATO.IITR.730185
            The Superannuation lump sum tax withheld amount must equal the sum of all Superannuation lump sum tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR610 <> NULL AND ^IITR610 <> Sum(^INCDTLS329)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR610 <> NULL AND ^IITR610 <> Sum(^INCDTLS329)

        Data Elements:
    
            ^IITR610 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount
    
            ^INCDTLS329 = INCDTLS329
        */

        public static ProcessMessageDocument VR_ATO_IITR_730185(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: COUNT(SCHEDULE = "INCDTLS") = 1 
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // CONDITION 2: Determine if [iitr610] <> NULL
            bool cond2_iitr610IsNotNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR610 == null) ? false : true);

            // Only process the remainder of the rule if we know that condition 2 is true.
            if (cond2_iitr610IsNotNull)
            {
                // Get the sum of all INCDTLS329 elements from all tuples where it exists
                decimal sumIncdtls329 = (incdtlschilddoc.Rp_IncomeCollection == null ? 0 : (incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS329 != null).Sum(tuple => tuple.INCDTLS329.GetValueOrDefault())));

                // CONDITION 3: [iitr610] <> SUM([incdtls329])
                bool cond3_iitr610NotEqualToSumIncdtls329 = (report.iitrParentDocument.IITR610 != sumIncdtls329 ? true : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_iitr610NotEqualToSumIncdtls329);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730185",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum tax withheld amount is incorrect",
                        LongDescription = @"The Superannuation lump sum tax withheld amount must equal the sum of all Superannuation lump sum tax withheld amounts provided in the attached Income Details schedule",
                        Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730185" },
                            new ProcessMessageParameter() { Name = "IITR610", Value = cond2_iitr610IsNotNull ? report.iitrParentDocument.IITR610.Value.ToString() : "null" },
                            new ProcessMessageParameter() { Name = "SUM([incdtls329])", Value = sumIncdtls329.ToString() },
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730185

        #region VR.ATO.IITR.730186

        /* VR.ATO.IITR.730186
            Where any Superannuation lump sum taxed elements are present in the attached Income Details schedule, the Superannuation lump sum taxed element must be provided

        Legacy Rule Format:
            ^IITR611 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 <> NULL)

        Technical Business Rule Format:
            ^IITR611 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 <> NULL)

        Data Elements:
    
            ^IITR611 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount
    
            ^INCDTLS330 = INCDTLS330
        */

        public static ProcessMessageDocument VR_ATO_IITR_730186(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: Determine whether [iitr611] = NULL .
            bool cond1_iitr611IsNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR611 == null) ? true : false);

            // CONDITION 2: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // Only process the remainder of the rule if we know that Condition 1 is true.
            if (cond1_iitr611IsNull)
            {
                // CONDITION 3: ANY OCCURRENCE OF([incdtls330]) <> NULL
                bool cond3_anyOccurrenceOfINCDTLS330NotNull = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS330 != null)) : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_anyOccurrenceOfINCDTLS330NotNull);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730186",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum taxed element must be provided",
                        LongDescription = @"Where any Superannuation lump sum taxed elements are present in the attached Income Details schedule, the Superannuation lump sum taxed element must be provided",
                        Location = "/xbrli:xbrl/tns:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730186" },
                            new ProcessMessageParameter() { Name = "IITR611", Value = cond1_iitr611IsNull ? "null" : report.iitrParentDocument.IITR611.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls330]) <> NULL", Value = cond3_anyOccurrenceOfINCDTLS330NotNull.ToString() }
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730186

        #region VR.ATO.IITR.730187

        /* VR.ATO.IITR.730187
            The Superannuation lump sum taxed element must equal the sum of all Superannuation lump sum taxed elements in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR611 <> NULL AND ^IITR611 <> Sum(^INCDTLS330)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR611 <> NULL AND ^IITR611 <> Sum(^INCDTLS330)

        Data Elements:
    
            ^IITR611 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount
    
            ^INCDTLS330 = INCDTLS330
        */

        public static ProcessMessageDocument VR_ATO_IITR_730187(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // CONDITION 2: Determine if [iitr611] <> NULL
            bool cond2_iitr611IsNotNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR611 == null) ? false : true);

            // Only process the remainder of the rule if we know that Condition 2 is true.
            if (cond2_iitr611IsNotNull)
            {
                // Get the sum of all INCDTLS330 elements from all tuples where it exists
                decimal sumIncdtls330 = (incdtlschilddoc.Rp_IncomeCollection == null ? 0 : (incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS330 != null).Sum(tuple => tuple.INCDTLS330.GetValueOrDefault())));

                // CONDITION 3: [iitr611] <> SUM([incdtls330])
                bool cond3_iitr611NotEqualToSumIncdtls330 = (report.iitrParentDocument.IITR611 != sumIncdtls330 ? true : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_iitr611NotEqualToSumIncdtls330);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730187",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum taxed element is incorrect",
                        LongDescription = @"The Superannuation lump sum taxed element must equal the sum of all Superannuation lump sum taxed elements in the attached Income Details schedule",
                        Location = "/xbrli:xbrl/tns:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730187" },
                            new ProcessMessageParameter() { Name = "IITR611", Value = cond2_iitr611IsNotNull ? report.iitrParentDocument.IITR611.Value.ToString() : "null" },
                            new ProcessMessageParameter() { Name = "SUM([incdtls330])", Value = sumIncdtls330.ToString() }
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730187

        #region VR.ATO.IITR.730188

        /* VR.ATO.IITR.730188
            Where any Superannuation lump sum untaxed elements are present in the attached Income Details schedule, the amount of Superannuation lump sum untaxed elements must be provided

        Legacy Rule Format:
            ^IITR612 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS331, ^INCDTLS331 <> NULL)

        Technical Business Rule Format:
            ^IITR612 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS331, ^INCDTLS331 <> NULL)

        Data Elements:
    
            ^IITR612 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS331 = INCDTLS331
        */

        public static ProcessMessageDocument VR_ATO_IITR_730188(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: Determine whether [iitr612] = NULL.
            bool cond1_iitr612IsNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR612 == null) ? true : false);

            // CONDITION 2: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // Only process the remainder of the rule if we know that Condition 1 is true.
            if (cond1_iitr612IsNull)
            {
                // CONDITION 3: ANY OCCURRENCE OF([incdtls331]) <> NULL
                bool cond3_anyOccurrenceOfINCDTLS331NotNull = ((incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null) ? (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS331 != null)) : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_anyOccurrenceOfINCDTLS331NotNull);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730188",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum untaxed element must be provided",
                        LongDescription = @"Where any Superannuation lump sum untaxed elements are present in the attached Income Details schedule, the amount of Superannuation lump sum untaxed elements must be provided",
                        Location = "/xbrli:xbrl/tns:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730188" },
                            new ProcessMessageParameter() { Name = "IITR612", Value = cond1_iitr612IsNull ? "null" : report.iitrParentDocument.IITR612.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls331]) <> NULL", Value = cond3_anyOccurrenceOfINCDTLS331NotNull.ToString() }
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730188

        #region VR.ATO.IITR.730189

        /* VR.ATO.IITR.730189
            The Superannuation lump sum untaxed element must equal the sum of all Superannuation lump sum untaxed elements provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR612 <> NULL AND ^IITR612 <> Sum(^INCDTLS331)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR612 <> NULL AND ^IITR612 <> Sum(^INCDTLS331)

        Data Elements:
    
            ^IITR612 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount
    
            ^INCDTLS331 = INCDTLS331
        */

        public static ProcessMessageDocument VR_ATO_IITR_730189(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // CONDITION 1: COUNT(SCHEDULE = "INCDTLS") = 1
            // This has already been determined in the IF statement which surrounds the call to this validation rule.

            // CONDITION 2: Determine if [iitr612] <> NULL
            bool cond2_iitr612IsNotNull = ((report == null || report.iitrParentDocument == null || report.iitrParentDocument.IITR612 == null) ? false : true);

            // Only process the remainder of the rule if we know that Condition 2 is true.
            if (cond2_iitr612IsNotNull)
            {
                // Get the sum of all INCDTLS331 elements from all tuples where it exists
                decimal sumIncdtls331 = (incdtlschilddoc.Rp_IncomeCollection == null ? 0 : (incdtlschilddoc.Rp_IncomeCollection.FindAll(tuple => tuple.INCDTLS331 != null).Sum(tuple => tuple.INCDTLS331.GetValueOrDefault())));

                // CONDITION 3: [iitr612] <> SUM([incdtls331])
                bool cond3_iitr612NotEqualToSumIncdtls331 = (report.iitrParentDocument.IITR612 != sumIncdtls331 ? true : false);

                // For the assertion we only need to check condition 3 because conditions 1 and 2 have already been checked above.
                assertion = (cond3_iitr612NotEqualToSumIncdtls331);
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730189",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Superannuation lump sum untaxed element is incorrect",
                        LongDescription = @"The Superannuation lump sum untaxed element must equal the sum of all Superannuation lump sum untaxed elements provided in the attached Income Details schedule",
                        Location = "/xbrli:xbrl/tns:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730189" },
                            new ProcessMessageParameter() { Name = "IITR612", Value = cond2_iitr612IsNotNull ? report.iitrParentDocument.IITR612.Value.ToString() : "null" },
                            new ProcessMessageParameter() { Name = "SUM([incdtls331])", Value = sumIncdtls331.ToString() }
                        },
                    };
                }
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730189

        #region VR.ATO.IITR.730190

        /* VR.ATO.IITR.730190
            Where the age of tax payer is less than 55 on 30 June of the reporting period; and Total tax withheld from SLS payments, from the same Payer ABN, is more than the sum of First $1,780,000 of the total SLS untaxed amounts, from the same payer ABN, * 32% (30% SLS rate 3 + 2% Medicare), Plus First $1,780,000 of the total SLS untaxed amounts, from the same payer ABN, above $1,780,000 * 47% (45% SLS rate 4 + 2% Medicare), check Australian superannuation lump sum payments "Tax withheld amount"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 > ConvertToDate(30, 6, (^IITR10 - 55))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.32))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (1780000 * 0.32 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 > ConvertToDate(30, 6, (^IITR10 - 55))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.32))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (1780000 * 0.32 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Data Elements:
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
    
            ^INCDTLS307 = INCDTLS307
    
            ^INCDTLS327 = INCDTLS327
    
            ^INCDTLS329 = INCDTLS329
    
            ^INCDTLS330 = INCDTLS330
    
            ^INCDTLS331 = INCDTLS331
        */
        public static ProcessMessageDocument VR_ATO_IITR_730190(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            DateTime birthDate = report.iitrParentDocument.IITR29 ?? new DateTime();
            
            int targetFinancialYear = report.iitrParentDocument.IITR10.GetValueOrDefault();

            bool individualIsYoungerThan55YearsOld = report.iitrParentDocument.IITR29 != null && report.iitrParentDocument.IITR10 != null ?
                birthDate > new DateTime(targetFinancialYear - 55, 06, 30) : 
                false;

            if (individualIsYoungerThan55YearsOld && incdtlschilddoc.Rp_IncomeCollection != null)
            {
                List<CalculatedABNAmounts> calculatedABNAmounts = CalculatedABNAmounts.GetListOfCalculatedAmountsForEachABN(incdtlschilddoc);

                foreach (INCDTLS2026.Rp_Income incomeTuple in incdtlschilddoc.Rp_IncomeCollection)
                {
                    bool abnExists = !string.IsNullOrEmpty(incomeTuple.INCDTLS307);
                    bool superLumpSumPaymentIsZero = incomeTuple.INCDTLS330.GetValueOrDefault() == 0;

                    if (abnExists && superLumpSumPaymentIsZero)
                    {
                        CalculatedABNAmounts abnAmounts = calculatedABNAmounts
                            .Find(abnAmount => abnAmount.Abn == incomeTuple.INCDTLS307);
                            
                        decimal sumINCDTLS331 = abnAmounts.SumINCDTLS331;
                        decimal sumINCDTLS329 = abnAmounts.SumINCDTLS329;
                            
                        bool cond1 = sumINCDTLS331 <= SlsUntaxedPlanCapThreshold && sumINCDTLS329 > sumINCDTLS331 * 0.32M;
                            
                        bool cond2 = sumINCDTLS331 > SlsUntaxedPlanCapThreshold && 
                            sumINCDTLS329 > SlsUntaxedPlanCapThreshold * 0.32M + (sumINCDTLS331 - SlsUntaxedPlanCapThreshold) * 0.47M;
                            
                        bool assertion = (cond1 || cond2);
                        if (assertion)
                        {
                            ProcessMessageDocument processMessage = new ProcessMessageDocument()
                            {
                                Code = "CMN.ATO.IITR.730190",
                                Severity = ProcessMessageSeverity.Warning,
                                Description = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary.",
                                LongDescription = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary; if payment is from a taxed or untaxed element and taxpayer's age when payment was received.",
                                Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount",
                                Parameters = new ProcessMessageParameters()
                                {
                                    new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730190" },
                                    new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29.GetValueOrDefault().ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS307", Value = incomeTuple.INCDTLS307.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS330 NULL/0", Value = superLumpSumPaymentIsZero.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS331 Sum", Value = sumINCDTLS331.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS329 Sum", Value = sumINCDTLS329.ToString() },

                                },
                            };
                            // The validation rule has been triggered, so return the populated process message to the calling function. (No need to continue looping).
                            return processMessage;
                        }
                    }
                }
            }
            return null;
        }
        #endregion // VR.ATO.IITR.730190

        #region VR.ATO.IITR.730191

        /* VR.ATO.IITR.730191
            Where the age of the tax payer is greater than 60 on 30 June of the reporting period; and Total tax withheld from SLS payments, from the same Payer ABN, is more than the sum of First $1,780,000  of the total SLS untaxed amounts, from the same payer ABN, * 17% (15% SLS rate 1 + 2% Medicare), Plus First $1,780,000 of the total SLS untaxed amounts, from the same payer ABN, above $1,780,000 * 47% (45% SLS rate 4 + 2% Medicare), check Australian superannuation lump sum payments "Tax withheld amount"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 <> NULL AND ^IITR29 <= ConvertToDate(30, 6, (^IITR10 - 60))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.17))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (1780000 * 0.17 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 <> NULL AND ^IITR29 <= ConvertToDate(30, 6, (^IITR10 - 60))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.17))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (1780000 * 0.17 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Data Elements:
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
    
            ^INCDTLS307 = INCDTLS307
    
            ^INCDTLS327 = INCDTLS327
    
            ^INCDTLS329 = INCDTLS329
    
            ^INCDTLS330 = INCDTLS330
    
            ^INCDTLS331 = INCDTLS331
        */
        public static ProcessMessageDocument VR_ATO_IITR_730191(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            DateTime birthDate = report.iitrParentDocument.IITR29 ?? new DateTime();
            int targetFinancialYear = report.iitrParentDocument.IITR10.GetValueOrDefault();

            bool individualIsOlderThan60YearsOld = report.iitrParentDocument.IITR29 != null && report.iitrParentDocument.IITR10 != null ?
                birthDate <= new DateTime(targetFinancialYear - 60, 06, 30) :
                false;

            if (individualIsOlderThan60YearsOld && incdtlschilddoc.Rp_IncomeCollection != null)
            {
                List<CalculatedABNAmounts> calculatedABNAmounts = CalculatedABNAmounts.GetListOfCalculatedAmountsForEachABN(incdtlschilddoc);

                foreach (INCDTLS2026.Rp_Income incomeTuple in incdtlschilddoc.Rp_IncomeCollection)
                {
                    bool abnExists = !string.IsNullOrEmpty(incomeTuple.INCDTLS307);
                    bool lumpSumTaxedElementIsZero = (incomeTuple.INCDTLS330 == null || incomeTuple.INCDTLS330 == 0);

                    if (abnExists && lumpSumTaxedElementIsZero)
                    {
                        CalculatedABNAmounts abnAmounts = calculatedABNAmounts
                            .Find(IterationObject => IterationObject.Abn == incomeTuple.INCDTLS307);
                            
                        decimal sumINCDTLS331 = abnAmounts.SumINCDTLS331;
                        decimal sumINCDTLS329 = abnAmounts.SumINCDTLS329;
                            
                        bool cond1 = sumINCDTLS331 <= SlsUntaxedPlanCapThreshold && sumINCDTLS329 > sumINCDTLS331 * 0.17M;

                        bool cond2 = sumINCDTLS331 > SlsUntaxedPlanCapThreshold &&
                            sumINCDTLS329 > SlsUntaxedPlanCapThreshold * 0.17M + (sumINCDTLS331 - SlsUntaxedPlanCapThreshold) * 0.47M;
                            
                        bool assertion = (cond1 || cond2);
                        if (assertion)
                        {
                            ProcessMessageDocument processMessage = new ProcessMessageDocument()
                            {
                                Code = "CMN.ATO.IITR.730191",
                                Severity = ProcessMessageSeverity.Warning,
                                Description = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary.",
                                LongDescription = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary; if payment is from a taxed or untaxed element and taxpayer's age when payment was received.",
                                Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount",
                                Parameters = new ProcessMessageParameters()
                                {
                                    new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730191" },
                                    new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29.GetValueOrDefault().ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS307", Value = incomeTuple.INCDTLS307.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS330 NULL/0", Value = lumpSumTaxedElementIsZero.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS331 Sum", Value = sumINCDTLS331.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS329 Sum", Value = sumINCDTLS329.ToString() },
                                },
                            };
                            return processMessage;
                        }
                    }
                }
            }
            return null;
        }
        #endregion // VR.ATO.IITR.730191

        #region VR.ATO.IITR.730192

        /* VR.ATO.IITR.730192
            Where the age of the tax payer is greater than 55 and less than 60 on 30 June of the reporting period; and Total tax withheld from SLS payments, from the same Payer ABN, is more than the sum of First $245,000 of the total SLS untaxed amounts, from the same payer ABN, * 17% (15% sls rate 1 + 2% Medicare), Plus amount between $245,000 and up to $1,780,000 of the total SLS untaxed amounts, from the same payer ABN, * 32% (30% sls rate 3 + 2% Medicare), Plus First $1,780,000 of the total SLS untaxed amounts, from the same payer ABN, above $1,780,000 * 47% (45% sls rate 4 + 2% Medicare), check Australian superannuation lump sum payments "Tax withheld amount"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 > ConvertToDate(30, 6, (^IITR10 - 60))) AND (^IITR29 <= ConvertToDate(30, 6, (^IITR10 - 55))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 245000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.17))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 245000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (245000 * 0.17 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 245000) * 0.32)))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (245000 * 0.17 + (1780000 - 245000) * 0.32 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS327, ^INCDTLS327 <> NULL) AND ((^IITR29 > ConvertToDate(30, 6, (^IITR10 - 60))) AND (^IITR29 <= ConvertToDate(30, 6, (^IITR10 - 55))) AND (^INCDTLS307 <> NULL) AND AnyOccurrence(^INCDTLS330, ^INCDTLS330 = NULL OR ^INCDTLS330 = 0) AND (((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 245000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) * 0.17))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 245000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) <= 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (245000 * 0.17 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 245000) * 0.32)))) OR ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) > 1780000) AND (Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS329,0)) > (245000 * 0.17 + (1780000 - 245000) * 0.32 + ((Sum(ConditionalValue(HasDuplicateValues(^INCDTLS307) WHERE (^INCDTLS330 = NULL OR ^INCDTLS330 = 0),^INCDTLS331,0)) - 1780000) * 0.47))))))

        Data Elements:
    
            ^IITR10 = RP:Report.TargetFinancial.Year
    
            ^IITR29 = RP:PersonDemographicDetails.Birth.Date
    
            ^INCDTLS307 = INCDTLS307
    
            ^INCDTLS327 = INCDTLS327
    
            ^INCDTLS329 = INCDTLS329
    
            ^INCDTLS330 = INCDTLS330
    
            ^INCDTLS331 = INCDTLS331
        */
        public static ProcessMessageDocument VR_ATO_IITR_730192(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            if (incdtlschilddoc.Rp_IncomeCollection != null)
            {
                DateTime birthDate = report.iitrParentDocument.IITR29 ?? new DateTime();
                int targetFinancialYear = report.iitrParentDocument.IITR10.GetValueOrDefault();

                bool individualIsYoungerThan60YearsOld = report.iitrParentDocument.IITR29 != null && report.iitrParentDocument.IITR10 != null ?
                    birthDate > new DateTime(targetFinancialYear - 60, 06, 30) :
                    false;

                bool individualIs55YearsOrOlder = report.iitrParentDocument.IITR29 != null && report.iitrParentDocument.IITR10 != null ?
                    birthDate <= new DateTime(targetFinancialYear - 55, 06, 30) :
                    false;
                
                if (individualIsYoungerThan60YearsOld && individualIs55YearsOrOlder)
                {
                    List<CalculatedABNAmounts> calculatedABNAmounts = CalculatedABNAmounts.GetListOfCalculatedAmountsForEachABN(incdtlschilddoc);
                    
                    foreach (INCDTLS2026.Rp_Income incomeTuple in incdtlschilddoc.Rp_IncomeCollection)
                    {
                        bool abnExists = !string.IsNullOrEmpty(incomeTuple.INCDTLS307);

                        bool lumpSumTaxedElementIsZero = (incomeTuple.INCDTLS330 == null || incomeTuple.INCDTLS330 == 0);
                        if (abnExists && lumpSumTaxedElementIsZero)
                        {
                            CalculatedABNAmounts currentAbn = calculatedABNAmounts
                                .Find(IterationObject => IterationObject.Abn == incomeTuple.INCDTLS307);
                            
                            decimal SumINCDTLS331 = currentAbn.SumINCDTLS331;
                            decimal SumINCDTLS329 = currentAbn.SumINCDTLS329;
                            
                            bool cond1 = SumINCDTLS331 <= SlsLifetimeCapThreshold && SumINCDTLS329 > SumINCDTLS331 * 0.17M;
                            
                            bool cond2 = SumINCDTLS331 > SlsLifetimeCapThreshold && 
                                SumINCDTLS331 <= SlsUntaxedPlanCapThreshold && 
                                SumINCDTLS329 > SlsLifetimeCapThreshold * 0.17M + (SumINCDTLS331 - SlsLifetimeCapThreshold) * 0.32M;
                            
                            bool cond3 = SumINCDTLS331 > SlsUntaxedPlanCapThreshold && 
                                SumINCDTLS329 > SlsLifetimeCapThreshold * 0.17M + (SlsUntaxedPlanCapThreshold - SlsLifetimeCapThreshold) * 0.32M + 
                                    (SumINCDTLS331 - SlsUntaxedPlanCapThreshold) * 0.47M;
                            
                            bool assertion = (cond1 || cond2 || cond3);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.IITR.730192",
                                    Severity = ProcessMessageSeverity.Warning,
                                    Description = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary.",
                                    LongDescription = @"Check the Tax Withheld amount matches Total tax Withheld from the PAYG SLS summary; if payment is from a taxed or untaxed element and taxpayer's age when payment was received.",
                                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount",
                                    Parameters = new ProcessMessageParameters()
                                {
                                    new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730192" },
                                    new ProcessMessageParameter() { Name = "IITR29", Value = report.iitrParentDocument.IITR29.GetValueOrDefault().ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS307", Value = incomeTuple.INCDTLS307.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS330 NULL/0", Value = lumpSumTaxedElementIsZero.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS331 Sum", Value = SumINCDTLS331.ToString() },
                                    new ProcessMessageParameter() { Name = "INCDTLS329 Sum", Value = SumINCDTLS329.ToString() },
                                },
                                };
                                return processMessage;
                            }
                        }
                    }
                }
            }
            return null;
        }
        #endregion // VR.ATO.IITR.730192

        #region VR.ATO.IITR.730193

        /* VR.ATO.IITR.730193
            The Tax withheld from attributed personal services income amount must equal the sum of all Attributed PSI tax withheld amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR111 <> NULL AND ^IITR111 <> Sum(^INCDTLS341))

        Technical Business Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR111 <> NULL AND ^IITR111 <> Sum(^INCDTLS341))

        Data Elements:
    
            ^IITR111 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount
    
            ^INCDTLS341 = INCDTLS341
        */

        public static ProcessMessageDocument VR_ATO_IITR_730193(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // SUM([incdtls341])
            decimal sumOfINCDTLS341 = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumOfINCDTLS341 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS341.GetValueOrDefault());

            assertion = report.iitrParentDocument.IITR111 != null && report.iitrParentDocument.IITR111 != sumOfINCDTLS341;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730193",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from attributed personal services income amount is incorrect",
                    LongDescription = @"The Tax withheld from attributed personal services income amount must equal the sum of all Attributed PSI tax withheld amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730193" },
                        new ProcessMessageParameter() { Name = "IITR111", Value = report.iitrParentDocument.IITR111.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS341])", Value = sumOfINCDTLS341.ToString() }
                    },
                };

            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730193

        #region VR.ATO.IITR.730194

        /* VR.ATO.IITR.730194
            Where any Attributed PSI tax withheld amounts are present in the attached Income Details schedule, the Tax withheld from attributed personal services income amount must be provided

        Legacy Rule Format:
            ^IITR111 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS341, ^INCDTLS341 <> NULL)

        Technical Business Rule Format:
            ^IITR111 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS341, ^INCDTLS341 <> NULL)

        Data Elements:
    
            ^IITR111 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount
    
            ^INCDTLS341 = INCDTLS341
        */
        public static ProcessMessageDocument VR_ATO_IITR_730194(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // ANY OCCURRENCE OF([incdtls341]) <> NULL
            bool anyOccurence341IsNotNull = false;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                anyOccurence341IsNotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS341 != null);

            assertion = report.iitrParentDocument.IITR111 == null && anyOccurence341IsNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730194",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from attributed personal services income amount must be provided",
                    LongDescription = @"Where any Attributed PSI tax withheld amounts are present in the attached Income Details schedule, the Tax withheld from attributed personal services income amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730194" },
                        new ProcessMessageParameter() { Name = "IITR111", Value = report.iitrParentDocument.IITR111.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS341]) <> NULL", Value = anyOccurence341IsNotNull.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730194

        #region VR.ATO.IITR.730195

        /* VR.ATO.IITR.730195
            The Attributed personal services income amount must equal the sum of all Attributed PSI gross amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR112 <> NULL AND ^IITR112 <> Sum(^INCDTLS342))

        Technical Business Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR112 <> NULL AND ^IITR112 <> Sum(^INCDTLS342))

        Data Elements:
    
            ^IITR112 = RP:Income.PersonalServicesIncome.Total.Amount
    
            ^INCDTLS342 = INCDTLS342
        */

        public static ProcessMessageDocument VR_ATO_IITR_730195(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // SUM([incdtls342])
            decimal sumOfINCDTLS342 = 0;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                sumOfINCDTLS342 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS342.GetValueOrDefault());

            assertion = report.iitrParentDocument.IITR112 != null && report.iitrParentDocument.IITR112 != sumOfINCDTLS342;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730195",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Attributed personal services income amount is incorrect",
                    LongDescription = @"The Attributed personal services income amount must equal the sum of all Attributed PSI gross amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.Total.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730195" },
                        new ProcessMessageParameter() { Name = "IITR112", Value = report.iitrParentDocument.IITR112.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS342])", Value = sumOfINCDTLS342.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730195

        #region VR.ATO.IITR.730196

        /* VR.ATO.IITR.730196
            Where any Attributed PSI gross amounts are present in the attached Income Details schedule, the Attributed personal services income amount must be provided

        Legacy Rule Format:
            ^IITR112 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS342, ^INCDTLS342 <> NULL)

        Technical Business Rule Format:
            ^IITR112 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS342, ^INCDTLS342 <> NULL)

        Data Elements:
    
            ^IITR112 = RP:Income.PersonalServicesIncome.Total.Amount
    
            ^INCDTLS342 = INCDTLS342
        */

        public static ProcessMessageDocument VR_ATO_IITR_730196(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // ANY OCCURRENCE OF([incdtls342]) <> NULL
            bool anyOccurence342IsNotNull = false;
            if (incdtlschilddoc.Rp_IncomeCollection != null)
                anyOccurence342IsNotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS342 != null);

            assertion = report.iitrParentDocument.IITR112 == null && anyOccurence342IsNotNull;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730196",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Attributed personal services income amount must be provided",
                    LongDescription = @"Where any Attributed PSI gross amounts are present in the attached Income Details schedule, the Attributed personal services income amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.Total.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730196" },
                        new ProcessMessageParameter() { Name = "IITR112", Value = report.iitrParentDocument.IITR112.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS342]) <> NULL", Value = anyOccurence342IsNotNull.ToString() }
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730196

        #region VR.ATO.IITR.730197

        /* VR.ATO.IITR.730197
            The Dividends - Unfranked amount must equal the sum of the following amounts on the Income Details schedule, where the Country of residence when the dividend was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands": all Total unfranked amounts from dividends for individually owned accounts; and all Your share of unfranked amounts from dividends for joint accounts

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR118 <> NULL AND ^IITR118 <> RoundDown(Sum(ConditionalValue((^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS347 = 1, ^INCDTLS371, ^INCDTLS378), 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR118 <> NULL AND ^IITR118 <> RoundDown(Sum(ConditionalValue((^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS347 = 1, ^INCDTLS371, ^INCDTLS378), 0)), 0)

        Data Elements:
    
            ^IITR118 = RP:Income.DividendsUnfranked.Amount
    
            ^INCDTLS347 = INCDTLS347
    
            ^INCDTLS348 = INCDTLS348
    
            ^INCDTLS371 = INCDTLS371
    
            ^INCDTLS378 = INCDTLS378
        */

        public static ProcessMessageDocument VR_ATO_IITR_730197(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            // This condition also checks for the Australian Country codes
            decimal conditionalSumINCDTLS371_or_INCDTLS378 = 0;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
                conditionalSumINCDTLS371_or_INCDTLS378 = Math.Truncate(incdtlschilddoc.Rp_DividendsCollection.Where(f => (f.INCDTLS348 == null || australianCountryCodes.Contains(f.INCDTLS348))).Sum(f => f.INCDTLS347 == 1 ? f.INCDTLS371.GetValueOrDefault() : f.INCDTLS378.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR118 != null && (report.iitrParentDocument.IITR118 != conditionalSumINCDTLS371_or_INCDTLS378));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730197",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Unfranked amount is incorrect",
                    LongDescription = "The Dividends - Unfranked amount must equal the sum of the following amounts on the Income Details schedule, where the Country of residence when the dividend was paid or credited is \"Australia\", \"Christmas Island\", \"Norfolk Island\", \"Cocos(Keeling) Islands\" or \"Heard and McDonald Islands\": all Total unfranked amounts from dividends for individually owned accounts; and all Your share of unfranked amounts from dividends for joint accounts",
                    Location = "/xbrli:xbrl/tns:Income.DividendsUnfranked.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730197" },
                        new ProcessMessageParameter() { Name = "IITR118", Value = report.iitrParentDocument.IITR118.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue(([incdtls348] = NULL OR [incdtls348] = SET(\"au\",\"cc\",\"cx\",\"nf\",\"hm\")), ConditionalValue([incdtls347] = 1, [incdtls371], [incdtls378]), 0)), 0)", Value = conditionalSumINCDTLS371_or_INCDTLS378.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730197

        #region VR.ATO.IITR.730198

        /* VR.ATO.IITR.730198
            Where any Dividends unfranked amounts are present where the Country of residence when the dividend was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands" on the Income Details schedule, the Dividends - Unfranked amount must be provided

        Legacy Rule Format:
            ^IITR118 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS371, ^INCDTLS371 <> NULL) WHERE (^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')))

        Technical Business Rule Format:
            ^IITR118 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS371, ^INCDTLS371 <> NULL) WHERE (^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')))

        Data Elements:
    
            ^IITR118 = RP:Income.DividendsUnfranked.Amount
    
            ^INCDTLS348 = INCDTLS348
    
            ^INCDTLS371 = INCDTLS371
        */

        public static ProcessMessageDocument VR_ATO_IITR_730198(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            // Condition 3a also includes a country code check for Australian country codes
            bool Condition3a_INCDTLS371AnyNotNull = false;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
            {
                Condition3a_INCDTLS371AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => (tuple.INCDTLS348 == null || australianCountryCodes.Contains(tuple.INCDTLS348)) && tuple.INCDTLS371 != null));
            }

            bool assertion = (report.iitrParentDocument.IITR118 == null && (Condition3a_INCDTLS371AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730198",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Unfranked amount must be provided",
                    LongDescription = "Where any Dividends unfranked amounts are present where the Country of residence when the dividend was paid or credited is \"Australia\", \"Christmas Island\", \"Norfolk Island\", \"Cocos(Keeling) Islands\" or \"Heard and McDonald Islands\" on the Income Details schedule, the Dividends - Unfranked amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.DividendsUnfranked.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730198" },
                        new ProcessMessageParameter() { Name = "IITR118", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls371]) <> NULL WHERE ([incdtls348] = NULL OR [incdtls348] = SET(\"au\",\"cc\",\"cx\",\"nf\",\"hm\"))", Value = Condition3a_INCDTLS371AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730198

        #region VR.ATO.IITR.730199

        /* VR.ATO.IITR.730199
            The Dividends - Franked amount must equal the sum of all Dividends franked amounts reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR119 <> NULL AND ^IITR119 <> RoundDown(Sum(ConditionalValue(^INCDTLS347 = 1,^INCDTLS372,^INCDTLS379)), 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR119 <> NULL AND ^IITR119 <> RoundDown(Sum(ConditionalValue(^INCDTLS347 = 1,^INCDTLS372,^INCDTLS379)), 0))

        Data Elements:
    
            ^IITR119 = RP:Income.DividendsFranked.Amount
    
            ^INCDTLS347 = INCDTLS347
    
            ^INCDTLS372 = INCDTLS372
    
            ^INCDTLS379 = INCDTLS379
        */

        public static ProcessMessageDocument VR_ATO_IITR_730199(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            decimal conditionalSumINCDTLS372_or_INCDTLS379 = 0;

            if (incdtlschilddoc.Rp_DividendsCollection != null)
                conditionalSumINCDTLS372_or_INCDTLS379 = Math.Truncate(incdtlschilddoc.Rp_DividendsCollection.Sum(f => f.INCDTLS347 == 1 ? f.INCDTLS372.GetValueOrDefault() : f.INCDTLS379.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR119 != null && (report.iitrParentDocument.IITR119 != conditionalSumINCDTLS372_or_INCDTLS379));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730199",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Franked amount is incorrect",
                    LongDescription = "The Dividends - Franked amount must equal the sum of all Dividends franked amounts reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.DividendsFranked.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730199" },
                        new ProcessMessageParameter() { Name = "IITR119", Value = report.iitrParentDocument.IITR119.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue([incdtls347] = 1,[incdtls372],[incdtls379])), 0))", Value = conditionalSumINCDTLS372_or_INCDTLS379.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730199

        #region VR.ATO.IITR.730230

        /* VR.ATO.IITR.730230
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "012" (no ABN quoted), a Business income statement type of "Business" and a Business income statement industry production type of "Primary", then PP - Gross payments where Australian Business Number not quoted must be provided

        Legacy Rule Format:
            ^IITR436 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Technical Business Rule Format:
            ^IITR436 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Data Elements:
    
            ^IITR436 = RP:Income.ABNNotQuotedPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730230(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR436 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730230",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments where Australian Business Number not quoted must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""012"" (no ABN quoted), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Primary"", then PP - Gross payments where Australian Business Number not quoted must be provided",
                    Location = "/xbrli:xbrl/tns:Income.ABNNotQuotedPrimaryProductionPaymentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730230" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730231

        /* VR.ATO.IITR.730231
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "012" (no ABN quoted), a Business income statement type of "Business" and a Business income statement industry production type of "Non-Primary", then Non-PP - Gross payments where Australian Business Number not quoted must be provided

        Legacy Rule Format:
            ^IITR437 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Technical Business Rule Format:
            ^IITR437 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Data Elements:
    
            ^IITR437 = RP:Income.ABNNotQuotedNonPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730231(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR437 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Non-Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730231",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments where Australian Business Number not quoted must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""012"" (no ABN quoted), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Non-Primary"", then Non-PP - Gross payments where Australian Business Number not quoted must be provided",
                    Location = "/xbrli:xbrl/tns:Income.ABNNotQuotedNonPrimaryProductionPaymentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730231" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730232

        /* VR.ATO.IITR.730232
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "011" (foreign resident withholding), and a Business income statement type of "Business", then Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) must be provided

        Legacy Rule Format:
            ^IITR438 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business')

        Technical Business Rule Format:
             ^IITR438 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business')

        Data Elements:
    
            ^IITR438 = RP:Income.ForeignResidentWithholdingNonPrimaryProduction.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730232(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR438 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "011" && tuple.INCDTLS490 == "Business");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730232",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""011"" (foreign resident withholding), and a Business income statement type of ""Business"", then Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) must be provided",
                    Location = "/xbrli:xbrl/tns:Income.ForeignResidentWithholdingNonPrimaryProduction.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730232" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730233

        /* VR.ATO.IITR.730233
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "003" (voluntary agreement), a Business income statement type of "Business" and a Business income statement industry production type of "Primary", then PP -  Gross payments voluntary agreement must be provided

        Legacy Rule Format:
            ^IITR439 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Technical Business Rule Format:
            ^IITR439 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Data Elements:
    
            ^IITR439 = RP:Income.VoluntaryAgreementPrimaryProductionGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730233(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR439 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730233",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments voluntary agreement must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""003"" (voluntary agreement), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Primary"", then PP -  Gross payments voluntary agreement must be provided",
                    Location = "/xbrli:xbrl/tns:Income.VoluntaryAgreementPrimaryProductionGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730233" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730234

        /* VR.ATO.IITR.730234
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "003" (voluntary agreement), a Business income statement type of "Business" and a Business income statement industry production type of "Non-Primary", then Non-PP - Gross payments voluntary agreement must be provided

        Legacy Rule Format:
            ^IITR440 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Technical Business Rule Format:
            ^IITR440 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Data Elements:
    
            ^IITR440 = RP:Income.VoluntaryAgreementNonPrimaryProductionGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730234(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR440 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Non-Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730234",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments voluntary agreement must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""003"" (voluntary agreement), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Non-Primary"", then Non-PP - Gross payments voluntary agreement must be provided",
                    Location = "/xbrli:xbrl/tns:Income.VoluntaryAgreementNonPrimaryProductionGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730234" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730235

        /* VR.ATO.IITR.730235
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "001" (labour hire) or "002" (other specified payments), a Business income statement type of "Business" and a Business income statement industry production type of "Primary", then PP - Gross payments labour hire or other specified payments must be provided

        Legacy Rule Format:
            ^IITR441 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Technical Business Rule Format:
            ^IITR441 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary')

        Data Elements:
    
            ^IITR441 = RP:Income.LabourHireArrangementPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730235(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR441 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && Regex.IsMatch(tuple.INCDTLS489, "^(001|002)$") && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730235",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments labour hire or other specified payments must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""001"" (labour hire) or ""002"" (other specified payments), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Primary"", then PP - Gross payments labour hire or other specified payments must be provided",
                    Location = "/xbrli:xbrl/tns:Income.LabourHireArrangementPrimaryProductionPaymentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730235" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730236

        /* VR.ATO.IITR.730236
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "001" (labour hire) or "002" (other specified payments), a Business income statement type of "Business" and a Business income statement industry production type of "Non-Primary", then Non-PP - Gross payments labour hire or other specified payments must be provided

        Legacy Rule Format:
            ^IITR442 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Technical Business Rule Format:
            ^IITR442 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary')

        Data Elements:
    
            ^IITR442 = RP:Income.LabourHireArrangementNonPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730236(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR442 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && Regex.IsMatch(tuple.INCDTLS489, "^(001|002)$") && tuple.INCDTLS490 == "Business" && tuple.INCDTLS491 == "Non-Primary");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730236",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments labour hire or other specified payments must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""001"" (labour hire) or ""002"" (other specified payments), a Business income statement type of ""Business"" and a Business income statement industry production type of ""Non-Primary"", then Non-PP - Gross payments labour hire or other specified payments must be provided",
                    Location = "/xbrli:xbrl/tns:Income.LabourHireArrangementNonPrimaryProductionPaymentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730236" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730237

        /* VR.ATO.IITR.730237
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "003" (voluntary agreement), and a Business income statement type of "Personal Services", then PSI - voluntary agreement must be provided

        Legacy Rule Format:
            ^IITR411 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
            ^IITR411 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income')

        Data Elements:
    
            ^IITR411 = RP:Income.PersonalServicesIncome.VoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730237(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR411 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Personal Services Income");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730237",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI - voluntary agreement must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""003"" (voluntary agreement), and a Business income statement type of ""Personal Services"", then PSI - voluntary agreement must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.VoluntaryAgreement.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730237" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730238

        /* VR.ATO.IITR.730238
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "012" (no ABN quoted), and a Business income statement type of "Personal Services", then PSI where Australian business number not quoted must be provided

        Legacy Rule Format:
            ^IITR412 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
            ^IITR412 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income')

         Data Elements:

             ^IITR412 = RP:Income.PersonalServicesIncome.ABNNotQuoted.Amount

             ^INCDTLS489 = INCDTLS489

             ^INCDTLS490 = INCDTLS490

             ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730238(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR412 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Personal Services Income");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730238",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI where Australian business number not quoted must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""012"" (no ABN quoted), and a Business income statement type of ""Personal Services"", then PSI where Australian business number not quoted must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.ABNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730238" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730239

        /* VR.ATO.IITR.730239
            Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of "001" (labour hire) or "002" (other specified payments), and a Business income statement type of "Personal Services", then PSI - labour hire or other specified payments must be provided

        Legacy Rule Format:
            ^IITR413 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
            ^IITR413 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS492, ^INCDTLS492 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Personal Services Income')

        Data Elements:
    
            ^IITR413 = RP:Income.PersonalServicesIncome.LabourHireOrOtherSpecifiedPayment.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730239(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR413 == null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null && incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS492 != null && Regex.IsMatch(tuple.INCDTLS489, "^(001|002)$") && tuple.INCDTLS490 == "Personal Services Income");
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730239",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI - labour hire or other specified payments must be provided",
                    LongDescription = @"Where any Business income statement gross payment amount is provided on the attached Income Details schedule with a Business income statement payment type of ""001"" (labour hire) or ""002"" (other specified payments), and a Business income statement type of ""Personal Services"", then PSI - labour hire or other specified payments must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.LabourHireOrOtherSpecifiedPayment.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730239" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730240

        /* VR.ATO.IITR.730240
            Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of "003" (voluntary agreement) and Business income statement type is "Business", then Net income/loss from business tax withheld voluntary agreement must be provided

        Legacy Rule Format:
            ^IITR286 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business')

        Technical Business Rule Format:
            ^IITR286 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business')

        Data Elements:
    
            ^IITR286 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730240(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;
                        
            if (report.iitrParentDocument.IITR286.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Business");

            bool assertion = !report.iitrParentDocument.IITR286.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730240",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld voluntary agreement must be provided",
                    LongDescription = "Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of \"003\" (voluntary agreement) and Business income statement type is \"Business\", then Net income/loss from business tax withheld voluntary agreement must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730240" },
                        new ProcessMessageParameter() { Name = "Any occurence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730241

        /* VR.ATO.IITR.730241
            Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of "012" (no ABN quoted) and Business income statement type is "Business", then Net income/loss from business tax withheld where Australian business number not quoted must be provided

        Legacy Rule Format:
            ^IITR287 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business')

        Technical Business Rule Format:
                ^IITR287 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business')

        Data Elements:
    
            ^IITR287 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessABNNotQuoted.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730241(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR287.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Business");

            bool assertion = !report.iitrParentDocument.IITR287.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730241",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld where Australian business number not quoted must be provided",
                    LongDescription = "Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of \"012\" (no ABN quoted) and Business income statement type is \"Business\", then Net income/loss from business tax withheld where Australian business number not quoted must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessABNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730241" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730242

        /* VR.ATO.IITR.730242
            Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of "011" (foreign resident withholding) and Business income statement type is "Business", then Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) must be provided

        Legacy Rule Format:
            ^IITR288 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business')

        Technical Business Rule Format:
            ^IITR288 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business')

        Data Elements:
    
            ^IITR288 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessForeignResident.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730242(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR288.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && tuple.INCDTLS489 == "011" && tuple.INCDTLS490 == "Business");

            bool assertion = !report.iitrParentDocument.IITR288.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730242",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) must be provided",
                    LongDescription = "Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of \"011\" (foreign resident withholding) and Business income statement type is \"Business\", then Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessForeignResident.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730242" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730243

        /* VR.ATO.IITR.730243
            Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of "001" (labour hire) or "002" (other specified payments) and Business income statement type is "Business", then Net income/loss from business tax withheld - labour hire or other specified payments must be provided

        Legacy Rule Format:
            ^IITR289 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business')

        Technical Business Rule Format:
            ^IITR289 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Business')

        Data Elements:
    
            ^IITR289 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730243(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR289.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && (tuple.INCDTLS489 == "001" || tuple.INCDTLS489 == "002") && tuple.INCDTLS490 == "Business");

            bool assertion = !report.iitrParentDocument.IITR289.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730243",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld - labour hire or other specified payments must be provided",
                    LongDescription = "Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of \"001\" (labour hire) or \"002\" (other specified payments) and Business income statement type is \"Business\", then Net income/loss from business tax withheld - labour hire or other specified payments must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730243" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730244

        /* VR.ATO.IITR.730244
            The Discount from taxed upfront schemes - eligible for reduction amount must equal the sum of all Discount from taxed-upfront schemes eligible for reduction amounts in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR123 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR123 <> Sum(^INCDTLS501))

        Technical Business Rule Format:
            ^IITR123 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR123 <> Sum(^INCDTLS501))

        Data Elements:
    
            ^IITR123 = RP:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount
    
            ^INCDTLS501 = INCDTLS501
        */

        public static ProcessMessageDocument VR_ATO_IITR_730244(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumOfINCDTLS501 = 0;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null)
            {
                sumOfINCDTLS501 = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(tuple => tuple.INCDTLS501.GetValueOrDefault());
            }

            bool assertion = report.iitrParentDocument.IITR123 != null && (report.iitrParentDocument.IITR123.GetValueOrDefault() != sumOfINCDTLS501);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730244",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from taxed upfront schemes - eligible for reduction amount is incorrect",
                    LongDescription = @"The Discount from taxed upfront schemes - eligible for reduction amount must equal the sum of all Discount from taxed-upfront schemes eligible for reduction amounts in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730244" },
                        new ProcessMessageParameter() { Name = "IITR123", Value = report.iitrParentDocument.IITR123.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls501])", Value = sumOfINCDTLS501.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730245

        /* VR.ATO.IITR.730245
            Where any Discount from taxed-upfront schemes eligible for reduction amounts are present in the attached Income Details schedule, the Discount from taxed upfront schemes - eligible for reduction amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR123 = NULL AND AnyOccurrence(^INCDTLS501, ^INCDTLS501 <> NULL)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR123 = NULL AND AnyOccurrence(^INCDTLS501, ^INCDTLS501 <> NULL)

        Data Elements:
    
            ^IITR123 = RP:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount
    
            ^INCDTLS501 = INCDTLS501
        */
        public static ProcessMessageDocument VR_ATO_IITR_730245(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS501AnyNotNull = false;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollectionExists)
                INCDTLS501AnyNotNull = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Any(tuple => tuple.INCDTLS501 != null);

            bool assertion = report.iitrParentDocument.IITR123 == null && incdtlschilddoc.Rp_IncomeCollection != null && INCDTLS501AnyNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730245",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from taxed upfront schemes - eligible for reduction amount must be provided",
                    LongDescription = @"Where any Discount from taxed-upfront schemes eligible for reduction amounts are present in the attached Income Details schedule, the Discount from taxed upfront schemes - eligible for reduction amount must be provided",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730245" },
                        new ProcessMessageParameter() { Name = "IITR123", Value = report.iitrParentDocument.IITR123.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls501]) <> NULL", Value = INCDTLS501AnyNotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730246

        /* VR.ATO.IITR.730246
            The Discount from taxed upfront schemes - not eligible for reduction amount must equal the sum of all Discount from taxed-upfront schemes not eligible for reduction amounts in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR124 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR124 <> Sum(^INCDTLS502))

        Technical Business Rule Format:
            ^IITR124 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR124 <> Sum(^INCDTLS502))

        Data Elements:
    
            ^IITR124 = RP:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount
    
            ^INCDTLS502 = INCDTLS502
        */

        public static ProcessMessageDocument VR_ATO_IITR_730246(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumOfINCDTLS502 = 0;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null)
            {
                sumOfINCDTLS502 = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(tuple => tuple.INCDTLS502.GetValueOrDefault());
            }

            bool assertion = report.iitrParentDocument.IITR124 != null && report.iitrParentDocument.IITR124.GetValueOrDefault() != sumOfINCDTLS502;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730246",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from taxed upfront schemes - not eligible for reduction amount is incorrect",
                    LongDescription = @"The Discount from taxed upfront schemes - not eligible for reduction amount must equal the sum of all Discount from taxed-upfront schemes not eligible for reduction amounts in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730246" },
                        new ProcessMessageParameter() { Name = "IITR124", Value = report.iitrParentDocument.IITR124.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls502])", Value = sumOfINCDTLS502.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730247

        /* VR.ATO.IITR.730247
            Where any Discount from taxed-upfront schemes not eligible for reduction amounts are present in the attached Income Details schedule, the Discount from taxed upfront schemes - not eligible for reduction amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR124 = NULL AND AnyOccurrence(^INCDTLS502, ^INCDTLS502 <> NULL)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR124 = NULL AND AnyOccurrence(^INCDTLS502, ^INCDTLS502 <> NULL)

        Data Elements:
    
            ^IITR124 = RP:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount
    
            ^INCDTLS502 = INCDTLS502
        */

        public static ProcessMessageDocument VR_ATO_IITR_730247(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS502AnyNotNull = false;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollectionExists)
            {
                INCDTLS502AnyNotNull = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Any(tuple => tuple.INCDTLS502 != null);
            }

            bool assertion = report.iitrParentDocument.IITR124 == null && incdtlschilddoc.Rp_IncomeCollection != null && INCDTLS502AnyNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730247",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from taxed upfront schemes - not eligible for reduction amount must be provided",
                    LongDescription = @"Where any Discount from taxed-upfront schemes not eligible for reduction amounts are present in the attached Income Details schedule, the Discount from taxed upfront schemes - not eligible for reduction amount must be provided",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730247" },
                        new ProcessMessageParameter() { Name = "IITR124", Value = report.iitrParentDocument.IITR124.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls502]) <> NULL", Value = INCDTLS502AnyNotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730248

        /* VR.ATO.IITR.730248
            The Discount from deferral schemes amount must equal the sum of all Discount from deferral schemes amounts in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR125 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR125 <> Sum(^INCDTLS503))

        Technical Business Rule Format:
            ^IITR125 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR125 <> Sum(^INCDTLS503))

        Data Elements:
    
            ^IITR125 = RP:Income.EmployeeShareScheme.DeferralDiscount.Amount
    
            ^INCDTLS503 = INCDTLS503
        */

        public static ProcessMessageDocument VR_ATO_IITR_730248(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumOfINCDTLS503 = 0;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null)
                sumOfINCDTLS503 = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(tuple => tuple.INCDTLS503.GetValueOrDefault());

            bool assertion = report.iitrParentDocument.IITR125 != null && report.iitrParentDocument.IITR125.GetValueOrDefault() != sumOfINCDTLS503;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730248",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from deferral schemes amount is incorrect",
                    LongDescription = @"The Discount from deferral schemes amount must equal the sum of all Discount from deferral schemes amounts in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.DeferralDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730248" },
                        new ProcessMessageParameter() { Name = "IITR125", Value = report.iitrParentDocument.IITR125.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls503])", Value = sumOfINCDTLS503.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730249

        /* VR.ATO.IITR.730249
            Where any Discount from deferral schemes amounts are present in the attached Income Details schedule, the Discount from deferral schemes amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR125 = NULL AND AnyOccurrence(^INCDTLS503, ^INCDTLS503 <> NULL)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR125 = NULL AND AnyOccurrence(^INCDTLS503, ^INCDTLS503 <> NULL)

        Data Elements:
    
            ^IITR125 = RP:Income.EmployeeShareScheme.DeferralDiscount.Amount
    
            ^INCDTLS503 = INCDTLS503
        */

        public static ProcessMessageDocument VR_ATO_IITR_730249(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS503AnyNotNull = false;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollectionExists)
            {
                INCDTLS503AnyNotNull = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Any(tuple => tuple.INCDTLS503 != null);
            }

            bool assertion = report.iitrParentDocument.IITR125 == null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Exists(tuple => tuple.INCDTLS503 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730249",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Discount from deferral schemes amount must be provided",
                    LongDescription = @"Where any Discount from deferral schemes amounts are present in the attached Income Details schedule, the Discount from deferral schemes amount must be provided",
                    Location = $"/xbrli:xbrl/tns:Income.EmployeeShareScheme.DeferralDiscount.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730249" },
                        new ProcessMessageParameter() { Name = "IITR125", Value = report.iitrParentDocument.IITR125.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls503]) <> NULL", Value = INCDTLS503AnyNotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730250

        /* VR.ATO.IITR.730250
            Where any Dividends franked amounts are present in the attached Income Details schedule, the Dividends - Franked amount must be provided

        Legacy Rule Format:
            ^IITR119 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS372, ^INCDTLS372 <> NULL) OR AnyOccurrence(^INCDTLS379, ^INCDTLS379 <> NULL))

        Technical Business Rule Format:
            ^IITR119 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS372, ^INCDTLS372 <> NULL) OR AnyOccurrence(^INCDTLS379, ^INCDTLS379 <> NULL))

        Data Elements:
    
            ^IITR119 = RP:Income.DividendsFranked.Amount
    
            ^INCDTLS372 = INCDTLS372
    
            ^INCDTLS379 = INCDTLS379
        */

        public static ProcessMessageDocument VR_ATO_IITR_730250(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3a_INCDTLS372AnyNotNull = false;
            bool Condition3b_INCDTLS379AnyNotNull = false;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
            {
                Condition3a_INCDTLS372AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS372 != null));
                Condition3b_INCDTLS379AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS379 != null));
            }

            bool assertion = (report.iitrParentDocument.IITR119 == null && (Condition3a_INCDTLS372AnyNotNull || Condition3b_INCDTLS379AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730250",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Franked amount must be provided",
                    LongDescription = "Where any Dividends franked amounts are present in the attached Income Details schedule, the Dividends - Franked amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.DividendsFranked.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730250" },
                        new ProcessMessageParameter() { Name = "IITR119", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS372]) <> NULL", Value = Condition3a_INCDTLS372AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS379]) <> NULL", Value = Condition3b_INCDTLS379AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730250

        #region VR.ATO.IITR.730251

        /* VR.ATO.IITR.730251
            The Dividends - Franking credit amount must equal the sum of all Dividends franking credits reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR120 <> NULL AND ^IITR120 <> RoundDown(Sum(ConditionalValue(^INCDTLS347 = 1,^INCDTLS373,^INCDTLS380)), 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR120 <> NULL AND ^IITR120 <> RoundDown(Sum(ConditionalValue(^INCDTLS347 = 1,^INCDTLS373,^INCDTLS380)), 0))

        Data Elements:
    
            ^IITR120 = RP:IncomeTax.FrankingCredits.Amount
    
            ^INCDTLS347 = INCDTLS347
    
            ^INCDTLS373 = INCDTLS373
    
            ^INCDTLS380 = INCDTLS380
        */

        public static ProcessMessageDocument VR_ATO_IITR_730251(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            decimal conditionalSumINCDTLS373_or_INCDTLS380 = 0;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
                conditionalSumINCDTLS373_or_INCDTLS380 = Math.Truncate(incdtlschilddoc.Rp_DividendsCollection.Sum(f => f.INCDTLS347 == 1 ? f.INCDTLS373.GetValueOrDefault() : f.INCDTLS380.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR120 != null && (report.iitrParentDocument.IITR120 != conditionalSumINCDTLS373_or_INCDTLS380));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730251",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Franking credit is incorrect",
                    LongDescription = "The Dividends - Franking credit amount must equal the sum of all Dividends franking credits reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.FrankingCredits.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730251" },
                        new ProcessMessageParameter() { Name = "IITR120", Value = report.iitrParentDocument.IITR120.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue([incdtls347] = 1,[incdtls373],[incdtls380])), 0))", Value = conditionalSumINCDTLS373_or_INCDTLS380.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730251

        #region VR.ATO.IITR.730252

        /* VR.ATO.IITR.730252
            Where any Dividends franking credits are present in the attached Income Details schedule, the Dividends - Franking credit amount must be provided

        Legacy Rule Format:
            ^IITR120 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS373, ^INCDTLS373 <> NULL) OR AnyOccurrence(^INCDTLS380, ^INCDTLS380 <> NULL))

        Technical Business Rule Format:
            ^IITR120 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS373, ^INCDTLS373 <> NULL) OR AnyOccurrence(^INCDTLS380, ^INCDTLS380 <> NULL))

        Data Elements:
    
            ^IITR120 = RP:IncomeTax.FrankingCredits.Amount
    
            ^INCDTLS373 = INCDTLS373
    
            ^INCDTLS380 = INCDTLS380
        */

        public static ProcessMessageDocument VR_ATO_IITR_730252(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3a_INCDTLS373AnyNotNull = false;
            bool Condition3b_INCDTLS380AnyNotNull = false;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
            {
                Condition3a_INCDTLS373AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS373 != null));
                Condition3b_INCDTLS380AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS380 != null));
            }

            bool assertion = (report.iitrParentDocument.IITR120 == null && (Condition3a_INCDTLS373AnyNotNull || Condition3b_INCDTLS380AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730252",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Dividends - Franking credit must be provided",
                    LongDescription = "Where any Dividends franking credits are present in the attached Income Details schedule, the Dividends - Franking credit amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.FrankingCredits.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730252" },
                        new ProcessMessageParameter() { Name = "IITR120", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS373]) <> NULL", Value = Condition3a_INCDTLS373AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS380]) <> NULL", Value = Condition3b_INCDTLS380AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730252

        #region VR.ATO.IITR.730253

        /* VR.ATO.IITR.730253
            The TFN amounts withheld from dividends must equal the sum of the following amounts on the Income Details schedule, where the Country of residence when the dividend was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands": all Total TFN amounts withheld from dividends for individually owned accounts; and all Your share of TFN amounts withheld from dividends for joint accounts

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR121 <> NULL AND ^IITR121 <> Sum(ConditionalValue(^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS347 = 1, ^INCDTLS374, ^INCDTLS381)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND (^IITR121 <> NULL AND ^IITR121 <> Sum(ConditionalValue(^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')), ConditionalValue(^INCDTLS347 = 1, ^INCDTLS374, ^INCDTLS381)))

        Data Elements:
    
            ^IITR121 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount
    
            ^INCDTLS347 = INCDTLS347
    
            ^INCDTLS348 = INCDTLS348
    
            ^INCDTLS374 = INCDTLS374
    
            ^INCDTLS381 = INCDTLS381
        */

        public static ProcessMessageDocument VR_ATO_IITR_730253(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            // Condtional sum contains a country code check for Australian country codes
            decimal conditionalSumINCDTLS374_or_INCDTLS381 = 0;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
                conditionalSumINCDTLS374_or_INCDTLS381 = incdtlschilddoc.Rp_DividendsCollection.Where(f => f.INCDTLS348 == null || australianCountryCodes.Contains(f.INCDTLS348)).Sum(f => f.INCDTLS347 == 1 ? f.INCDTLS374.GetValueOrDefault() : f.INCDTLS381.GetValueOrDefault());

            bool assertion = (report.iitrParentDocument.IITR121 != null && (report.iitrParentDocument.IITR121 != conditionalSumINCDTLS374_or_INCDTLS381));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730253",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "TFN amounts withheld from dividends is incorrect",
                    LongDescription = "The TFN amounts withheld from dividends must equal the sum of the following amounts on the Income Details schedule, where the Country of residence when the dividend was paid or credited is \"Australia\", \"Christmas Island\", \"Norfolk Island\", \"Cocos(Keeling) Islands\" or \"Heard and McDonald Islands\": all Total TFN amounts withheld from dividends for individually owned accounts; and all Your share of TFN amounts withheld from dividends for joint accounts",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730253" },
                        new ProcessMessageParameter() { Name = "IITR121", Value = report.iitrParentDocument.IITR121.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue(([incdtls348] = NULL OR [incdtls348] = SET(\"au\",\"cc\",\"cx\",\"nf\",\"hm\")), ConditionalValue([incdtls347] = 1, [incdtls374], [incdtls381]))))", Value = conditionalSumINCDTLS374_or_INCDTLS381.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730253

        #region VR.ATO.IITR.730254

        /* VR.ATO.IITR.730254
            Where any Dividends TFN amounts are present where the Country of residence when the dividend was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands" on the Income Details schedule, the TFN amounts withheld from dividends must be provided

        Legacy Rule Format:
            ^IITR121 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS374, ^INCDTLS374 <> NULL) WHERE (^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')))

        Technical Business Rule Format:
            ^IITR121 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS374, ^INCDTLS374 <> NULL) WHERE (^INCDTLS348 = NULL OR InSet(^INCDTLS348, '"au","cc","cx","nf","hm"')))

        Data Elements:
    
            ^IITR121 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount
    
            ^INCDTLS348 = INCDTLS348
    
            ^INCDTLS374 = INCDTLS374
        */

        public static ProcessMessageDocument VR_ATO_IITR_730254(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3a_INCDTLS374AnyNotNull = false;

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
            {
                Condition3a_INCDTLS374AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => (tuple.INCDTLS348 == null || australianCountryCodes.Contains(tuple.INCDTLS348)) && tuple.INCDTLS374 != null));
            }

            bool assertion = (report.iitrParentDocument.IITR121 == null && (Condition3a_INCDTLS374AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730254",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "TFN amounts withheld from dividends must be provided",
                    LongDescription = "Where any Dividends TFN amounts are present where the Country of residence when the dividend was paid or credited is \"Australia\", \"Christmas Island\", \"Norfolk Island\", \"Cocos(Keeling) Islands\" or \"Heard and McDonald Islands\" on the Income Details schedule, the TFN amounts withheld from dividends must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730254" },
                        new ProcessMessageParameter() { Name = "IITR121", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls374]) <> NULL WHERE ([incdtls348] = NULL OR [incdtls348] = SET(\"au\",\"cc\",\"cx\",\"nf\",\"hm\"))", Value = Condition3a_INCDTLS374AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730254

        #region VR.ATO.IITR.730255

        /* VR.ATO.IITR.730255
            The Assessable balancing adjustment from low value pool relating to financial investments value must equal the sum of all Assessable adjustment from low value pool relating to financial investments values

        Legacy Rule Format:
            (^IITR613 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR613 <> RoundDown(Sum(^INCDTLS457),0))

        Technical Business Rule Format:
            (^IITR613 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR613 <> RoundDown(Sum(^INCDTLS457),0))

        Data Elements:
    
            ^IITR613 = RP:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
    
            ^INCDTLS457 = INCDTLS457
        */

        public static ProcessMessageDocument VR_ATO_IITR_730255(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls457]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS457 = 0;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS457
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Conditional3_SumOfINCDTLS457 = (incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS457.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR613 != null && (report.iitrParentDocument.IITR613.GetValueOrDefault() != Math.Truncate(Conditional3_SumOfINCDTLS457)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730255",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable balancing adjustment from low value pool relating to financial investments is incorrect",
                    LongDescription = @"The Assessable balancing adjustment from low value pool relating to financial investments value must equal the sum of all Assessable adjustment from low value pool relating to financial investments values",
                    Location = "/xbrli:xbrl/tns:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730255" },
                        new ProcessMessageParameter() { Name = "iitr613", Value = report.iitrParentDocument.IITR613.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls457]))", Value = Math.Truncate(Conditional3_SumOfINCDTLS457).ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730255

        #region VR.ATO.IITR.730256

        /* VR.ATO.IITR.730256
            Where Assessable balancing adjustment from low value pool relating to financial investments is not provided, then Assessable adjustment from low value pool relating to financial investments must not be provided

        Legacy Rule Format:
            (^IITR613 = NULL) AND (CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS457, ^INCDTLS457 <> NULL))

        Technical Business Rule Format:
            (^IITR613 = NULL) AND (CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS457, ^INCDTLS457 <> NULL))

        Data Elements:
    
            ^IITR613 = RP:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
    
            ^INCDTLS457 = INCDTLS457
        */

        public static ProcessMessageDocument VR_ATO_IITR_730256(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS457AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS457
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Condition3_INCDTLS457AnyNotNull = (incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS457 != null));

            bool assertion = (report.iitrParentDocument.IITR613 == null && (Condition3_INCDTLS457AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730256",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable balancing adjustment from low value pool relating to financial investments must not be provided",
                    LongDescription = @"Where Assessable balancing adjustment from low value pool relating to financial investments is not provided, then Assessable adjustment from low value pool relating to financial investments must not be provided",
                    Location = "/xbrli:xbrl/tns:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730256" },
                        new ProcessMessageParameter() { Name = "iitr613", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls457]) <> NULL", Value = Condition3_INCDTLS457AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730256

        #region VR.ATO.IITR.730257

        /* VR.ATO.IITR.730257
            The Assessable balancing adjustment from low value pool relating to rental property value must equal the sum of all Assessable adjustment from low value pool relating to rental property values

        Legacy Rule Format:
            (^IITR614 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR614 <> RoundDown(Sum(^INCDTLS458),0))

        Technical Business Rule Format:
            (^IITR614 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR614 <> RoundDown(Sum(^INCDTLS458),0))

        Data Elements:
    
            ^IITR614 = RP:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount
    
            ^INCDTLS458 = INCDTLS458
        */

        public static ProcessMessageDocument VR_ATO_IITR_730257(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls458]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS458 = 0;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS458
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Conditional3_SumOfINCDTLS458 = (incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS458.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR614 != null && (report.iitrParentDocument.IITR614.GetValueOrDefault() != Math.Truncate(Conditional3_SumOfINCDTLS458)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730257",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable balancing adjustment from low value pool relating to rental property is incorrect",
                    LongDescription = @"The Assessable balancing adjustment from low value pool relating to rental property value must equal the sum of all Assessable adjustment from low value pool relating to rental property values",
                    Location = "/xbrli:xbrl/tns:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730257" },
                        new ProcessMessageParameter() { Name = "iitr614", Value = report.iitrParentDocument.IITR614.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls458]))", Value = Math.Truncate(Conditional3_SumOfINCDTLS458).ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730257

        #region VR.ATO.IITR.730258

        /* VR.ATO.IITR.730258
            Where Assessable balancing adjustment from low value pool relating to rental property is not provided, then Assessable adjustment from low value pool relating to rental property must not be provided

        Legacy Rule Format:
            (^IITR614 = NULL) AND (CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS458, ^INCDTLS458 <> NULL))

        Technical Business Rule Format:
            (^IITR614 = NULL) AND (CountDocument('INCDTLS') = 1) AND (AnyOccurrence(^INCDTLS458, ^INCDTLS458 <> NULL))

        Data Elements:
    
            ^IITR614 = RP:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount
    
            ^INCDTLS458 = INCDTLS458
        */

        public static ProcessMessageDocument VR_ATO_IITR_730258(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS458AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS458
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Condition3_INCDTLS458AnyNotNull = (incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS458 != null));

            bool assertion = (report.iitrParentDocument.IITR614 == null && (Condition3_INCDTLS458AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730258",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Assessable balancing adjustment from low value pool relating to rental property must not be provided",
                    LongDescription = @"Where Assessable balancing adjustment from low value pool relating to rental property is not provided, then Assessable adjustment from low value pool relating to rental property must not be provided",
                    Location = "/xbrli:xbrl/tns:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730258" },
                        new ProcessMessageParameter() { Name = "iitr614", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls458]) <> NULL", Value = Condition3_INCDTLS458AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730258

        #region VR.ATO.IITR.730259

        /*  VR.ATO.IITR.730259
        The Income from a financial investment not included elsewhere must equal the sum of Other income amount where Other income type is set to "Financial investments", and other income from managed fund amounts reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            (^IITR617 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR617 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Financial investments', ^INCDTLS451, 0)) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS401, ^INCDTLS431)),0))

        Technical Business Rule Format:
            (^IITR617 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR617 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Financial investments', ^INCDTLS451, 0)) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS401, ^INCDTLS431)),0))

        Data Elements:
    
            ^IITR617 = RP:IncomeTax.FinancialInvestmentsOther.Amount
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS401 = INCDTLS401
    
            ^INCDTLS431 = INCDTLS431
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730259(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: Sum(ConditionalValue([incdtls449] = "Financial investments", [incdtls451], 0))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS451 = 0;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS451 where INCDTLS449 = Financial investments
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Conditional3_SumOfINCDTLS451 = incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS449 == "Financial investments" ? tuple.INCDTLS451.GetValueOrDefault() : 0);

            // Condition 4: Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS401, ^INCDTLS431))
            decimal Conditional4_TotalSum = 0;
            decimal Conditional4_INCDTLS401Sum = 0;
            decimal Conditional4_INCDTLS431Sum = 0;
            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                foreach (INCDTLS2026.Rp_ManagedFunds managed in incdtlschilddoc.Rp_ManagedFundsCollection)
                {
                    if (managed.INCDTLS387 == 1)
                        Conditional4_INCDTLS401Sum += managed.INCDTLS401.GetValueOrDefault();
                    else
                        Conditional4_INCDTLS431Sum += managed.INCDTLS431.GetValueOrDefault();
                }
                Conditional4_TotalSum = Conditional4_INCDTLS401Sum + Conditional4_INCDTLS431Sum;
            }

            bool assertion = report.iitrParentDocument.IITR617 != null && (report.iitrParentDocument.IITR617.GetValueOrDefault() != Math.Truncate(Conditional3_SumOfINCDTLS451 + Conditional4_TotalSum));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731259",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income from a financial investment not included elsewhere is incorrect",
                    LongDescription = @"The Income from a financial investment not included elsewhere must equal the sum of Other income amount where Other income type is set to ""Financial investments"", and other income from managed fund amounts reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.FinancialInvestmentsOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730259" },
                        new ProcessMessageParameter() { Name = "IITR617", Value = report.iitrParentDocument.IITR617.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS451 Sum", Value = Conditional3_SumOfINCDTLS451.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS401 Sum", Value = Conditional4_INCDTLS401Sum.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS431 Sum", Value = Conditional4_INCDTLS431Sum.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730259

        #region VR.ATO.IITR.730260

        /*  VR.ATO.IITR.730260
        Where any Other income amounts are present with Other income type set to "Financial investments", Total other income from managed fund or Your share of other income from managed fund, in the attached Income details schedule, the amount of Income from a financial investment not included elsewhere must be provided

        Legacy Rule Format:
            (^IITR617 = NULL) AND (CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE (^INCDTLS449 = 'Financial investments')) OR (AnyOccurrence(^INCDTLS401, ^INCDTLS401 <> NULL)) OR (AnyOccurrence(^INCDTLS431, ^INCDTLS431 <> NULL)))

        Technical Business Rule Format:
            (^IITR617 = NULL) AND (CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE (^INCDTLS449 = 'Financial investments')) OR (AnyOccurrence(^INCDTLS401, ^INCDTLS401 <> NULL)) OR (AnyOccurrence(^INCDTLS431, ^INCDTLS431 <> NULL)))

        Data Elements:
    
            ^IITR617 = RP:IncomeTax.FinancialInvestmentsOther.Amount
    
            ^INCDTLS401 = INCDTLS401
    
            ^INCDTLS431 = INCDTLS431
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730260(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Checks to see if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS451 where INCDTLS449 = Financial investments
            bool Condition3_INCDTLS451AnyNotNull = false;

            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                Condition3_INCDTLS451AnyNotNull = (incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS449 == "Financial investments" ? tuple.INCDTLS451 != null ? true : false : false));

            // Checks to see if the ManagedFunds tuple exists and if so, checks each tuple for any instance of INCDTLS401 or INCDTLS431
            bool Condition4_INCDTLS401AnyNotNull = false;
            bool Condition4_INCDTLS431AnyNotNull = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition4_INCDTLS401AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS401 != null);
                Condition4_INCDTLS431AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS431 != null);
            }

            bool assertion = report.iitrParentDocument.IITR617 == null && (Condition3_INCDTLS451AnyNotNull || Condition4_INCDTLS401AnyNotNull || Condition4_INCDTLS431AnyNotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731260",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income from a financial investment not included elsewhere must be provided",
                    LongDescription = @"Where any Other income amounts are present with Other income type set to ""Financial investments"", Total other income from managed fund or Your share of other income from managed fund, in the attached Income details schedule, the amount of Income from a financial investment not included elsewhere must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.FinancialInvestmentsOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730260" },
                        new ProcessMessageParameter() { Name = "IITR617", Value = report.iitrParentDocument.IITR617.ToString()  },
                        new ProcessMessageParameter() { Name = "INCDTLS451 Not Null", Value = Condition3_INCDTLS451AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS401 Not Null", Value = Condition4_INCDTLS401AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS431 Not Null", Value = Condition4_INCDTLS431AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730260

        #region VR.ATO.IITR.730264

        /* VR.ATO.IITR.730264
            Working holiday maker net income has been declared as greater than the sum of all Salary or wages gross amount amounts where the Did you earn this income while you held a Working Holiday visa (subclass 417) or Work and Holiday visa (subclass 462)? indicator is true. Check that all sources of working holiday maker income have been declared.
    
            Legacy Rule Format:
            (^IITR499 <> NULL) AND ((CountDocument('INCDTLS') = 0) OR (^IITR499 > Sum(ConditionalValue(^INCDTLS310 = TRUE, ^INCDTLS312, 0))))

            Technical Business Rule Format:
            (^IITR499 <> NULL) AND ((CountDocument('INCDTLS') = 0) OR (^IITR499 > Sum(ConditionalValue(^INCDTLS310 = TRUE, ^INCDTLS312, 0))))
    
            Data Elements:
    
            ^IITR499 = RP.WHM:Income.Net.Amount
    
            ^INCDTLS310 = INCDTLS310
    
            ^INCDTLS312 = INCDTLS312
        */

        public static ProcessMessageDocument VR_ATO_IITR_730264(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 3: (COUNT(SCHEDULE = "INCDTLS") = 0)
            bool Conditional2_CountOfINCDTLSSchedule = incdtlschilddoc == null;

            // Condition 3: SUM(ConditionalValue([incdtls310] = TRUE, [incdtls312], 0))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS312 = 0;

            // Only runs if the INCDTLS schedule is provided
            if (!Conditional2_CountOfINCDTLSSchedule)
            {
                // Checks to see if the Income tuple exists and if so, checks each tuple for any instance of INCDTLS312 where INCDTLS310 = TRUE
                if (incdtlschilddoc.Rp_IncomeCollectionExists)
                    Conditional3_SumOfINCDTLS312 = incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS310.GetValueOrDefault() ? tuple.INCDTLS312.GetValueOrDefault() : 0);
            }

            bool assertion = (report.iitrParentDocument.IITR499 != null && (Conditional2_CountOfINCDTLSSchedule || (report.iitrParentDocument.IITR499.GetValueOrDefault() > Conditional3_SumOfINCDTLS312)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730264",
                    Severity = ProcessMessageSeverity.Warning,
                    Description = @"Check Working holiday maker net income amount",
                    LongDescription = @"Working holiday maker net income has been declared as greater than the sum of all Salary or wages gross amount amounts where the Did you earn this income while you held a Working Holiday visa (subclass 417) or Work and Holiday visa (subclass 462)? indicator is true. Check that all sources of working holiday maker income have been declared.",
                    Location = "/xbrli:xbrl/tns:Income.Net.Amount[@contextRef='" + report.iitrParentDocument.RPWHMId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730264" },
                        new ProcessMessageParameter() { Name = "iitr499", Value = report.iitrParentDocument.IITR499.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue([incdtls310] = TRUE, [incdtls312], 0))", Value = Conditional3_SumOfINCDTLS312.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730264

        #region VR.ATO.IITR.730327

        /* VR.ATO.IITR.730327
            The Reportable employer superannuation contributions amount must equal the combined total of Salary or wages reportable employer superannuation contributions, Foreign employment income reportable employer superannuation contributions, Attributed PSI reportable employer super contributions, and Business income statement reportable employer super contribution amounts

        Legacy Rule Format:
            ^IITR201 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR201 <> (Sum(^INCDTLS319) + Sum(^INCDTLS171) + Sum(^INCDTLS343) + Sum(^INCDTLS494))

        Technical Business Rule Format:
            ^IITR201 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR201 <> (Sum(^INCDTLS319) + Sum(^INCDTLS171) + Sum(^INCDTLS343) + Sum(^INCDTLS494))

        Data Elements:
    
            ^IITR201 = RP:SuperannuationContribution.EmployerReportable.Amount
    
            ^INCDTLS171 = INCDTLS171
    
            ^INCDTLS319 = INCDTLS319
    
            ^INCDTLS343 = INCDTLS343
    
            ^INCDTLS494 = INCDTLS494
        */

        public static ProcessMessageDocument VR_ATO_IITR_730327(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: (SUM([incdtls319]) + SUM([incdtls171]) + SUM([incdtls343]) + SUM([incdtls494])))
            // Calculate the total of each of the sum values
            decimal Conditional3_sumOfTotal = 0;
            decimal Conditional3a_SumOfINCDTLS319 = 0;
            decimal Conditional3b_SumOfINCDTLS171 = 0;
            decimal Conditional3c_SumOfINCDTLS343 = 0;
            decimal Conditional3d_SumOfINCDTLS494 = 0;

            // Calculate total of each of the fields if the RP tuple exists
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
            {
                Conditional3a_SumOfINCDTLS319 = (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS319.GetValueOrDefault()));
                Conditional3b_SumOfINCDTLS171 = (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS171.GetValueOrDefault()));
                Conditional3c_SumOfINCDTLS343 = (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS343.GetValueOrDefault()));
            }

            // Calculate total of INCDTLS494 if the BusinessIncomePaymentSummaries tuple exists
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                Conditional3d_SumOfINCDTLS494 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS494.GetValueOrDefault()));

            // Calculate total of each of the sum values
            Conditional3_sumOfTotal = Conditional3a_SumOfINCDTLS319 + Conditional3b_SumOfINCDTLS171 + Conditional3c_SumOfINCDTLS343 + Conditional3d_SumOfINCDTLS494;

            bool assertion = (report.iitrParentDocument.IITR201 != null && (report.iitrParentDocument.IITR201.GetValueOrDefault() != Conditional3_sumOfTotal));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730327",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reportable employer superannuation contributions is incorrect",
                    LongDescription = @"The Reportable employer superannuation contributions amount must equal the combined total of Salary or wages reportable employer superannuation contributions, Foreign employment income reportable employer superannuation contributions, Attributed PSI reportable employer super contributions, and Business income statement reportable employer super contribution amounts",
                    Location = "/xbrli:xbrl/tns:SuperannuationContribution.EmployerReportable.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730327" },
                        new ProcessMessageParameter() { Name = "IITR201", Value = report.iitrParentDocument.IITR201.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls319])", Value = Conditional3a_SumOfINCDTLS319.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls171])", Value = Conditional3b_SumOfINCDTLS171.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls343])", Value = Conditional3c_SumOfINCDTLS343.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls494])", Value = Conditional3d_SumOfINCDTLS494.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls319]) + SUM([incdtls171]) + SUM([incdtls343]) + SUM([incdtls494]))", Value = Math.Truncate(Conditional3_sumOfTotal).ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730327

        #region VR.ATO.IITR.730328

        /* VR.ATO.IITR.730328
            Where Salary or wages reportable employer superannuation contributions, Foreign employment income reportable employer superannuation contributions, Attributed PSI reportable employer super contributions, or Business income statement reportable employer super contribution amount is provided, then Reportable employer superannuation contributions must be provided.

        Legacy Rule Format:
            (^IITR201 = NULL) AND (CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS319, ^INCDTLS319 <> NULL) OR AnyOccurrence(^INCDTLS171, ^INCDTLS171 <> NULL) OR AnyOccurrence(^INCDTLS343, ^INCDTLS343 <> NULL) OR AnyOccurrence(^INCDTLS494, ^INCDTLS494 <> NULL)))

        Technical Business Rule Format:
            (^IITR201 = NULL) AND (CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS319, ^INCDTLS319 <> NULL) OR AnyOccurrence(^INCDTLS171, ^INCDTLS171 <> NULL) OR AnyOccurrence(^INCDTLS343, ^INCDTLS343 <> NULL) OR AnyOccurrence(^INCDTLS494, ^INCDTLS494 <> NULL)))

        Data Elements:
    
            ^IITR201 = RP:SuperannuationContribution.EmployerReportable.Amount
    
            ^INCDTLS171 = INCDTLS171
    
            ^INCDTLS319 = INCDTLS319
    
            ^INCDTLS343 = INCDTLS343
    
            ^INCDTLS494 = INCDTLS494
        */

        public static ProcessMessageDocument VR_ATO_IITR_730328(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3a_INCDTLS319AnyNotNull = false;
            bool Condition3b_INCDTLS171AnyNotNull = false;
            bool Condition3c_INCDTLS343AnyNotNull = false;
            bool Condition3d_INCDTLS494AnyNotNull = false;

            // Check to see if the RP tuple exists and if so, checks each tuple for any instance of the following fields (INCDTLS319, INCDTLS171 or INCDTLS343)
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
            {
                Condition3a_INCDTLS319AnyNotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS319 != null));
                Condition3b_INCDTLS171AnyNotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS171 != null));
                Condition3c_INCDTLS343AnyNotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS343 != null));
            }

            // Check to see if the BusinessIncomePaymentSummaries tuple exists and if so, checks each tuple for any instance of INCDTLS494
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                Condition3d_INCDTLS494AnyNotNull = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS494 != null));

            bool assertion = (report.iitrParentDocument.IITR201 == null && (Condition3a_INCDTLS319AnyNotNull || Condition3b_INCDTLS171AnyNotNull || Condition3c_INCDTLS343AnyNotNull || Condition3d_INCDTLS494AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730328",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reportable employer superannuation contributions must be provided",
                    LongDescription = @"Where Salary or wages reportable employer superannuation contributions, Foreign employment income reportable employer superannuation contributions, Attributed PSI reportable employer super contributions, or Business income statement reportable employer super contribution amount is provided, then Reportable employer superannuation contributions must be provided.",
                    Location = "/xbrli:xbrl/tns:SuperannuationContribution.EmployerReportable.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730328" },
                        new ProcessMessageParameter() { Name = "IITR201", Value = report.iitrParentDocument.IITR201.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS319]) <> NULL", Value = Condition3a_INCDTLS319AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS171]) <> NULL", Value = Condition3b_INCDTLS171AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS343]) <> NULL", Value = Condition3c_INCDTLS343AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS494]) <> NULL", Value = Condition3d_INCDTLS494AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730328

        #region VR.ATO.IITR.730353

        /* VR.ATO.IITR.730353
            The Net foreign pension or annuity income without an undeducted purchase price must equal the sum of all Foreign pension or annuity gross amounts less Foreign pension or annuity deductible expenses provided in the attached Income Details schedule, where the Foreign pension or annuity undeducted purchase price is zero or not provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR322 <> NULL AND ^IITR322 <> RoundDown(Sum(ConditionalValue((^INCDTLS211 = NULL OR ^INCDTLS211 = 0), (^INCDTLS209 - ^INCDTLS210), 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR322 <> NULL AND ^IITR322 <> RoundDown(Sum(ConditionalValue((^INCDTLS211 = NULL OR ^INCDTLS211 = 0), (^INCDTLS209 - ^INCDTLS210), 0)), 0)

        Data Elements:
    
            ^IITR322 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeWithoutUndeductedPurchasePrice.Amount
    
            ^INCDTLS209 = INCDTLS209
    
            ^INCDTLS210 = INCDTLS210
    
            ^INCDTLS211 = INCDTLS211
        */

        public static ProcessMessageDocument VR_ATO_IITR_730353(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            decimal totalSum = 0;
            bool assertion = false;

            if (report.iitrParentDocument.IITR322 != null)
            {
                if (incdtlschilddoc != null && incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
                {
                    totalSum = Math.Truncate(incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection
                        .Sum(tuple => tuple.INCDTLS211.GetValueOrDefault() == 0 || !tuple.INCDTLS211.HasValue
                        ? tuple.INCDTLS209.GetValueOrDefault() - tuple.INCDTLS210.GetValueOrDefault()
                        : 0));
                }

                assertion = (report.iitrParentDocument.IITR322.GetValueOrDefault() != totalSum);
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730353",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net foreign pension or annuity income without an undeducted purchase price is incorrect",
                    LongDescription = @"The Net foreign pension or annuity income without an undeducted purchase price must equal the sum of all Foreign pension or annuity gross amounts less Foreign pension or annuity deductible expenses provided in the attached Income Details schedule, where the Foreign pension or annuity undeducted purchase price is zero or not provided",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignPensionOrAnnuityIncomeWithoutUndeductedPurchasePrice.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730353" },
                        new ProcessMessageParameter() { Name = "IITR322", Value = report.iitrParentDocument.IITR322.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue((INCDTLS211 = NULL OR INCDTLS211 = 0), (INCDTLS209 - INCDTLS210), 0)), 0)", Value = totalSum.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730353

        #region VR.ATO.IITR.730354

        /* VR.ATO.IITR.730354
            The Net foreign pension or annuity income with an undeducted purchase price must equal the sum of all Foreign pension or annuity gross amounts less Foreign pension or annuity deductible expenses provided in the attached Income Details schedule, where the Foreign pension or annuity undeducted purchase price is positive

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR323 <> NULL AND ^IITR323 <> RoundDown(Sum(ConditionalValue(^INCDTLS211 > 0, (^INCDTLS209 - ^INCDTLS210), 0)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR323 <> NULL AND ^IITR323 <> RoundDown(Sum(ConditionalValue(^INCDTLS211 > 0, (^INCDTLS209 - ^INCDTLS210), 0)), 0)

        Data Elements:
    
            ^IITR323 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^INCDTLS209 = INCDTLS209
    
            ^INCDTLS210 = INCDTLS210
    
            ^INCDTLS211 = INCDTLS211
        */

        public static ProcessMessageDocument VR_ATO_IITR_730354(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            decimal sum = 0;

            if (report.iitrParentDocument.IITR323 != null)
            {
                if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
                {
                    sum = Math.Truncate(incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection
                        .Sum(tuple => tuple.INCDTLS211.GetValueOrDefault() > 0
                        ? tuple.INCDTLS209.GetValueOrDefault() - tuple.INCDTLS210.GetValueOrDefault()
                        : 0));
                }
                assertion = report.iitrParentDocument.IITR323.GetValueOrDefault() != sum;
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730354",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net foreign pension or annuity income with an undeducted purchase price is incorrect",
                    LongDescription = @"The Net foreign pension or annuity income with an undeducted purchase price must equal the sum of all Foreign pension or annuity gross amounts less Foreign pension or annuity deductible expenses provided in the attached Income Details schedule, where the Foreign pension or annuity undeducted purchase price is positive",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignPensionOrAnnuityIncomeUndeductedPurchasePrice.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730354" },
                        new ProcessMessageParameter() { Name = "IITR323", Value = report.iitrParentDocument.IITR323.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM(ConditionalValue(INCDTLS211 > 0), INCDTLS209 - INCDTLS210, 0))", Value = sum.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730354

        #region VR.ATO.IITR.730355

        /* VR.ATO.IITR.730355
            Where any Foreign pension or annuity gross income amounts are present in the attached Income Details schedule, the following amounts must be provided: Net foreign pension or annuity income without an undeducted purchase price; Net foreign pension or annuity income with an undeducted purchase price; and Deductible amount of UPP of foreign pension or annuity

        Legacy Rule Format:
            (^IITR322 = NULL OR ^IITR323 = NULL OR ^IITR358 = NULL) AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS209, ^INCDTLS209 <> NULL))

        Technical Business Rule Format:
            (^IITR322 = NULL OR ^IITR323 = NULL OR ^IITR358 = NULL) AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS209, ^INCDTLS209 <> NULL))

        Data Elements:
    
            ^IITR322 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeWithoutUndeductedPurchasePrice.Amount
    
            ^IITR323 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^IITR358 = RP:IncomeTax.Deduction.ForeignPensionAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^INCDTLS209 = INCDTLS209
        */

        public static ProcessMessageDocument VR_ATO_IITR_730355(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            decimal? iitr322 = report?.iitrParentDocument?.IITR322;
            decimal? iitr323 = report?.iitrParentDocument?.IITR323;
            decimal? iitr358 = report?.iitrParentDocument?.IITR358;
            bool? anyOccurrencIncdtls209NotNull = null;
            bool assertion = false;

            if (!iitr322.HasValue || !iitr323.HasValue || !iitr358.HasValue)
            {
                anyOccurrencIncdtls209NotNull = incdtlschilddoc?.Rp_ForeignPensionsOrAnnuitiesCollection?.Any(tuple => tuple.INCDTLS209.HasValue);
                assertion = anyOccurrencIncdtls209NotNull.GetValueOrDefault();
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730355",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Foreign pension or annuity income details are incomplete",
                    LongDescription = @"Where any Foreign pension or annuity gross income amounts are present in the attached Income Details schedule, the following amounts must be provided: Net foreign pension or annuity income without an undeducted purchase price; Net foreign pension or annuity income with an undeducted purchase price; and Deductible amount of UPP of foreign pension or annuity",
                    Location = $"/xbrli:xbrl/tns:InternationalDealings.ForeignPensionOrAnnuityIncomeWithoutUndeductedPurchasePrice.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730355" },
                        new ProcessMessageParameter() { Name = "IITR322", Value = iitr322.ToString() },
                        new ProcessMessageParameter() { Name = "IITR323", Value = iitr323.ToString() },
                        new ProcessMessageParameter() { Name = "IITR358", Value = iitr358.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(INCDTLS209) <> NULL)", Value = anyOccurrencIncdtls209NotNull.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730355

        #region VR.ATO.IITR.730356

        /* VR.ATO.IITR.730356
            When the sum of all foreign pension or annuity assessable amounts in the Income Details schedule (Foreign pension or annuity gross amount less Foreign pension or annuity deductible expenses) is positive, the Deductible amount of UPP of foreign pension or annuity must equal the lesser value of the sum of all adjusted Foreign pension or annuity undeducted purchase price amounts or sum of all foreign pension or annuity assessable amounts; Otherwise, the Deductible amount of UPP of foreign pension or annuity must be set to zero. Note: The adjusted Foreign pension or annuity undeducted purchase price for each pension (or annuity) is determined as either; the lesser value of the foreign pension or annuity assessable amount or Foreign pension or annuity undeducted purchase price, when the foreign pension or annuity assessable amount is positive; or zero when the foreign pension or annuity assessable amount is zero or negative.

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR358 <> NULL AND ((RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0) > 0 AND ^IITR358 <> ConditionalValue(Sum(ConditionalValue((^INCDTLS209 - ^INCDTLS210) > 0, ConditionalValue(^INCDTLS211 < (^INCDTLS209 - ^INCDTLS210), ^INCDTLS211, (^INCDTLS209 - ^INCDTLS210)), 0)) < (Sum(^INCDTLS209) - Sum(^INCDTLS210)), RoundDown(Sum(ConditionalValue((^INCDTLS209 - ^INCDTLS210) > 0, ConditionalValue(^INCDTLS211 < (^INCDTLS209 - ^INCDTLS210), ^INCDTLS211, (^INCDTLS209 - ^INCDTLS210)), 0)), 0), RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0))) OR (RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0) <= 0 AND ^IITR358 <> 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR358 <> NULL AND ((RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0) > 0 AND ^IITR358 <> ConditionalValue(Sum(ConditionalValue((^INCDTLS209 - ^INCDTLS210) > 0, ConditionalValue(^INCDTLS211 < (^INCDTLS209 - ^INCDTLS210), ^INCDTLS211, (^INCDTLS209 - ^INCDTLS210)), 0)) < (Sum(^INCDTLS209) - Sum(^INCDTLS210)), RoundDown(Sum(ConditionalValue((^INCDTLS209 - ^INCDTLS210) > 0, ConditionalValue(^INCDTLS211 < (^INCDTLS209 - ^INCDTLS210), ^INCDTLS211, (^INCDTLS209 - ^INCDTLS210)), 0)), 0), RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0))) OR (RoundDown((Sum(^INCDTLS209) - Sum(^INCDTLS210)), 0) <= 0 AND ^IITR358 <> 0))

        Data Elements:
    
            ^IITR358 = RP:IncomeTax.Deduction.ForeignPensionAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^INCDTLS209 = INCDTLS209
    
            ^INCDTLS210 = INCDTLS210
    
            ^INCDTLS211 = INCDTLS211
        */

        public static ProcessMessageDocument VR_ATO_IITR_730356(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            decimal sumIncdtls209 = 0;
            decimal sumIncdtls210 = 0;

            // SUM(ConditionalValue((incdtls209 - incdtls210) > 0, ConditionalValue(incdtls211 < (incdtls209 - incdtls210), incdtls211, (incdtls209 - incdtls210)), 0))
            decimal sumConditionalValues = 0;

            // SUM(incdtls209) - SUM(incdtls210))
            decimal diffSumIncdtls209SumIncdtls210 = 0;

            if (report.iitrParentDocument != null && report.iitrParentDocument.IITR358 != null)
            {
                if (incdtlschilddoc != null && incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
                {
                    List<INCDTLS2026.Rp_ForeignPensionsOrAnnuities> fpaCollection = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection;

                    // SUM(incdtls209)
                    sumIncdtls209 = fpaCollection.Sum(tuple => tuple.INCDTLS209.GetValueOrDefault());

                    // SUM(incdtls210)
                    sumIncdtls210 = fpaCollection.Sum(tuple => tuple.INCDTLS210.GetValueOrDefault());

                    // diffIncdtls209Incdtls210(): returns incdtls209 - incdtls210
                    Func<INCDTLS2026.Rp_ForeignPensionsOrAnnuities, decimal> diffIncdtls209Incdtls210 = tuple => tuple.INCDTLS209.GetValueOrDefault() - tuple.INCDTLS210.GetValueOrDefault();

                    // SUM(ConditionalValue((incdtls209 - incdtls210) > 0, ConditionalValue(incdtls211 < (incdtls209 - incdtls210), incdtls211, (incdtls209 - incdtls210)), 0))
                    sumConditionalValues =
                        fpaCollection.Sum(tuple =>
                        diffIncdtls209Incdtls210(tuple) > 0
                        ? tuple.INCDTLS211.GetValueOrDefault() < diffIncdtls209Incdtls210(tuple)
                          ? tuple.INCDTLS211.GetValueOrDefault()
                          : diffIncdtls209Incdtls210(tuple)
                        : 0);

                    // SUM(incdtls209) - SUM(incdtls210))
                    diffSumIncdtls209SumIncdtls210 = sumIncdtls209 - sumIncdtls210;

                }

                assertion =
                    (
                        // RoundDown((SUM(incdtls209) - SUM(incdtls210)), 0) > 0 
                        Math.Truncate(diffSumIncdtls209SumIncdtls210) > 0
                        &&
                        // iitr358 <> ConditionalValue(SUM(ConditionalValue((incdtls209 - incdtls210) > 0, ConditionalValue(incdtls211 < (incdtls209 - incdtls210), incdtls211, (incdtls209 - incdtls210)), 0)) < (SUM(incdtls209) - SUM(incdtls210)), RoundDown(SUM(ConditionalValue((incdtls209 - incdtls210) > 0, ConditionalValue(incdtls211 < (incdtls209 - incdtls210), incdtls211, (incdtls209 - incdtls210)), 0)), 0), RoundDown((SUM(incdtls209) - SUM(incdtls210)), 0))
                        report.iitrParentDocument.IITR358.GetValueOrDefault() != (sumConditionalValues < diffSumIncdtls209SumIncdtls210 ? Math.Truncate(sumConditionalValues) : Math.Truncate(diffSumIncdtls209SumIncdtls210))
                    )
                    ||
                    (
                        // RoundDown((SUM(incdtls209) - SUM(incdtls210)), 0) <= 0
                        Math.Truncate(diffSumIncdtls209SumIncdtls210) <= 0
                        &&
                        // iitr358 <> 0
                        report.iitrParentDocument.IITR358.GetValueOrDefault() != 0
                    );
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730356",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Deductible amount of UPP of foreign pension or annuity is incorrect",
                    LongDescription = @"When the sum of all foreign pension or annuity assessable amounts in the Income Details schedule (Foreign pension or annuity gross amount less Foreign pension or annuity deductible expenses) is positive, the Deductible amount of UPP of foreign pension or annuity must equal the lesser value of the sum of all adjusted Foreign pension or annuity undeducted purchase price amounts or sum of all foreign pension or annuity assessable amounts; Otherwise, the Deductible amount of UPP of foreign pension or annuity must be set to zero. Note: The adjusted Foreign pension or annuity undeducted purchase price for each pension (or annuity) is determined as either; the lesser value of the foreign pension or annuity assessable amount or Foreign pension or annuity undeducted purchase price, when the foreign pension or annuity assessable amount is positive; or zero when the foreign pension or annuity assessable amount is zero or negative.",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.Deduction.ForeignPensionAnnuityIncomeUndeductedPurchasePrice.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730356" },
                        new ProcessMessageParameter() { Name = "IITR358", Value = report.iitrParentDocument.IITR358.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(incdtls209)", Value = sumIncdtls209.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(incdtls210)", Value = sumIncdtls210.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(ConditionalValue((incdtls209 - incdtls210) > 0, ConditionalValue(incdtls211 < (incdtls209 - incdtls210), incdtls211, (incdtls209 - incdtls210)), 0))", Value = sumConditionalValues.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(incdtls209) - SUM(incdtls210))", Value = diffSumIncdtls209SumIncdtls210.ToString() },
                    },
                };
            }

            return processMessage;
        }
        #endregion // VR.ATO.IITR.730356

        #region VR.ATO.IITR.730275

        /* VR.ATO.IITR.730275
            Where any Tax withheld from allowances, earnings, tips, director’s fees etc amounts are present in the attached Income Details schedule, the Tax withheld from allowances, earnings, tips, director’s fees etc must be provided

        Legacy Rule Format:
            ^IITR64 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS339, ^INCDTLS339 <> NULL)

        Technical Business Rule Format:
            ^IITR64 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS339, ^INCDTLS339 <> NULL)

        Data Elements:
    
            ^IITR64 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount
    
            ^INCDTLS339 = INCDTLS339
        */

        public static ProcessMessageDocument VR_ATO_IITR_730275(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool condition1_isIITR64Null = false;
            bool condition3_AnyOccurranceINCDTLS339NotNull = false;
            // Condition 2 met if rule is called (COUNT(SCHEDULE = "INCDTLS") = 1 )

            // Check for Condition 1: [iitr64] = NULL
            if (report.iitrParentDocument.IITR64 == null)
                condition1_isIITR64Null = true;

            // Check for Condition 3 ANY OCCURRENCE OF([incdtls339]) <> NULL
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
            {
                condition3_AnyOccurranceINCDTLS339NotNull = (incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS339 != null));
            }

            assertion = (condition1_isIITR64Null && condition3_AnyOccurranceINCDTLS339NotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730275",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from allowances, earnings, tips, director's fees etc must be provided",
                    LongDescription = @"Where any Tax withheld from allowances, earnings, tips, director's fees etc amounts are present in the attached Income Details schedule, the Tax withheld from allowances, earnings, tips, director's fees etc must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730275" },
                        new ProcessMessageParameter() { Name = "IITR64", Value = report.iitrParentDocument.IITR64.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS339]) <> NULL", Value = condition3_AnyOccurranceINCDTLS339NotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730275

        #region VR.ATO.IITR.730276

        /* VR.ATO.IITR.730276
            The Tax withheld from allowances, earnings, tips, director’s fees etc must equal the sum of all Tax withheld from allowances, earnings, tips, director’s fees etc amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR64 <> NULL AND ^IITR64 <> Sum(^INCDTLS339)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR64 <> NULL AND ^IITR64 <> Sum(^INCDTLS339)

        Data Elements:
    
            ^IITR64 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount
    
            ^INCDTLS339 = INCDTLS339
        */

        public static ProcessMessageDocument VR_ATO_IITR_730276(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1 )
            bool condition2_IITR64NotNull = false;
            decimal? sumOfINCDTLS339 = 0;
            bool condition3_IITR64NotEqualINCDTLS339 = false;

            // Get the sum of all INCDTLS339 fields
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                sumOfINCDTLS339 = (incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS339));

            // Setup the booleans for our assertion
            condition2_IITR64NotNull = (report.iitrParentDocument.IITR64 != null);
            condition3_IITR64NotEqualINCDTLS339 = (report.iitrParentDocument.IITR64 != sumOfINCDTLS339);

            assertion = (condition2_IITR64NotNull && condition3_IITR64NotEqualINCDTLS339);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730276",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld from allowances, earnings, tips, director's fees etc amount incorrect",
                    LongDescription = @"The Tax withheld from allowances, earnings, tips, director's fees etc must equal the sum of all Tax withheld from allowances, earnings, tips, director's fees etc amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730276" },
                        new ProcessMessageParameter() { Name = "IITR64", Value = report.iitrParentDocument.IITR64.ToString() },
                        new ProcessMessageParameter() { Name = "[iitr64] <> SUM([incdtls339]", Value = condition3_IITR64NotEqualINCDTLS339.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730276

        #region VR.ATO.IITR.730357

        /* VR.ATO.IITR.730357
            Where any Australian franking credits from a NZ franking company, Total Australian credits from a NZ franking company from managed fund amounts, or Australian franking credits from a New Zealand company - Beneficiary shares are present in the attached Income Details schedule, the Australian franking credits from a New Zealand franking company amount must be provided

        Legacy Rule Format:
            ^IITR328 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS223, ^INCDTLS223 <> NULL) OR AnyOccurrence(^INCDTLS414, ^INCDTLS414 <> NULL) OR AnyOccurrence(^INCDTLS546, ^INCDTLS546 <> NULL))

        Technical Business Rule Format:
            ^IITR328 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS223, ^INCDTLS223 <> NULL) OR AnyOccurrence(^INCDTLS414, ^INCDTLS414 <> NULL) OR AnyOccurrence(^INCDTLS546, ^INCDTLS546 <> NULL))

        Data Elements:
    
            ^IITR328 = RP:IncomeTax.FrankingCreditsNewZealand.Amount
    
            ^INCDTLS223 = INCDTLS223
    
            ^INCDTLS414 = INCDTLS414

            ^INCDTLS546 = INCDTLS546
        */

        public static ProcessMessageDocument VR_ATO_IITR_730357(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal? iitr328 = report?.iitrParentDocument?.IITR328;
            bool anyOccurrenceIncdtls223NotNull = false;
            bool anyOccurrenceIncdtls414NotNull = false;
            bool anyOccurrenceIncdtls546NotNull = false;

            if (!iitr328.HasValue)
            {
                anyOccurrenceIncdtls223NotNull = incdtlschilddoc?.Rp_OtherForeignIncomeCollection?.Any(foreignIncome => foreignIncome.INCDTLS223.HasValue) ?? false;
                anyOccurrenceIncdtls414NotNull = incdtlschilddoc?.Rp_ManagedFundsCollection?.Any(managedFund => managedFund.INCDTLS414.HasValue) ?? false;
                anyOccurrenceIncdtls546NotNull = incdtlschilddoc?.Rp_TrustIncomeCollection?.Any(trustIncome => trustIncome.INCDTLS546.HasValue) ?? false;
            }

            bool assertion = anyOccurrenceIncdtls223NotNull || anyOccurrenceIncdtls414NotNull || anyOccurrenceIncdtls546NotNull;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731357",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Australian franking credits from a New Zealand franking company amount must be provided",
                    LongDescription = "Where any Australian franking credits from a NZ franking company, Total Australian credits from a NZ franking company from managed fund amounts, or Australian franking credits from a New Zealand company - Beneficiary shares are present in the attached Income Details schedule, the Australian franking credits from a New Zealand franking company amount must be provided",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.FrankingCreditsNewZealand.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730357" },
                        new ProcessMessageParameter() { Name = "IITR328", Value = iitr328.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS223 <> NULL", Value = anyOccurrenceIncdtls223NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS414 <> NULL", Value = anyOccurrenceIncdtls414NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS546 <> NULL", Value = anyOccurrenceIncdtls546NotNull.ToString() }
                    }
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730357

        #region VR.ATO.IITR.730358

        /* VR.ATO.IITR.730358
            The Australian franking credits from a New Zealand franking company amount must equal the sum of all the following amounts provided in the attached Income Details schedule: Australian franking credits from a NZ franking company; Your share of Australian credits from a NZ franking company from managed fund where there is more than one account holder; Total Australian credits from a NZ franking company from managed fund amounts where there is a single account holder; and Australian franking credits from a New Zealand company - Beneficiary share

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR328 <> NULL AND ^IITR328 <> RoundDown(Sum(^INCDTLS223) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS442, ^INCDTLS414)) + Sum(^INCDTLS546), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR328 <> NULL AND ^IITR328 <> RoundDown(Sum(^INCDTLS223) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS442, ^INCDTLS414)) + Sum(^INCDTLS546), 0)

        Data Elements:
    
            ^IITR328 = RP:IncomeTax.FrankingCreditsNewZealand.Amount
    
            ^INCDTLS223 = INCDTLS223
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS414 = INCDTLS414
    
            ^INCDTLS442 = INCDTLS442

            ^INCDTLS546 = INCDTLS546
        */

        public static ProcessMessageDocument VR_ATO_IITR_730358(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumIncdtls223 = 0;
            decimal sumConditionalIncdtls442Incdtls414 = 0;
            decimal sumIncdtls546 = 0;

            if (report.iitrParentDocument.IITR328 != null)
            {
                if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                    sumIncdtls223 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeign => otherForeign.INCDTLS223.GetValueOrDefault());

                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                {
                    sumConditionalIncdtls442Incdtls414 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(managedFund =>
                        managedFund.INCDTLS387.GetValueOrDefault() > 1
                        ? managedFund.INCDTLS442.GetValueOrDefault()
                        : managedFund.INCDTLS414.GetValueOrDefault()
                    );
                }

                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumIncdtls546 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(trustIncome => trustIncome.INCDTLS546.GetValueOrDefault());

                assertion = report.iitrParentDocument.IITR328.GetValueOrDefault() != Math.Truncate(sumIncdtls223 + sumConditionalIncdtls442Incdtls414 + sumIncdtls546);
            }
            
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731358",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian franking credits from a New Zealand franking company amount is incorrect",
                    LongDescription = @"The Australian franking credits from a New Zealand franking company amount must equal the sum of all the following amounts provided in the attached Income Details schedule: Australian franking credits from a NZ franking company; Your share of Australian credits from a NZ franking company from managed fund where there is more than one account holder; Total Australian credits from a NZ franking company from managed fund amounts where there is a single account holder; and Australian franking credits from a New Zealand company - Beneficiary share",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.FrankingCreditsNewZealand.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730358" },
                        new ProcessMessageParameter() { Name = "IITR328", Value = report.iitrParentDocument.IITR328.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS223)", Value = sumIncdtls223.ToString() },
                        new ProcessMessageParameter() { Name = "Managed Funds Total", Value = sumConditionalIncdtls442Incdtls414.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS546)", Value = sumIncdtls546.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730358

        #region VR.ATO.IITR.730359

        /* VR.ATO.IITR.730359
            The Foreign income tax offset amount must not exceed the sum of all of the following amounts provided in the attached Income Details schedule: Foreign pension or annuity foreign tax paid; Foreign income foreign tax paid; Foreign employment income foreign tax paid; Foreign rental income foreign tax paid; Other foreign income foreign tax paid; Foreign financial investment foreign tax paid (excluding NZ franking credits); Employee share scheme foreign tax paid; Your share of foreign income tax offset from managed fund where there is more than one account holder; Total foreign income tax offset from managed fund where there is a single account holder; and Foreign income tax offset - Beneficiary share

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR331 <> NULL AND ^IITR331 > (Sum(^INCDTLS212) + Sum(^INCDTLS190) + Sum(^INCDTLS169) + Sum(^INCDTLS220) + Sum(^INCDTLS227) + Sum(^INCDTLS224) + Sum(^INCDTLS507) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS430, ^INCDTLS400)) + Sum(^INCDTLS564))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR331 <> NULL AND ^IITR331 > (Sum(^INCDTLS212) + Sum(^INCDTLS190) + Sum(^INCDTLS169) + Sum(^INCDTLS220) + Sum(^INCDTLS227) + Sum(^INCDTLS224) + Sum(^INCDTLS507) + Sum(ConditionalValue(^INCDTLS387 > 1, ^INCDTLS430, ^INCDTLS400)) + Sum(^INCDTLS564))

        Data Elements:
    
            ^IITR331 = RP:Income.InternationalDealings.TaxOffset.Amount
    
            ^INCDTLS169 = INCDTLS169
    
            ^INCDTLS190 = INCDTLS190
    
            ^INCDTLS212 = INCDTLS212
    
            ^INCDTLS220 = INCDTLS220
    
            ^INCDTLS224 = INCDTLS224
    
            ^INCDTLS227 = INCDTLS227
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS400 = INCDTLS400
    
            ^INCDTLS430 = INCDTLS430
    
            ^INCDTLS507 = INCDTLS507

            ^INCDTLS564 = INCDTLS564
        */

        public static ProcessMessageDocument VR_ATO_IITR_730359(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            decimal sumIncdtls212 = 0;
            decimal sumIncdtls190 = 0;
            decimal sumIncdtls169 = 0;
            decimal sumIncdtls220 = 0;
            decimal sumIncdtls227 = 0;
            decimal sumIncdtls224 = 0;
            decimal sumIncdtls507 = 0;
            decimal sumConditionalIncdtls430Incdtls400 = 0;
            decimal sumIncdtls564 = 0;

            if (report.iitrParentDocument.IITR331 != null)
            {
                if (incdtlschilddoc.Rp_IncomeCollection != null)
                {
                    sumIncdtls169 = incdtlschilddoc.Rp_IncomeCollection.Sum(income => income.INCDTLS169.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_ForeignIncomeCollection != null)
                {
                    sumIncdtls190 = incdtlschilddoc.Rp_ForeignIncomeCollection.Sum(foreignIncome => foreignIncome.INCDTLS190.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection != null)
                {
                    sumIncdtls212 = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Sum(foreignPoA => foreignPoA.INCDTLS212.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_OtherForeignIncomeCollection != null)
                {
                    sumIncdtls220 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS220.GetValueOrDefault());
                    sumIncdtls224 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS224.GetValueOrDefault());
                    sumIncdtls227 = incdtlschilddoc.Rp_OtherForeignIncomeCollection.Sum(otherForeignIncome => otherForeignIncome.INCDTLS227.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null)
                {
                    sumIncdtls507 = incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(income => income.INCDTLS507.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                {
                    sumConditionalIncdtls430Incdtls400 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(managedFund =>
                    managedFund.INCDTLS387.GetValueOrDefault() > 1
                    ? managedFund.INCDTLS430.GetValueOrDefault()
                    : managedFund.INCDTLS400.GetValueOrDefault());
                }

                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumIncdtls564 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(trustIncome => trustIncome.INCDTLS564.GetValueOrDefault());

                assertion = report.iitrParentDocument.IITR331.GetValueOrDefault() > (sumIncdtls212 + sumIncdtls190 + sumIncdtls169 + sumIncdtls220 + sumIncdtls227 + sumIncdtls224 + sumIncdtls507 + sumConditionalIncdtls430Incdtls400) + sumIncdtls564;
            }

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731359",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Foreign income tax offset amount is incorrect",
                    LongDescription = @"The Foreign income tax offset amount must not exceed the sum of all of the following amounts provided in the attached Income Details schedule: Foreign pension or annuity foreign tax paid; Foreign income foreign tax paid; Foreign employment income foreign tax paid; Foreign rental income foreign tax paid; Other foreign income foreign tax paid; Foreign financial investment foreign tax paid (excluding NZ franking credits); Employee share scheme foreign tax paid; Your share of foreign income tax offset from managed fund where there is more than one account holder; Total foreign income tax offset from managed fund where there is a single account holder; and Foreign income tax offset - Beneficiary share",
                    Location = $"/xbrli:xbrl/tns:Income.InternationalDealings.TaxOffset.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730359" },
                        new ProcessMessageParameter() { Name = "IITR331", Value = report.iitrParentDocument.IITR331.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS212)", Value = sumIncdtls212.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS190)", Value = sumIncdtls190.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS169)", Value = sumIncdtls169.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS220)", Value = sumIncdtls220.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS227)", Value = sumIncdtls227.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS224)", Value = sumIncdtls224.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS507)", Value = sumIncdtls507.ToString() },
                        new ProcessMessageParameter() { Name = "Managed Funds Total", Value = sumConditionalIncdtls430Incdtls400.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS564)", Value = sumIncdtls564.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730359

        #region VR.ATO.IITR.730374

        /* VR.ATO.IITR.730374
            The Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts amount must equal the sum of all the following amounts provided in the attached Income Details schedule: Total other deductions for primary production distributions from managed fund where there is a single account holder; Your share of other deductions for primary production distributions from managed fund where there is more than one account holder; Primary production other deductions from partnership amounts; and Primary production other deductions from trusts amount

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR246 <> NULL AND ^IITR246 <> RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS403, ^INCDTLS433)) + Sum(^INCDTLS466) + Sum(^INCDTLS248), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR246 <> NULL AND ^IITR246 <> RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS403, ^INCDTLS433)) + Sum(^INCDTLS466) + Sum(^INCDTLS248), 0)

        Data Elements:
    
            ^IITR246 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
    
            ^INCDTLS248 = INCDTLS248
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS403 = INCDTLS403
    
            ^INCDTLS433 = INCDTLS433
    
            ^INCDTLS466 = INCDTLS466
        */

        public static ProcessMessageDocument VR_ATO_IITR_730374(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            decimal condition3_INCDTLS466Sum = 0m;
            decimal condition3_INCDTLS248Sum = 0m;
            decimal condition3_INCDTLS387ConditionalSum = 0m;

            // Condition 2: [iitr246] <> NULL 
            bool condition2_IITR246IsNotNull = report.iitrParentDocument.IITR246 != null;

            // Condition 3 Sum 1: SUM(ConditionalValue([incdtls387] = 1, [incdtls403], [incdtls433]))
            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
                condition3_INCDTLS387ConditionalSum = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(x => x.INCDTLS387 == 1 ? x.INCDTLS403.GetValueOrDefault() : x.INCDTLS433.GetValueOrDefault());

            // Condition 3 Sum 2: SUM([incdtls466])
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition3_INCDTLS466Sum = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS466.GetValueOrDefault());

            // Condition 3 Sum 2: Sum(^INCDTLS248)
            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                condition3_INCDTLS248Sum = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS248.GetValueOrDefault());

            // Condition 3 Total Sum: RoundDown(SUM(ConditionalValue([incdtls387] = 1, [incdtls403], [incdtls433])) + SUM([incdtls466]) + [incdtls248], 0)
            decimal condition3_INCDTLSTotalSum = Math.Truncate(condition3_INCDTLS387ConditionalSum + condition3_INCDTLS466Sum + condition3_INCDTLS248Sum);

            // Condition 3: [iitr246] <> RoundDown(SUM(ConditionalValue([incdtls387] = 1, [incdtls403], [incdtls433])) + SUM([incdtls466]) + [incdtls248], 0)
            bool condition3_IITR246IsNotEqual = report.iitrParentDocument.IITR246.GetValueOrDefault() != condition3_INCDTLSTotalSum;

            // Rule assertion: condition1 AND condition2 AND condition3
            bool assertion = (condition2_IITR246IsNotNull && condition3_IITR246IsNotEqual);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730374",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts is incorrect",
                    LongDescription = @"The Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts amount must equal the sum of all the following amounts provided in the attached Income Details schedule: Total other deductions for primary production distributions from managed fund where there is a single account holder; Your share of other deductions for primary production distributions from managed fund where there is more than one account holder; Primary production other deductions from partnership amounts; and Primary production other deductions from trusts amount",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730374" },
                        new ProcessMessageParameter() { Name = "IITR246", Value = report.iitrParentDocument.IITR246.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IITR403/433 Sum", Value = condition3_INCDTLS387ConditionalSum.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS466 Sum", Value = condition3_INCDTLS466Sum.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS248 Sum", Value = condition3_INCDTLS248Sum.ToString() },
                        new ProcessMessageParameter() { Name = "Total Sum", Value = condition3_INCDTLSTotalSum.ToString() },
                        new ProcessMessageParameter() { Name = "IITR248 = Total Sum", Value = condition3_IITR246IsNotEqual.ToString() },
                    },
                };

            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730374

        #region VR.ATO.IITR.730375

        /* VR.ATO.IITR.730375
            Where any Total other deductions for primary production distributions from managed fund, Primary production other deductions from partnership, or Primary production other deductions from trusts amounts are present in the attached Income Details schedule, the Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR246 = NULL AND (AnyOccurrence(^INCDTLS403, ^INCDTLS403 <> NULL) OR AnyOccurrence(^INCDTLS466, ^INCDTLS466 <> NULL) OR AnyOccurrence(^INCDTLS248, ^INCDTLS248 <> NULL))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR246 = NULL AND (AnyOccurrence(^INCDTLS403, ^INCDTLS403 <> NULL) OR AnyOccurrence(^INCDTLS466, ^INCDTLS466 <> NULL) OR AnyOccurrence(^INCDTLS248, ^INCDTLS248 <> NULL))

        Data Elements:
    
            ^IITR246 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
    
            ^INCDTLS248 = INCDTLS248
    
            ^INCDTLS403 = INCDTLS403
    
            ^INCDTLS466 = INCDTLS466
        */

        public static ProcessMessageDocument VR_ATO_IITR_730375(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool Condition3_INCDTLS403AnyNotNull = false;
            bool Condition4_INCDTLS466AnyNotNull = false;
            bool Condition5_INCDTLS248AnyNotNull = false;

            // Condition 2: [iitr246] = NULL
            bool condition2_IITR246IsNull = report.iitrParentDocument.IITR246 == null;

            // Condition 3: ANY OCCURRENCE OF([incdtls403]) <> NULL
            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
                Condition3_INCDTLS403AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS403 != null);

            // Condition 4: ANY OCCURRENCE OF ([incdtls466]) <> NULL)
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition4_INCDTLS466AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS466 != null);

            // Condition 5: AnyOccurrence(^INCDTLS248, ^INCDTLS248 <> NULL)
            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                Condition5_INCDTLS248AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS248 != null);

            bool assertion = condition2_IITR246IsNull && (Condition3_INCDTLS403AnyNotNull || Condition4_INCDTLS466AnyNotNull || Condition5_INCDTLS248AnyNotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730375",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts must be provided",
                    LongDescription = @"Where any Total other deductions for primary production distributions from managed fund, Primary production other deductions from partnership, or Primary production other deductions from trusts amounts are present in the attached Income Details schedule, the Deductions relating to amounts shown at Distribution from partnerships and Share of net income from trusts amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730375" },
                        new ProcessMessageParameter() { Name = "IITR246", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS403 <> NULL", Value = Condition3_INCDTLS403AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS466 <> NULL", Value = Condition4_INCDTLS466AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS248 <> NULL", Value = Condition5_INCDTLS248AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730375

        #region VR.ATO.IITR.730376

        /* VR.ATO.IITR.730376
            When the individual is an Australian resident for the full year, the Country of residence when the dividend was paid or credited in the attached Income Details schedule must not be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR19 = TRUE AND ^IITR666 = NULL AND ^IITR667 = NULL) AND AnyOccurrence(^INCDTLS348, ^INCDTLS348 <> NULL)

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR19 = TRUE AND ^IITR666 = NULL AND ^IITR667 = NULL) AND AnyOccurrence(^INCDTLS348, ^INCDTLS348 <> NULL)

        Data Elements:
    
            ^IITR19 = RP:Residency.TaxPurposesPersonStatus.Indicator
    
            ^IITR666 = RP:Residency.TaxPurposesStart.Date
    
            ^IITR667 = RP:Residency.TaxPurposesEnd.Date
    
            ^INCDTLS348 = INCDTLS348
        */

        public static ProcessMessageDocument VR_ATO_IITR_730376(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            // COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.                        

            // ANY OCCURRENCE OF(incdtls348) <> NULL
            bool anyINCDTLS348NotNull = incdtlschilddoc != null &&
                incdtlschilddoc.Rp_DividendsCollection != null &&
                incdtlschilddoc.Rp_DividendsCollectionExists &&
                incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS348 != null);

            bool assertion =
                // iitr19 = TRUE
                report.iitrParentDocument.IITR19.GetValueOrDefault() &&
                // iitr666 = NULL
                report.iitrParentDocument.IITR666 == null &&
                // iitr667 = NULL
                report.iitrParentDocument.IITR667 == null &&
                // ANY OCCURRENCE OF(incdtls348) <> NULL
                anyINCDTLS348NotNull;

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730376",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Country of residence when the dividend was paid or credited must not be provided",
                    LongDescription = @"When the individual is an Australian resident for the full year, the Country of residence when the dividend was paid or credited in the attached Income Details schedule must not be provided",
                    Location = $"/xbrli:xbrl/tns:Residency.TaxPurposesPersonStatus.Indicator='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730376" },
                        new ProcessMessageParameter() { Name = "IITR19", Value = report.iitrParentDocument.IITR19.ToString() },
                        new ProcessMessageParameter() { Name = "IITR666", Value = report.iitrParentDocument.IITR666.ToString() },
                        new ProcessMessageParameter() { Name = "IITR667", Value = report.iitrParentDocument.IITR667.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls348) <> NULL", Value = anyINCDTLS348NotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730376

        #region VR.ATO.IITR.730377

        /* VR.ATO.IITR.730377
            When the individual is an Australian resident for the full year, the Country of residence when the interest was paid or credited in the attached Income Details schedule must not be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR19 = TRUE AND ^IITR666 = NULL AND ^IITR667 = NULL) AND AnyOccurrence(^INCDTLS354, ^INCDTLS354 <> NULL)

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR19 = TRUE AND ^IITR666 = NULL AND ^IITR667 = NULL) AND AnyOccurrence(^INCDTLS354, ^INCDTLS354 <> NULL)

        Data Elements:
    
            ^IITR19 = RP:Residency.TaxPurposesPersonStatus.Indicator
    
            ^IITR666 = RP:Residency.TaxPurposesStart.Date
    
            ^IITR667 = RP:Residency.TaxPurposesEnd.Date
    
            ^INCDTLS354 = INCDTLS354
        */

        public static ProcessMessageDocument VR_ATO_IITR_730377(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            // COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.                        

            // ANY OCCURRENCE OF(incdtls354) <> NULL
            bool anyINCDTLS354NotNull = incdtlschilddoc != null &&
                incdtlschilddoc.Rp_InterestCollection != null &&
                incdtlschilddoc.Rp_InterestCollectionExists &&
                incdtlschilddoc.Rp_InterestCollection.Any(tuple => tuple.INCDTLS354 != null);

            bool assertion =
                // iitr19 = TRUE
                report.iitrParentDocument.IITR19.GetValueOrDefault() &&
                // iitr666 = NULL
                report.iitrParentDocument.IITR666 == null &&
                // iitr667 = NULL
                report.iitrParentDocument.IITR667 == null &&
                // ANY OCCURRENCE OF(incdtls354) <> NULL
                anyINCDTLS354NotNull;

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730377",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Country of residence when the interest was paid or credited must not be provided",
                    LongDescription = @"When the individual is an Australian resident for the full year, the Country of residence when the interest was paid or credited in the attached Income Details schedule must not be provided",
                    Location = $"/xbrli:xbrl/tns:Residency.TaxPurposesPersonStatus.Indicator='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730377" },
                        new ProcessMessageParameter() { Name = "IITR19", Value = report.iitrParentDocument.IITR19.ToString() },
                        new ProcessMessageParameter() { Name = "IITR666", Value = report.iitrParentDocument.IITR666.ToString() },
                        new ProcessMessageParameter() { Name = "IITR667", Value = report.iitrParentDocument.IITR667.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls354) <> NULL", Value = anyINCDTLS354NotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730377

        #region VR.ATO.IITR.730378

        /* VR.ATO.IITR.730378
            Country of residence when the interest was paid or credited must be provided when Australian residency start and end dates have been provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR666 <> NULL OR ^IITR667 <> NULL) AND (AnyOccurrence(^INCDTLS350, ^INCDTLS350 <> NULL) WHERE ^INCDTLS354 = NULL)

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR666 <> NULL OR ^IITR667 <> NULL) AND (AnyOccurrence(^INCDTLS350, ^INCDTLS350 <> NULL) WHERE ^INCDTLS354 = NULL)

        Data Elements:
    
            ^IITR666 = RP:Residency.TaxPurposesStart.Date
    
            ^IITR667 = RP:Residency.TaxPurposesEnd.Date
    
            ^INCDTLS350 = INCDTLS350
    
            ^INCDTLS354 = INCDTLS354
        */

        public static ProcessMessageDocument VR_ATO_IITR_730378(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            // COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.                        

            // ([iitr666] <> NULL)
            bool isIITR666NotNull = report.iitrParentDocument.IITR666 != null;

            // ([iitr667] <> NULL)
            bool isIITR667NotNull = report.iitrParentDocument.IITR667 != null;

            // ([iitr666] <> NULL OR [iitr667] <> NULL)
            bool isIITR666OrIITR667NotNull = isIITR666NotNull || isIITR667NotNull;

            // ANY OCCURRENCE OF(incdtls350) <> NULL WHERE incdtls354 = NULL
            bool anyINCDTLS350WhereINCDTLS354IsNull =
                incdtlschilddoc != null &&
                incdtlschilddoc.Rp_InterestCollection != null &&
                incdtlschilddoc.Rp_InterestCollectionExists &&
                incdtlschilddoc.Rp_InterestCollection.Any(tuple => tuple.INCDTLS354 == null);

            ProcessMessageDocument processMessage = null;

            bool assertion = isIITR666OrIITR667NotNull && anyINCDTLS350WhereINCDTLS354IsNull;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730378",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Country of residence when the interest was paid or credited must be provided",
                    LongDescription = "Country of residence when the interest was paid or credited must be provided when Australian residency start and end dates have been provided",
                    Location = "/xbrli:xbrl/tns:Residency.TaxPurposesStart.Date[@contextRef='" + report.iitrParentDocument.RPId + "']",

                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730378" },
                        new ProcessMessageParameter() { Name = "IITR666", Value = report.iitrParentDocument.IITR666.ToString() },
                        new ProcessMessageParameter() { Name = "IITR667", Value = report.iitrParentDocument.IITR667.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls350) <> NULL WHERE incdtls354 = NULL", Value = anyINCDTLS350WhereINCDTLS354IsNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730379

        /* VR.ATO.IITR.730379
            Where any Total TFN amounts withheld from gross interest are present where the Country of residence for tax purposes when interest was paid or credited is "Australia", "Christmas Island", "Norfolk Island", "Cocos (Keeling) Islands" or "Heard and McDonald Islands" on the Income Details schedule, the TFN amounts withheld from gross interest must be provided

        Legacy Rule Format:
            ^IITR116 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS358, ^INCDTLS358 <> NULL) WHERE (^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')))

        Technical Business Rule Format:
            ^IITR116 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS358, ^INCDTLS358 <> NULL) WHERE (^INCDTLS354 = NULL OR InSet(^INCDTLS354, '"au","cc","cx","nf","hm"')))

        Data Elements:
    
            ^IITR116 = RP:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
    
            ^INCDTLS354 = INCDTLS354
    
            ^INCDTLS358 = INCDTLS358
        */

        public static ProcessMessageDocument VR_ATO_IITR_730379(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            if (incdtlschilddoc.Rp_InterestCollection != null)
            {
                bool assertion = (report.iitrParentDocument.IITR116 == null && (incdtlschilddoc.Rp_InterestCollection.Where(t => t.INCDTLS358 != null && australianCountryCodes.Contains(t.INCDTLS354)).Count() != 0));
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730379",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"TFN amounts withheld from gross interest must be provided",
                        LongDescription = @"Where any Total TFN amounts withheld from gross interest are present where the Country of residence for tax purposes when interest was paid or credited is ""Australia"", ""Christmas Island"", ""Norfolk Island"", ""Cocos (Keeling) Islands"" or ""Heard and McDonald Islands"" on the Income Details schedule, the TFN amounts withheld from gross interest must be provided",
                        Location = $"/xbrli:xbrl/tns:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730379" },
                        new ProcessMessageParameter() { Name = "IITR116", Value = "null" }},
                    };
                }
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730379

        #region VR.ATO.IITR.730402

        /* VR.ATO.IITR.730402
            The ESS TFN amounts withheld from discounts must equal the sum of all ESS TFN amounts withheld from discounts in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR128 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR128 <> Sum(^INCDTLS505))

        Technical Business Rule Format:
            ^IITR128 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR128 <> Sum(^INCDTLS505))

        Data Elements:
    
            ^IITR128 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount
    
            ^INCDTLS505 = INCDTLS505
        */

        public static ProcessMessageDocument VR_ATO_IITR_730402(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR128 != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null && report.iitrParentDocument.IITR128.GetValueOrDefault() != incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(tuple => tuple.INCDTLS505.GetValueOrDefault());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730402",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"ESS TFN amounts withheld from discounts is incorrect",
                    LongDescription = @"The ESS TFN amounts withheld from discounts must equal the sum of all ESS TFN amounts withheld from discounts in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730402" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730403

        /* VR.ATO.IITR.730403
            Where any ESS TFN amounts withheld from discounts are present in the attached Income Details schedule, the ESS TFN amounts withheld from discounts must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR128 = NULL AND AnyOccurrence(^INCDTLS505, ^INCDTLS505 <> NULL)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR128 = NULL AND AnyOccurrence(^INCDTLS505, ^INCDTLS505 <> NULL)

        Data Elements:
    
            ^IITR128 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount
    
            ^INCDTLS505 = INCDTLS505
        */

        public static ProcessMessageDocument VR_ATO_IITR_730403(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR128 == null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Exists(tuple => tuple.INCDTLS505 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730403",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"ESS TFN amounts withheld from discounts must be provided",
                    LongDescription = @"Where any ESS TFN amounts withheld from discounts are present in the attached Income Details schedule, the ESS TFN amounts withheld from discounts must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730403" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730404

        /* VR.ATO.IITR.730404
            The Foreign source discounts amount must equal the sum of all Foreign source discounts amounts in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR129 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR129 <> Sum(^INCDTLS506))

        Technical Business Rule Format:
            ^IITR129 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR129 <> Sum(^INCDTLS506))

        Data Elements:
    
            ^IITR129 = RP:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount
    
            ^INCDTLS506 = INCDTLS506
        */

        public static ProcessMessageDocument VR_ATO_IITR_730404(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR129 != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null && report.iitrParentDocument.IITR129.GetValueOrDefault() != incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Sum(tuple => tuple.INCDTLS506.GetValueOrDefault());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730404",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Foreign source discounts amount is incorrect",
                    LongDescription = @"The Foreign source discounts amount must equal the sum of all Foreign source discounts amounts in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730404" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730405

        /* VR.ATO.IITR.730405
            Where any Foreign source discounts amounts are present in the Income Details schedule, the Foreign source discounts amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR129 = NULL AND AnyOccurrence(^INCDTLS506, ^INCDTLS506 <> NULL)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR129 = NULL AND AnyOccurrence(^INCDTLS506, ^INCDTLS506 <> NULL)

        Data Elements:
    
            ^IITR129 = RP:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount
    
            ^INCDTLS506 = INCDTLS506
        */

        public static ProcessMessageDocument VR_ATO_IITR_730405(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = report.iitrParentDocument.IITR129 == null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection != null && incdtlschilddoc.Rp_EmployeeShareSchemeCollection.Exists(tuple => tuple.INCDTLS506 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730405",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Foreign source discounts must be provided",
                    LongDescription = @"Where any Foreign source discounts amounts are present in the Income Details schedule, the Foreign source discounts amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730405" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730434

        /* VR.ATO.IITR.730434
            Country of residence when the dividend was paid or credited must be provided when Australian residency start and end dates have been provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR666 <> NULL OR ^IITR667 <> NULL) AND (AnyOccurrence(^INCDTLS344, ^INCDTLS344 <> NULL) WHERE ^INCDTLS348 = NULL)

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR666 <> NULL OR ^IITR667 <> NULL) AND (AnyOccurrence(^INCDTLS344, ^INCDTLS344 <> NULL) WHERE ^INCDTLS348 = NULL)

        Data Elements:
    
            ^IITR666 = RP:Residency.TaxPurposesStart.Date
    
            ^IITR667 = RP:Residency.TaxPurposesEnd.Date
    
            ^INCDTLS344 = INCDTLS344
    
            ^INCDTLS348 = INCDTLS348
        */

        public static ProcessMessageDocument VR_ATO_IITR_730434(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            // COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.                        

            // ([iitr666] <> NULL)
            bool isIITR666NotNull = report.iitrParentDocument.IITR666 != null;

            // ([iitr667] <> NULL)
            bool isIITR667NotNull = report.iitrParentDocument.IITR667 != null;

            // ([iitr666] <> NULL OR [iitr667] <> NULL)
            bool isIITR666OrIITR667NotNull = isIITR666NotNull || isIITR667NotNull;

            // ANY OCCURRENCE OF(incdtls344) <> NULL WHERE incdtls348 = NULL
            bool anyINCDTLS344WhereINCDTLS348IsNull =
                incdtlschilddoc != null &&
                incdtlschilddoc.Rp_DividendsCollection != null &&
                incdtlschilddoc.Rp_DividendsCollectionExists &&
                incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS348 == null);

            ProcessMessageDocument processMessage = null;

            bool assertion = isIITR666OrIITR667NotNull && anyINCDTLS344WhereINCDTLS348IsNull;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730434",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Country of residence when the dividend was paid or credited must be provided",
                    LongDescription = @"Country of residence when the dividend was paid or credited must be provided when Australian residency start and end dates have been provided",
                    Location = "/xbrli:xbrl/tns:Residency.TaxPurposesStart.Date[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730434" },
                        new ProcessMessageParameter() { Name = "IITR666", Value = report.iitrParentDocument.IITR666.ToString() },
                        new ProcessMessageParameter() { Name = "IITR667", Value = report.iitrParentDocument.IITR667.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF(incdtls344) <> NULL WHERE incdtls348 = NULL", Value = anyINCDTLS344WhereINCDTLS348IsNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730436

        /* VR.ATO.IITR.730436
            When the total of; the sum of Special professional taxable income already included elsewhere on this return; plus the sum of Other income amount where the income type is "Special professional income"; less the sum of Deductible expenses for special professional taxable income; less the sum of Deductible expenses for special professional taxable income included elsewhere on this return; provided in the attached Income Details schedule is positive, then Taxable professional income must equal this total.Otherwise Taxable professional income must be zero.

        Legacy Rule Format:
            ^IITR355<> NULL AND CountDocument('INCDTLS') = 1 AND ((RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0) > 0 AND ^IITR355<> RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0)) OR(RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0) <= 0 AND ^IITR355<> 0))

        Technical Business Rule Format:
            ^IITR355<> NULL AND CountDocument('INCDTLS') = 1 AND((RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0) > 0 AND ^IITR355<> RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0)) OR(RoundDown((Sum(^INCDTLS453) + Sum(ConditionalValue(^INCDTLS449 = 'Special professional income', ^INCDTLS451, 0)) - Sum(^INCDTLS454) - Sum(^INCDTLS455)), 0) <= 0 AND ^IITR355<> 0))

        Data Elements:
    
            ^IITR355 = RP:Income.SpecialProfessional.Amount
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
    
            ^INCDTLS453 = INCDTLS453
    
            ^INCDTLS454 = INCDTLS454
    
            ^INCDTLS455 = INCDTLS455
        */

        public static ProcessMessageDocument VR_ATO_IITR_730436(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool assertion = false;
            ProcessMessageDocument processMessage = null;

            decimal condition3a_SumINCDTLS453 = 0;
            decimal condition3b_SumINCDTLS451WhenConditionIsMet = 0;
            decimal condition3c_SumINCDTLS454 = 0;
            decimal condition3d_SumINCDTLS455 = 0;
            decimal totalSum = 0;

            // Condition 1: [iitr355] <> NULL
            if (report.iitrParentDocument.IITR355 != null)
            {
                // Condition 2: INCDTLS form is already provided
                if (incdtlschilddoc.Rp_IncomeOtherCollection != null)
                {
                    List<INCDTLS2026.Rp_IncomeOther> otherIncomes = incdtlschilddoc.Rp_IncomeOtherCollection;

                    // Conditional 3a: (SUM([incdtls453])
                    condition3a_SumINCDTLS453 = otherIncomes.Sum(tuple => tuple.INCDTLS453.GetValueOrDefault());

                    // Conditional 3b: SUM(ConditionalValue([incdtls449] = "Special professional income", [incdtls451], 0))
                    condition3b_SumINCDTLS451WhenConditionIsMet = otherIncomes.Sum(tuple => tuple.INCDTLS449 == ("Special professional income") ? tuple.INCDTLS451.GetValueOrDefault() : 0);

                    // Conditional 3c: (SUM([incdtls454])
                    condition3c_SumINCDTLS454 = otherIncomes.Sum(tuple => tuple.INCDTLS454.GetValueOrDefault());

                    // Conditional 3d: (SUM([incdtls455])
                    condition3d_SumINCDTLS455 = otherIncomes.Sum(tuple => tuple.INCDTLS455.GetValueOrDefault());
                }

                // Condition 3 Total Sum: RoundDown((SUM([incdtls453]) + SUM(ConditionalValue([incdtls449] = "Special professional income", [incdtls451], 0)) - SUM([incdtls454]) - SUM([incdtls455])), 0)
                totalSum = Math.Truncate(condition3a_SumINCDTLS453 + condition3b_SumINCDTLS451WhenConditionIsMet - condition3c_SumINCDTLS454 - condition3d_SumINCDTLS455);

                // Condition 3: ((RoundDown((SUM([incdtls453]) + SUM(ConditionalValue([incdtls449] = "Special professional income", [incdtls451], 0)) - SUM([incdtls454]) - SUM([incdtls455])), 0) > 0 AND [iitr355] <> (SUM([incdtls453]) + SUM(ConditionalValue([incdtls449] = "Special professional income", [incdtls451], 0)) - SUM([incdtls454]) - SUM([incdtls455]))) OR (RoundDown((SUM([incdtls453]) + SUM(ConditionalValue([incdtls449] = "Special professional income", [incdtls451], 0)) - SUM([incdtls454]) - SUM([incdtls455])), 0) <= 0 AND [iitr355] <> 0))
                assertion = (totalSum > 0 && report.iitrParentDocument.IITR355.GetValueOrDefault() != totalSum) || (totalSum <= 0 && report.iitrParentDocument.IITR355.GetValueOrDefault() != 0);

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730436",
                        Severity = ProcessMessageSeverity.Error,
                        Description = "Taxable professional income is incorrect",
                        LongDescription = @"When the total of; the sum of Special professional taxable income already included elsewhere on this return; plus the sum of Other income amount where the income type is ""Special professional income""; less the sum of Deductible expenses for special professional taxable income; less the sum of Deductible expenses for special professional taxable income included elsewhere on this return; provided in the attached Income Details schedule is positive, then Taxable professional income must equal this total. Otherwise Taxable professional income must be zero.",
                        Location = "/xbrli:xbrl/tns:Income.SpecialProfessional.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730436" },
                            new ProcessMessageParameter() { Name = "iitr355", Value = report.iitrParentDocument.IITR355.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS453", Value = condition3a_SumINCDTLS453.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS454", Value = condition3c_SumINCDTLS454.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS455", Value = condition3d_SumINCDTLS455.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS451 when INCDTLS449 is 'Special professional income'", Value = condition3b_SumINCDTLS451WhenConditionIsMet.ToString() },
                            new ProcessMessageParameter() { Name = "Total of Sum of INCDTLS fields", Value = totalSum.ToString() }
                        },
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730437

        /* VR.ATO.IITR.730437
            Where Special professional taxable income already included elsewhere on this return, Deductible expenses for special professional taxable income, Deductible expenses for special professional taxable income included elsewhere on this return, or any Other income amount where the income type is "Special professional income" is present in the attached Income Details schedule, the Taxable professional income must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR355 = NULL AND (AnyOccurrence(^INCDTLS453, ^INCDTLS453 <> NULL) OR AnyOccurrence(^INCDTLS454, ^INCDTLS454 <> NULL) OR AnyOccurrence(^INCDTLS455, ^INCDTLS455 <> NULL) OR (AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Special professional income'))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR355 = NULL AND (AnyOccurrence(^INCDTLS453, ^INCDTLS453 <> NULL) OR AnyOccurrence(^INCDTLS454, ^INCDTLS454 <> NULL) OR AnyOccurrence(^INCDTLS455, ^INCDTLS455 <> NULL) OR (AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Special professional income'))

        Data Elements:
    
            ^IITR355 = RP:Income.SpecialProfessional.Amount
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
    
            ^INCDTLS453 = INCDTLS453
    
            ^INCDTLS454 = INCDTLS454
    
            ^INCDTLS455 = INCDTLS455
        */

        public static ProcessMessageDocument VR_ATO_IITR_730437(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool nullIITR355 = report.iitrParentDocument.IITR355 == null;
            bool? notNullINCDTLS453 = incdtlschilddoc.Rp_IncomeOtherCollection?.Any(tuple => tuple.INCDTLS453 != null);
            bool? notNullINCDTLS454 = incdtlschilddoc.Rp_IncomeOtherCollection?.Any(tuple => tuple.INCDTLS454 != null);
            bool? notNullINCDTLS455 = incdtlschilddoc.Rp_IncomeOtherCollection?.Any(tuple => tuple.INCDTLS455 != null);
            bool? notNullINCDTLS451 = incdtlschilddoc.Rp_IncomeOtherCollection?.Any(tuple => tuple.INCDTLS449.Equals("Special professional income") ? tuple.INCDTLS451 != null : false);

            if (nullIITR355 && ((notNullINCDTLS453 ?? false) || (notNullINCDTLS454 ?? false) || (notNullINCDTLS455 ?? false) || (notNullINCDTLS451 ?? false)))
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730437",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Taxable professional income must be provided",
                    LongDescription = @"Where Special professional taxable income already included elsewhere on this return, Deductible expenses for special professional taxable income, Deductible expenses for special professional taxable income included elsewhere on this return, or any Other income amount where the income type is ""Special professional income"" is present in the attached Income Details schedule, the Taxable professional income must be provided",
                    Location = "/xbrli:xbrl/tns:Income.SpecialProfessional.Amount[@contextRef ='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730437" },
                        new ProcessMessageParameter() { Name = "[iitr355] = NULL", Value = nullIITR355.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls453]) <> NULL", Value = notNullINCDTLS453.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls454]) <> NULL", Value = notNullINCDTLS454.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls455]) <> NULL", Value = notNullINCDTLS455.ToString() },
                        new ProcessMessageParameter() { Name = @"ANY OCCURRENCE OF ([incdtls451]) <> NULL WHERE [incdtls449] = ""Special professional income"")", Value = notNullINCDTLS451.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        static decimal BusinessPaymentSummarySum(INCDTLS2026.Rp_BusinessIncomePaymentSummaries tupleInstance, string paymentType, string incomeType, string industryProductionType)
        {
            bool includeInSum = tupleInstance.INCDTLS489 == paymentType && tupleInstance.INCDTLS490 == incomeType && tupleInstance.INCDTLS491 == industryProductionType;
            return includeInSum ? tupleInstance.INCDTLS492.Value : 0;
        }

        #region VR.ATO.IITR.730277

        /* VR.ATO.IITR.730277
            PP - Gross payments where Australian Business Number not quoted must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "012" (no ABN quoted), Business income statement type is "Business", and Business income statement industry production type is "Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR436 <> NULL AND ^IITR436 <> Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
                CountDocument('INCDTLS') = 1 AND ^IITR436 <> NULL AND ^IITR436 <> Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR436 = RP:Income.ABNNotQuotedPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */
        public static ProcessMessageDocument VR_ATO_IITR_730277(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR436NotNull = false;
            bool condition3_IITR436EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "012", INCDTLS490 is "Business", and INCDTLS491 is "Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "012", "Business", "Primary")));

            // Condition 2: [iitr436] <> NULL
            condition2_IITR436NotNull = (report.iitrParentDocument.IITR436 != null);

            // Condition 3: [iitr436] <> SUM(ConditionalValue(([incdtls489] = "012" AND [incdtls490] = "Business" AND [incdtls491] = "Primary"), [incdtls492], 0))
            condition3_IITR436EqualsSum = report.iitrParentDocument.IITR436 != sumOfINCDTLS492;

            assertion = (condition2_IITR436NotNull && condition3_IITR436EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730277",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments where Australian Business Number not quoted is incorrect",
                    LongDescription = @"PP - Gross payments where Australian Business Number not quoted must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is ""012"" (no ABN quoted), Business income statement type is ""Business"", and Business income statement industry production type is ""Primary""",
                    Location = "/xbrli:xbrl/tns:Income.ABNNotQuotedPrimaryProductionPaymentGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730277" },
                        new ProcessMessageParameter() { Name = "IITR436", Value = report.iitrParentDocument.IITR436.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730277

        #region VR.ATO.IITR.730278

        /* VR.ATO.IITR.730278
            Non-PP - Gross payments where Australian Business Number not quoted must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "012" (no ABN quoted), Business income statement type is "Business", and Business income statement industry production type is "Non-Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR437 <> NULL AND ^IITR437 <> Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR437 <> NULL AND ^IITR437 <> Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR437 = RP:Income.ABNNotQuotedNonPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730278(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR437NotNull = false;
            bool condition3_IITR437EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "012", INCDTLS490 is "Business", and INCDTLS491 is "Non-Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "012", "Business", "Non-Primary")));

            // Condition 2: [iitr437] <> NULL
            condition2_IITR437NotNull = (report.iitrParentDocument.IITR437 != null);

            // Condition 3: [iitr437] <> SUM(ConditionalValue(([incdtls489] = "012" AND [incdtls490] = "Business" AND [incdtls491] = "Non-Primary"), [incdtls492], 0))
            condition3_IITR437EqualsSum = report.iitrParentDocument.IITR437 != sumOfINCDTLS492;

            assertion = (condition2_IITR437NotNull && condition3_IITR437EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730278",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments where Australian Business Number not quoted is incorrect",
                    LongDescription = @"Non-PP - Gross payments where Australian Business Number not quoted must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is ""012'""(no ABN quoted), Business income statement type is ""Business"", and Business income statement industry production type is ""Non-Primary""",
                    Location = "/xbrli:xbrl/tns:Income.ABNNotQuotedNonPrimaryProductionPaymentGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730278" },
                        new ProcessMessageParameter() { Name = "IITR437", Value = report.iitrParentDocument.IITR437.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730278

        #region VR.ATO.IITR.730279

        /* VR.ATO.IITR.730279
            Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "011" (foreign resident withholding) and Business income statement type is "Business"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR438 <> NULL AND ^IITR438 <> Sum(ConditionalValue(^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business', ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR438 <> NULL AND ^IITR438 <> Sum(ConditionalValue(^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business', ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR438 = RP:Income.ForeignResidentWithholdingNonPrimaryProduction.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730279(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR438NotNull = false;
            bool condition3_IITR438EqualsSum = false;
            decimal sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "011"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "011" && tuple.INCDTLS490 == "Business" ? tuple.INCDTLS492.GetValueOrDefault() : 0));

            // Condition 2: [iitr438] <> NULL
            condition2_IITR438NotNull = (report.iitrParentDocument.IITR438 != null);

            // Condition 3: [iitr438] <> SUM(ConditionalValue([incdtls489] = "011", [incdtls492], 0))
            condition3_IITR438EqualsSum = report.iitrParentDocument.IITR438 != sumOfINCDTLS492;

            assertion = (condition2_IITR438NotNull && condition3_IITR438EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730279",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) is incorrect",
                    LongDescription = "Non-PP - Gross payments subject to foreign resident withholding (excluding capital gains) must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is \"011\" (foreign resident withholding) and Business income statement type is \"Business\"",
                    Location = "/xbrli:xbrl/tns:Income.ForeignResidentWithholdingNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730279" },
                        new ProcessMessageParameter() { Name = "IITR438", Value = report.iitrParentDocument.IITR438.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.730279

        #region VR.ATO.IITR.730280

        /* VR.ATO.IITR.730280
            PP - Gross payments voluntary agreement must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "003" (voluntary agreement), Business income statement type is "Business", and Business income statement industry production type is "Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR439 <> NULL AND ^IITR439 <> Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR439 <> NULL AND ^IITR439 <> Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR439 = RP:Income.VoluntaryAgreementPrimaryProductionGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730280(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR439NotNull = false;
            bool condition3_IITR439EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "003", INCDTLS490 is "Business", and INCDTLS491 is "Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "003", "Business", "Primary")));

            // Condition 2: [IITR439] <> NULL
            condition2_IITR439NotNull = (report.iitrParentDocument.IITR439 != null);

            // Condition 3: [IITR439] <> SUM(ConditionalValue(([incdtls489] = "003" AND [incdtls490] = "Business" AND [incdtls491] = "Primary"), [incdtls492], 0))
            condition3_IITR439EqualsSum = report.iitrParentDocument.IITR439 != sumOfINCDTLS492;

            assertion = (condition2_IITR439NotNull && condition3_IITR439EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730280",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments voluntary agreement is incorrect",
                    LongDescription = "PP - Gross payments voluntary agreement must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is \"003\" (voluntary agreement), Business income statement type is \"Business\", and Business income statement industry production type is \"Primary\"",
                    Location = "/xbrli:xbrl/tns:Income.VoluntaryAgreementPrimaryProductionGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730280" },
                        new ProcessMessageParameter() { Name = "IITR439", Value = report.iitrParentDocument.IITR439.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730280

        #region VR.ATO.IITR.730281

        /* VR.ATO.IITR.730281
            Non-PP - Gross payments voluntary agreement must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "003" (voluntary agreement), Business income statement type is "Business", and Business income statement industry production type is "Non-Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR440 <> NULL AND ^IITR440 <> Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR440 <> NULL AND ^IITR440 <> Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR440 = RP:Income.VoluntaryAgreementNonPrimaryProductionGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730281(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR440NotNull = false;
            bool condition3_IITR440EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "003", INCDTLS490 is "Business", and INCDTLS491 is "Non-Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "003", "Business", "Non-Primary")));

            // Condition 2: [iitr440] <> NULL
            condition2_IITR440NotNull = (report.iitrParentDocument.IITR440 != null);

            // Condition 3: [iitr440] <> SUM(ConditionalValue(([incdtls489] = "003" AND [incdtls490] = "Business" AND [incdtls491] = "Non-Primary"), [incdtls492], 0))
            condition3_IITR440EqualsSum = report.iitrParentDocument.IITR440 != sumOfINCDTLS492;

            assertion = (condition2_IITR440NotNull && condition3_IITR440EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730281",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments voluntary agreement is incorrect",
                    LongDescription = "Non-PP - Gross payments voluntary agreement must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is \"003\" (voluntary agreement), Business income statement type is \"Business\", and Business income statement industry production type is \"Non-Primary\"",
                    Location = "/xbrli:xbrl/tns:Income.VoluntaryAgreementNonPrimaryProductionGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730281" },
                        new ProcessMessageParameter() { Name = "IITR440", Value = report.iitrParentDocument.IITR440.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730281

        #region VR.ATO.IITR.730282

        /* VR.ATO.IITR.730282
            PP - Gross payments labour hire or other specified payments must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "001" (labour hire) or "002" (other specified payments), Business income statement type is "Business", and Business income statement industry production type is "Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR441 <> NULL AND ^IITR441 <> Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR441 <> NULL AND ^IITR441 <> Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR441 = RP:Income.LabourHireArrangementPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730282(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR441NotNull = false;
            bool condition3_IITR441EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "001" OR "002", INCDTLS490 is "Business", and INCDTLS491 is "Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
            {
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "001", "Business", "Primary")));
                sumOfINCDTLS492 += (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "002", "Business", "Primary")));
            }

            // Condition 2: [iitr441] <> NULL
            condition2_IITR441NotNull = (report.iitrParentDocument.IITR441 != null);

            // Condition 3: [iitr441] <> SUM(ConditionalValue((([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Business" AND [incdtls491] = "Primary"), [incdtls492], 0))
            condition3_IITR441EqualsSum = report.iitrParentDocument.IITR441 != sumOfINCDTLS492;

            assertion = (condition2_IITR441NotNull && condition3_IITR441EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730282",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PP - Gross payments labour hire or other specified payments is incorrect",
                    LongDescription = "PP - Gross payments labour hire or other specified payments must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is \"001\" (labour hire) or \"002\" (other specified payments), Business income statement type is \"Business\", and Business income statement industry production type is \"Primary\"",
                    Location = "/xbrli:xbrl/tns:Income.LabourHireArrangementPrimaryProductionPaymentGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730282" },
                        new ProcessMessageParameter() { Name = "IITR441", Value = report.iitrParentDocument.IITR441.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730282

        #region VR.ATO.IITR.730283

        /* VR.ATO.IITR.730283
            Non-PP - Gross payments labour hire or other specified payments must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is "001" (labour hire) or "002" (other specified payments), Business income statement type is "Business", and Business income statement industry production type is "Non-Primary"

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR442 <> NULL AND ^IITR442 <> Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR442 <> NULL AND ^IITR442 <> Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business' AND ^INCDTLS491 = 'Non-Primary'), ^INCDTLS492, 0))

        Data Elements:
    
            ^IITR442 = RP:Income.LabourHireArrangementNonPrimaryProductionPaymentGross.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS491 = INCDTLS491
    
            ^INCDTLS492 = INCDTLS492
            */

        public static ProcessMessageDocument VR_ATO_IITR_730283(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_IITR442NotNull = false;
            bool condition3_IITR442EqualsSum = false;
            decimal? sumOfINCDTLS492 = 0;

            // Get the sum of all INCDTLS492 fields where INCDTLS489 is "001" OR "002", INCDTLS490 is "Business", and INCDTLS491 is "Non-Primary"
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
            {
                sumOfINCDTLS492 = (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "001", "Business", "Non-Primary")));
                sumOfINCDTLS492 += (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => BusinessPaymentSummarySum(tuple, "002", "Business", "Non-Primary")));
            }

            // Condition 2: [iitr442] <> NULL
            condition2_IITR442NotNull = (report.iitrParentDocument.IITR442 != null);

            // Condition 3: [iitr442] <> SUM(ConditionalValue((([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Business" AND [incdtls491] = "Non-Primary"), [incdtls492], 0))
            condition3_IITR442EqualsSum = report.iitrParentDocument.IITR442 != sumOfINCDTLS492;

            assertion = (condition2_IITR442NotNull && condition3_IITR442EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730283",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Non-PP - Gross payments labour hire or other specified payments is incorrect",
                    LongDescription = "Non-PP - Gross payments labour hire or other specified payments must equal the sum of all Business income statement gross payment amounts in the attached Income Details schedule where the corresponding Business income statement payment type is \"001\" (labour hire) or \"002\" (other specified payments), Business income statement type is \"Business\", and Business income statement industry production type is \"Non-Primary\"",
                    Location = "/xbrli:xbrl/tns:Income.LabourHireArrangementNonPrimaryProductionPaymentGross.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730283" },
                        new ProcessMessageParameter() { Name = "IITR442", Value = report.iitrParentDocument.IITR442.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([INCDTLS492)", Value = sumOfINCDTLS492.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730283

        private static readonly List<string> IncomeCategory1Types = new List<string>()
        {
            "Winnings",
            "Foreign exchange",
            "Traditional securities",
            "Work in progress",
            "Assessable balancing adjustment",
            "Reimbursements of tax-related expenses or election expenses"
        };

        #region VR.ATO.IITR.730284

        /* VR.ATO.IITR.730284
            Where any Other income amount with an Other income type of "Winnings", "Foreign exchange", "Traditional securities", "Work in progress", "Assessable balancing adjustment", or "Reimbursements of tax-related expenses or election expenses", or Salary or wages lump sum E, or Foreign employment income lump sum E, or Foreign pension or annuity lump sum in arrears is provided in the attached Income Details schedule then Other income type - Category 1 - Amount must be provided

        Legacy Rule Format:
            ^IITR615 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE InSet(^INCDTLS449, '"Winnings","Foreign exchange","Traditional securities","Work in progress","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses"') OR AnyOccurrence(^INCDTLS326, ^INCDTLS326 <> NULL) OR AnyOccurrence(^INCDTLS177, ^INCDTLS177 <> NULL) OR AnyOccurrence(^INCDTLS213, ^INCDTLS213 <> NULL))

        Technical Business Rule Format:
            ^IITR615 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE InSet(^INCDTLS449, '"Winnings","Foreign exchange","Traditional securities","Work in progress","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses"') OR AnyOccurrence(^INCDTLS326, ^INCDTLS326 <> NULL) OR AnyOccurrence(^INCDTLS177, ^INCDTLS177 <> NULL) OR AnyOccurrence(^INCDTLS213, ^INCDTLS213 <> NULL))

        Data Elements:
    
            ^IITR615 = RP:IncomeTax.IncomeCategory1Other.Amount
    
            ^INCDTLS177 = INCDTLS177
    
            ^INCDTLS213 = INCDTLS213
    
            ^INCDTLS326 = INCDTLS326
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730284(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR615IsNull = false;
            bool condition2_INCDTLSExists = true;
            bool condition3_INCDTLS451Exists = false;
            bool condition4_INCDTLS326Exists = false;
            bool condition5_INCDTLS177Exists = false;
            bool condition6_INCDTLS213Exists = false;

            // Condition 1: [iitr615] = NULL
            condition1_IITR615IsNull = report.iitrParentDocument.IITR615 == null;

            // Condition 3: ANY OCCURRENCE OF([incdtls451]) <> NULL WHERE [incdtls449] = SET("Winnings","Foreign exchange","Traditional securities","Work in progress","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses")
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                condition3_INCDTLS451Exists = incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS451 != null && IncomeCategory1Types.Contains(tuple.INCDTLS449));

            // Condition 4: ANY OCCURRENCE OF([incdtls326]) <> NULL
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                condition4_INCDTLS326Exists = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS326 != null);

            // Condition 5: ANY OCCURRENCE OF([incdtls177]) <> NULL
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                condition5_INCDTLS177Exists = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.INCDTLS177 != null);

            // Condition 6: ANY OCCURRENCE OF([incdtls213]) <> NULL
            if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollectionExists)
                condition6_INCDTLS213Exists = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Any(tuple => tuple.INCDTLS213 != null);

            // Rule assertion: condition1 AND condition2 AND (condition3 || condition4 || condition5)
            assertion = (condition1_IITR615IsNull && condition2_INCDTLSExists && (condition3_INCDTLS451Exists || condition4_INCDTLS326Exists || condition5_INCDTLS177Exists || condition6_INCDTLS213Exists));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730284",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other income type - Category 1 - Amount must be provided",
                    LongDescription = @"Where any Other income amount with an Other income type of ""Winnings"", ""Foreign exchange"", ""Traditional securities"", ""Work in progress"", ""Assessable balancing adjustment"", or ""Reimbursements of tax-related expenses or election expenses"", or Salary or wages lump sum E, or Foreign employment income lump sum E, or Foreign pension or annuity lump sum in arrears is provided in the attached Income Details schedule then Other income type - Category 1 - Amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategory1Other.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730284" },
                        new ProcessMessageParameter() { Name = "IITR615", Value = report.iitrParentDocument.IITR615.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls451]) <> NULL", Value = condition3_INCDTLS451Exists.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls326]) <> NULL", Value = condition4_INCDTLS326Exists.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls177]) <> NULL", Value = condition5_INCDTLS177Exists.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls213]) <> NULL", Value = condition6_INCDTLS213Exists.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730284

        #region VR.ATO.IITR.730285

        /* VR.ATO.IITR.730285
            Other income type - Category 1 - Amount must equal the sum of all Other income amount with an Other income type of "Winnings", "Foreign exchange", "Traditional securities", "Work in progress", "Assessable balancing adjustment", or "Reimbursements of tax-related expenses or election expenses", and Salary or wages lump sum E, and Foreign employment income lump sum E, and Foreign pension or annuity lump sum in arrears is provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR615 <> NULL AND ^IITR615 <> (RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Winnings","Foreign exchange","Traditional securities","Work in progress","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses"'),^INCDTLS451,0)),0) + RoundDown(Sum(^INCDTLS326),0) + RoundDown(Sum(^INCDTLS177),0) + Sum(^INCDTLS213))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR615 <> NULL AND ^IITR615 <> (RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Winnings","Foreign exchange","Traditional securities","Work in progress","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses"'),^INCDTLS451,0)),0) + RoundDown(Sum(^INCDTLS326),0) + RoundDown(Sum(^INCDTLS177),0) + Sum(^INCDTLS213))

        Data Elements:
    
            ^IITR615 = RP:IncomeTax.IncomeCategory1Other.Amount
    
            ^INCDTLS177 = INCDTLS177
    
            ^INCDTLS213 = INCDTLS213
    
            ^INCDTLS326 = INCDTLS326
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730285(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR615IsNotNull = false;
            decimal condition3_INCDTLS451Sum = 0m;
            decimal condition3_INCDTLS326Sum = 0m;
            decimal condition3_INCDTLS177Sum = 0m;
            decimal condition3_INCDTLS213Sum = 0m;
            bool condition3_IITR615NotEqualsSum = false;

            // Condition 2: [iitr615] <> NULL
            condition2_IITR615IsNotNull = report.iitrParentDocument.IITR615 != null;

            // Sum 1: RoundDown(SUM(ConditionalValue([incdtls449] = SET("Winnings","Foreign exchange","Traditional securities","Traditional securities","Assessable balancing adjustment","Reimbursements of tax-related expenses or election expenses"),[incdtls451],0)), 0)
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                condition3_INCDTLS451Sum = Math.Truncate(incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => IncomeCategory1Types.Contains(tuple.INCDTLS449) ? tuple.INCDTLS451.GetValueOrDefault() : 0));

            // Sum 2: RoundDown(SUM([incdtls326]), 0)
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                condition3_INCDTLS326Sum = Math.Truncate(incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS326.GetValueOrDefault()));

            // Sum 3: RoundDown(SUM([incdtls177]), 0)
            if (incdtlschilddoc.Rp_IncomeCollectionExists)
                condition3_INCDTLS177Sum = Math.Truncate(incdtlschilddoc.Rp_IncomeCollection.Sum(tuple => tuple.INCDTLS177.GetValueOrDefault()));

            // Sum 4: SUM([incdtls213])
            if (incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollectionExists)
                condition3_INCDTLS213Sum = incdtlschilddoc.Rp_ForeignPensionsOrAnnuitiesCollection.Sum(tuple => tuple.INCDTLS213.GetValueOrDefault());

            // Condition 3: IITR615 <> (sum1 + sum2 + sum3 + sum4)
            decimal totalSum = condition3_INCDTLS451Sum + condition3_INCDTLS326Sum + condition3_INCDTLS177Sum + condition3_INCDTLS213Sum;
            condition3_IITR615NotEqualsSum = report.iitrParentDocument.IITR615 != totalSum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR615IsNotNull && condition3_IITR615NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730285",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other income type - Category 1 - Amount is incorrect",
                    LongDescription = @"Other income type - Category 1 - Amount must equal the sum of all Other income amount with an Other income type of ""Winnings"", ""Foreign exchange"", ""Traditional securities"", ""Work in progress"", ""Assessable balancing adjustment"", or ""Reimbursements of tax-related expenses or election expenses"", and Salary or wages lump sum E, and Foreign employment income lump sum E, and Foreign pension or annuity lump sum in arrears is provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategory1Other.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730285" },
                        new ProcessMessageParameter() { Name = "IITR615", Value = report.iitrParentDocument.IITR615.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls451])), 0)", Value = condition3_INCDTLS451Sum.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls326]), 0)", Value = condition3_INCDTLS326Sum.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls177]), 0)", Value = condition3_INCDTLS177Sum.ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls213])", Value = condition3_INCDTLS213Sum.ToString() },
                        new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730285

        #region VR.ATO.IITR.730286

        /* VR.ATO.IITR.730286
            Where any Other income amount with an Other income type of "ATO interest" is provided in the attached Income Details schedule then Other income type - Category 2 (ATO interest) - Amount must be provided

        Legacy Rule Format:
            ^IITR616 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'ATO interest'

        Technical Business Rule Format:
            ^IITR616 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'ATO interest'

        Data Elements:
    
            ^IITR616 = RP:IncomeTax.IncomeCategory2Total.Amount
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730286(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR616IsNull = false;
            bool condition2_INCDTLSExists = true;
            bool condition3_INCDTLS451Exists = false;

            // Condition 1: [iitr616] = NULL
            condition1_IITR616IsNull = report.iitrParentDocument.IITR616 == null;

            // Condition 3: ANY OCCURRENCE OF([incdtls451] WHERE [incdtls449] = "ATO interest") <> NULL
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                condition3_INCDTLS451Exists = incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS451 != null && tuple.INCDTLS449 == "ATO interest");

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR616IsNull && condition2_INCDTLSExists && condition3_INCDTLS451Exists);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730286",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other income type - Category 2 (ATO interest) - Amount must be provided",
                    LongDescription = @"Where any Other income amount with an Other income type of ""ATO interest"" is provided in the attached Income Details schedule then Other income type - Category 2 (ATO interest) - Amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategory2Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730286" },
                        new ProcessMessageParameter() { Name = "IITR616", Value = report.iitrParentDocument.IITR616.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls451]) <> NULL", Value = condition3_INCDTLS451Exists.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730286

        #region VR.ATO.IITR.730287

        /* VR.ATO.IITR.730287
            Other income type - Category 2 (ATO interest) - Amount must equal the sum of all Other income amounts with an Other income type of "ATO interest" provided in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR616 <> NULL AND ^IITR616 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'ATO interest',^INCDTLS451,0)),0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR616 <> NULL AND ^IITR616 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'ATO interest',^INCDTLS451,0)),0)

        Data Elements:
    
            ^IITR616 = RP:IncomeTax.IncomeCategory2Total.Amount
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730287(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR616IsNotNull = false;
            decimal condition3_INCDTLS451Sum = 0m;
            bool condition3_IITR616EqualsSum = false;

            // Condition 2: [iitr616] <> NULL
            condition2_IITR616IsNotNull = report.iitrParentDocument.IITR616 != null;

            // Condition 3 Sum: RoundDown(SUM(ConditionalValue([incdtls449] = "ATO interest", [incdtls451], 0)), 0)
            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
                condition3_INCDTLS451Sum = Math.Truncate(incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS449 == "ATO interest" ? tuple.INCDTLS451.GetValueOrDefault() : 0));

            // Condition 3: [iitr616] <> RoundDown(SUM(ConditionalValue([incdtls449] = "ATO interest",[incdtls451], 0)), 0)
            condition3_IITR616EqualsSum = report.iitrParentDocument.IITR616 != condition3_INCDTLS451Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR616IsNotNull && condition3_IITR616EqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730287",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other income type - Category 2 (ATO interest) - Amount is incorrect",
                    LongDescription = @"Other income type - Category 2 (ATO interest) - Amount must equal the sum of all Other income amounts with an Other income type of ""ATO interest"" provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategory2Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730287" },
                        new ProcessMessageParameter() { Name = "IITR616", Value = report.iitrParentDocument.IITR616.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls451])), 0)", Value = condition3_INCDTLS451Sum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730287

        #region VR.ATO.IITR.730288

        /* VR.ATO.IITR.730288
            The CFC income must equal the sum of Foreign entity CFC income, CFC income from managed fund amounts, and Attributed foreign income - Beneficiary share amounts reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            ^IITR316 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR316 <> RoundDown(^INCDTLS203 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS412, ^INCDTLS440)) + Sum(^INCDTLS562), 0)

        Technical Business Rule Format:
            ^IITR316 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR316 <> RoundDown(^INCDTLS203 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS412, ^INCDTLS440)) + Sum(^INCDTLS562), 0)

        Data Elements:
    
            ^IITR316 = RP:Income.ControlledForeignCompaniesAttributableIncome.Amount
    
            ^INCDTLS203 = INCDTLS203
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS412 = INCDTLS412
    
            ^INCDTLS440 = INCDTLS440

            ^INCDTLS562 = INCDTLS562
        */

        public static ProcessMessageDocument VR_ATO_IITR_730288(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR316NotNull = (report.iitrParentDocument.IITR316 != null);
            decimal conditionalSumINCDTLS412_or_INCDTLS440 = 0;
            decimal conditionalSumINCDTLS562 = 0;
            decimal condition3_SumINCDTLS203_Conditional = 0;
            bool condition3_IITR316NotEqualSum = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
                conditionalSumINCDTLS412_or_INCDTLS440 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS412.GetValueOrDefault() : tuple.INCDTLS440.GetValueOrDefault());

            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                conditionalSumINCDTLS562 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS562.GetValueOrDefault());

            condition3_SumINCDTLS203_Conditional = Math.Truncate(incdtlschilddoc.INCDTLS203.GetValueOrDefault() + conditionalSumINCDTLS412_or_INCDTLS440 + conditionalSumINCDTLS562);

            condition3_IITR316NotEqualSum = (report.iitrParentDocument.IITR316.GetValueOrDefault() != condition3_SumINCDTLS203_Conditional);

            bool assertion = (condition1_IITR316NotNull && condition3_IITR316NotEqualSum);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731288",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"CFC income is incorrect",
                    LongDescription = @"The CFC income must equal the sum of Foreign entity CFC income, CFC income from managed fund amounts, and Attributed foreign income - Beneficiary share amounts reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.ControlledForeignCompaniesAttributableIncome.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730288" },
                        new ProcessMessageParameter() { Name = "IITR316", Value = report.iitrParentDocument.IITR316.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated Total", Value = condition3_SumINCDTLS203_Conditional.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS203", Value = incdtlschilddoc.INCDTLS203.GetValueOrDefault().ToString() }
                    }
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730288

        #region VR.ATO.IITR.730289

        /* VR.ATO.IITR.730289
            Where Foreign entity CFC income, CFC income from managed fund, or Attributed foreign income - Beneficiary share are present in the attached Income Details schedule, the CFC income must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND (^INCDTLS203 <> NULL OR AnyOccurrence(^INCDTLS412, ^INCDTLS412 <> NULL) OR AnyOccurrence(^INCDTLS440, ^INCDTLS440 <> NULL) OR AnyOccurrence(^INCDTLS562, ^INCDTLS562 <> NULL)) AND ^IITR316 = NULL

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND (^INCDTLS203 <> NULL OR AnyOccurrence(^INCDTLS412, ^INCDTLS412 <> NULL) OR AnyOccurrence(^INCDTLS440, ^INCDTLS440 <> NULL) OR AnyOccurrence(^INCDTLS562, ^INCDTLS562 <> NULL)) AND ^IITR316 = NULL

        Data Elements:
    
            ^IITR316 = RP:Income.ControlledForeignCompaniesAttributableIncome.Amount
    
            ^INCDTLS203 = INCDTLS203
    
            ^INCDTLS412 = INCDTLS412
    
            ^INCDTLS440 = INCDTLS440

            ^INCDTLS562 = INCDTLS562
        */

        public static ProcessMessageDocument VR_ATO_IITR_730289(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2aINCDTLS203NotNull = (incdtlschilddoc.INCDTLS203 != null);
            bool condition2b_anyINCDTLS412NotNull = false;
            bool condition2c_anyINCDTLS440NotNull = false;
            bool condition2d_anyINCDTLS562NotNull = false;
            bool condition3_IITR316Null = (report.iitrParentDocument.IITR316 == null);

            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                condition2b_anyINCDTLS412NotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS412 != null);
                condition2c_anyINCDTLS440NotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS440 != null);
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                condition2d_anyINCDTLS562NotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS562 != null);
            
            bool assertion = ((condition2aINCDTLS203NotNull || condition2b_anyINCDTLS412NotNull || condition2c_anyINCDTLS440NotNull || condition2d_anyINCDTLS562NotNull) && condition3_IITR316Null);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731289",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"CFC income must be provided",
                    LongDescription = @"Where Foreign entity CFC income, CFC income from managed fund, or Attributed foreign income - Beneficiary share are present in the attached Income Details schedule, the CFC income must be provided",
                    Location = "/xbrli:xbrl/tns:Income.ControlledForeignCompaniesAttributableIncome.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730289" },
                        new ProcessMessageParameter() { Name = "INCDTLS203", Value = ((condition2aINCDTLS203NotNull) ? incdtlschilddoc.INCDTLS203.GetValueOrDefault().ToString() : "null")},
                        new ProcessMessageParameter() { Name = "INCDTLS412 <> NULL", Value = condition2b_anyINCDTLS412NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS440 <> NULL", Value = condition2c_anyINCDTLS440NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS562 <> NULL", Value = condition2d_anyINCDTLS562NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "IITR316", Value = ((condition3_IITR316Null) ? "null" : report.iitrParentDocument.IITR316.GetValueOrDefault().ToString()) }
                    }
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730289

        #region VR.ATO.IITR.730290

        /* VR.ATO.IITR.730290
            The Transferor trust income must equal the sum of Foreign entity transferor trust income, plus transferor trust income from managed fund amounts reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR318 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR318 <> (RoundDown(^INCDTLS204 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS411, ^INCDTLS439)), 0))))

        Technical Business Rule Format:
            ((^IITR318 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR318 <> (RoundDown(^INCDTLS204 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS411, ^INCDTLS439)), 0))))

        Data Elements:
    
            ^IITR318 = RP:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
    
            ^INCDTLS204 = INCDTLS204
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS411 = INCDTLS411
    
            ^INCDTLS439 = INCDTLS439
        */

        public static ProcessMessageDocument VR_ATO_IITR_730290(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR318NotNull = (report.iitrParentDocument.IITR318 != null);
            decimal conditionalSumINCDTLS411_or_INCDTLS439 = 0;
            decimal condition3_SumINCDTLS204_Conditional = 0;
            bool condition3_IITR318NotEqualSum = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
                conditionalSumINCDTLS411_or_INCDTLS439 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS411.GetValueOrDefault() : tuple.INCDTLS439.GetValueOrDefault());

            condition3_SumINCDTLS204_Conditional = Math.Truncate(incdtlschilddoc.INCDTLS204.GetValueOrDefault() + conditionalSumINCDTLS411_or_INCDTLS439);

            condition3_IITR318NotEqualSum = (report.iitrParentDocument.IITR318.GetValueOrDefault() != condition3_SumINCDTLS204_Conditional);

            // Check that IITR318 is Not Null and that [iitr318] <> RoundDown([incdtls204] + SUM(ConditionalValue([incdtls387] = 1, [incdtls411], [incdtls439]
            assertion = (condition1_IITR318NotNull && condition3_IITR318NotEqualSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730290",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Transferor trust income is incorrect",
                    LongDescription = @"The Transferor trust income must equal the sum of Foreign entity transferor trust income, plus transferor trust income from managed fund amounts reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730290" },
                        new ProcessMessageParameter() { Name = "IITR318", Value = report.iitrParentDocument.IITR318.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated Total: RoundDown([incdtls204] + SUM(ConditionalValue([incdtls387] = 1, [incdtls411], [incdtls439])), 0)))", Value = condition3_SumINCDTLS204_Conditional.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS204", Value = incdtlschilddoc.INCDTLS204.GetValueOrDefault().ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730290

        #region VR.ATO.IITR.730291

        /* VR.ATO.IITR.730291
            Where Foreign entity transferor trust income and/or transferor trust income from managed fund are present in the attached Income Details schedule, the Transferor trust income must be provided

        Legacy Rule Format:
            ((CountDocument('INCDTLS') = 1) AND ((^INCDTLS204 <> NULL) OR (AnyOccurrence(^INCDTLS411, ^INCDTLS411 <> NULL)) OR (AnyOccurrence(^INCDTLS439, ^INCDTLS439 <> NULL))) AND (^IITR318 = NULL))

        Technical Business Rule Format:
            ((CountDocument('INCDTLS') = 1) AND ((^INCDTLS204 <> NULL) OR (AnyOccurrence(^INCDTLS411, ^INCDTLS411 <> NULL)) OR (AnyOccurrence(^INCDTLS439, ^INCDTLS439 <> NULL))) AND (^IITR318 = NULL))

        Data Elements:
    
            ^IITR318 = RP:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
    
            ^INCDTLS204 = INCDTLS204
    
            ^INCDTLS411 = INCDTLS411
    
            ^INCDTLS439 = INCDTLS439
        */

        public static ProcessMessageDocument VR_ATO_IITR_730291(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2aINCDTLS204NotNull = (incdtlschilddoc.INCDTLS204 != null);
            bool condition2b_anyINCDTLS411NotNull = false;
            bool condition2c_anyINCDTLS439NotNull = false;
            bool condition3_IITR318Null = (report.iitrParentDocument.IITR318 == null);

            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                condition2b_anyINCDTLS411NotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS411 != null);
                condition2c_anyINCDTLS439NotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS439 != null);
            }

            // Check (([incdtls204] <> NULL) OR (ANY OCCURRENCE OF [incdtls411] <> NULL) OR (ANY OCCURRENCE OF [incdtls439] <> NULL)) AND ([iitr318] = NULL))
            assertion = ((condition2aINCDTLS204NotNull || condition2b_anyINCDTLS411NotNull || condition2c_anyINCDTLS439NotNull) && condition3_IITR318Null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730291",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Transferor trust income must be provided",
                    LongDescription = @"Where Foreign entity transferor trust income and/or transferor trust income from managed fund are present in the attached Income Details schedule, the Transferor trust income must be provided",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730291" },
                        new ProcessMessageParameter() { Name = "INCDTLS204", Value = ((condition2aINCDTLS204NotNull) ? incdtlschilddoc.INCDTLS204.GetValueOrDefault().ToString() : "null")},
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF [incdtls411] <> NULL", Value = condition2b_anyINCDTLS411NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF [incdtls439] <> NULL", Value = condition2c_anyINCDTLS439NotNull.ToString() },
                        new ProcessMessageParameter() { Name = "IITR318", Value = ((condition3_IITR318Null) ? "null" : report.iitrParentDocument.IITR318.GetValueOrDefault().ToString()) },

                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730291

        #region VR.ATO.IITR.730297

        /* VR.ATO.IITR.730297
            The PSI - voluntary agreement amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is "003" (voluntary agreement) and Business income statement type is "Personal Services Income" in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR411 <> NULL) AND ^IITR411 <> (Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR411 <> NULL) AND ^IITR411 <> (Sum(ConditionalValue((^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Data Elements:
    
            ^IITR411 = RP:Income.PersonalServicesIncome.VoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730297(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR411IsNotNull = false;
            decimal condition3_INCDTLS492Sum = 0m;
            bool condition3_IITR411NotEqualsSum = false;

            // Condition 2: [iitr411] <> NULL
            condition2_IITR411IsNotNull = report.iitrParentDocument.IITR411 != null;

            // Condition 3 Sum: [iitr411] <> (SUM(ConditionalValue(([incdtls489] = "003" AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS492Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS492.GetValueOrDefault() : 0);

            // Condition 3: [iitr411] <> (SUM(ConditionalValue(([incdtls489] = "003" AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            condition3_IITR411NotEqualsSum = report.iitrParentDocument.IITR411.GetValueOrDefault() != condition3_INCDTLS492Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR411IsNotNull && condition3_IITR411NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730297",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI - voluntary agreement amount is incorrect",
                    LongDescription = "The PSI - voluntary agreement amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is \"003\" (voluntary agreement) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.VoluntaryAgreement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730297" },
                        new ProcessMessageParameter() { Name = "IITR411", Value = report.iitrParentDocument.IITR411.ToString() },
                        new ProcessMessageParameter() { Name = "(SUM(ConditionalValue(([incdtls489] = \"003\" AND [incdtls490] = \"Personal Services Income\"), [incdtls492], 0)))", Value = condition3_INCDTLS492Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730297

        #region VR.ATO.IITR.730298

        /* VR.ATO.IITR.730298
            The PSI where Australian business number not quoted amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is "012" (no ABN quoted) and Business income statement type is "Personal Services Income" in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR412 <> NULL) AND ^IITR412 <> (Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR412 <> NULL) AND ^IITR412 <> (Sum(ConditionalValue((^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Data Elements:
    
            ^IITR412 = RP:Income.PersonalServicesIncome.ABNNotQuoted.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730298(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR412IsNotNull = false;
            decimal condition3_INCDTLS492Sum = 0m;
            bool condition3_IITR412NotEqualsSum = false;

            // Condition 2: [iitr412] <> NULL
            condition2_IITR412IsNotNull = report.iitrParentDocument.IITR412 != null;

            // Condition 3 Sum: (SUM(ConditionalValue(([incdtls489] = "012" AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS492Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS492.GetValueOrDefault() : 0);

            // Condition 3: [iitr412] <> (SUM(ConditionalValue(([incdtls489] = "012" AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            condition3_IITR412NotEqualsSum = report.iitrParentDocument.IITR412.GetValueOrDefault() != condition3_INCDTLS492Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR412IsNotNull && condition3_IITR412NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730298",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI where Australian business number not quoted amount is incorrect",
                    LongDescription = "The PSI where Australian business number not quoted amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is \"012\" (no ABN quoted) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.ABNNotQuoted.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730298" },
                        new ProcessMessageParameter() { Name = "IITR412", Value = report.iitrParentDocument.IITR412.ToString() },
                        new ProcessMessageParameter() { Name = "(SUM(ConditionalValue(([incdtls489] = \"012\" AND [incdtls490] = \"Personal Services Income\"), [incdtls492], 0)))", Value = condition3_INCDTLS492Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730298

        #region VR.ATO.IITR.730299

        /* VR.ATO.IITR.730299
            The PSI - labour hire or other specified payments amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is "001" (labour hire) or "002" (other specified payments) and Business income statement type is "Personal Services Income" in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR413 <> NULL) AND ^IITR413 <> (Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1) AND (^IITR413 <> NULL) AND ^IITR413 <> (Sum(ConditionalValue(((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Personal Services Income'), ^INCDTLS492, 0)))

        Data Elements:
    
            ^IITR413 = RP:Income.PersonalServicesIncome.LabourHireOrOtherSpecifiedPayment.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS492 = INCDTLS492
        */

        public static ProcessMessageDocument VR_ATO_IITR_730299(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR413IsNotNull = false;
            decimal condition3_INCDTLS492Sum = 0m;
            bool condition3_IITR413NotEqualsSum = false;

            // Condition 2: [iitr413] <> NULL
            condition2_IITR413IsNotNull = report.iitrParentDocument.IITR413 != null;

            // Condition 3 Sum: (SUM(ConditionalValue((([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS492Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => (tuple.INCDTLS489 == "001" || tuple.INCDTLS489 == "002") && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS492.GetValueOrDefault() : 0);

            // Condition 3: [iitr413] <> (SUM(ConditionalValue((([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Personal Services Income"), [incdtls492], 0)))
            condition3_IITR413NotEqualsSum = report.iitrParentDocument.IITR413 != condition3_INCDTLS492Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR413IsNotNull && condition3_IITR413NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730299",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"PSI - labour hire or other specified payments is incorrect",
                    LongDescription = "The PSI - labour hire or other specified payments amount must equal the sum of all Business income statement gross payment amount elements where Business income statement payment type is \"001\" (labour hire) or \"002\" (other specified payments) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PersonalServicesIncome.LabourHireOrOtherSpecifiedPayment.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730299" },
                        new ProcessMessageParameter() { Name = "IITR413", Value = report.iitrParentDocument.IITR413.ToString() },
                        new ProcessMessageParameter() { Name = "(SUM(ConditionalValue(([incdtls489] = \"012\" AND [incdtls490] = \"Personal Services Income\"), [incdtls492], 0)))", Value = condition3_INCDTLS492Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730299

        #region VR.ATO.IITR.730380

        /* VR.ATO.IITR.730380
            Managed investment scheme deductions relating to amounts shown at "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" amount must equal the sum of the following amounts on the Income Details schedule: Non-primary production managed investment scheme deductions amount; all Total other deductions relating to non-primary production from managed fund amounts for individually owned accounts; and all Your share of other deductions relating to non-primary production from managed fund amounts for joint accounts

        Legacy Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR261 <> NULL AND ^IITR261 <> RoundDown(Sum(^INCDTLS257) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS391, ^INCDTLS421)), 0))

        Technical Business Rule Format:
            Count SCHEDULE("INCDTLS") = 1 AND (^IITR261 <> NULL AND ^IITR261 <> RoundDown(Sum(^INCDTLS257) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS391, ^INCDTLS421)), 0))

        Data Elements:

            ^IITR261 = RP:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount

            ^INCDTLS257 = INCDTLS257

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS391 = INCDTLS391

            ^INCDTLS421 = INCDTLS421
        */

        public static ProcessMessageDocument VR_ATO_IITR_730380(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        { 
            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR261NotNull = (report.iitrParentDocument.IITR261 != null);

            decimal conditionalSumINCDTLS391_or_INCDTLS421 = incdtlschilddoc.Rp_ManagedFundsCollection != null ? (incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS391.GetValueOrDefault() : tuple.INCDTLS421.GetValueOrDefault())) : 0;

            decimal sumINCDTLS257 = incdtlschilddoc.Rp_TrustIncomeCollection != null ? incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS257.GetValueOrDefault()) : 0;

            decimal condition3_SumINCDTLS257_Conditional = Math.Truncate(sumINCDTLS257 + conditionalSumINCDTLS391_or_INCDTLS421);

            bool condition3_IITR261NotEqualSum = (report.iitrParentDocument.IITR261.GetValueOrDefault() != condition3_SumINCDTLS257_Conditional);

            // Check that IITR261 is Not Null and that [iitr261] <> (RoundDown([incdtls257] + SUM(ConditionalValue([incdtls387] = 1, [incdtls391], [incdtls421]
            bool assertion = (condition1_IITR261NotNull && condition3_IITR261NotEqualSum);

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730380",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Managed investment scheme deductions relating to amounts shown at ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" amount is incorrect",
                    LongDescription = @"Managed investment scheme deductions relating to amounts shown at ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" amount must equal the sum of the following amounts on the Income Details schedule: Non-primary production managed investment scheme deductions amount; all Total other deductions relating to non-primary production from managed fund amounts for individually owned accounts; and all Your share of other deductions relating to non-primary production from managed fund amounts for joint accounts",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730288" },
                        new ProcessMessageParameter() { Name = "IITR261", Value = report.iitrParentDocument.IITR261.ToString() },
                        new ProcessMessageParameter() { Name = "ondSumINCDTLS391_or_INCDTLS421", Value = conditionalSumINCDTLS391_or_INCDTLS421.ToString() },
                        new ProcessMessageParameter() { Name = "Sum([incdtls257])", Value = sumINCDTLS257.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730380

        #region VR.ATO.IITR.730381

        /* VR.ATO.IITR.730381
            Where any Non-primary production managed investment scheme deductions amount or Total other deductions relating to non-primary production from managed fund amounts are present in the attached Income Details schedule, the Managed investment scheme deductions relating to amounts shown at "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" amount must be provided

        Legacy Rule Format:
            ^IITR261 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS257, ^INCDTLS257 <> NULL) OR AnyOccurrence(^INCDTLS391, ^INCDTLS391 <> NULL))

        Technical Business Rule Format:
            ^IITR261 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS257, ^INCDTLS257 <> NULL) OR AnyOccurrence(^INCDTLS391, ^INCDTLS391 <> NULL))

        Data Elements:

            ^IITR261 = RP:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount

            ^INCDTLS257 = INCDTLS257

            ^INCDTLS391 = INCDTLS391
        */

        public static ProcessMessageDocument VR_ATO_IITR_730381(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS257 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS257 != null);
            bool anyINCDTLS391 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS391 != null);

            bool assertion = report.iitrParentDocument.IITR261 == null && (anyINCDTLS257 || anyINCDTLS391);

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730381",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Managed investment scheme deductions relating to amounts shown at ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" amount must be provided",
                    LongDescription = @"Where any Non-primary production managed investment scheme deductions amount or Total other deductions relating to non-primary production from managed fund amounts are present in the attached Income Details schedule, the Managed investment scheme deductions relating to amounts shown at ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730381" },
                        new ProcessMessageParameter() { Name = "IITR261", Value = report.iitrParentDocument.IITR261.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS257 <> null", Value = anyINCDTLS257.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS391 <> null", Value = anyINCDTLS391.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion
       
        #region VR.ATO.IITR.730406

        /* VR.ATO.IITR.730406
        The Share of net income from trusts must equal Primary production net income from trusts plus the sum of the following amounts: Total primary production income from managed fund where Managed fund number of account holders is 1; Your share of primary production income from managed fund where Managed fund number of account holders is greater than 1, in the attached Income schedule.

        Legacy Rule Format:
            ^IITR243 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR243 <> RoundDown(^Sum(INCDTLS247) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS402, ^INCDTLS432)), 0)

        Technical Business Rule Format:
            ^IITR243 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR243 <> RoundDown(^Sum(INCDTLS247) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS402, ^INCDTLS432)), 0)

        Data Elements:
    
            ^IITR243 = RP:Income.TrustPrimaryProductionNetShare.Amount
    
            ^INCDTLS247 = INCDTLS247
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS402 = INCDTLS402
    
            ^INCDTLS432 = INCDTLS432
        */
        public static ProcessMessageDocument VR_ATO_IITR_730406(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            
            decimal sumofINCDTLS247 = 0;
            decimal sumOfINCDTLS402OrINCDTLS432 = 0;
            decimal totalSum = 0;
            
            // Condition 1: [iitr243] <> NULL
            if (report.iitrParentDocument.IITR243 != null)
            {
                // Condition 2: INCDTLS form is already provided 

                // Condition 3: [iitr243] <> RoundDown([incdtls247] + SUM(ConditionalValue([incdtls387] = 1, [incdtls402], [incdtls432])), 0)
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOfINCDTLS402OrINCDTLS432 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS402.GetValueOrDefault() : tuple.INCDTLS432.GetValueOrDefault());

                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumofINCDTLS247 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS247.GetValueOrDefault());

                // RoundDown(^Sum(INCDTLS247) + SUM(ConditionalValue([incdtls387] = 1, [incdtls402], [incdtls432])), 0)
                totalSum = Math.Truncate(sumofINCDTLS247 + sumOfINCDTLS402OrINCDTLS432);

                bool assertion = report.iitrParentDocument.IITR243.GetValueOrDefault() != totalSum;
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730406",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Share of net income from trusts amount is incorrect",
                        LongDescription = @"The Share of net income from trusts must equal Primary production net income from trusts plus the sum of the following amounts: Total primary production income from managed fund where Managed fund number of account holders is 1; Your share of primary production income from managed fund where Managed fund number of account holders is greater than 1, in the attached Income schedule.",
                        Location = "/xbrli:xbrl/tns:Income.TrustPrimaryProductionNetShare.Amount",
                        Parameters = new ProcessMessageParameters() {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730406" },
                            new ProcessMessageParameter() { Name = "IITR243", Value = report.iitrParentDocument.IITR243.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS247", Value = sumofINCDTLS247.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS402/432 Sum", Value = sumOfINCDTLS402OrINCDTLS432.ToString() },
                            new ProcessMessageParameter() { Name = "Trust Amount Sums", Value = totalSum.ToString() }
                        },
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730407

        /* VR.ATO.IITR.730407
            Where any Total primary production income from managed fund, Your share of primary production income from managed fund or Primary production net income from trusts amounts are present in the attached Income Details schedule, the Share of net income from trusts must be provided

        Legacy Rule Format:
            ^IITR243 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS247, ^INCDTLS247 <> NULL) OR AnyOccurrence(^INCDTLS402, ^INCDTLS402 <> NULL) OR AnyOccurrence(^INCDTLS432, ^INCDTLS432 <> NULL))

        Technical Business Rule Format:
            ^IITR243 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS247, ^INCDTLS247 <> NULL) OR AnyOccurrence(^INCDTLS402, ^INCDTLS402 <> NULL) OR AnyOccurrence(^INCDTLS432, ^INCDTLS432 <> NULL))

        Data Elements:
    
            ^IITR243 = RP:Income.TrustPrimaryProductionNetShare.Amount
    
            ^INCDTLS247 = INCDTLS247
    
            ^INCDTLS402 = INCDTLS402
    
            ^INCDTLS432 = INCDTLS432
        */
        public static ProcessMessageDocument VR_ATO_IITR_730407(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool IITR243NotProvided = report.iitrParentDocument.IITR243 == null;
            bool anyINCDTLS247 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS247 != null);
            bool anyINCDTLS402 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS402 != null);
            bool anyINCDTLS432 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS432 != null);

            bool assertion = IITR243NotProvided && (anyINCDTLS247 || anyINCDTLS402 || anyINCDTLS432);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730407",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of net income from trusts must be provided",
                    LongDescription = @"Where any Total primary production income from managed fund, Your share of primary production income from managed fund or Primary production net income from trusts amounts are present in the attached Income Details schedule, the Share of net income from trusts must be provided",
                    Location = "/xbrli:xbrl/tns:Income.TrustPrimaryProductionNetShare.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730407" },
                        new ProcessMessageParameter() { Name = "IITR243 = null", Value = IITR243NotProvided.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS247 <> null", Value = anyINCDTLS247.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS402 <> null", Value = anyINCDTLS402.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS432 <> null", Value = anyINCDTLS432.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730408

        /* VR.ATO.IITR.730408
            Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount must equal the sum of the following amounts on the Income Details schedule, the Early stage venture capital limited partnership current year tax offset amount, all Your share of current year early stage venture capital limited partnership tax offset from managed fund amounts where the managed fund number of account holders is greater than 1, all Total current year early stage venture capital limited partnership tax offset from managed fund amounts where the managed fund number of account holders is 1, and all Early stage venture capital limited partnership tax offset - Beneficiary amounts

        Legacy Rule Format:
            ^IITR495 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR495 <> RoundDown(^INCDTLS231 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS415, ^INCDTLS443)) + Sum(^INCDTLS549), 0)

        Technical Business Rule Format:
            ^IITR495 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR495 <> RoundDown(^INCDTLS231 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS415, ^INCDTLS443)) + Sum(^INCDTLS549), 0)

        Data Elements:

            ^IITR495 = RP.LimitedPartners:TaxOffsetClaim.NonRefundableOther.Amount

            ^INCDTLS231 = INCDTLS231

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS415 = INCDTLS415

            ^INCDTLS443 = INCDTLS443

            ^INCDTLS549 = INCDTLS549
        */

        public static ProcessMessageDocument VR_ATO_IITR_730408(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            decimal sumOf415Or443 = 0;
            decimal sumPlus231 = 0;
            decimal sumIncdtls549 = 0;

            if (incdtlschilddoc != null)
            {
                // Loop through the ManagedFundsCollection
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOf415Or443 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS415.GetValueOrDefault() : tuple.INCDTLS443.GetValueOrDefault());

                // Loop through the TrustIncomeCollection
                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumIncdtls549 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(trustIncome => trustIncome.INCDTLS549.GetValueOrDefault());
            }

            sumPlus231 = Math.Truncate(incdtlschilddoc.INCDTLS231.GetValueOrDefault() + sumOf415Or443 + sumIncdtls549);

            bool assertion = report.iitrParentDocument.IITR495 != null && report.iitrParentDocument.IITR495.GetValueOrDefault() != sumPlus231;

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731408",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount is incorrect",
                    LongDescription = @"Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount must equal the sum of the following amounts on the Income Details schedule, the Early stage venture capital limited partnership current year tax offset amount, all Your share of current year early stage venture capital limited partnership tax offset from managed fund amounts where the managed fund number of account holders is greater than 1, all Total current year early stage venture capital limited partnership tax offset from managed fund amounts where the managed fund number of account holders is 1, and all Early stage venture capital limited partnership tax offset - Beneficiary amounts",
                    Location = $"/xbrli:xbrl/tns:TaxOffsetClaim.NonRefundableOther.Amount[@contextRef='{report.iitrParentDocument.RPLimitedPartnersId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730408" },
                        new ProcessMessageParameter() { Name = "IITR495", Value = report.iitrParentDocument.IITR495.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDLTS231", Value = incdtlschilddoc.INCDTLS231.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Managed Funds Total", Value = sumOf415Or443.ToString() },
                        new ProcessMessageParameter() { Name = "SUM[INCDLTS549]", Value = sumIncdtls549.ToString() }
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730409

        /* VR.ATO.IITR.730409
            When Early stage venture capital limited partnership current year tax offset amount, current year early stage venture capital limited partnership tax offset from managed fund amount, or Early stage venture capital limited partnership tax offset - Beneficiary amounts are present on the Income Details schedule, Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR495 = NULL AND (^INCDTLS231 <> NULL OR AnyOccurrence(^INCDTLS443, ^INCDTLS443 <> NULL) OR AnyOccurrence(^INCDTLS415, ^INCDTLS415 <> NULL) OR AnyOccurrence(^INCDTLS549, ^INCDTLS549 <> NULL))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR495 = NULL AND (^INCDTLS231 <> NULL OR AnyOccurrence(^INCDTLS443, ^INCDTLS443 <> NULL) OR AnyOccurrence(^INCDTLS415, ^INCDTLS415 <> NULL) OR AnyOccurrence(^INCDTLS549, ^INCDTLS549 <> NULL))

        Data Elements:

            ^IITR495 = RP.LimitedPartners:TaxOffsetClaim.NonRefundableOther.Amount

            ^INCDTLS231 = INCDTLS231

            ^INCDTLS415 = INCDTLS415

            ^INCDTLS443 = INCDTLS443

            ^INCDTLS549 = INCDTLS549
        */

        public static ProcessMessageDocument VR_ATO_IITR_730409(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool Condition1_INCDTLS443AnyNotNull = false;
            bool Condition2_INCDTLS415AnyNotNull = false;
            bool Condition3_INCDTLS549AnyNotNull = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition1_INCDTLS443AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS443 != null);
                Condition2_INCDTLS415AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS415 != null);
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
            {
                Condition3_INCDTLS549AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS549 != null);
            }

            bool assertion = report.iitrParentDocument.IITR495 == null && (incdtlschilddoc.INCDTLS231 != null || Condition1_INCDTLS443AnyNotNull || Condition2_INCDTLS415AnyNotNull || Condition3_INCDTLS549AnyNotNull);

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731409",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount must be provided",
                    LongDescription = @"When Early stage venture capital limited partnership current year tax offset amount, current year early stage venture capital limited partnership tax offset from managed fund amount, or Early stage venture capital limited partnership tax offset - Beneficiary amounts are present on the Income Details schedule, Early stage venture capital limited partnership (ESVCLP) - Current year tax offset amount must be provided",
                    Location = $"/xbrli:xbrl/tns:TaxOffsetClaim.NonRefundableOther.Amount[@contextRef='{report.iitrParentDocument.RPLimitedPartnersId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730409" },
                        new ProcessMessageParameter() { Name = "IITR495", Value = report.iitrParentDocument.IITR495.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS231", Value = incdtlschilddoc.INCDTLS231.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS443 <> NULL", Value = Condition1_INCDTLS443AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS415 <> NULL", Value = Condition2_INCDTLS415AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS549 <> NULL", Value = Condition3_INCDTLS549AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730410

        /* VR.ATO.IITR.730410
            Early stage investor - Current year tax offset amount must not exceed the sum of the following amounts on the Income Details schedule, the Early stage investor current year tax offset amount, all Your share of current year early stage investor tax offset from managed fund amounts where the managed fund number of account holders is greater than 1, all Total current year early stage investor tax offset from managed fund amounts where the managed fund number of account holders is 1, and all Early stage investor tax offset - Beneficiary amounts

        Legacy Rule Format:
            ^IITR496 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR496 > RoundDown(^INCDTLS232 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS416, ^INCDTLS444)) + Sum(^INCDTLS550), 0)

        Technical Business Rule Format:
            ^IITR496 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR496 > RoundDown(^INCDTLS232 + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS416, ^INCDTLS444)) + Sum(^INCDTLS550), 0)

        Data Elements:

            ^IITR496 = RP.Investor:TaxOffsetClaim.NonRefundableOther.Amount

            ^INCDTLS232 = INCDTLS232

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS416 = INCDTLS416

            ^INCDTLS444 = INCDTLS444

            ^INCDTLS550 = INCDTLS550
        */

        public static ProcessMessageDocument VR_ATO_IITR_730410(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            decimal sumOf416And444 = 0;
            decimal sumOf550 = 0;
            decimal sumPlus232 = 0;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_ManagedFundsCollection != null)
                sumOf416And444 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS416.GetValueOrDefault() : tuple.INCDTLS444.GetValueOrDefault());

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_TrustIncomeCollection != null)
                sumOf550 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS550.GetValueOrDefault());

            sumPlus232 = Math.Truncate(incdtlschilddoc.INCDTLS232.GetValueOrDefault() + sumOf416And444 + sumOf550);

            bool assertion = report.iitrParentDocument.IITR496 != null && report.iitrParentDocument.IITR496.GetValueOrDefault() > sumPlus232;

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731410",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Early stage investor - Current year tax offset amount is incorrect",
                    LongDescription = @"Early stage investor - Current year tax offset amount must not exceed the sum of the following amounts on the Income Details schedule, the Early stage investor current year tax offset amount, all Your share of current year early stage investor tax offset from managed fund amounts where the managed fund number of account holders is greater than 1, all Total current year early stage investor tax offset from managed fund amounts where the managed fund number of account holders is 1, and all Early stage investor tax offset - Beneficiary amounts",
                    Location = $"/xbrli:xbrl/tns:TaxOffsetClaim.NonRefundableOther.Amount[@contextRef='{report.iitrParentDocument.RPInvestorId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730410" },
                        new ProcessMessageParameter() { Name = "IITR496", Value = report.iitrParentDocument.IITR496.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDLTS232", Value = incdtlschilddoc.INCDTLS232.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "sumOf416And444", Value = sumOf416And444.ToString() },
                        new ProcessMessageParameter() { Name = "sumOf550", Value = sumOf550.ToString() }
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730411

        /* VR.ATO.IITR.730411
            When Early stage investor current year tax offset amount, any Early stage investor tax offset from managed fund amounts, or any Early stage investor tax offset - Beneficiary amounts are present on the Income Details schedule, Early stage investor - Current year tax offset amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR496 = NULL AND (^INCDTLS232 <> NULL OR AnyOccurrence(^INCDTLS444, ^INCDTLS444 <> NULL) OR AnyOccurrence(^INCDTLS416, ^INCDTLS416 <> NULL) OR AnyOccurrence(^INCDTLS550, ^INCDTLS550 <> NULL))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR496 = NULL AND (^INCDTLS232 <> NULL OR AnyOccurrence(^INCDTLS444, ^INCDTLS444 <> NULL) OR AnyOccurrence(^INCDTLS416, ^INCDTLS416 <> NULL) OR AnyOccurrence(^INCDTLS550, ^INCDTLS550 <> NULL))

        Data Elements:

            ^IITR496 = RP.Investor:TaxOffsetClaim.NonRefundableOther.Amount

            ^INCDTLS232 = INCDTLS232

            ^INCDTLS416 = INCDTLS416

            ^INCDTLS444 = INCDTLS444

            ^INCDTLS550 = INCDTLS550
        */

        public static ProcessMessageDocument VR_ATO_IITR_730411(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool Condition1_INCDTLS444AnyNotNull = false;
            bool Condition2_INCDTLS416AnyNotNull = false;
            bool Condition3_INCDTLS550AnyNotNull = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition1_INCDTLS444AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS444 != null);
                Condition2_INCDTLS416AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS416 != null);
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                Condition3_INCDTLS550AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS550 != null);

            bool assertion = report.iitrParentDocument.IITR496 == null && (incdtlschilddoc.INCDTLS232 != null || Condition1_INCDTLS444AnyNotNull || Condition2_INCDTLS416AnyNotNull || Condition3_INCDTLS550AnyNotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731411",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Early stage investor - Current year tax offset amount must be provided",
                    LongDescription = @"When Early stage investor current year tax offset amount, any Early stage investor tax offset from managed fund amounts, or any Early stage investor tax offset - Beneficiary amounts are present on the Income Details schedule, Early stage investor - Current year tax offset amount must be provided",
                    Location = $"/xbrli:xbrl/tns:TaxOffsetClaim.NonRefundableOther.Amount[@contextRef='{report.iitrParentDocument.RPInvestorId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730411" },
                        new ProcessMessageParameter() { Name = "IITR496", Value = report.iitrParentDocument.IITR496.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "[incdtls232] <> NULL", Value = incdtlschilddoc.INCDTLS232.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "ANY[incdtls444]<>NULL", Value = Condition1_INCDTLS444AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY[incdtls416]<>NULL", Value = Condition2_INCDTLS416AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY[incdtls550]<>NULL", Value = Condition3_INCDTLS550AnyNotNull.ToString() }
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730412

        /* VR.ATO.IITR.730412
            The Share of net income from trusts less capital gains, foreign income and franked distributions amount must equal the sum of the following amounts on the Income Details schedule: the Non-primary production net income from trusts (less capital gains, foreign income and franked distributions) amount; all Total non-primary production income from managed fund amounts where there is a single account holder; and all Your share of non-primary production income from managed fund amounts where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR255 <> NULL AND ^IITR255 <> RoundDown(Sum(^INCDTLS250) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS389, ^INCDTLS419)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR255 <> NULL AND ^IITR255 <> RoundDown(Sum(^INCDTLS250) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS389, ^INCDTLS419)), 0)

        Data Elements:

            ^IITR255 = RP:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount

            ^INCDTLS250 = INCDTLS250

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS389 = INCDTLS389

            ^INCDTLS419 = INCDTLS419
        */

        public static ProcessMessageDocument VR_ATO_IITR_730412(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
           
            decimal sumOfINCDTLS250 = 0;
            decimal sumOfINCDTLS389OrINCDTLS419 = 0;
            decimal totalSum = 0;

            // Condition 1: [iitr255] <> NULL
            if (report.iitrParentDocument.IITR255 != null)
            {
                // Condition 2: INCDTLS formm is already provided

                // Condition 3: [iitr255] <> RoundDown([incdtls250] + SUM(ConditionalValue([incdtls387] = 1, [incdtls389], [incdtls419])), 0)
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOfINCDTLS389OrINCDTLS419 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS389.GetValueOrDefault() : tuple.INCDTLS419.GetValueOrDefault());

                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumOfINCDTLS250 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS250.GetValueOrDefault());

                // RoundDown(Sum(^INCDTLS250) + SUM(ConditionalValue([incdtls387] = 1, [incdtls389], [incdtls419])), 0)
                totalSum = Math.Truncate(sumOfINCDTLS250 + sumOfINCDTLS389OrINCDTLS419);

                // Condition 3[iitr255] <> NULL AND [iitr255] <> ([incdtls250] + RoundDown(SUM(ConditionalValue([incdtls387] = 1, [incdtls389], [incdtls419])), 0))
                bool assertion = report.iitrParentDocument.IITR255.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730412",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Share of net income from trusts less capital gains, foreign income and franked distributions amount is incorrect",
                        LongDescription = @"The Share of net income from trusts less capital gains, foreign income and franked distributions amount must equal the sum of the following amounts on the Income Details schedule: the Non-primary production net income from trusts (less capital gains, foreign income and franked distributions) amount; all Total non-primary production income from managed fund amounts where there is a single account holder; and all Your share of non-primary production income from managed fund amounts where there is more than one account holder",
                        Location = "/xbrli:xbrl/tns:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730412" },
                            new ProcessMessageParameter() { Name = "IITR255", Value = report.iitrParentDocument.IITR255.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS250", Value = sumOfINCDTLS250.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS389/419 Sum", Value = sumOfINCDTLS389OrINCDTLS419.ToString() },
                            new ProcessMessageParameter() { Name = "Trust Amount Sums", Value = totalSum.ToString() },
                        }
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730413

        /* VR.ATO.IITR.730413
            Where the Total non-primary production income from managed fund amount or any Non-primary production net income from trusts (less capital gains, foreign income and franked distributions) amounts are present in the attached Income Details schedule, the Share of net income from trusts less capital gains, foreign income and franked distributions amount must be provided

        Legacy Rule Format:
            ^IITR255 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS250, ^INCDTLS250 <> NULL) OR AnyOccurrence(^INCDTLS389, ^INCDTLS389 <> NULL))

        Technical Business Rule Format:
            ^IITR255 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS250, ^INCDTLS250 <> NULL) OR AnyOccurrence(^INCDTLS389, ^INCDTLS389 <> NULL))

        Data Elements:

            ^IITR255 = RP:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount

            ^INCDTLS250 = INCDTLS250

            ^INCDTLS389 = INCDTLS389
        */

        public static ProcessMessageDocument VR_ATO_IITR_730413(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool IITR255NotProvided = report.iitrParentDocument.IITR255 == null;
            bool anyINCDTLS250 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS250 != null);
            bool anyINCDTLS389 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS389 != null);

            bool assertion = report.iitrParentDocument.IITR255 == null && (anyINCDTLS250 || anyINCDTLS389);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730413",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of net income from trusts less capital gains, foreign income and franked distributions amount must be provided",
                    LongDescription = @"Where the Total non-primary production income from managed fund amount or any Non-primary production net income from trusts (less capital gains, foreign income and franked distributions) amounts are present in the attached Income Details schedule, the Share of net income from trusts less capital gains, foreign income and franked distributions amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730413" },
                        new ProcessMessageParameter() { Name = "IITR255 = null", Value = IITR255NotProvided.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS247 <> null", Value = anyINCDTLS250.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS389 <> null", Value = anyINCDTLS389.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730414

        /* VR.ATO.IITR.730414
            The (total) Franked distributions from trusts amount must equal the sum of the following amounts on the Income Details schedule: the Franked distributions from trusts amount; all Total franked distribution from managed fund amounts where there is a single account holder; and all Your share of franked distribution from managed fund amounts where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR259 <> NULL AND ^IITR259 <> RoundDown(Sum(^INCDTLS253) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS390, ^INCDTLS420)), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR259 <> NULL AND ^IITR259 <> RoundDown(Sum(^INCDTLS253) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS390, ^INCDTLS420)), 0)

        Data Elements:

            ^IITR259 = RP:Income.TrustFrankedNonPrimaryProductionShare.Amount

            ^INCDTLS253 = INCDTLS253

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS390 = INCDTLS390

            ^INCDTLS420 = INCDTLS420
        */

        public static ProcessMessageDocument VR_ATO_IITR_730414(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;
            decimal sumOfINCDTLS390OrINCDTLS420 = 0;
            decimal sumOfINCDTLS253 = 0;
            decimal totalSum = 0;

            // Condition 1: [iitr259] <> NULL
            if (report.iitrParentDocument.IITR259 != null)
            {
                // Condition 2: INCDTLS formm is already provided

                // Condition 3: [iitr259] <> RoundDown(Sum(^INCDTLS253) + SUM(ConditionalValue([incdtls387] = 1, [incdtls390], [incdtls420])), 0)
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOfINCDTLS390OrINCDTLS420 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS390.GetValueOrDefault() : tuple.INCDTLS420.GetValueOrDefault());

                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumOfINCDTLS253 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS253.GetValueOrDefault());

                // RoundDown(RoundDown(Sum(^INCDTLS253) + SUM(ConditionalValue([incdtls387] = 1, [incdtls390], [incdtls420])), 0)
                totalSum = Math.Truncate(sumOfINCDTLS253 + sumOfINCDTLS390OrINCDTLS420);

                // Condition 3: [iitr259] <> RoundDown([incdtls253] + SUM(ConditionalValue([incdtls387] = 1, [incdtls390], [incdtls420])), 0)
                assertion = report.iitrParentDocument.IITR259.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730414",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Franked distributions from trusts amount is incorrect",
                        LongDescription = @"The (total) Franked distributions from trusts amount must equal the sum of the following amounts on the Income Details schedule: the Franked distributions from trusts amount; all Total franked distribution from managed fund amounts where there is a single account holder; and all Your share of franked distribution from managed fund amounts where there is more than one account holder",
                        Location = $"/xbrli:xbrl/tns:Income.TrustFrankedNonPrimaryProductionShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730414" },
                            new ProcessMessageParameter() { Name = "IITR259", Value = report.iitrParentDocument.IITR259.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS253 Sum", Value = sumOfINCDTLS253.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS390/420 Sum", Value = sumOfINCDTLS390OrINCDTLS420.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString() },
                        },
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730415

        /* VR.ATO.IITR.730415
            Where the Franked distributions from trusts amount or any Total franked distribution from managed fund amounts are present in the attached Income Details schedule, the (total) Franked distributions from trusts amount must be provided

        Legacy Rule Format:
            ^IITR259 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS253, ^INCDTLS253 <> NULL) OR AnyOccurrence(^INCDTLS390, ^INCDTLS390 <> NULL))

        Technical Business Rule Format:
            ^IITR259 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS253, ^INCDTLS253 <> NULL) OR AnyOccurrence(^INCDTLS390, ^INCDTLS390 <> NULL))

        Data Elements:

            ^IITR259 = RP:Income.TrustFrankedNonPrimaryProductionShare.Amount

            ^INCDTLS253 = INCDTLS253

            ^INCDTLS390 = INCDTLS390
        */

        public static ProcessMessageDocument VR_ATO_IITR_730415(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool Condition3_INCDTLS253AnyNotNull = false;
            bool Condition4_INCDTLS390AnyNotNull = false;

            // Condition 2: ^IITR259 = NULL
            bool condition2_IITR259IsNull = report.iitrParentDocument.IITR259 == null;

            // Condition 3: (AnyOccurrence(^INCDTLS253, ^INCDTLS253 <> NULL)
            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                Condition3_INCDTLS253AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS253 != null);

            // Condition 4: AnyOccurrence(^INCDTLS390, ^INCDTLS390 <> NULL)
            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
                Condition4_INCDTLS390AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS390 != null);

            bool assertion = condition2_IITR259IsNull && (Condition3_INCDTLS253AnyNotNull || Condition4_INCDTLS390AnyNotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730415",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Franked distributions from trusts amount must be provided",
                    LongDescription = @"Where the Franked distributions from trusts amount or any Total franked distribution from managed fund amounts are present in the attached Income Details schedule, the (total) Franked distributions from trusts amount must be provided",
                    Location = $"/xbrli:xbrl/tns:Income.TrustFrankedNonPrimaryProductionShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730415" },
                        new ProcessMessageParameter() { Name = "IITR259", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS253 <> NULL", Value = Condition3_INCDTLS253AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS390 <> NULL", Value = Condition4_INCDTLS390AnyNotNull.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730416

        /* VR.ATO.IITR.730416
            The Credit for TFN amounts withheld from payments from closely held trusts must equal TFN amounts withheld from payments from closely held trusts plus the sum of TFN amounts withheld from payments from closely held trusts from partnership, in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR271 <> NULL AND ^IITR271 <> Sum(^INCDTLS263) + Sum(^INCDTLS483)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR271 <> NULL AND ^IITR271 <> Sum(^INCDTLS263) + Sum(^INCDTLS483)

        Data Elements:

            ^IITR271 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount

            ^INCDTLS263 = INCDTLS263

            ^INCDTLS483 = INCDTLS483
        */

        public static ProcessMessageDocument VR_ATO_IITR_730416(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal? condition2_INCDTLS263Sum = 0;
            decimal? condition2_INCDTLS483Sum = 0;
            
            // Condition 3: ^IITR271 <> NULL AND ^IITR271 <> Sum(^INCDTLS263) + Sum(^INCDTLS483)
            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                condition2_INCDTLS263Sum = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS263.GetValueOrDefault());

            if (incdtlschilddoc.Rp_PartnershipsCollection != null)
                condition2_INCDTLS483Sum = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS483.GetValueOrDefault());

            bool assertion = report.iitrParentDocument.IITR271 != null && report.iitrParentDocument.IITR271.GetValueOrDefault() != (condition2_INCDTLS263Sum + condition2_INCDTLS483Sum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730416",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Credit for TFN amounts withheld from payments from closely held trusts amount is incorrect",
                    LongDescription = @"The Credit for TFN amounts withheld from payments from closely held trusts must equal TFN amounts withheld from payments from closely held trusts plus the sum of TFN amounts withheld from payments from closely held trusts from partnership, in the attached Income Details schedule",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730416" },
                        new ProcessMessageParameter() { Name = "IITR271", Value = report.iitrParentDocument.IITR271.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS263 Sum", Value = condition2_INCDTLS263Sum.ToString()},
                        new ProcessMessageParameter() { Name = "INCDTLS483 Sum", Value = condition2_INCDTLS483Sum.ToString()}
                    },

                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730417

        /* VR.ATO.IITR.730417
            Where any TFN amounts withheld from payments from closely held trusts from partnership or TFN amounts withheld from payments from closely held trusts are present in the Income Details schedule, the Credit for TFN amounts withheld from payments from closely held trusts must be provided

        Legacy Rule Format:
            ^IITR271 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS483, ^INCDTLS483 <> NULL) OR AnyOccurrence(^INCDTLS263, ^INCDTLS263 <> NULL))

        Technical Business Rule Format:
            ^IITR271 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS483, ^INCDTLS483 <> NULL) OR AnyOccurrence(^INCDTLS263, ^INCDTLS263 <> NULL))

        Data Elements:

            ^IITR271 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount

            ^INCDTLS263 = INCDTLS263

            ^INCDTLS483 = INCDTLS483
        */

        public static ProcessMessageDocument VR_ATO_IITR_730417(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool condition1_INCDTLS483IsNotNull = false;
            bool condition2_INCDTLS263IsNotNull = false;

            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition1_INCDTLS483IsNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS483 != null);

            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                condition2_INCDTLS263IsNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS263 != null);

            bool assertion = report.iitrParentDocument.IITR271 == null && (condition1_INCDTLS483IsNotNull || condition2_INCDTLS263IsNotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730417",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Credit for TFN amounts withheld from payments from closely held trusts must be provided",
                    LongDescription = "Where any TFN amounts withheld from payments from closely held trusts from partnership or TFN amounts withheld from payments from closely held trusts are present in the Income Details schedule, the Credit for TFN amounts withheld from payments from closely held trusts must be provided",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730417" },
                        new ProcessMessageParameter() { Name = "IITR271", Value = report.iitrParentDocument.IITR271.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS483 <> NULL", Value = condition1_INCDTLS483IsNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS263 <> NULL", Value = condition2_INCDTLS263IsNotNull.ToString() }
                    },
                };
            }

            return processMessage;

        }

        #endregion
        
        #region VR.ATO.IITR.730418

        /* VR.ATO.IITR.730418
            Share of credit for tax withheld where Australian business number not quoted amount must equal the sum of the following amounts on the Income Details schedule: Tax withheld where Australian business number not quoted from trusts amount, Tax withheld where Australian business number not quoted from partnership amount, Total tax withheld when ABN not quoted from managed fund amount where there is a single account holder and sum of Your share of tax withheld when ABN not quoted from managed fund amount where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR268 <> NULL AND ^IITR268 <> (Sum(^INCDTLS260) + Sum(^INCDTLS480) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS404, ^INCDTLS434)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR268 <> NULL AND ^IITR268 <> (Sum(^INCDTLS260) + Sum(^INCDTLS480) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS404, ^INCDTLS434)))

        Data Elements:

            ^IITR268 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount

            ^INCDTLS260 = INCDTLS260

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS404 = INCDTLS404

            ^INCDTLS434 = INCDTLS434

            ^INCDTLS480 = INCDTLS480
        */

        public static ProcessMessageDocument VR_ATO_IITR_730418(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumINCDTLS260 = 0;
            decimal sumINCDTLS480 = 0;
            decimal sumOfINCDTLS404_434 = 0;
            decimal totalSum = 0;

            // Condition 1: INCDTLS form is already provided

            // Condition 2: [iitr268] <> NULL
            if (report.iitrParentDocument.IITR268 != null)
            {
                // SUM([INCDTLS260])
                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumINCDTLS260 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS260.GetValueOrDefault());

                //  SUM([incdtls480])
                if (incdtlschilddoc.Rp_PartnershipsCollection != null)
                    sumINCDTLS480 = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS480.GetValueOrDefault());

                // Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS404, ^INCDTLS434))
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOfINCDTLS404_434 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS404.GetValueOrDefault() : tuple.INCDTLS434.GetValueOrDefault());

                // (Sum(^INCDTLS260) + Sum(^INCDTLS480) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS404, ^INCDTLS434)))
                totalSum = sumINCDTLS260 + sumINCDTLS480 + sumOfINCDTLS404_434;

                // Condition 3: ^IITR268 <> (Sum(^INCDTLS260) + Sum(^INCDTLS480) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS404, ^INCDTLS434)))
                bool assertion = report.iitrParentDocument.IITR268.GetValueOrDefault() != totalSum;
                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730418",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Share of credit for tax withheld where Australian business number not quoted amount is incorrect",
                        LongDescription = @"Share of credit for tax withheld where Australian business number not quoted amount must equal the sum of the following amounts on the Income Details schedule: Tax withheld where Australian business number not quoted from trusts amount, Tax withheld where Australian business number not quoted from partnership amount, Total tax withheld when ABN not quoted from managed fund amount where there is a single account holder and sum of Your share of tax withheld when ABN not quoted from managed fund amount where there is more than one account holder",
                        Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730418" },
                            new ProcessMessageParameter() { Name = "IITR268", Value = report.iitrParentDocument.IITR268.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS260 Sum", Value = sumINCDTLS260.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS480 Sum", Value = sumINCDTLS480.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS404/434 Sum", Value = sumOfINCDTLS404_434.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sum", Value = totalSum.ToString() },
                        }
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730419

        /* VR.ATO.IITR.730419
            Share of credit for tax withheld where Australian business number not quoted amount must be provided if any of the following amounts on the Income Details schedule are provided: Tax withheld where Australian business number not quoted from trusts amount, Tax withheld where Australian business number not quoted from partnership amount, Total tax withheld when ABN not quoted from managed fund amount and Your share of tax withheld when ABN not quoted from managed fund amount

        Legacy Rule Format:
            ^IITR268 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS260, ^INCDTLS260 <> NULL) OR AnyOccurrence(^INCDTLS480, ^INCDTLS480 <> NULL) OR AnyOccurrence(^INCDTLS404, ^INCDTLS404 <> NULL) OR  AnyOccurrence(^INCDTLS434, ^INCDTLS434 <> NULL))

        Technical Business Rule Format:
            ^IITR268 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS260, ^INCDTLS260 <> NULL) OR AnyOccurrence(^INCDTLS480, ^INCDTLS480 <> NULL) OR AnyOccurrence(^INCDTLS404, ^INCDTLS404 <> NULL) OR  AnyOccurrence(^INCDTLS434, ^INCDTLS434 <> NULL))

        Data Elements:

            ^IITR268 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount

            ^INCDTLS260 = INCDTLS260

            ^INCDTLS404 = INCDTLS404

            ^INCDTLS434 = INCDTLS434

            ^INCDTLS480 = INCDTLS480
        */

        public static ProcessMessageDocument VR_ATO_IITR_730419(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS260AnyNotNull = false;
            bool INCDTLS480AnyNotNull = false;
            bool INCDTLS404AnyNotNull = false;
            bool INCDTLS434AnyNotNull = false;

            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                INCDTLS260AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS260 != null);

            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                INCDTLS404AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS404 != null);
                INCDTLS434AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS434 != null);
            }

            if ( incdtlschilddoc.Rp_PartnershipsCollectionExists)
                INCDTLS480AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS480 != null);

            bool assertion = report.iitrParentDocument.IITR268 == null && (INCDTLS260AnyNotNull || INCDTLS480AnyNotNull || INCDTLS404AnyNotNull || INCDTLS434AnyNotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730419",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for tax withheld where Australian business number not quoted amount must be provided",
                    LongDescription = @"Share of credit for tax withheld where Australian business number not quoted amount must be provided if any of the following amounts on the Income Details schedule are provided: Tax withheld where Australian business number not quoted from trusts amount, Tax withheld where Australian business number not quoted from partnership amount, Total tax withheld when ABN not quoted from managed fund amount and Your share of tax withheld when ABN not quoted from managed fund amount",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730419" },
                        new ProcessMessageParameter() { Name = "IITR268 = NULL", Value = (report.iitrParentDocument.IITR268 == null).ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS260 <> NULL", Value = INCDTLS260AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS480 <> NULL", Value = INCDTLS480AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS404 <> NULL", Value = INCDTLS404AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS434 <> NULL", Value = INCDTLS434AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730420

        /* VR.ATO.IITR.730420
            Share of franking credit from franked dividends amount must equal the sum of the following amounts on the Income Details schedule: Franking credit from franked dividends from trusts amount, Franking credits from partnership amount, Total franking credits from managed fund amount where there is a single account holder and Your share of franking credits from managed fund amount where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR269 <> NULL AND ^IITR269 <> (Sum(^INCDTLS261) + Sum(^INCDTLS481) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS392, ^INCDTLS422)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR269 <> NULL AND ^IITR269 <> (Sum(^INCDTLS261) + Sum(^INCDTLS481) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS392, ^INCDTLS422)))

        Data Elements:

            ^IITR269 = RP:IncomeTax.FrankingCreditsShare.Amount

            ^INCDTLS261 = INCDTLS261

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS392 = INCDTLS392

            ^INCDTLS422 = INCDTLS422

            ^INCDTLS481 = INCDTLS481
        */

        public static ProcessMessageDocument VR_ATO_IITR_730420(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumOf392And422 = 0;
            decimal sumOf481 = 0;
            decimal sumOf261 = 0;
            decimal totalSumOf261And481 = 0;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                sumOf392And422 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS392.GetValueOrDefault() : tuple.INCDTLS422.GetValueOrDefault());
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_PartnershipsCollectionExists)
            {
                sumOf481 = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS481.GetValueOrDefault());
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_TrustIncomeCollectionExists)
            {
                sumOf261 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS261.GetValueOrDefault());
            }

            totalSumOf261And481 = sumOf392And422 + sumOf481 + sumOf261;

            bool assertion = report.iitrParentDocument.IITR269 != null && report.iitrParentDocument.IITR269.GetValueOrDefault() != totalSumOf261And481;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730420",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of franking credit from franked dividends amount is incorrect",
                    LongDescription = @"Share of franking credit from franked dividends amount must equal the sum of the following amounts on the Income Details schedule: Franking credit from franked dividends from trusts amount, Franking credits from partnership amount, Total franking credits from managed fund amount where there is a single account holder and Your share of franking credits from managed fund amount where there is more than one account holder",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.FrankingCreditsShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730420" },
                        new ProcessMessageParameter() { Name = "IITR269", Value = report.iitrParentDocument.IITR269.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS261", Value = sumOf261.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS481", Value = sumOf481.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated total of Franking Credits on the Income Details Schedule", Value = totalSumOf261And481.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730421

        /* VR.ATO.IITR.730421
            Share of franking credit from franked dividends amount must be provided when the following amounts on the Income Details schedule is provided: Franking credit from franked dividends from trusts amount, Franking credits from partnership amount, Total franking credits from managed fund amount where there is a single account holder and Your share of franking credits from managed fund amount where there is more than one account holder

        Legacy Rule Format:
            ^IITR269 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS261, ^INCDTLS261 <> NULL) OR AnyOccurrence(^INCDTLS481, ^INCDTLS481 <> NULL) OR AnyOccurrence(^INCDTLS392, ^INCDTLS392 <> NULL) OR  AnyOccurrence(^INCDTLS422, ^INCDTLS422 <> NULL))

        Technical Business Rule Format:
            ^IITR269 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS261, ^INCDTLS261 <> NULL) OR AnyOccurrence(^INCDTLS481, ^INCDTLS481 <> NULL) OR AnyOccurrence(^INCDTLS392, ^INCDTLS392 <> NULL) OR  AnyOccurrence(^INCDTLS422, ^INCDTLS422 <> NULL))

        Data Elements:

            ^IITR269 = RP:IncomeTax.FrankingCreditsShare.Amount

            ^INCDTLS261 = INCDTLS261

            ^INCDTLS392 = INCDTLS392

            ^INCDTLS422 = INCDTLS422

            ^INCDTLS481 = INCDTLS481
        */

        public static ProcessMessageDocument VR_ATO_IITR_730421(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS481AnyNotNull = false;
            bool INCDTLS392AnyNotNull = false;
            bool INCDTLS422AnyNotNull = false;
            bool INCDTLS261AnyNotNull = false;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                INCDTLS392AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS392 != null);
                INCDTLS422AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS422 != null);
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_PartnershipsCollectionExists)
            {
                INCDTLS481AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS481 != null);
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_TrustIncomeCollectionExists)
            {
                INCDTLS261AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS261 != null);
            }

            bool assertion = report.iitrParentDocument.IITR269 == null && (INCDTLS261AnyNotNull || INCDTLS481AnyNotNull || INCDTLS392AnyNotNull || INCDTLS422AnyNotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730421",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of franking credit from franked dividends  amount must be provided",
                    LongDescription = @"Share of franking credit from franked dividends amount must be provided when the following amounts on the Income Details schedule is provided: Franking credit from franked dividends from trusts amount, Franking credits from partnership amount, Total franking credits from managed fund amount where there is a single account holder and Your share of franking credits from managed fund amount where there is more than one account holder",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.FrankingCreditsShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730421" },
                        new ProcessMessageParameter() { Name = "[iitr269] = NULL", Value = (report.iitrParentDocument.IITR269 == null).ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS261 <> NULL", Value = INCDTLS261AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS481 <> NULL", Value = INCDTLS481AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS392 <> NULL", Value = INCDTLS392AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS422 <> NULL", Value = INCDTLS422AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730422

        /* VR.ATO.IITR.730422
            Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount must equal the sum of the following amounts on the Income Details schedule: TFN amounts withheld from interest, dividends and unit trust distributions from trusts amount, TFN amounts withheld from interest, dividends and unit trust distributions from partnership amount, Total TFN amounts withheld from managed fund amount where there is a single account holder and Your share of TFN amounts withheld from managed fund amount where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR270 <> NULL AND ^IITR270 <> (Sum(^INCDTLS262) + Sum(^INCDTLS482) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS393, ^INCDTLS423)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR270 <> NULL AND ^IITR270 <> (Sum(^INCDTLS262) + Sum(^INCDTLS482) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS393, ^INCDTLS423)))

        Data Elements:

            ^IITR270 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount

            ^INCDTLS262 = INCDTLS262

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS393 = INCDTLS393

            ^INCDTLS423 = INCDTLS423

            ^INCDTLS482 = INCDTLS482
        */

        public static ProcessMessageDocument VR_ATO_IITR_730422(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumOfINCDTLS393_423 = 0;
            decimal sum482 = 0;
            decimal sumINCDTLS262 = 0;
            decimal totalSum = 0;

            // Condition 1: INCDTLS form is already provided

            // Condition 2: [iitr270] <> NULL
            if (report.iitrParentDocument.IITR270 != null)
            {
                // SUM([incdtls482])
                if (incdtlschilddoc.Rp_PartnershipsCollection != null)
                    sum482 = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS482.GetValueOrDefault());

                // SUM(ConditionalValue([incdtls387] = 1, [incdtls393], [incdtls423])))
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumOfINCDTLS393_423 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS393.GetValueOrDefault() : tuple.INCDTLS423.GetValueOrDefault());

                if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                    sumINCDTLS262 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS262.GetValueOrDefault());

                // (Sum(^INCDTLS262) + Sum(^INCDTLS482) + SUM(ConditionalValue([incdtls387] = 1, [incdtls393], [incdtls423])))
                totalSum = sumINCDTLS262 + sum482 + sumOfINCDTLS393_423;

                // Conditon 3: [iitr270] <> ([incdtls262] + SUM([incdtls482]) + SUM(ConditionalValue([incdtls387] = 1, [incdtls393], [incdtls423])))
                assertion = report.iitrParentDocument.IITR270.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730422",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount is incorrect",
                        LongDescription = @"Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount must equal the sum of the following amounts on the Income Details schedule: TFN amounts withheld from interest, dividends and unit trust distributions from trusts amount, TFN amounts withheld from interest, dividends and unit trust distributions from partnership amount, Total TFN amounts withheld from managed fund amount where there is a single account holder and Your share of TFN amounts withheld from managed fund amount where there is more than one account holder",
                        Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730422" },
                            new ProcessMessageParameter() { Name = "IITR270", Value = report.iitrParentDocument.IITR270.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS262", Value = sumINCDTLS262.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS482", Value = sum482.ToString() },
                            new ProcessMessageParameter() { Name = "Sum of INCDTLS393+423", Value = sumOfINCDTLS393_423.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sum of INCDTLS Amounts", Value = totalSum.ToString() },
                        }
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730423

        /* VR.ATO.IITR.730423
            Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount must be provided when the following amounts on the Income Details schedule is provided: TFN amounts withheld from interest, dividends and unit trust distributions from trusts amount, TFN amounts withheld from interest, dividends and unit trust distributions from partnership amount, Total TFN amounts withheld from managed fund amount and Your share of TFN amounts withheld from managed fund amount

        Legacy Rule Format:
            ^IITR270 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS262, ^INCDTLS262 <> NULL) OR AnyOccurrence(^INCDTLS482, ^INCDTLS482 <> NULL) OR AnyOccurrence(^INCDTLS393, ^INCDTLS393 <> NULL) OR  AnyOccurrence(^INCDTLS423, ^INCDTLS423 <> NULL))

        Technical Business Rule Format:
            ^IITR270 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS262, ^INCDTLS262 <> NULL) OR AnyOccurrence(^INCDTLS482, ^INCDTLS482 <> NULL) OR AnyOccurrence(^INCDTLS393, ^INCDTLS393 <> NULL) OR  AnyOccurrence(^INCDTLS423, ^INCDTLS423 <> NULL))

        Data Elements:

            ^IITR270 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount

            ^INCDTLS262 = INCDTLS262

            ^INCDTLS393 = INCDTLS393

            ^INCDTLS423 = INCDTLS423

            ^INCDTLS482 = INCDTLS482
        */

        public static ProcessMessageDocument VR_ATO_IITR_730423(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS482AnyNotNull = false;
            bool INCDTLS393AnyNotNull = false;
            bool INCDTLS423AnyNotNull = false;
            bool INCDTLS262AnyNotNull = false;

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                INCDTLS393AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS393 != null);
                INCDTLS423AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS423 != null);
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_PartnershipsCollectionExists)
            {
                INCDTLS482AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS482 != null);
            }

            if (incdtlschilddoc != null && incdtlschilddoc.Rp_TrustIncomeCollectionExists)
            {
                INCDTLS262AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS262 != null);
            }

            bool assertion = report.iitrParentDocument.IITR270 == null && (INCDTLS262AnyNotNull || INCDTLS482AnyNotNull || INCDTLS393AnyNotNull || INCDTLS423AnyNotNull);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730423",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount must be provided",
                    LongDescription = @"Share of credit for TFN amounts withheld from interest, dividends and unit trust distributions amount must be provided when the following amounts on the Income Details schedule is provided: TFN amounts withheld from interest, dividends and unit trust distributions from trusts amount, TFN amounts withheld from interest, dividends and unit trust distributions from partnership amount, Total TFN amounts withheld from managed fund amount and Your share of TFN amounts withheld from managed fund amount",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730423" },
                        new ProcessMessageParameter() { Name = "[iitr270] = NULL", Value = (report.iitrParentDocument.IITR270 == null).ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS262 <> NULL", Value = INCDTLS262AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS482 <> NULL", Value = INCDTLS482AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS393 <> NULL", Value = INCDTLS393AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS423 <> NULL", Value = INCDTLS423AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        //#region VR.ATO.IITR.730416

        ///* VR.ATO.IITR.730416
        //    The Credit for TFN amounts withheld from payments from closely held trusts must equal TFN amounts withheld from payments from closely held trusts plus the sum of TFN amounts withheld from payments from closely held trusts from partnership, in the attached Income Details schedule

        //Legacy Rule Format:
        //    CountDocument('INCDTLS') = 1 AND ^IITR271 <> NULL AND ^IITR271 <> ^INCDTLS263 + Sum(^INCDTLS483)

        //Technical Business Rule Format:
        //    CountDocument('INCDTLS') = 1 AND ^IITR271 <> NULL AND ^IITR271 <> ^INCDTLS263 + Sum(^INCDTLS483)

        //Data Elements:

        //    ^IITR271 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount

        //    ^INCDTLS263 = INCDTLS263

        //    ^INCDTLS483 = INCDTLS483
        //*/

        //public static ProcessMessageDocument VR_ATO_IITR_730416(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        //{
        //    ProcessMessageDocument processMessage = null;

        //    decimal? condition2_INCDTLS483Sum = 0m;

        //    //Condition 2 sum: SUM([incdtls483])
        //    condition2_INCDTLS483Sum = incdtlschilddoc?.Rp_PartnershipsCollection?.Sum(tuple => tuple.INCDTLS483.GetValueOrDefault());

        //    bool assertion = report.iitrParentDocument.IITR271 != null && report.iitrParentDocument.IITR271.GetValueOrDefault() != (incdtlschilddoc.INCDTLS263.GetValueOrDefault() + condition2_INCDTLS483Sum.GetValueOrDefault());
        //    if (assertion)
        //    {
        //        processMessage = new ProcessMessageDocument()
        //        {
        //            Code = "CMN.ATO.IITR.730416",
        //            Severity = ProcessMessageSeverity.Error,
        //            Description = @"Credit for TFN amounts withheld from payments from closely held trusts amount is incorrect",
        //            LongDescription = @"The Credit for TFN amounts withheld from payments from closely held trusts must equal TFN amounts withheld from payments from closely held trusts plus the sum of TFN amounts withheld from payments from closely held trusts from partnership, in the attached Income Details schedule",
        //            Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
        //            Parameters = new ProcessMessageParameters()
        //            {
        //                new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730416" },
        //                new ProcessMessageParameter() { Name = "IITR271", Value = report.iitrParentDocument.IITR271.ToString() },
        //                new ProcessMessageParameter() { Name = "INCDTLS263", Value = incdtlschilddoc.INCDTLS263.GetValueOrDefault().ToString()},
        //                new ProcessMessageParameter() { Name = "SUM([incdtls483]", Value = condition2_INCDTLS483Sum.ToString()}
        //            },

        //        };
        //    }

        //    return processMessage;
        //}

        //#endregion

        //#region VR.ATO.IITR.730417

        ///* VR.ATO.IITR.730417
        //    Where any TFN amounts withheld from payments from closely held trusts from partnership or TFN amounts withheld from payments from closely held trusts are present in the Income Details schedule, the Credit for TFN amounts withheld from payments from closely held trusts must be provided

        //Legacy Rule Format:
        //    ^IITR271 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS483, ^INCDTLS483 <> NULL) OR ^INCDTLS263 <> NULL)

        //Technical Business Rule Format:
        //    ^IITR271 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS483, ^INCDTLS483 <> NULL) OR ^INCDTLS263 <> NULL)

        //Data Elements:

        //    ^IITR271 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount

        //    ^INCDTLS263 = INCDTLS263

        //    ^INCDTLS483 = INCDTLS483
        //*/

        //public static ProcessMessageDocument VR_ATO_IITR_730417(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        //{
        //    ProcessMessageDocument processMessage = null;

        //    bool condition1_INCDTLS483IsNotNull = false;
        //    bool condition2_INCDTLS263IsNotNull = false;

        //    if (incdtlschilddoc.Rp_PartnershipsCollectionExists && incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS483 != null))
        //    {
        //        condition1_INCDTLS483IsNotNull = true;
        //    }

        //    if (incdtlschilddoc.INCDTLS263 != null)
        //    {
        //        condition2_INCDTLS263IsNotNull = true;
        //    }

        //    bool assertion = report.iitrParentDocument.IITR271 == null && (condition1_INCDTLS483IsNotNull || condition2_INCDTLS263IsNotNull);

        //    if (assertion)
        //    {
        //        processMessage = new ProcessMessageDocument()
        //        {
        //            Code = "CMN.ATO.IITR.730417",
        //            Severity = ProcessMessageSeverity.Error,
        //            Description = @"Credit for TFN amounts withheld from payments from closely held trusts must be provided",
        //            LongDescription = "Where any TFN amounts withheld from payments from closely held trusts from partnership or TFN amounts withheld from payments from closely held trusts are present in the Income Details schedule, the Credit for TFN amounts withheld from payments from closely held trusts must be provided",
        //            Location = $"/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
        //            Parameters = new ProcessMessageParameters()
        //            {
        //                new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730417" },
        //                new ProcessMessageParameter() { Name = "IITR271", Value = report.iitrParentDocument.IITR271.GetValueOrDefault().ToString() },
        //                new ProcessMessageParameter() { Name = "[incdtls483] <> NULL", Value = condition1_INCDTLS483IsNotNull.ToString() },
        //                new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF [incdtls483] <> NULL", Value = condition2_INCDTLS263IsNotNull.ToString() }
        //            },
        //        };
        //    }

        //    return processMessage;

        //}

        //#endregion

        #region VR.ATO.IITR.730430

        /* VR.ATO.IITR.730430
            The Bonuses from life insurance companies and friendly societies amount must equal the sum of all Other income amounts provided in the attached Income Details schedule, where the corresponding income type is "Bonuses from life insurance and friendly societies"

        Legacy Rule Format:
            ^IITR339 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR339 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Bonuses from life insurance and friendly societies', ^INCDTLS451, 0)), 0)

        Technical Business Rule Format:
            ^IITR339 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR339 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Bonuses from life insurance and friendly societies', ^INCDTLS451, 0)), 0)

        Data Elements:

            ^IITR339 = RP:IncomeTax.LifeInsuranceCompaniesAndFriendlySocietiesBonuses.Amount

            ^INCDTLS449 = INCDTLS449

            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730430(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumOfINCDTLS451 = 0;

            // Condition 2: INCDTLS form is already provided

            // Condition 1: [iitr339] <> NULL
            if (report.iitrParentDocument.IITR339 != null)
            {
                // RoundDown(SUM(ConditionalValue([incdtls449] = ""Bonuses from life insurance and friendly societies"", [incdtls451], 0)), 0)
                if (incdtlschilddoc.Rp_IncomeOtherCollection != null)
                    sumOfINCDTLS451 = incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS449 == "Bonuses from life insurance and friendly societies" ? tuple.INCDTLS451.GetValueOrDefault() : 0);

                // Condition 3: [iitr339] <> RoundDown(SUM(ConditionalValue([incdtls449] = ""Bonuses from life insurance and friendly societies"", [incdtls451], 0)), 0)
                assertion = report.iitrParentDocument.IITR339.GetValueOrDefault() != Math.Truncate(sumOfINCDTLS451);

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730430",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Bonuses from life insurance companies and friendly societies amount is incorrect",
                        LongDescription = @"The Bonuses from life insurance companies and friendly societies amount must equal the sum of all Other income amounts provided in the attached Income Details schedule, where the corresponding income type is ""Bonuses from life insurance and friendly societies""",
                        Location = $"/xbrli:xbrl/tns:IncomeTax.LifeInsuranceCompaniesAndFriendlySocietiesBonuses.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730430" },
                            new ProcessMessageParameter() { Name = "IITR339", Value = report.iitrParentDocument.IITR339.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = "Sum INCDTLS451", Value = sumOfINCDTLS451.ToString() },
                        }
                    };
                }
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730431

        /* VR.ATO.IITR.730431
            When "Bonuses from life insurance and friendly societies" is selected for an Other income type with a corresponding Other income amount, both on the attached Income Details schedule, the Bonuses from life insurance companies and friendly societies amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR339 = NULL AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Bonuses from life insurance and friendly societies'

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR339 = NULL AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Bonuses from life insurance and friendly societies'

        Data Elements:

            ^IITR339 = RP:IncomeTax.LifeInsuranceCompaniesAndFriendlySocietiesBonuses.Amount
7
            ^INCDTLS449 = INCDTLS449

            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730431(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS451AnyNotNull = false;

            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
            {
                INCDTLS451AnyNotNull = incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS451 != null && tuple.INCDTLS449.Equals("Bonuses from life insurance and friendly societies"));
            }

            bool assertion = report.iitrParentDocument.IITR339 == null && INCDTLS451AnyNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730431",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Bonuses from life insurance companies and friendly societies must be provided",
                    LongDescription = @"When ""Bonuses from life insurance and friendly societies"" is selected for an Other income type with a corresponding Other income amount, both on the attached Income Details schedule, the Bonuses from life insurance companies and friendly societies amount must be provided",
                    Location = $"/xbrli:xbrl/tns:IncomeTax.LifeInsuranceCompaniesAndFriendlySocietiesBonuses.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730431" },
                        new ProcessMessageParameter() { Name = "[iitr339] = NULL", Value = (report.iitrParentDocument.IITR339 == null).ToString() },
                        new ProcessMessageParameter() { Name = @"ANY OCCURRENCE OF([incdtls451]) <> NULL WHERE [incdtls449] = ""Bonuses from life insurance and friendly societies""", Value = INCDTLS451AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730432

        /* VR.ATO.IITR.730432
            The Forestry managed investment scheme income amount must equal the sum of all Other income amounts provided in the attached Income Details schedule, where the corresponding income type is "Forestry managed investments"

        Legacy Rule Format:
            ^IITR341 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR341 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Forestry managed investments', ^INCDTLS451, 0)), 0)

        Technical Business Rule Format:
            ^IITR341 <> NULL AND CountDocument('INCDTLS') = 1 AND ^IITR341 <> RoundDown(Sum(ConditionalValue(^INCDTLS449 = 'Forestry managed investments', ^INCDTLS451, 0)), 0)

        Data Elements:

            ^IITR341 = RP:Income.ForestryManagedInvestmentScheme.Amount

            ^INCDTLS449 = INCDTLS449

            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730432(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumOfINCDTLS451 = 0;

            // Condition 2: COUNT(SCHEDULE = ""INCDTLS"") = 1

            // Condition 1: [iitr341] <> NULL
            if (report.iitrParentDocument.IITR341 != null)
            {
                // RoundDown(SUM(ConditionalValue([incdtls449] = ""Forestry managed investments"", [incdtls451], 0)), 0)
                if (incdtlschilddoc.Rp_IncomeOtherCollection != null)
                    sumOfINCDTLS451 = incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS449 == "Forestry managed investments" ? tuple.INCDTLS451.GetValueOrDefault() : 0);

                // Conditon 3: [iitr341] <> RoundDown(SUM(ConditionalValue([incdtls449] = ""Forestry managed investments"", [incdtls451], 0)), 0)
                assertion = report.iitrParentDocument.IITR341.GetValueOrDefault() != Math.Truncate(sumOfINCDTLS451);

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730432",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Forestry managed investment scheme income amount is incorrect",
                        LongDescription = @"The Forestry managed investment scheme income amount must equal the sum of all Other income amounts provided in the attached Income Details schedule, where the corresponding income type is ""Forestry managed investments""",
                        Location = $"/xbrli:xbrl/tns:Income.ForestryManagedInvestmentScheme.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                        Parameters = new ProcessMessageParameters() {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730432" },
                            new ProcessMessageParameter() { Name = "IITR341", Value = report.iitrParentDocument.IITR341.GetValueOrDefault().ToString() },
                            new ProcessMessageParameter() { Name = @"Sum INCDTLS451", Value = sumOfINCDTLS451.ToString() },
                        }
                    };
                }
            }
            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730433

        /* VR.ATO.IITR.730433
            When "Forestry managed investments" is selected for an Other income type with a corresponding Other income amount, both on the attached Income Details schedule, the Forestry managed investment scheme income amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR341 = NULL AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Forestry managed investments'

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR341 = NULL AND AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE ^INCDTLS449 = 'Forestry managed investments'

        Data Elements:

            ^IITR341 = RP:Income.ForestryManagedInvestmentScheme.Amount

            ^INCDTLS449 = INCDTLS449

            ^INCDTLS451 = INCDTLS451
        */

        public static ProcessMessageDocument VR_ATO_IITR_730433(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool INCDTLS451AnyNotNull = false;

            if (incdtlschilddoc.Rp_IncomeOtherCollectionExists)
            {
                INCDTLS451AnyNotNull = incdtlschilddoc.Rp_IncomeOtherCollection.Any(tuple => tuple.INCDTLS451 != null && tuple.INCDTLS449.Equals("Forestry managed investments"));
            }

            bool assertion = report.iitrParentDocument.IITR341 == null && INCDTLS451AnyNotNull;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730433",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Forestry managed investment scheme income must be provided",
                    LongDescription = @"When ""Forestry managed investments"" is selected for an Other income type with a corresponding Other income amount, both on the attached Income Details schedule, the Forestry managed investment scheme income amount must be provided",
                    Location = $"/xbrli:xbrl/tns:Income.ForestryManagedInvestmentScheme.Amount[@contextRef='{report.iitrParentDocument.RPId}']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730433" },
                        new ProcessMessageParameter() { Name = "[IITR341] = NULL", Value = (report.iitrParentDocument.IITR341 == null).ToString() },
                        new ProcessMessageParameter() { Name = @"INCDTLS451 <> Null", Value = INCDTLS451AnyNotNull.ToString() },
                    }
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730424 

        /* VR.ATO.IITR.730424
            Share of credit for tax paid by trustee amount must equal the sum of the following amounts on the Income Details schedule: Credit for tax paid by trustee amount; Total credit for tax paid by trustee from managed fund amounts where there is a single account holder; and all Your share of credit for tax paid by trustee from managed fund amounts where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR272 <> NULL AND ^IITR272 <> (Sum(^INCDTLS264) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS405, ^INCDTLS435)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR272 <> NULL AND ^IITR272 <> (Sum(^INCDTLS264) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS405, ^INCDTLS435)))

        Data Elements:

            ^IITR272 = RP:IncomeTax.CreditTrusteeTaxPaidShare.Amount

            ^INCDTLS264 = INCDTLS264

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS405 = INCDTLS405

            ^INCDTLS435 = INCDTLS435
        */

        public static ProcessMessageDocument VR_ATO_IITR_730424(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal sumINCDTLS405_INCDTLS435 = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS405.GetValueOrDefault() : tuple.INCDTLS435.GetValueOrDefault()) : 0;
            decimal sumINCDTLS264 = incdtlschilddoc.Rp_TrustIncomeCollection != null ? incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS264.GetValueOrDefault()) : 0;

            decimal sumOfINCDTLS264_INCDTLS405_INCDTLS435 = sumINCDTLS264 + sumINCDTLS405_INCDTLS435;

            bool assertion = (report.iitrParentDocument.IITR272 != null && report.iitrParentDocument.IITR272 != sumOfINCDTLS264_INCDTLS405_INCDTLS435);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730424",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for tax paid by trustee amount is incorrect",
                    LongDescription = "Share of credit for tax paid by trustee amount must equal the sum of the following amounts on the Income Details schedule: Credit for tax paid by trustee amount; Total credit for tax paid by trustee from managed fund amounts where there is a single account holder; and all Your share of credit for tax paid by trustee from managed fund amounts where there is more than one account holder",
                    Location = "/xbrli:xbrl/tns:IncomeTax.CreditTrusteeTaxPaidShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730424" },
                        new ProcessMessageParameter() { Name = "IITR272", Value = report.iitrParentDocument.IITR272.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS264 Sum", Value = sumINCDTLS264.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS405/435 Sum", Value = sumINCDTLS405_INCDTLS435.ToString() },
                        new ProcessMessageParameter() { Name = "Total Sum", Value = sumINCDTLS405_INCDTLS435.ToString()}
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730424 

        #region VR.ATO.IITR.730425 

        /* VR.ATO.IITR.730425
            Where Credit for tax paid by trustee amount or any Total credit for tax paid by trustee from managed fund amounts or any Your share of credit for tax paid by trustee from managed fund amounts are present in the attached Income Details schedule, Share of credit for tax paid by trustee amount must be provided

        Legacy Rule Format:
            ^IITR272 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS264, ^INCDTLS264 <> NULL) OR AnyOccurrence(^INCDTLS405, ^INCDTLS405 <> NULL) OR AnyOccurrence(^INCDTLS435, ^INCDTLS435 <> NULL))

        Technical Business Rule Format:
            ^IITR272 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS264, ^INCDTLS264 <> NULL) OR AnyOccurrence(^INCDTLS405, ^INCDTLS405 <> NULL) OR AnyOccurrence(^INCDTLS435, ^INCDTLS435 <> NULL))

        Data Elements:

            ^IITR272 = RP:IncomeTax.CreditTrusteeTaxPaidShare.Amount

            ^INCDTLS264 = INCDTLS264

            ^INCDTLS405 = INCDTLS405

            ^INCDTLS435 = INCDTLS435
        */

        public static ProcessMessageDocument VR_ATO_IITR_730425(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS405 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS405 != null);
            bool anyINCDTLS435 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS435 != null);
            bool anyINCDTLS264 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS264 != null);

            bool assertion = (report.iitrParentDocument.IITR272 == null && (anyINCDTLS264 || anyINCDTLS405 || anyINCDTLS435));

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730425",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for tax paid by trustee amount must be provided",
                    LongDescription = @"Where Credit for tax paid by trustee amount or any Total credit for tax paid by trustee from managed fund amounts or any Your share of credit for tax paid by trustee from managed fund amounts are present in the attached Income Details schedule, Share of credit for tax paid by trustee amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.CreditTrusteeTaxPaidShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730425" },
                        new ProcessMessageParameter() { Name = "IITR272", Value = GetValueOrEmpty(report.iitrParentDocument.IITR272.ToString()) },
                        new ProcessMessageParameter() { Name = "INCDTLS264 <> Null", Value = anyINCDTLS264.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS405 <> Null", Value = anyINCDTLS405.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS435 <> Null", Value = anyINCDTLS435.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730425 

        #region VR.ATO.IITR.730426

        /* VR.ATO.IITR.730426
            Share of credit for foreign resident withholding amounts (excluding capital gains) amount must equal the sum of the following amounts on the Income Details schedule: Credit for foreign resident withholding amounts (excluding capital gains) from trusts amount; Credit for foreign resident withholding amounts (excluding capital gains) from partnership amount; Total credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts where there is a single account holder; and all Your share of credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR273 <> NULL AND ^IITR273 <> (Sum(^INCDTLS268) + Sum(^INCDTLS484) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS408, ^INCDTLS436)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR273 <> NULL AND ^IITR273 <> (Sum(^INCDTLS268) + Sum(^INCDTLS484) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS408, ^INCDTLS436)))

        Data Elements:

            ^IITR273 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount

            ^INCDTLS268 = INCDTLS268

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS408 = INCDTLS408

            ^INCDTLS436 = INCDTLS436

            ^INCDTLS484 = INCDTLS484
        */

        public static ProcessMessageDocument VR_ATO_IITR_730426(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            decimal sumINCDTLS268 = incdtlschilddoc.Rp_TrustIncomeCollection != null ? incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS268.GetValueOrDefault()) : 0;
            decimal sumINCDTLS484 = incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS484.GetValueOrDefault()) : 0;
            decimal sumINCDTLS408_INCDTLS436 = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS408.GetValueOrDefault() : tuple.INCDTLS436.GetValueOrDefault()) : 0;
            decimal sumOfINCDTLS268_INCDTLS484_INCDTLS408_INCDTLS436 = sumINCDTLS268 + sumINCDTLS484 + sumINCDTLS408_INCDTLS436;

            bool assertion = (report.iitrParentDocument.IITR273 != null && report.iitrParentDocument.IITR273.GetValueOrDefault() != sumOfINCDTLS268_INCDTLS484_INCDTLS408_INCDTLS436);

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730426",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for foreign resident withholding amounts (excluding capital gains) amount is incorrect",
                    LongDescription = "Share of credit for foreign resident withholding amounts (excluding capital gains) amount must equal the sum of the following amounts on the Income Details schedule: Credit for foreign resident withholding amounts (excluding capital gains) from trusts amount; Credit for foreign resident withholding amounts (excluding capital gains) from partnership amount; Total credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts where there is a single account holder; and all Your share of credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts where there is more than one account holder",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730426" },
                        new ProcessMessageParameter() { Name = "IITR273", Value = report.iitrParentDocument.IITR273.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS268 Sum", Value = sumINCDTLS268.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS484 Sum", Value = sumINCDTLS484.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS408/436 Sum", Value = sumINCDTLS408_INCDTLS436.ToString()},
                        new ProcessMessageParameter() { Name = "Total Sum", Value = sumOfINCDTLS268_INCDTLS484_INCDTLS408_INCDTLS436.ToString()},
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730426

        #region VR.ATO.IITR.730427          

        /* VR.ATO.IITR.730427
            Where Credit for foreign resident withholding amounts (excluding capital gains) from trusts amount or any Credit for foreign resident withholding amounts (excluding capital gains) from partnership amounts or any Total credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts or any Your share of credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts are present in the attached Income Details schedule, Share of credit for foreign resident withholding amounts (excluding capital gains) amount must be provided

        Legacy Rule Format:
            ^IITR273 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS268, ^INCDTLS268 <> NULL) OR AnyOccurrence(^INCDTLS484, ^INCDTLS484 <> NULL) OR AnyOccurrence(^INCDTLS408, ^INCDTLS408 <> NULL) OR AnyOccurrence(^INCDTLS436, ^INCDTLS436 <> NULL))

        Technical Business Rule Format:
            ^IITR273 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS268, ^INCDTLS268 <> NULL) OR AnyOccurrence(^INCDTLS484, ^INCDTLS484 <> NULL) OR AnyOccurrence(^INCDTLS408, ^INCDTLS408 <> NULL) OR AnyOccurrence(^INCDTLS436, ^INCDTLS436 <> NULL))

        Data Elements:

            ^IITR273 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount

            ^INCDTLS268 = INCDTLS268

            ^INCDTLS408 = INCDTLS408

            ^INCDTLS436 = INCDTLS436

            ^INCDTLS484 = INCDTLS484
        */

        public static ProcessMessageDocument VR_ATO_IITR_730427(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS268 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS268 != null);
            bool anyINCDTLS484 = incdtlschilddoc.Rp_PartnershipsCollection != null && incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS484 != null);
            bool anyINCDTLS408 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS408 != null);
            bool anyINCDTLS436 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS436!= null);

            bool assertion = (report.iitrParentDocument.IITR273 == null && (anyINCDTLS268 || anyINCDTLS484 || anyINCDTLS408 || anyINCDTLS436));

            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730427",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of credit for foreign resident withholding amounts (excluding capital gains) amount must be provided",
                    LongDescription = "Where Credit for foreign resident withholding amounts (excluding capital gains) from trusts amount or any Credit for foreign resident withholding amounts (excluding capital gains) from partnership amounts or any Total credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts or any Your share of credit for foreign resident withholding amounts (excluding capital gains) from managed fund amounts are present in the attached Income Details schedule, Share of credit for foreign resident withholding amounts (excluding capital gains) amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730427" },
                        new ProcessMessageParameter() { Name = "IITR273", Value = GetValueOrEmpty(report.iitrParentDocument.IITR273.ToString()) },
                        new ProcessMessageParameter() { Name = "INCDTLS268 <> Null", Value = anyINCDTLS268.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS484 <> Null", Value = anyINCDTLS484.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS408 <> Null", Value = anyINCDTLS408.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS436 <> Null", Value = anyINCDTLS436.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730427

        #region VR.ATO.IITR.730428

        /* VR.ATO.IITR.730428
            Share of National rental affordability scheme tax offset amount must equal the sum of the following amounts on the Income Details schedule: National rental affordability scheme tax offset from trusts amount; National rental affordability scheme tax offset from partnership amount; Total national rental affordability scheme offset from managed fund amounts where there is a single account holder; and all Your share of national rental affordability scheme offset from managed fund amounts where there is more than one account holder

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR274 <> NULL AND ^IITR274 <> (Sum(^INCDTLS269) + Sum(^INCDTLS485) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS409, ^INCDTLS437)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR274 <> NULL AND ^IITR274 <> (Sum(^INCDTLS269) + Sum(^INCDTLS485) + Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS409, ^INCDTLS437)))

        Data Elements:

            ^IITR274 = RP:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount

            ^INCDTLS269 = INCDTLS269

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS409 = INCDTLS409

            ^INCDTLS437 = INCDTLS437

            ^INCDTLS485 = INCDTLS485
        */

        public static ProcessMessageDocument VR_ATO_IITR_730428(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;

            decimal sumINCDTLS485 = 0;
            decimal sumINCDTLS409_INCDTLS437 = 0;
            decimal totalSum = 0;
            decimal sumINCDTLS269 = 0;

            // Condition 1: INCDTLS form is already provided

            // Condition 2: [iitr274] <> NULL
            if (report.iitrParentDocument.IITR274 != null)
            {
                // SUM([incdtls485])
                if (incdtlschilddoc.Rp_PartnershipsCollection != null)
                    sumINCDTLS485 = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS485.GetValueOrDefault());

                // SUM(ConditionalValue([incdtls387] = 1, [incdtls409], [incdtls437])))
                if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                    sumINCDTLS409_INCDTLS437 = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS409.GetValueOrDefault() : tuple.INCDTLS437.GetValueOrDefault());

                // Sum(^INCDTLS269)
                if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                    sumINCDTLS269 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS269.GetValueOrDefault());

                // (SUM[incdtls269] + SUM([incdtls485]) + SUM(ConditionalValue([incdtls387] = 1, [incdtls409], [incdtls437])))
                totalSum = sumINCDTLS269 + sumINCDTLS485 + sumINCDTLS409_INCDTLS437;

                // Conditon 3: [iitr274] <> ([incdtls269] + SUM([incdtls485]) + SUM(ConditionalValue([incdtls387] = 1, [incdtls409], [incdtls437])))
                assertion = report.iitrParentDocument.IITR274.GetValueOrDefault() != totalSum;

                if (assertion)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IITR.730428",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Share of National rental affordability scheme tax offset amount is incorrect",
                        LongDescription = "Share of National rental affordability scheme tax offset amount must equal the sum of the following amounts on the Income Details schedule: National rental affordability scheme tax offset from trusts amount; National rental affordability scheme tax offset from partnership amount; Total national rental affordability scheme offset from managed fund amounts where there is a single account holder; and all Your share of national rental affordability scheme offset from managed fund amounts where there is more than one account holder",
                        Location = "/xbrli:xbrl/tns:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                        Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730428" },
                            new ProcessMessageParameter() { Name = "IITR274", Value = report.iitrParentDocument.IITR274.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTL269S Sum", Value = sumINCDTLS269.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS485 Sum", Value = sumINCDTLS485.ToString() },
                            new ProcessMessageParameter() { Name = "INCDTLS409/437 Sum", Value = sumINCDTLS409_INCDTLS437.ToString() },
                            new ProcessMessageParameter() { Name = "Total Sums", Value = totalSum.ToString() }
                        },
                    };
                }
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730428

        #region VR.ATO.IITR.730429

        /* VR.ATO.IITR.730429
            Where National rental affordability scheme tax offset from trusts amount or any National rental affordability scheme tax offset from partnership amounts or any Total national rental affordability scheme offset from managed fund amounts or any Your share of national rental affordability scheme offset from managed fund amounts are present in the attached Income Details schedule, Share of National rental affordability scheme tax offset amount must be provided

        Legacy Rule Format:
            ^IITR274 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS269, ^INCDTLS269 <> NULL) OR AnyOccurrence(^INCDTLS485, ^INCDTLS485 <> NULL) OR AnyOccurrence(^INCDTLS409, ^INCDTLS409 <> NULL) OR AnyOccurrence(^INCDTLS437, ^INCDTLS437 <> NULL))

        Technical Business Rule Format:
            ^IITR274 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS269, ^INCDTLS269 <> NULL) OR AnyOccurrence(^INCDTLS485, ^INCDTLS485 <> NULL) OR AnyOccurrence(^INCDTLS409, ^INCDTLS409 <> NULL) OR AnyOccurrence(^INCDTLS437, ^INCDTLS437 <> NULL))

        Data Elements:

            ^IITR274 = RP:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount

            ^INCDTLS269 = INCDTLS269

            ^INCDTLS409 = INCDTLS409

            ^INCDTLS437 = INCDTLS437

            ^INCDTLS485 = INCDTLS485
        */

        public static ProcessMessageDocument VR_ATO_IITR_730429(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            bool anyINCDTLS269 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS269 != null);
            bool anyINCDTLS485 = incdtlschilddoc.Rp_PartnershipsCollection != null && incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS485 != null);
            bool anyINCDTLS409 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS409 != null);
            bool anyINCDTLS437 = incdtlschilddoc.Rp_ManagedFundsCollection != null && incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS437 != null);

            bool assertion = (report.iitrParentDocument.IITR274 == null && (anyINCDTLS269 || anyINCDTLS485 || anyINCDTLS409 || anyINCDTLS437));
            ProcessMessageDocument processMessage = null;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730429",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of National rental affordability scheme tax offset amount must be provided",
                    LongDescription = "Where National rental affordability scheme tax offset from trusts amount or any National rental affordability scheme tax offset from partnership amounts or any Total national rental affordability scheme offset from managed fund amounts or any Your share of national rental affordability scheme offset from managed fund amounts are present in the attached Income Details schedule, Share of National rental affordability scheme tax offset amount must be provided",
                    Location = "/xbrli:xbrl/tns:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "IITR274", Value = GetValueOrEmpty(report.iitrParentDocument.IITR274.ToString()) },
                        new ProcessMessageParameter() { Name = "INCDTLS269 <> null", Value = anyINCDTLS269.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS485 <> null", Value = anyINCDTLS485.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS409 <> null", Value = anyINCDTLS409.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS437 <> null", Value = anyINCDTLS437.ToString() },
                    },

                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730429

        #region VR.ATO.IITR.730450

        /* VR.ATO.IITR.730450
            The Net income/loss from business tax withheld voluntary agreement amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "003" (voluntary agreement) and Business income statement type is "Business" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR286 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR286 <> (Sum(ConditionalValue(^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR286 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR286 <> (Sum(ConditionalValue(^INCDTLS489 = '003' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR286 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730450(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR286IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR286NotEqualsSum = false;

            // Condition 1: [iitr286] <> NULL
            condition1_IITR286IsNotNull = report.iitrParentDocument.IITR286 != null;

            // Condition 3 Sum: (SUM(ConditionalValue([incdtls489] = "003", [incdtls493], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Business" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr286] <> (SUM(ConditionalValue([incdtls489] = "003", [incdtls493], 0)))
            condition3_IITR286NotEqualsSum = report.iitrParentDocument.IITR286.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR286IsNotNull && condition2_INCDTLSExists && condition3_IITR286NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730450",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld voluntary agreement is incorrect",
                    LongDescription = "The Net income/loss from business tax withheld voluntary agreement amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"003\" (voluntary agreement) and Business income statement type is \"Business\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730450" },
                        new ProcessMessageParameter() { Name = "IITR286", Value = report.iitrParentDocument.IITR286.ToString() },
                        new ProcessMessageParameter() { Name = "(SUM(ConditionalValue([incdtls489] = \"003\", [incdtls493], 0)))", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730450

        #region VR.ATO.IITR.730451

        /* VR.ATO.IITR.730451
            The Net income/loss from business tax withheld where Australian business number not quoted amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "012" (no ABN quoted) and Business income statement type is "Business" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR287 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR287 <> (Sum(ConditionalValue(^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR287 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR287 <> (Sum(ConditionalValue(^INCDTLS489 = '012' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR287 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessABNNotQuoted.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730451(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR287IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR287NotEqualsSum = false;

            // Condition 1: [iitr287] <> NULL
            condition1_IITR287IsNotNull = report.iitrParentDocument.IITR287 != null;

            // Condition 3 Sum: (SUM(ConditionalValue([incdtls489] = "012" AND [incdtls490] = "Business", [incdtls493], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Business" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr287] <> (SUM(ConditionalValue([incdtls489] = "012", [incdtls493], 0)))
            condition3_IITR287NotEqualsSum = report.iitrParentDocument.IITR287.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR287IsNotNull && condition2_INCDTLSExists && condition3_IITR287NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730451",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld where Australian business number not quoted is incorrect",
                    LongDescription = "The Net income/loss from business tax withheld where Australian business number not quoted amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"012\" (no ABN quoted) and Business income statement type is \"Business\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessABNNotQuoted.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730451" },
                        new ProcessMessageParameter() { Name = "IITR287", Value = report.iitrParentDocument.IITR287.ToString() },
                        new ProcessMessageParameter() { Name = "Sum of INCDTLS493 when the conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730451

        #region VR.ATO.IITR.730452

        /* VR.ATO.IITR.730452
            The Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "011" (foreign resident withholding) and Business income statement type is "Business" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR288 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR288 <> (Sum(ConditionalValue(^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR288 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR288 <> (Sum(ConditionalValue(^INCDTLS489 = '011' AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR288 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessForeignResident.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730452(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR288IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR288NotEqualsSum = false;

            // Condition 1: [iitr288] <> NULL
            condition1_IITR288IsNotNull = report.iitrParentDocument.IITR288 != null;

            // Condition 3 Sum: (SUM(ConditionalValue([incdtls489] = "011" AND [incdtls490] = "Business", [incdtls493], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "011" && tuple.INCDTLS490 == "Business" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr288] <> (SUM(ConditionalValue([incdtls489] = "011", [incdtls493], 0)))
            condition3_IITR288NotEqualsSum = report.iitrParentDocument.IITR288.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR288IsNotNull && condition2_INCDTLSExists && condition3_IITR288NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730452",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) is incorrect",
                    LongDescription = "The Net income/loss from business tax withheld - foreign resident withholding (excluding capital gains) amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"011\" (foreign resident withholding) and Business income statement type is \"Business\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessForeignResident.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730452" },
                        new ProcessMessageParameter() { Name = "IITR288", Value = report.iitrParentDocument.IITR288.ToString() },
                        new ProcessMessageParameter() { Name = "Sum of INCDTLS493 when the conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730452

        #region VR.ATO.IITR.730453

        /* VR.ATO.IITR.730453
            The Net income/loss from business tax withheld - labour hire or other specified payments amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "001" (labour hire) or "002" (other specified payments) and Business income statement type is "Business" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR289 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR289 <> (Sum(ConditionalValue((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR289 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR289 <> (Sum(ConditionalValue((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Business', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR289 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730453(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR289IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR289NotEqualsSum = false;

            // Condition 1: [iitr289] <> NULL
            condition1_IITR289IsNotNull = report.iitrParentDocument.IITR289 != null;

            // Condition 3 Sum: (SUM(ConditionalValue(([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Business", [incdtls493], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => (tuple.INCDTLS489 == "001" || tuple.INCDTLS489 == "002") && tuple.INCDTLS490 == "Business" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr289] <> (SUM(ConditionalValue(([incdtls489] = "001" OR [incdtls489] = "002"), [incdtls493], 0)))
            condition3_IITR289NotEqualsSum = report.iitrParentDocument.IITR289.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR289IsNotNull && condition2_INCDTLSExists && condition3_IITR289NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730453",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net income/loss from business tax withheld - labour hire or other specified payments is incorrect",
                    LongDescription = "The Net income/loss from business tax withheld - labour hire or other specified payments amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"001\" (labour hire) or \"002\" (other specified payments) and Business income statement type is \"Business\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730453" },
                        new ProcessMessageParameter() { Name = "IITR289", Value = report.iitrParentDocument.IITR289.ToString() },
                        new ProcessMessageParameter() { Name = "Sum of INCDTLS493 when the conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730453

        #region VR.ATO.IITR.730454

        /* VR.ATO.IITR.730454
            Credit for foreign resident capital gains withholding amounts must be equal to or greater than the sum of all credits for foreign resident capital gains withholding amounts from managed funds and trust distributions reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR497 <> NULL AND ^IITR497 < Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS410, ^INCDTLS438)) + Sum(^INCDTLS561)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR497 <> NULL AND ^IITR497 < Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS410, ^INCDTLS438)) + Sum(^INCDTLS561)

        Data Elements:
    
            ^IITR497 = RP:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS410 = INCDTLS410
    
            ^INCDTLS438 = INCDTLS438

            ^INCDTLS561 = INCDTLS561
        */

        public static ProcessMessageDocument VR_ATO_IITR_730454(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR497IsNotNull = false;
            decimal condition3_INCDTLS410Or438Sum = 0m;
            decimal condition3_INCDTLS561Sum = 0m;
            bool condition3_IITR497NotEqualsSum = false;

            // Condition 2: [iitr497] <> NULL
            condition2_IITR497IsNotNull = report.iitrParentDocument.IITR497 != null;

            // Condition 3 Sum: SUM(ConditionalValue([incdtls387] = 1, [incdtls410], [incdtls438])), 0
            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                condition3_INCDTLS410Or438Sum = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS410.GetValueOrDefault() : tuple.INCDTLS438.GetValueOrDefault());

            // Condition 3: Sum(^INCDTLS561)
            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                condition3_INCDTLS561Sum = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS561.GetValueOrDefault());

            // Condition 3: [iitr497] < SUM(ConditionalValue([incdtls387] = 1, [incdtls410], [incdtls438])) + Sum(^INCDTLS561)
            condition3_IITR497NotEqualsSum = report.iitrParentDocument.IITR497.GetValueOrDefault() < condition3_INCDTLS410Or438Sum + condition3_INCDTLS561Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            bool assertion = (condition1_INCDTLSExists && condition2_IITR497IsNotNull && condition3_IITR497NotEqualsSum);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731454",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Credit for foreign resident capital gains withholding amounts is incorrect",
                    LongDescription = @"Credit for foreign resident capital gains withholding amounts must be equal to or greater than the sum of all credits for foreign resident capital gains withholding amounts from managed funds and trust distributions reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730454" },
                        new ProcessMessageParameter() { Name = "IITR497", Value = report.iitrParentDocument.IITR497.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS410)", Value = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS410.GetValueOrDefault(): 0).ToString() : "0" },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS438)", Value = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 != 1 ? tuple.INCDTLS438.GetValueOrDefault(): 0).ToString() : "0" },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS561)", Value = condition3_INCDTLS561Sum.ToString() },
                        new ProcessMessageParameter() { Name = "Sum Total", Value = condition3_INCDTLS410Or438Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730454

        #region VR.ATO.IITR.730455

        /* VR.ATO.IITR.730455
            Where any credits for foreign resident capital gains withholding amounts from managed funds or trust distributions are provided in the attached Income Details schedule then Credit for foreign resident capital gains withholding amounts must be provided

        Legacy Rule Format:
            ^IITR497 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS410, ^INCDTLS410 <> NULL) OR AnyOccurrence(^INCDTLS438, ^INCDTLS438 <> NULL) OR AnyOccurrence(^INCDTLS561, ^INCDTLS561 <> NULL))

        Technical Business Rule Format:
            ^IITR497 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS410, ^INCDTLS410 <> NULL) OR AnyOccurrence(^INCDTLS438, ^INCDTLS438 <> NULL) OR AnyOccurrence(^INCDTLS561, ^INCDTLS561 <> NULL))

        Data Elements:

            ^IITR497 = RP:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount

            ^INCDTLS410 = INCDTLS410

            ^INCDTLS438 = INCDTLS438

            ^INCDTLS561 = INCDTLS561
        */

        public static ProcessMessageDocument VR_ATO_IITR_730455(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR497IsNull = false;
            bool condition2_INCDTLSExists = true;
            bool Condition3a_INCDTLS410AnyNotNull = false;
            bool Condition3b_INCDTLS438AnyNotNull = false;
            bool Condition3c_INCDTLS561AnyNotNull = false;

            // Condition 1: [iitr497] = NULL
            condition1_IITR497IsNull = report.iitrParentDocument.IITR497 == null;

            // Condition 3: (ANY OCCURRENCE OF([incdtls410]) <> NULL) OR (ANY OCCURRENCE OF([incdtls438]) <> NULL)
            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition3a_INCDTLS410AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS410 != null);
                Condition3b_INCDTLS438AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS438 != null);
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                Condition3c_INCDTLS561AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS561 != null);

            bool assertion = (condition1_IITR497IsNull && condition2_INCDTLSExists && (Condition3a_INCDTLS410AnyNotNull || Condition3b_INCDTLS438AnyNotNull || Condition3c_INCDTLS561AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731455",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Credit for foreign resident capital gains withholding amounts must be provided",
                    LongDescription = @"Where any credits for foreign resident capital gains withholding amounts from managed funds or trust distributions are provided in the attached Income Details schedule then Credit for foreign resident capital gains withholding amounts must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730455" },
                        new ProcessMessageParameter() { Name = "IITR497", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS410 <> NULL", Value = Condition3a_INCDTLS410AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS438 <> NULL", Value = Condition3b_INCDTLS438AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS561 <> NULL", Value = Condition3c_INCDTLS561AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730455

        #region VR.ATO.IITR.730292

        /* VR.ATO.IITR.730292
            Other refundable tax offsets must not be less than the sum of all exploration credit amounts from managed funds, dividends, or trust distributions reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR395 <> NULL AND ^IITR395 < RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS417, ^INCDTLS445)) + Sum(ConditionalValue(^INCDTLS347 = 1, ^INCDTLS375, ^INCDTLS382)) + Sum(^INCDTLS547), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR395 <> NULL AND ^IITR395 < RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS417, ^INCDTLS445)) + Sum(ConditionalValue(^INCDTLS347 = 1, ^INCDTLS375, ^INCDTLS382)) + Sum(^INCDTLS547), 0)

        Data Elements:
    
            ^IITR395 = RP:IncomeTax.TaxOffsetRefundableOther.Amount
    
            ^INCDTLS347 = INCDTLS347
    
            ^INCDTLS375 = INCDTLS375
    
            ^INCDTLS382 = INCDTLS382
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS417 = INCDTLS417
    
            ^INCDTLS445 = INCDTLS445

            ^INCDTLS547 = INCDTLS547
        */

        public static ProcessMessageDocument VR_ATO_IITR_730292(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR395IsNotNull = false;
            decimal condition3A_INCDTLS417Or445Sum = 0m;
            decimal condition3B_INCDTLS375Or382Sum = 0m;
            decimal condition3C_INCDTLS547Sum = 0m;
            decimal condition3_INCDTLSTotalSum = 0m;
            bool condition3_IITR395IsLessThanSum = false;

            // Condition 2: [iitr395] <> NULL
            condition2_IITR395IsNotNull = report.iitrParentDocument.IITR395 != null;

            // Condition 3 A Sum: SUM(ConditionalValue([incdtls387] = 1, [incdtls417], [incdtls445]))
            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                condition3A_INCDTLS417Or445Sum = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS417.GetValueOrDefault() : tuple.INCDTLS445.GetValueOrDefault());

            // Condition 3 B Sum: SUM(ConditionalValue([incdtls347] = 1, [incdtls375], [incdtls382]))
            if (incdtlschilddoc.Rp_DividendsCollection != null)
                condition3B_INCDTLS375Or382Sum = incdtlschilddoc.Rp_DividendsCollection.Sum(tuple => tuple.INCDTLS347 == 1 ? tuple.INCDTLS375.GetValueOrDefault() : tuple.INCDTLS382.GetValueOrDefault());

            // Sum(^INCDTLS547)
            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                condition3C_INCDTLS547Sum = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS547.GetValueOrDefault());

            // Condition 3 Total Sum: RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS417, ^INCDTLS445)) + Sum(ConditionalValue(^INCDTLS347 = 1, ^INCDTLS375, ^INCDTLS382)) + Sum(^INCDTLS547), 0)
            condition3_INCDTLSTotalSum = Math.Truncate(condition3A_INCDTLS417Or445Sum + condition3B_INCDTLS375Or382Sum + condition3C_INCDTLS547Sum);

            // Condition 3: [iitr395] < RoundDown(SUM(ConditionalValue([incdtls387] = 1, [incdtls417], [incdtls445])) + SUM(ConditionalValue([incdtls347] = 1, [incdtls375], [incdtls382])), 0)
            condition3_IITR395IsLessThanSum = report.iitrParentDocument.IITR395.GetValueOrDefault() < condition3_INCDTLSTotalSum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR395IsNotNull && condition3_IITR395IsLessThanSum);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731292",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other refundable tax offsets is incorrect",
                    LongDescription = "Other refundable tax offsets must not be less than the sum of all exploration credit amounts from managed funds, dividends, or trust distributions reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.TaxOffsetRefundableOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730292" },
                        new ProcessMessageParameter() { Name = "IITR395", Value = report.iitrParentDocument.IITR395.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS417/445 Sum", Value = condition3A_INCDTLS417Or445Sum.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS375/382 Sum", Value = condition3B_INCDTLS375Or382Sum.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown Total Sum", Value = condition3_INCDTLSTotalSum.ToString() },
                        new ProcessMessageParameter() { Name = "IITR395 != Totals", Value = condition3_IITR395IsLessThanSum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730292

        #region VR.ATO.IITR.730293

        /* VR.ATO.IITR.730293
            Where any exploration credit amounts from managed funds, dividends, or trust distributions are provided in the attached Income Details schedule, then Other refundable tax offsets must be provided

        Legacy Rule Format:
            ^IITR395 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS417, ^INCDTLS417 <> NULL) OR AnyOccurrence(^INCDTLS445, ^INCDTLS445 <> NULL) OR AnyOccurrence(^INCDTLS375, ^INCDTLS375 <> NULL) OR AnyOccurrence(^INCDTLS382, ^INCDTLS382 <> NULL) OR AnyOccurrence(^INCDTLS547, ^INCDTLS547 <> NULL))

        Technical Business Rule Format:
            ^IITR395 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS417, ^INCDTLS417 <> NULL) OR AnyOccurrence(^INCDTLS445, ^INCDTLS445 <> NULL) OR AnyOccurrence(^INCDTLS375, ^INCDTLS375 <> NULL) OR AnyOccurrence(^INCDTLS382, ^INCDTLS382 <> NULL) OR AnyOccurrence(^INCDTLS547, ^INCDTLS547 <> NULL))

        Data Elements:
    
            ^IITR395 = RP:IncomeTax.TaxOffsetRefundableOther.Amount
    
            ^INCDTLS375 = INCDTLS375
    
            ^INCDTLS382 = INCDTLS382
    
            ^INCDTLS417 = INCDTLS417
    
            ^INCDTLS445 = INCDTLS445

            ^INCDTLS547 = INCDTLS547
        */

        public static ProcessMessageDocument VR_ATO_IITR_730293(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR395IsNull = false;
            bool condition2_INCDTLSExists = true;
            bool Condition3a_INCDTLS417AnyNotNull = false;
            bool Condition3b_INCDTLS445AnyNotNull = false;
            bool Condition3c_INCDTLS375AnyNotNull = false;
            bool Condition3d_INCDTLS382AnyNotNull = false;
            bool Condition3e_INCDTLS547AnyNotNull = false;

            // Condition 1: [iitr395] = NULL
            condition1_IITR395IsNull = report.iitrParentDocument.IITR395 == null;

            // Condition 3: (AnyOccurrence(^INCDTLS417, ^INCDTLS417 <> NULL) OR AnyOccurrence(^INCDTLS445, ^INCDTLS445 <> NULL) OR AnyOccurrence(^INCDTLS375, ^INCDTLS375 <> NULL) OR AnyOccurrence(^INCDTLS382, ^INCDTLS382 <> NULL) OR AnyOccurrence(^INCDTLS547, ^INCDTLS547 <> NULL))
            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition3a_INCDTLS417AnyNotNull = (incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS417 != null));
                Condition3b_INCDTLS445AnyNotNull = (incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS445 != null));
            }

            if (incdtlschilddoc.Rp_DividendsCollection != null)
            {
                Condition3c_INCDTLS375AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS375 != null));
                Condition3d_INCDTLS382AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS382 != null));
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                Condition3e_INCDTLS547AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS547 != null);

            assertion = (condition1_IITR395IsNull && condition2_INCDTLSExists && (Condition3a_INCDTLS417AnyNotNull || Condition3b_INCDTLS445AnyNotNull || Condition3c_INCDTLS375AnyNotNull || Condition3d_INCDTLS382AnyNotNull || Condition3e_INCDTLS547AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731293",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other refundable tax offsets must be provided",
                    LongDescription = @"Where any exploration credit amounts from managed funds, dividends, or trust distributions are provided in the attached Income Details schedule, then Other refundable tax offsets must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.TaxOffsetRefundableOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730293" },
                        new ProcessMessageParameter() { Name = "IITR395", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS417 <> NULL", Value = Condition3a_INCDTLS417AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS445 <> NULL", Value = Condition3b_INCDTLS445AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS375 <> NULL", Value = Condition3c_INCDTLS375AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS382 <> NULL", Value = Condition3d_INCDTLS382AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS547 <> NULL", Value = Condition3e_INCDTLS547AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730293

        #region VR.ATO.IITR.730294

        /* VR.ATO.IITR.730294
            Where any exploration credit amounts from managed funds or dividends are provided in the attached Income Details schedule, then the Other refundable tax offsets code must be set to "ExplorationCreditRefundableTaxOffset" or "MultipleTaxOffsets"

        Legacy Rule Format:
            (NotInSet(^IITR396, '"MultipleTaxOffsets", "ExplorationCreditRefundableTaxOffset"')) AND CountDocument('INCDTLS') = 1 AND ((AnyOccurrence(^INCDTLS417, ^INCDTLS417 <> NULL)) OR (AnyOccurrence(^INCDTLS445, ^INCDTLS445 <> NULL)) OR (AnyOccurrence(^INCDTLS375, ^INCDTLS375 <> NULL)) OR (AnyOccurrence(^INCDTLS382, ^INCDTLS382 <> NULL)))

        Technical Business Rule Format:
            (NotInSet(^IITR396, '"MultipleTaxOffsets", "ExplorationCreditRefundableTaxOffset"')) AND CountDocument('INCDTLS') = 1 AND ((AnyOccurrence(^INCDTLS417, ^INCDTLS417 <> NULL)) OR (AnyOccurrence(^INCDTLS445, ^INCDTLS445 <> NULL)) OR (AnyOccurrence(^INCDTLS375, ^INCDTLS375 <> NULL)) OR (AnyOccurrence(^INCDTLS382, ^INCDTLS382 <> NULL)))

        Data Elements:
    
            ^IITR396 = RP:IncomeTax.TaxOffsetRefundableOther.Code
    
            ^INCDTLS375 = INCDTLS375
    
            ^INCDTLS382 = INCDTLS382
    
            ^INCDTLS417 = INCDTLS417
    
            ^INCDTLS445 = INCDTLS445
        */

        public static ProcessMessageDocument VR_ATO_IITR_730294(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_IITR396IsNotInSet = false;
            bool condition2_INCDTLSExists = true;
            bool Condition3a_INCDTLS417AnyNotNull = false;
            bool Condition3b_INCDTLS445AnyNotNull = false;
            bool Condition3c_INCDTLS375AnyNotNull = false;
            bool Condition3d_INCDTLS382AnyNotNull = false;

            // Condition 1: ([iitr396] <> SET("MultipleTaxOffsets", "ExplorationCreditRefundableTaxOffset"))
            condition1_IITR396IsNotInSet = !(IsMatch(report.iitrParentDocument.IITR396, @"^(MultipleTaxOffsets|ExplorationCreditRefundableTaxOffset)$", RegexOptions.IgnoreCase));

            // Condition 3: ((ANY OCCURRENCE OF([incdtls417]) <> NULL) OR (ANY OCCURRENCE OF([incdtls445]) <> NULL) OR (ANY OCCURRENCE OF([incdtls375]) <> NULL) OR (ANY OCCURRENCE OF([incdtls382]) <> NULL))
            if (incdtlschilddoc.Rp_ManagedFundsCollectionExists)
            {
                Condition3a_INCDTLS417AnyNotNull = (incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS417 != null));
                Condition3b_INCDTLS445AnyNotNull = (incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS445 != null));
            }

            if (incdtlschilddoc.Rp_DividendsCollectionExists)
            {
                Condition3c_INCDTLS375AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS375 != null));
                Condition3d_INCDTLS382AnyNotNull = (incdtlschilddoc.Rp_DividendsCollection.Any(tuple => tuple.INCDTLS382 != null));
            }

            assertion = (condition1_IITR396IsNotInSet && condition2_INCDTLSExists && (Condition3a_INCDTLS417AnyNotNull || Condition3b_INCDTLS445AnyNotNull || Condition3c_INCDTLS375AnyNotNull || Condition3d_INCDTLS382AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730294",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other refundable tax offsets code is incorrect",
                    LongDescription = "Where any exploration credit amounts from managed funds or dividends are provided in the attached Income Details schedule, then the Other refundable tax offsets code must be set to \"ExplorationCreditRefundableTaxOffset\" or \"MultipleTaxOffsets\"",
                    Location = "/xbrli:xbrl/tns:IncomeTax.TaxOffsetRefundableOther.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730294" },
                        new ProcessMessageParameter() { Name = "([iitr396] <> SET(\"MultipleTaxOffsets\", \"ExplorationCreditRefundableTaxOffset\"))", Value = condition1_IITR396IsNotInSet.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS417]) <> NULL", Value = Condition3a_INCDTLS417AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS445]) <> NULL", Value = Condition3b_INCDTLS445AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS375]) <> NULL", Value = Condition3c_INCDTLS375AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS382]) <> NULL", Value = Condition3d_INCDTLS382AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730294

        #region VR.ATO.IITR.730295

        /* VR.ATO.IITR.730295
            The Other category 4 income must equal the sum of Other income amounts where Other income type is either "Special professional income", "Financial investments", "Other", plus the sum of Australian government benefit taxable amount when Australia benefit type is "Special", plus other income from managed fund amounts reported for the individual, less the sum of Deductible expenses for special professional taxable income in the attached Income Details schedule

        Legacy Rule Format:
            (^IITR618 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR618 <> (ConditionalValue(((RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Special Professional income", "Financial investments", "Other"'), ^INCDTLS451, 0)) - Sum(^INCDTLS454), 0)) < 0), 0, (RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Special Professional income", "Financial investments", "Other"'), ^INCDTLS451, 0)) - Sum(^INCDTLS454), 0))) + RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Special', incdtls128, 0)), 0) + RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS401, ^INCDTLS431)), 0)))

        Technical Business Rule Format:
            (^IITR618 <> NULL) AND (CountDocument('INCDTLS') = 1) AND (^IITR618 <> (ConditionalValue(((RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Special Professional income", "Financial investments", "Other"'), ^INCDTLS451, 0)) - Sum(^INCDTLS454), 0)) < 0), 0, (RoundDown(Sum(ConditionalValue(InSet(^INCDTLS449, '"Special Professional income", "Financial investments", "Other"'), ^INCDTLS451, 0)) - Sum(^INCDTLS454), 0))) + RoundDown(Sum(ConditionalValue(^INCDTLS126 = 'Special', incdtls128, 0)), 0) + RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS401, ^INCDTLS431)), 0)))

        Data Elements:
    
            ^IITR618 = RP:IncomeTax.IncomeCategoryMiscellaneousOther.Amount
    
            ^INCDTLS126 = INCDTLS126
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS401 = INCDTLS401
    
            ^INCDTLS431 = INCDTLS431
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
    
            ^INCDTLS454 = INCDTLS454
        */

        public static ProcessMessageDocument VR_ATO_IITR_730295(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            decimal incdtls451Condition = incdtlschilddoc.Rp_IncomeOtherCollection != null
                ? incdtlschilddoc.Rp_IncomeOtherCollection.Sum(
                    tuple => IsMatch(tuple.INCDTLS449, @"^(Special professional income|Financial investments|Other)$") ? tuple.INCDTLS451.GetValueOrDefault() : 0
                ) : 0;
            decimal incdtls454Condition = incdtlschilddoc.Rp_IncomeOtherCollection != null
                ? incdtlschilddoc.Rp_IncomeOtherCollection.Sum(tuple => tuple.INCDTLS454.GetValueOrDefault()) : 0;
            decimal incdtls451Calculation = Math.Floor(incdtls451Condition - incdtls454Condition);
            decimal incdtls128Calculation = incdtlschilddoc.Rp_IncomeCollection != null
                ? Math.Floor(incdtlschilddoc.Rp_IncomeCollection.Sum(
                    income => income.Rp_Income_GovernmentBenefitCollection != null ? income.Rp_Income_GovernmentBenefitCollection.Sum(
                        tuple => !string.IsNullOrWhiteSpace(tuple.INCDTLS126) && tuple.INCDTLS126.Equals("Special") ? tuple.INCDTLS128.GetValueOrDefault() : 0
                    ) : 0
                )) : 0;
            decimal incdtls401_431Calculation = incdtlschilddoc.Rp_ManagedFundsCollection != null
                ? Math.Floor(incdtlschilddoc.Rp_ManagedFundsCollection.Sum(
                    tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 ? tuple.INCDTLS401.GetValueOrDefault() : tuple.INCDTLS431.GetValueOrDefault())
                ) : 0;

            bool assertion = report.iitrParentDocument.IITR618 != null && incdtlschilddoc != null && report.iitrParentDocument.IITR618.GetValueOrDefault() != (
                (incdtls451Calculation < 0 ? 0 : incdtls451Calculation) + incdtls128Calculation + incdtls401_431Calculation
            );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730295",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other category 4 income is incorrect",
                    LongDescription = @"The Other category 4 income must equal the sum of Other income amounts where Other income type is either ""Special professional income"", ""Financial investments"", ""Other"", plus the sum of Australian government benefit taxable amount when Australia benefit type is ""Special"", plus other income from managed fund amounts reported for the individual, less the sum of Deductible expenses for special professional taxable income in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategoryMiscellaneousOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730295" },
                        new ProcessMessageParameter() { Name = "IITR618", Value = report.iitrParentDocument.IITR618.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS451)", Value = incdtls451Condition.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS454)", Value = incdtls454Condition.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS128)", Value = incdtls128Calculation.ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS401, INCDTLS431)", Value = incdtls401_431Calculation.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730295

        #region VR.ATO.IITR.730296

        /* VR.ATO.IITR.730296
            Where any Other income amounts with Other income type set to either "Special professional income", "Financial investments", "Other", or where any Australian government benefit taxable amount when Australian government benefit type is "Special", or where any Deductible expenses for special professional taxable income amounts, or Total other income from managed fund, or Your share of other income from managed fund are present in the attached Income details schedule, the amount of Other category 4 income must be provided

        Legacy Rule Format:
            ((^IITR618 = NULL) AND (CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE(InSet(^INCDTLS449, '"Special professional income", "Financial investments", "Other"'))) OR ((AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE([incdtls126 = 'Special']))) OR (AnyOccurrence(^INCDTLS454, ^INCDTLS454 <> NULL)) OR (AnyOccurrence(^INCDTLS401, ^INCDTLS401 <> NULL)) OR (AnyOccurrence(^INCDTLS431, ^INCDTLS431 <> NULL))))

        Technical Business Rule Format:
            ((^IITR618 = NULL) AND (CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS451, ^INCDTLS451 <> NULL) WHERE(InSet(^INCDTLS449, '"Special professional income", "Financial investments", "Other"'))) OR ((AnyOccurrence(^INCDTLS128, ^INCDTLS128 <> NULL) WHERE([incdtls126 = 'Special']))) OR (AnyOccurrence(^INCDTLS454, ^INCDTLS454 <> NULL)) OR (AnyOccurrence(^INCDTLS401, ^INCDTLS401 <> NULL)) OR (AnyOccurrence(^INCDTLS431, ^INCDTLS431 <> NULL))))

        Data Elements:
    
            ^IITR618 = RP:IncomeTax.IncomeCategoryMiscellaneousOther.Amount
    
            ^INCDTLS128 = INCDTLS128
    
            ^INCDTLS401 = INCDTLS401
    
            ^INCDTLS431 = INCDTLS431
    
            ^INCDTLS449 = INCDTLS449
    
            ^INCDTLS451 = INCDTLS451
    
            ^INCDTLS454 = INCDTLS454
        */

        public static ProcessMessageDocument VR_ATO_IITR_730296(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            bool incdtls451Condition = incdtlschilddoc.Rp_IncomeOtherCollection != null
                ? incdtlschilddoc.Rp_IncomeOtherCollection.Exists(
                    tuple => IsMatch(tuple.INCDTLS449, @"^(Special professional income|Financial investments|Other)$") && tuple.INCDTLS451 != null
                ) : false;
            bool incdtls454Condition = incdtlschilddoc.Rp_IncomeOtherCollection != null
                ? incdtlschilddoc.Rp_IncomeOtherCollection.Exists(tuple => tuple.INCDTLS454 != null) : false;
            bool incdtls128Condition = incdtlschilddoc.Rp_IncomeCollection != null
                ? incdtlschilddoc.Rp_IncomeCollection.Exists(income => income.Rp_Income_GovernmentBenefitCollection != null
                    ? income.Rp_Income_GovernmentBenefitCollection.Exists(
                        tuple => !string.IsNullOrWhiteSpace(tuple.INCDTLS126) && tuple.INCDTLS126.Equals("Special") && tuple.INCDTLS128 != null
                    ) : false
                ) : false;
            bool incdtls401Condition = incdtlschilddoc.Rp_ManagedFundsCollection != null
                ? incdtlschilddoc.Rp_ManagedFundsCollection.Exists(tuple => tuple.INCDTLS401 != null) : false;
            bool incdtls431Condition = incdtlschilddoc.Rp_ManagedFundsCollection != null
                ? incdtlschilddoc.Rp_ManagedFundsCollection.Exists(tuple => tuple.INCDTLS431 != null) : false;

            bool assertion = report.iitrParentDocument.IITR618 == null && incdtlschilddoc != null && (
                incdtls451Condition || incdtls128Condition || incdtls454Condition || incdtls401Condition || incdtls431Condition
            );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730296",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other category 4 income must be provided",
                    LongDescription = @"Where any Other income amounts with Other income type set to either ""Special professional income"", ""Financial investments"", ""Other"", or where any Australian government benefit taxable amount when Australian government benefit type is ""Special"", or where any Deductible expenses for special professional taxable income amounts, or Total other income from managed fund, or Your share of other income from managed fund are present in the attached Income details schedule, the amount of Other category 4 income must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.IncomeCategoryMiscellaneousOther.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730296" },
                        new ProcessMessageParameter() { Name = "IITR618", Value = report.iitrParentDocument.IITR618.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS451 <> NULL", Value = incdtls451Condition.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS128 <> NULL", Value = incdtls128Condition.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS454 <> NULL", Value = incdtls454Condition.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS401 <> NULL", Value = incdtls401Condition.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS431 <> NULL", Value = incdtls431Condition.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730296

        #region VR.ATO.IITR.730456

        /* VR.ATO.IITR.730456
            Total current year capital gains must be greater than or equal to the sum of all current year capital gains from managed funds and trust distributions reported for the individual in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR312 <> NULL AND ^IITR312 < RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS395, ^INCDTLS425)) + Sum(^INCDTLS552), 0)

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR312 <> NULL AND ^IITR312 < RoundDown(Sum(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS395, ^INCDTLS425)) + Sum(^INCDTLS552), 0)

        Data Elements:
    
            ^IITR312 = RP:Capital.Gains.Total.Amount
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS395 = INCDTLS395
    
            ^INCDTLS425 = INCDTLS425

            ^INCDTLS553 = INCDTLS553
        */

        public static ProcessMessageDocument VR_ATO_IITR_730456(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR312IsNotNull = false;
            decimal condition3_INCDTLS395Or425Sum = 0m;
            decimal condition3_INCDTLS552 = 0m;
            bool condition3_IITR312NotEqualsSum = false;

            // Condition 2: ^IITR312 <> NULL
            condition2_IITR312IsNotNull = report.iitrParentDocument.IITR312 != null;

            // Condition 3 Sum: SUM(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS395, ^INCDTLS425))
            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
                condition3_INCDTLS395Or425Sum = incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS395.GetValueOrDefault() : tuple.INCDTLS425.GetValueOrDefault());

            // Condition 3 Sum: SUM(^INCDTLS552)
            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                condition3_INCDTLS552 = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS552.GetValueOrDefault());

            // Condition 3: ^IITR312 < RoundDown(SUM(ConditionalValue(^INCDTLS387 = 1, ^INCDTLS395, ^INCDTLS425)) + SUM(^INCDTLS552), 0)
            condition3_IITR312NotEqualsSum = report.iitrParentDocument.IITR312.GetValueOrDefault() < Math.Truncate(condition3_INCDTLS395Or425Sum + condition3_INCDTLS552);

            // Rule assertion: condition1 AND condition2 AND condition3
            bool assertion = (condition1_INCDTLSExists && condition2_IITR312IsNotNull && condition3_IITR312NotEqualsSum);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731456",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total current year capital gains is incorrect",
                    LongDescription = @"Total current year capital gains must be greater than or equal to the sum of all current year capital gains from managed funds and trust distributions reported for the individual in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730456" },
                        new ProcessMessageParameter() { Name = "IITR312", Value = report.iitrParentDocument.IITR312.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS395)", Value = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 == 1 ? tuple.INCDTLS395.GetValueOrDefault(): 0).ToString() : "0" },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS425)", Value = incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.Sum(tuple => tuple.INCDTLS387 != 1 ? tuple.INCDTLS425.GetValueOrDefault(): 0).ToString() : "0" },
                        new ProcessMessageParameter() { Name = "SUM(INCDTLS552)", Value = condition3_INCDTLS552.ToString() },
                        new ProcessMessageParameter() { Name = "Sum Total", Value = Math.Truncate(condition3_INCDTLS395Or425Sum + condition3_INCDTLS552).ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730456

        #region VR.ATO.IITR.730457

        /* VR.ATO.IITR.730457
            Where any current year capital gains from managed funds or trust distributions are provided in the attached Income Details schedule, then Total current year capital gains must be provided

        Legacy Rule Format:
            ^IITR312 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS395, ^INCDTLS395 <> NULL) OR AnyOccurrence(^INCDTLS425, ^INCDTLS425 <> NULL) OR AnyOccurrence(^INCDTLS552, ^INCDTLS552 <> NULL))

        Technical Business Rule Format:
            ^IITR312 = NULL AND CountDocument('INCDTLS') = 1 AND (AnyOccurrence(^INCDTLS395, ^INCDTLS395 <> NULL) OR AnyOccurrence(^INCDTLS425, ^INCDTLS425 <> NULL) OR AnyOccurrence(^INCDTLS552, ^INCDTLS552 <> NULL))

        Data Elements:
    
            ^IITR312 = RP:Capital.Gains.Total.Amount
    
            ^INCDTLS395 = INCDTLS395
    
            ^INCDTLS425 = INCDTLS425

            ^INCDTLS553 = INCDTLS553
        */

        public static ProcessMessageDocument VR_ATO_IITR_730457(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 2: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3a_INCDTLS395AnyNotNull = false;
            bool Condition3b_INCDTLS425AnyNotNull = false;
            bool Condition3c_INCDTLS552AnyNotNull = false;

            if (incdtlschilddoc.Rp_ManagedFundsCollection != null)
            {
                Condition3a_INCDTLS395AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS395 != null);
                Condition3b_INCDTLS425AnyNotNull = incdtlschilddoc.Rp_ManagedFundsCollection.Any(tuple => tuple.INCDTLS425 != null);
            }

            if (incdtlschilddoc.Rp_TrustIncomeCollection != null)
                Condition3c_INCDTLS552AnyNotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS552 != null);

            bool assertion = (report.iitrParentDocument.IITR312 == null && (Condition3a_INCDTLS395AnyNotNull || Condition3b_INCDTLS425AnyNotNull || Condition3c_INCDTLS552AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.731457",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Total current year capital gains must be provided",
                    LongDescription = "Where any current year capital gains from managed funds or trust distributions are provided in the attached Income Details schedule, then Total current year capital gains must be provided",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730457" },
                        new ProcessMessageParameter() { Name = "IITR312", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS395 <> NULL", Value = Condition3a_INCDTLS395AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS425 <> NULL", Value = Condition3b_INCDTLS425AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS552 <> NULL", Value = Condition3c_INCDTLS552AnyNotNull.ToString() }
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730457

        #region VR.ATO.IITR.300105

        /* VR.ATO.IITR.300105
            Occupation code and occupation description must be present in the return where Salary or wages payment summary or Foreign employment income payment summary is present or where there is a claim for a work related expense deduction.

        Legacy Rule Format:
            (^IITR58 = BLANK OR ^IITR59 = BLANK) AND (((CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS309, ^INCDTLS309 <> NULL)) OR (AnyOccurrence(^INCDTLS160, ^INCDTLS160 <> NULL)))) OR (^IITR134 > 0) OR (^IITR136 > 0) OR (^IITR137 > 0) OR (^IITR139 > 0) OR (^IITR141 > 0))

        Technical Business Rule Format:
            (^IITR58 = BLANK OR ^IITR59 = BLANK) AND (((CountDocument('INCDTLS') = 1) AND ((AnyOccurrence(^INCDTLS309, ^INCDTLS309 <> NULL)) OR (AnyOccurrence(^INCDTLS160, ^INCDTLS160 <> NULL)))) OR (^IITR134 > 0) OR (^IITR136 > 0) OR (^IITR137 > 0) OR (^IITR139 > 0) OR (^IITR141 > 0))

        Data Elements:
    
            ^IITR58 = RP:PersonDemographicDetails.Occupation.Description
    
            ^IITR59 = RP:PersonDemographicDetails.Occupation.Code
    
            ^IITR134 = RP:IncomeTax.Deduction.Car.Amount
    
            ^IITR136 = RP:IncomeTax.Deduction.Travel.Amount
    
            ^IITR137 = RP:IncomeTax.Deduction.Clothing.Amount
    
            ^IITR139 = RP:IncomeTax.Deduction.EducationNet.Amount
    
            ^IITR141 = RP:IncomeTax.Deduction.WorkRelatedOther.Amount
    
            ^INCDTLS160 = INCDTLS160
    
            ^INCDTLS309 = INCDTLS309
        */

        public static ProcessMessageDocument VR_ATO_IITR_300105(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool condition1_IITR58OrIITR59NullOrBlank = (string.IsNullOrWhiteSpace(report.iitrParentDocument.IITR58) || string.IsNullOrWhiteSpace(report.iitrParentDocument.IITR59) );
            bool condition2_INCDTLS309OrINCDTLS160_AnyNotNull = false;
            bool condition2a_INCDTLS309AnyNotNull = false;
            bool condition2b_INCDTLS160AnyNotNull = false;
            bool conditon3_workRelatedExpensesDeductionClaim = (report.iitrParentDocument.IITR134.GetValueOrDefault() > 0 || report.iitrParentDocument.IITR136.GetValueOrDefault() > 0 || report.iitrParentDocument.IITR137.GetValueOrDefault() > 0 || report.iitrParentDocument.IITR139.GetValueOrDefault() > 0 || report.iitrParentDocument.IITR141.GetValueOrDefault() > 0);

            // Check if INCDTLS309 or INCDTLS160 Tuples are provided (Exist)
            if (incdtlschilddoc != null)
            {
                if (incdtlschilddoc.Rp_IncomeCollectionExists)
                {
                    condition2a_INCDTLS309AnyNotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.Rp_Income_OrganisationNameDetails_SalaryOrWagesCollectionExists);
                    condition2b_INCDTLS160AnyNotNull = incdtlschilddoc.Rp_IncomeCollection.Any(tuple => tuple.Rp_Income_OrganisationNameDetails_ForeignEmploymentCollectionExists);
                    condition2_INCDTLS309OrINCDTLS160_AnyNotNull = condition2a_INCDTLS309AnyNotNull || condition2b_INCDTLS160AnyNotNull;
                }
            }

            assertion = (condition1_IITR58OrIITR59NullOrBlank && (condition2_INCDTLS309OrINCDTLS160_AnyNotNull || conditon3_workRelatedExpensesDeductionClaim));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.301105",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Main salary or wage occupation description and Occupation code must be provided",
                    LongDescription = @"When Salary or wages payment summary or Foreign employment income payment summary is present or positive amounts for 'Work related car expenses', 'Work related travel expenses', 'Work related uniform, occupation specific or protective clothing, laundry and dry cleaning expenses', 'Work related self-education expenses' or 'Other work related expenses' are present, the 'Main salary or wage occupation description' and 'Occupation code' must be provided",
                    Location = "/xbrli:xbrl/tns:PersonDemographicDetails.Occupation.Description[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.300105" },
                        new ProcessMessageParameter() { Name = "IITR58", Value = GetValueOrEmpty(report.iitrParentDocument.IITR58) },
                        new ProcessMessageParameter() { Name = "IITR59", Value = GetValueOrEmpty(report.iitrParentDocument.IITR59) },
                        new ProcessMessageParameter() { Name = "IITR134", Value = GetValueOrEmpty(report.iitrParentDocument.IITR134) },
                        new ProcessMessageParameter() { Name = "IITR136", Value = GetValueOrEmpty(report.iitrParentDocument.IITR136) },
                        new ProcessMessageParameter() { Name = "IITR137", Value = GetValueOrEmpty(report.iitrParentDocument.IITR137) },
                        new ProcessMessageParameter() { Name = "IITR139", Value = GetValueOrEmpty(report.iitrParentDocument.IITR139) },
                        new ProcessMessageParameter() { Name = "IITR141", Value = GetValueOrEmpty(report.iitrParentDocument.IITR141) },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls309]) <> NULL", Value = condition2a_INCDTLS309AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls160]) <> NULL", Value = condition2b_INCDTLS160AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "(ANY OCCURRENCE OF([incdtls309]) <> NULL) OR (ANY OCCURRENCE OF([incdtls160]) <> NULL)", Value = condition2_INCDTLS309OrINCDTLS160_AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.300105

        #region VR.ATO.IITR.300106

        /* VR.ATO.IITR.300106
            An occupation code or occupation description has been entered with no corresponding Salary or wages payment summary or Foreign employment income payment summary or Work related expense deductions.

        Legacy Rule Format:
            (^IITR58 <> BLANK OR ^IITR59 <> BLANK) AND ((CountDocument('INCDTLS') = 0) OR ((CountDocument('INCDTLS') = 1) AND (AllOccurrences(^INCDTLS309, ^INCDTLS309 = NULL)) AND (AllOccurrences(^INCDTLS160, ^INCDTLS160 = NULL)))) AND (^IITR134 = NULL OR ^IITR134 = 0) AND (^IITR136 = NULL OR ^IITR136 = 0) AND (^IITR137 = NULL OR ^IITR137 = 0) AND (^IITR139 = NULL OR ^IITR139 = 0) AND (^IITR141 = NULL OR ^IITR141 = 0)

        Technical Business Rule Format:
            (^IITR58 <> BLANK OR ^IITR59 <> BLANK) AND ((CountDocument('INCDTLS') = 0) OR ((CountDocument('INCDTLS') = 1) AND (AllOccurrences(^INCDTLS309, ^INCDTLS309 = NULL)) AND (AllOccurrences(^INCDTLS160, ^INCDTLS160 = NULL)))) AND (^IITR134 = NULL OR ^IITR134 = 0) AND (^IITR136 = NULL OR ^IITR136 = 0) AND (^IITR137 = NULL OR ^IITR137 = 0) AND (^IITR139 = NULL OR ^IITR139 = 0) AND (^IITR141 = NULL OR ^IITR141 = 0)

        Data Elements:
    
            ^IITR58 = RP:PersonDemographicDetails.Occupation.Description
    
            ^IITR59 = RP:PersonDemographicDetails.Occupation.Code
    
            ^IITR134 = RP:IncomeTax.Deduction.Car.Amount
    
            ^IITR136 = RP:IncomeTax.Deduction.Travel.Amount
    
            ^IITR137 = RP:IncomeTax.Deduction.Clothing.Amount
    
            ^IITR139 = RP:IncomeTax.Deduction.EducationNet.Amount
    
            ^IITR141 = RP:IncomeTax.Deduction.WorkRelatedOther.Amount
    
            ^INCDTLS160 = INCDTLS160
    
            ^INCDTLS309 = INCDTLS309
        */

        public static ProcessMessageDocument VR_ATO_IITR_300106(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool condition1_IITR58OrIITR59NotNullOrBlank = (string.IsNullOrWhiteSpace(report.iitrParentDocument.IITR58) != true || string.IsNullOrWhiteSpace(report.iitrParentDocument.IITR59) != true);
            bool condition2_INCDTLS309OrINCDTLS160NotProvided = false;
            bool condition2a_INCDTLS309AllNotProvided = false;
            bool condition2b_INCDTLS160AllNotProvided = false;
            bool condition3_WREDeductonsNullOrZero = (report.iitrParentDocument.IITR134.GetValueOrDefault() == 0) && (report.iitrParentDocument.IITR136.GetValueOrDefault() == 0) && (report.iitrParentDocument.IITR137.GetValueOrDefault() == 0) && (report.iitrParentDocument.IITR139.GetValueOrDefault() == 0) && (report.iitrParentDocument.IITR141.GetValueOrDefault() == 0);

            // Check if INCDTLS309 or INCDTLS160 Tuples are provided (Exist)
            if (incdtlschilddoc != null)
            {
                if (incdtlschilddoc.Rp_IncomeCollectionExists)
                {
                    condition2a_INCDTLS309AllNotProvided = incdtlschilddoc.Rp_IncomeCollection.All(tuple => !tuple.Rp_Income_OrganisationNameDetails_SalaryOrWagesCollectionExists);
                    condition2b_INCDTLS160AllNotProvided = incdtlschilddoc.Rp_IncomeCollection.All(tuple => !tuple.Rp_Income_OrganisationNameDetails_ForeignEmploymentCollectionExists);
                    condition2_INCDTLS309OrINCDTLS160NotProvided = condition2a_INCDTLS309AllNotProvided && condition2b_INCDTLS160AllNotProvided;
                }
                else
                    condition2_INCDTLS309OrINCDTLS160NotProvided = true;
            }

            assertion = (condition1_IITR58OrIITR59NotNullOrBlank && (incdtlschilddoc == null || (condition2_INCDTLS309OrINCDTLS160NotProvided)) && condition3_WREDeductonsNullOrZero);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.301106",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Salary or wages gross income or work related expense deductions must be provided",
                    LongDescription = @"When the 'Main salary or wage occupation description' or 'Occupation code' are present, a Salary or wages payment summary, Foreign employment income payment summary, or at least one positive amount for 'Work related car expenses', 'Work related travel expenses', 'Work related uniform, occupation specific or protective clothing, laundry and dry cleaning expenses', 'Work related self-education expenses' or 'Other work related expenses', must be provided",
                    Location = "/xbrli:xbrl/tns:PersonDemographicDetails.Occupation.Description[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.300106" },
                        new ProcessMessageParameter() { Name = "IITR58", Value = GetValueOrEmpty(report.iitrParentDocument.IITR58) },
                        new ProcessMessageParameter() { Name = "IITR59", Value = GetValueOrEmpty(report.iitrParentDocument.IITR59) },
                        new ProcessMessageParameter() { Name = "IITR134", Value = GetValueOrEmpty(report.iitrParentDocument.IITR134) },
                        new ProcessMessageParameter() { Name = "IITR136", Value = GetValueOrEmpty(report.iitrParentDocument.IITR136) },
                        new ProcessMessageParameter() { Name = "IITR137", Value = GetValueOrEmpty(report.iitrParentDocument.IITR137) },
                        new ProcessMessageParameter() { Name = "IITR139", Value = GetValueOrEmpty(report.iitrParentDocument.IITR139) },
                        new ProcessMessageParameter() { Name = "IITR141", Value = GetValueOrEmpty(report.iitrParentDocument.IITR141) },
                        new ProcessMessageParameter() { Name = "(COUNT(SCHEDULE = \"INCDTLS\") = 0)", Value = (incdtlschilddoc == null).ToString() },
                        new ProcessMessageParameter() { Name = "ALL OCCURRENCES OF([incdtls309]) = NULL", Value = condition2a_INCDTLS309AllNotProvided.ToString() },
                        new ProcessMessageParameter() { Name = "ALL OCCURRENCES OF([incdtls160]) = NULL", Value = condition2b_INCDTLS160AllNotProvided.ToString() },
                        new ProcessMessageParameter() { Name = "(ALL OCCURRENCES OF([incdtls309]) = NULL) AND (ALL OCCURRENCES OF([incdtls160]) = NULL)", Value = condition2_INCDTLS309OrINCDTLS160NotProvided.ToString() },
                    },
                };

            }
            return processMessage;
        }
        #endregion // VR.ATO.IITR.300106

        #region VR.ATO.IITR.730460

        /* VR.ATO.IITR.730460
            The Partnership deductions relating to financial investment amounts shown at "Distribution from partnerships less foreign income" amount must equal the sum of all Non-primary production financial investment deductions from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR262 <> NULL AND ^IITR262 <> RoundDown(Sum(^INCDTLS476),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR262 <> NULL AND ^IITR262 <> RoundDown(Sum(^INCDTLS476),0))

        Data Elements:
    
            ^IITR262 = RP:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount
    
            ^INCDTLS476 = INCDTLS476
        */

        public static ProcessMessageDocument VR_ATO_IITR_730460(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR262IsNotNull = false;
            decimal condition3_INCDTLS476Sum = 0m;
            bool condition3_IITR262IsNotEqual = false;

            // Condition 2: [iitr262] <> NULL 
            condition2_IITR262IsNotNull = report.iitrParentDocument.IITR262 != null;

            // Condition 3 Sum: SUM([incdtls476])
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition3_INCDTLS476Sum = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS476.GetValueOrDefault()));

            // Condition 3: [iitr262] <> RoundDown(SUM([incdtls476]), 0))
            condition3_IITR262IsNotEqual = report.iitrParentDocument.IITR262.GetValueOrDefault() != condition3_INCDTLS476Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR262IsNotNull && condition3_IITR262IsNotEqual);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730460",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Partnership deductions relating to financial investment amounts shown at \"Distribution from partnerships less foreign income\" is incorrect",
                    LongDescription = "The Partnership deductions relating to financial investment amounts shown at \"Distribution from partnerships less foreign income\" amount must equal the sum of all Non-primary production financial investment deductions from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730460" },
                        new ProcessMessageParameter() { Name = "IITR262", Value = report.iitrParentDocument.IITR262.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls476]), 0)", Value = condition3_INCDTLS476Sum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730460

        #region VR.ATO.IITR.730461

        /* VR.ATO.IITR.730461
            Where Non-primary production financial investment deductions from partnership are present in the attached Income Details schedule, the Partnership deductions relating to financial investment amounts shown at "Distribution from partnerships less foreign income" amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR262 = NULL AND AnyOccurrence(^INCDTLS476, ^INCDTLS476 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR262 = NULL AND AnyOccurrence(^INCDTLS476, ^INCDTLS476 <> NULL))

        Data Elements:
    
            ^IITR262 = RP:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount
    
            ^INCDTLS476 = INCDTLS476
        */

        public static ProcessMessageDocument VR_ATO_IITR_730461(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR262IsNull = false;
            bool condition3_INCDTLS476AnyNotNull = false;

            // Condition 2: [iitr262] = NULL
            condition2_IITR262IsNull = report.iitrParentDocument.IITR262 == null;

            // Condition 3: ANY OCCURRENCE OF ([incdtls476]) <> NULL)
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition3_INCDTLS476AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS476 != null);

            assertion = (condition1_INCDTLSExists && condition2_IITR262IsNull && condition3_INCDTLS476AnyNotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730461",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Partnership deductions relating to financial investment amounts shown at \"Distribution from partnerships less foreign income\" must be provided",
                    LongDescription = "Where Non-primary production financial investment deductions from partnership are present in the attached Income Details schedule, the Partnership deductions relating to financial investment amounts shown at \"Distribution from partnerships less foreign income\" amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730461" },
                        new ProcessMessageParameter() { Name = "IITR262", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS476]) <> NULL", Value = condition3_INCDTLS476AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730461

        #region VR.ATO.IITR.730462

        /* VR.ATO.IITR.730462
            The Partnership deductions relating to rental property income or loss shown at "Distribution from partnerships less foreign income" amount must equal the sum of all Non-primary production rental property deductions from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR263 <> NULL AND ^IITR263 <> RoundDown(Sum(^INCDTLS477),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR263 <> NULL AND ^IITR263 <> RoundDown(Sum(^INCDTLS477),0))

        Data Elements:
    
            ^IITR263 = RP:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount
    
            ^INCDTLS477 = INCDTLS477
        */

        public static ProcessMessageDocument VR_ATO_IITR_730462(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR263IsNotNull = false;
            decimal condition3_INCDTLS477Sum = 0m;
            bool condition3_IITR263IsNotEqual = false;

            // Condition 2: [iitr263] <> NULL 
            condition2_IITR263IsNotNull = report.iitrParentDocument.IITR263 != null;

            // Condition 3 Sum: RoundDown(SUM([incdtls477]), 0)
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition3_INCDTLS477Sum = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS477.GetValueOrDefault()));

            // Condition 3: [iitr263] <> RoundDown(SUM([incdtls477]), 0)
            condition3_IITR263IsNotEqual = report.iitrParentDocument.IITR263.GetValueOrDefault() != condition3_INCDTLS477Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR263IsNotNull && condition3_IITR263IsNotEqual);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730462",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Partnership deductions relating to rental property income or loss shown at \"Distribution from partnerships less foreign income\" is incorrect",
                    LongDescription = "The Partnership deductions relating to rental property income or loss shown at \"Distribution from partnerships less foreign income\" amount must equal the sum of all Non-primary production rental property deductions from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730462" },
                        new ProcessMessageParameter() { Name = "IITR263", Value = report.iitrParentDocument.IITR263.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls477]), 0)", Value = condition3_INCDTLS477Sum.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730462

        #region VR.ATO.IITR.730463

        /* VR.ATO.IITR.730463
            Where Non-primary production rental property deductions from partnership are present in the attached Income Details schedule, the Partnership deductions relating to rental property income or loss shown at "Distribution from partnerships less foreign income" amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR263 = NULL AND AnyOccurrence(^INCDTLS477, ^INCDTLS477 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR263 = NULL AND AnyOccurrence(^INCDTLS477, ^INCDTLS477 <> NULL))

        Data Elements:
    
            ^IITR263 = RP:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount
    
            ^INCDTLS477 = INCDTLS477
        */

        public static ProcessMessageDocument VR_ATO_IITR_730463(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR263IsNull = false;
            bool Condition3_INCDTLS477AnyNotNull = false;

            // Condition 2: [iitr263] = NULL
            condition2_IITR263IsNull = report.iitrParentDocument.IITR263 == null;

            // Condition 3: ANY OCCURRENCE OF ([incdtls477]) <> NULL)
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS477AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS477 != null);

            assertion = (condition1_INCDTLSExists && condition2_IITR263IsNull && Condition3_INCDTLS477AnyNotNull);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730463",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Partnership deductions relating to rental property income or loss shown at \"Distribution from partnerships less foreign income\" must be provided",
                    LongDescription = "Where Non-primary production rental property deductions from partnership are present in the attached Income Details schedule, the Partnership deductions relating to rental property income or loss shown at \"Distribution from partnerships less foreign income\" amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730463" },
                        new ProcessMessageParameter() { Name = "IITR263", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([INCDTLS477]) <> NULL", Value = Condition3_INCDTLS477AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730463

        #region VR.ATO.IITR.730464

        /* VR.ATO.IITR.730464
            The Other deductions relating to distributions shown at "Distribution from partnerships less foreign income", "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" amount must equal the sum of all Non-primary production remaining deductions from partnership and Non-primary production remaining deductions from trusts amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR264 <> NULL AND ^IITR264 <> RoundDown(Sum(^INCDTLS478) + Sum(^INCDTLS258),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR264 <> NULL AND ^IITR264 <> RoundDown(Sum(^INCDTLS478) + Sum(^INCDTLS258),0))

        Data Elements:

            ^IITR264 = RP:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount

            ^INCDTLS258 = INCDTLS258

            ^INCDTLS478 = INCDTLS478
        */

        public static ProcessMessageDocument VR_ATO_IITR_730464(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR264IsNotNull = false;
            decimal condition3A_INCDTLS478Sum = 0m;
            decimal condition3B_INCDTLS258Sum = 0m;
            decimal condition3_INCDTLSTotalSum = 0m;
            bool condition3_IITR264IsNotEqual = false;

            // Condition 2: [iitr264] <> NULL 
            condition2_IITR264IsNotNull = report.iitrParentDocument.IITR264 != null;

            // Condition 3 A Sum: SUM([incdtls478])
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                condition3A_INCDTLS478Sum = incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS478.GetValueOrDefault());

            // Condition 3(B): Sum(^INCDTLS258)
            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                condition3B_INCDTLS258Sum = incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS258.GetValueOrDefault());

            // Condition 3 Total Sum: RoundDown(SUM([incdtls478]) + [incdtls258],0)
            condition3_INCDTLSTotalSum = Math.Truncate(condition3A_INCDTLS478Sum + condition3B_INCDTLS258Sum);

            // Condition 3: [iitr264] <> RoundDown(SUM([incdtls478]) + [incdtls258],0)
            condition3_IITR264IsNotEqual = report.iitrParentDocument.IITR264.GetValueOrDefault() != condition3_INCDTLSTotalSum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_INCDTLSExists && condition2_IITR264IsNotNull && condition3_IITR264IsNotEqual);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730464",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Other deductions relating to distributions shown at \"Distribution from partnerships less foreign income\", \"Share of net income from trusts less capital gains, foreign income and franked distributions\" and \"Franked distributions from trusts\" is incorrect",
                    LongDescription = "The Other deductions relating to distributions shown at \"Distribution from partnerships less foreign income\", \"Share of net income from trusts less capital gains, foreign income and franked distributions\" and \"Franked distributions from trusts\" amount must equal the sum of all Non-primary production remaining deductions from partnership and Non-primary production remaining deductions from trusts amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730464" },
                        new ProcessMessageParameter() { Name = "IITR264", Value = report.iitrParentDocument.IITR264.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "SUM([incdtls478])", Value = condition3A_INCDTLS478Sum.ToString() },
                        new ProcessMessageParameter() { Name = "Sum(^INCDTLS258)", Value = condition3B_INCDTLS258Sum.ToString() },
                        new ProcessMessageParameter() { Name = "Sum INCDTLS478+258", Value = condition3_INCDTLSTotalSum.ToString() },
                        new ProcessMessageParameter() { Name = "IITR264 Total", Value = condition3_IITR264IsNotEqual.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730464

        #region VR.ATO.IITR.730465

        /* VR.ATO.IITR.730465
            Where Non-primary production remaining deductions from partnership or Non-primary production remaining deductions from trusts are present in the attached Income Details schedule, the Other deductions relating to distributions shown at "Distribution from partnerships less foreign income", "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" amount must be provided

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR264 = NULL AND (AnyOccurrence(^INCDTLS478, ^INCDTLS478 <> NULL) OR AnyOccurrence(^INCDTLS258, ^INCDTLS258 <> NULL))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR264 = NULL AND (AnyOccurrence(^INCDTLS478, ^INCDTLS478 <> NULL) OR AnyOccurrence(^INCDTLS258, ^INCDTLS258 <> NULL))

        Data Elements:

            ^IITR264 = RP:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount

            ^INCDTLS258 = INCDTLS258

            ^INCDTLS478 = INCDTLS478
        */

        public static ProcessMessageDocument VR_ATO_IITR_730465(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 1 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition1_INCDTLSExists = true;
            bool condition2_IITR264IsNull = false;
            bool Condition3a_INCDTLS478AnyNotNull = false;
            bool Condition3b_INCDTLS258NotNull = false;

            // Condition 2: [iitr264] = NULL
            condition2_IITR264IsNull = report.iitrParentDocument.IITR264 == null;

            // Condition 3: ANY OCCURRENCE OF ([incdtls478]) <> NULL OR [incdtls258] <> NULL)
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3a_INCDTLS478AnyNotNull = incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS478 != null);

            if (incdtlschilddoc.Rp_TrustIncomeCollectionExists)
                Condition3b_INCDTLS258NotNull = incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS258 != null);

            assertion = (condition1_INCDTLSExists && condition2_IITR264IsNull && (Condition3a_INCDTLS478AnyNotNull || Condition3b_INCDTLS258NotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730465",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Other deductions relating to distributions shown at \"Distribution from partnerships less foreign income\", \"Share of net income from trusts less capital gains, foreign income and franked distributions\" and \"Franked distributions from trusts\" must be provided",
                    LongDescription = "Where Non-primary production remaining deductions from partnership or Non-primary production remaining deductions from trusts are present in the attached Income Details schedule, the Other deductions relating to distributions shown at \"Distribution from partnerships less foreign income\", \"Share of net income from trusts less capital gains, foreign income and franked distributions\" and \"Franked distributions from trusts\" amount must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730465" },
                        new ProcessMessageParameter() { Name = "IITR264", Value = "NULL" },
                        new ProcessMessageParameter() { Name = "INCDTLS478 <> NULL", Value = Condition3a_INCDTLS478AnyNotNull.ToString() },
                        new ProcessMessageParameter() { Name = "INCDTLS258 <> NULL", Value = Condition3b_INCDTLS258NotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730465

        #region VR.ATO.IITR.730468

        /* VR.ATO.IITR.730468
            The Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset amount must equal the sum of all Primary production landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR245 <> NULL AND ^IITR245 <> RoundDown(Sum(^INCDTLS465),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR245 <> NULL AND ^IITR245 <> RoundDown(Sum(^INCDTLS465),0))

        Data Elements:
    
            ^IITR245 = RP.Partnership:Expense.LandcareOperationsAcceleratedDepreciation.Amount
    
            ^INCDTLS465 = INCDTLS465
        */

        public static ProcessMessageDocument VR_ATO_IITR_730468(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([INCDTLS465]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS465 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS465
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS465 = (incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS465.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR245 != null && (report.iitrParentDocument.IITR245.GetValueOrDefault() != Math.Truncate(Conditional3_SumOfINCDTLS465)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730468",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset amount is incorrect",
                    LongDescription = @"The Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset amount must equal the sum of all Primary production landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Expense.LandcareOperationsAcceleratedDepreciation.Amount[@contextRef='" + report.iitrParentDocument.RPPartnershipId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730468" },
                        new ProcessMessageParameter() { Name = "iitr245", Value = report.iitrParentDocument.IITR245.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([INCDTLS465]))", Value = Conditional3_SumOfINCDTLS465.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730468

        #region VR.ATO.IITR.730469

        /* VR.ATO.IITR.730469
            Where Primary production landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset from partnership amounts are present in the attached Income Details schedule, the Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR245 = NULL AND AnyOccurrence(^INCDTLS465, ^INCDTLS465 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR245 = NULL AND AnyOccurrence(^INCDTLS465, ^INCDTLS465 <> NULL))

        Data Elements:
    
            ^IITR245 = RP.Partnership:Expense.LandcareOperationsAcceleratedDepreciation.Amount
    
            ^INCDTLS465 = INCDTLS465
        */

        public static ProcessMessageDocument VR_ATO_IITR_730469(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS465AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS465
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS465AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS465 != null));

            bool assertion = (report.iitrParentDocument.IITR245 == null && (Condition3_INCDTLS465AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730469",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset must be provided",
                    LongDescription = @"Where Primary production landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset from partnership amounts are present in the attached Income Details schedule, the Landcare operations and deduction for decline in value of water facility, fencing asset and fodder storage asset amount must be provided",
                    Location = "/xbrli:xbrl/tns:Expense.LandcareOperationsAcceleratedDepreciation.Amount[@contextRef='" + report.iitrParentDocument.RPPartnershipId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730469" },
                        new ProcessMessageParameter() { Name = "iitr245", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls465]) <> NULL", Value = Condition3_INCDTLS465AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730469

        #region VR.ATO.IITR.730470

        /* VR.ATO.IITR.730470
        The Landcare operations expenses amount must equal the sum of all Non-primary production landcare operations expenses from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR260<> NULL AND ^IITR260<> RoundDown(Sum(^INCDTLS473),0))

        Technical Business Rule Format:
                (CountDocument('INCDTLS') = 1 AND ^IITR260<> NULL AND ^IITR260<> RoundDown(Sum(^INCDTLS473),0))

        Data Elements:
    
            ^IITR260 = RP:Expense.LandcareOperationsNonPrimaryProduction.Amount
    
            ^INCDTLS473 = INCDTLS473
        */

        public static ProcessMessageDocument VR_ATO_IITR_730470(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([INCDTLS473]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS473 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS473
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS473 = (incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS473.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR260 != null && (report.iitrParentDocument.IITR260.GetValueOrDefault() != Math.Truncate(Conditional3_SumOfINCDTLS473)));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730470",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Landcare operations expenses is incorrect",
                    LongDescription = @"The Landcare operations expenses amount must equal the sum of all Non-primary production landcare operations expenses from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Expense.LandcareOperationsNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730470" },
                        new ProcessMessageParameter() { Name = "IITR260", Value = report.iitrParentDocument.IITR260.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([INCDTLS473]))", Value = Conditional3_SumOfINCDTLS473.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730470

        #region VR.ATO.IITR.730471

        /* VR.ATO.IITR.730471
            Where Non-primary production landcare operations expenses from partnership amounts are present in the attached Income Details schedule, the Landcare operations expenses amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR260 = NULL AND AnyOccurrence(^INCDTLS473, ^INCDTLS473 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR260 = NULL AND AnyOccurrence(^INCDTLS473, ^INCDTLS473 <> NULL))

        Data Elements:
    
            ^IITR260 = RP:Expense.LandcareOperationsNonPrimaryProduction.Amount
    
            ^INCDTLS473 = INCDTLS473
        */

        public static ProcessMessageDocument VR_ATO_IITR_730471(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS473AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS473
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS473AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS473 != null));

            bool assertion = (report.iitrParentDocument.IITR260 == null && (Condition3_INCDTLS473AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730471",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Landcare operations expenses must be provided",
                    LongDescription = @"Where Non-primary production landcare operations expenses from partnership amounts are present in the attached Income Details schedule, the Landcare operations expenses amount must be provided",
                    Location = "/xbrli:xbrl/tns:Expense.LandcareOperationsNonPrimaryProduction.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730471" },
                        new ProcessMessageParameter() { Name = "iitr260", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls473]) <> NULL", Value = Condition3_INCDTLS473AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730471

        #region VR.ATO.IITR.730472

        /* VR.ATO.IITR.730472
            The Distribution from partnerships amount must equal the sum of all Primary production distribution from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR242 <> NULL AND ^IITR242 <> RoundDown(Sum(^INCDTLS464),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR242 <> NULL AND ^IITR242 <> RoundDown(Sum(^INCDTLS464),0))

        Data Elements:
    
            ^IITR242 = RP:Income.PartnershipPrimaryProductionShare.Amount
    
            ^INCDTLS464 = INCDTLS464
        */
        public static ProcessMessageDocument VR_ATO_IITR_730472(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls464]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS464 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS464
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS464 = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS464.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR242 != null && (report.iitrParentDocument.IITR242.GetValueOrDefault() != Conditional3_SumOfINCDTLS464));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730472",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Distribution from partnerships amount is incorrect",
                    LongDescription = @"The Distribution from partnerships amount must equal the sum of all Primary production distribution from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730472" },
                        new ProcessMessageParameter() { Name = "iitr242", Value = report.iitrParentDocument.IITR242.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls464]))", Value = Conditional3_SumOfINCDTLS464.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730472

        #region VR.ATO.IITR.730473

        /* VR.ATO.IITR.730473
            Where Primary production distribution from partnership amounts are present in the attached Income Details schedule, the Distribution from partnerships amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR242 = NULL AND AnyOccurrence(^INCDTLS464, ^INCDTLS464 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR242 = NULL AND AnyOccurrence(^INCDTLS464, ^INCDTLS464 <> NULL))

        Data Elements:
    
            ^IITR242 = RP:Income.PartnershipPrimaryProductionShare.Amount
    
            ^INCDTLS464 = INCDTLS464
        */

        public static ProcessMessageDocument VR_ATO_IITR_730473(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS464AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS464
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS464AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS464 != null));

            bool assertion = (report.iitrParentDocument.IITR242 == null && (Condition3_INCDTLS464AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730473",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Distribution from partnerships must be provided",
                    LongDescription = @"Where Primary production distribution from partnership amounts are present in the attached Income Details schedule, the Distribution from partnerships amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730473" },
                        new ProcessMessageParameter() { Name = "iitr242", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls464]) <> NULL", Value = Condition3_INCDTLS464AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730473

        #region VR.ATO.IITR.730474

        /* VR.ATO.IITR.730474
            The Distribution from partnerships relating to financial investments, less foreign income amount must equal the sum of all Non-primary production net financial investment income or loss from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR249 <> NULL AND ^IITR249 <> RoundDown(Sum(^INCDTLS470),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR249 <> NULL AND ^IITR249 <> RoundDown(Sum(^INCDTLS470),0))

        Data Elements:
    
            ^IITR249 = RP:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount
    
            ^INCDTLS470 = INCDTLS470
        */

        public static ProcessMessageDocument VR_ATO_IITR_730474(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls470]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS470 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS470
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS470 = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS470.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR249 != null && (report.iitrParentDocument.IITR249.GetValueOrDefault() != Conditional3_SumOfINCDTLS470));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730474",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Distribution from partnerships relating to financial investments, less foreign income amount is incorrect",
                    LongDescription = @"The Distribution from partnerships relating to financial investments, less foreign income amount must equal the sum of all Non-primary production net financial investment income or loss from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730474" },
                        new ProcessMessageParameter() { Name = "iitr249", Value = report.iitrParentDocument.IITR249.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls470]))", Value = Conditional3_SumOfINCDTLS470.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730474

        #region VR.ATO.IITR.730475

        /* VR.ATO.IITR.730475
            Where Non-primary production net financial investment income or loss from partnership amounts are present in the attached Income Details schedule, the Distribution from partnerships relating to financial investments, less foreign income amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR249 = NULL AND AnyOccurrence(^INCDTLS470, ^INCDTLS470 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR249 = NULL AND AnyOccurrence(^INCDTLS470, ^INCDTLS470 <> NULL))

        Data Elements:
    
            ^IITR249 = RP:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount
    
            ^INCDTLS470 = INCDTLS470
        */
        public static ProcessMessageDocument VR_ATO_IITR_730475(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS470AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS470
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS470AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS470 != null));

            bool assertion = (report.iitrParentDocument.IITR249 == null && (Condition3_INCDTLS470AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730475",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Distribution from partnerships relating to financial investments, less foreign income must be provided",
                    LongDescription = @"Where Non-primary production net financial investment income or loss from partnership amounts are present in the attached Income Details schedule, the Distribution from partnerships relating to financial investments, less foreign income amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730475" },
                        new ProcessMessageParameter() { Name = "iitr249", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls470]) <> NULL", Value = Condition3_INCDTLS470AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730475

        #region VR.ATO.IITR.730476

        /* VR.ATO.IITR.730476
            The Share of net rental property income or loss from partnerships amount must equal the sum of all Non-primary production net rental property income or loss from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR250 <> NULL AND ^IITR250 <> RoundDown(Sum(^INCDTLS471),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR250 <> NULL AND ^IITR250 <> RoundDown(Sum(^INCDTLS471),0))

        Data Elements:
    
            ^IITR250 = RP:Income.PartnershipRentalNonPrimaryProductionShare.Amount
    
            ^INCDTLS471 = INCDTLS471
        */

        public static ProcessMessageDocument VR_ATO_IITR_730476(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls471]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS471 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS471
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS471 = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS471.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR250 != null && (report.iitrParentDocument.IITR250.GetValueOrDefault() != Conditional3_SumOfINCDTLS471));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730476",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of net rental property income or loss from partnerships amount is incorrect",
                    LongDescription = @"The Share of net rental property income or loss from partnerships amount must equal the sum of all Non-primary production net rental property income or loss from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipRentalNonPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730476" },
                        new ProcessMessageParameter() { Name = "iitr250", Value = report.iitrParentDocument.IITR250.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls471]))", Value = Conditional3_SumOfINCDTLS471.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730476

        #region VR.ATO.IITR.730477

        /* VR.ATO.IITR.730477
            Where Non-primary production net rental property income or loss from partnership amounts are present in the attached Income Details schedule, the Share of net rental property income or loss from partnerships amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR250 = NULL AND AnyOccurrence(^INCDTLS471, ^INCDTLS471 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR250 = NULL AND AnyOccurrence(^INCDTLS471, ^INCDTLS471 <> NULL))

        Data Elements:
    
            ^IITR250 = RP:Income.PartnershipRentalNonPrimaryProductionShare.Amount
    
            ^INCDTLS471 = INCDTLS471
        */

        public static ProcessMessageDocument VR_ATO_IITR_730477(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS471AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS471
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS471AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS471 != null));

            bool assertion = (report.iitrParentDocument.IITR250 == null && (Condition3_INCDTLS471AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730477",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Share of net rental property income or loss from partnerships must be provided",
                    LongDescription = @"Where Non-primary production net rental property income or loss from partnership amounts are present in the attached Income Details schedule, the Share of net rental property income or loss from partnerships amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipRentalNonPrimaryProductionShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730477" },
                        new ProcessMessageParameter() { Name = "iitr250", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls471]) <> NULL", Value = Condition3_INCDTLS471AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730477

        #region VR.ATO.IITR.730478

        /* VR.ATO.IITR.730478
            The Other distributions from partnerships amount must equal the sum of all Non-primary production remaining distribution from partnership amounts provided in the attached Income Details schedule

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR251 <> NULL AND ^IITR251 <> RoundDown(Sum(^INCDTLS472),0))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR251 <> NULL AND ^IITR251 <> RoundDown(Sum(^INCDTLS472),0))

        Data Elements:
    
            ^IITR251 = RP:Income.PartnershipNonPrimaryProductionOtherShare.Amount
    
            ^INCDTLS472 = INCDTLS472
        */

        public static ProcessMessageDocument VR_ATO_IITR_730478(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.

            // Condition 3: RoundDown(SUM([incdtls472]))
            // Calculate the total of each of the sum values
            decimal Conditional3_SumOfINCDTLS472 = 0;

            // Calculate total of each of the fields if the PartnershipsCollection tuple exists and if so, checks each tuple for any instance of INCDTLS472
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Conditional3_SumOfINCDTLS472 = Math.Truncate(incdtlschilddoc.Rp_PartnershipsCollection.Sum(tuple => tuple.INCDTLS472.GetValueOrDefault()));

            bool assertion = (report.iitrParentDocument.IITR251 != null && (report.iitrParentDocument.IITR251.GetValueOrDefault() != Conditional3_SumOfINCDTLS472));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730478",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other distributions from partnerships amount is incorrect",
                    LongDescription = @"The Other distributions from partnerships amount must equal the sum of all Non-primary production remaining distribution from partnership amounts provided in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipNonPrimaryProductionOtherShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730478" },
                        new ProcessMessageParameter() { Name = "iitr251", Value = report.iitrParentDocument.IITR251.ToString() },
                        new ProcessMessageParameter() { Name = "RoundDown(SUM([incdtls472]))", Value = Conditional3_SumOfINCDTLS472.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730478

        #region VR.ATO.IITR.730479

        /* VR.ATO.IITR.730479
            Where Non-primary production remaining distribution from partnership amounts are present in the attached Income Details schedule, the Other distributions from partnerships amount must be provided

        Legacy Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR251 = NULL AND AnyOccurrence(^INCDTLS472, ^INCDTLS472 <> NULL))

        Technical Business Rule Format:
            (CountDocument('INCDTLS') = 1 AND ^IITR251 = NULL AND AnyOccurrence(^INCDTLS472, ^INCDTLS472 <> NULL))

        Data Elements:
    
            ^IITR251 = RP:Income.PartnershipNonPrimaryProductionOtherShare.Amount
    
            ^INCDTLS472 = INCDTLS472
        */
        public static ProcessMessageDocument VR_ATO_IITR_730479(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            // Condition 1: COUNT SCHEDULE("INCDTLS") = 1 is already met as per the function that calls this rule.
            bool Condition3_INCDTLS472AnyNotNull = false;

            // Calculate total of each of the fields if the IncomeOther tuple exists and if so, checks each tuple for any instance of INCDTLS472
            if (incdtlschilddoc.Rp_PartnershipsCollectionExists)
                Condition3_INCDTLS472AnyNotNull = (incdtlschilddoc.Rp_PartnershipsCollection.Any(tuple => tuple.INCDTLS472 != null));

            bool assertion = (report.iitrParentDocument.IITR251 == null && (Condition3_INCDTLS472AnyNotNull));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730479",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other distributions from partnerships must be provided",
                    LongDescription = @"Where Non-primary production remaining distribution from partnership amounts are present in the attached Income Details schedule, the Other distributions from partnerships amount must be provided",
                    Location = "/xbrli:xbrl/tns:Income.PartnershipNonPrimaryProductionOtherShare.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730479" },
                        new ProcessMessageParameter() { Name = "iitr251", Value = null },
                        new ProcessMessageParameter() { Name = "ANY OCCURRENCE OF([incdtls472]) <> NULL", Value = Condition3_INCDTLS472AnyNotNull.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion // VR.ATO.IITR.730479

        #region VR.ATO.IITR.730480

        /* VR.ATO.IITR.730480
            Where Other deductions relating to amounts shown type of "All" is selected, all instances of Primary production deduction loss type from partnership in the attached Income Details schedule must be populated with "All", and there must not be any positive amounts provided for Primary production other deductions from trusts or Other deductions for primary production distributions from managed funds

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = 'All' AND ((AnyOccurrence(^INCDTLS467, ^INCDTLS467 <> 'All') WHERE ^INCDTLS466 > 0) OR AnyOccurrence(^INCDTLS248, ^INCDTLS248 > 0) OR (AnyOccurrence(^INCDTLS403, ^INCDTLS403 > 0) WHERE ^INCDTLS387 = 1) OR (AnyOccurrence(^INCDTLS433, ^INCDTLS433 > 0) WHERE ^INCDTLS387 > 1))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = 'All' AND ((AnyOccurrence(^INCDTLS467, ^INCDTLS467 <> 'All') WHERE ^INCDTLS466 > 0) OR AnyOccurrence(^INCDTLS248, ^INCDTLS248 > 0) OR (AnyOccurrence(^INCDTLS403, ^INCDTLS403 > 0) WHERE ^INCDTLS387 = 1) OR (AnyOccurrence(^INCDTLS433, ^INCDTLS433 > 0) WHERE ^INCDTLS387 > 1))

        Data Elements:
    
            ^IITR247 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code
    
            ^INCDTLS248 = INCDTLS248
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS403 = INCDTLS403
    
            ^INCDTLS433 = INCDTLS433
    
            ^INCDTLS466 = INCDTLS466
    
            ^INCDTLS467 = INCDTLS467
        */

        public static ProcessMessageDocument VR_ATO_IITR_730480(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls467Matches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS466.GetValueOrDefault() > 0 && tuple.INCDTLS467 != "All") : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls403Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 && tuple.INCDTLS403.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls433Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS387.GetValueOrDefault() > 1 && tuple.INCDTLS433.GetValueOrDefault() > 0) : null);
            bool anyINCDTLS248 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS248 > 0);

            bool assertion = report.iitrParentDocument.IITR247 == "All" && (Count(incdtls467Matches) > 0 || anyINCDTLS248 || Count(incdtls403Matches) > 0 || Count(incdtls433Matches) > 0);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730480",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown type of ""All"" is selected, all instances of Primary production deduction loss type from partnership in the attached Income Details schedule must be populated with ""All"", and there must not be any positive amounts provided for Primary production other deductions from trusts or Other deductions for primary production distributions from managed funds",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730480" },
                        new ProcessMessageParameter() { Name = "IITR247", Value = report.iitrParentDocument.IITR247 },
                        new ProcessMessageParameter() { Name = "INCDTLS387", Value = (Count(incdtls403Matches) > 0 ? "1" : (Count(incdtls433Matches) > 0 ? incdtls433Matches.First().INCDTLS387.GetValueOrDefault().ToString() : "0")) },
                        new ProcessMessageParameter() { Name = "INCDTLS403", Value = (Count(incdtls403Matches) > 0 ? incdtls403Matches.First().INCDTLS403.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS433", Value = (Count(incdtls433Matches) > 0 ? incdtls433Matches.First().INCDTLS433.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS466", Value = (Count(incdtls467Matches) > 0 ? incdtls467Matches.First().INCDTLS466.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS467", Value = (Count(incdtls467Matches) > 0 ? incdtls467Matches.First().INCDTLS467 : "null") },
                        new ProcessMessageParameter() { Name = "INCDTLS248 <> NULL", Value = anyINCDTLS248.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730480

        #region VR.ATO.IITR.730481

        /* VR.ATO.IITR.730481
            Where Other deductions relating to amounts shown type of "Part" is selected; at least one instance of Primary production deduction loss type from partnership in the attached Income Details schedule must be populated with "Part", or; at least one instance of Primary production deduction loss type from partnership must be populated with "All" and either, at least one other instance of Primary production deduction loss type from partnership is populated with "None" (or blank), or a positive amount is provided for Primary production other deductions from trusts or Other deductions for primary production distributions from managed funds, in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = 'Part' AND CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'Part' AND ^INCDTLS466 > 0)) = 0 AND (CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'All' AND ^INCDTLS466 > 0)) = 0 OR (CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'None' AND ^INCDTLS466 > 0)) = 0 AND CountOccurrence(^INCDTLS467, (^INCDTLS467 = NULL AND ^INCDTLS466 > 0)) = 0 AND CountOccurrence(^INCDTLS248, ^INCDTLS248 = 0 OR ^INCDTLS248 = NULL) = 0 AND CountOccurrence(^INCDTLS403, (^INCDTLS403 > 0 AND ^INCDTLS387 = 1)) = 0 AND CountOccurrence(^INCDTLS433, (^INCDTLS433 > 0 AND ^INCDTLS387 > 1)) = 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = 'Part' AND CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'Part' AND ^INCDTLS466 > 0)) = 0 AND (CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'All' AND ^INCDTLS466 > 0)) = 0 OR (CountOccurrence(^INCDTLS467, (^INCDTLS467 = 'None' AND ^INCDTLS466 > 0)) = 0 AND CountOccurrence(^INCDTLS467, (^INCDTLS467 = NULL AND ^INCDTLS466 > 0)) = 0 AND CountOccurrence(^INCDTLS248, ^INCDTLS248 = 0 OR ^INCDTLS248 = NULL) = 0 AND CountOccurrence(^INCDTLS403, (^INCDTLS403 > 0 AND ^INCDTLS387 = 1)) = 0 AND CountOccurrence(^INCDTLS433, (^INCDTLS433 > 0 AND ^INCDTLS387 > 1)) = 0))

        Data Elements:
    
            ^IITR247 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code
    
            ^INCDTLS248 = INCDTLS248
    
            ^INCDTLS387 = INCDTLS387
    
            ^INCDTLS403 = INCDTLS403
    
            ^INCDTLS433 = INCDTLS433
    
            ^INCDTLS466 = INCDTLS466
    
            ^INCDTLS467 = INCDTLS467
        */

        public static ProcessMessageDocument VR_ATO_IITR_730481(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls467PartMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS467 == "Part" && tuple.INCDTLS466.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls467AllMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS467 == "All" && tuple.INCDTLS466.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls467NoneMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS467 == "None" && tuple.INCDTLS466.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls467NullMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => string.IsNullOrWhiteSpace(tuple.INCDTLS467) && tuple.INCDTLS466.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls403Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS403.GetValueOrDefault() > 0 && tuple.INCDTLS387.GetValueOrDefault() == 1) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls433Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS433.GetValueOrDefault() > 0 && tuple.INCDTLS387.GetValueOrDefault() > 1) : null);
            List<INCDTLS2026.Rp_TrustIncome> incdtls248Matches = (incdtlschilddoc.Rp_TrustIncomeCollection != null ? incdtlschilddoc.Rp_TrustIncomeCollection.FindAll(tuple => tuple.INCDTLS248 == null || tuple.INCDTLS248 == 0) : null);
            

            bool assertion = report.iitrParentDocument.IITR247 == "Part" && Count(incdtls467PartMatches) == 0 && (Count(incdtls467AllMatches) == 0 || (Count(incdtls467NoneMatches) == 0 && Count(incdtls467NullMatches) == 0 && Count(incdtls248Matches) == 0 && Count(incdtls403Matches) == 0 && Count(incdtls433Matches) == 0));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730481",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown type of ""Part"" is selected; at least one instance of Primary production deduction loss type from partnership in the attached Income Details schedule must be populated with ""Part"", or; at least one instance of Primary production deduction loss type from partnership must be populated with ""All"" and either, at least one other instance of Primary production deduction loss type from partnership is populated with ""None"" (or blank), or a positive amount is provided for Primary production other deductions from trusts or Other deductions for primary production distributions from managed funds, in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730481" },
                        new ProcessMessageParameter() { Name = "IITR247", Value = report.iitrParentDocument.IITR247 },
                        new ProcessMessageParameter() { Name = "INCDTLS403", Value = (Count(incdtls403Matches) > 0 ? incdtls403Matches.First().INCDTLS403.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS433", Value = (Count(incdtls433Matches) > 0 ? incdtls433Matches.First().INCDTLS433.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS248", Value = (Count(incdtls248Matches) > 0 ? incdtls248Matches.First().INCDTLS248.GetValueOrDefault().ToString() : "0") },
                    },
                };
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730481

        #region VR.ATO.IITR.730482

        /* VR.ATO.IITR.730482
            Where Other deductions relating to amounts shown type is not provided, all instances of Primary production deduction loss type from partnership must be populated with "None" (or blank), in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = NULL AND (AnyOccurrence(^INCDTLS467, ^INCDTLS467 <> 'None') WHERE (^INCDTLS467 <> NULL AND ^INCDTLS466 > 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR247 = NULL AND (AnyOccurrence(^INCDTLS467, ^INCDTLS467 <> 'None') WHERE (^INCDTLS467 <> NULL AND ^INCDTLS466 > 0))

        Data Elements:
    
            ^IITR247 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code
    
            ^INCDTLS466 = INCDTLS466
    
            ^INCDTLS467 = INCDTLS467
        */
        public static ProcessMessageDocument VR_ATO_IITR_730482(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls467matches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS467 != null && tuple.INCDTLS466.GetValueOrDefault() > 0 && tuple.INCDTLS467 != "None") : null);

            bool assertion = report.iitrParentDocument.IITR247 == null && Count(incdtls467matches) > 0;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730482",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown type is not provided, all instances of Primary production deduction loss type from partnership must be populated with ""None"" (or blank), in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730482" },
                        new ProcessMessageParameter() { Name = "IITR247", Value = report.iitrParentDocument.IITR247 },
                        new ProcessMessageParameter() { Name = "INCDTLS466", Value = (Count(incdtls467matches) > 0 ? incdtls467matches.First().INCDTLS466.ToString() : "0" ) },
                        new ProcessMessageParameter() { Name = "INCDTLS467", Value = (Count(incdtls467matches) > 0 ? incdtls467matches.First().INCDTLS467 : "null" ) }
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730482

        #region VR.ATO.IITR.730485

        /* VR.ATO.IITR.730485
            Where Other deductions relating to amounts shown at "Distribution from partnerships less foreign income", "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" type of "Entire" is selected, all instances of Non-primary production deduction loss type from partnership in the attached Income Details schedule must be populated with "All", and there must not be any positive amounts provided for Non-primary production other deductions from trusts or Other deductions for non-primary production distributions from managed funds

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = 'Entire' AND ((AnyOccurrence(^INCDTLS475, ^INCDTLS475 <> 'All') WHERE (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0)) OR AnyOccurrence(^INCDTLS256, ^INCDTLS256 > 0) OR (AnyOccurrence(^INCDTLS391, ^INCDTLS391 > 0) WHERE ^INCDTLS387 = 1) OR (AnyOccurrence(^INCDTLS421, ^INCDTLS421 > 0) WHERE ^INCDTLS387 > 1))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = 'Entire' AND ((AnyOccurrence(^INCDTLS475, ^INCDTLS475 <> 'All') WHERE (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0)) OR AnyOccurrence(^INCDTLS256, ^INCDTLS256 > 0) OR (AnyOccurrence(^INCDTLS391, ^INCDTLS391 > 0) WHERE ^INCDTLS387 = 1) OR (AnyOccurrence(^INCDTLS421, ^INCDTLS421 > 0) WHERE ^INCDTLS387 > 1))

        Data Elements:

            ^IITR266 = RP:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code

            ^INCDTLS256 = INCDTLS256

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS391 = INCDTLS391

            ^INCDTLS421 = INCDTLS421

            ^INCDTLS475 = INCDTLS475

            ^INCDTLS476 = INCDTLS476

            ^INCDTLS477 = INCDTLS477

            ^INCDTLS478 = INCDTLS478
        */

        public static ProcessMessageDocument VR_ATO_IITR_730485(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls475matches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS475 != "All" && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls391matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS387.GetValueOrDefault() == 1 && tuple.INCDTLS391.GetValueOrDefault() > 0) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls421matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS387.GetValueOrDefault() > 1 && tuple.INCDTLS421.GetValueOrDefault() > 0) : null);
            bool anyINCDTLS256 = incdtlschilddoc.Rp_TrustIncomeCollection != null && incdtlschilddoc.Rp_TrustIncomeCollection.Any(tuple => tuple.INCDTLS256 > 0);

            bool assertion = report.iitrParentDocument.IITR266 == "Entire" && (Count(incdtls475matches) > 0 || anyINCDTLS256 || Count(incdtls391matches) > 0 || Count(incdtls421matches) > 0);

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730485",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type of ""Entire"" is selected, all instances of Non-primary production deduction loss type from partnership in the attached Income Details schedule must be populated with ""All"", and there must not be any positive amounts provided for Non-primary production other deductions from trusts or Other deductions for non-primary production distributions from managed funds",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730485" },
                        new ProcessMessageParameter() { Name = "IITR266", Value = report.iitrParentDocument.IITR266 },
                        new ProcessMessageParameter() { Name = "INCDTLS391", Value = (Count(incdtls391matches) > 0 ? incdtls391matches.First().INCDTLS391.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS421", Value = (Count(incdtls421matches) > 0 ? incdtls421matches.First().INCDTLS421.GetValueOrDefault().ToString() : "0") },
                        new ProcessMessageParameter() { Name = "INCDTLS256 <> NULL", Value = anyINCDTLS256.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730485

        #region VR.ATO.IITR.730486

        /* VR.ATO.IITR.730486
            Where Other deductions relating to amounts shown at "Distribution from partnerships less foreign income", "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" type of "Part" is selected; at least one instance of Non-primary production deduction loss type from partnership in the attached Income Details schedule must be populated with "Part", or; at least one instance of Non-Primary production deduction loss type from partnership must be populated with "All" and either, at least one other instance of Non-primary production deduction loss type from partnership is populated with "None" (or blank), or a positive amount is provided for  Non-primary production other deductions from trusts or Other deductions for non-primary production distributions from managed funds, in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = 'Part' AND CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'Part' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND (CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'All' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 OR (CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'None' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND CountOcurrence(^INCDTLS475, (^INCDTLS475 = NULL AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND Sum(^INCDTLS256) = 0 AND CountOcurrence(^INCDTLS391, (^INCDTLS391 > 0 AND ^INCDTLS387 = 1)) = 0 AND CountOcurrence(^INCDTLS421, (^INCDTLS421 > 0 AND ^INCDTLS387 > 1)) = 0))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = 'Part' AND CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'Part' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND (CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'All' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 OR (CountOcurrence(^INCDTLS475, (^INCDTLS475 = 'None' AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND CountOcurrence(^INCDTLS475, (^INCDTLS475 = NULL AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0))) = 0 AND Sum(^INCDTLS256) = 0 AND CountOcurrence(^INCDTLS391, (^INCDTLS391 > 0 AND ^INCDTLS387 = 1)) = 0 AND CountOcurrence(^INCDTLS421, (^INCDTLS421 > 0 AND ^INCDTLS387 > 1)) = 0))

        Data Elements:

            ^IITR266 = RP:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code

            ^INCDTLS256 = INCDTLS256

            ^INCDTLS387 = INCDTLS387

            ^INCDTLS391 = INCDTLS391

            ^INCDTLS421 = INCDTLS421

            ^INCDTLS475 = INCDTLS475

            ^INCDTLS476 = INCDTLS476

            ^INCDTLS477 = INCDTLS477

            ^INCDTLS478 = INCDTLS478
        */

        public static ProcessMessageDocument VR_ATO_IITR_730486(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls475PartMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS475 == "Part" && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls475AllMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS475 == "All" && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls475NoneMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS475 == "None" && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);
            List<INCDTLS2026.Rp_Partnerships> incdtls475NullMatches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => string.IsNullOrWhiteSpace(tuple.INCDTLS475) && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls391Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS391.GetValueOrDefault() > 0 && tuple.INCDTLS387.GetValueOrDefault() == 1) : null);
            List<INCDTLS2026.Rp_ManagedFunds> incdtls421Matches = (incdtlschilddoc.Rp_ManagedFundsCollection != null ? incdtlschilddoc.Rp_ManagedFundsCollection.FindAll(tuple => tuple.INCDTLS421.GetValueOrDefault() > 0 && tuple.INCDTLS387.GetValueOrDefault() > 1) : null);
            decimal sumINCDTLS256 = incdtlschilddoc.Rp_TrustIncomeCollection != null ? incdtlschilddoc.Rp_TrustIncomeCollection.Sum(tuple => tuple.INCDTLS256.GetValueOrDefault()) : 0;

            bool assertion = report.iitrParentDocument.IITR266 == "Part" && Count(incdtls475PartMatches) == 0 && (Count(incdtls475AllMatches) == 0 || (Count(incdtls475NoneMatches) == 0 && Count(incdtls475NullMatches) == 0 && (sumINCDTLS256 == 0) && Count(incdtls391Matches) == 0 && Count(incdtls421Matches) == 0));

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730486",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type of ""Part"" is selected; at least one instance of Non-primary production deduction loss type from partnership in the attached Income Details schedule must be populated with ""Part"", or; at least one instance of Non-Primary production deduction loss type from partnership must be populated with ""All"" and either, at least one other instance of Non-primary production deduction loss type from partnership is populated with ""None"" (or blank), or a positive amount is provided for Non-primary production other deductions from trusts or Other deductions for non-primary production distributions from managed funds, in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730486" },
                        new ProcessMessageParameter() { Name = "IITR266", Value = report.iitrParentDocument.IITR266 },
                        new ProcessMessageParameter() { Name = "Sum([incdtls256])", Value = sumINCDTLS256.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730486

        #region VR.ATO.IITR.730487

        /* VR.ATO.IITR.730487
            Where Other deductions relating to amounts shown at "Distribution from partnerships less foreign income", "Share of net income from trusts less capital gains, foreign income and franked distributions" and "Franked distributions from trusts" type is not provided, all instances of Non-primary production deduction loss type from partnership must be populated with "None" (or blank), in the attached Income Details schedule

        Legacy Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = NULL AND (AnyOccurrence(^INCDTLS475, ^INCDTLS475 <> 'None') WHERE (^INCDTLS475 <> NULL AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0)))

        Technical Business Rule Format:
            CountDocument('INCDTLS') = 1 AND ^IITR266 = NULL AND (AnyOccurrence(^INCDTLS475, ^INCDTLS475 <> 'None') WHERE (^INCDTLS475 <> NULL AND (^INCDTLS476 > 0 OR ^INCDTLS477 > 0 OR ^INCDTLS478 > 0)))

        Data Elements:
    
            ^IITR266 = RP:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code
    
            ^INCDTLS475 = INCDTLS475
    
            ^INCDTLS476 = INCDTLS476
    
            ^INCDTLS477 = INCDTLS477
    
            ^INCDTLS478 = INCDTLS478
        */

        public static ProcessMessageDocument VR_ATO_IITR_730487(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;

            List<INCDTLS2026.Rp_Partnerships> incdtls475matches = (incdtlschilddoc.Rp_PartnershipsCollection != null ? incdtlschilddoc.Rp_PartnershipsCollection.FindAll(tuple => tuple.INCDTLS475 != null && tuple.INCDTLS475 != "None" && (tuple.INCDTLS476.GetValueOrDefault() > 0 || tuple.INCDTLS477.GetValueOrDefault() > 0 || tuple.INCDTLS478.GetValueOrDefault() > 0)) : null);

            bool assertion = report.iitrParentDocument.IITR266 == null && Count(incdtls475matches) > 0;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730487",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type is incorrect",
                    LongDescription = @"Where Other deductions relating to amounts shown at ""Distribution from partnerships less foreign income"", ""Share of net income from trusts less capital gains, foreign income and franked distributions"" and ""Franked distributions from trusts"" type is not provided, all instances of Non-primary production deduction loss type from partnership must be populated with ""None"" (or blank), in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730487" },
                    },
                };
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730487

        #region VR.ATO.IITR.730488

        /* VR.ATO.IITR.730488
                    Where any summary income amounts are present, the details must be provided in the Income Details schedule

                Legacy Rule Format:
                    CountDocument('INCDTLS') = 0 AND (^IITR601 > 0 OR ^IITR64 > 0 OR ^IITR606 > 0 OR ^IITR607 > 0 OR ^IITR608 > 0 OR ^IITR609 > 0 OR ^IITR65 > 0 OR ^IITR85 > 0 OR ^IITR88 > 0 OR ^IITR89 > 0 OR ^IITR91 > 0 OR ^IITR92 > 0 OR ^IITR93 > 0 OR ^IITR94 > 0 OR ^IITR95 > 0 OR ^IITR111 > 0 OR ^IITR112 > 0 OR ^IITR115 > 0 OR ^IITR116 > 0 OR ^IITR118 > 0 OR ^IITR119 > 0 OR ^IITR120 > 0 OR ^IITR121 > 0 OR ^IITR123 > 0 OR ^IITR124 > 0 OR ^IITR125 > 0 OR ^IITR128 > 0 OR ^IITR129 > 0 OR ^IITR166 > 0 OR ^IITR490 > 0 OR ^IITR491 > 0 OR ^IITR201 > 0 OR ^IITR242 > 0 OR ^IITR243 > 0 OR ^IITR245 > 0 OR ^IITR249 > 0 OR ^IITR250 > 0 OR ^IITR251 > 0 OR ^IITR255 > 0 OR ^IITR259 > 0 OR ^IITR260 > 0 OR ^IITR262 > 0 OR ^IITR263 > 0 OR ^IITR264 > 0 OR ^IITR271 > 0 OR ^IITR272 > 0 OR ^IITR273 > 0 OR ^IITR274 > 0 OR ^IITR286 > 0 OR ^IITR287 > 0 OR ^IITR288 > 0 OR ^IITR289 > 0 OR ^IITR316 > 0 OR ^IITR318 > 0 OR ^IITR320 > 0 OR ^IITR321 > 0 OR ^IITR322 > 0 OR ^IITR323 > 0 OR ^IITR324 > 0 OR ^IITR325 > 0 OR ^IITR326 > 0 OR ^IITR328 > 0 OR ^IITR330 > 0 OR ^IITR331 > 0 OR ^IITR339 > 0 OR ^IITR341 > 0 OR ^IITR358 > 0 OR ^IITR495 > 0 OR ^IITR496 > 0 OR ^IITR411 > 0 OR ^IITR412 > 0 OR ^IITR413 > 0 OR ^IITR436 > 0 OR ^IITR437 > 0 OR ^IITR438 > 0 OR ^IITR439 > 0 OR ^IITR440 > 0 OR ^IITR441 > 0 OR ^IITR442 > 0 OR ^IITR625 > 0 OR ^IITR626 > 0 OR ^IITR615 > 0 OR ^IITR616 > 0 OR ^IITR600 > 0 OR ^IITR602 > 0 OR ^IITR610 > 0 OR ^IITR611 > 0 OR ^IITR612 > 0 OR ^IITR613 > 0 OR ^IITR614 > 0 OR ^IITR617 > 0 OR ^IITR618 > 0 OR ^IITR268 > 0 OR ^IITR269 > 0 OR ^IITR270 > 0 OR ^IITR246 > 0 OR ^IITR355 > 0 OR ^IITR261 > 0 OR ^IITR276 > 0 OR ^IITR277 > 0 OR ^IITR278 > 0 OR ^IITR321 < 0 OR ^IITR322 < 0 OR ^IITR323 < 0 OR ^IITR324 < 0 OR ^IITR325 < 0 OR ^IITR326 < 0 OR ^IITR242 < 0 OR ^IITR243 < 0 OR ^IITR249 < 0 OR ^IITR250 < 0 OR ^IITR251 < 0 OR ^IITR255 < 0 OR ^IITR86 > ^IITR602)

            Technical Business Rule Format:
                    CountDocument('INCDTLS') = 0 AND (^IITR601 > 0 OR ^IITR64 > 0 OR ^IITR606 > 0 OR ^IITR607 > 0 OR ^IITR608 > 0 OR ^IITR609 > 0 OR ^IITR65 > 0 OR ^IITR85 > 0 OR ^IITR88 > 0 OR ^IITR89 > 0 OR ^IITR91 > 0 OR ^IITR92 > 0 OR ^IITR93 > 0 OR ^IITR94 > 0 OR ^IITR95 > 0 OR ^IITR111 > 0 OR ^IITR112 > 0 OR ^IITR115 > 0 OR ^IITR116 > 0 OR ^IITR118 > 0 OR ^IITR119 > 0 OR ^IITR120 > 0 OR ^IITR121 > 0 OR ^IITR123 > 0 OR ^IITR124 > 0 OR ^IITR125 > 0 OR ^IITR128 > 0 OR ^IITR129 > 0 OR ^IITR166 > 0 OR ^IITR490 > 0 OR ^IITR491 > 0 OR ^IITR201 > 0 OR ^IITR242 > 0 OR ^IITR243 > 0 OR ^IITR245 > 0 OR ^IITR249 > 0 OR ^IITR250 > 0 OR ^IITR251 > 0 OR ^IITR255 > 0 OR ^IITR259 > 0 OR ^IITR260 > 0 OR ^IITR262 > 0 OR ^IITR263 > 0 OR ^IITR264 > 0 OR ^IITR271 > 0 OR ^IITR272 > 0 OR ^IITR273 > 0 OR ^IITR274 > 0 OR ^IITR286 > 0 OR ^IITR287 > 0 OR ^IITR288 > 0 OR ^IITR289 > 0 OR ^IITR316 > 0 OR ^IITR318 > 0 OR ^IITR320 > 0 OR ^IITR321 > 0 OR ^IITR322 > 0 OR ^IITR323 > 0 OR ^IITR324 > 0 OR ^IITR325 > 0 OR ^IITR326 > 0 OR ^IITR328 > 0 OR ^IITR330 > 0 OR ^IITR331 > 0 OR ^IITR339 > 0 OR ^IITR341 > 0 OR ^IITR358 > 0 OR ^IITR495 > 0 OR ^IITR496 > 0 OR ^IITR411 > 0 OR ^IITR412 > 0 OR ^IITR413 > 0 OR ^IITR436 > 0 OR ^IITR437 > 0 OR ^IITR438 > 0 OR ^IITR439 > 0 OR ^IITR440 > 0 OR ^IITR441 > 0 OR ^IITR442 > 0 OR ^IITR625 > 0 OR ^IITR626 > 0 OR ^IITR615 > 0 OR ^IITR616 > 0 OR ^IITR600 > 0 OR ^IITR602 > 0 OR ^IITR610 > 0 OR ^IITR611 > 0 OR ^IITR612 > 0 OR ^IITR613 > 0 OR ^IITR614 > 0 OR ^IITR617 > 0 OR ^IITR618 > 0 OR ^IITR268 > 0 OR ^IITR269 > 0 OR ^IITR270 > 0 OR ^IITR246 > 0 OR ^IITR355 > 0 OR ^IITR261 > 0 OR ^IITR276 > 0 OR ^IITR277 > 0 OR ^IITR278 > 0 OR ^IITR321 < 0 OR ^IITR322 < 0 OR ^IITR323 < 0 OR ^IITR324 < 0 OR ^IITR325 < 0 OR ^IITR326 < 0 OR ^IITR242 < 0 OR ^IITR243 < 0 OR ^IITR249 < 0 OR ^IITR250 < 0 OR ^IITR251 < 0 OR ^IITR255 < 0 OR ^IITR86 > ^IITR602)

        Data Elements:
    
            ^IITR601 = RP:Income.SalaryOrWages.Amount
    
            ^IITR64 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount
    
            ^IITR65 = RP:Income.AllowancesEarningsTipsDirectorsFees.Amount
    
            ^IITR85 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentAllowancesAndPayments.Amount
    
            ^IITR86 = RP:Income.AustralianGovernmentAllowancesAndPayments.Amount
    
            ^IITR88 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount
    
            ^IITR89 = RP:Pension.Total.Amount
    
            ^IITR91 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount
    
            ^IITR92 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount
    
            ^IITR93 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount
    
            ^IITR94 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount
    
            ^IITR95 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount
    
            ^IITR111 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount
    
            ^IITR112 = RP:Income.PersonalServicesIncome.Total.Amount
    
            ^IITR115 = RP:Income.Interest.Gross.Amount
    
            ^IITR116 = RP:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
    
            ^IITR118 = RP:Income.DividendsUnfranked.Amount
    
            ^IITR119 = RP:Income.DividendsFranked.Amount
    
            ^IITR120 = RP:IncomeTax.FrankingCredits.Amount
    
            ^IITR121 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount
    
            ^IITR123 = RP:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount
    
            ^IITR124 = RP:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount
    
            ^IITR125 = RP:Income.EmployeeShareScheme.DeferralDiscount.Amount
    
            ^IITR128 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount
    
            ^IITR129 = RP:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount
    
            ^IITR166 = RP:TaxOffsetClaim.SuperannuationIncomeStream.Amount
    
            ^IITR201 = RP:SuperannuationContribution.EmployerReportable.Amount
    
            ^IITR242 = RP:Income.PartnershipPrimaryProductionShare.Amount
    
            ^IITR243 = RP:Income.TrustPrimaryProductionNetShare.Amount
    
            ^IITR245 = RP.Partnership:Expense.LandcareOperationsAcceleratedDepreciation.Amount
    
            ^IITR246 = RP:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
    
            ^IITR249 = RP:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount
    
            ^IITR250 = RP:Income.PartnershipRentalNonPrimaryProductionShare.Amount
    
            ^IITR251 = RP:Income.PartnershipNonPrimaryProductionOtherShare.Amount
    
            ^IITR255 = RP:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount
    
            ^IITR259 = RP:Income.TrustFrankedNonPrimaryProductionShare.Amount
    
            ^IITR260 = RP:Expense.LandcareOperationsNonPrimaryProduction.Amount
    
            ^IITR261 = RP:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount
    
            ^IITR262 = RP:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount
    
            ^IITR263 = RP:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount
    
            ^IITR264 = RP:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount
    
            ^IITR268 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
    
            ^IITR269 = RP:IncomeTax.FrankingCreditsShare.Amount
    
            ^IITR270 = RP:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount
    
            ^IITR271 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount
    
            ^IITR272 = RP:IncomeTax.CreditTrusteeTaxPaidShare.Amount
    
            ^IITR273 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount
    
            ^IITR274 = RP:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount
    
            ^IITR276 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeVoluntaryAgreement.Amount
    
            ^IITR277 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeABNNotQuoted.Amount
    
            ^IITR278 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeLabourHireOrOtherPayments.Amount
    
            ^IITR286 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount
    
            ^IITR287 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessABNNotQuoted.Amount
    
            ^IITR288 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessForeignResident.Amount
    
            ^IITR289 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount
    
            ^IITR316 = RP:Income.ControlledForeignCompaniesAttributableIncome.Amount
    
            ^IITR318 = RP:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
    
            ^IITR320 = RP:InternationalDealings.ForeignIncomeGross.Amount
    
            ^IITR321 = RP:InternationalDealings.ForeignEmploymentIncomeOther.Amount
    
            ^IITR322 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeWithoutUndeductedPurchasePrice.Amount
    
            ^IITR323 = RP:InternationalDealings.ForeignPensionOrAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^IITR324 = RP:InternationalDealings.ForeignRent.Amount
    
            ^IITR325 = RP:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount
    
            ^IITR326 = RP:InternationalDealings.ForeignSourceIncomeOther.Amount
    
            ^IITR328 = RP:IncomeTax.FrankingCreditsNewZealand.Amount
    
            ^IITR330 = RP:InternationalDealings.ExemptForeignEmploymentIncome.Amount
    
            ^IITR331 = RP:Income.InternationalDealings.TaxOffset.Amount
    
            ^IITR339 = RP:IncomeTax.LifeInsuranceCompaniesAndFriendlySocietiesBonuses.Amount
    
            ^IITR341 = RP:Income.ForestryManagedInvestmentScheme.Amount
    
            ^IITR355 = RP:Income.SpecialProfessional.Amount
    
            ^IITR358 = RP:IncomeTax.Deduction.ForeignPensionAnnuityIncomeUndeductedPurchasePrice.Amount
    
            ^IITR411 = RP:Income.PersonalServicesIncome.VoluntaryAgreement.Amount
    
            ^IITR412 = RP:Income.PersonalServicesIncome.ABNNotQuoted.Amount
    
            ^IITR413 = RP:Income.PersonalServicesIncome.LabourHireOrOtherSpecifiedPayment.Amount
    
            ^IITR436 = RP:Income.ABNNotQuotedPrimaryProductionPaymentGross.Amount
    
            ^IITR437 = RP:Income.ABNNotQuotedNonPrimaryProductionPaymentGross.Amount
    
            ^IITR438 = RP:Income.ForeignResidentWithholdingNonPrimaryProduction.Amount
    
            ^IITR439 = RP:Income.VoluntaryAgreementPrimaryProductionGross.Amount
    
            ^IITR440 = RP:Income.VoluntaryAgreementNonPrimaryProductionGross.Amount
    
            ^IITR441 = RP:Income.LabourHireArrangementPrimaryProductionPaymentGross.Amount
    
            ^IITR442 = RP:Income.LabourHireArrangementNonPrimaryProductionPaymentGross.Amount
    
            ^IITR490 = RP.Eligible:Income.FringeBenefitsReportable.Amount
    
            ^IITR491 = RP.Ineligible:Income.FringeBenefitsReportable.Amount
    
            ^IITR495 = RP.LimitedPartners:TaxOffsetClaim.NonRefundableOther.Amount
    
            ^IITR496 = RP.Investor:TaxOffsetClaim.NonRefundableOther.Amount
    
            ^IITR600 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount
    
            ^IITR602 = RP:Income.CommunityDevelopmentEmploymentProject.Amount
    
            ^IITR606 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^IITR607 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
    
            ^IITR608 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^IITR609 = RP:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
    
            ^IITR610 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount
    
            ^IITR611 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount
    
            ^IITR612 = RP:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount
    
            ^IITR613 = RP:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
    
            ^IITR614 = RP:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount
    
            ^IITR615 = RP:IncomeTax.IncomeCategory1Other.Amount
    
            ^IITR616 = RP:IncomeTax.IncomeCategory2Total.Amount
    
            ^IITR617 = RP:IncomeTax.FinancialInvestmentsOther.Amount
    
            ^IITR618 = RP:IncomeTax.IncomeCategoryMiscellaneousOther.Amount
    
            ^IITR625 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount
    
            ^IITR626 = RP:Income.EmploymentTerminationPaymentTaxable.Amount
            */
        public static ProcessMessageDocument VR_ATO_IITR_730488(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion = false;
            
            bool incdtlschilddocNotProvided = incdtlschilddoc == null;

            List<decimal?> incomeValuesNegative = new List<decimal?>
            {
                report.iitrParentDocument.IITR601,
                report.iitrParentDocument.IITR64,
                report.iitrParentDocument.IITR606,
                report.iitrParentDocument.IITR607,
                report.iitrParentDocument.IITR608,
                report.iitrParentDocument.IITR609,
                report.iitrParentDocument.IITR65,
                report.iitrParentDocument.IITR85,
                report.iitrParentDocument.IITR88,
                report.iitrParentDocument.IITR89,
                report.iitrParentDocument.IITR91,
                report.iitrParentDocument.IITR92,
                report.iitrParentDocument.IITR93,
                report.iitrParentDocument.IITR94,
                report.iitrParentDocument.IITR95,
                report.iitrParentDocument.IITR111,
                report.iitrParentDocument.IITR112,
                report.iitrParentDocument.IITR115,
                report.iitrParentDocument.IITR116,
                report.iitrParentDocument.IITR118,
                report.iitrParentDocument.IITR119,
                report.iitrParentDocument.IITR120,
                report.iitrParentDocument.IITR121,
                report.iitrParentDocument.IITR123,
                report.iitrParentDocument.IITR124,
                report.iitrParentDocument.IITR125,
                report.iitrParentDocument.IITR128,
                report.iitrParentDocument.IITR129,
                report.iitrParentDocument.IITR166,
                report.iitrParentDocument.IITR490,
                report.iitrParentDocument.IITR491,
                report.iitrParentDocument.IITR201,
                report.iitrParentDocument.IITR242,
                report.iitrParentDocument.IITR243,
                report.iitrParentDocument.IITR245,
                report.iitrParentDocument.IITR249,
                report.iitrParentDocument.IITR250,
                report.iitrParentDocument.IITR251,
                report.iitrParentDocument.IITR255,
                report.iitrParentDocument.IITR259,
                report.iitrParentDocument.IITR260,
                report.iitrParentDocument.IITR262,
                report.iitrParentDocument.IITR263,
                report.iitrParentDocument.IITR264,
                report.iitrParentDocument.IITR271,
                report.iitrParentDocument.IITR272,
                report.iitrParentDocument.IITR273,
                report.iitrParentDocument.IITR274,
                report.iitrParentDocument.IITR286,
                report.iitrParentDocument.IITR287,
                report.iitrParentDocument.IITR288,
                report.iitrParentDocument.IITR289,
                report.iitrParentDocument.IITR316,
                report.iitrParentDocument.IITR318,
                report.iitrParentDocument.IITR320,
                report.iitrParentDocument.IITR321,
                report.iitrParentDocument.IITR322,
                report.iitrParentDocument.IITR323,
                report.iitrParentDocument.IITR324,
                report.iitrParentDocument.IITR325,
                report.iitrParentDocument.IITR326,
                report.iitrParentDocument.IITR328,
                report.iitrParentDocument.IITR330,
                report.iitrParentDocument.IITR331,
                report.iitrParentDocument.IITR339,
                report.iitrParentDocument.IITR341,
                report.iitrParentDocument.IITR358,
                report.iitrParentDocument.IITR495,
                report.iitrParentDocument.IITR496,
                report.iitrParentDocument.IITR411,
                report.iitrParentDocument.IITR412,
                report.iitrParentDocument.IITR413,
                report.iitrParentDocument.IITR436,
                report.iitrParentDocument.IITR437,
                report.iitrParentDocument.IITR438,
                report.iitrParentDocument.IITR439,
                report.iitrParentDocument.IITR440,
                report.iitrParentDocument.IITR441,
                report.iitrParentDocument.IITR442,
                report.iitrParentDocument.IITR625,
                report.iitrParentDocument.IITR626,
                report.iitrParentDocument.IITR615,
                report.iitrParentDocument.IITR616,
                report.iitrParentDocument.IITR600,
                report.iitrParentDocument.IITR602,
                report.iitrParentDocument.IITR610,
                report.iitrParentDocument.IITR611,
                report.iitrParentDocument.IITR612,
                report.iitrParentDocument.IITR613,
                report.iitrParentDocument.IITR614,
                report.iitrParentDocument.IITR617,
                report.iitrParentDocument.IITR618,
                report.iitrParentDocument.IITR268,
                report.iitrParentDocument.IITR269,
                report.iitrParentDocument.IITR270,
                report.iitrParentDocument.IITR246,
                report.iitrParentDocument.IITR355,
                report.iitrParentDocument.IITR261,
                report.iitrParentDocument.IITR276,
                report.iitrParentDocument.IITR277,
                report.iitrParentDocument.IITR278
            };

            List<decimal?> incomeValuesPositive = new List<decimal?>
            { 
                report.iitrParentDocument.IITR321,
                report.iitrParentDocument.IITR322,
                report.iitrParentDocument.IITR323,
                report.iitrParentDocument.IITR324,
                report.iitrParentDocument.IITR325,
                report.iitrParentDocument.IITR326,
                report.iitrParentDocument.IITR242,
                report.iitrParentDocument.IITR243,
                report.iitrParentDocument.IITR249,
                report.iitrParentDocument.IITR250,
                report.iitrParentDocument.IITR251,
                report.iitrParentDocument.IITR255
            };

            bool govtAllowanceAndPaymentsValid = report.iitrParentDocument.IITR86 > report.iitrParentDocument.IITR602;
            if (incdtlschilddocNotProvided)
            {
                assertion = incomeValuesNegative.Any(x => x > 0) ||
                    incomeValuesPositive.Any(x => x < 0) ||
                    govtAllowanceAndPaymentsValid;
            }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730488",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Income Details schedule must be provided",
                    LongDescription = "Where any summary income amounts are present, the details must be provided in the Income Details schedule",
                    Location = "/xbrli:xbrl/tns:Income.SalaryOrWages.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730488" },
                        new ProcessMessageParameter() { Name = "COUNT(SCHEDULE = \"INCDTLS\") = 0", Value = incdtlschilddocNotProvided.ToString() },
                        new ProcessMessageParameter() { Name = " IITR601 ", Value = report.iitrParentDocument.IITR601.ToString() },
                        new ProcessMessageParameter() { Name = " IITR64 ", Value = report.iitrParentDocument.IITR64.ToString() },
                        new ProcessMessageParameter() { Name = " IITR606 ", Value = report.iitrParentDocument.IITR606.ToString() },
                        new ProcessMessageParameter() { Name = " IITR607 ", Value = report.iitrParentDocument.IITR607.ToString() },
                        new ProcessMessageParameter() { Name = " IITR608 ", Value = report.iitrParentDocument.IITR608.ToString() },
                        new ProcessMessageParameter() { Name = " IITR609 ", Value = report.iitrParentDocument.IITR609.ToString() },
                        new ProcessMessageParameter() { Name = " IITR65 ", Value = report.iitrParentDocument.IITR65.ToString() },
                        new ProcessMessageParameter() { Name = " IITR85 ", Value = report.iitrParentDocument.IITR85.ToString() },
                        new ProcessMessageParameter() { Name = " IITR88 ", Value = report.iitrParentDocument.IITR88.ToString() },
                        new ProcessMessageParameter() { Name = " IITR89 ", Value = report.iitrParentDocument.IITR89.ToString() },
                        new ProcessMessageParameter() { Name = " IITR91 ", Value = report.iitrParentDocument.IITR91.ToString() },
                        new ProcessMessageParameter() { Name = " IITR92 ", Value = report.iitrParentDocument.IITR92.ToString() },
                        new ProcessMessageParameter() { Name = " IITR93 ", Value = report.iitrParentDocument.IITR93.ToString() },
                        new ProcessMessageParameter() { Name = " IITR94 ", Value = report.iitrParentDocument.IITR94.ToString() },
                        new ProcessMessageParameter() { Name = " IITR95 ", Value = report.iitrParentDocument.IITR95.ToString() },
                        new ProcessMessageParameter() { Name = " IITR111 ", Value = report.iitrParentDocument.IITR111.ToString() },
                        new ProcessMessageParameter() { Name = " IITR112 ", Value = report.iitrParentDocument.IITR112.ToString() },
                        new ProcessMessageParameter() { Name = " IITR115 ", Value = report.iitrParentDocument.IITR115.ToString() },
                        new ProcessMessageParameter() { Name = " IITR116 ", Value = report.iitrParentDocument.IITR116.ToString() },
                        new ProcessMessageParameter() { Name = " IITR118 ", Value = report.iitrParentDocument.IITR118.ToString() },
                        new ProcessMessageParameter() { Name = " IITR119 ", Value = report.iitrParentDocument.IITR119.ToString() },
                        new ProcessMessageParameter() { Name = " IITR120 ", Value = report.iitrParentDocument.IITR120.ToString() },
                        new ProcessMessageParameter() { Name = " IITR121 ", Value = report.iitrParentDocument.IITR121.ToString() },
                        new ProcessMessageParameter() { Name = " IITR123 ", Value = report.iitrParentDocument.IITR123.ToString() },
                        new ProcessMessageParameter() { Name = " IITR124 ", Value = report.iitrParentDocument.IITR124.ToString() },
                        new ProcessMessageParameter() { Name = " IITR125 ", Value = report.iitrParentDocument.IITR125.ToString() },
                        new ProcessMessageParameter() { Name = " IITR128 ", Value = report.iitrParentDocument.IITR128.ToString() },
                        new ProcessMessageParameter() { Name = " IITR129 ", Value = report.iitrParentDocument.IITR129.ToString() },
                        new ProcessMessageParameter() { Name = " IITR166 ", Value = report.iitrParentDocument.IITR166.ToString() },
                        new ProcessMessageParameter() { Name = " IITR490 ", Value = report.iitrParentDocument.IITR490.ToString() },
                        new ProcessMessageParameter() { Name = " IITR491 ", Value = report.iitrParentDocument.IITR491.ToString() },
                        new ProcessMessageParameter() { Name = " IITR201 ", Value = report.iitrParentDocument.IITR201.ToString() },
                        new ProcessMessageParameter() { Name = " IITR242 ", Value = report.iitrParentDocument.IITR242.ToString() },
                        new ProcessMessageParameter() { Name = " IITR243 ", Value = report.iitrParentDocument.IITR243.ToString() },
                        new ProcessMessageParameter() { Name = " IITR245 ", Value = report.iitrParentDocument.IITR245.ToString() },
                        new ProcessMessageParameter() { Name = " IITR249 ", Value = report.iitrParentDocument.IITR249.ToString() },
                        new ProcessMessageParameter() { Name = " IITR250 ", Value = report.iitrParentDocument.IITR250.ToString() },
                        new ProcessMessageParameter() { Name = " IITR251 ", Value = report.iitrParentDocument.IITR251.ToString() },
                        new ProcessMessageParameter() { Name = " IITR255 ", Value = report.iitrParentDocument.IITR255.ToString() },
                        new ProcessMessageParameter() { Name = " IITR259 ", Value = report.iitrParentDocument.IITR259.ToString() },
                        new ProcessMessageParameter() { Name = " IITR260 ", Value = report.iitrParentDocument.IITR260.ToString() },
                        new ProcessMessageParameter() { Name = " IITR262 ", Value = report.iitrParentDocument.IITR262.ToString() },
                        new ProcessMessageParameter() { Name = " IITR263 ", Value = report.iitrParentDocument.IITR263.ToString() },
                        new ProcessMessageParameter() { Name = " IITR264 ", Value = report.iitrParentDocument.IITR264.ToString() },
                        new ProcessMessageParameter() { Name = " IITR271 ", Value = report.iitrParentDocument.IITR271.ToString() },
                        new ProcessMessageParameter() { Name = " IITR272 ", Value = report.iitrParentDocument.IITR272.ToString() },
                        new ProcessMessageParameter() { Name = " IITR273 ", Value = report.iitrParentDocument.IITR273.ToString() },
                        new ProcessMessageParameter() { Name = " IITR274 ", Value = report.iitrParentDocument.IITR274.ToString() },
                        new ProcessMessageParameter() { Name = " IITR286 ", Value = report.iitrParentDocument.IITR286.ToString() },
                        new ProcessMessageParameter() { Name = " IITR287 ", Value = report.iitrParentDocument.IITR287.ToString() },
                        new ProcessMessageParameter() { Name = " IITR288 ", Value = report.iitrParentDocument.IITR288.ToString() },
                        new ProcessMessageParameter() { Name = " IITR289 ", Value = report.iitrParentDocument.IITR289.ToString() },
                        new ProcessMessageParameter() { Name = " IITR316 ", Value = report.iitrParentDocument.IITR316.ToString() },
                        new ProcessMessageParameter() { Name = " IITR318 ", Value = report.iitrParentDocument.IITR318.ToString() },
                        new ProcessMessageParameter() { Name = " IITR320 ", Value = report.iitrParentDocument.IITR320.ToString() },
                        new ProcessMessageParameter() { Name = " IITR321 ", Value = report.iitrParentDocument.IITR321.ToString() },
                        new ProcessMessageParameter() { Name = " IITR322 ", Value = report.iitrParentDocument.IITR322.ToString() },
                        new ProcessMessageParameter() { Name = " IITR323 ", Value = report.iitrParentDocument.IITR323.ToString() },
                        new ProcessMessageParameter() { Name = " IITR324 ", Value = report.iitrParentDocument.IITR324.ToString() },
                        new ProcessMessageParameter() { Name = " IITR325 ", Value = report.iitrParentDocument.IITR325.ToString() },
                        new ProcessMessageParameter() { Name = " IITR326 ", Value = report.iitrParentDocument.IITR326.ToString() },
                        new ProcessMessageParameter() { Name = " IITR328 ", Value = report.iitrParentDocument.IITR328.ToString() },
                        new ProcessMessageParameter() { Name = " IITR330 ", Value = report.iitrParentDocument.IITR330.ToString() },
                        new ProcessMessageParameter() { Name = " IITR331 ", Value = report.iitrParentDocument.IITR331.ToString() },
                        new ProcessMessageParameter() { Name = " IITR339 ", Value = report.iitrParentDocument.IITR339.ToString() },
                        new ProcessMessageParameter() { Name = " IITR341 ", Value = report.iitrParentDocument.IITR341.ToString() },
                        new ProcessMessageParameter() { Name = " IITR358 ", Value = report.iitrParentDocument.IITR358.ToString() },
                        new ProcessMessageParameter() { Name = " IITR495 ", Value = report.iitrParentDocument.IITR495.ToString() },
                        new ProcessMessageParameter() { Name = " IITR496 ", Value = report.iitrParentDocument.IITR496.ToString() },
                        new ProcessMessageParameter() { Name = " IITR411 ", Value = report.iitrParentDocument.IITR411.ToString() },
                        new ProcessMessageParameter() { Name = " IITR412 ", Value = report.iitrParentDocument.IITR412.ToString() },
                        new ProcessMessageParameter() { Name = " IITR413 ", Value = report.iitrParentDocument.IITR413.ToString() },
                        new ProcessMessageParameter() { Name = " IITR436 ", Value = report.iitrParentDocument.IITR436.ToString() },
                        new ProcessMessageParameter() { Name = " IITR437 ", Value = report.iitrParentDocument.IITR437.ToString() },
                        new ProcessMessageParameter() { Name = " IITR438 ", Value = report.iitrParentDocument.IITR438.ToString() },
                        new ProcessMessageParameter() { Name = " IITR439 ", Value = report.iitrParentDocument.IITR439.ToString() },
                        new ProcessMessageParameter() { Name = " IITR440 ", Value = report.iitrParentDocument.IITR440.ToString() },
                        new ProcessMessageParameter() { Name = " IITR441 ", Value = report.iitrParentDocument.IITR441.ToString() },
                        new ProcessMessageParameter() { Name = " IITR442 ", Value = report.iitrParentDocument.IITR442.ToString() },
                        new ProcessMessageParameter() { Name = " IITR625 ", Value = report.iitrParentDocument.IITR625.ToString() },
                        new ProcessMessageParameter() { Name = " IITR626 ", Value = report.iitrParentDocument.IITR626.ToString() },
                        new ProcessMessageParameter() { Name = " IITR615 ", Value = report.iitrParentDocument.IITR615.ToString() },
                        new ProcessMessageParameter() { Name = " IITR616 ", Value = report.iitrParentDocument.IITR616.ToString() },
                        new ProcessMessageParameter() { Name = " IITR600 ", Value = report.iitrParentDocument.IITR600.ToString() },
                        new ProcessMessageParameter() { Name = " IITR602 ", Value = report.iitrParentDocument.IITR602.ToString() },
                        new ProcessMessageParameter() { Name = " IITR610 ", Value = report.iitrParentDocument.IITR610.ToString() },
                        new ProcessMessageParameter() { Name = " IITR611 ", Value = report.iitrParentDocument.IITR611.ToString() },
                        new ProcessMessageParameter() { Name = " IITR612 ", Value = report.iitrParentDocument.IITR612.ToString() },
                        new ProcessMessageParameter() { Name = " IITR613 ", Value = report.iitrParentDocument.IITR613.ToString() },
                        new ProcessMessageParameter() { Name = " IITR614 ", Value = report.iitrParentDocument.IITR614.ToString() },
                        new ProcessMessageParameter() { Name = " IITR617 ", Value = report.iitrParentDocument.IITR617.ToString() },
                        new ProcessMessageParameter() { Name = " IITR618 ", Value = report.iitrParentDocument.IITR618.ToString() },
                        new ProcessMessageParameter() { Name = " IITR268 ", Value = report.iitrParentDocument.IITR268.ToString() },
                        new ProcessMessageParameter() { Name = " IITR269 ", Value = report.iitrParentDocument.IITR269.ToString() },
                        new ProcessMessageParameter() { Name = " IITR270 ", Value = report.iitrParentDocument.IITR270.ToString() }, 
                        new ProcessMessageParameter() { Name = " IITR246 ", Value = report.iitrParentDocument.IITR246.ToString() },
                        new ProcessMessageParameter() { Name = " IITR355 ", Value = report.iitrParentDocument.IITR355.ToString() },
                        new ProcessMessageParameter() { Name = " IITR261 ", Value = report.iitrParentDocument.IITR261.ToString() },
                        new ProcessMessageParameter() { Name = " IITR276 ", Value = report.iitrParentDocument.IITR276.ToString() },
                        new ProcessMessageParameter() { Name = " IITR277 ", Value = report.iitrParentDocument.IITR277.ToString() },
                        new ProcessMessageParameter() { Name = " IITR278 ", Value = report.iitrParentDocument.IITR278.ToString() }, 
                        new ProcessMessageParameter() { Name = "IITR86 > IITR602", Value = govtAllowanceAndPaymentsValid.ToString() },
                    },
                };
            }
            return processMessage;
        }

        #endregion VR.ATO.IITR.730487

        #region VR.ATO.IITR.730491

        /* VR.ATO.IITR.730491
            Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of "003" (voluntary agreement) and Business income statement type is "Personal Services Income", then Tax withheld - voluntary agreement must be provided

        Legacy Rule Format:
            ^IITR276 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
            ^IITR276 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income')

        Data Elements:
    
            ^IITR276 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeVoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730491(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR276.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Personal Services Income");

            bool assertion = !report.iitrParentDocument.IITR276.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730491",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld - voluntary agreement must be provided",
                    LongDescription = "Where any Business income statement tax withheld amount is provided on the attached Income Details schedule with a Business income statement payment type of \"003\" (voluntary agreement) and Business income statement type is \"Personal Services Income\", then Tax withheld - voluntary agreement must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeVoluntaryAgreement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730491" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.730491

        #region VR.ATO.IITR.730492

        /* VR.ATO.IITR.730492
            The Tax withheld - voluntary agreement amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "003" (voluntary agreement) and Business income statement type is “Personal Services Income” in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR276 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR276 <> (Sum(ConditionalValue(^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR276 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR276 <> (Sum(ConditionalValue(^INCDTLS489 = '003' AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR276 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeVoluntaryAgreement.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730492(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR276IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR276NotEqualsSum = false;

            // Condition 1: [iitr276] <> NULL
            condition1_IITR276IsNotNull = report.iitrParentDocument.IITR276 != null;

            // Condition 3 Sum: (SUM(ConditionalValue([incdtls489] = "003" AND [incdtls490] = "Personal Services Income", [incdtls493], 0)))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "003" && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr276] <> (SUM(ConditionalValue([incdtls489] = "003" AND [incdtls490] = "Personal Services Income", [incdtls493], 0)))
            condition3_IITR276NotEqualsSum = report.iitrParentDocument.IITR276.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR276IsNotNull && condition2_INCDTLSExists && condition3_IITR276NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730492",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld - voluntary agreement is incorrect",
                    LongDescription = "The Tax withheld - voluntary agreement amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"003\" (voluntary agreement) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeVoluntaryAgreement.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730492" },
                        new ProcessMessageParameter() { Name = "IITR276", Value = report.iitrParentDocument.IITR276.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated sum of INCDTLS493 when conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730492

        #region VR.ATO.IITR.730493

        /* VR.ATO.IITR.730493
            Where any Tax withheld where Australian business number not quoted is provided on the attached Income Details schedule with a Business income statement payment type of "012" (no ABN quoted) and Business income statement type is "Personal Services Income", then Tax withheld where Australian business number not quoted must be provided

        Legacy Rule Format:
            ^IITR277 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
            ^IITR277 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income')

        Data Elements:
    
            ^IITR277 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeABNNotQuoted.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730493(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR277.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Personal Services Income");

            bool assertion = !report.iitrParentDocument.IITR277.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730493",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld where Australian business number not quoted must be provided",
                    LongDescription = "Where any Tax withheld where Australian business number not quoted is provided on the attached Income Details schedule with a Business income statement payment type of \"012\" (no ABN quoted) and Business income statement type is \"Personal Services Income\", then Tax withheld where Australian business number not quoted must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeABNNotQuoted.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730493" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730494

        /* VR.ATO.IITR.730494
            The Tax withheld where Australian business number not quoted amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "012" (no ABN quoted) and Business income statement type is "Personal Services Income" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR277 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR277 <> (Sum(ConditionalValue(^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR277 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR277 <> (Sum(ConditionalValue(^INCDTLS489 = '012' AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR277 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeABNNotQuoted.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730494(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR277IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR277NotEqualsSum = false;

            // Condition 1: [iitr277] <> NULL
            condition1_IITR277IsNotNull = report.iitrParentDocument.IITR277 != null;

            // Condition 3 Sum: (SUM(ConditionalValue([incdtls489] = "012" AND [incdtls490] = "Personal Services Income", [incdtls493], 0))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => tuple.INCDTLS489 == "012" && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr277] <> (SUM(ConditionalValue([incdtls489] = "012" AND [incdtls490] = "Personal Services Income", [incdtls493], 0)))
            condition3_IITR277NotEqualsSum = report.iitrParentDocument.IITR277.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR277IsNotNull && condition2_INCDTLSExists && condition3_IITR277NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730494",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld where Australian business number not quoted is incorrect",
                    LongDescription = "The Tax withheld where Australian business number not quoted amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"012\" (no ABN quoted) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeABNNotQuoted.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730494" },
                        new ProcessMessageParameter() { Name = "IITR277", Value = report.iitrParentDocument.IITR277.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated sum of INCDTLS493 when the conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730494

        #region VR.ATO.IITR.730495

        /* VR.ATO.IITR.730495
            Where any Tax withheld - labour hire or other specified payments amount is provided on the attached Income Details schedule with a Business income statement payment type of "001" (labour hire) or "002" (other specified payments) and Business income statement type is "Personal Services Income", then Tax withheld - labour hire or other specified payments must be provided

        Legacy Rule Format:
            ^IITR278 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Personal Services Income')

        Technical Business Rule Format:
                ^IITR278 = NULL AND CountDocument('INCDTLS') = 1 AND AnyOccurrence(^INCDTLS493, ^INCDTLS493 <> NULL) WHERE (InSet(^INCDTLS489, '"001", "002"') AND ^INCDTLS490 = 'Personal Services Income')

        Data Elements:
    
            ^IITR278 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeLabourHireOrOtherPayments.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730495(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool condition3_AnyINCDTLS493WhenConditionsAreMet = false;

            if (report.iitrParentDocument.IITR278.HasValue)
                return processMessage;

            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection != null)
                condition3_AnyINCDTLS493WhenConditionsAreMet = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Any(tuple => tuple.INCDTLS493 != null && (tuple.INCDTLS489 == "001" || tuple.INCDTLS489 == "002") && tuple.INCDTLS490 == "Personal Services Income");

            bool assertion = !report.iitrParentDocument.IITR278.HasValue && condition3_AnyINCDTLS493WhenConditionsAreMet;

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730495",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld - labour hire or other specified payments must be provided",
                    LongDescription = "Where any Tax withheld - labour hire or other specified payments amount is provided on the attached Income Details schedule with a Business income statement payment type of \"001\" (labour hire) or \"002\" (other specified payments) and Business income statement type is \"Personal Services Income\", then Tax withheld - labour hire or other specified payments must be provided",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeLabourHireOrOtherPayments.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730495" },
                        new ProcessMessageParameter() { Name = "Any occurrence of INCDTLS493 when conditions are met", Value = condition3_AnyINCDTLS493WhenConditionsAreMet.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.730496

        /* VR.ATO.IITR.730496
            The Tax withheld - labour hire or other specified payments amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is "001" (labour hire) or "002" (other specified payments) and Business income statement type is "Personal Services Income" in the attached Income Details schedule

        Legacy Rule Format:
            ((^IITR278 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR278 <> (Sum(ConditionalValue((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Technical Business Rule Format:
            ((^IITR278 <> NULL) AND (CountDocument('INCDTLS') = 1) AND ^IITR278 <> (Sum(ConditionalValue((^INCDTLS489 = '001' OR ^INCDTLS489 = '002') AND ^INCDTLS490 = 'Personal Services Income', ^INCDTLS493, 0))))

        Data Elements:
    
            ^IITR278 = RP:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeLabourHireOrOtherPayments.Amount
    
            ^INCDTLS489 = INCDTLS489
    
            ^INCDTLS490 = INCDTLS490
    
            ^INCDTLS493 = INCDTLS493
        */

        public static ProcessMessageDocument VR_ATO_IITR_730496(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            // Condition 2 already met if this rule is called. (COUNT(SCHEDULE = "INCDTLS") = 1)
            bool condition2_INCDTLSExists = true;
            bool condition1_IITR278IsNotNull = false;
            decimal condition3_INCDTLS493Sum = 0m;
            bool condition3_IITR278NotEqualsSum = false;

            // Condition 1: [iitr278] <> NULL
            condition1_IITR278IsNotNull = report.iitrParentDocument.IITR278 != null;

            // Condition 3 Sum: (SUM(ConditionalValue(([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Personal Services Income", [incdtls493], 0))
            if (incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollectionExists)
                condition3_INCDTLS493Sum = incdtlschilddoc.Rp_BusinessIncomePaymentSummariesCollection.Sum(tuple => (tuple.INCDTLS489 == "001" || tuple.INCDTLS489 == "002") && tuple.INCDTLS490 == "Personal Services Income" ? tuple.INCDTLS493.GetValueOrDefault() : 0);

            // Condition 3: [iitr278] <> (SUM(ConditionalValue(([incdtls489] = "001" OR [incdtls489] = "002") AND [incdtls490] = "Personal Services Income", [incdtls493], 0)))
            condition3_IITR278NotEqualsSum = report.iitrParentDocument.IITR278.GetValueOrDefault() != condition3_INCDTLS493Sum;

            // Rule assertion: condition1 AND condition2 AND condition3
            assertion = (condition1_IITR278IsNotNull && condition2_INCDTLSExists && condition3_IITR278NotEqualsSum);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.730496",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax withheld - labour hire or other specified payments is incorrect",
                    LongDescription = "The Tax withheld - labour hire or other specified payments amount must equal the sum of all Business income statement tax withheld amounts where the Business income statement payment type is \"001\" (labour hire) or \"002\" (other specified payments) and Business income statement type is \"Personal Services Income\" in the attached Income Details schedule",
                    Location = "/xbrli:xbrl/tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncomeLabourHireOrOtherPayments.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.730496" },
                        new ProcessMessageParameter() { Name = "IITR278", Value = report.iitrParentDocument.IITR278.ToString() },
                        new ProcessMessageParameter() { Name = "Calculated sum of INCDTLS493 when the conditions are met", Value = condition3_INCDTLS493Sum.ToString() }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.730496

        #region VR.ATO.IITR.800005

        /* VR.ATO.IITR.800005
        When an assessable amount from a capped defined benefit income stream is present, a positive amount for Superannuation income stream taxable component taxed element, Superannuation income stream taxable component untaxed element, Superannuation income stream tax free component, Superannuation income stream lump sum in arrears taxable component taxed element, Superannuation income stream lump sum in arrears taxable component untaxed element or Superannuation income stream lump sum in arrears tax free component must also be provided

        Technical Business Rule Format:
            (^IITR505 <> NULL AND (CountDocument('INCDTLS') = 0 OR Count(^INCDTLS108) = 0)) OR (CountDocument('INCDTLS') = 1 AND (^IITR505 <> NULL) AND (AllOccurrences(^INCDTLS113, ^INCDTLS113 = NULL OR ^INCDTLS113 = 0)) AND (AllOccurrences(^INCDTLS114, ^INCDTLS114 = NULL OR ^INCDTLS114 = 0)) AND (AllOccurrences(^INCDTLS115, ^INCDTLS115 = NULL OR ^INCDTLS115 = 0)) AND (AllOccurrences(^INCDTLS117, ^INCDTLS117 = NULL OR ^INCDTLS117 = 0)) AND (AllOccurrences(^INCDTLS118, ^INCDTLS118 = NULL OR ^INCDTLS118 = 0)) AND (AllOccurrences(^INCDTLS119, ^INCDTLS119 = NULL OR ^INCDTLS119 = 0)))

        Data Elements:
    
            ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount

            ^INCDTLS108 = ^INCDTLS108

            
            ^INCDTLS113 = ^INCDTLS113

            ^INCDTLS114 = ^INCDTLS114

            ^INCDTLS115 = ^INCDTLS115

            ^INCDTLS117 = ^INCDTLS117

            ^INCDTLS118 = ^INCDTLS118

            ^INCDTLS119 = ^INCDTLS119
        */

        public static ProcessMessageDocument VR_ATO_IITR_800005(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            bool condition1 = report.iitrParentDocument.IITR505 != null && (incdtlschilddoc == null || incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => !incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuationCollectionExists));
            bool condition2 = incdtlschilddoc != null && (report.iitrParentDocument.IITR505 != null)
                && (incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS113 == null || incomeTuple.INCDTLS113.Value == 0)
                && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS114 == null || incomeTuple.INCDTLS114.Value == 0)
                && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS115 == null || incomeTuple.INCDTLS115.Value == 0)
                && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS117 == null || incomeTuple.INCDTLS117.Value == 0)
                && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS118 == null || incomeTuple.INCDTLS118.Value == 0)
                && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS119 == null || incomeTuple.INCDTLS119.Value == 0) : true);

            assertion = condition1 || condition2;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.800005",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Australian superannuation income stream payment summary amounts must be provided",
                    LongDescription = "When an assessable amount from a capped defined benefit income stream is present, a positive amount for Superannuation income stream taxable component taxed element, Superannuation income stream taxable component untaxed element, Superannuation income stream tax free component, Superannuation income stream lump sum in arrears taxable component taxed element, Superannuation income stream lump sum in arrears taxable component untaxed element or Superannuation income stream lump sum in arrears tax free component must also be provided",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.800005" },
                        new ProcessMessageParameter() { Name = "IITR505", Value = report.iitrParentDocument.IITR505.HasValue ? report.iitrParentDocument.IITR505.Value.ToString() : "null" },
                        new ProcessMessageParameter() { Name = "INCDTLS108Exists", Value = (incdtlschilddoc != null && incdtlschilddoc.Rp_IncomeCollection != null && incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => !incomeTuple.Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuationCollectionExists)).ToString() },
                        new ProcessMessageParameter() { Name = "All INCDTLS113 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS113 == null)) ? "true" : "false" },
                        new ProcessMessageParameter() { Name = "All INCDTLS114 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS114 == null)) ? "true" : "false" },
                        new ProcessMessageParameter() { Name = "All INCDTLS115 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS115 == null)) ? "true" : "false" },
                        new ProcessMessageParameter() { Name = "All INCDTLS117 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS117 == null)) ? "true" : "false" },
                        new ProcessMessageParameter() { Name = "All INCDTLS118 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS118 == null)) ? "true" : "false" },
                        new ProcessMessageParameter() { Name = "All INCDTLS119 are not provided or 0", Value = incdtlschilddoc != null && (incdtlschilddoc.Rp_IncomeCollection == null || incdtlschilddoc.Rp_IncomeCollection.All(incomeTuple => incomeTuple.INCDTLS119 == null)) ? "true" : "false" }
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.800005

        #region VR.ATO.IITR.W00002

        /* VR.ATO.IITR.W00002
        Where Assessable amount from a capped defined benefit income stream is present and AASIS Taxable component taxed element is equal to the sum of all Superannuation income stream taxable components taxed elements provided in the attached Income Details schedule or AASIS Lump sum in arrears taxable component taxed element is equal to the sum of all Superannuation income stream lump sum in arrears taxable components taxed elements provided in the attached Income Details schedule, check AASIS details have been provided correctly

        Legacy Rule Format:
            ^IITR505 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR92 = Sum(^INCDTLS113) OR ^IITR94 = Sum(^INCDTLS117))

        Technical Business Rule Format:
            ^IITR505 <> NULL AND CountDocument('INCDTLS') = 1 AND (^IITR92 = Sum(^INCDTLS113) OR ^IITR94 = Sum(^INCDTLS117))

        Data Elements:
    
            ^IITR92 = RP:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount

            ^IITR94 = RP:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount
            
            ^IITR505 = RP:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount

            ^INCDTLS113 = ^INCDTLS113

            ^INCDTLS117 = ^INCDTLS117
        */

        public static ProcessMessageDocument VR_ATO_IITR_W00002(IITR2026Crossform report, INCDTLS2026 incdtlschilddoc)
        {
            ProcessMessageDocument processMessage = null;
            bool assertion;

            decimal sumINCDTLS113 = incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Sum(incomeTuple => incomeTuple.INCDTLS113.HasValue ? incomeTuple.INCDTLS113 : 0).Value : 0;
            decimal sumINCDTLS117 = incdtlschilddoc.Rp_IncomeCollection != null ? incdtlschilddoc.Rp_IncomeCollection.Sum(incomeTuple => incomeTuple.INCDTLS117.HasValue ? incomeTuple.INCDTLS117 : 0).Value : 0;
            
            assertion = report.iitrParentDocument.IITR505 != null && (report.iitrParentDocument.IITR92 == sumINCDTLS113 || report.iitrParentDocument.IITR94 == sumINCDTLS117);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.W00002",
                    Severity = ProcessMessageSeverity.Warning,
                    Description = @"Check AASIS details have been provided correctly",
                    LongDescription = "Where Assessable amount from a capped defined benefit income stream is present and AASIS Taxable component taxed element is equal to the sum of all Superannuation income stream taxable components taxed elements provided in the attached Income Details schedule or AASIS Lump sum in arrears taxable component taxed element is equal to the sum of all Superannuation income stream lump sum in arrears taxable components taxed elements provided in the attached Income Details schedule, check AASIS details have been provided correctly",
                    Location = "/xbrli:xbrl/tns:Income.Superannuation.AnnuitiesAndSuperannuationAssessableCappedBenefit.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.W00002" },
                        new ProcessMessageParameter() { Name = "IITR92", Value = report.iitrParentDocument.IITR92.HasValue ? report.iitrParentDocument.IITR92.Value.ToString() : "null" },
                        new ProcessMessageParameter() { Name = "IITR94", Value = report.iitrParentDocument.IITR94.HasValue ? report.iitrParentDocument.IITR94.Value.ToString() : "null" },
                        new ProcessMessageParameter() { Name = "IITR505", Value = report.iitrParentDocument.IITR505.HasValue ? report.iitrParentDocument.IITR505.Value.ToString() : "null" },
                        new ProcessMessageParameter() { Name = "Sum(INCDTLS113)", Value = sumINCDTLS113.ToString() },
                        new ProcessMessageParameter() { Name = "Sum(INCDTLS117)", Value = sumINCDTLS117.ToString() },
                    },
                };
            }

            return processMessage;
        }

        #endregion // VR.ATO.IITR.W00002
    }
}