using System;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationINCDTLS
{
    public class INCDTLS2026
    {

    public bool RpCollectionExists = false;
    public int RpCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp
    /// INCDTLS:pyin.02.00:Lodgment.PeriodStart.Date
    /// </summary>
    public DateTime? INCDTLS100 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp
    /// INCDTLS:pyin.02.00:Lodgment.PeriodEnd.Date
    /// </summary>
    public DateTime? INCDTLS101 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp
    /// INCDTLS:pyid.02.00:Identifiers.TaxFileNumber.Identifier
    /// </summary>
    public string INCDTLS102 = null;

    public bool Rp_IncomeCollectionExists = false;
    public int Rp_IncomeCollectionCount = 0;
    
    public List<Rp_Income> Rp_IncomeCollection = null;
    
    public class Rp_Income 
    {
        public int OccurrenceIndex = 0;
    
        public bool Rp_Income_OrganisationNameDetailsCollectionExists = false;
        public int Rp_Income_OrganisationNameDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS306 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails
        /// INCDTLS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string INCDTLS307 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails
        /// INCDTLS:pyid.02.00:Identifiers.WithholdingPayerNumber.Identifier
        /// </summary>
        public string INCDTLS308 = null;
    
        public bool Rp_Income_OrganisationNameDetails_SalaryOrWagesCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_SalaryOrWagesCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:lrla.02.27:Remuneration.WorkingHolidayMakerIncome.Indicator
        /// </summary>
        public bool? INCDTLS310 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSalaryOrWages.Amount
        /// </summary>
        public decimal? INCDTLS311 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.23:Income.SalaryOrWages.Amount
        /// </summary>
        public decimal? INCDTLS312 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.23:Income.AllowancesEarningsTipsDirectorsFees.Amount
        /// </summary>
        public decimal? INCDTLS313 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAllowancesEarningsTipsDirectorsFees.Amount
        /// </summary>
        public decimal? INCDTLS339 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.23:Income.FringeBenefitsReportable.Amount
        /// </summary>
        public decimal? INCDTLS314 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:rvctc3.02.36:FringeBenefitsTax.Exemption.Indicator
        /// </summary>
        public bool? INCDTLS315 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.24:Income.CommunityDevelopmentEmploymentProject.Amount
        /// </summary>
        public decimal? INCDTLS316 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:emsup.02.19:SuperannuationContribution.EmployerReportable.Amount
        /// </summary>
        public decimal? INCDTLS319 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
        /// </summary>
        public decimal? INCDTLS320 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.23:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
        /// </summary>
        public decimal? INCDTLS321 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:lrla.02.00:Remuneration.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Code
        /// </summary>
        public string INCDTLS322 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
        /// </summary>
        public decimal? INCDTLS323 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.23:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
        /// </summary>
        public decimal? INCDTLS324 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.24:Income.GenuineRedundancyPaymentLumpSumD.Amount
        /// </summary>
        public decimal? INCDTLS325 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages
        /// INCDTLS:bafpr1.02.24:Income.BackPaymentLumpSumE.Amount
        /// </summary>
        public decimal? INCDTLS326 = null;
    
        public bool Rp_Income_OrganisationNameDetails_SalaryOrWages_ExemptForeignEmploymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_SalaryOrWages_ExemptForeignEmploymentCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:ExemptForeignEmployment
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ExemptForeignEmploymentIncome.Amount
        /// </summary>
        public decimal? INCDTLS335 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:ExemptForeignEmployment
        /// INCDTLS:rvctc1.02.29:IncomeTax.ForeignWithholding.Amount
        /// </summary>
        public decimal? INCDTLS336 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:ExemptForeignEmployment
        /// INCDTLS:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string INCDTLS337 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:ExemptForeignEmployment
        /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
        /// </summary>
        public decimal? INCDTLS338 = null;
    
        public bool Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollectionCount = 0;

        public List<Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears> Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrearsCollection = null;

        public class Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:LumpSumArrears
            /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPaymentType.Code
            /// </summary>
            public string INCDTLS151 = null;

            public bool Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollectionExists = false;
            public int Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollectionCount = 0;
    
            public List<Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPayment> Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPaymentCollection = null;
    
            public class Rp_Income_OrganisationNameDetails_SalaryOrWages_LumpSumArrears_LumpSumArrearsPayment 
            {
                public int OccurrenceIndex = 0;
        
                /// <summary>
                /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:LumpSumArrears/:LumpSumArrearsPayment
                /// INCDTLS:pyin.02.37:Report.TargetFinancial.Year
                /// </summary>
                public int? INCDTLS153 = null;
        
                /// <summary>
                /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SalaryOrWages/:LumpSumArrears/:LumpSumArrearsPayment
                /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
                /// </summary>
                public decimal? INCDTLS154 = null;
            }
        }
    
        public bool Rp_Income_OrganisationNameDetails_ForeignEmploymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_ForeignEmploymentCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:rvctc2.02.15:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignEmploymentIncome.Amount
        /// </summary>
        public decimal? INCDTLS167 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:rvctc4.02.04:InternationalDealings.ForeignIncomeGross.Amount
        /// </summary>
        public decimal? INCDTLS168 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS169 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:bafpr1.02.23:Income.FringeBenefitsReportable.Amount
        /// </summary>
        public decimal? INCDTLS170 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:rvctc3.02.36:FringeBenefitsTax.Exemption.Indicator
        /// </summary>
        public bool? INCDTLS180 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:emsup.02.19:SuperannuationContribution.EmployerReportable.Amount
        /// </summary>
        public decimal? INCDTLS171 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:bafpr1.02.23:Income.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
        /// </summary>
        public decimal? INCDTLS174 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:lrla.02.00:Remuneration.UnusedAnnualOrLongServiceLeavePaymentLumpSumA.Code
        /// </summary>
        public string INCDTLS175 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:bafpr1.02.24:Income.GenuineRedundancyPaymentLumpSumD.Amount
        /// </summary>
        public decimal? INCDTLS176 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:bafpr1.02.24:Income.BackPaymentLumpSumE.Amount
        /// </summary>
        public decimal? INCDTLS177 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignEmploymentIncomePaymentSummary.Amount
        /// </summary>
        public decimal? INCDTLS178 = null;
    
        public bool Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollectionCount = 0;

        public List<Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPayment> Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPaymentCollection = null;

        public class Rp_Income_OrganisationNameDetails_ForeignEmployment_FEIPSLumpSumArrearsPayment 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment/:FEIPSLumpSumArrearsPayment
            /// INCDTLS:pyin.02.37:Report.TargetFinancial.Year
            /// </summary>
            public int? INCDTLS523 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:ForeignEmployment/:FEIPSLumpSumArrearsPayment
            /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
            /// </summary>
            public decimal? INCDTLS524 = null;
        }
    
        public bool Rp_Income_OrganisationNameDetails_EmploymentTerminationPaymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_EmploymentTerminationPaymentCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string INCDTLS136 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:bafpr1.02.23:Income.EmploymentTerminationPayment.Date
        /// </summary>
        public DateTime? INCDTLS137 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:rvctc2.02.31:IncomeTax.PayAsYouGoWithholding.EmploymentTerminationPaymentType.Code
        /// </summary>
        public string INCDTLS138 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmploymentTerminationPayment.Amount
        /// </summary>
        public decimal? INCDTLS139 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:bafpr1.02.23:Income.EmploymentTerminationPaymentTaxable.Amount
        /// </summary>
        public decimal? INCDTLS140 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:EmploymentTerminationPayment
        /// INCDTLS:bafpr1.02.24:Income.EmploymentTerminationPaymentTaxFree.Amount
        /// </summary>
        public decimal? INCDTLS141 = null;
    
        public bool Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuationCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuationCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.24:Income.Superannuation.AnnuitiesAndSuperannuationReversionaryIncomeStream.Indicator
        /// </summary>
        public bool? INCDTLS109 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.24:Income.Superannuation.AnnuitiesAndSuperannuationPaymentPeriodStart.Date
        /// </summary>
        public DateTime? INCDTLS110 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.24:Income.Superannuation.AnnuitiesAndSuperannuationPaymentPeriodEnd.Date
        /// </summary>
        public DateTime? INCDTLS111 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount
        /// </summary>
        public decimal? INCDTLS112 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentTaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS113 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.AnnuitiesAndSuperannuationTaxableComponentUntaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS114 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:rvctc2.02.10:IncomeTax.Superannuation.TaxFreeComponent.Amount
        /// </summary>
        public decimal? INCDTLS115 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:gfati.02.00:TaxOffsetClaim.SuperannuationIncomeStream.Amount
        /// </summary>
        public decimal? INCDTLS116 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentTaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS117 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.AnnuitiesAndSuperannuationLumpSumArrearsTaxableComponentUntaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS118 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.LumpSumArrearsTaxFree.Amount
        /// </summary>
        public decimal? INCDTLS119 = null;
    
        public bool Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollectionCount = 0;

        public List<Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPayment> Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPaymentCollection = null;

        public class Rp_Income_OrganisationNameDetails_AnnuitiesAndSuperannuation_SISLumpSumArrearsPayment 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation/:SISLumpSumArrearsPayment
            /// INCDTLS:pyin.02.37:Report.TargetFinancial.Year
            /// </summary>
            public int? INCDTLS526 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AnnuitiesAndSuperannuation/:SISLumpSumArrearsPayment
            /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
            /// </summary>
            public decimal? INCDTLS527 = null;
        }
    
        public bool Rp_Income_OrganisationNameDetails_AustralianAnnuitiesCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_AustralianAnnuitiesCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AustralianAnnuities
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianAnnuitiesAndSuperannuationIncomeStream.Amount
        /// </summary>
        public decimal? INCDTLS146 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AustralianAnnuities
        /// INCDTLS:bafpr3.02.04:Income.Insurance.LifePremiumDirectGross.Amount
        /// </summary>
        public decimal? INCDTLS147 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AustralianAnnuities
        /// INCDTLS:rvctc2.02.03:IncomeTax.Deduction.PensionOrAnnuityPurchasePriceUndeducted.Amount
        /// </summary>
        public decimal? INCDTLS148 = null;
    
        public bool Rp_Income_OrganisationNameDetails_SuperannuationLumpSumPaymentCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_SuperannuationLumpSumPaymentCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:bafpr3.02.18:Income.Superannuation.LumpSumPayment.Date
        /// </summary>
        public DateTime? INCDTLS328 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldSuperannuationLumpSumPayment.Amount
        /// </summary>
        public decimal? INCDTLS329 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.LumpSumPaymentTaxableComponentTaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS330 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:bafpr3.02.19:Income.Superannuation.LumpSumPaymentTaxableComponentUntaxedElement.Amount
        /// </summary>
        public decimal? INCDTLS331 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:bafpr3.02.30:Income.Superannuation.LumpSumPaymentTaxFree.Amount
        /// </summary>
        public decimal? INCDTLS332 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:SuperannuationLumpSumPayment
        /// INCDTLS:emsup.02.17:SuperannuationBenefit.DeathBenefit.Indicator
        /// </summary>
        public bool? INCDTLS333 = null;
    
        public bool Rp_Income_OrganisationNameDetails_AttributedPersonalServicesIncomeCollectionExists = false;
        public int Rp_Income_OrganisationNameDetails_AttributedPersonalServicesIncomeCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AttributedPersonalServicesIncome
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount
        /// </summary>
        public decimal? INCDTLS341 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AttributedPersonalServicesIncome
        /// INCDTLS:bafpr3.02.11:Income.PersonalServicesIncome.Total.Amount
        /// </summary>
        public decimal? INCDTLS342 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Income/:OrganisationNameDetails/:AttributedPersonalServicesIncome
        /// INCDTLS:emsup.02.19:SuperannuationContribution.EmployerReportable.Amount
        /// </summary>
        public decimal? INCDTLS343 = null;
    
        public bool Rp_Income_GovernmentBenefitCollectionExists = false;
        public int Rp_Income_GovernmentBenefitCollectionCount = 0;

        public List<Rp_Income_GovernmentBenefit> Rp_Income_GovernmentBenefitCollection = null;

        public class Rp_Income_GovernmentBenefit 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:gfapc.02.07:Payment.Type.Code
            /// </summary>
            public string INCDTLS126 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:gfapc.02.03:Payment.Type.Description
            /// </summary>
            public string INCDTLS127 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:gfapc.02.03:Payment.Taxable.Amount
            /// </summary>
            public decimal? INCDTLS128 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldAustralianGovernmentPensionsAndAllowances.Amount
            /// </summary>
            public decimal? INCDTLS129 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:gfapc.02.08:Payment.AdjustmentReason.Code
            /// </summary>
            public string INCDTLS131 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:Income/:GovernmentBenefit
            /// INCDTLS:gfapc.02.08:Payment.AdjustmentReason.Description
            /// </summary>
            public string INCDTLS132 = null;
        }
    }

    public bool Rp_EmployeeShareSchemeCollectionExists = false;
    public int Rp_EmployeeShareSchemeCollectionCount = 0;
    
    public List<Rp_EmployeeShareScheme> Rp_EmployeeShareSchemeCollection = null;
    
    public class Rp_EmployeeShareScheme 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS495 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string INCDTLS496 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:bafpr3.02.18:Income.EmployeeShareScheme.TaxUpfrontReducibleDiscount.Amount
        /// </summary>
        public decimal? INCDTLS501 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:bafpr3.02.18:Income.EmployeeShareScheme.TaxUpfrontNonReducibleDiscount.Amount
        /// </summary>
        public decimal? INCDTLS502 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:bafpr3.02.18:Income.EmployeeShareScheme.DeferralDiscount.Amount
        /// </summary>
        public decimal? INCDTLS503 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldEmployeeShareSchemeDiscountTFNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS505 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:bafpr3.02.18:Income.EmployeeShareScheme.ForeignSourceDiscount.Amount
        /// </summary>
        public decimal? INCDTLS506 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:EmployeeShareScheme
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS507 = null;
    }

    public bool Rp_InterestCollectionExists = false;
    public int Rp_InterestCollectionCount = 0;
    
    public List<Rp_Interest> Rp_InterestCollection = null;
    
    public class Rp_Interest 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionName.Text
        /// </summary>
        public string INCDTLS351 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:bafot.02.34:Miscellaneous.InvestorReferenceNumber.Identifier
        /// </summary>
        public string INCDTLS352 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:bafot.02.24:RegulatoryDisclosures.AccountHolder.Count
        /// </summary>
        public decimal? INCDTLS353 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string INCDTLS354 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:bafpr2.02.30:Income.Interest.AdjustmentReason.Code
        /// </summary>
        public string INCDTLS534 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest
        /// INCDTLS:bafpr2.02.29:Income.Interest.AdjustmentReason.Description
        /// </summary>
        public string INCDTLS535 = null;
    
        public bool Rp_Interest_InterestTotalCollectionExists = false;
        public int Rp_Interest_InterestTotalCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest/:InterestTotal
        /// INCDTLS:rvctc1.02.16:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
        /// </summary>
        public decimal? INCDTLS358 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest/:InterestTotal
        /// INCDTLS:bafpr2.02.02:Income.Interest.Gross.Amount
        /// </summary>
        public decimal? INCDTLS359 = null;
    
        public bool Rp_Interest_InterestYourShareCollectionExists = false;
        public int Rp_Interest_InterestYourShareCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest/:InterestYourShare
        /// INCDTLS:rvctc1.02.16:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
        /// </summary>
        public decimal? INCDTLS361 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Interest/:InterestYourShare
        /// INCDTLS:bafpr2.02.02:Income.Interest.Gross.Amount
        /// </summary>
        public decimal? INCDTLS362 = null;
    }

    public bool Rp_DividendsCollectionExists = false;
    public int Rp_DividendsCollectionCount = 0;
    
    public List<Rp_Dividends> Rp_DividendsCollection = null;
    
    public class Rp_Dividends 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS345 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends
        /// INCDTLS:bafot.02.34:Miscellaneous.InvestorReferenceNumber.Identifier
        /// </summary>
        public string INCDTLS346 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends
        /// INCDTLS:bafot.02.24:RegulatoryDisclosures.AccountHolder.Count
        /// </summary>
        public decimal? INCDTLS347 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends
        /// INCDTLS:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string INCDTLS348 = null;
    
        public bool Rp_Dividends_DividendTotalCollectionExists = false;
        public int Rp_Dividends_DividendTotalCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:bafpr1.02.05:Income.DividendsUnfranked.Amount
        /// </summary>
        public decimal? INCDTLS371 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:bafpr1.02.00:Income.DividendsFranked.Amount
        /// </summary>
        public decimal? INCDTLS372 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:rvctc1.02.03:IncomeTax.FrankingCredits.Amount
        /// </summary>
        public decimal? INCDTLS373 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS374 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? INCDTLS375 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendTotal
        /// INCDTLS:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? INCDTLS376 = null;
    
        public bool Rp_Dividends_DividendYourShareCollectionExists = false;
        public int Rp_Dividends_DividendYourShareCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:bafpr1.02.05:Income.DividendsUnfranked.Amount
        /// </summary>
        public decimal? INCDTLS378 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:bafpr1.02.00:Income.DividendsFranked.Amount
        /// </summary>
        public decimal? INCDTLS379 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:rvctc1.02.03:IncomeTax.FrankingCredits.Amount
        /// </summary>
        public decimal? INCDTLS380 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldDividendsTFNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS381 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? INCDTLS382 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Dividends/:DividendYourShare
        /// INCDTLS:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? INCDTLS383 = null;
    }

    public bool Rp_ManagedFundsCollectionExists = false;
    public int Rp_ManagedFundsCollectionCount = 0;
    
    public List<Rp_ManagedFunds> Rp_ManagedFundsCollection = null;
    
    public class Rp_ManagedFunds 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS385 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds
        /// INCDTLS:bafot.02.34:Miscellaneous.InvestorReferenceNumber.Identifier
        /// </summary>
        public string INCDTLS386 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds
        /// INCDTLS:bafot.02.24:RegulatoryDisclosures.AccountHolder.Count
        /// </summary>
        public decimal? INCDTLS387 = null;
    
        public bool Rp_ManagedFunds_ManagedFundsTotalCollectionExists = false;
        public int Rp_ManagedFunds_ManagedFundsTotalCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr1.02.23:Income.NonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS389 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr1.02.23:Income.TrustFrankedNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS390 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS391 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsShare.Amount
        /// </summary>
        public decimal? INCDTLS392 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.04:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldWhereTFNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS393 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc4.02.04:InternationalDealings.ForeignIncomeGross.Amount
        /// </summary>
        public decimal? INCDTLS398 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr3.02.14:Income.InternationalDealings.Net.Amount
        /// </summary>
        public decimal? INCDTLS399 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS400 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.40:IncomeTax.IncomeCategoryMiscellaneousTotal.Amount
        /// </summary>
        public decimal? INCDTLS401 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr1.02.23:Income.TrustPrimaryProductionNetShare.Amount
        /// </summary>
        public decimal? INCDTLS402 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS403 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS404 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.27:IncomeTax.CreditTrusteeTaxPaidTotal.Amount
        /// </summary>
        public decimal? INCDTLS405 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.41:IncomeTax.CreditTrusteeTaxPaidReason.Code
        /// </summary>
        public string INCDTLS406 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr1.02.13:Income.TrustDistributions.Amount
        /// </summary>
        public decimal? INCDTLS407 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount
        /// </summary>
        public decimal? INCDTLS408 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:gfati.02.06:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount
        /// </summary>
        public decimal? INCDTLS409 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
        /// </summary>
        public decimal? INCDTLS410 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc4.02.00:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
        /// </summary>
        public decimal? INCDTLS411 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
        /// </summary>
        public decimal? INCDTLS412 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignRent.Amount
        /// </summary>
        public decimal? INCDTLS413 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsNewZealand.Amount
        /// </summary>
        public decimal? INCDTLS414 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageVentureCapitalLimitedPartnershipTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS415 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageInvestorTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS416 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal
        /// INCDTLS:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? INCDTLS417 = null;
    
        public bool Rp_ManagedFunds_ManagedFundsTotal_CapitalGainsCollectionExists = false;
        public int Rp_ManagedFunds_ManagedFundsTotal_CapitalGainsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal/:CapitalGains
        /// INCDTLS:rvctc3.02.19:Capital.Gains.Net.Amount
        /// </summary>
        public decimal? INCDTLS394 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal/:CapitalGains
        /// INCDTLS:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? INCDTLS395 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal/:CapitalGains
        /// INCDTLS:rvctc3.02.20:Capital.Gains.DiscountedMethod.Amount
        /// </summary>
        public decimal? INCDTLS396 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsTotal/:CapitalGains
        /// INCDTLS:rvctc3.02.20:Capital.Gains.OtherMethod.Amount
        /// </summary>
        public decimal? INCDTLS397 = null;
    
        public bool Rp_ManagedFunds_ManagedFundsYourShareCollectionExists = false;
        public int Rp_ManagedFunds_ManagedFundsYourShareCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr1.02.23:Income.NonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS419 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr1.02.23:Income.TrustFrankedNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS420 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS421 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsShare.Amount
        /// </summary>
        public decimal? INCDTLS422 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.04:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldWhereTFNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS423 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc4.02.04:InternationalDealings.ForeignIncomeGross.Amount
        /// </summary>
        public decimal? INCDTLS428 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr3.02.14:Income.InternationalDealings.Net.Amount
        /// </summary>
        public decimal? INCDTLS429 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS430 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.40:IncomeTax.IncomeCategoryMiscellaneousTotal.Amount
        /// </summary>
        public decimal? INCDTLS431 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr1.02.23:Income.TrustPrimaryProductionNetShare.Amount
        /// </summary>
        public decimal? INCDTLS432 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS433 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS434 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.27:IncomeTax.CreditTrusteeTaxPaidTotal.Amount
        /// </summary>
        public decimal? INCDTLS435 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount
        /// </summary>
        public decimal? INCDTLS436 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:gfati.02.06:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount
        /// </summary>
        public decimal? INCDTLS437 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
        /// </summary>
        public decimal? INCDTLS438 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc4.02.00:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
        /// </summary>
        public decimal? INCDTLS439 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
        /// </summary>
        public decimal? INCDTLS440 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignRent.Amount
        /// </summary>
        public decimal? INCDTLS441 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsNewZealand.Amount
        /// </summary>
        public decimal? INCDTLS442 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageVentureCapitalLimitedPartnershipTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS443 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageInvestorTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS444 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare
        /// INCDTLS:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? INCDTLS445 = null;
    
        public bool Rp_ManagedFunds_ManagedFundsYourShare_YourShareCapitalGainsCollectionExists = false;
        public int Rp_ManagedFunds_ManagedFundsYourShare_YourShareCapitalGainsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare/:YourShareCapitalGains
        /// INCDTLS:rvctc3.02.19:Capital.Gains.Net.Amount
        /// </summary>
        public decimal? INCDTLS424 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare/:YourShareCapitalGains
        /// INCDTLS:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? INCDTLS425 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare/:YourShareCapitalGains
        /// INCDTLS:rvctc3.02.20:Capital.Gains.DiscountedMethod.Amount
        /// </summary>
        public decimal? INCDTLS426 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ManagedFunds/:ManagedFundsYourShare/:YourShareCapitalGains
        /// INCDTLS:rvctc3.02.20:Capital.Gains.OtherMethod.Amount
        /// </summary>
        public decimal? INCDTLS427 = null;
    }

    public bool Rp_ForeignIncomeCollectionExists = false;
    public int Rp_ForeignIncomeCollectionCount = 0;
    
    public List<Rp_ForeignIncome> Rp_ForeignIncomeCollection = null;
    
    public class Rp_ForeignIncome 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS186 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome
        /// INCDTLS:bafpr1.02.43:Expense.ForeignIncomeDeductions.Amount
        /// </summary>
        public decimal? INCDTLS187 = null;
    
        public bool Rp_ForeignIncome_ForeignIncomeEmploymentDetailsCollectionExists = false;
        public int Rp_ForeignIncome_ForeignIncomeEmploymentDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ForeignIncomeEmploymentDetails
        /// INCDTLS:rvctc4.02.04:InternationalDealings.ForeignIncomeGross.Amount
        /// </summary>
        public decimal? INCDTLS189 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ForeignIncomeEmploymentDetails
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS190 = null;
    
        public bool Rp_ForeignIncome_ExemptForeignIncomeCollectionExists = false;
        public int Rp_ForeignIncome_ExemptForeignIncomeCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ExemptForeignIncome
        /// INCDTLS:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string INCDTLS192 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ExemptForeignIncome
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ExemptForeignEmploymentIncome.Amount
        /// </summary>
        public decimal? INCDTLS193 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ExemptForeignIncome
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS194 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignIncome/:ExemptForeignIncome
        /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
        /// </summary>
        public decimal? INCDTLS195 = null;
    
        public bool Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollectionExists = false;
        public int Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollectionCount = 0;

        public List<Rp_ForeignIncome_FEINPSLumpSumArrearsPayment> Rp_ForeignIncome_FEINPSLumpSumArrearsPaymentCollection = null;

        public class Rp_ForeignIncome_FEINPSLumpSumArrearsPayment 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:ForeignIncome/:FEINPSLumpSumArrearsPayment
            /// INCDTLS:pyin.02.37:Report.TargetFinancial.Year
            /// </summary>
            public int? INCDTLS529 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:ForeignIncome/:FEINPSLumpSumArrearsPayment
            /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
            /// </summary>
            public decimal? INCDTLS530 = null;
        }
    }

    public bool Rp_ForeignEntitiesCollectionExists = false;
    public int Rp_ForeignEntitiesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:ForeignEntities
    /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
    /// </summary>
    public string INCDTLS201 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:ForeignEntities
    /// INCDTLS:pyde.02.00:PersonUnstructuredName.FullName.Text
    /// </summary>
    public string INCDTLS202 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:ForeignEntities
    /// INCDTLS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
    /// </summary>
    public decimal? INCDTLS203 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:ForeignEntities
    /// INCDTLS:rvctc4.02.00:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount
    /// </summary>
    public decimal? INCDTLS204 = null;

    public bool Rp_ForeignPensionsOrAnnuitiesCollectionExists = false;
    public int Rp_ForeignPensionsOrAnnuitiesCollectionCount = 0;
    
    public List<Rp_ForeignPensionsOrAnnuities> Rp_ForeignPensionsOrAnnuitiesCollection = null;
    
    public class Rp_ForeignPensionsOrAnnuities 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:rvctc4.02.05:InternationalDealings.Description.Text
        /// </summary>
        public string INCDTLS208 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:bafpr3.02.04:Income.Insurance.LifePremiumDirectGross.Amount
        /// </summary>
        public decimal? INCDTLS209 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:bafpr1.02.43:Expense.ForeignIncomeDeductions.Amount
        /// </summary>
        public decimal? INCDTLS210 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignPensionOrAnnuityIncomeUndeductedPurchasePrice.Amount
        /// </summary>
        public decimal? INCDTLS211 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS212 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities
        /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
        /// </summary>
        public decimal? INCDTLS213 = null;
    
        public bool Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollectionExists = false;
        public int Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollectionCount = 0;

        public List<Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPayment> Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPaymentCollection = null;

        public class Rp_ForeignPensionsOrAnnuities_FPALumpSumArrearsPayment 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities/:FPALumpSumArrearsPayment
            /// INCDTLS:pyin.02.37:Report.TargetFinancial.Year
            /// </summary>
            public int? INCDTLS532 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:Rp/:ForeignPensionsOrAnnuities/:FPALumpSumArrearsPayment
            /// INCDTLS:bafpr1.02.43:Income.LumpSumArrearsPayment.Amount
            /// </summary>
            public decimal? INCDTLS533 = null;
        }
    }

    public bool Rp_OtherForeignIncomeCollectionExists = false;
    public int Rp_OtherForeignIncomeCollectionCount = 0;
    
    public List<Rp_OtherForeignIncome> Rp_OtherForeignIncomeCollection = null;
    
    public class Rp_OtherForeignIncome 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome
        /// INCDTLS:rvctc4.02.05:InternationalDealings.Description.Text
        /// </summary>
        public string INCDTLS216 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome
        /// INCDTLS:bafpr1.02.43:Expense.ForeignIncomeDeductions.Amount
        /// </summary>
        public decimal? INCDTLS217 = null;
    
        public bool Rp_OtherForeignIncome_ForeignRentalIncomeDetailsCollectionExists = false;
        public int Rp_OtherForeignIncome_ForeignRentalIncomeDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:ForeignRentalIncomeDetails
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignRent.Amount
        /// </summary>
        public decimal? INCDTLS219 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:ForeignRentalIncomeDetails
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS220 = null;
    
        public bool Rp_OtherForeignIncome_ForeignFinancialInvestmentDetailsCollectionExists = false;
        public int Rp_OtherForeignIncome_ForeignFinancialInvestmentDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:ForeignFinancialInvestmentDetails
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignSourceCompanyIncomeOther.Amount
        /// </summary>
        public decimal? INCDTLS222 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:ForeignFinancialInvestmentDetails
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsNewZealand.Amount
        /// </summary>
        public decimal? INCDTLS223 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:ForeignFinancialInvestmentDetails
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS224 = null;
    
        public bool Rp_OtherForeignIncome_OtherForeignIncomeDetailsCollectionExists = false;
        public int Rp_OtherForeignIncome_OtherForeignIncomeDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:OtherForeignIncomeDetails
        /// INCDTLS:rvctc4.02.08:InternationalDealings.ForeignSourceIncomeOther.Amount
        /// </summary>
        public decimal? INCDTLS226 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:OtherForeignIncome/:OtherForeignIncomeDetails
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS227 = null;
    }

    public bool Rp_IncomeOtherCollectionExists = false;
    public int Rp_IncomeOtherCollectionCount = 0;
    
    public List<Rp_IncomeOther> Rp_IncomeOtherCollection = null;
    
    public class Rp_IncomeOther 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther
        /// INCDTLS:bafpr1.02.43:Income.OtherIncomeType.Code
        /// </summary>
        public string INCDTLS449 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther
        /// INCDTLS:bafpr1.02.00:Income.Other.Description
        /// </summary>
        public string INCDTLS450 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther
        /// INCDTLS:bafpr1.02.04:Income.Other.Amount
        /// </summary>
        public decimal? INCDTLS451 = null;
    
        public bool Rp_IncomeOther_SpecialProfessionalExpenseCollectionExists = false;
        public int Rp_IncomeOther_SpecialProfessionalExpenseCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:SpecialProfessionalExpense
        /// INCDTLS:bafpr1.02.23:Income.SpecialProfessional.Amount
        /// </summary>
        public decimal? INCDTLS453 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:SpecialProfessionalExpense
        /// INCDTLS:bafpr1.02.04:Expense.DeductibleOtherTotal.Amount
        /// </summary>
        public decimal? INCDTLS454 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:SpecialProfessionalExpense
        /// INCDTLS:bafpr1.02.43:Expense.DeductibleIncludedElsewhereTotal.Amount
        /// </summary>
        public decimal? INCDTLS455 = null;
    
        public bool Rp_IncomeOther_IncomeTaxAssessableLowValuePoolDeductionCollectionExists = false;
        public int Rp_IncomeOther_IncomeTaxAssessableLowValuePoolDeductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:IncomeTaxAssessableLowValuePoolDeduction
        /// INCDTLS:bafpr3.02.11:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
        /// </summary>
        public decimal? INCDTLS457 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:IncomeTaxAssessableLowValuePoolDeduction
        /// INCDTLS:bafpr1.02.19:Income.DepreciatingAssetsAssessableIncomeFromBalancingAdjustmentEventsTotal.Amount
        /// </summary>
        public decimal? INCDTLS458 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:IncomeOther/:IncomeTaxAssessableLowValuePoolDeduction
        /// INCDTLS:bafpr1.02.05:Income.BalancingAdjustmentTotal.Amount
        /// </summary>
        public decimal? INCDTLS459 = null;
    }

    public bool Rp_EarlyStageOffsetsCollectionExists = false;
    public int Rp_EarlyStageOffsetsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:EarlyStageOffsets
    /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageVentureCapitalLimitedPartnershipTaxOffset.Amount
    /// </summary>
    public decimal? INCDTLS231 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:Rp/:EarlyStageOffsets
    /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageInvestorTaxOffset.Amount
    /// </summary>
    public decimal? INCDTLS232 = null;

    public bool Rp_PartnershipsCollectionExists = false;
    public int Rp_PartnershipsCollectionCount = 0;
    
    public List<Rp_Partnerships> Rp_PartnershipsCollection = null;
    
    public class Rp_Partnerships 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS461 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships
        /// INCDTLS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string INCDTLS462 = null;
    
        public bool Rp_Partnerships_PartnershipsCreditsIncomeTaxOffsetsCollectionExists = false;
        public int Rp_Partnerships_PartnershipsCreditsIncomeTaxOffsetsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS480 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsShare.Amount
        /// </summary>
        public decimal? INCDTLS481 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount
        /// </summary>
        public decimal? INCDTLS482 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount
        /// </summary>
        public decimal? INCDTLS483 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount
        /// </summary>
        public decimal? INCDTLS484 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsCreditsIncomeTaxOffsets
        /// INCDTLS:gfati.02.06:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount
        /// </summary>
        public decimal? INCDTLS485 = null;
    
        public bool Rp_Partnerships_PartnershipsPrimaryCollectionExists = false;
        public int Rp_Partnerships_PartnershipsPrimaryCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsPrimary
        /// INCDTLS:bafpr1.02.36:Income.PartnershipsTrustsPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS464 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsPrimary
        /// INCDTLS:bafpr1.02.36:Expense.LandcareOperationsAcceleratedDepreciationPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS465 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsPrimary
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS466 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsPrimary
        /// INCDTLS:rvctc1.02.41:IncomeTax.LossesNonCommercialType.Code
        /// </summary>
        public string INCDTLS467 = null;
    
        public bool Rp_Partnerships_PartnershipsNonPrimaryCollectionExists = false;
        public int Rp_Partnerships_PartnershipsNonPrimaryCollectionCount = 0;
    
        public bool Rp_Partnerships_PartnershipsNonPrimary_PartnershipsNonPrimaryDistributionCollectionExists = false;
        public int Rp_Partnerships_PartnershipsNonPrimary_PartnershipsNonPrimaryDistributionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDistribution
        /// INCDTLS:bafpr1.02.23:Income.PartnershipInvestmentLessForeignIncomeNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS470 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDistribution
        /// INCDTLS:bafpr1.02.23:Income.PartnershipRentalNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS471 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDistribution
        /// INCDTLS:bafpr1.02.23:Income.PartnershipNonPrimaryProductionOtherShare.Amount
        /// </summary>
        public decimal? INCDTLS472 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDistribution
        /// INCDTLS:bafpr1.02.23:Expense.LandcareOperationsNonPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS473 = null;
    
        public bool Rp_Partnerships_PartnershipsNonPrimary_PartnershipsNonPrimaryDeductionCollectionExists = false;
        public int Rp_Partnerships_PartnershipsNonPrimary_PartnershipsNonPrimaryDeductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDeduction
        /// INCDTLS:rvctc1.02.41:IncomeTax.LossesNonCommercialType.Code
        /// </summary>
        public string INCDTLS475 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDeduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipExcludingForeignIncomeNonPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS476 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDeduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipRentalNonPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS477 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:Partnerships/:PartnershipsNonPrimary/:PartnershipsNonPrimaryDeduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS478 = null;
    }

    public bool Rp_TrustIncomeCollectionExists = false;
    public int Rp_TrustIncomeCollectionCount = 0;
    
    public List<Rp_TrustIncome> Rp_TrustIncomeCollection = null;
    
    public class Rp_TrustIncome 
    {
        public int OccurrenceIndex = 0;
    
        public bool Rp_TrustIncome_DistributingTrustCollectionExists = false;
        public int Rp_TrustIncome_DistributingTrustCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:DistributingTrust
        /// INCDTLS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string INCDTLS537 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:DistributingTrust
        /// INCDTLS:pyid.02.00:Identifiers.AustralianCompanyNumber.Identifier
        /// </summary>
        public string INCDTLS538 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:DistributingTrust
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS539 = null;
    
        public bool Rp_TrustIncome_TrustPrimaryProductionCollectionExists = false;
        public int Rp_TrustIncome_TrustPrimaryProductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustPrimaryProductionNetShare.Amount
        /// </summary>
        public decimal? INCDTLS247 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustPrimaryProduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.PartnershipsAndTrustPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS248 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustPrimaryProduction
        /// INCDTLS:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? INCDTLS540 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustPrimaryProduction
        /// INCDTLS:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? INCDTLS541 = null;
    
        public bool Rp_TrustIncome_TrustNonPrimaryProductionCollectionExists = false;
        public int Rp_TrustIncome_TrustNonPrimaryProductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS250 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustManagedInvestmentSchemeLessNetCapitalGainAndForeignIncomeNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS251 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustOtherNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS252 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustFrankedNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS253 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustFrankedInvestmentNonPrimaryProductionShare.Amount
        /// </summary>
        public decimal? INCDTLS254 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.23:Income.TrustFrankedNonPrimaryProductionOtherShare.Amount
        /// </summary>
        public decimal? INCDTLS255 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustPartnershipOtherNonPrimaryProductionNet.Amount
        /// </summary>
        public decimal? INCDTLS256 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustExcludingCapitalGainsAndForeignIncomeNonPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS257 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:rvctc2.02.14:IncomeTax.Deduction.TrustsPartnershipsOtherAllowableNonPrimaryProduction.Amount
        /// </summary>
        public decimal? INCDTLS258 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? INCDTLS542 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustNonPrimaryProduction
        /// INCDTLS:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? INCDTLS543 = null;
    
        public bool Rp_TrustIncome_TrustCreditsIncomeTaxOffsetsCollectionExists = false;
        public int Rp_TrustIncome_TrustCreditsIncomeTaxOffsetsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
        /// </summary>
        public decimal? INCDTLS260 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:bafpr1.02.41:Income.TaxableMinorBeneficiary.Amount
        /// </summary>
        public decimal? INCDTLS544 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.16:IncomeTax.FrankingCreditsShare.Amount
        /// </summary>
        public decimal? INCDTLS261 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldInvestmentsTFNNotQuotedShare.Amount
        /// </summary>
        public decimal? INCDTLS262 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldCloselyHeldTrustShare.Amount
        /// </summary>
        public decimal? INCDTLS263 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.27:IncomeTax.CreditTrusteeTaxPaidTotal.Amount
        /// </summary>
        public decimal? INCDTLS264 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.41:IncomeTax.CreditTrusteeTaxPaidReason.Code
        /// </summary>
        public string INCDTLS265 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:bafpr1.02.13:Income.TrustDistributions.Amount
        /// </summary>
        public decimal? INCDTLS266 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.41:IncomeTax.CreditTrusteeTaxPaidCredits.Amount
        /// </summary>
        public decimal? INCDTLS267 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromNewZealandCompanies.Amount
        /// </summary>
        public decimal? INCDTLS546 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:gfati.02.06:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlementShare.Amount
        /// </summary>
        public decimal? INCDTLS269 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? INCDTLS547 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:bafpr1.02.04:Income.SmallBusinessEntityNet.Amount
        /// </summary>
        public decimal? INCDTLS548 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageVentureCapitalLimitedPartnershipTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS549 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCreditsIncomeTaxOffsets
        /// INCDTLS:rvctc1.02.30:IncomeTax.EarlyStageInvestorTaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS550 = null;
    
        public bool Rp_TrustIncome_TrustCapitalGainsCollectionExists = false;
        public int Rp_TrustIncome_TrustCapitalGainsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:bafpr1.02.00:Income.CapitalGainsNet.Amount
        /// </summary>
        public decimal? INCDTLS552 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? INCDTLS553 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:rvctc3.02.11:Capital.Losses.Total.Amount
        /// </summary>
        public decimal? INCDTLS554 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:gfagc.02.06:TaxConcession.CapitalGains.DiscountTotal.Amount
        /// </summary>
        public decimal? INCDTLS555 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:gfagc.02.01:TaxConcession.CapitalGains.DiscountAndSmallBusinessConcessionsTotal.Amount
        /// </summary>
        public decimal? INCDTLS556 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:rvctc3.02.49:Capital.Gains.NonConcessionalManagedInvestmentTrustIncome.Amount
        /// </summary>
        public decimal? INCDTLS557 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:TrustCapitalGains
        /// INCDTLS:rvctc3.02.49:Capital.Gains.ExcludedFromNonConcessionalManagedInvestmentTrustIncome.Amount
        /// </summary>
        public decimal? INCDTLS558 = null;
    
        public bool Rp_TrustIncome_ForeignAndNonResidentCollectionExists = false;
        public int Rp_TrustIncome_ForeignAndNonResidentCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldForeignResidentShare.Amount
        /// </summary>
        public decimal? INCDTLS268 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
        /// </summary>
        public decimal? INCDTLS561 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:rvctc1.02.00:IncomeTax.AttributedForeignIncome.Amount
        /// </summary>
        public decimal? INCDTLS562 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:bafpr3.02.14:Income.InternationalDealings.Net.Amount
        /// </summary>
        public decimal? INCDTLS563 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? INCDTLS564 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:rvctc4.02.00:InternationalDealings.AssessableIncomeNonResidentBeneficiaryNonTrustee.Amount
        /// </summary>
        public decimal? INCDTLS565 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:TrustIncome/:ForeignAndNonResident
        /// INCDTLS:rvctc4.02.00:InternationalDealings.AssessableIncomeNonResidentBeneficiaryTrustee.Amount
        /// </summary>
        public decimal? INCDTLS566 = null;
    }

    public bool Rp_BusinessIncomePaymentSummariesCollectionExists = false;
    public int Rp_BusinessIncomePaymentSummariesCollectionCount = 0;
    
    public List<Rp_BusinessIncomePaymentSummaries> Rp_BusinessIncomePaymentSummariesCollection = null;
    
    public class Rp_BusinessIncomePaymentSummaries 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string INCDTLS487 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string INCDTLS488 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:lrla.02.27:Remuneration.WithholdingPaymentIncomeType.Code
        /// </summary>
        public string INCDTLS489 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:rvctc1.02.16:IncomeTax.IncomeType.Code
        /// </summary>
        public string INCDTLS490 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:bafpr1.02.43:Income.IndustryProductionType.Code
        /// </summary>
        public string INCDTLS491 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:bafpr1.02.36:Income.BusinessGrossTotal.Amount
        /// </summary>
        public decimal? INCDTLS492 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheld.Amount
        /// </summary>
        public decimal? INCDTLS493 = null;

        /// <summary>
        /// /xbrli:xbrl/:Rp/:BusinessIncomePaymentSummaries
        /// INCDTLS:emsup.02.02:SuperannuationContribution.EmployerContributions.Amount
        /// </summary>
        public decimal? INCDTLS494 = null;
    }

    }
}