using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationIEE;
using Ato.EN.IntegrationServices.CodeGenerationSMSFAR;
using DataContracts;

namespace Ato.CD.Inbound.SMSFAR202502
{
    internal class CrossFormValidatorIEE : ICrossFormValidator
    {
        private SMSFAR2025 ParentDocument { get; }

        private IEE2021 ChildDocument { get; }

        internal CrossFormValidatorIEE(SMSFAR2025 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (IEE2021)childDocument.ConsumedReport;
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOIEE410324(response);
            VRATOIEE410396(response);
            VRATOIEE410410(response);
            VRATOIEE410051(response);

            return response;
        }

        #region VR.ATO.IEE.410324

        /* VR.ATO.IEE.410324
        Reporting period on Schedule must match reporting period on main form

        WHERE PARENT RETURN EXISTS
        IF [IEE201] <> PARENT RETURN:RP:period.startDate OR [IEE202] <> PARENT RETURN:RP:period.endDate 
            RETURN VALIDATION MESSAGE
        ENDIF
        
        IEE201 = tns:PeriodStartD

        IEE202 = tns:PeriodEndD

        */
        private void VRATOIEE410324(List<ProcessMessageDocument> response)
        {
            bool assertion = ChildDocument.IEE201 != ParentDocument.RPStartDate || ChildDocument.IEE202 != ParentDocument.RPEndDate;
            if (assertion)
            {
                var processMessage = new ProcessMessageDocument
                {
                    Code = "CMN.ATO.IEE.410324",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Reporting period does not match the reporting period supplied on the form it was submitted with",
                    Location = "//tns:IEE/tns:RP/tns:PeriodStartD",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IEE.410324" },
                        new ProcessMessageParameter { Name = "IEE201", Value = ChildDocument.IEE201.ToString() },
                        new ProcessMessageParameter { Name = "IEE202", Value = ChildDocument.IEE202.ToString() },
                        new ProcessMessageParameter { Name = "RP:period.startDate", Value = ParentDocument.RPStartDate.ToString() },
                        new ProcessMessageParameter { Name = "RP:period.endDate", Value = ParentDocument.RPEndDate.ToString() }
                    }
                };

                response.Add(processMessage);
            }
        }

        #endregion VR.ATO.IEE.410324

        #region VR.ATO.IEE.410396
        //IF (RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) 
        //AND (PARENT RETURN:RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) 
        //AND (RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> PARENT RETURN:RP:tns:Identifiers.AustralianBusinessNumber.Identifier)
        //    RETURN VALIDATION MESSAGE
        //ENDIF
        private void VRATOIEE410396(List<ProcessMessageDocument> response)
        {
            bool assertion = !string.IsNullOrWhiteSpace(ParentDocument.SMSFAR5) &&
                             !string.IsNullOrWhiteSpace(ChildDocument.IEE162) &&
                             !ParentDocument.SMSFAR5.Equals(ChildDocument.IEE162);
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402010",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied ABN does not match the ABN supplied on the form it was submitted with",
                    LongDescription = "Your supplied ABN does not match the ABN supplied on the parent form it was submitted with",
                    Location = "/tns:IEE/tns:RP/tns:AustralianBusinessNumberId",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IEE.410396" } }
                });
            }
        }
        #endregion

        #region VR.ATO.IEE.410410
        //WHERE PARENT RETURN EXISTS 
        //IF(IEE:RP:entity.identifier.TFN<> NULLORBLANK) AND(IEE:RP:entity.identifier.TFN<> PARENT RETURN:RP:entity.identifier.TFN)
        //    RETURN VALIDATION MESSAGE
        //ENDIF
        private void VRATOIEE410410(List<ProcessMessageDocument> response)
        {
            bool assertion = !string.IsNullOrWhiteSpace(ChildDocument.IEE3) &&
                             !ParentDocument.RPIdentifierTFN.Equals(ChildDocument.IEE3);
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.410115",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "TFN on Schedule must match TFN on main form",
                    Location = "/tns:IEE/tns:RP/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IEE.410410" } }
                });
            }
        }
        #endregion

        #region VR.ATO.IEE.410051
        //WHERE PARENT RETURN EXISTS
        //IF([IEE49] <> NULL) AND([IEE45] <> PARENT RETURN:Report.TargetFinancial.Year)
        //  RETURN VALIDATION MESSAGE
        //ENDIF
        private void VRATOIEE410051(List<ProcessMessageDocument> response)
        {
            bool assertion = ChildDocument.IEE49.HasValue && ChildDocument.IEE45 != ParentDocument.SMSFAR1;
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.IEE.410235",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Election Commencement Time must not be present if Income Year Specified is different to the parent return target financial year",
                    Location = "/tns:IEE/tns:RP/tns:InterposedEntityElectionRevocationDetails/tns:ElectionsCommencementD",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IEE.410051" },
                        new ProcessMessageParameter { Name = "IEE49", Value = ChildDocument.IEE49.Value.ToString() }
                    }
                });
            }
        }
        #endregion
    }
}