using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using VaTS;
using System;
using System.Collections.Immutable;

namespace Ato.CD.Inbound.TRTAMI202502
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<TRTAMI2025, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            ImmutableDictionary<string, Func<TRTAMI2025, BusinessDocument, ICrossFormValidator>>.Builder builder = ImmutableDictionary.CreateBuilder<string, Func<TRTAMI2025, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.CGTS.ToString(), (parent, schedule) => new CrossFormValidatorCGTS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.IDS.ToString(), (parent, schedule) => new CrossFormValidatorIDS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.PSS.ToString(), (parent, schedule) => new CrossFormValidatorPSS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.RS.ToString(), (parent, schedule) => new CrossFormValidatorRS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.TRTAMIS.ToString(), (parent, schedule) => new CrossFormValidatorTRTAMIS(parent, schedule.ConsumedReport));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(TRTAMI2025 parent, BusinessDocument schedule) => CrossFormValidators[schedule.DocumentName](parent, schedule);
    }
}