using System.IO;
using System.Runtime.Serialization;

namespace VaTS
{

    public class BusinessDocument
    {
        /// <summary>
        /// This document name is a combination of thrre values. It is used to specify the name, version and request / resppnse indicator eg;
        /// Stic.2013.Request
        /// </summary>
        [DataMember(Name = "DocumentName", IsRequired = true, Order = 0)]
        public string DocumentName { get; set; }

        /// <summary>
        /// The document URI of the schema that applies to the Document property.
        /// </summary>
        [DataMember(Name = "DocumentUri", IsRequired = false, Order = 9)]
        public string DocumentUri { get; set; }

        /// <summary>
        /// Used only for the validation and transformation of related documents.  Will contain child documents associated with the primary document.
        /// </summary>
        [DataMember(Name = "ChildDocuments", IsRequired = false, Order = 10)]
        public BusinessDocumentCollection ChildDocuments { get; set; }

        /// <summary>
        /// The consumed report is used with generated code for services that used multiple documents.
        /// Where a parent document is consumed from its source into a intermediate format it can be stored here to be used
        /// for cross form validation or transformation.
        /// </summary>
        /// <value>
        /// The consumed report.
        /// </value>
        /// <remarks>Note that this is set to IgnoreDataMember as it is not something to be used or known about by the platform that calls VaTS services</remarks>
        [IgnoreDataMember]
        public object ConsumedReport { get; set; }

        public MemoryStream DocumentStream { get; set; }
    }
}