using System;
using System.Collections.Generic;
using DataContracts;

namespace Ato.EN.IntegrationServices.CodeGenerationCGLS {
    public partial class CGLS2017Validator {
    
    #region Cross Form Rules - not supported yet

        #region VR.ATO.CGLS.404006

        /*  VR.ATO.CGLS.404006
                    The total amount of tax losses deducted on the CGLS for a consolidated group must equal the amount of tax losses deducted on the CTR.

                Legacy Rule Format:
                    IF [CGLS107] > 0 AND
                        [CGLS107] <>[CTR117]
                                 RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CGLS107] = CGLS:RP.TOT:rvctc3.02.15:Tax.Losses.Deducted.Amount
                    [CTR117] = CTR:RP:rvctc2.02.00:IncomeTax.Deduction.TaxLossesDeducted.Amount

            Technical Business Rule Format:
                    ^CGLS107 > 0 AND    ^CGLS107 <>^CTR117

        Data Elements:
            
                    RP.TOT:^CGLS107 = tns:Tax.Losses.Deducted.Amount
            
                    RP.TOT:^CTR117 = CTR:RP:rvctc2.02.00:IncomeTax.Deduction.TaxLossesDeducted.Amount
                    */
        protected void VRATOCGLS404006(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.CGLS.404006
            
            assertion = false; // = (report.CGLS107.GetValueOrDefault() > 0 && report.CGLS107.GetValueOrDefault() != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGLS.404212", Severity = ProcessMessageSeverity.Error,
                    Description = @"Total tax losses deducted must equal tax losses deducted on the Company Return",
                    LongDescription = @"(Tax losses deducted - Total) must equal (Tax losses deducted) on the Company Return",
                    //Location = "/xbrli:xbrl/tns:Tax.Losses.Deducted.Amount[@contextRef='" + report.RPTOTId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.CGLS.404006"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "CGLS107", Value = report.CGLS107.GetValueOrDefault().ToString() });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CGLS.404006

        #region VR.ATO.CGLS.404011

        /*  VR.ATO.CGLS.404011
                    The total amount of tax losses carried forward to later income years on the CGLS for a consolidated group must equal the amount of tax losses carried forward to later income years on the CTR.

                Legacy Rule Format:
                    IF [CGLS19] > 0 AND
                        [CGLS19] <> [CTR175]
                                 RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CGLS19] = CGLS:RP.TOT:rvctc3.02.00:Tax.Losses.CarriedForward.Total.Amount
                    [CTR175] = CTR:RP:rvctc3.02.00:Tax.Losses.CarriedForward.Total.Amount

            Technical Business Rule Format:
                    ^CGLS19 > 0 AND    ^CGLS19 <> ^CTR175

        Data Elements:
            
                    RP.TOT:^CGLS19 = tns:Tax.Losses.CarriedForward.Total.Amount
            
                    RP.TOT:^CTR175 = CTR:RP:rvctc3.02.00:Tax.Losses.CarriedForward.Total.Amount
                    */
        protected void VRATOCGLS404011(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.CGLS.404011
            
            assertion = false; // = (report.CGLS19.GetValueOrDefault() > 0 && report.CGLS19.GetValueOrDefault() != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGLS.404011", Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax losses carried forward must equal corresponding field on the Company Return",
                    LongDescription = @"(Tax losses carried forward to later income years - Total) must equal (Tax losses carried forward to later income years) on the Company Return",
                    //Location = "/xbrli:xbrl/tns:Tax.Losses.CarriedForward.Total.Amount[@contextRef='" + report.RPTOTId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.CGLS.404011"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "CGLS19", Value = report.CGLS19.GetValueOrDefault().ToString() });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CGLS.404011

        #region VR.ATO.GEN.402009

        /*  VR.ATO.GEN.402009
                    Your supplied TFN does not match the TFN supplied on the form it was submitted with

                Legacy Rule Format:
                    IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
                    RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^TFN <> ^ParentTFN

        Data Elements:
            
                    ^ParentTFN = ParentTFN
            
                    ^TFN = RP
                    */
        protected void VRATOGEN402009(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.402009
            
            assertion = false; // = ((report.RPExists == true) && (report.RPIdentifierTFN != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402009", Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.402009

        #region VR.ATO.GEN.402010

        /*  VR.ATO.GEN.402010
                    Your supplied ABN does not match the ABN supplied on the form it was submitted with

                Legacy Rule Format:
                    IF (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) AND (PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) AND (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier)
                    RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    (^CGLS3 <> BLANK) AND (^ParentABN <> BLANK) AND (^CGLS3 <> ^ParentABN)

        Data Elements:
            
                    RP:^CGLS3 = tns:Identifiers.AustralianBusinessNumber.Identifier
            
                    RP:^ParentABN = ParentABN
                    */
        protected void VRATOGEN402010(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.402010
            
            assertion = false; // = (string.IsNullOrWhiteSpace(report.CGLS3) != true &&  != null && report.CGLS3 != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402010", Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied ABN does not match the ABN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied ABN does not match the ABN supplied on the parent form it was submitted with",
                    //Location = "/xbrli:xbrl/tns:Identifiers.AustralianBusinessNumber.Identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.402010"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "CGLS3", Value = report.CGLS3 });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.402010

        #region VR.ATO.GEN.428045

        /*  VR.ATO.GEN.428045
                    Organisation Name in schedule should match Organisation Name in parent return

                Legacy Rule Format:
                    IF RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname1.xx.xx:OrganisationNameDetails) <> NULL
                    AND RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname1.xx.xx:OrganisationNameDetails) <> 
                    (PARENT RETURN:RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname2.xx.xx:OrganisationNameDetails)
                    WHERE (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.OrganisationalNameType.Code = "MN")
                    AND  (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.Currency.Code = "C")) 
                             RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^CGLS2 <> NULL AND ^CGLS2 <> ^ParentORGN.T

        Data Elements:
            
                    RP:^CGLS2 = tns:OrganisationNameDetails.OrganisationalName.Text WHERE [OrganisationNameDetails.OrganisationalNameType.Code='MN']
            
                    RP:^ParentORGN.T = ParentORGN.T
                    */
        protected void VRATOGEN428045(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.428045
            
            assertion = false; // = (report.CGLS2 != null && report.CGLS2 != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.428045", Severity = ProcessMessageSeverity.Error,
                    Description = @"Organisation Name in schedule should match Organisation Name in parent return",
                    //Location = "/xbrli:xbrl/tns:OrganisationNameDetails" + OccurrenceIndex(report.OrganisationNameDetailsCollection_MN_RPOccurrenceIndex) + "/tns:OrganisationNameDetails.OrganisationalName.Text",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.428045"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "CGLS2", Value = report.CGLS2 });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.428045

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(trfrContext.OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(jeContext.OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000__(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPGRPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000___(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000____(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_____(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTFOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000______(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTTOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_______(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPTRFDOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPTOTOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000__________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus1OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000___________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus2OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000____________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus4POccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_____________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus3OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP
                    */
        protected void VRATOGEN438001(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPExists == true) && (report.RPEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = TRFR
                    */
        protected void VRATOGEN438001_(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = (trfrContext.EndDate != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(trfrContext.OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = JE
                    */
        protected void VRATOGEN438001__(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = (jeContext.EndDate != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(jeContext.OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.COTP
                    */
        protected void VRATOGEN438001___(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPCOTPExists == true) && (report.RPCOTPEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.COTF
                    */
        protected void VRATOGEN438001____(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPCOTFExists == true) && (report.RPCOTFEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTFOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.COTT
                    */
        protected void VRATOGEN438001_____(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPCOTTExists == true) && (report.RPCOTTEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPCOTTOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.GRP
                    */
        protected void VRATOGEN438001______(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPGRPExists == true) && (report.RPGRPEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPGRPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.TRFD
                    */
        protected void VRATOGEN438001_______(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPTRFDExists == true) && (report.RPTRFDEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPTRFDOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.TOT
                    */
        protected void VRATOGEN438001________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPTOTExists == true) && (report.RPTOTEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPTOTOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0
                    */
        protected void VRATOGEN438001_________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Exists == true) && (report.RPY0EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-1
                    */
        protected void VRATOGEN438001__________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus1Exists == true) && (report.RPY0Minus1EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus1OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-2
                    */
        protected void VRATOGEN438001___________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus2Exists == true) && (report.RPY0Minus2EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus2OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-3
                    */
        protected void VRATOGEN438001____________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus3Exists == true) && (report.RPY0Minus3EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus3OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-4P
                    */
        protected void VRATOGEN438001_____________(List<ProcessMessageDocument> response, CGLS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus4PExists == true) && (report.RPY0Minus4PEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus4POccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001
    #endregion Cross Form Rules - not supported yet
        #region ValidateCrossFormRules

        public List<ProcessMessageDocument> ValidateCrossFormRules(CGLS2017 report)
        {
            List<ProcessMessageDocument> response = new List<ProcessMessageDocument>();
            #region Cross Form Rules
            VRATOCGLS404006(response, report);
            VRATOCGLS404011(response, report);
            VRATOGEN402009(response, report);
            VRATOGEN402010(response, report);
            VRATOGEN428045(response, report);
            VRATOGEN438000(response, report);
            VRATOGEN438000_(response, report);
            VRATOGEN438000__(response, report);
            VRATOGEN438000___(response, report);
            VRATOGEN438000____(response, report);
            VRATOGEN438000_____(response, report);
            VRATOGEN438000______(response, report);
            VRATOGEN438000_______(response, report);
            VRATOGEN438000________(response, report);
            VRATOGEN438000_________(response, report);
            VRATOGEN438000__________(response, report);
            VRATOGEN438000___________(response, report);
            VRATOGEN438000____________(response, report);
            VRATOGEN438000_____________(response, report);
            VRATOGEN438001(response, report);
            VRATOGEN438001_(response, report);
            VRATOGEN438001__(response, report);
            VRATOGEN438001___(response, report);
            VRATOGEN438001____(response, report);
            VRATOGEN438001_____(response, report);
            VRATOGEN438001______(response, report);
            VRATOGEN438001_______(response, report);
            VRATOGEN438001________(response, report);
            VRATOGEN438001_________(response, report);
            VRATOGEN438001__________(response, report);
            VRATOGEN438001___________(response, report);
            VRATOGEN438001____________(response, report);
            VRATOGEN438001_____________(response, report);
            #endregion Cross Form Rules
            return response;
        }

        #endregion
    }
}
