using System;
using System.Collections.Generic;
using Au.Gov.Sbr.Xbrl.Document;
using Au.Gov.Sbr.Xbrl.Metadata;
using System.Linq;
using System.Xml;
using System.Text.RegularExpressions;
using DataContracts;

namespace Ato.EN.IntegrationServices.CodeGenerationRPTTAXPOS
{
    public class RPTTAXPOS2019Consumer
    {

        private static Regex StripWhitespace = new Regex(@"\s*");

        #region Helper/Validation Methods
        private static bool? ToBoolean(string str)
        {
            bool returnValue;
            string value = (str ?? "").Trim();
            if (value == "0" || value == "1")
                return Convert.ToBoolean(Convert.ToInt32(value));
            
            if (Boolean.TryParse(value, out returnValue))
                return returnValue;
            return null;
        }

        private static string GetValueOrEmpty(bool? val)
        {
            return (val.HasValue) ? val.ToString().ToLower() : string.Empty;
        }

        private static string GetValueOrEmpty(DateTime? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        private static string GetValueOrEmpty(string val)
        {
            return !string.IsNullOrWhiteSpace(val) ? val : string.Empty;
        }

        private static string GetValueOrEmpty(decimal? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        private static string GetValueOrEmpty(int? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        /// <summary>
        /// Derives the SBR element location.
        /// </summary>
        /// <param name="sbrElement">The SBR element.</param>
        /// <param name="addOccurrenceIndex">if set to <c>true</c> [add occurrence the occurrence index to the path].</param>
        /// <returns></returns>
        private static string DeriveSbrElementLocation(SBRElement sbrElement, bool addOccurrenceIndex = false)
        {
            if (sbrElement == null) return "/xbrli:xbrl";
            int xpathOccurrence = sbrElement.OccurrenceIndex + 1;
            string location;

            if (addOccurrenceIndex)
            {
                location = "/" + sbrElement.NamespacePrefix + ":" + sbrElement.Name + "[" +
                           xpathOccurrence + "]";
            }
            else
            {
                location = "/" + sbrElement.NamespacePrefix + ":" + sbrElement.Name;
            }

            if (sbrElement.IsInTuple)
            {
                location = DeriveSbrElementLocation(sbrElement.ParentTuple, true) + location;
            }
            else
            {
                location = "/xbrli:xbrl" + location;
            }

            return location;
        }

        private static bool IsMatch(int? field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(Convert.ToString(field.Value), expression, options);
        }

        private static bool IsMatch(string field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(field, expression, options);
        }

        public DateTime AsDate(string dateAsString)
        {
            DateTime response = DateTime.MinValue;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date;
            }

            return response;
        }

         #endregion

        public RPTTAXPOS2019 Consume(SBRDocument sbrDocument)
        {
            List<ProcessMessageDocument> errors;
            return Consume(sbrDocument, false, out errors);
        }

        /// <summary>
        /// Allows for validation of rules that can not be generated and must run at a lower level.
        /// A sub-class will need to be created with an override for this method - which does nothing in its base implementation.
        /// </summary>
        /// <param name="sbrDocument">The SBR document.</param>
        /// <param name="populatedReportElementsMap">The populated report elements map can be used to find data elements and tuples.</param>
        /// <param name="contextArray">The context array can be used to find context values.</param>
        /// <param name="errors">The errors collection is to be populated with validation results.</param>
        protected virtual void ValidateUnsupportedRules(SBRDocument sbrDocument, IDictionary<string, SBRElement> populatedReportElementsMap, SBRContext[] contextArray, List<ProcessMessageDocument> errors)
        {

        }

        public RPTTAXPOS2019 Consume(SBRDocument sbrDocument, bool validationMode, out List<ProcessMessageDocument> errors)
        {
            RPTTAXPOS2019 report;
            report = new RPTTAXPOS2019();
            errors = new List<ProcessMessageDocument>();

            SBRContext[] contextArray;
            IDictionary<string, SBRElement> populatedReportElementsMap;

            contextArray = sbrDocument.ContextsMap.Values.ToArray();
            populatedReportElementsMap = sbrDocument.PopulatedChildElementsMap ?? new Dictionary<string, SBRElement>();

            if (validationMode) ValidateUnsupportedRules(sbrDocument, populatedReportElementsMap, contextArray, errors);

            /// <summary>
            /// Current element being extracted
            /// </summary>
            SBRElement currentValue = null;
            /// <summary>
            /// Current elements being extracted
            /// </summary>
            IList<SBRElement> currentValues = null;
            /// <summary>
            /// Current occurrences being extracted
            /// </summary>
            IList<SBRElement> currentOccurrences = null;
            /// <summary>
            /// Working Variable for date time variables
            /// </summary>
            DateTime currentDateTimeValue;
            /// <summary>
            /// Working Variable for boolean variables
            /// </summary>
            bool currentBooleanValue;
            /// <summary>
            /// Working Variable for decimal variables
            /// </summary>
            decimal currentDecimalValue;
            /// <summary>
            /// Working Variable for integer variables
            /// </summary>
            int currentIntValue;
            /// <summary>
            /// Working Variable for long variables
            /// </summary>
            long currentLongValue;
            XmlDocumentFragment currentSegment;
            XmlNamespaceManager currentNamespaceManager;
            XmlNode currentNode;
    
            #region sbrRPContext
            IEnumerable<SBRContext> sbrRPContexts = null;
            SBRContext sbrRPContext = null;
    
            sbrRPContexts = contextArray.Where(
                c => c.Period != null && c.Period.PeriodType == SBRPeriod_PeriodType.DURATION &&
                c.Segment != null && c.Segment.ExplicitOrTypedDimensionDomains.Count == 1 && 
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}ReportPartyTypeDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}ReportingParty")) ));
            Dictionary<string, IList<SBRElement>> sbrPopulatedRPElementsMap = new Dictionary<string, IList<SBRElement>>();
            if (sbrRPContexts != null && sbrRPContexts.Count() > 0)
            {
                sbrRPContext = sbrRPContexts.First();
        
                report.RPId = sbrRPContext.Id;
                report.RPIdentifier = sbrRPContext.EntityIdentifier;
                report.RPIdentifierScheme = sbrRPContext.EntityScheme;
        
                report.RPCount = sbrRPContexts.Count();
                report.RPExists = true;
                report.RPOccurrenceIndex = Array.IndexOf(contextArray, sbrRPContext) + 1;
                report.RPLastOccurrenceIndex = Array.IndexOf(contextArray, sbrRPContexts.Last()) + 1;
        

                if (report.RPIdentifierScheme == "http://www.ato.gov.au/tfn") report.RPIdentifierTFN = report.RPIdentifier;
    
                report.RPStartDate = ((SBRDurationPeriod)sbrRPContext.Period).DurationStartAsDateObject;
                report.RPEndDate = ((SBRDurationPeriod)sbrRPContext.Period).DurationEndAsDateObject;
        
                sbrPopulatedRPElementsMap = new System.Collections.Generic.Dictionary<string, IList<SBRElement>>();
                for (int i = 0; i < sbrRPContexts.Count(); i++)
                {
                    sbrRPContext = sbrRPContexts.ElementAt(i);
            
                    IList<SBRElement> elements = sbrDocument.ElementsByContextId[sbrRPContext.Id];
                    if (elements != null)
                    {
                        for (int e = 0; e < elements.Count(); e++)
                        {
                            SBRElement currentElement = elements[e];
                            if (currentElement == null || currentElement.IsInTuple) continue; // Don't add tuple elements here, they will be found through a different map.
                            if (sbrPopulatedRPElementsMap.ContainsKey("{" + currentElement.Namespace + "}" + currentElement.Name))
                            {
                                sbrPopulatedRPElementsMap["{" + currentElement.Namespace + "}" + currentElement.Name].Add(currentElement);
                            }
                            else
                            {
                                sbrPopulatedRPElementsMap.Add("{" + currentElement.Namespace + "}" + currentElement.Name, new List<SBRElement> { currentElement } );
                            }
                        }
                    }
                    report.RPTTAXPOS1 = report.RPIdentifier;
            
                    if (sbrPopulatedRPElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryAB.Indicator", out currentValues))
                    {
                        if (!currentValues[0].IsNil) report.RPTTAXPOS2 = ToBoolean(currentValues[0].Value);
                    }
            
                    if (sbrPopulatedRPElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryAB.Count", out currentValues))
                    {
                        if (!currentValues[0].IsNil) report.RPTTAXPOS3 = decimal.Parse(currentValues[0].Value);
                    }
        
                    IEnumerable<SBRElement> sbrReportableTaxPositionCategoryAAndBCollection;
                    if (populatedReportElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}ReportableTaxPositionCategoryAAndB", out currentValue))
                        sbrReportableTaxPositionCategoryAAndBCollection = currentValue.Occurrences;
                    else
                        sbrReportableTaxPositionCategoryAAndBCollection = null;
            
                    #region sbrReportableTaxPositionCategoryAAndBCollection
            
                    if (sbrReportableTaxPositionCategoryAAndBCollection != null)
                    {
                        report.ReportableTaxPositionCategoryAAndBCollectionExists = true;
                        report.ReportableTaxPositionCategoryAAndBCollectionCount = sbrReportableTaxPositionCategoryAAndBCollection.Count();
                        if (sbrReportableTaxPositionCategoryAAndBCollection != null && sbrReportableTaxPositionCategoryAAndBCollection.Count() > 0)
                        {
                            report.ReportableTaxPositionCategoryAAndBCollection = new List<RPTTAXPOS2019.ReportableTaxPositionCategoryAAndB>();
                            for (int tupleIndex = 0; tupleIndex < sbrReportableTaxPositionCategoryAAndBCollection.Count(); tupleIndex++)
                            {
                                SBRElement sbrReportableTaxPositionCategoryAAndB;
                                sbrReportableTaxPositionCategoryAAndB = sbrReportableTaxPositionCategoryAAndBCollection.ElementAt(tupleIndex);
                
                                IDictionary<string, SBRElement> sbrReportableTaxPositionCategoryAAndBTupleElementMap;
                                sbrReportableTaxPositionCategoryAAndBTupleElementMap = sbrReportableTaxPositionCategoryAAndB.PopulatedChildElementsMap ?? new Dictionary<string, SBRElement>();
                
                                RPTTAXPOS2019.ReportableTaxPositionCategoryAAndB reportableTaxPositionCategoryAAndB = new RPTTAXPOS2019.ReportableTaxPositionCategoryAAndB();
                                report.ReportableTaxPositionCategoryAAndBCollection.Add(reportableTaxPositionCategoryAAndB);
                                reportableTaxPositionCategoryAAndB.OccurrenceIndex = tupleIndex + 1;
                        
                                if (sbrReportableTaxPositionCategoryAAndBTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryAAndB.RPTTAXPOS4 = currentValue.Value;
                                }
                        
                                if (sbrReportableTaxPositionCategoryAAndBTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionDiscussion.Indicator", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryAAndB.RPTTAXPOS5 = ToBoolean(currentValue.Value);
                                }
                        
                                if (sbrReportableTaxPositionCategoryAAndBTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategory.Code", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryAAndB.RPTTAXPOS6 = currentValue.Value;
                                }
                        
                                if (sbrReportableTaxPositionCategoryAAndBTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryDescription.Text", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryAAndB.RPTTAXPOS7 = currentValue.Value;
                                }
                        
                                if (sbrReportableTaxPositionCategoryAAndBTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionBasis.Text", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryAAndB.RPTTAXPOS8 = currentValue.Value;
                                }
                    } 
                    #endregion End of Tuple sbrReportableTaxPositionCategoryAAndBCollection
                        } 
                    } 
            
                    if (sbrPopulatedRPElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryC.Indicator", out currentValues))
                    {
                        if (!currentValues[0].IsNil) report.RPTTAXPOS9 = ToBoolean(currentValues[0].Value);
                    }
            
                    if (sbrPopulatedRPElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryC.Count", out currentValues))
                    {
                        if (!currentValues[0].IsNil) report.RPTTAXPOS10 = decimal.Parse(currentValues[0].Value);
                    }
        
                    IEnumerable<SBRElement> sbrReportableTaxPositionCategoryCCollection;
                    if (populatedReportElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}ReportableTaxPositionCategoryC", out currentValue))
                        sbrReportableTaxPositionCategoryCCollection = currentValue.Occurrences;
                    else
                        sbrReportableTaxPositionCategoryCCollection = null;
            
                    #region sbrReportableTaxPositionCategoryCCollection
            
                    if (sbrReportableTaxPositionCategoryCCollection != null)
                    {
                        report.ReportableTaxPositionCategoryCCollectionExists = true;
                        report.ReportableTaxPositionCategoryCCollectionCount = sbrReportableTaxPositionCategoryCCollection.Count();
                        if (sbrReportableTaxPositionCategoryCCollection != null && sbrReportableTaxPositionCategoryCCollection.Count() > 0)
                        {
                            report.ReportableTaxPositionCategoryCCollection = new List<RPTTAXPOS2019.ReportableTaxPositionCategoryC>();
                            for (int tupleIndex = 0; tupleIndex < sbrReportableTaxPositionCategoryCCollection.Count(); tupleIndex++)
                            {
                                SBRElement sbrReportableTaxPositionCategoryC;
                                sbrReportableTaxPositionCategoryC = sbrReportableTaxPositionCategoryCCollection.ElementAt(tupleIndex);
                
                                IDictionary<string, SBRElement> sbrReportableTaxPositionCategoryCTupleElementMap;
                                sbrReportableTaxPositionCategoryCTupleElementMap = sbrReportableTaxPositionCategoryC.PopulatedChildElementsMap ?? new Dictionary<string, SBRElement>();
                
                                RPTTAXPOS2019.ReportableTaxPositionCategoryC reportableTaxPositionCategoryC = new RPTTAXPOS2019.ReportableTaxPositionCategoryC();
                                report.ReportableTaxPositionCategoryCCollection.Add(reportableTaxPositionCategoryC);
                                reportableTaxPositionCategoryC.OccurrenceIndex = tupleIndex + 1;
                        
                                if (sbrReportableTaxPositionCategoryCTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryC.RPTTAXPOS11 = currentValue.Value;
                                }
                        
                                if (sbrReportableTaxPositionCategoryCTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionDiscussion.Indicator", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryC.RPTTAXPOS12 = ToBoolean(currentValue.Value);
                                }
                        
                                if (sbrReportableTaxPositionCategoryCTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryCQuestion.Number", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryC.RPTTAXPOS13 = decimal.Parse(currentValue.Value);
                                }
                        
                                if (sbrReportableTaxPositionCategoryCTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionCategoryCSubcategory.Number", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryC.RPTTAXPOS14 = decimal.Parse(currentValue.Value);
                                }
                        
                                if (sbrReportableTaxPositionCategoryCTupleElementMap.TryGetValue("{http://www.sbr.gov.au/ato/rpttaxpos}RegulatoryDisclosures.ReportableTaxPositionAdditionalInformation.Text", out currentValue))
                                {
                                    if (!currentValue.IsNil) reportableTaxPositionCategoryC.RPTTAXPOS15 = currentValue.Value;
                                }
                    } 
                    #endregion End of Tuple sbrReportableTaxPositionCategoryCCollection
                        } 
                    } 
                } 
            } 
            #endregion End of Context sbrRPContext
            return report;

        } // Of Consume Method
    } // Of Class
} // Of Namespace

