using System;
using System.Collections.Immutable;
using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationCTR;
using VaTS;

namespace Ato.CD.Inbound.CTR202402
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<CTR2024, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            var builder = ImmutableDictionary.CreateBuilder<string, Func<CTR2024, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.CGLS.ToString(), (report, schedule) => new CrossFormValidatorCGLS(report, schedule));
            builder.Add(Schedule.CGNFT.ToString(), (report, schedule) => new CrossFormValidatorCGNFT(report, schedule));
            builder.Add(Schedule.CGTS.ToString(), (report, schedule) => new CrossFormValidatorCGTS(report, schedule));
            builder.Add(Schedule.DIS.ToString(), (report, schedule) => new CrossFormValidatorDIS(report, schedule));
			builder.Add(Schedule.DISTBENTRT.ToString(), (report, schedule) => new CrossFormValidatorDISTBENTRT(report, schedule));
            builder.Add(Schedule.IDS.ToString(), (report, schedule) => new CrossFormValidatorIDS(report, schedule));
            builder.Add(Schedule.IEE.ToString(), (report, schedule) => new CrossFormValidatorIEE(report, schedule));
            builder.Add(Schedule.LS.ToString(), (report, schedule) => new CrossFormValidatorLS(report, schedule));
            builder.Add(Schedule.PSS.ToString(), (report, schedule) => new CrossFormValidatorPSS(report, schedule));
            builder.Add(Schedule.RDTIS.ToString(), (report, schedule) => new CrossFormValidatorRDTIS(report, schedule));
            builder.Add(Schedule.RPTTAXPOS.ToString(), (report, schedule) => new CrossFormValidatorRPTTAXPOS(report, schedule));
            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(BusinessDocument schedule, CTR2024 report)
            => CrossFormValidators[schedule.DocumentName](report, schedule);
    }
}