using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationCTR;
using Ato.EN.IntegrationServices.CodeGenerationCGNFT;
using DataContracts;
using System;

namespace Ato.CD.Inbound.CTR202402
{
    internal class CrossFormValidatorCGNFT : ICrossFormValidator
    {
        private CTR2024 ParentDocument { get; }

        private CGNFT2018 ChildDocument { get; }

        internal CrossFormValidatorCGNFT(CTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;          
            ChildDocument = (CGNFT2018)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();
            VRATOCGNFT000027(response);
            VRATOCGNFT000030(response);
            VRATOCGNFT000057(response);

            return response;
        }

        #region VR.ATO.CGNFT.000027
            /*  VR.ATO.CGNFT.000027
                    IF (PARENT RETURN <> NULL) AND (RP:period.startDate <> CTR:RP:period.startDate)
                         RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCGNFT000027(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            bool assertion = ParentDocument.RPStartDate.GetValueOrDefault() != ChildDocument.RPStartDate.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGNFT.000027",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Invalid context. Period start date must be the same as the Period start date of the parent form.",
                    Location = ChildDocument.RPOccurrenceIndex>1 ? "/xbrli:xbrl/xbrli:context[" + ChildDocument.RPOccurrenceIndex.ToString() + "]xbrli:period/xbrli:startDate"
                    : "/xbrli:xbrl/xbrli:context/xbrli:period/xbrli:startDate",                 
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGNFT.000027" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CGNFT.000027

        #region VR.ATO.CGNFT.000030

        /*  VR.ATO.CGNFT.000030
                    IF (PARENT RETURN <> NULL) AND (RP:period.endDate <> CTR:RP:period.endDate)
                         RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCGNFT000030(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            bool assertion = ParentDocument.RPEndDate.GetValueOrDefault() != ChildDocument.RPEndDate.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGNFT.000030",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Invalid context. Period end date must be the same as the Period end date of the parent form.",
                    Location = ChildDocument.RPOccurrenceIndex > 1 ? "/xbrli:xbrl/xbrli:context[" + ChildDocument.RPOccurrenceIndex.ToString() + "]xbrli:period/xbrli:endDate"
                     : "/xbrli:xbrl/xbrli:context/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGNFT.000030" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CGNFT.000030

        #region VR.ATO.CGNFT.000057

        /*  VR.ATO.CGNFT.000057
                 
                    IF (PARENT RETURN <> NULL) AND ((CTR:RP.Period.Start.Date <> NULL) AND 
                    (CTR:RP.Period.End.Date <> NULL)) AND
                    (([cgnft6] < 2002-07-01) OR ([cgnft6] < CTR:RP.Period.Start.Date) OR ([cgnft6] > CTR:RP.Period.End.Date))
                       RETURN VALIDATION MESSAGE
                    ENDIF
               
                    */
        protected void VRATOCGNFT000057(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            // = ( != null &&  != null && (report.CGNFT6.GetValueOrDefault() < AsDate(@"2002-07-01") || report.CGNFT6.GetValueOrDefault() <  || report.CGNFT6.GetValueOrDefault() > ));

            bool assertion = ParentDocument.RPEndDate.HasValue && ParentDocument.RPStartDate.HasValue &&
                  (  ChildDocument.CGNFT6.GetValueOrDefault() < DateTime.Parse(@"2002-07-01") ||
                     ChildDocument.CGNFT6.GetValueOrDefault() > ParentDocument.RPEndDate.GetValueOrDefault() ||
                     ChildDocument.CGNFT6.GetValueOrDefault() < ParentDocument.RPStartDate.GetValueOrDefault()
                  );

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGNFT.000057",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Date of consolidation is invalid",
                    LongDescription = @"The Date of consolidation must not be prior to 01/07/2002 and must be within the financial year of income applying to the income tax return of the head company",
                    Location = "/xbrli:xbrl/tns:OrganisationDetails.TaxConsolidation.Date",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGNFT.000057" } },
                };

               
                    processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "CGNFT6", Value = ChildDocument.CGNFT6.GetValueOrDefault().ToString() });
                
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CGNFT.000057

    }
}
