using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationCTR;
using Ato.EN.IntegrationServices.CodeGenerationDIS;
using DataContracts;

namespace Ato.CD.Inbound.CTR202402
{
    internal class CrossFormValidatorDIS : ICrossFormValidator
    {
        private CTR2024 ParentDocument { get; }

        private DIS2018 ChildDocument { get; }

        internal CrossFormValidatorDIS(CTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (DIS2018)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATODIS406032(response);
            VRATODIS406036(response);
            VRATODIS406038(response);
           
            return response;
        }

        #region VR.ATO.DIS.406032

        /*  VR.ATO.DIS.406032
                   
                    WHERE PARENT RETURN EXISTS
                        IF (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) AND
                        (PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) 
                        AND (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <>
                            PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier)
                    RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATODIS406032(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = !string.IsNullOrWhiteSpace(ChildDocument.DIS23) && !string.IsNullOrWhiteSpace(ParentDocument.CTR11) &&
                    !ChildDocument.DIS23.Equals(ParentDocument.CTR11);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402010",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied ABN does not match the ABN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied ABN does not match the ABN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/tns:Identifiers.AustralianBusinessNumber.Identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.DIS.406032" } },
                };

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.DIS.406032

        #region VR.ATO.DIS.406036

        /*  VR.ATO.DIS.406036
               
                    WHERE PARENT RETURN EXISTS
                    IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
                    RETURN VALIDATION MESSAGE
                    ENDIF

                    */
        protected void VRATODIS406036(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = !string.IsNullOrWhiteSpace(ChildDocument.RPIdentifierTFN) &&
                            ! ChildDocument.RPIdentifierTFN.Equals(ParentDocument.RPIdentifierTFN);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.DIS.406036",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with.",
                    Location = ChildDocument.RPOccurrenceIndex > 1 ? "/xbrli:xbrl/xbrli:context[" + ChildDocument.RPOccurrenceIndex.ToString() + "]/xbrli:entity/xbrli:identifier" : $"/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.DIS.406036" } },
                };

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.DIS.406036

        #region VR.ATO.DIS.406038

        /*  VR.ATO.DIS.406038
                  
                    WHERE PARENT RETURN EXISTS
                    IF RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\orgname1.xx.xx:OrganisationNameDetails) <> NULL
                    AND RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\orgname1.xx.xx:OrganisationNameDetails) <> 
                    (PARENT RETURN:RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\orgname2.xx.xx:OrganisationNameDetails)
                    WHERE (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.OrganisationalNameType.Code = "MN")
                    AND  (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.Currency.Code = "C")) 
                    RETURN VALIDATION MESSAGE
                    ENDIF

                    */
        protected void VRATODIS406038(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
           
            bool assertion = !string.IsNullOrWhiteSpace(ChildDocument.DIS24) &&
                         !ChildDocument.DIS24.Equals(ParentDocument.CTR9);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.DIS.406038",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Organisation main name on schedule does not match parent return.",                   
                    Location = ChildDocument.OrganisationNameDetailsCollection_MN_RPOccurrenceIndex > 1 ? "/xbrli:xbrl/tns:OrganisationNameDetails[" + ChildDocument.OrganisationNameDetailsCollection_MN_RPOccurrenceIndex + "]/tns:OrganisationNameDetails.OrganisationalName.Text"
                    : "/xbrli:xbrl/tns:OrganisationNameDetails/tns:OrganisationNameDetails.OrganisationalName.Text",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.DIS.406038" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.DIS.406038

        //Below rules need move to DIS
    }
}
