using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationIDS;
using DataContracts;
using Ato.EN.IntegrationServices.CodeGenerationCTR;

namespace Ato.CD.Inbound.CTR202402
{
    internal class CrossFormValidatorIDS : ICrossFormValidator
    {
        private CTR2024 ParentDocument { get; }

        private IDS2024 ChildDocument { get; }

        private List<Context> Contexts { get; }

        internal CrossFormValidatorIDS(CTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (IDS2024)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOCTR428426(response);
            VRATOCTR428406(response);
            VRATOCTR428412(response);
            VRATOCTR428419(response);
            VRATOCTR428410(response);
            VRATOCTR428418(response);
            VRATOCTR428427(response);
            VRATOCTR428422(response);
            VRATOCTR428421(response);
            VRATOCTR428413(response);
            VRATOCTR428415(response);
            VRATOCTR428405(response);
            VRATOCTR428417(response);
            VRATOCTR428414(response);
            VRATOCTR428416(response);
            VRATOCTR428409(response);
            VRATOCTR428420(response);
            VRATOCTR428408(response);
            VRATOCTR438050(response);
            // IDS_CTR
            VRATOIDS440670(response);

            return response;
        }

        //CTR_IDS

        #region VR.ATO.CTR.428426

        /*  VR.ATO.CTR.428426
              
                    IF ([CTR51] <> "NonResidentPermEstab") AND ([IDS221] = TRUE)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR51] = CTR:RP:pyde.02.10:Residency.TaxPurposesOrganisationStatus.Code
                    [IDS221] = IDS:RP:bafpo6.02.09:Liabilities.ThinCapitalisation.AustralianResidentCompanyElected.Indicator
                    */
        protected void VRATOCTR428426(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;


            // = (report.CTR51 != @"NonResidentPermEstab" &&  == true);

            bool assertion = ParentDocument.CTR51!= @"NonResidentPermEstab" && ChildDocument.IDS221.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.430011",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Status of company is incorrect",
                    LongDescription = @"If there is a 'True' response to ""Has an Australian resident company elected under subdivision 820-FB of the ITAA 1997 to treat your qualifying Australian branch operations as part of a consolidated group, MEC group or a single company for thin capitalisation purposes?"" on the IDS then the residency status at Status of company must be Non-resident with permanent establishment on the company return",
                    Location = "/xbrli:xbrl/tns:Residency.TaxPurposesOrganisationStatus.Code",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428426" } },
                };
                   processMessage.Parameters.Add(new ProcessMessageParameter{ Name = "CTR51", Value = ParentDocument.CTR51 });
                    processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS221", Value = ChildDocument.IDS221.GetValueOrDefault().ToString() });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428426

        #region VR.ATO.CTR.428406

        /*  VR.ATO.CTR.428406
                 
                    IF ([CTR57] = NULL OR [CTR57] = 0) AND (([CTR366] = NULL OR [CTR366] = 0) AND ([IDS22] > 0))
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR57] = CTR:RP:lrla.02.00:Remuneration.PaymentToForeignResidentGross.Amount
                    [CTR366] = CTR:RP.JFOREIGN:bafpr1.02.27:Expense.Royalties.Amount
                    [IDS22] = IDS:RP.Royalties:bafpr1.02.12:Expense.DeductionsTotal.Amount

                    */
        protected void VRATOCTR428406(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            bool assertion = (!ParentDocument.CTR57.HasValue || ParentDocument.CTR57.Value == 0) &&
                            ((!ParentDocument.CTR366.HasValue || ParentDocument.CTR366.Value == 0) && ChildDocument.IDS22 > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.438069",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Royalty expenses overseas or Foreign resident withholding expenses (excluding capital gains) required.",
                    LongDescription = @"If a Royalties deduction amount has been completed on the IDS then Foreign resident withholding (excluding capital gains) expenses or Royalty expenses overseas must be greater than zero on the company return form.",
                    Location = "/xbrli:xbrl/tns:Remuneration.PaymentToForeignResidentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428406" } },
                };            
                    processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR57", Value = ParentDocument.CTR57.GetValueOrDefault().ToString() });
                    processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR366", Value = ParentDocument.CTR366.GetValueOrDefault().ToString() });
                    processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS22", Value = ChildDocument.IDS22.ToString() });
                 response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428406

        #region VR.ATO.CTR.428412

        /*  VR.ATO.CTR.428412
                
                    IF (([CTR57] = NULL OR [CTR57] = 0) AND ([CTR64] = NULL OR [CTR64] = 0)) AND ([IDS103] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR57] = CTR:RP:lrla.02.00:Remuneration.PaymentToForeignResidentGross.Amount
                    [CTR64] = CTR:RP:bafpr2.02.02:Income.Interest.Gross.Amount
                    [IDS103] = IDS:RP.OtherInterest:bafpr1.02.26:Revenue.Total.Amount
                    */
        protected void VRATOCTR428412(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
     
            bool assertion = ((!ParentDocument.CTR57.HasValue || ParentDocument.CTR57.Value == 0) && (!ParentDocument.CTR64.HasValue || ParentDocument.CTR64.Value == 0))
                             && ChildDocument.IDS103 > 0;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.438070",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross interest or Gross payments subject to foreign resident withholding (excluding capital gains) required.",
                    LongDescription = @"If Interest revenue has been completed on the IDS then Gross interest or Gross payments subject to foreign resident withholding (excluding capital gains) must be greater than zero on the company return form.",
                    Location = "/xbrli:xbrl/tns:Remuneration.PaymentToForeignResidentGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428412" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR57", Value = ParentDocument.CTR57.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR64", Value = ParentDocument.CTR64.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS103", Value = ChildDocument.IDS103.ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428412

        #region VR.ATO.CTR.428419

        /*  VR.ATO.CTR.428419
                    IF ([CTR59] = NULL OR [CTR59] = 0) AND [IDS18] > 0
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCTR428419(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;

            bool assertion = (!ParentDocument.CTR59.HasValue || ParentDocument.CTR59.Value == 0) && ChildDocument.IDS18 > 0;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428419",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other sales of goods and services required",
                    LongDescription = @"If a revenue amount has been completed at 'Tangible property of a revenue nature including trading stock and raw materials' on the IDS then Other sales of goods and services must be greater than zero on the company return form.",
                    Location = "/xbrli:xbrl/tns:Income.SaleOfGoodsAndServices.Other.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428419" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR59", Value = ParentDocument.CTR59.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS18", Value = ChildDocument.IDS18.ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428419

        #region VR.ATO.CTR.428410
       /*  VR.ATO.CTR.428410
                 IF ([CTR65] = NULL OR [CTR65] = 0) AND ([IDS32] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCTR428410(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = (!ParentDocument.CTR65.HasValue || ParentDocument.CTR65.Value == 0) && 
                (ChildDocument.IDS32.HasValue && ChildDocument.IDS32 > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428410",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross rent and other leasing and hiring income required",
                    LongDescription = @"If Rent/leasing revenue has been completed on the IDS then Gross rent and other leasing and hiring income must be greater than zero on the company return form",
                    Location = "/xbrli:xbrl/tns:Income.RentLeasingHiringGross.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428410" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR65", Value = ParentDocument.CTR65.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS32", Value = ChildDocument.IDS32.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428410

        #region VR.ATO.CTR.428418

        /*  VR.ATO.CTR.428418
                
                    IF [CTR73] = NULL AND ([IDS17] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                 
                    */
        protected void VRATOCTR428418(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = !ParentDocument.CTR73.HasValue  && ChildDocument.IDS17 > 0;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428418",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Cost of sales required",
                    LongDescription = @"If an expenditure amount has been completed at 'Tangible property of a revenue nature including trading stock and raw materials' on the IDS then Cost of sales must be completed on the company return form.",
                    Location = "/xbrli:xbrl/tns:Expense.Operating.CostOfSales.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428418" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR73", Value = ParentDocument.CTR73.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS17", Value = ChildDocument.IDS17.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428418

        #region VR.ATO.CTR.428427

        /*  VR.ATO.CTR.428427
                  
                    IF ([CTR89] = FALSE) AND ([IDS208] = TRUE)
                       RETURN VALIDATION MESSAGE
                    ENDIF
               
                    */
        protected void VRATOCTR428427(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
           
            bool assertion = ParentDocument.CTR89.GetValueOrDefault()==false && ChildDocument.IDS208.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428427",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Check response to CGT event question",
                    LongDescription = @"If there is a 'True' response to 'Did you have any capital gains tax (CGT) events in relation to your interest in a foreign company?' On the IDS then a 'True' response is required at 'Did you have a CGT event during the year?' on the company return.",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.Event.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428427" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428427

        #region VR.ATO.CTR.428422

        /*  VR.ATO.CTR.428422
                  
                    IF (([CTR91] = NULL) AND ([IDS209] > 0))
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCTR428422(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            bool assertion = !ParentDocument.CTR91.HasValue && ChildDocument.IDS209 > 0;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428422",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net capital gain required",
                    LongDescription = @"If Capital gain amounts has been completed on the IDS then Net capital gain must be completed on the main return.",
                     Location = "/xbrli:xbrl/tns:Income.CapitalGainsNet.Amount[@contextRef='" + ParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428422" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR91", Value = ParentDocument.CTR91.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS209", Value = ChildDocument.IDS209.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428422

        #region VR.ATO.CTR.428421

        /*  VR.ATO.CTR.428421
             
                    IF ([CTR95] = NULL OR [CTR95] = 0) AND ([IDS219] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR95] = CTR:RP:bafpr1.02.02:Income.AssessableOther.Amount
                    [IDS219] = IDS:RP:bafpo7.02.11:Assets.Investment.ForeignHybridLimitedPartnershipOrForeignHybridCompanyNetIncomeProfitTotal.Amount

                    */
        protected void VRATOCTR428421(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
        
            bool assertion = (!ParentDocument.CTR95.HasValue || ParentDocument.CTR95.Value == 0) &&
               (ChildDocument.IDS219.HasValue && ChildDocument.IDS219 > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428421",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other assessable income required",
                    LongDescription = @"If Total amount of your share of net income/distribution of profit has been completed on the IDS then Other assessable income must be completed on the company return form.",
                    Location = "/xbrli:xbrl/tns:Income.AssessableOther.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428421" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR95", Value = ParentDocument.CTR95.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS219", Value = ChildDocument.IDS219.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428421

        #region VR.ATO.CTR.428413

        /*  VR.ATO.CTR.428413
                   
                    IF ([CTR156] > 0 OR [CTR158] > 0 OR [CTR159] > 0) AND ((([IDS191] + [IDS192] + [IDS193]) < ([CTR156] + [CTR158])) OR (([IDS191] + [IDS192] + [IDS193]) > ([CTR156] + [CTR158] + [CTR159])))
                       RETURN VALIDATION MESSAGE
                    ENDIF
                */
        protected void VRATOCTR428413(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
               bool assertion = (ParentDocument.CTR156.GetValueOrDefault() > 0 || ParentDocument.CTR158.GetValueOrDefault() > 0 || ParentDocument.CTR159.GetValueOrDefault() > 0) &&
                             (
                               (ChildDocument.IDS191.GetValueOrDefault() + ChildDocument.IDS192.GetValueOrDefault() + ChildDocument.IDS193.GetValueOrDefault()) <
                               (ParentDocument.CTR156.GetValueOrDefault() + ParentDocument.CTR158.GetValueOrDefault()) ||
                               (ChildDocument.IDS191.GetValueOrDefault() + ChildDocument.IDS192.GetValueOrDefault() + ChildDocument.IDS193.GetValueOrDefault()) >
                               (ParentDocument.CTR156.GetValueOrDefault() + ParentDocument.CTR158.GetValueOrDefault() + ParentDocument.CTR159.GetValueOrDefault())
                              );
                
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.430222",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Attributed foreign income incorrect",
                    LongDescription = @"The sum of amounts at attributable income of controlled foreign companies and controlled foreign trusts on the International Dealing Schedule should be equal to or greater than the sum of amounts at Listed country, Unlisted country and equal to or less than the sum of amounts at Listed country,Unlisted country and Transferor trust on the company return form.",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.TransferorTrustAttributedForeignIncome.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428413" } },
                };
                            
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR156", Value = ParentDocument.CTR156.GetValueOrDefault().ToString() });
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR158", Value = ParentDocument.CTR158.GetValueOrDefault().ToString() });
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR159", Value = ParentDocument.CTR159.GetValueOrDefault().ToString() });
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS191", Value = ChildDocument.IDS191.GetValueOrDefault().ToString() });
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS192", Value = ChildDocument.IDS192.GetValueOrDefault().ToString() });
                  processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS193", Value = ChildDocument.IDS193.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428413

        #region VR.ATO.CTR.428415

        /*  VR.ATO.CTR.428415
               
                    IF [CTR195] = FALSE AND ([IDS191] > 0 OR [IDS192] > 0 OR [IDS193] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
         
         */
        protected void VRATOCTR428415(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
      
            bool assertion = !ParentDocument.CTR195.GetValueOrDefault() && 
                (ChildDocument.IDS191.GetValueOrDefault() >0 || ChildDocument.IDS192.GetValueOrDefault() > 0 || ChildDocument.IDS193.GetValueOrDefault() > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428415",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Response required at overseas interests question",
                    LongDescription = @"If assessable income of controlled foreign companies and controlled foreign trusts under sections 456, 457 or 459A has been completed on the IDS then the response to the Overseas interests question on the company return form must be 'True'.",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.DirectOrIndirectOverseasInterest.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428415" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR195", Value = ParentDocument.CTR195.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS191", Value = ChildDocument.IDS191.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS192", Value = ChildDocument.IDS192.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS193", Value = ChildDocument.IDS193.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428415

        #region VR.ATO.CTR.428405

        /*  VR.ATO.CTR.428405
                
                    IF ([CTR196] = FALSE) AND ([IDS220] = TRUE)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR196] = CTR:RP:bafpo6.02.15:Liabilities.ThinCapitalisation.ProvisionsApplied.Indicator
                    [IDS220] = IDS:RP:bafpo6.02.15:Liabilities.ThinCapitalisation.ProvisionsApplied.Indicator
                    */
        protected void VRATOCTR428405(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            
            bool assertion = !ParentDocument.CTR196.GetValueOrDefault() && ChildDocument.IDS220.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428405",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Check response to Thin Capitalisation question",
                    LongDescription = @"If there is a 'True' response to 'Did the thin capitalisation rules apply to you?' on the IDS then a 'True' response is required at 'Did the thin capitalisation provisions apply as outlined in the instructions?' on the company return form.",
                    Location = "/xbrli:xbrl/tns:Liabilities.ThinCapitalisation.ProvisionsApplied.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428405" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR196", Value = ParentDocument.CTR196.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS220", Value = ChildDocument.IDS220.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428405

        #region VR.ATO.CTR.428417

        /*  VR.ATO.CTR.428417
                    
                    IF [CTR198] = FALSE AND [IDS9] = TRUE
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCTR428417(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = !ParentDocument.CTR198.GetValueOrDefault() && ChildDocument.IDS9.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428417",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Transactions with specified countries question incorrect",
                    LongDescription = @"If there is a 'True' response at 'Did you have dealings with international related parties located in specified countries?' on the International Dealings Schedule (IDS), then the response at 'Overseas transactions - Transactions with specified countries' on the company return must be 'True'.",
                    Location = "/xbrli:xbrl/tns:InternationalDealings.TransactionsWithTaxHavenCountries.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428417" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR198", Value = ParentDocument.CTR198.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS9", Value = ChildDocument.IDS9.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428417

        #region VR.ATO.CTR.428414

        /*  VR.ATO.CTR.428414
              
                    IF ([CTR156] > 0) AND ([IDS188] > [CTR156])
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR156] = CTR:RP.CFCLC:bafpr3.02.02:Income.InternationalDealings.Attributed.Amount
                    [IDS188] = IDS:RP.CFCLC:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
*/
        protected void VRATOCTR428414(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
           
            bool assertion = ParentDocument.CTR156.GetValueOrDefault() > 0 && 
                ChildDocument.IDS188.GetValueOrDefault()> ParentDocument.CTR156.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428414",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Attributed foreign income amount is incorrect",
                    LongDescription = @"CFCs attributable income - Listed countries amount on the International Dealings Schedule (IDS) must be equal to or less than Attributed foreign income - Listed country on the parent Company Tax Return (CTR)",
                    Location = "/xbrli:xbrl/tns:Income.InternationalDealings.Attributed.Amount[@contextRef='" + ParentDocument.RPCFCLCId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428414" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter{ Name = "CTR156", Value = ParentDocument.CTR156.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name ="IDS188", Value = ChildDocument.IDS188.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428414

        #region VR.ATO.CTR.428416

        /*  VR.ATO.CTR.428416
                   
                    IF ([CTR156] > 0 OR [CTR158] > 0 OR [CTR159] > 0) AND ([IDS185] = NULL AND [IDS186] = NULL AND [IDS187] = NULL)
                       RETURN VALIDATION MESSAGE
                    ENDIF
*/
        protected void VRATOCTR428416(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
            // = ((report.CTR156.GetValueOrDefault() > 0 || report.CTR158.GetValueOrDefault() > 0 || report.CTR159.GetValueOrDefault() > 0) && ( == null &&  == null &&  == null));

            bool assertion = (ParentDocument.CTR156.GetValueOrDefault() > 0 || ParentDocument.CTR158.GetValueOrDefault() > 0 || ParentDocument.CTR159.GetValueOrDefault() > 0) &&
                             (!ChildDocument.IDS185.HasValue && !ChildDocument.IDS186.HasValue && !ChildDocument.IDS187.HasValue);
          if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428416",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Number of controlled foreign companies or trusts on International Dealing Schedule is required",
                    LongDescription = @"Attributed foreign income has been completed on the company return form and the number of controlled foreign companies or trusts on the IDS has not been supplied.",
                    Location = "/xbrli:xbrl/tns:Income.InternationalDealings.Attributed.Amount[@contextRef='" + ParentDocument.RPCFCLCId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428416" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR156", Value = ParentDocument.CTR156.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR158", Value = ParentDocument.CTR158.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR159", Value = ParentDocument.CTR159.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428416

        #region VR.ATO.CTR.428409

        /*  VR.ATO.CTR.428409
                  
                    IF (([CTR78] = NULL OR [CTR78] = 0) AND ([CTR79] = NULL OR [CTR79] = 0)) AND ([IDS31] > 0) 
                       RETURN VALIDATION MESSAGE
                    ENDIF
                 */
        protected void VRATOCTR428409(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;          
            bool assertion = (!ParentDocument.CTR78.HasValue || ParentDocument.CTR78.Value == 0) &&
                             (!ParentDocument.CTR79.HasValue || ParentDocument.CTR79.Value == 0) &&
                             (ChildDocument.IDS31.HasValue && ChildDocument.IDS31 > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428409",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Lease expenses overseas or Rent expenses are required",
                    LongDescription = @"Where there is a Rent/leasing expenditure amount present on the IDS, there must also be an amount at either Lease expenses overseas or Rent expenses on the company return form",
                    Location = "/xbrli:xbrl/tns:Expense.Operating.Lease.Amount[@contextRef='" + ParentDocument.RPJFOREIGNId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428409" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR78", Value = ParentDocument.CTR78.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR79", Value = ParentDocument.CTR179.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS31", Value = ChildDocument.IDS31.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428409

        #region VR.ATO.CTR.428420

        /*  VR.ATO.CTR.428420
                 
                    IF ([CTR80] = NULL OR [CTR80] = 0 ) AND ([CTR81] = NULL OR [CTR81] = 0 ) AND (COUNT(SCHEDULE = "IDS") = 1) AND ([IDS207] > 0)
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    */
        protected void VRATOCTR428420(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = (!ParentDocument.CTR80.HasValue || ParentDocument.CTR80.Value == 0) &&
                           (!ParentDocument.CTR81.HasValue || ParentDocument.CTR81.Value == 0) &&
                           (ChildDocument.IDS207.HasValue && ChildDocument.IDS207 > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.430046",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Interest expenses required",
                    LongDescription = @"If Debt deductions in earning non-assessable non-exempt foreign income claimed under s25-90 or 230-15(3) has been completed on the International dealings schedule (IDS) then Interest expenses within Australia or Interest expenses overseas must be greater than zero on the company return",
                    Location = "/xbrli:xbrl/tns:Expense.Operating.Interest.Amount[@contextRef='" + ParentDocument.RPJFOREIGNId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428420" } },
                };

                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR80", Value = ParentDocument.CTR80.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR81", Value = ParentDocument.CTR81.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS207", Value = ChildDocument.IDS207.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428420

        #region VR.ATO.CTR.428408

          /*  VR.ATO.CTR.428408
                 
                    IF ([CTR366] >  0) AND ([CTR366] < [IDS22])
                       RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [CTR366] = CTR:RP.JFOREIGN:bafpr1.02.27:Expense.Royalties.Amount
                    [IDS22] = IDS:RP.Royalties:bafpr1.02.12:Expense.DeductionsTotal.Amount
                    */
        protected void VRATOCTR428408(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
       
            bool assertion = ParentDocument.CTR366.GetValueOrDefault() > 0 &&
                            ParentDocument.CTR366.GetValueOrDefault() < ChildDocument.IDS22.GetValueOrDefault();
                
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.428408",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Royalties deductions incorrect",
                    LongDescription = @"If Royalties deductions has been completed on the IDS then it must be less than or equal to Royalty expenses overseas on the Company return form",
                    Location = "/xbrli:xbrl/tns:Expense.Royalties.Amount[@contextRef='" + ParentDocument.RPJFOREIGNId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.428408" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR366", Value = ParentDocument.CTR81.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS22", Value = ChildDocument.IDS22.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.428408

        #region VR.ATO.CTR.438050

        /*  VR.ATO.CTR.438050
              
                    IF ([CTR310] > 0 OR [CTR311] > 0) 
                    AND (COUNT(SCHEDULE = "IDS") = 1 AND [IDS177] <> TRUE)
                      RETURN VALIDATION MESSAGE
                    ENDIF
              */
        protected void VRATOCTR438050(List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage;
          
            bool assertion = (ParentDocument.CTR310.GetValueOrDefault() > 0 || ParentDocument.CTR311.GetValueOrDefault() > 0) &&
                             !ChildDocument.IDS177.GetValueOrDefault();
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.438050",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Response to 'Are you subject to the TOFA rules contained in Division 230 of the ITAA 1997' is incorrect",
                    LongDescription = @"If there is an amount at either 'Total TOFA gains' or 'Total TOFA Losses' that indicates you made a gain or loss from a financial arrangement subject to the TOFA rules, then there must be a 'True' response to 'Are you subject to the Taxation of Financial Arrangements rules contained in Division 230 of the ITAA 1997?' on the IDS",
                    Location = "/xbrli:xbrl/tns:Income.GainsTotal.Amount",
                   
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.438050" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR310", Value = ParentDocument.CTR310.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "CTR311", Value = ParentDocument.CTR311.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter { Name = "IDS22", Value = ChildDocument.IDS22.GetValueOrDefault().ToString() });
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.438050

        //IDS_CTR
        #region VR.ATO.IDS.440670
        /*
         *            IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
            RETURN VALIDATION MESSAGE
            ENDIF
      */

        private void VRATOIDS440670(List<ProcessMessageDocument> response)
        {
            bool assertion = !ParentDocument.RPIdentifierTFN.Equals(ChildDocument.IDS500);

            if (assertion)
            {
                var processMessage = new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IDS.440670" } }
                };
               response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.IDS.440670
    }
}
