using System;
using System.Collections.Immutable;
using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationFITR;
using VaTS;

namespace Ato.CD.Inbound.FITR202402
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<FITR2024, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            ImmutableDictionary<string, Func<FITR2024, BusinessDocument, ICrossFormValidator>>.Builder builder = ImmutableDictionary.CreateBuilder<string, Func<FITR2024, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.CGTS.ToString(), (report, schedule) => new CrossFormValidatorCGTS(report, schedule));
            builder.Add(Schedule.LS.ToString(), (report, schedule) => new CrossFormValidatorLS(report, schedule));
            builder.Add(Schedule.PSS.ToString(), (report, schedule) => new CrossFormValidatorPSS(report, schedule));
            builder.Add(Schedule.DISTBENTRT.ToString(), (report, schedule) => new CrossFormValidatorDISTBENTRT(report, schedule));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(BusinessDocument schedule, FITR2024 report)
            => CrossFormValidators[schedule.DocumentName](report, schedule);
    }
}