using System;
using System.Runtime.Serialization;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationFTER2021
{
    /// <summary>
    /// FTER
    /// </summary>
    [DataContract(Name = "FTER", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class FTER
    {

        [DataMember(EmitDefaultValue = false, Order = 1)]
        public INT INT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public RP RP { get; set; }
    }

    /// <summary>
    /// TelephoneDetails
    /// </summary>
    [DataContract(Name = "TelephoneDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class TelephoneDetails
    {

        /// <summary>
        /// Tax Agent telephone area code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string ElectronicContactAreaC { get; set; }

        /// <summary>
        /// Tax Agent telephone number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string ElectronicContactMinimalN { get; set; }
    }

    /// <summary>
    /// Declaration
    /// </summary>
    [DataContract(Name = "Declaration", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class Declaration
    {

        /// <summary>
        /// Tax Agent declaration statement type code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string StatementTypeC { get; set; }

        /// <summary>
        /// Tax Agent declaration statement accepted indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool StatementAcceptedI { get; set; }

        /// <summary>
        /// Tax Agent declaration signature date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public DateTime SignatureD { get; set; }

        /// <summary>
        /// Tax Agent declaration signatory identifier
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string SignatoryIdentifierT { get; set; }

        /// <summary>
        /// Tax Agent declaration person name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PersonUnstructuredNameFullNameT { get; set; }
    }

    /// <summary>
    /// INT
    /// </summary>
    [DataContract(Name = "INT", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class INT
    {

        /// <summary>
        /// Tax Agent number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxAgentNumberId { get; set; }

        /// <summary>
        /// Tax Agent ABN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Tax Agent contact name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PersonUnstructuredNameFullNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 4)]
        public TelephoneDetails TelephoneDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 5)]
        public Declaration Declaration { get; set; }
    }

    /// <summary>
    /// PostalAddressDetails
    /// </summary>
    [DataContract(Name = "PostalAddressDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class PostalAddressDetails
    {

        /// <summary>
        /// Trust current postal address - Line 1
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string Line1T { get; set; }

        /// <summary>
        /// Trust current postal address - Line 2
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string Line2T { get; set; }

        /// <summary>
        /// Trust current postal address - Suburb/Town/City
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string LocalityNameT { get; set; }

        /// <summary>
        /// Trust current postal address - Postcode
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PostcodeT { get; set; }

        /// <summary>
        /// Trust current postal address - State/territory
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string StateOrTerritoryC { get; set; }

        /// <summary>
        /// Trust current postal address - Country code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string CountryC { get; set; }
    }

    /// <summary>
    /// CurrentTrustDetails
    /// </summary>
    [DataContract(Name = "CurrentTrustDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class CurrentTrustDetails
    {

        /// <summary>
        /// Trust current name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public PostalAddressDetails PostalAddressDetails { get; set; }
    }

    /// <summary>
    /// PreviousTrustDetails
    /// </summary>
    [DataContract(Name = "PreviousTrustDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class PreviousTrustDetails
    {

        /// <summary>
        /// Trust previous name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public PostalAddressDetails PostalAddressDetails { get; set; }
    }

    /// <summary>
    /// PeriodDetails
    /// </summary>
    [CollectionDataContract(Name = "PeriodDetailsCollection", Namespace = "http://www.sbr.gov.au/ato/fter", ItemName="PeriodDetails" )]
    public class PeriodDetailsCollection: List<PeriodDetails> {}

    /// <summary>
    /// PeriodDetails
    /// </summary>
    [DataContract(Name = "PeriodDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class PeriodDetails
    {

        /// <summary>
        /// Central management and control of trust was outside Australia during the relevant period - Date from
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public DateTime StartD { get; set; }

        /// <summary>
        /// Central management and control of the trust outside Australia during the relevant period - Date to
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public DateTime EndD { get; set; }
    }

    /// <summary>
    /// CentralManagementOutsideAustralia
    /// </summary>
    [DataContract(Name = "CentralManagementOutsideAustralia", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class CentralManagementOutsideAustralia
    {

        /// <summary>
        /// Was the central management and control of the trust outside Australia at any time during the period from the election commencement time until the election is made (relevant period)?
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public bool ResidencyCentralManagementAndControlOutsideAustraliaI { get; set; }

        /// <summary>
        /// Central management and control of trust outside Australia at all times during the relevant period - Full period indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool? ResidencyCentralManagementAndControlOutsideAustraliaFullPeriodI { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public PeriodDetailsCollection PeriodDetailsCollection { get; set; }
    }

    /// <summary>
    /// NonResidentPeriodDetails
    /// </summary>
    [CollectionDataContract(Name = "NonResidentPeriodDetailsCollection", Namespace = "http://www.sbr.gov.au/ato/fter", ItemName="NonResidentPeriodDetails" )]
    public class NonResidentPeriodDetailsCollection: List<NonResidentPeriodDetails> {}

    /// <summary>
    /// NonResidentPeriodDetails
    /// </summary>
    [DataContract(Name = "NonResidentPeriodDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class NonResidentPeriodDetails
    {

        /// <summary>
        /// Trustee was a non-resident for tax purposes during the relevant period - Date from
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public DateTime StartD { get; set; }

        /// <summary>
        /// Trustee was a non-resident for tax purposes during the relevant period - Date to
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public DateTime EndD { get; set; }
    }

    /// <summary>
    /// Trustee
    /// </summary>
    [CollectionDataContract(Name = "TrusteeCollection", Namespace = "http://www.sbr.gov.au/ato/fter", ItemName="Trustee" )]
    public class TrusteeCollection: List<Trustee> {}

    /// <summary>
    /// Trustee
    /// </summary>
    [DataContract(Name = "Trustee", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class Trustee
    {

        /// <summary>
        /// Trustee Tax file number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Trustee does not have a TFN indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool? TaxFileNumberInexistentI { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 3)]
        public IndividualNameDetails IndividualNameDetails { get; set; }

        /// <summary>
        /// Trustee non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        /// <summary>
        /// Trustee ACN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AustralianCompanyNumberId { get; set; }

        /// <summary>
        /// Trustee ARBN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string AustralianRegisteredBodyNumberId { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 7)]
        public PostalAddressDetails PostalAddressDetails { get; set; }

        /// <summary>
        /// At any time during the relevant period was the trustee a non-resident for tax purposes?
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 8)]
        public bool ResidencyTaxPurposesPersonStatusI { get; set; }

        /// <summary>
        /// Trustee was a non-resident for tax purposes at all times during the relevant period - Full period indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 9)]
        public bool? ResidencyNonResidentFullPeriodI { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 10)]
        public NonResidentPeriodDetailsCollection NonResidentPeriodDetailsCollection { get; set; }
    }

    /// <summary>
    /// SubstitutedAccountingPeriodDetails
    /// </summary>
    [DataContract(Name = "SubstitutedAccountingPeriodDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class SubstitutedAccountingPeriodDetails
    {

        /// <summary>
        /// Substituted accounting period - Date from
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public DateTime StartD { get; set; }

        /// <summary>
        /// Substituted accounting period - Date to
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public DateTime EndD { get; set; }
    }

    /// <summary>
    /// ElectionOrVariationIncomeYear
    /// </summary>
    [DataContract(Name = "ElectionOrVariationIncomeYear", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class ElectionOrVariationIncomeYear
    {

        /// <summary>
        /// Income year specified for the purposes of the family trust election or variation
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public int ElectionsFamilyTrustElectionStatusY { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 2)]
        public SubstitutedAccountingPeriodDetails SubstitutedAccountingPeriodDetails { get; set; }
    }

    /// <summary>
    /// ResidentialAddressDetails
    /// </summary>
    [DataContract(Name = "ResidentialAddressDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class ResidentialAddressDetails
    {

        /// <summary>
        /// Specified individual current address of principal place of residence - Line 1
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string Line1T { get; set; }

        /// <summary>
        /// Specified individual current address of principal place of residence - Line 2
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string Line2T { get; set; }

        /// <summary>
        /// Specified individual current address of principal place of residence - Suburb/Town/City
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string LocalityNameT { get; set; }

        /// <summary>
        /// Specified individual current address of principal place of residence - Postcode
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PostcodeT { get; set; }

        /// <summary>
        /// Specified individual current address of principal place of residence - State/territory
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string StateOrTerritoryC { get; set; }

        /// <summary>
        /// Specified individual current address of principal place of residence - Country code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string CountryC { get; set; }
    }

    /// <summary>
    /// SpecifiedIndividual
    /// </summary>
    [DataContract(Name = "SpecifiedIndividual", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class SpecifiedIndividual
    {

        /// <summary>
        /// Specified individual Tax file number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Specified individual does not have a TFN indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public bool? TaxFileNumberInexistentI { get; set; }

        /// <summary>
        /// Specified individual Date of birth
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public DateTime PersonDemographicDetailsBirthD { get; set; }

        /// <summary>
        /// Specified individual - Title
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PersonNameDetailsTitleT { get; set; }

        /// <summary>
        /// Specified individual - Suffix
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PersonNameDetailsNameSuffixT { get; set; }

        /// <summary>
        /// Specified individual - Family name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string PersonNameDetailsFamilyNameT { get; set; }

        /// <summary>
        /// Specified individual - First name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public string PersonNameDetailsGivenNameT { get; set; }

        /// <summary>
        /// Specified individual - Other given names
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 8)]
        public string PersonNameDetailsOtherGivenNameT { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 9)]
        public ResidentialAddressDetails ResidentialAddressDetails { get; set; }
    }

    /// <summary>
    /// InterposedEntity
    /// </summary>
    [CollectionDataContract(Name = "InterposedEntityCollection", Namespace = "http://www.sbr.gov.au/ato/fter", ItemName="InterposedEntity" )]
    public class InterposedEntityCollection: List<InterposedEntity> {}

    /// <summary>
    /// InterposedEntity
    /// </summary>
    [DataContract(Name = "InterposedEntity", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class InterposedEntity
    {

        /// <summary>
        /// Entity code of interposed entity - where election in respect of trust and specified individual is being revoked
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PartyTypeC { get; set; }

        /// <summary>
        /// Entity Tax file number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Company/fund/partnership/trust does not have a TFN indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public bool? TaxFileNumberInexistentI { get; set; }

        /// <summary>
        /// Entity non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        /// <summary>
        /// Company ACN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string AustralianCompanyNumberId { get; set; }

        /// <summary>
        /// Company ARBN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string AustralianRegisteredBodyNumberId { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 7)]
        public PostalAddressDetails PostalAddressDetails { get; set; }
    }

    /// <summary>
    /// FamilyTrustRevocation
    /// </summary>
    [DataContract(Name = "FamilyTrustRevocation", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class FamilyTrustRevocation
    {

        /// <summary>
        /// Income year that family trust election ceases to be in force - first date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public DateTime? ElectionsD { get; set; }

        /// <summary>
        /// Income year from which the revocation is to be effective under subsection 272-80(8)
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public int? ElectionsStatusEffectiveY { get; set; }

        /// <summary>
        /// Income year for which the details of the election being revoked were included in the tax return for the trust or given to the Commissioner as required under subsection 272‑80(2) of Schedule 2F to the ITAA 1936 or sub-items 22(4) or 22A(4) of Schedule 1 to the Taxation Laws Amendment (Trust Loss and Other Deductions) Act 1998
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public int ElectionsNotificationOfElectionBeingRevokedY { get; set; }

        /// <summary>
        /// Income year specified in the election being revoked
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public int ElectionsFamilyTrustElectionStatusY { get; set; }

        /// <summary>
        /// Tax file number of the specified individual for the trust election being revoked
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Specified individual for trust election being revoked does not have a TFN indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public bool? TaxFileNumberInexistentI { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 7)]
        public InterposedEntityCollection InterposedEntityCollection { get; set; }
    }

    /// <summary>
    /// IndividualNameDetails
    /// </summary>
    [DataContract(Name = "IndividualNameDetails", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class IndividualNameDetails
    {

        /// <summary>
        /// Trustee declaration name - Title
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string PersonNameDetailsTitleT { get; set; }

        /// <summary>
        /// Trustee declaration name - Suffix
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string PersonNameDetailsNameSuffixT { get; set; }

        /// <summary>
        /// Trustee declaration name - Family name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string PersonNameDetailsFamilyNameT { get; set; }

        /// <summary>
        /// Trustee declaration name - First name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public string PersonNameDetailsGivenNameT { get; set; }

        /// <summary>
        /// Trustee declaration name - Other given names
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public string PersonNameDetailsOtherGivenNameT { get; set; }
    }

    /// <summary>
    /// DeclarationOfTrustee
    /// </summary>
    [CollectionDataContract(Name = "DeclarationOfTrusteeCollection", Namespace = "http://www.sbr.gov.au/ato/fter", ItemName="DeclarationOfTrustee" )]
    public class DeclarationOfTrusteeCollection: List<DeclarationOfTrustee> {}

    /// <summary>
    /// DeclarationOfTrustee
    /// </summary>
    [DataContract(Name = "DeclarationOfTrustee", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class DeclarationOfTrustee
    {

        [DataMember(EmitDefaultValue = false, Order = 1)]
        public IndividualNameDetails IndividualNameDetails { get; set; }

        /// <summary>
        /// Trustee declaration name - Non-individual name
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string OrganisationNameDetailsOrganisationalNameT { get; set; }

        /// <summary>
        /// Trustee declaration statement type code
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public string StatementTypeC { get; set; }

        /// <summary>
        /// Trustee declaration accepted indicator
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public bool StatementAcceptedI { get; set; }

        /// <summary>
        /// Trustee declaration signature date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public DateTime SignatureD { get; set; }

        /// <summary>
        /// Trustee declaration signatory identifier
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string SignatoryIdentifierT { get; set; }
    }

    /// <summary>
    /// RP
    /// </summary>
    [DataContract(Name = "RP", Namespace = "http://www.sbr.gov.au/ato/fter")]
    public class RP
    {

        /// <summary>
        /// Trust Tax file number
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 1)]
        public string TaxFileNumberId { get; set; }

        /// <summary>
        /// Trust ABN
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 2)]
        public string AustralianBusinessNumberId { get; set; }

        /// <summary>
        /// Year of return
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 3)]
        public int LodgmentPeriodYearY { get; set; }

        /// <summary>
        /// Reporting period start date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 4)]
        public DateTime PeriodStartD { get; set; }

        /// <summary>
        /// Reporting period end date
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 5)]
        public DateTime PeriodEndD { get; set; }

        /// <summary>
        /// Are you using this form for an election, revocation or a variation?
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 6)]
        public string ElectionsFamilyTrustElectionRevocationC { get; set; }

        /// <summary>
        /// Hours taken to prepare and complete this form
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 7)]
        public decimal? CompletionHoursN { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 8)]
        public CurrentTrustDetails CurrentTrustDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 9)]
        public PreviousTrustDetails PreviousTrustDetails { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 10)]
        public CentralManagementOutsideAustralia CentralManagementOutsideAustralia { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 11)]
        public TrusteeCollection TrusteeCollection { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 12)]
        public ElectionOrVariationIncomeYear ElectionOrVariationIncomeYear { get; set; }

        /// <summary>
        /// The election commencement time for the family trust election or effective date of a variation
        /// </summary>
        [DataMember(EmitDefaultValue = false, Order = 13)]
        public DateTime? ElectionsCommencementD { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 14)]
        public SpecifiedIndividual SpecifiedIndividual { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 15)]
        public FamilyTrustRevocation FamilyTrustRevocation { get; set; }

        [DataMember(EmitDefaultValue = false, Order = 16)]
        public DeclarationOfTrusteeCollection DeclarationOfTrusteeCollection { get; set; }
    }
}
 
