using System.Linq;
using System.Collections.Generic;
using DataContracts;
namespace Ato.EN.IntegrationServices.CodeGenerationIDS
{
    public partial class IDS2024Validator
    {
        #region Manual Rules - Rules marked for manual coding

        #region VR.ATO.IDS.440005

        public void VRATOIDS440005(List<ProcessMessageDocument> response, IDS2024 report)
        {
            ProcessMessageDocument processMessage;
            bool assertion;

            /*  VR.ATO.IDS.440005
            If an expenditure or revenue amount is completed at 'Did you have dealings with international related parties, apart from the dealings with related parties located in specified countries?' or 'Did you have dealings with international related parties located in specified countries?', then there must be at least one expenditure or revenue amount greater than zero at one of Questions 5, 6, 7, 8, 9, 10, 11 or 12.

            Legacy Rule Format:
                (AnyOccurrence(^IDS5, ^IDS5 > 0) OR AnyOccurrence(^IDS6, ^IDS6 > 0) OR AnyOccurrence(^IDS12, ^IDS12 > 0) OR AnyOccurrence(^IDS13, ^IDS13 > 0)) AND ((^IDS17 = NULL OR ^IDS17 = 0) AND (^IDS18 = NULL OR ^IDS18 = 0) AND (^IDS22 = NULL OR ^IDS22 = 0) AND (^IDS23 = NULL OR ^IDS23 = 0) AND (^IDS26 = NULL OR ^IDS26 = 0) AND (^IDS27 = NULL OR ^IDS27 = 0) AND (^IDS31 = NULL OR ^IDS31 = 0) AND (^IDS32 = NULL OR ^IDS32 = 0) AND (^IDS36 = NULL OR ^IDS36 = 0) AND (^IDS37 = NULL OR ^IDS37 = 0) AND (^IDS40 = NULL OR ^IDS40 = 0) AND (^IDS41 = NULL OR ^IDS41 = 0) AND (^IDS44 = NULL OR ^IDS44 = 0) AND (^IDS45 = NULL OR ^IDS45 = 0) AND (^IDS48 = NULL OR ^IDS48 = 0) AND (^IDS49 = NULL OR ^IDS49 = 0) AND (^IDS52 = NULL OR ^IDS52 = 0) AND (^IDS53 = NULL OR ^IDS53 = 0) AND (^IDS56 = NULL OR ^IDS56 = 0) AND (^IDS57 = NULL OR ^IDS57 = 0) AND (^IDS60 = NULL OR ^IDS60 = 0) AND (^IDS61 = NULL OR ^IDS61 = 0) AND (^IDS64 = NULL OR ^IDS64 = 0) AND (^IDS65 = NULL OR ^IDS65 = 0) AND (^IDS68 = NULL OR ^IDS68 = 0) AND (^IDS69 = NULL OR ^IDS69 = 0) AND (^IDS72 = NULL OR ^IDS72 = 0) AND (^IDS73 = NULL OR ^IDS73 = 0) AND (^IDS76 = NULL OR ^IDS76 = 0) AND (^IDS77 = NULL OR ^IDS77 = 0) AND (^IDS82 = NULL OR ^IDS82 = 0) AND (^IDS83 = NULL OR ^IDS83 = 0) AND (^IDS89 = NULL OR ^IDS89 = 0) AND (^IDS90 = NULL OR ^IDS90 = 0) AND (^IDS93 = NULL OR ^IDS93 = 0) AND (^IDS94 = NULL OR ^IDS94 = 0) AND (^IDS102 = NULL OR ^IDS102 = 0) AND (^IDS103 = NULL OR ^IDS103 = 0) AND (^IDS106 = NULL OR ^IDS106 = 0) AND (^IDS107 = NULL OR ^IDS107 = 0) AND (^IDS110 = NULL OR ^IDS110 = 0) AND (^IDS111 = NULL OR ^IDS111 = 0) AND (^IDS114 = NULL OR ^IDS114 = 0) AND (^IDS115 = NULL OR ^IDS115 = 0) AND ALL OCCURRENCES OF(^IDS336) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS337) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS338) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS339) = SET(0, NULL) AND (^IDS118 = NULL OR ^IDS118 = 0) AND (^IDS119 = NULL OR ^IDS119 = 0) AND (^IDS124 = NULL OR ^IDS124 = 0) AND (^IDS125 = NULL OR ^IDS125 = 0))
    
            Technical Business Rule Format:
                (AnyOccurrence(^IDS5, ^IDS5 > 0) OR AnyOccurrence(^IDS6, ^IDS6 > 0) OR AnyOccurrence(^IDS12, ^IDS12 > 0) OR AnyOccurrence(^IDS13, ^IDS13 > 0)) AND ((^IDS17 = NULL OR ^IDS17 = 0) AND (^IDS18 = NULL OR ^IDS18 = 0) AND (^IDS22 = NULL OR ^IDS22 = 0) AND (^IDS23 = NULL OR ^IDS23 = 0) AND (^IDS26 = NULL OR ^IDS26 = 0) AND (^IDS27 = NULL OR ^IDS27 = 0) AND (^IDS31 = NULL OR ^IDS31 = 0) AND (^IDS32 = NULL OR ^IDS32 = 0) AND (^IDS36 = NULL OR ^IDS36 = 0) AND (^IDS37 = NULL OR ^IDS37 = 0) AND (^IDS40 = NULL OR ^IDS40 = 0) AND (^IDS41 = NULL OR ^IDS41 = 0) AND (^IDS44 = NULL OR ^IDS44 = 0) AND (^IDS45 = NULL OR ^IDS45 = 0) AND (^IDS48 = NULL OR ^IDS48 = 0) AND (^IDS49 = NULL OR ^IDS49 = 0) AND (^IDS52 = NULL OR ^IDS52 = 0) AND (^IDS53 = NULL OR ^IDS53 = 0) AND (^IDS56 = NULL OR ^IDS56 = 0) AND (^IDS57 = NULL OR ^IDS57 = 0) AND (^IDS60 = NULL OR ^IDS60 = 0) AND (^IDS61 = NULL OR ^IDS61 = 0) AND (^IDS64 = NULL OR ^IDS64 = 0) AND (^IDS65 = NULL OR ^IDS65 = 0) AND (^IDS68 = NULL OR ^IDS68 = 0) AND (^IDS69 = NULL OR ^IDS69 = 0) AND (^IDS72 = NULL OR ^IDS72 = 0) AND (^IDS73 = NULL OR ^IDS73 = 0) AND (^IDS76 = NULL OR ^IDS76 = 0) AND (^IDS77 = NULL OR ^IDS77 = 0) AND (^IDS82 = NULL OR ^IDS82 = 0) AND (^IDS83 = NULL OR ^IDS83 = 0) AND (^IDS89 = NULL OR ^IDS89 = 0) AND (^IDS90 = NULL OR ^IDS90 = 0) AND (^IDS93 = NULL OR ^IDS93 = 0) AND (^IDS94 = NULL OR ^IDS94 = 0) AND (^IDS102 = NULL OR ^IDS102 = 0) AND (^IDS103 = NULL OR ^IDS103 = 0) AND (^IDS106 = NULL OR ^IDS106 = 0) AND (^IDS107 = NULL OR ^IDS107 = 0) AND (^IDS110 = NULL OR ^IDS110 = 0) AND (^IDS111 = NULL OR ^IDS111 = 0) AND (^IDS114 = NULL OR ^IDS114 = 0) AND (^IDS115 = NULL OR ^IDS115 = 0) AND ALL OCCURRENCES OF(^IDS336) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS337) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS338) = SET(0, NULL) AND ALL OCCURRENCES OF(^IDS339) = SET(0, NULL) AND (^IDS118 = NULL OR ^IDS118 = 0) AND (^IDS119 = NULL OR ^IDS119 = 0) AND (^IDS124 = NULL OR ^IDS124 = 0) AND (^IDS125 = NULL OR ^IDS125 = 0))

            Data Elements:

            ^IDS5 = IDS:RP:ForeignCountry:ForeignDealings:Expense.Total.Amount

            ^IDS6 = IDS:RP:ForeignCountry:ForeignDealings:Revenue.Total.Amount

            ^IDS12 = IDS:RP:SpecifiedCountry:SpecifiedDealings:Expense.Total.Amount

            ^IDS13 = IDS:RP:SpecifiedCountry:SpecifiedDealings:Revenue.Total.Amount

            ^IDS17 = IDS:RP:TangiblePropertyRevenue:Expense.Total.Amount

            ^IDS18 = IDS:RP:TangiblePropertyRevenue:Revenue.Total.Amount

            ^IDS22 = IDS:RP:Royalties:Expense.DeductionsTotal.Amount

            ^IDS23 = IDS:RP:Royalties:Income.IncludedInAssessableTotal.Amount

            ^IDS26 = IDS:RP:LicenceFees:Expense.DeductionsTotal.Amount

            ^IDS27 = IDS:RP:LicenceFees:Income.IncludedInAssessableTotal.Amount

            ^IDS31 = IDS:RP:RentOrLeasing:Expense.Total.Amount

            ^IDS32 = IDS:RP:RentOrLeasing:Revenue.Total.Amount

            ^IDS36 = IDS:RP:ServiceArrangements:TreasuryServices:Expense.Total.Amount

            ^IDS37 = IDS:RP:ServiceArrangements:TreasuryServices:Revenue.Total.Amount

            ^IDS40 = IDS:RP:ServiceArrangements:ManagementAndAdministrationServices:Expense.Total.Amount

            ^IDS41 = IDS:RP:ServiceArrangements:ManagementAndAdministrationServices:Revenue.Total.Amount

            ^IDS44 = IDS:RP:ServiceArrangements:InsuranceServices:Expense.Total.Amount

            ^IDS45 = IDS:RP:ServiceArrangements:InsuranceServices:Revenue.Total.Amount

            ^IDS48 = IDS:RP:ServiceArrangements:ReinsuranceServices:Expense.Total.Amount

            ^IDS49 = IDS:RP:ServiceArrangements:ReinsuranceServices:Revenue.Total.Amount

            ^IDS52 = IDS:RP:ServiceArrangements:RAndDServices:Expense.Total.Amount

            ^IDS53 = IDS:RP:ServiceArrangements:RAndDServices:Revenue.Total.Amount

            ^IDS56 = IDS:RP:ServiceArrangements:SalesAndMarketingServices:Expense.Total.Amount

            ^IDS57 = IDS:RP:ServiceArrangements:SalesAndMarketingServices:Revenue.Total.Amount

            ^IDS60 = IDS:RP:ServiceArrangements:SoftwareAndITServices:Expense.Total.Amount

            ^IDS61 = IDS:RP:ServiceArrangements:SoftwareAndITServices:Revenue.Total.Amount

            ^IDS64 = IDS:RP:ServiceArrangements:TechnicalServices:Expense.Total.Amount

            ^IDS65 = IDS:RP:ServiceArrangements:TechnicalServices:Revenue.Total.Amount

            ^IDS68 = IDS:RP:ServiceArrangements:LogisticsServices:Expense.Total.Amount

            ^IDS69 = IDS:RP:ServiceArrangements:LogisticsServices:Revenue.Total.Amount

            ^IDS72 = IDS:RP:ServiceArrangements:AssetManagementServices:Expense.Total.Amount

            ^IDS73 = IDS:RP:ServiceArrangements:AssetManagementServices:Revenue.Total.Amount

            ^IDS76 = IDS:RP:ServiceArrangements:OtherServices:Expense.Total.Amount

            ^IDS77 = IDS:RP:ServiceArrangements:OtherServices:Revenue.Total.Amount

            ^IDS82 = IDS:RP:Derivatives:Expense.Total.Amount

            ^IDS83 = IDS:RP:Derivatives:Revenue.Total.Amount

            ^IDS89 = IDS:RP:DebtFactoring:Expense.BookValue.Amount

            ^IDS90 = IDS:RP:DebtFactoring:Expense.Consideration.Amount

            ^IDS93 = IDS:RP:Securitisation:Expense.BookValue.Amount

            ^IDS94 = IDS:RP:Securitisation:Expense.Consideration.Amount

            ^IDS102 = IDS:RP:FinancialDealings:Interest:Expense.Total.Amount

            ^IDS103 = IDS:RP:FinancialDealings:Interest:Revenue.Total.Amount

            ^IDS106 = IDS:RP:FinancialDealings:Guarantees:Expense.Total.Amount

            ^IDS107 = IDS:RP:FinancialDealings:Guarantees:Revenue.Total.Amount

            ^IDS110 = IDS:RP:FinancialDealings:Insurance:Expense.Total.Amount

            ^IDS111 = IDS:RP:FinancialDealings:Insurance:Revenue.Total.Amount

            ^IDS114 = IDS:RP:FinancialDealings:Reinsurance:Expense.Total.Amount

            ^IDS115 = IDS:RP:FinancialDealings:Reinsurance:Revenue.Total.Amount

            ^IDS118 = IDS:RP:FinancialDealings:OtherFinancial:Expense.Total.Amount

            ^IDS119 = IDS:RP:FinancialDealings:OtherFinancial:Revenue.Total.Amount

            ^IDS124 = IDS:RP:RevenueDealings:Expense.Total.Amount

            ^IDS125 = IDS:RP:RevenueDealings:Revenue.Total.Amount

            ^IDS336 = IDS:RP:ForeignExchange:GainOrLoss:InternationalDealings.ForeignExchangeLossesHighestNominal.Amount

            ^IDS337 = IDS:RP:ForeignExchange:GainOrLoss:InternationalDealings.ForeignExchangeGainsHighestNominal.Amount

            ^IDS338 = IDS:RP:ForeignExchange:InternationalDealings.ForeignExchangeLossesOther.Amount

            ^IDS339 = IDS:RP:ForeignExchange:InternationalDealings.ForeignExchangeGainsOther.Amount
            */

            bool ids336AllOccurancesAreZeroOrNull = true;
            bool ids337AllOccurancesAreZeroOrNull = true;
            bool ids338AllOccurancesAreZeroOrNull = true;
            bool ids339AllOccurancesAreZeroOrNull = true;

            //if we find a value of greater than zero for any occurance of ids336, ids337, ids338 or ids339 then
            //the rule will not fire as all occurances need to be zero or null
            if (report.RP_ForeignExchangeCollectionExists)
            {
                foreach (var foreignExchange in report.RP_ForeignExchangeCollection)
                {
                    if (foreignExchange.IDS338.GetValueOrDefault() > 0)
                    {
                        ids338AllOccurancesAreZeroOrNull = false;
                        break;
                    }

                    if (foreignExchange.IDS339.GetValueOrDefault() > 0)
                    {
                        ids339AllOccurancesAreZeroOrNull = false;
                        break;
                    }

                    if (foreignExchange.RP_ForeignExchange_GainOrLossCollectionExists)
                    {
                        foreach (var gainOrLoss in foreignExchange.RP_ForeignExchange_GainOrLossCollection)
                        {
                            if (gainOrLoss.IDS336.GetValueOrDefault() > 0)
                            {
                                ids336AllOccurancesAreZeroOrNull = false;
                                break;
                            }

                            if (gainOrLoss.IDS337.GetValueOrDefault() > 0)
                            {
                                ids337AllOccurancesAreZeroOrNull = false;
                                break;
                            }
                        }
                    }
                }
            }

            bool ids5AnyOccuranceGreaterThanZero = false;
            bool ids6AnyOccuranceGreaterThanZero = false;
            bool ids12AnyOccuranceGreaterThanZero = false;
            bool ids13AnyOccuranceGreaterThanZero = false;

            //any one of the fields ids5, ids6, ids12 or ids13 can be greater than zero to trigger the rule, 
            //set their default value to zero and then 
            //set there value if we find one with a value greater than zero
            //these variables are used to display the valu in the parameter list if the rule is triggered
            decimal ids5 = 0;
            decimal ids6 = 0;
            decimal ids12 = 0;
            decimal ids13 = 0;

            if (report.RP_ForeignCountryCollectionExists)
            {
                foreach (var foreignCountry in report.RP_ForeignCountryCollection)
                {
                    if (foreignCountry.RP_ForeignCountry_ForeignDealingsCollectionExists)
                    {
                        foreach (var foreignDealing in foreignCountry.RP_ForeignCountry_ForeignDealingsCollection)
                        {
                            if (foreignDealing.IDS5.GetValueOrDefault() > 0)
                            {
                                ids5AnyOccuranceGreaterThanZero = true;
                                //store the first instance of ids5 which is greater than zero to display in the parameter list
                                if (ids5 == 0)
                                    ids5 = foreignDealing.IDS5.GetValueOrDefault();
                            }

                            if (foreignDealing.IDS6.GetValueOrDefault() > 0)
                            {
                                ids6AnyOccuranceGreaterThanZero = true;
                                //store the first instance of ids6 which is greater than zero to display in the parameter list
                                if (ids6 == 0)
                                    ids6 = foreignDealing.IDS6.GetValueOrDefault();
                            }
                        }
                    }
                }
            }

            if (report.RP_SpecifiedCountryCollectionExists)
            {
                foreach (var specifiedCountry in report.RP_SpecifiedCountryCollection)
                {
                    if (specifiedCountry.RP_SpecifiedCountry_SpecifiedDealingsCollectionExists)
                    {
                        foreach (var specifiedDealings in specifiedCountry.RP_SpecifiedCountry_SpecifiedDealingsCollection)
                        {
                            if (specifiedDealings.IDS12.GetValueOrDefault() > 0)
                            {
                                ids12AnyOccuranceGreaterThanZero = true;
                                //store the first instance of ids12 which is greater than zero to display in the parameter list
                                if (ids12 == 0)
                                    ids12 = specifiedDealings.IDS12.GetValueOrDefault();
                            }
                            if (specifiedDealings.IDS13.GetValueOrDefault() > 0)
                            {
                                ids13AnyOccuranceGreaterThanZero = true;
                                //store the first instance of ids13 which is greater than zero to display in the parameter list
                                if (ids13 == 0)
                                    ids13 = specifiedDealings.IDS13.GetValueOrDefault();
                            }
                        }
                    }
                }
            }

            assertion = ((ids5AnyOccuranceGreaterThanZero || ids6AnyOccuranceGreaterThanZero || ids12AnyOccuranceGreaterThanZero || ids13AnyOccuranceGreaterThanZero) && ((report.IDS17 == null || report.IDS17 == 0) && (report.IDS18 == null || report.IDS18 == 0) && (report.IDS22 == null || report.IDS22 == 0) && (report.IDS23 == null || report.IDS23 == 0) && (report.IDS26 == null || report.IDS26 == 0) && (report.IDS27 == null || report.IDS27 == 0) && (report.IDS31 == null || report.IDS31 == 0) && (report.IDS32 == null || report.IDS32 == 0) && (report.IDS36 == null || report.IDS36 == 0) && (report.IDS37 == null || report.IDS37 == 0) && (report.IDS40 == null || report.IDS40 == 0) && (report.IDS41 == null || report.IDS41 == 0) && (report.IDS44 == null || report.IDS44 == 0) && (report.IDS45 == null || report.IDS45 == 0) && (report.IDS48 == null || report.IDS48 == 0) && (report.IDS49 == null || report.IDS49 == 0) && (report.IDS52 == null || report.IDS52 == 0) && (report.IDS53 == null || report.IDS53 == 0) && (report.IDS56 == null || report.IDS56 == 0) && (report.IDS57 == null || report.IDS57 == 0) && (report.IDS60 == null || report.IDS60 == 0) && (report.IDS61 == null || report.IDS61 == 0) && (report.IDS64 == null || report.IDS64 == 0) && (report.IDS65 == null || report.IDS65 == 0) && (report.IDS68 == null || report.IDS68 == 0) && (report.IDS69 == null || report.IDS69 == 0) && (report.IDS72 == null || report.IDS72 == 0) && (report.IDS73 == null || report.IDS73 == 0) && (report.IDS76 == null || report.IDS76 == 0) && (report.IDS77 == null || report.IDS77 == 0) && (report.IDS82 == null || report.IDS82 == 0) && (report.IDS83 == null || report.IDS83 == 0) && (report.IDS89 == null || report.IDS89 == 0) && (report.IDS90 == null || report.IDS90 == 0) && (report.IDS93 == null || report.IDS93 == 0) && (report.IDS94 == null || report.IDS94 == 0) && (report.IDS102 == null || report.IDS102 == 0) && (report.IDS103 == null || report.IDS103 == 0) && (report.IDS106 == null || report.IDS106 == 0) && (report.IDS107 == null || report.IDS107 == 0) && (report.IDS110 == null || report.IDS110 == 0) && (report.IDS111 == null || report.IDS111 == 0) && (report.IDS114 == null || report.IDS114 == 0) && (report.IDS115 == null || report.IDS115 == 0) && ids336AllOccurancesAreZeroOrNull && ids337AllOccurancesAreZeroOrNull && ids338AllOccurancesAreZeroOrNull && ids339AllOccurancesAreZeroOrNull && (report.IDS118 == null || report.IDS118 == 0) && (report.IDS119 == null || report.IDS119 == 0) && (report.IDS124 == null || report.IDS124 == 0) && (report.IDS125 == null || report.IDS125 == 0)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IDS.440702",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Expenditure and revenue information incomplete",
                    LongDescription = @"If an expenditure or revenue amount is completed at ""Did you have dealings with international related parties, apart from the dealings with related parties located in specified countries?"" or ""Did you have dealings with international related parties located in specified countries?"", then there must be at least one expenditure or revenue amount greater than zero at ""Did you have any international related party dealings involving tangible property of a revenue nature, including trading stock and raw materials?"" or ""Did you have any international related party dealings involving royalties or licence fees?"" or ""Did you have any international related party dealings involving rent or leasing?"" or ""Did you have any service arrangements with international related parties?"" or ""Did you have any derivative transactions with international related parties?"" or ""Did you enter into any debt factoring or securitisation arrangements with international related parties?"" or ""Did you have any dealings of a financial nature other than those listed under derivative transactions or debt factoring or securitisation arrangements with international related parties?"" or ""Have you returned a foreign exchange gain or deducted a foreign exchange loss in relation to dealings with international related parties?"" or ""Did you have any other international related party dealings of a revenue nature not reported elsewhere?""",
                    Location = "/tns:IDS/tns:RP/tns:ForeignCountryCollection/tns:ForeignCountry/tns:ForeignDealingsCollection/tns:ForeignDealings/tns:ExpenseTotalA",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IDS.440005" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS5", Value = ids5.ToString() });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS6", Value = ids6.ToString() });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS12", Value = ids12.ToString() });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS13", Value = ids13.ToString() });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS17", Value = GetValueOrEmpty(report.IDS17) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS18", Value = GetValueOrEmpty(report.IDS18) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS22", Value = GetValueOrEmpty(report.IDS22) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS23", Value = GetValueOrEmpty(report.IDS23) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS26", Value = GetValueOrEmpty(report.IDS26) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS27", Value = GetValueOrEmpty(report.IDS27) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS31", Value = GetValueOrEmpty(report.IDS31) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS32", Value = GetValueOrEmpty(report.IDS32) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS36", Value = GetValueOrEmpty(report.IDS36) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS37", Value = GetValueOrEmpty(report.IDS37) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS40", Value = GetValueOrEmpty(report.IDS40) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS41", Value = GetValueOrEmpty(report.IDS41) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS44", Value = GetValueOrEmpty(report.IDS44) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS45", Value = GetValueOrEmpty(report.IDS45) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS48", Value = GetValueOrEmpty(report.IDS48) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS49", Value = GetValueOrEmpty(report.IDS49) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS52", Value = GetValueOrEmpty(report.IDS52) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS53", Value = GetValueOrEmpty(report.IDS53) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS56", Value = GetValueOrEmpty(report.IDS56) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS57", Value = GetValueOrEmpty(report.IDS57) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS60", Value = GetValueOrEmpty(report.IDS60) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS61", Value = GetValueOrEmpty(report.IDS61) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS64", Value = GetValueOrEmpty(report.IDS64) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS65", Value = GetValueOrEmpty(report.IDS65) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS68", Value = GetValueOrEmpty(report.IDS68) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS69", Value = GetValueOrEmpty(report.IDS69) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS72", Value = GetValueOrEmpty(report.IDS72) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS73", Value = GetValueOrEmpty(report.IDS73) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS76", Value = GetValueOrEmpty(report.IDS76) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS77", Value = GetValueOrEmpty(report.IDS77) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS82", Value = GetValueOrEmpty(report.IDS82) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS83", Value = GetValueOrEmpty(report.IDS83) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS89", Value = GetValueOrEmpty(report.IDS89) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS90", Value = GetValueOrEmpty(report.IDS90) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS93", Value = GetValueOrEmpty(report.IDS93) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS94", Value = GetValueOrEmpty(report.IDS94) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS102", Value = GetValueOrEmpty(report.IDS102) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS103", Value = GetValueOrEmpty(report.IDS103) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS106", Value = GetValueOrEmpty(report.IDS106) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS107", Value = GetValueOrEmpty(report.IDS107) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS110", Value = GetValueOrEmpty(report.IDS110) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS111", Value = GetValueOrEmpty(report.IDS111) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS114", Value = GetValueOrEmpty(report.IDS114) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS115", Value = GetValueOrEmpty(report.IDS115) });

                //All values for IDS336, IDS337, IDS338 and IDS339 must be zero or null for the rule to fire
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS336", Value = "0" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS337", Value = "0" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS338", Value = "0" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS339", Value = "0" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS118", Value = GetValueOrEmpty(report.IDS118) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS119", Value = GetValueOrEmpty(report.IDS119) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS124", Value = GetValueOrEmpty(report.IDS124) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IDS125", Value = GetValueOrEmpty(report.IDS125) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.IDS.440005

        #endregion Manual Rules - Rules marked for manual coding
    }
}
