using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml;
using System.Text.RegularExpressions;
using Au.Gov.Sbr.Xbrl.Document;
using DataContracts;
using Au.Gov.Sbr.Xbrl.Metadata;
using System.Runtime.CompilerServices;
using System.IO;
using System.Text;
using System.Xml.Schema;
using System.Reflection;
using System.Runtime.Serialization; 

namespace Ato.EN.IntegrationServices.CodeGenerationLS {
    public partial class LS2017Validator {
    
    #region Cross Form Rules - not supported yet

        #region VR.ATO.GEN.402009

        /*  VR.ATO.GEN.402009
                    Your supplied TFN does not match the TFN supplied on the form it was submitted with

                Legacy Rule Format:
                    IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
                    RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^TFN <> ^ParentTFN

        Data Elements:
            
                    ^ParentTFN = ParentTFN
            
                    ^TFN = RP
                    */
        protected void VRATOGEN402009(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.402009
            
            assertion = false; // = ((report.RPExists == true) && (report.RPIdentifierTFN != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402009", Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.402009

        #region VR.ATO.GEN.402010

        /*  VR.ATO.GEN.402010
                    Your supplied ABN does not match the ABN supplied on the form it was submitted with

                Legacy Rule Format:
                    IF (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) AND (PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK) AND (RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier <> PARENT RETURN:RP:pyid.xx.xx:Identifiers.AustralianBusinessNumber.Identifier)
                    RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    (^LS3 <> BLANK) AND (^ParentABN <> BLANK) AND (^LS3 <> ^ParentABN)

        Data Elements:
            
                    RP:^LS3 = tns:Identifiers.AustralianBusinessNumber.Identifier
            
                    RP:^ParentABN = ParentABN
                    */
        protected void VRATOGEN402010(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.402010
            
            assertion = false; // = (string.IsNullOrWhiteSpace(report.LS3) != true &&  != null && report.LS3 != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402010", Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied ABN does not match the ABN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied ABN does not match the ABN supplied on the parent form it was submitted with",
                    //Location = "/xbrli:xbrl/tns:Identifiers.AustralianBusinessNumber.Identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.402010"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS3", Value = report.LS3 });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.402010

        #region VR.ATO.GEN.428045

        /*  VR.ATO.GEN.428045
                    Organisation Name in schedule should match Organisation Name in parent return

                Legacy Rule Format:
                    IF RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname1.xx.xx:OrganisationNameDetails) <> NULL
                    AND RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname1.xx.xx:OrganisationNameDetails) <> 
                    (PARENT RETURN:RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text
                    IN TUPLE (xbrli\organisationname2.xx.xx:OrganisationNameDetails)
                    WHERE (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.OrganisationalNameType.Code = "MN")
                    AND  (TUPLE EXPLICIT pyde.xx.xx:OrganisationNameDetails.Currency.Code = "C")) 
                             RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^LS2 <> NULL AND ^LS2 <> ^ParentORGN.T

        Data Elements:
            
                    RP:^LS2 = tns:OrganisationNameDetails.OrganisationalName.Text
            
                    RP:^ParentORGN.T = ParentORGN.T
                    */
        protected void VRATOGEN428045(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.428045
            
            assertion = false; // = (report.LS2 != null && report.LS2 != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.428045", Severity = ProcessMessageSeverity.Error,
                    Description = @"Organisation Name in schedule should match Organisation Name in parent return",
                    //Location = "/xbrli:xbrl/tns:OrganisationNameDetails/tns:OrganisationNameDetails.OrganisationalName.Text",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.428045"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS2", Value = report.LS2 });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.428045

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus1OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000__(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus2OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000___(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus3OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000____(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPALLOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_____(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus5POccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000______(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus4OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438000

        /*  VR.ATO.GEN.438000
                    Period start date within context on the schedule does not match period start date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^StartDate <> ^ParentStartDate

        Data Elements:
            
                    ^ParentStartDate = ParentStartDate
            
                    ^StartDate = StartDate
                    */
        protected void VRATOGEN438000_______(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438000
            
            assertion = false; // = ( != );
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438000

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-3
                    */
        protected void VRATOGEN438001(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus3Exists == true) && (report.RPY0Minus3EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus3OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0
                    */
        protected void VRATOGEN438001_(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Exists == true) && (report.RPY0EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP
                    */
        protected void VRATOGEN438001__(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPExists == true) && (report.RPEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-2
                    */
        protected void VRATOGEN438001___(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus2Exists == true) && (report.RPY0Minus2EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus2OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.ALL
                    */
        protected void VRATOGEN438001____(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPALLExists == true) && (report.RPALLEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPALLOccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-5P
                    */
        protected void VRATOGEN438001_____(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus5PExists == true) && (report.RPY0Minus5PEndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus5POccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-1
                    */
        protected void VRATOGEN438001______(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus1Exists == true) && (report.RPY0Minus1EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus1OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.GEN.438001

        /*  VR.ATO.GEN.438001
                    Period end date within context on the schedule does not match period end date within PARENT RETURN:reporting party context

                Legacy Rule Format:
                    IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
                       RETURN VALIDATION MESSAGE
                    ENDIF

            Technical Business Rule Format:
                    ^EndDate <> ^ParentEndDate

        Data Elements:
            
                    ^ParentEndDate = ParentEndDate
            
                    ^EndDate = RP:RP.Y0-4
                    */
        protected void VRATOGEN438001_______(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.GEN.438001
            
            assertion = false; // = ((report.RPY0Minus4Exists == true) && (report.RPY0Minus4EndDate != ));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001", Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    //Location = "/xbrli:xbrl/xbrli:context" + OccurrenceIndex(report.RPY0Minus4OccurrenceIndex) + "/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.GEN.438001

        #region VR.ATO.LS.414017

        /*  VR.ATO.LS.414017
                    Only companies and widely held trusts are required to indicate whether continuity of majority ownership test passed for each year of loss.

                Legacy Rule Format:
                    IF (PARENT RETURN <> SET("CTR", "TRT")) AND (([LS15] <>NULL) OR ([LS16] <> NULL) OR ([LS17] <> NULL) OR ([LS18] <> NULL) OR ([LS19] <> NULL) OR ([LS53] <> NULL))
                      RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [LS15] = LS:RP.Y0:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    [LS16] = LS:RP.Y0-1:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    [LS17] = LS:RP.Y0-2:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    [LS18] = LS:RP.Y0-3:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    [LS19] = LS:RP.Y0-4:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    [LS53] = LS:RP.Y0-5P:rvctc3.02.00:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator

            Technical Business Rule Format:
                    (Not(ParentDocument('CTR,TRT'))) AND ((^LS15 <> NULL) OR (^LS16 <> NULL) OR (^LS17 <> NULL) OR (^LS18 <> NULL) OR (^LS19 <> NULL) OR (^LS53 <> NULL))

        Data Elements:
            
                    RP.Y0:^LS15 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
            
                    RP.Y0-1:^LS16 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
            
                    RP.Y0-2:^LS17 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
            
                    RP.Y0-3:^LS18 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
            
                    RP.Y0-4:^LS19 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
            
                    RP.Y0-5P:^LS53 = tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator
                    */
        protected void VRATOLS414017(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.LS.414017
            
            assertion = false; // = ( !(@"CTR,TRT") ) && (report.LS15 != null || report.LS16 != null || report.LS17 != null || report.LS18 != null || report.LS19 != null || report.LS53 != null));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.LS.414017", Severity = ProcessMessageSeverity.Error,
                    Description = @"Continuity of majority ownership test only required for companies or widely held trusts",
                    //Location = "/xbrli:xbrl/tns:Tax.Losses.CarriedForward.ContinuityOfMajorityOwnershipTestPassed.Indicator[@contextRef='" + report.RPY0Id + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.LS.414017"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS15", Value = GetValueOrEmpty(report.LS15) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS16", Value = GetValueOrEmpty(report.LS16) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS17", Value = GetValueOrEmpty(report.LS17) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS18", Value = GetValueOrEmpty(report.LS18) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS19", Value = GetValueOrEmpty(report.LS19) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS53", Value = GetValueOrEmpty(report.LS53) });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.LS.414017

        #region VR.ATO.LS.414022

        /*  VR.ATO.LS.414022
                    Questions relating to unrealised losses are to be completed by companies only. Funds and trusts are not required to complete.

                Legacy Rule Format:
                    IF (PARENT RETURN<>"CTR") AND ([LS25] <> NULL OR [LS26] <> NULL OR [LS27] <> NULL OR [LS28] <> NULL)
                      RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [LS25] = LS:RP:rvctc3.02.00:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator
                    [LS26] = LS:RP:rvctc3.02.00:Tax.Losses.MaximumNetAssetValueTestPassedAtChangeoverTime.Indicator
                    [LS27] = LS:RP:rvctc3.02.00:Tax.Losses.UnrealisedNetLossAtChangeoverTime.Indicator
                    [LS28] = LS:RP:rvctc3.02.00:Tax.Losses.UnrealisedNetLossAtChangeoverTime.Amount

            Technical Business Rule Format:
                    (Not(ParentDocument('CTR'))) AND (^LS25 <> NULL OR ^LS26 <> NULL OR ^LS27 <> NULL OR ^LS28 <> NULL)

        Data Elements:
            
                    RP:^LS25 = tns:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator
            
                    RP:^LS26 = tns:Tax.Losses.MaximumNetAssetValueTestPassedAtChangeoverTime.Indicator
            
                    RP:^LS27 = tns:Tax.Losses.UnrealisedNetLossAtChangeoverTime.Indicator
            
                    RP:^LS28 = tns:Tax.Losses.UnrealisedNetLossAtChangeoverTime.Amount
                    */
        protected void VRATOLS414022(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.LS.414022
            
            assertion = false; // = ( !(@"CTR") ) && (report.LS25 != null || report.LS26 != null || report.LS27 != null || report.LS28 != null));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.LS.414022", Severity = ProcessMessageSeverity.Error,
                    Description = @"Unrealised losses are not required",
                    //Location = "/xbrli:xbrl/tns:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.LS.414022"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS25", Value = GetValueOrEmpty(report.LS25) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS26", Value = GetValueOrEmpty(report.LS26) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS27", Value = GetValueOrEmpty(report.LS27) });
    
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS28", Value = report.LS28.GetValueOrDefault().ToString() });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.LS.414022

        #region VR.ATO.LS.414023

        /*  VR.ATO.LS.414023
                    A company is required to indicate whether a changeover time occurred by selecting either "yes" or "no".

                Legacy Rule Format:
                    IF (PARENT RETURN = "CTR") AND [LS25] = NULL
                      RETURN VALIDATION MESSAGE
                    ENDIF
                    
                    [LS25] = LS:RP:rvctc3.02.00:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator

            Technical Business Rule Format:
                    (ParentDocument('CTR')) AND ^LS25 = NULL

        Data Elements:
            
                    RP:^LS25 = tns:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator
                    */
        protected void VRATOLS414023(List<ProcessMessageDocument> response, LS2017 report)
        {
            ProcessMessageDocument processMessage; 
            bool assertion;

            //TODO: Write manual rule for VR.ATO.LS.414023
            
            assertion = false; // = (@"CTR") && report.LS25 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.LS.414023", Severity = ProcessMessageSeverity.Error,
                    Description = @"Answer to changeover time question is required",
                    //Location = "/xbrli:xbrl/tns:Tax.Losses.ChangeOfOwnershipOrControlAfterReferenceTime.Indicator",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() {Name = "RuleIdentifier", Value = "VR.ATO.LS.414023"} },
                };
    
            /*  Parameters are commented out or non-existant for manual rules 
                processMessage.Parameters.Add(new ProcessMessageParameter
                    { Name = "LS25", Value = GetValueOrEmpty(report.LS25) });
    
    
            */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.LS.414023
    #endregion Cross Form Rules - not supported yet
        #region ValidateCrossFormRules

        public List<ProcessMessageDocument> ValidateCrossFormRules(LS2017 report)
        {
            List<ProcessMessageDocument> response = new List<ProcessMessageDocument>();
            #region Cross Form Rules
            VRATOGEN402009(response, report);
            VRATOGEN402010(response, report);
            VRATOGEN428045(response, report);
            VRATOGEN438000(response, report);
            VRATOGEN438000_(response, report);
            VRATOGEN438000__(response, report);
            VRATOGEN438000___(response, report);
            VRATOGEN438000____(response, report);
            VRATOGEN438000_____(response, report);
            VRATOGEN438000______(response, report);
            VRATOGEN438000_______(response, report);
            VRATOGEN438001(response, report);
            VRATOGEN438001_(response, report);
            VRATOGEN438001__(response, report);
            VRATOGEN438001___(response, report);
            VRATOGEN438001____(response, report);
            VRATOGEN438001_____(response, report);
            VRATOGEN438001______(response, report);
            VRATOGEN438001_______(response, report);
            VRATOLS414017(response, report);
            VRATOLS414022(response, report);
            VRATOLS414023(response, report);
            #endregion Cross Form Rules
            return response;
        }

        #endregion
    }
}
