using System;
using System.Collections.Generic;
using DataContracts;
using System.Linq;

namespace Ato.EN.IntegrationServices.CodeGenerationRPTTAXPOS {
    public partial class RPTTAXPOS2019Validator {

        #region Manual Rules - Rules marked for manual coding


        #region VR.ATO.RPTTAXPOS.000006

        /*  VR.ATO.RPTTAXPOS.000006
                RTP Category A & B Number must be unique and in incremental sequential order starting from '20xx-001' up to the supplied number of Category A & B reportable tax position.

                Legacy Rule Format:
                WHERE IN TUPLE(rpttaxpos.0001.lodge.req.xx.xx:ReportableTaxPositionCategoryAAndB)
                IF ANY OCCURRENCE OF [RPTTAXPOS4] <> INCREMENTAL SEQUENCE OF ANY OTHER OCCURRENCE OF [RPTTAXPOS4]
                  RETURN VALIDATION MESSAGE
                ENDIF
                
                [RPTTAXPOS4] = RPTTAXPOS:RP:bafot.02.36:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier IN TUPLE(rpttaxpos.0001.lodge.req.02.00:ReportableTaxPositionCategoryAAndB)
    
                Technical Business Rule Format:
                AnyOccurrence(^RPTTAXPOS4, ^RPTTAXPOS4 <> INCREMENTAL SEQUENCE OF ANY OTHER OCCURRENCE OF ^RPTTAXPOS4)
        
                Data Elements:
        
                ^RPTTAXPOS4 = RP:ReportableTaxPositionCategoryAAndB:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier
                */

        protected void VRATORPTTAXPOS000006(List<ProcessMessageDocument> response, RPTTAXPOS2019 report)
        {
            bool assertion = false;
            ProcessMessageDocument processMessage;

            if (report.ReportableTaxPositionCategoryAAndBCollection != null)
                for (int i = 1; i <= report.RPTTAXPOS3; i++)
                {
                    assertion = !report.ReportableTaxPositionCategoryAAndBCollection.Any(c => c.RPTTAXPOS4 != null
                    && c.RPTTAXPOS4.Substring(5, c.RPTTAXPOS4.Length - 5).All(char.IsDigit)
                    && Int32.Parse(c.RPTTAXPOS4.Substring(5, c.RPTTAXPOS4.Length - 5)) == i);
                    if (assertion)
                        break;
                }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.RPTTAXPOS.000006",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Last three digits of the RTP Category A & B Number is incorrect.",
                    LongDescription = @"RTP Category A & B Number must have the last three digits in sequential order with an increment of one and starting from '001' up to the supplied number in 'How many Category A or B Reportable tax positions are you reporting?'.",
                    Location = "/xbrli:xbrl/tns:ReportableTaxPositionCategoryAAndB/tns:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.RPTTAXPOS.000006" } },
                };

                /*  Parameters are commented out or non-existant for manual rules 

                */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.RPTTAXPOS.000006

        #region VR.ATO.RPTTAXPOS.000015

        /*  VR.ATO.RPTTAXPOS.000015
            RTP Category C Number must be unique and in incremental sequential order starting from '20xx-001' up to the supplied number of Category C reportable tax position.

        Legacy Rule Format:
            WHERE IN TUPLE(rpttaxpos.0001.lodge.req.xx.xx:ReportableTaxPositionCategoryC)
            IF ANY OCCURRENCE OF [RPTTAXPOS11] <> INCREMENTAL SEQUENCE OF ANY OTHER OCCURRENCE OF [RPTTAXPOS11]
              RETURN VALIDATION MESSAGE
            ENDIF
            
            [RPTTAXPOS11] = RPTTAXPOS:RP:bafot.02.36:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier IN TUPLE(rpttaxpos.0001.lodge.req.02.00:ReportableTaxPositionCategoryC)

    Technical Business Rule Format:
            AnyOccurrence(^RPTTAXPOS11, ^RPTTAXPOS11 <> INCREMENTAL SEQUENCE OF ANY OTHER OCCURRENCE OF ^RPTTAXPOS11)

Data Elements:
    
    ^RPTTAXPOS11 = RP:ReportableTaxPositionCategoryC:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier
    */
        protected void VRATORPTTAXPOS000015(List<ProcessMessageDocument> response, RPTTAXPOS2019 report)
        {
            ProcessMessageDocument processMessage;
            bool assertion = false;

            if (report.ReportableTaxPositionCategoryCCollection != null)
                for (int i = 1; i <= report.RPTTAXPOS10; i++)
                {
                    assertion = !report.ReportableTaxPositionCategoryCCollection.Any(c => c.RPTTAXPOS11 != null
                    && c.RPTTAXPOS11.Substring(5, c.RPTTAXPOS11.Length - 5).All(char.IsDigit)
                    && Int32.Parse(c.RPTTAXPOS11.Substring(5, c.RPTTAXPOS11.Length - 5)) == i);
                    if (assertion)
                        break;
                }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.RPTTAXPOS.000015",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Last three digits of the RTP Category C Number is incorrect.",
                    LongDescription = @"RTP Category C Number must have the last three digits in sequential order with an increment of one and starting from '001' up to the supplied number in 'How many Category C Reportable tax positions are you reporting?'.",
                    Location = "/xbrli:xbrl/tns:ReportableTaxPositionCategoryC/tns:RegulatoryDisclosures.ReportableTaxPositionCategoryReferenceNumber.Identifier",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.RPTTAXPOS.000015" } },
                };

                /*  Parameters are commented out or non-existant for manual rules 

                */
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.RPTTAXPOS.000015


        #endregion Manual Rules - Rules marked for manual coding
    }
}
