using Ato.EN.IntegrationServices.CodeGenerationCGTS;
using Ato.EN.IntegrationServices.CodeGenerationDISTBENTRT;
using Ato.EN.IntegrationServices.CodeGenerationFTER;
using Ato.EN.IntegrationServices.CodeGenerationIDS;
using Ato.EN.IntegrationServices.CodeGenerationIEE;
using Ato.EN.IntegrationServices.CodeGenerationLS;
using Ato.EN.IntegrationServices.CodeGenerationPSS;
using Ato.EN.IntegrationServices.CodeGenerationRS;
using Ato.EN.IntegrationServices.CodeGenerationTRT;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMIS;
using VaTS;
using DataContracts;
using System.Collections.Generic;
using System.Linq;

namespace Ato.CD.Inbound.TRT202402
{
    public class CrossFormValidator
    {
        private IEnumerable<CGTS2018> cgtsChildDocuments { get; set; }
        private IEnumerable<FTER2021> fterChildDocuments { get; set; }
        private IEnumerable<IDS2024> idsChildDocuments { get; set; }
        private IEnumerable<IEE2021> ieeChildDocuments { get; set; }
        private IEnumerable<LS2017> lsChildDocuments { get; set; }
        private IEnumerable<PSS2018> pssChildDocuments { get; set; }
        private IEnumerable<RS2018> rsChildDocuments { get; set; }
        private IEnumerable<TRTAMIS2022> trtamisChildDocuments { get; set; }
        private IEnumerable<DISTBENTRT2024> distbentrtChildDocuments { get; set; }

        public List<ProcessMessageDocument> response { get; private set; }

        private TRT2024 parentDocument { get; set; }

        public CrossFormValidator(TRT2024 parent, BusinessDocumentCollection childDocuments)
        {
            response = new List<ProcessMessageDocument>();

            parentDocument = parent;

            BusinessDocumentCollection ChildDocuments = childDocuments ?? new BusinessDocumentCollection();

            cgtsChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.CGTS.ToString()))
                .Select(p => (CGTS2018)p.ConsumedReport);

            distbentrtChildDocuments = ChildDocuments
                 .Where(s => s.DocumentName.Equals(Schedule.DISTBENTRT.ToString()))
                 .Select(p => (DISTBENTRT2024)p.ConsumedReport);

            fterChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.FTER.ToString()))
                .Select(p => (FTER2021)p.ConsumedReport);

            idsChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.IDS.ToString()))
                .Select(p => (IDS2024)p.ConsumedReport);

            ieeChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.IEE.ToString()))
                .Select(p => (IEE2021)p.ConsumedReport);

            lsChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.LS.ToString()))
                .Select(p => (LS2017)p.ConsumedReport);

            pssChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.PSS.ToString()))
                .Select(p => (PSS2018)p.ConsumedReport);

            rsChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.RS.ToString()))
                .Select(p => (RS2018)p.ConsumedReport);

            trtamisChildDocuments = ChildDocuments
                .Where(s => s.DocumentName.Equals(Schedule.TRTAMIS.ToString()))
                .Select(p => (TRTAMIS2022)p.ConsumedReport);
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOTRT432011();
            VRATOTRT432017();
            VRATOTRT432019();
            VRATOTRT432021();
            VRATOTRT432042();
            VRATOTRT432927();
            VRATOTRT432648();
            VRATOTRT433001();
            VRATOTRT432210();
            VRATOTRT432429();
            VRATOTRT432043();
            VRATOTRT432044();
            VRATOTRT432051();
            VRATOTRT432088();
            VRATOTRT432115();
            VRATOTRT432116();
            VRATOTRT432117();
            VRATOTRT432120();
            VRATOTRT432122();
            VRATOTRT432124();
            VRATOTRT432126();
            VRATOTRT432675();
            VRATOTRT432676();
            VRATOTRT433050();
            // CrossForm DISTBENTRT
            VRATOTRT442897();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.TRT.432011

        // CountDocument('IEE') > 0 AND AnyOccurrence(^IEE116, ^IEE116 = 'R' AND ^IEE82 <> ^TRT1)

        public virtual void VRATOTRT432011()
        {
            IEE2021 childDocument = null;

            if (ieeChildDocuments.Count() > 0)
                childDocument = ieeChildDocuments.Any(iee => iee.IEE116 == "R" && iee.IEE82 != parentDocument.TRT1) ? ieeChildDocuments.First(iee => iee.IEE116 == "R" && iee.IEE82 != parentDocument.TRT1) : null;

            bool assertion = childDocument != null;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430176",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Year of revocation must be the same as the year of the return",
                    LongDescription = @"The income year for which the details of the Interposed Entity Election are being revoked must equal the income year of the main return being lodged.",
                    Location = "/tns:TRT/tns:RP/tns:TargetFinancialY",
                    Parameters = new ProcessMessageParameters {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432011" },
                        new ProcessMessageParameter { Name = "TRT1", Value = parentDocument.TRT1.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter { Name = "IEE82", Value = childDocument.IEE82.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter { Name = "IEE116", Value = "R" }
                    }
                });
            }
        }

        #endregion // VR.ATO.TRT.432011

        #region VR.ATO.TRT.432017

        /*  VR.ATO.TRT.432017
                    Family Trust Election status code selected requires a Family trust election, revocation or variation schedule to be completed and attached to return and there is no schedule present.

                Legacy Rule Format:
                    ^TRT29 <> NULL AND CountDocument('FTER') = 0

            Technical Business Rule Format:
                    ^TRT29 <> NULL AND CountDocument('FTER') = 0

            Data Elements:
    
            ^TRT29 = TRT:RP:ElectionStatus:Elections.FamilyTrustElectionRevocation.Code
            */
        public virtual void VRATOTRT432017()
        {
            bool assertion = parentDocument.TRT29 != null && !fterChildDocuments.Any();
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.432017",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Family trust election or revocation schedule must be present",
                    Location = "/tns:TRT/tns:RP/tns:ElectionStatus/tns:ElectionsFamilyTrustElectionRevocationC",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432017" },
                        new ProcessMessageParameter() { Name = "TRT29", Value = parentDocument.TRT29 }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432017

        #region VR.ATO.TRT.432042

        /*  VR.ATO.TRT.432042
                    If Net capital gain is greater than $10,000, a Capital Gains Tax schedule must be present

                Legacy Rule Format:
                    ^TRT133 > 10000 AND CountDocument('CGTS') = 0

            Technical Business Rule Format:
                    ^TRT133 > 10000 AND CountDocument('CGTS') = 0

            Data Elements:
    
            ^TRT133 = TRT:RP:BusinessDetails:Income:CapitalGains:Income.CapitalGainsNet.Amount
            */
        public virtual void VRATOTRT432042()
        {
            bool assertion = parentDocument.TRT133.GetValueOrDefault() > 10000 && !cgtsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432042",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital Gains Tax schedule must be present",
                    LongDescription = @"If Net capital gain is greater than $10,000, a Capital Gains Tax schedule must be present",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:OrganisationDetailsTaxConsolidationStatusI",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432042" },
                        new ProcessMessageParameter() { Name = "TRT133", Value = parentDocument.TRT133.GetValueOrDefault().ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432042

        #region VR.ATO.TRT.432927

        // (CountDocument('IEE') > 0) AND AnyOccurrence(^IEE50, ^IEE50 = ^TRT5)

        public virtual void VRATOTRT432927()
        {
            IEE2021 childDocument = null;

            if (ieeChildDocuments.Count() > 0)
                childDocument = ieeChildDocuments.Any(iee => iee.IEE50 == parentDocument.TRT5) ? ieeChildDocuments.First(iee => iee.IEE50 == parentDocument.TRT5) : null;

            bool assertion = childDocument != null;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430008",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The Family Trust TFN on the IEE must not be the same as the main entity TFN",
                    LongDescription = @"An Entity cannot interpose itself; therefore the family trust tax file number quoted in Interposed Entity Election cannot be the same as the tax file number of the entity making the election",
                    Location = "/tns:TRT/tns:RP/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432927" },
                        new ProcessMessageParameter { Name = "TRT5", Value = parentDocument.TRT5 },
                        new ProcessMessageParameter { Name = "IEE50", Value = childDocument.IEE50 }
                    }
                });
            }
        }

        #endregion // VR.ATO.TRT.432927

        #region VR.ATO.TRT.432648

        /*  VR.ATO.TRT.432648
                    Where a positive amount is present at Attributed foreign income (Listed country or Unlisted country) on the Trust return, the Number of CFCs and CFTs in which you had an interest at the end of your income year (Listed countries, Specified countries or Other unlisted countries) must be provided on the International Dealings Schedule. If at the end of your income year you no longer held an interest in CFCs or CFTs, enter '0' (zero).

                Legacy Rule Format:
                    (^TRT134 > 0 OR ^TRT136 > 0) AND (CountDocument('IDS') = 0 OR (^IDS185 = NULL AND ^IDS186 = NULL AND ^IDS187 = NULL))

            Technical Business Rule Format:
                    (^TRT134 > 0 OR ^TRT136 > 0) AND (CountDocument('IDS') = 0 OR (^IDS185 = NULL AND ^IDS186 = NULL AND ^IDS187 = NULL))

            Data Elements:
    
            ^TRT134 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:ListedCountry:Income.InternationalDealings.Attributed.Amount
    
            ^IDS185 = IDS185
    
            ^IDS186 = IDS186
    
            ^IDS187 = IDS187
    
            ^TRT136 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:UnlistedCountry:Income.InternationalDealings.Attributed.Amount
            */
        public virtual void VRATOTRT432648()
        {
            bool assertion = (parentDocument.TRT134.GetValueOrDefault() > 0 || parentDocument.TRT136.GetValueOrDefault() > 0) && (!idsChildDocuments.Any() || idsChildDocuments.Any(ids => ids.IDS185 == null && ids.IDS186 == null && ids.IDS187 == null));

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.442648",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Number of controlled foreign companies or trusts required",
                    LongDescription = @"Where a positive amount is present at Attributed foreign income (Listed country or Unlisted country) on the Trust return, the Number of CFCs and CFTs in which you had an interest at the end of your income year (Listed countries, Specified countries or Other unlisted countries) must be provided on the International Dealings Schedule. If at the end of your income year you no longer held an interest in CFCs or CFTs, enter '0' (zero).",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:AttributedForeignIncome/tns:ListedCountryInternationalDealingsA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432648" },
                        new ProcessMessageParameter() { Name = "TRT134", Value = parentDocument.TRT134.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT136", Value = parentDocument.TRT136.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "IDS185", Value = "null" },
                        new ProcessMessageParameter() { Name = "IDS186", Value = "null" },
                        new ProcessMessageParameter() { Name = "IDS187", Value = "null" }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432648

        #region VR.ATO.TRT.433001

        /*  VR.ATO.TRT.433001
                    If the response to the question to whether the entity had either a direct or indirect interest in a foreign trust, controlled foreign company or transferor trust (Attributed foreign income) is 'Yes, an International Dealings Schedule must be attached

                Legacy Rule Format:
                    ^TRT138 = TRUE AND CountDocument('IDS') = 0

            Technical Business Rule Format:
                    ^TRT138 = TRUE AND CountDocument('IDS') = 0

            Data Elements:
    
            ^TRT138 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:Income.InternationalDealings.AttributedForeignIncomeForeignTrustorControlledForeignCompanyorTransferorTrust.Indicator
            */
        public virtual void VRATOTRT433001()
        {
            bool assertion = parentDocument.TRT138 == true && !idsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.438002",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"International Dealings Schedule is not attached",
                    LongDescription = @"The answer to the question 'Did the entity have either a direct or indirect interest in a foreign trust, controlled foreign company or transferor trust?' is 'Yes', and no International Dealings Schedule is attached.",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:AttributedForeignIncome/tns:InternationalDealingsTrustorControlledCompanyorTransferorTrustI",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.433001" },
                        new ProcessMessageParameter() { Name = "TRT138", Value = "true" }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.433001

        #region VR.ATO.TRT.432019

        /*  VR.ATO.TRT.432019
                    An IEE schedule is attached; however the IEE specified income year has not been completed on the main form.

                Legacy Rule Format:
                    ^TRT30 = NULL AND CountDocument('IEE') > 0

            Technical Business Rule Format:
                    ^TRT30 = NULL AND CountDocument('IEE') > 0

            Data Elements:
    
            ^TRT30 = TRT:RP:InterposedEntityElectionStatus:Elections.InterposedEntityElectionStatus.Year
            */
        public virtual void VRATOTRT432019()
        {
            bool assertion = parentDocument.TRT30 == null && ieeChildDocuments.Count() > 0;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430178",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"IEE specified income year must be present",
                    LongDescription = @"If an IEE schedule is present, the Interposed entity election status - Specified income year must be present",
                    Location = "/tns:TRT/tns:RP/tns:InterposedEntityElectionStatus/tns:ElectionsY",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432019" },
                        new ProcessMessageParameter() { Name = "TRT30", Value = "null" },
                        new ProcessMessageParameter() { Name = "Count of IEE", Value = ieeChildDocuments.Count().ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432019

        #region VR.ATO.TRT.432021

        /*  VR.ATO.TRT.432021
                    The Interposed Entity Election code indicates a revocation is being made, however no schedule is attached.

                Legacy Rule Format:
                    ^TRT31 = 'R' AND CountDocument('IEE') = 0

            Technical Business Rule Format:
                    ^TRT31 = 'R' AND CountDocument('IEE') = 0

            Data Elements:
    
            ^TRT31 = TRT:RP:InterposedEntityElectionStatus:Elections.InterposedEntityElectionRevocation.Code
            */
        public virtual void VRATOTRT432021()
        {
            bool assertion = parentDocument.TRT31 == @"R" && !ieeChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430180",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"If the Interposed Entity Election revocation code is present, an IEE schedule must be present",
                    Location = "/tns:TRT/tns:RP/tns:InterposedEntityElectionStatus/tns:ElectionsInterposedEntityElectionRevocationC",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432021" },
                        new ProcessMessageParameter() { Name = "TRT31", Value = "R" },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432021

        #region VR.ATO.TRT.432210

        /*  VR.ATO.TRT.432210
                    Where the total of tax losses AND net capital losses exceeds $100000, a Losses schedule must be attached.

                Legacy Rule Format:
                    (^TRT145 + ^TRT475) > 100000 AND ^TRT44 <> TRUE AND CountDocument('LS') = 0

            Technical Business Rule Format:
                    (^TRT145 + ^TRT475) > 100000 AND ^TRT44 <> TRUE AND CountDocument('LS') = 0

            Data Elements:
    
            ^TRT145 = TRT:RP:BusinessDetails:Income:Tax.Losses.CarriedForward.LaterIncomeYearsTotal.Amount
    
            ^TRT44 = TRT:RP:BusinessDetails:OrganisationDetails.TaxConsolidationStatus.Indicator
    
            ^TRT475 = TRT:RP:BusinessDetails:Income:Capital.Losses.CarriedForward.Net.Amount
            */
        public virtual void VRATOTRT432210()
        {
            bool assertion = parentDocument.TRT145.GetValueOrDefault() + parentDocument.TRT475.GetValueOrDefault() > 100000 && parentDocument.TRT44 != true && !lsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432210",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Losses schedule must be attached where total of tax losses and net capital losses exceeds $100000",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:TaxLossesCarriedForwardLaterIncomeYearsTotalA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432210" },
                        new ProcessMessageParameter() { Name = "TRT145", Value = parentDocument.TRT145.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT475", Value = parentDocument.TRT475.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT44", Value = parentDocument.TRT44.GetValueOrDefault().ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432210

        #region VR.ATO.TRT.432429

        /*  VR.ATO.TRT.432429
                    Losses schedule must be attached

                Legacy Rule Format:
                    ^TRT32 = '179' AND ^TRT144 > 100000 AND CountDocument('LS') = 0

            Technical Business Rule Format:
                    ^TRT32 = '179' AND ^TRT144 > 100000 AND CountDocument('LS') = 0

            Data Elements:
    
            ^TRT144 = TRT:RP:BusinessDetails:Income:TaxLossesDeducted:IncomeTax.Deduction.TaxLossesDeducted.Amount
    
            ^TRT32 = TRT:RP:TypeOfTrust:OrganisationDetails.OrganisationType.Code
            */
        public virtual void VRATOTRT432429()
        {
            bool assertion = parentDocument.TRT32 == @"179" && parentDocument.TRT144.GetValueOrDefault() > 100000 && !lsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432429",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Losses schedule must be attached",
                    LongDescription = @"Public unit trust (listed other than cash management unit trust) that have Tax losses deducted of greater than $100,000 must complete Part B1 of the Losses schedule for unconsolidated entities",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:TaxLossesDeductedTaxDeductionA",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432429" },
                        new ProcessMessageParameter() { Name = "TRT32", Value = "179" },
                        new ProcessMessageParameter() { Name = "TRT144", Value = parentDocument.TRT144.GetValueOrDefault().ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432429

        #region VR.ATO.TRT.432043

        /*  VR.ATO.TRT.432043
                    Payment Summary schedule must be present if Gross payments where ABN not quoted is present

                Legacy Rule Format:
                    (^TRT46 + ^TRT47) > 0 AND CountDocument('PSS') = 0

            Technical Business Rule Format:
                    (^TRT46 + ^TRT47) > 0 AND CountDocument('PSS') = 0

            Data Elements:
    
            ^TRT46 = TRT:RP:BusinessDetails:Income:BusinessIncomeAndExpenses:IncomePrimaryProduction:Remuneration.ABNNotQuotedPaymentGross.Amount
    
            ^TRT47 = TRT:RP:BusinessDetails:Income:BusinessIncomeAndExpenses:IncomeNonPrimaryProduction:Remuneration.ABNNotQuotedPaymentGross.Amount
            */
        public virtual void VRATOTRT432043()
        {
            bool assertion = parentDocument.TRT46.GetValueOrDefault() + parentDocument.TRT47.GetValueOrDefault() > 0 && !pssChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430019",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payment Summary schedule must be present if Gross payments where ABN not quoted is present",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:BusinessIncomeAndExpenses/tns:IncomePrimaryProduction/tns:RemunerationABNNotQuotedPaymentGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432043" },
                        new ProcessMessageParameter() { Name = "TRT46", Value = parentDocument.TRT46.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT47", Value = parentDocument.TRT47.GetValueOrDefault().ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432043

        #region VR.ATO.TRT.432044

        /*  VR.ATO.TRT.432044
                    The sum of gross payment with indicator 'N' in the payment summary schedule must equal the sum of total gross payment where ABN not quoted for primary production AND total gross payment where ABN not quoted for non-primary production on the main return form

                Legacy Rule Format:
                    CountDocument('PSS') > 0 AND Sum(^PSS19) <> (^TRT46 + ^TRT47)

            Technical Business Rule Format:
                    CountDocument('PSS') > 0 AND Sum(^PSS19) <> (^TRT46 + ^TRT47)

            Data Elements:
    
            ^TRT46 = TRT:RP:BusinessDetails:Income:BusinessIncomeAndExpenses:IncomePrimaryProduction:Remuneration.ABNNotQuotedPaymentGross.Amount
    
            ^PSS19 = PSS19
    
            ^TRT47 = TRT:RP:BusinessDetails:Income:BusinessIncomeAndExpenses:IncomeNonPrimaryProduction:Remuneration.ABNNotQuotedPaymentGross.Amount
            */
        public virtual void VRATOTRT432044()
        {
            bool assertion = pssChildDocuments.Any() && pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS19.GetValueOrDefault()) : 0) != (parentDocument.TRT46.GetValueOrDefault() + parentDocument.TRT47.GetValueOrDefault());
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430020",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross payment where ABN not quoted must equal sum of payments on schedule",
                    LongDescription = @"The sum of gross payment with indicator 'N' in the Payment Summary schedule must equal the sum of Primary production and Non-primary production Gross payments where ABN not quoted on main return form",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:BusinessIncomeAndExpenses/tns:IncomePrimaryProduction/tns:RemunerationABNNotQuotedPaymentGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432044" },
                        new ProcessMessageParameter() { Name = "TRT46", Value = parentDocument.TRT46.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT47", Value = parentDocument.TRT47.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(PSS19)", Value = pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS19.GetValueOrDefault()) : 0).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432044

        #region VR.ATO.TRT.432051

        /*  VR.ATO.TRT.432051
                    The sum of gross payment with indicator 'F' in the Payment Summary schedule must equal total gross payment subject to foreign resident withholding (excluding capital gains) non-primary production on the main return form.

                Legacy Rule Format:
                    CountDocument('PSS') > 0 AND ^TRT49 <> Sum(^PSS18)

            Technical Business Rule Format:
                    CountDocument('PSS') > 0 AND ^TRT49 <> Sum(^PSS18)

            Data Elements:
    
            ^TRT49 = TRT:RP:BusinessDetails:Income:BusinessIncomeAndExpenses:IncomeNonPrimaryProduction:Remuneration.PaymentToForeignResidentGross.Amount
    
            ^PSS18 = PSS18
            */
        public virtual void VRATOTRT432051()
        {
            bool assertion = pssChildDocuments.Any() && parentDocument.TRT49.GetValueOrDefault() != pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS18.GetValueOrDefault()) : 0);
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432749",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross payment - Foreign Resident Withholding (excluding capital gains) is incorrect",
                    LongDescription = @"The sum of gross payments with indicator 'F' in the Payment Summary schedule must be equal to total gross payment subject to foreign resident withholding (excluding capital gains) non-primary production on the main return form.",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:BusinessIncomeAndExpenses/tns:IncomeNonPrimaryProduction/tns:RemunerationPaymentToForeignResidentGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432051" },
                        new ProcessMessageParameter() { Name = "TRT49", Value = parentDocument.TRT49.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(PSS18)", Value = pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS18.GetValueOrDefault()) : 0).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432051

        #region VR.ATO.TRT.432088

        /*  VR.ATO.TRT.432088
                    If an amount greater than zero has been entered at Tax withheld from payments where ABN not quoted, then a Payment Summary schedule must be present AND it must include the same total amount of Tax withheld from payments where ABN not quoted

                Legacy Rule Format:
                    ^TRT73 > 0 AND (CountDocument('PSS') = 0 OR Sum(^PSS23) <> ^TRT73)

            Technical Business Rule Format:
                    ^TRT73 > 0 AND (CountDocument('PSS') = 0 OR Sum(^PSS23) <> ^TRT73)

            Data Elements:
    
            ^TRT73 = TRT:RP:BusinessDetails:Income:PayAsYouGoWithholding:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
    
            ^PSS23 = PSS23
            */
        public virtual void VRATOTRT432088()
        {
            bool assertion = parentDocument.TRT73.GetValueOrDefault() > 0 && (!pssChildDocuments.Any() || pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS23.GetValueOrDefault()) : 0) != parentDocument.TRT73.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430183",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payment Summary schedule must include Tax withheld where ABN not quoted amount",
                    LongDescription = @"If an amount greater than zero has been entered at Tax withheld from payments where ABN no quoted, then a Payment Summary schedule must be present and it must include the same total amount of Tax withheld from payments where ABN no quoted",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:PayAsYouGoWithholding/tns:TaxCreditForTaxWithheldWhereABNNotQuotedA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432088" },
                        new ProcessMessageParameter() { Name = "TRT73", Value = parentDocument.TRT73.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(PSS23)", Value = pssChildDocuments.Sum(f => f.RPPayerPSSeqNumContextCollection != null ? f.RPPayerPSSeqNumContextCollection.Sum(c => c.PSS23.GetValueOrDefault()) : 0).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432088

        #region VR.ATO.TRT.432115

        /*  VR.ATO.TRT.432115
                    A rental schedule is attached AND rental income AND deduction amounts are not present in the return form.

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND ^TRT89 = NULL AND (^TRT90 = 0 OR ^TRT90 = NULL) AND (^TRT91 = 0 OR ^TRT91 = NULL) AND (^TRT92 = 0 OR ^TRT92 = NULL)

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND ^TRT89 = NULL AND (^TRT90 = 0 OR ^TRT90 = NULL) AND (^TRT91 = 0 OR ^TRT91 = NULL) AND (^TRT92 = 0 OR ^TRT92 = NULL)

            Data Elements:
    
            ^TRT89 = TRT:RP:BusinessDetails:Income:Rent:Income.Operating.RentalIncomeGross.Amount
    
            ^TRT90 = TRT:RP:BusinessDetails:Income:Rent:Expense.Interest.Amount
    
            ^TRT91 = TRT:RP:BusinessDetails:Income:Rent:Expense.CapitalWorksDeduction.Amount
    
            ^TRT92 = TRT:RP:BusinessDetails:Income:Rent:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
            */
        public virtual void VRATOTRT432115()
        {
            bool assertion = rsChildDocuments.Any() && parentDocument.TRT89 == null && (parentDocument.TRT90 == 0 || parentDocument.TRT90 == null) && (parentDocument.TRT91 == 0 || parentDocument.TRT91 == null) && (parentDocument.TRT92 == 0 || parentDocument.TRT92 == null);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430082",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross rent and Rental deduction amounts must be present",
                    LongDescription = @"If a Rental property schedule is present, Gross rent or rental deductions must be present",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:OperatingIncomeGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432115" },
                        new ProcessMessageParameter() { Name = "TRT89", Value = "null" },
                        new ProcessMessageParameter() { Name = "TRT90", Value = "0" },
                        new ProcessMessageParameter() { Name = "TRT91", Value = "0" },
                        new ProcessMessageParameter() { Name = "TRT92", Value = "0" }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432115

        #region VR.ATO.TRT.432116

        /*  VR.ATO.TRT.432116
                    Total gross rent of schedules AND gross rent value in return must be equal

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS38 + ^RS39) <> ^TRT89

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS38 + ^RS39) <> ^TRT89

            Data Elements:
    
            ^TRT89 = TRT:RP:BusinessDetails:Income:Rent:Income.Operating.RentalIncomeGross.Amount
    
            ^RS38 = RS38
    
            ^RS39 = RS39
            */
        public virtual void VRATOTRT432116()
        {
            bool assertion = rsChildDocuments.Any() && rsChildDocuments.Sum(rs => rs.RS38.GetValueOrDefault() + rs.RS39.GetValueOrDefault()) != parentDocument.TRT89.GetValueOrDefault();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430083",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Gross rent must equal the total Gross rent in the Rental Schedules",
                    LongDescription = @"The Gross rent amount in the main form must equal the total Gross rent present in all Rental property schedules",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:OperatingIncomeGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432116" },
                        new ProcessMessageParameter() { Name = "TRT89", Value = parentDocument.TRT89.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(RS38 + RS39)", Value = rsChildDocuments.Sum(rs => rs.RS38.GetValueOrDefault() + rs.RS39.GetValueOrDefault()).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432116

        #region VR.ATO.TRT.432117

        /*  VR.ATO.TRT.432117
                    Total net rent of schedule AND net rent value in return must be equal

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS59) <> (^TRT89 - ^TRT90 - ^TRT91 - ^TRT92)

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS59) <> (^TRT89 - ^TRT90 - ^TRT91 - ^TRT92)

            Data Elements:
    
            ^TRT89 = TRT:RP:BusinessDetails:Income:Rent:Income.Operating.RentalIncomeGross.Amount
    
            ^RS59 = RS59
    
            ^TRT90 = TRT:RP:BusinessDetails:Income:Rent:Expense.Interest.Amount
    
            ^TRT91 = TRT:RP:BusinessDetails:Income:Rent:Expense.CapitalWorksDeduction.Amount
    
            ^TRT92 = TRT:RP:BusinessDetails:Income:Rent:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
            */
        public virtual void VRATOTRT432117()
        {
            bool assertion = rsChildDocuments.Any() && rsChildDocuments.Sum(rs => rs.RS59.GetValueOrDefault()) != (parentDocument.TRT89.GetValueOrDefault() - parentDocument.TRT90.GetValueOrDefault() - parentDocument.TRT91.GetValueOrDefault() - parentDocument.TRT92.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430084",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net rent must equal the total net rent in the Rental Schedules",
                    LongDescription = @"The net rent amount in the main form (Gross rent minus rental deduction amounts) must equal the total Net rent present in all Rental property schedules",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:OperatingIncomeGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432117" },
                        new ProcessMessageParameter() { Name = "TRT89", Value = parentDocument.TRT89.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT90", Value = parentDocument.TRT90.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT91", Value = parentDocument.TRT91.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT92", Value = parentDocument.TRT92.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(RS59)", Value = rsChildDocuments.Sum(rs => rs.RS59.GetValueOrDefault()).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432117

        #region VR.ATO.TRT.432120

        /*  VR.ATO.TRT.432120
                    If there is a positive amount at Gross rent or at any Rental deductions item, then a Rental property schedule must be submitted for each rental property

                Legacy Rule Format:
                    (^TRT89 <> NULL OR ^TRT90 > 0 OR ^TRT91 > 0 OR ^TRT92 > 0) AND CountDocument('RS') = 0

            Technical Business Rule Format:
                    (^TRT89 <> NULL OR ^TRT90 > 0 OR ^TRT91 > 0 OR ^TRT92 > 0) AND CountDocument('RS') = 0

            Data Elements:
    
            ^TRT89 = TRT:RP:BusinessDetails:Income:Rent:Income.Operating.RentalIncomeGross.Amount
    
            ^TRT90 = TRT:RP:BusinessDetails:Income:Rent:Expense.Interest.Amount
    
            ^TRT91 = TRT:RP:BusinessDetails:Income:Rent:Expense.CapitalWorksDeduction.Amount
    
            ^TRT92 = TRT:RP:BusinessDetails:Income:Rent:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
            */
        public virtual void VRATOTRT432120()
        {
            bool assertion = (parentDocument.TRT89 != null || parentDocument.TRT90.GetValueOrDefault() > 0 || parentDocument.TRT91.GetValueOrDefault() > 0 || parentDocument.TRT92.GetValueOrDefault() > 0) && !rsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430081",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Rental schedule must be present",
                    LongDescription = @"If there is a positive amount at Gross rent or at any Rental deductions item, then a Rental property schedule must be submitted for each rental property",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:OperatingIncomeGrossA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432120" },
                        new ProcessMessageParameter() { Name = "TRT89", Value = parentDocument.TRT89.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT90", Value = parentDocument.TRT90.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT91", Value = parentDocument.TRT91.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "TRT92", Value = parentDocument.TRT92.GetValueOrDefault().ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432120

        #region VR.ATO.TRT.432122

        /*  VR.ATO.TRT.432122
                    Total interest of schedules AND interest value in return must be equal

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS48) <> ^TRT90

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS48) <> ^TRT90

            Data Elements:
    
            ^TRT90 = TRT:RP:BusinessDetails:Income:Rent:Expense.Interest.Amount
    
            ^RS48 = RS48
            */
        public virtual void VRATOTRT432122()
        {
            bool assertion = rsChildDocuments.Any() && (rsChildDocuments.Sum(rs => rs.RS48.GetValueOrDefault()) != parentDocument.TRT90.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430086",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Rental Interest deductions must equal the total Interest deductions in the Rental Schedules",
                    LongDescription = @"The Interest deductions amount in the main form must equal the total of all Interest deductions in the Rental property schedules",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:ExpenseInterestA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432122" },
                        new ProcessMessageParameter() { Name = "TRT90", Value = parentDocument.TRT90.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(RS48)", Value = rsChildDocuments.Sum(rs => rs.RS48.GetValueOrDefault()).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432122

        #region VR.ATO.TRT.432124

        /*  VR.ATO.TRT.432124
                    Total of capital works deductions claimed in attached schedules are not equal to the total of capital works deductions claimed in the return.

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS54) <> ^TRT91

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS54) <> ^TRT91

            Data Elements:
    
            ^TRT91 = TRT:RP:BusinessDetails:Income:Rent:Expense.CapitalWorksDeduction.Amount
    
            ^RS54 = RS54
            */
        public virtual void VRATOTRT432124()
        {
            bool assertion = rsChildDocuments.Any() && (rsChildDocuments.Sum(rs => rs.RS54.GetValueOrDefault()) != parentDocument.TRT91.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430088",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital works deductions must equal the total Capital works deductions in the Rental Schedules",
                    LongDescription = @"The Capital works deductions amount in the main form must equal the total of all Capital works deductions in the Rental property schedules",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:ExpenseCapitalWorksDeductionA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432124" },
                        new ProcessMessageParameter() { Name = "TRT91", Value = parentDocument.TRT91.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(RS54)", Value = rsChildDocuments.Sum(rs => rs.RS54.GetValueOrDefault()).ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432124

        #region VR.ATO.TRT.432126

        /*  VR.ATO.TRT.432126
                    Total of rental expenses less Interest AND Capital works (Special building write-off) of schedules AND value of Other rental deductions in return must be equal

                Legacy Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS40 + ^RS41 + ^RS42 + ^RS43 + ^RS44 + ^RS45 + ^RS46 + ^RS47 + ^RS49 + ^RS50 + ^RS51 + ^RS52 + ^RS53 + ^RS55 + ^RS56 + ^RS57 + ^RS58) <> ^TRT92

            Technical Business Rule Format:
                    CountDocument('RS') > 0 AND Sum(^RS40 + ^RS41 + ^RS42 + ^RS43 + ^RS44 + ^RS45 + ^RS46 + ^RS47 + ^RS49 + ^RS50 + ^RS51 + ^RS52 + ^RS53 + ^RS55 + ^RS56 + ^RS57 + ^RS58) <> ^TRT92

            Data Elements:
    
            ^TRT92 = TRT:RP:BusinessDetails:Income:Rent:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
    
            ^RS40 = RS40
    
            ^RS41 = RS41
    
            ^RS42 = RS42
    
            ^RS43 = RS43
    
            ^RS44 = RS44
    
            ^RS45 = RS45
    
            ^RS46 = RS46
    
            ^RS47 = RS47
    
            ^RS49 = RS49
    
            ^RS50 = RS50
    
            ^RS51 = RS51
    
            ^RS52 = RS52
    
            ^RS53 = RS53
    
            ^RS55 = RS55
    
            ^RS56 = RS56
    
            ^RS57 = RS57
    
            ^RS58 = RS58
            */
        public virtual void VRATOTRT432126()
        {
            decimal rsTotal = rsChildDocuments.Sum(rs =>
            rs.RS40.GetValueOrDefault() +
            rs.RS41.GetValueOrDefault() +
            rs.RS42.GetValueOrDefault() +
            rs.RS43.GetValueOrDefault() +
            rs.RS44.GetValueOrDefault() +
            rs.RS45.GetValueOrDefault() +
            rs.RS46.GetValueOrDefault() +
            rs.RS47.GetValueOrDefault() +
            rs.RS49.GetValueOrDefault() +
            rs.RS50.GetValueOrDefault() +
            rs.RS51.GetValueOrDefault() +
            rs.RS52.GetValueOrDefault() +
            rs.RS53.GetValueOrDefault() +
            rs.RS55.GetValueOrDefault() +
            rs.RS56.GetValueOrDefault() +
            rs.RS57.GetValueOrDefault() +
            rs.RS58.GetValueOrDefault());

            bool assertion = rsChildDocuments.Any() && rsTotal != parentDocument.TRT92.GetValueOrDefault();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430090",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other rental deductions must equal the total other deductions in the Rental Schedules",
                    LongDescription = @"The Other rental deductions amount in the main form must equal the total of all rental expenses in the Rental property, excluding Interest deductions and Capital works deductions",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:Rent/tns:TaxDeductionIncomeDeductionsOtherThanInterestAndCapitalWorksA",
                    Parameters = new ProcessMessageParameters() {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432126" },
                        new ProcessMessageParameter() { Name = "TRT92", Value = parentDocument.TRT92.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter() { Name = "Sum(RS Amounts)", Value = rsTotal.ToString() }
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.432126

        #region VR.ATO.TRT.432675

        /*  VR.ATO.TRT.432675
            Ensure an International dealings schedule (IDS) is completed when a value greater than zero is present at label Interest expenses overseas       

            Legacy Rule Format:
            ^TRT182 > 0 AND CountDocument('IDS') = 0      

            Technical Business Rule Format:
            ^TRT182 > 0 AND CountDocument('IDS') = 0           

            Data Elements:
    
            ^TRT182 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:Income:ThinCapitalisation.ExpenseInterestA
            */
        public virtual void VRATOTRT432675()
        {
            bool assertion = parentDocument.TRT182 > 0 && !idsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432675",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "International Dealings Schedule not attached",
                    LongDescription = "An International dealings schedule (IDS) is not attached when a value greater than zero is present at label Interest expenses overseas",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:ThinCapitalisation/tns:ExpenseInterestA",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432675" },
                        new ProcessMessageParameter() { Name = "TRT182", Value = parentDocument.TRT182.ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432675

        #region VR.ATO.TRT.432676

        /*  VR.ATO.TRT.432676
            Ensure an International dealings schedule (IDS) is completed when a value greater than zero is present at label Royalty expenses overseas      

            Legacy Rule Format:
            ^TRT183 > 0 AND CountDocument('IDS') = 0      

            Technical Business Rule Format:
            ^TRT183 > 0 AND CountDocument('IDS') = 0           

            Data Elements:
    
            ^TRT183 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:Income:ThinCapitalisation.ExpenseRoyaltiesA
            */
        public virtual void VRATOTRT432676()
        {
            bool assertion = parentDocument.TRT183 > 0 && !idsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.432676",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "International Dealings Schedule not attached",
                    LongDescription = "An International dealings schedule (IDS) is not attached when a value greater than zero is present at label Royalty expenses overseas",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:ThinCapitalisation/tns:ExpenseRoyaltiesA",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.432676" },
                        new ProcessMessageParameter() { Name = "TRT183", Value = parentDocument.TRT183.ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.432676

        #region VR.ATO.TRT.433050

        /*  VR.ATO.TRT.433050
            When you were affected by the Thin capitalisation provisions, the International Dealings Schedule (IDS) must be attached        

            Legacy Rule Format:
            ^TRT449 = TRUE AND CountDocument('IDS') = 0       

            Technical Business Rule Format:
            ^TRT449 = TRUE AND CountDocument('IDS') = 0           

            Data Elements:
    
            ^TRT449 = TRT:RP:BusinessDetails:Income:AttributedForeignIncome:Income:ThinCapitalisation.LiabilitiesProvisionsAppliedI
            */
        public virtual void VRATOTRT433050()
        {
            bool assertion = parentDocument.TRT449 == true && !idsChildDocuments.Any();

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.438017",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "International Dealings Schedule not attached",
                    LongDescription = "If the thin capitalisation rules apply then International Dealings Schedule must be attached",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:ThinCapitalisation/tns:LiabilitiesProvisionsAppliedI",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.433050" },
                        new ProcessMessageParameter() { Name = "TRT449", Value = parentDocument.TRT449.ToString() },
                    },
                });
            }
        }
        #endregion // VR.ATO.TRT.433050

        #endregion // Validation Rules

        #region DISTBENTRT CrossForm Validation Rules

        #region VR.ATO.TRT.442897

        /*  VR.ATO.TRT.442897
                  Distributions to Beneficiaries of Trust schedule must be present when Trust distributions - Income amounts or credits are provided except where type of trust is CCIV Sub-Fund Trust or Is the trust a managed investment trust (MIT)? is yes (true)

              Legacy Rule Format:
                  CountDocument('DISTBENTRT') = 0 AND ^TRT32 <> '233' AND ^TRT520 <> TRUE AND (^TRT77> 0 OR ^TRT81> 0 OR ^TRT437 > 0)

          Technical Business Rule Format:
                  CountDocument('DISTBENTRT') = 0 AND ^TRT32 <> '233' AND ^TRT520 <> TRUE AND (^TRT77> 0 OR ^TRT81> 0 OR ^TRT437 > 0)

      Data Elements:

          ^TRT77 = TRT:RP:BusinessDetails:Income:PartnershipsTrustsPrimaryProduction:Income.TrustShareNet.Amount

          ^TRT32 = TRT:RP:TypeOfTrust:OrganisationDetails.OrganisationType.Code

          ^TRT81 = TRT:RP:BusinessDetails:Income:PartnershipTrustNonPrimaryProduction:Income.TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked.Amount

          ^TRT437 = TRT:RP:BusinessDetails:Income:PartnershipTrustNonPrimaryProduction:Income.TrustDistributionFranked.Amount

          ^TRT520 = TRT:RP:TypeOfTrust:OrganisationDetails.ManagedInvestmentTrust.Indicator
          */
        public void VRATOTRT442897()

        //  assertion = false; // = (@"DISTBENTRT") == 0 && report.TRT32 != @"233" && report.TRT520 != true && (report.TRT77.GetValueOrDefault() > 0 || report.TRT81.GetValueOrDefault() > 0 || report.TRT437.GetValueOrDefault() > 0));
        {
            bool assertion = ((parentDocument.TRT77.HasValue && parentDocument.TRT77.GetValueOrDefault() > 0) || (parentDocument.TRT81.HasValue && parentDocument.TRT81.GetValueOrDefault() > 0)
                    || (parentDocument.TRT437.HasValue && parentDocument.TRT437.GetValueOrDefault() > 0)) && (distbentrtChildDocuments.Count() == 0) && (!parentDocument.TRT520.HasValue || parentDocument.TRT520 != true) && (string.IsNullOrEmpty(parentDocument.TRT32)||!parentDocument.TRT32.Equals("233")); 

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.442897",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Distributions to Beneficiaries of Trust schedule must be present",
                    LongDescription = @"Distributions to Beneficiaries of Trust schedule must be present when Trust distributions - Income amounts or credits are provided except where type of trust is CCIV Sub-Fund Trust or Is the trust a managed investment trust (MIT)? is yes (true)",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:PartnershipsTrustsPrimaryProduction/tns:TrustShareNetA",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRT.442897" },
                        new ProcessMessageParameter { Name = "TRT77", Value = parentDocument.TRT77.HasValue ? parentDocument.TRT77.GetValueOrDefault().ToString(): "null" },
                        new ProcessMessageParameter { Name = "TRT81", Value = parentDocument.TRT81.HasValue ? parentDocument.TRT81.GetValueOrDefault().ToString(): "null" },
                        new ProcessMessageParameter { Name = "TRT437", Value = parentDocument.TRT437.HasValue ? parentDocument.TRT437.GetValueOrDefault().ToString(): "null"},
                        new ProcessMessageParameter { Name = "TRT520", Value = parentDocument.TRT520.HasValue ? parentDocument.TRT520.GetValueOrDefault().ToString().ToLower(): "null" },
                        new ProcessMessageParameter { Name = "TRT32", Value =  ! string.IsNullOrWhiteSpace(parentDocument.TRT32)? parentDocument.TRT32.ToString(): "null"}
                    }
                });
            }
        }
        #endregion // VR.ATO.TRT.442897


        #endregion // DISTBENTRT CrossForm Validation Rules
    }
}