using System;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationTRT
{
    public class TRT2024
    {

    public bool RpCollectionExists = false;
    public int RpCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:pyin.02.37:Report.TargetFinancial.Year
    /// </summary>
    public int? TRT1 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:pyin.02.00:Period.Start.Date
    /// </summary>
    public DateTime? TRT573 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:pyin.02.00:Period.End.Date
    /// </summary>
    public DateTime? TRT574 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:pyid.02.00:Identifiers.TaxFileNumber.Identifier
    /// </summary>
    public string TRT5 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
    /// </summary>
    public string TRT7 = null;

    public bool RP_ReportAmendmentCollectionExists = false;
    public int RP_ReportAmendmentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportAmendment
    /// TRT:pyin.02.28:Report.Amendment.Indicator
    /// </summary>
    public bool? TRT414 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportAmendment
    /// TRT:pyin.02.08:Report.AmendmentType.Code
    /// </summary>
    public string TRT415 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportAmendment
    /// TRT:pyin.02.08:Report.AmendmentReason.Text
    /// </summary>
    public string TRT416 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportAmendment
    /// TRT:pyin.02.08:Report.AmendmentSequence.Number
    /// </summary>
    public decimal? TRT417 = null;

    public bool RP_CurrentTrustCollectionExists = false;
    public int RP_CurrentTrustCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust
    /// TRT:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
    /// </summary>
    public string TRT6 = null;

    public bool RP_CurrentTrust_CurrentPostalAddressDetailsCollectionExists = false;
    public int RP_CurrentTrust_CurrentPostalAddressDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.OverseasAddress.Indicator
    /// </summary>
    public bool? TRT315 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line1.Text
    /// </summary>
    public string TRT9 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line2.Text
    /// </summary>
    public string TRT306 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.LocalityName.Text
    /// </summary>
    public string TRT10 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Postcode.Text
    /// </summary>
    public string TRT12 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.StateOrTerritory.Code
    /// </summary>
    public string TRT11 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CurrentTrust/:CurrentPostalAddressDetails
    /// TRT:pyde.02.08:AddressDetails.Country.Code
    /// </summary>
    public string TRT367 = null;

    public bool RP_PreviousTrustCollectionExists = false;
    public int RP_PreviousTrustCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust
    /// TRT:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
    /// </summary>
    public string TRT8 = null;

    public bool RP_PreviousTrust_PreviousPostalAddressDetailsCollectionExists = false;
    public int RP_PreviousTrust_PreviousPostalAddressDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.OverseasAddress.Indicator
    /// </summary>
    public bool? TRT317 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line1.Text
    /// </summary>
    public string TRT14 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line2.Text
    /// </summary>
    public string TRT312 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.LocalityName.Text
    /// </summary>
    public string TRT15 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Postcode.Text
    /// </summary>
    public string TRT17 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.00:AddressDetails.StateOrTerritory.Code
    /// </summary>
    public string TRT16 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:PreviousTrust/:PreviousPostalAddressDetails
    /// TRT:pyde.02.08:AddressDetails.Country.Code
    /// </summary>
    public string TRT368 = null;

    public bool RP_MailRecipientCollectionExists = false;
    public int RP_MailRecipientCollectionCount = 0;

    public bool RP_MailRecipient_PersonNameDetailsCollectionExists = false;
    public int RP_MailRecipient_PersonNameDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:PersonNameDetails
    /// TRT:pyde.02.00:PersonNameDetails.Title.Text
    /// </summary>
    public string TRT19 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:PersonNameDetails
    /// TRT:pyde.02.00:PersonNameDetails.NameSuffix.Text
    /// </summary>
    public string TRT21 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:PersonNameDetails
    /// TRT:pyde.02.00:PersonNameDetails.FamilyName.Text
    /// </summary>
    public string TRT20 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:PersonNameDetails
    /// TRT:pyde.02.00:PersonNameDetails.GivenName.Text
    /// </summary>
    public string TRT22 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:PersonNameDetails
    /// TRT:pyde.02.00:PersonNameDetails.OtherGivenName.Text
    /// </summary>
    public string TRT23 = null;

    public bool RP_MailRecipient_OrganisationNameDetailsCollectionExists = false;
    public int RP_MailRecipient_OrganisationNameDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:OrganisationNameDetails
    /// TRT:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
    /// </summary>
    public string TRT24 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:OrganisationNameDetails
    /// TRT:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
    /// </summary>
    public string TRT25 = null;

    public bool RP_MailRecipient_ElectronicContactTelephoneCollectionExists = false;
    public int RP_MailRecipient_ElectronicContactTelephoneCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:ElectronicContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code
    /// </summary>
    public string TRT371 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:ElectronicContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.Area.Code
    /// </summary>
    public string TRT26 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MailRecipient/:ElectronicContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.Minimal.Number
    /// </summary>
    public string TRT27 = null;

    public bool RP_ElectionStatusCollectionExists = false;
    public int RP_ElectionStatusCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ElectionStatus
    /// TRT:rvctc3.02.00:Elections.FamilyTrustElectionStatus.Year
    /// </summary>
    public int? TRT28 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ElectionStatus
    /// TRT:rvctc3.02.03:Elections.FamilyTrustElectionRevocation.Code
    /// </summary>
    public string TRT29 = null;

    public bool RP_InterposedEntityElectionStatusCollectionExists = false;
    public int RP_InterposedEntityElectionStatusCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:InterposedEntityElectionStatus
    /// TRT:rvctc3.02.00:Elections.InterposedEntityElectionStatus.Year
    /// </summary>
    public int? TRT30 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:InterposedEntityElectionStatus
    /// TRT:rvctc3.02.00:Elections.InterposedEntityElectionRevocation.Code
    /// </summary>
    public string TRT31 = null;

    public bool RP_TypeOfTrustCollectionExists = false;
    public int RP_TypeOfTrustCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyde.02.52:OrganisationDetails.OrganisationType.Code
    /// </summary>
    public string TRT32 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyde.02.05:OrganisationDetails.CharitableOrganisation.Indicator
    /// </summary>
    public bool? TRT33 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyde.02.00:PersonDemographicDetails.Death.Date
    /// </summary>
    public DateTime? TRT34 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:bafpo7.02.33:Assets.Investment.CrossOtherCCIVSubfund.Indicator
    /// </summary>
    public bool? TRT566 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyde.02.45:OrganisationDetails.ManagedInvestmentTrust.Indicator
    /// </summary>
    public bool? TRT520 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyde.02.45:OrganisationDetails.ManagedInvestmentTrustType.Code
    /// </summary>
    public string TRT521 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:rvctc3.02.24:Elections.ManagedInvestmentTrusts.Indicator
    /// </summary>
    public bool? TRT352 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyin.02.00:Report.Statement.Summary.PaymentRefundOrNil.Code
    /// </summary>
    public string TRT35 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TypeOfTrust
    /// TRT:pyin.02.28:Lodgment.FinalReturn.Indicator
    /// </summary>
    public bool? TRT36 = null;

    public bool RP_FinancialInstitutionAccountCollectionExists = false;
    public int RP_FinancialInstitutionAccountCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialInstitutionAccount
    /// TRT:pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number
    /// </summary>
    public string TRT38 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialInstitutionAccount
    /// TRT:pyid.02.20:FinancialInstitutionAccount.FinancialInstitutionAccount.Number
    /// </summary>
    public string TRT39 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialInstitutionAccount
    /// TRT:pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text
    /// </summary>
    public string TRT40 = null;

    public bool RP_BusinessDetailsCollectionExists = false;
    public int RP_BusinessDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:pyde.02.05:OrganisationDetails.MainIncomeActivity.Description
    /// </summary>
    public string TRT41 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:pyde.02.48:OrganisationDetails.OrganisationIndustry2006Extended.Code
    /// </summary>
    public string TRT42 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:pyde.02.42:OrganisationDetails.ActivityEvent.Code
    /// </summary>
    public string TRT43 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:pyde.02.00:OrganisationDetails.TaxConsolidationStatus.Indicator
    /// </summary>
    public bool? TRT44 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:pyde.02.43:OrganisationDetails.SignificantGlobalEntityStatus.Indicator
    /// </summary>
    public bool? TRT487 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails
    /// TRT:rvctc4.02.17:InternationalDealings.CountryByCountryReportingEntityStatus.Indicator
    /// </summary>
    public bool? TRT550 = null;

    public bool RP_BusinessDetails_IncomeCollectionExists = false;
    public int RP_BusinessDetails_IncomeCollectionCount = 0;

    public bool RP_BusinessDetails_Income_BusinessIncomeAndExpensesCollectionExists = false;
    public int RP_BusinessDetails_Income_BusinessIncomeAndExpensesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses
    /// TRT:bafpr1.02.04:Income.SmallBusinessEntityNet.Amount
    /// </summary>
    public decimal? TRT478 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses
    /// TRT:bafpr1.02.04:Income.ReconciliationAdjustmentTotal.Amount
    /// </summary>
    public decimal? TRT69 = null;

    public bool RP_BusinessDetails_Income_BusinessIncomeAndExpenses_IncomePrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_BusinessIncomeAndExpenses_IncomePrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomePrimaryProduction
    /// TRT:lrla.02.00:Remuneration.ABNNotQuotedPaymentGross.Amount
    /// </summary>
    public decimal? TRT46 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomePrimaryProduction
    /// TRT:gfagg.02.00:GovernmentFunding.GovernmentIndustryPaymentsAssessable.Amount
    /// </summary>
    public decimal? TRT50 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomePrimaryProduction
    /// TRT:gfagg.02.02:GovernmentFunding.GovernmentIndustryPaymentsAssessable.Indicator
    /// </summary>
    public bool? TRT361 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomePrimaryProduction
    /// TRT:bafpr1.02.04:Income.Other.Amount
    /// </summary>
    public decimal? TRT54 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomePrimaryProduction
    /// TRT:bafpr1.02.23:Income.Net.Amount
    /// </summary>
    public decimal? TRT71 = null;

    public bool RP_BusinessDetails_Income_BusinessIncomeAndExpenses_IncomeNonPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_BusinessIncomeAndExpenses_IncomeNonPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:lrla.02.00:Remuneration.ABNNotQuotedPaymentGross.Amount
    /// </summary>
    public decimal? TRT47 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:lrla.02.21:Remuneration.PaymentToForeignResidentGross.Amount
    /// </summary>
    public decimal? TRT49 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:gfagg.02.00:GovernmentFunding.GovernmentIndustryPaymentsAssessable.Amount
    /// </summary>
    public decimal? TRT52 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:gfagg.02.02:GovernmentFunding.GovernmentIndustryPaymentsAssessable.Indicator
    /// </summary>
    public bool? TRT362 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:bafpr1.02.04:Income.Other.Amount
    /// </summary>
    public decimal? TRT55 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:IncomeNonPrimaryProduction
    /// TRT:bafpr1.02.23:Income.Net.Amount
    /// </summary>
    public decimal? TRT72 = null;

    public bool RP_BusinessDetails_Income_BusinessIncomeAndExpenses_BusinessExpensesCollectionExists = false;
    public int RP_BusinessDetails_Income_BusinessIncomeAndExpenses_BusinessExpensesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr1.02.02:Expense.ForeignResidentWithholding.Amount
    /// </summary>
    public decimal? TRT56 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:lrla.02.16:Remuneration.WagesAndSalaries.PaymentsContractorAndConsultant.Amount
    /// </summary>
    public decimal? TRT57 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:emsup.02.02:SuperannuationContribution.EmployerContributions.Amount
    /// </summary>
    public decimal? TRT58 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.16:Expense.Operating.CostOfSales.Amount
    /// </summary>
    public decimal? TRT467 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.16:Expense.Operating.BadDebts.Amount
    /// </summary>
    public decimal? TRT468 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.04:Expense.Operating.LeaseTotal.Amount
    /// </summary>
    public decimal? TRT61 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.16:Expense.Operating.Rent.Amount
    /// </summary>
    public decimal? TRT469 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.17:Expense.Operating.Interest.Amount
    /// </summary>
    public decimal? TRT470 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr1.02.27:Expense.Royalties.Amount
    /// </summary>
    public decimal? TRT471 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr1.02.37:Expense.DepreciationAndAmortisation.Amount
    /// </summary>
    public decimal? TRT65 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.16:Expense.Operating.MotorVehicle.Amount
    /// </summary>
    public decimal? TRT472 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr2.02.16:Expense.Operating.RepairsAndMaintenance.Amount
    /// </summary>
    public decimal? TRT473 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr1.02.04:Expense.DeductibleOtherTotal.Amount
    /// </summary>
    public decimal? TRT68 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:BusinessIncomeAndExpenses/:BusinessExpenses
    /// TRT:bafpr1.02.10:Expense.ReconciliationAdjustmentTotal.Amount
    /// </summary>
    public decimal? TRT447 = null;

    public bool RP_BusinessDetails_Income_PayAsYouGoWithholdingCollectionExists = false;
    public int RP_BusinessDetails_Income_PayAsYouGoWithholdingCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PayAsYouGoWithholding
    /// TRT:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
    /// </summary>
    public decimal? TRT73 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PayAsYouGoWithholding
    /// TRT:rvctc2.02.13:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldFromForeignResidents.Amount
    /// </summary>
    public decimal? TRT474 = null;

    public bool RP_BusinessDetails_Income_PartnershipsTrustsPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_PartnershipsTrustsPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipsTrustsPrimaryProduction
    /// TRT:bafpr1.02.02:Income.PartnershipDistributionGross.Amount
    /// </summary>
    public decimal? TRT76 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipsTrustsPrimaryProduction
    /// TRT:bafpr1.02.14:Income.TrustShareNet.Amount
    /// </summary>
    public decimal? TRT77 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipsTrustsPrimaryProduction
    /// TRT:pyde.02.49:Party.TrustType.Code
    /// </summary>
    public string TRT353 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipsTrustsPrimaryProduction
    /// TRT:bafpr1.02.04:Expense.DistributionDeductionsOther.Amount
    /// </summary>
    public decimal? TRT79 = null;

    public bool RP_BusinessDetails_Income_PartnershipTrustNonPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_PartnershipTrustNonPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:bafpr1.02.04:Income.PartnershipDistributionLessForeignIncome.Amount
    /// </summary>
    public decimal? TRT80 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:bafpr1.02.13:Income.TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked.Amount
    /// </summary>
    public decimal? TRT81 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:pyde.02.49:Party.TrustType.Code
    /// </summary>
    public string TRT436 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:bafpr1.02.04:Expense.DistributionDeductionsOther.Amount
    /// </summary>
    public decimal? TRT83 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:bafpr1.02.04:Income.TrustDistributionFranked.Amount
    /// </summary>
    public decimal? TRT437 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PartnershipTrustNonPrimaryProduction
    /// TRT:rvctc2.02.05:IncomeTax.Deduction.TrustDistributionFranked.Amount
    /// </summary>
    public decimal? TRT438 = null;

    public bool RP_BusinessDetails_Income_ShareOfCreditsCollectionExists = false;
    public int RP_BusinessDetails_Income_ShareOfCreditsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ShareOfCredits
    /// TRT:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuotedShareReceivedIndirectly.Amount
    /// </summary>
    public decimal? TRT84 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ShareOfCredits
    /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.FrankingCreditShareReceivedIndirectly.Amount
    /// </summary>
    public decimal? TRT85 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ShareOfCredits
    /// TRT:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldFromInterestAndDividendsWhereTFNNotQuotedShareReceivedIndirectly.Amount
    /// </summary>
    public decimal? TRT86 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ShareOfCredits
    /// TRT:rvctc2.02.03:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldFromCloselyHeldTrustShareReceivedIndirectly.Amount
    /// </summary>
    public decimal? TRT418 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ShareOfCredits
    /// TRT:rvctc4.02.00:InternationalDealings.CreditForTaxWithheldFromForeignResidentWithholdingShareReceivedIndirectly.Amount
    /// </summary>
    public decimal? TRT87 = null;

    public bool RP_BusinessDetails_Income_RentCollectionExists = false;
    public int RP_BusinessDetails_Income_RentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Rent
    /// TRT:bafpr2.02.00:Income.Operating.RentalIncomeGross.Amount
    /// </summary>
    public decimal? TRT89 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Rent
    /// TRT:bafpr1.02.05:Expense.Interest.Amount
    /// </summary>
    public decimal? TRT90 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Rent
    /// TRT:bafpr1.02.02:Expense.CapitalWorksDeduction.Amount
    /// </summary>
    public decimal? TRT91 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Rent
    /// TRT:rvctc2.02.00:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
    /// </summary>
    public decimal? TRT92 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:bafpr1.02.23:Income.ForestryManagedInvestmentScheme.Amount
    /// </summary>
    public decimal? TRT93 = null;

    public bool RP_BusinessDetails_Income_GrossInterestCollectionExists = false;
    public int RP_BusinessDetails_Income_GrossInterestCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:GrossInterest
    /// TRT:bafpr2.02.02:Income.Interest.Gross.Amount
    /// </summary>
    public decimal? TRT94 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:GrossInterest
    /// TRT:rvctc1.02.16:IncomeTax.TFNAmountsWithheldFromGrossInterest.Amount
    /// </summary>
    public decimal? TRT95 = null;

    public bool RP_BusinessDetails_Income_DividendsCollectionExists = false;
    public int RP_BusinessDetails_Income_DividendsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Dividends
    /// TRT:bafpr1.02.05:Income.DividendsUnfranked.Amount
    /// </summary>
    public decimal? TRT96 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Dividends
    /// TRT:bafpr1.02.00:Income.DividendsFranked.Amount
    /// </summary>
    public decimal? TRT97 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Dividends
    /// TRT:rvctc1.02.03:IncomeTax.FrankingCredits.Amount
    /// </summary>
    public decimal? TRT98 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Dividends
    /// TRT:rvctc1.02.00:IncomeTax.DividendsTFNAmountsWithheld.Amount
    /// </summary>
    public decimal? TRT99 = null;

    public bool RP_BusinessDetails_Income_SuperannuationLumpSumWithholdingPaymentDetailsCollectionExists = false;
    public int RP_BusinessDetails_Income_SuperannuationLumpSumWithholdingPaymentDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationLumpSumWithholdingPaymentDetails
    /// TRT:emsup.02.01:SuperannuationBenefit.DeathBenefitLumpSumPaymentTaxedElement.Amount
    /// </summary>
    public decimal? TRT100 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationLumpSumWithholdingPaymentDetails
    /// TRT:emsup.02.01:SuperannuationBenefit.DeathBenefitLumpSumPaymentUntaxedElement.Amount
    /// </summary>
    public decimal? TRT101 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationLumpSumWithholdingPaymentDetails
    /// TRT:crigi.02.00:InsuranceBenefits.DeathBenefit.Indicator
    /// </summary>
    public bool? TRT408 = null;

    public bool RP_BusinessDetails_Income_EmploymentTerminationPaymentDetailsCollectionExists = false;
    public int RP_BusinessDetails_Income_EmploymentTerminationPaymentDetailsCollectionCount = 0;
    
    public List<RP_BusinessDetails_Income_EmploymentTerminationPaymentDetails> RP_BusinessDetails_Income_EmploymentTerminationPaymentDetailsCollection = null;
    
    public class RP_BusinessDetails_Income_EmploymentTerminationPaymentDetails 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:EmploymentTerminationPaymentDetails
        /// TRT:emsup.02.01:SuperannuationBenefit.DeathBenefitEmploymentTerminationPaymentTaxableComponent.Amount
        /// </summary>
        public decimal? TRT102 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:EmploymentTerminationPaymentDetails
        /// TRT:crigi.02.00:InsuranceBenefits.DeathBenefit.Indicator
        /// </summary>
        public bool? TRT409 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:EmploymentTerminationPaymentDetails
        /// TRT:crigi.02.00:InsuranceBenefits.BeneficiaryType.Code
        /// </summary>
        public string TRT411 = null;
    }

    public bool RP_BusinessDetails_Income_OtherAustralianIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_OtherAustralianIncomeCollectionCount = 0;
    
    public List<RP_BusinessDetails_Income_OtherAustralianIncome> RP_BusinessDetails_Income_OtherAustralianIncomeCollection = null;
    
    public class RP_BusinessDetails_Income_OtherAustralianIncome 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:OtherAustralianIncome
        /// TRT:bafpr1.02.00:Income.Other.Description
        /// </summary>
        public string TRT120 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:OtherAustralianIncome
        /// TRT:bafpr1.02.04:Income.Other.Amount
        /// </summary>
        public decimal? TRT121 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:bafpr1.02.04:Income.ExceptedTrustNet.Amount
    /// </summary>
    public decimal? TRT122 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:rvctc1.02.00:IncomeTax.AustralianGovernmentPensionsAndAllowancesTaxWithheld.Amount
    /// </summary>
    public decimal? TRT104 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:gfapc.02.01:Pension.Total.Amount
    /// </summary>
    public decimal? TRT105 = null;

    public bool RP_BusinessDetails_Income_IndividualNonBusinessWithholdingPaymentDetailsCollectionExists = false;
    public int RP_BusinessDetails_Income_IndividualNonBusinessWithholdingPaymentDetailsCollectionCount = 0;
    
    public List<RP_BusinessDetails_Income_IndividualNonBusinessWithholdingPaymentDetails> RP_BusinessDetails_Income_IndividualNonBusinessWithholdingPaymentDetailsCollection = null;
    
    public class RP_BusinessDetails_Income_IndividualNonBusinessWithholdingPaymentDetails 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string TRT107 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:rvctc2.02.12:IncomeTax.PayAsYouGoWithholding.TaxWithheld.Amount
        /// </summary>
        public decimal? TRT108 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:lrla.02.22:Remuneration.IndividualNonBusinessGross.Amount
        /// </summary>
        public decimal? TRT109 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumA.Amount
        /// </summary>
        public decimal? TRT110 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:lrla.02.22:Remuneration.UnusedAnnualLongServiceLeavePaymentLumpSumA.Amount
        /// </summary>
        public decimal? TRT111 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldUnusedAnnualOrLongServiceLeavePaymentLumpSumB.Amount
        /// </summary>
        public decimal? TRT112 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:IndividualNonBusinessWithholdingPaymentDetails
        /// TRT:lrla.02.22:Remuneration.UnusedAnnualLongServiceLeavePaymentLumpSumB.Amount
        /// </summary>
        public decimal? TRT113 = null;
    }

    public bool RP_BusinessDetails_Income_SuperannuationIncomeStreamWithholdingPaymentDetailsCollectionExists = false;
    public int RP_BusinessDetails_Income_SuperannuationIncomeStreamWithholdingPaymentDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationIncomeStreamWithholdingPaymentDetails
    /// TRT:rvctc2.02.12:IncomeTax.PayAsYouGoWithholding.TaxWithheld.Amount
    /// </summary>
    public decimal? TRT114 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationIncomeStreamWithholdingPaymentDetails
    /// TRT:rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentTaxedElement.Amount
    /// </summary>
    public decimal? TRT115 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationIncomeStreamWithholdingPaymentDetails
    /// TRT:rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentUntaxedElement.Amount
    /// </summary>
    public decimal? TRT116 = null;

    public bool RP_BusinessDetails_Income_SuperannuationIncomeStreamWithholdingPaymentDetails_LumpSumInArrearsCollectionExists = false;
    public int RP_BusinessDetails_Income_SuperannuationIncomeStreamWithholdingPaymentDetails_LumpSumInArrearsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationIncomeStreamWithholdingPaymentDetails/:LumpSumInArrears
    /// TRT:rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentTaxedElement.Amount
    /// </summary>
    public decimal? TRT117 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:SuperannuationIncomeStreamWithholdingPaymentDetails/:LumpSumInArrears
    /// TRT:rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentUntaxedElement.Amount
    /// </summary>
    public decimal? TRT118 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:lrla.02.00:Remuneration.BonusesAndAllowances.Amount
    /// </summary>
    public decimal? TRT119 = null;

    public bool RP_BusinessDetails_Income_DeductionsCollectionExists = false;
    public int RP_BusinessDetails_Income_DeductionsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Deductions
    /// TRT:bafpr1.02.04:Expense.AustralianInvestmentAllowableDeduction.Amount
    /// </summary>
    public decimal? TRT123 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Deductions
    /// TRT:rvctc2.02.06:IncomeTax.Deduction.DistributionFranked.Amount
    /// </summary>
    public decimal? TRT439 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Deductions
    /// TRT:bafpr1.02.23:Expense.ForestryManagedInvestmentSchemeDeduction.Amount
    /// </summary>
    public decimal? TRT124 = null;

    public bool RP_BusinessDetails_Income_Deductions_OtherDeductionsCollectionExists = false;
    public int RP_BusinessDetails_Income_Deductions_OtherDeductionsCollectionCount = 0;
    
    public List<RP_BusinessDetails_Income_Deductions_OtherDeductions> RP_BusinessDetails_Income_Deductions_OtherDeductionsCollection = null;
    
    public class RP_BusinessDetails_Income_Deductions_OtherDeductions 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Deductions/:OtherDeductions
        /// TRT:bafpr1.02.04:Expense.DeductibleOther.Text
        /// </summary>
        public string TRT128 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:Deductions/:OtherDeductions
        /// TRT:bafpr1.02.04:Expense.DeductibleOther.Amount
        /// </summary>
        public decimal? TRT129 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:bafpr1.02.23:Income.Net.Amount
    /// </summary>
    public decimal? TRT130 = null;

    public bool RP_BusinessDetails_Income_CapitalGainsCollectionExists = false;
    public int RP_BusinessDetails_Income_CapitalGainsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:CapitalGains
    /// TRT:rvctc3.02.00:CapitalGainsTax.Event.Indicator
    /// </summary>
    public bool? TRT131 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:CapitalGains
    /// TRT:bafpr1.02.00:Income.CapitalGainsNet.Amount
    /// </summary>
    public decimal? TRT133 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:CapitalGains
    /// TRT:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
    /// </summary>
    public decimal? TRT480 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:CapitalGains
    /// TRT:rvctc3.02.11:CapitalGainsTax.ExemptionOrRolloverApplied.Indicator
    /// </summary>
    public bool? TRT454 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:CapitalGains
    /// TRT:rvctc3.02.47:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    /// </summary>
    public List<string> TRT448Collection = null;

    public bool RP_BusinessDetails_Income_AttributedForeignIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_AttributedForeignIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome
    /// TRT:bafpr3.02.03:Income.InternationalDealings.AttributedForeignIncomeForeignTrustorControlledForeignCompanyorTransferorTrust.Indicator
    /// </summary>
    public bool? TRT138 = null;

    public bool RP_BusinessDetails_Income_AttributedForeignIncome_ListedCountryCollectionExists = false;
    public int RP_BusinessDetails_Income_AttributedForeignIncome_ListedCountryCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:ListedCountry
    /// TRT:bafpr3.02.02:Income.InternationalDealings.Attributed.Amount
    /// </summary>
    public decimal? TRT134 = null;

    public bool RP_BusinessDetails_Income_AttributedForeignIncome_UnlistedCountryCollectionExists = false;
    public int RP_BusinessDetails_Income_AttributedForeignIncome_UnlistedCountryCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:UnlistedCountry
    /// TRT:bafpr3.02.02:Income.InternationalDealings.Attributed.Amount
    /// </summary>
    public decimal? TRT136 = null;

    public bool RP_BusinessDetails_Income_AttributedForeignIncome_OtherAssessableForeignIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_AttributedForeignIncome_OtherAssessableForeignIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:OtherAssessableForeignIncome
    /// TRT:bafpr1.02.04:Income.Other.Amount
    /// </summary>
    public decimal? TRT140 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:OtherAssessableForeignIncome
    /// TRT:bafpr1.02.23:Income.Net.Amount
    /// </summary>
    public decimal? TRT141 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:OtherAssessableForeignIncome
    /// TRT:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
    /// </summary>
    public decimal? TRT142 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:AttributedForeignIncome/:OtherAssessableForeignIncome
    /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromNewZealandCompanies.Amount
    /// </summary>
    public decimal? TRT143 = null;

    public bool RP_BusinessDetails_Income_TaxLossesDeductedCollectionExists = false;
    public int RP_BusinessDetails_Income_TaxLossesDeductedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:TaxLossesDeducted
    /// TRT:rvctc2.02.00:IncomeTax.Deduction.TaxLossesDeducted.Amount
    /// </summary>
    public decimal? TRT144 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:rvctc3.02.02:Tax.Losses.CarriedForward.LaterIncomeYearsTotal.Amount
    /// </summary>
    public decimal? TRT145 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:rvctc3.02.16:Capital.Losses.CarriedForward.Net.Amount
    /// </summary>
    public decimal? TRT475 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:gfati.02.05:TaxOffsetClaim.LandcareAndWaterFacilityBroughtForward.Amount
    /// </summary>
    public decimal? TRT147 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income
    /// TRT:rvctc4.02.10:InternationalDealings.RelatedPartiesTransactionsExcessAggregateValue.Indicator
    /// </summary>
    public bool? TRT148 = null;

    public bool RP_BusinessDetails_Income_ThinCapitalisationCollectionExists = false;
    public int RP_BusinessDetails_Income_ThinCapitalisationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ThinCapitalisation
    /// TRT:bafpo6.02.15:Liabilities.ThinCapitalisation.ProvisionsApplied.Indicator
    /// </summary>
    public bool? TRT449 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ThinCapitalisation
    /// TRT:bafpr1.02.05:Expense.Interest.Amount
    /// </summary>
    public decimal? TRT182 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ThinCapitalisation
    /// TRT:bafpr1.02.27:Expense.Royalties.Amount
    /// </summary>
    public decimal? TRT183 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ThinCapitalisation
    /// TRT:pyde.02.25:Residency.TaxPurposesPersonStatus.Indicator
    /// </summary>
    public bool? TRT149 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:ThinCapitalisation
    /// TRT:rvctc4.02.11:InternationalDealings.TransactionsWithTaxHavenCountries.Indicator
    /// </summary>
    public bool? TRT151 = null;

    public bool RP_BusinessDetails_Income_PersonalServicesIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_PersonalServicesIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:bafpr1.02.13:Income.PersonalServicesIncomeIncluded.Indicator
    /// </summary>
    public bool? TRT155 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:bafpr3.02.11:Income.PersonalServicesIncome.Total.Amount
    /// </summary>
    public decimal? TRT450 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:bafpr3.02.11:Expense.PersonalServicesIncome.Deduction.Amount
    /// </summary>
    public decimal? TRT451 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:rvctc2.02.15:IncomeTax.PersonalServicesIncome.IndividualResultsTestSatisfied.Indicator
    /// </summary>
    public bool? TRT452 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:rvctc2.02.15:IncomeTax.PersonalServicesIncome.IndividualPersonalServiceBusinessDeterminationHeld.Indicator
    /// </summary>
    public bool? TRT453 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:rvctc2.02.15:IncomeTax.PersonalServicesIncome.UnrelatedClientsTestSatisfied.Indicator
    /// </summary>
    public bool? TRT455 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:rvctc2.02.15:IncomeTax.PersonalServicesIncome.EmploymentTestSatisfied.Indicator
    /// </summary>
    public bool? TRT456 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:PersonalServicesIncome
    /// TRT:rvctc2.02.15:IncomeTax.PersonalServicesIncome.BusinessPremisesTestSatisfied.Indicator
    /// </summary>
    public bool? TRT457 = null;

    public bool RP_BusinessDetails_Income_TaxationOfFinancialArrangementsCollectionExists = false;
    public int RP_BusinessDetails_Income_TaxationOfFinancialArrangementsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:TaxationOfFinancialArrangements
    /// TRT:bafpr1.02.04:Income.GainsTotal.Amount
    /// </summary>
    public decimal? TRT356 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:TaxationOfFinancialArrangements
    /// TRT:bafpr1.02.04:Expense.LossesTotal.Amount
    /// </summary>
    public decimal? TRT357 = null;

    public bool RP_BusinessDetails_Income_NCMIBusinessIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIBusinessIncomeCollectionCount = 0;

    public bool RP_BusinessDetails_Income_NCMIBusinessIncome_NCMIBusinessIncomePrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIBusinessIncome_NCMIBusinessIncomePrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIBusinessIncome/:NCMIBusinessIncomePrimaryProduction
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT523 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIBusinessIncome/:NCMIBusinessIncomePrimaryProduction
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT524 = null;

    public bool RP_BusinessDetails_Income_NCMIBusinessIncome_NCMIBusinessIncomeNonPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIBusinessIncome_NCMIBusinessIncomeNonPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIBusinessIncome/:NCMIBusinessIncomeNonPrimaryProduction
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT525 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIBusinessIncome/:NCMIBusinessIncomeNonPrimaryProduction
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT526 = null;

    public bool RP_BusinessDetails_Income_NCMIPartnershipsAndTrustsCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIPartnershipsAndTrustsCollectionCount = 0;

    public bool RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsPrimaryProduction
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT527 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsPrimaryProduction
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT528 = null;

    public bool RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsPrimaryProduction_PrimaryProductionShareOfNetIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsPrimaryProduction_PrimaryProductionShareOfNetIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsPrimaryProduction/:PrimaryProductionShareOfNetIncome
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT529 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsPrimaryProduction/:PrimaryProductionShareOfNetIncome
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT530 = null;

    public bool RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsNonPrimaryProductionCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsNonPrimaryProductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsNonPrimaryProduction
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT531 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsNonPrimaryProduction
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT532 = null;

    public bool RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsNonPrimaryProduction_NonPrimaryProductionShareOfNetIncomeCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMIPartnershipsAndTrusts_NCMIPartnershipsAndTrustsNonPrimaryProduction_NonPrimaryProductionShareOfNetIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsNonPrimaryProduction/:NonPrimaryProductionShareOfNetIncome
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT533 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMIPartnershipsAndTrusts/:NCMIPartnershipsAndTrustsNonPrimaryProduction/:NonPrimaryProductionShareOfNetIncome
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT534 = null;

    public bool RP_BusinessDetails_Income_NCMICapitalGainsCollectionExists = false;
    public int RP_BusinessDetails_Income_NCMICapitalGainsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMICapitalGains
    /// TRT:rvctc3.02.49:Capital.Gains.NonConcessionalManagedInvestmentTrustIncome.Amount
    /// </summary>
    public decimal? TRT535 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessDetails/:Income/:NCMICapitalGains
    /// TRT:rvctc3.02.49:Capital.Gains.ExcludedFromNonConcessionalManagedInvestmentTrustIncome.Amount
    /// </summary>
    public decimal? TRT536 = null;

    public bool RP_KeyFinancialInformationCollectionExists = false;
    public int RP_KeyFinancialInformationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:KeyFinancialInformation
    /// TRT:bafpo1.02.00:Assets.CurrentTotal.Amount
    /// </summary>
    public decimal? TRT156 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:KeyFinancialInformation
    /// TRT:bafpo1.02.13:Assets.Total.Amount
    /// </summary>
    public decimal? TRT157 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:KeyFinancialInformation
    /// TRT:bafpo1.02.00:Liabilities.CurrentTotal.Amount
    /// </summary>
    public decimal? TRT158 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:KeyFinancialInformation
    /// TRT:bafpo1.02.13:Liabilities.Total.Amount
    /// </summary>
    public decimal? TRT159 = null;

    public bool RP_BusinessAndProfessionalInformationCollectionExists = false;
    public int RP_BusinessAndProfessionalInformationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation
    /// TRT:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
    /// </summary>
    public string TRT161 = null;

    public bool RP_BusinessAndProfessionalInformation_BusinessAddressDetailsCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_BusinessAddressDetailsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.OverseasAddress.Indicator
    /// </summary>
    public bool? TRT316 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line1.Text
    /// </summary>
    public string TRT162 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Line2.Text
    /// </summary>
    public string TRT309 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.LocalityName.Text
    /// </summary>
    public string TRT163 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.Postcode.Text
    /// </summary>
    public string TRT165 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.00:AddressDetails.StateOrTerritory.Code
    /// </summary>
    public string TRT164 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAddressDetails
    /// TRT:pyde.02.08:AddressDetails.Country.Code
    /// </summary>
    public string TRT374 = null;

    public bool RP_BusinessAndProfessionalInformation_BusinessAndProfessionaltemsCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_BusinessAndProfessionaltemsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:bafpo7.02.04:Assets.Inventories.Total.Amount
    /// </summary>
    public decimal? TRT166 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:bafpr2.02.02:Expense.Purchases.AndOtherCosts.Amount
    /// </summary>
    public decimal? TRT167 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:lrla.02.17:Remuneration.WagesAndSalaries.Total.Amount
    /// </summary>
    public decimal? TRT172 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:lrla.02.05:Remuneration.WagesAndSalariesAction.Code
    /// </summary>
    public string TRT173 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:lrla.02.00:Remuneration.PaymentToRelatedPartiesGross.Amount
    /// </summary>
    public decimal? TRT174 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:lrla.02.00:Remuneration.FringeBenefits.EmployeeContribution.Amount
    /// </summary>
    public decimal? TRT181 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:rvctc1.02.00:IncomeTax.PrivateCompanyUnpaidPresentEntitlement.Code
    /// </summary>
    public string TRT187 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems
    /// TRT:rvctc3.02.02:Elections.TradingStock.Indicator
    /// </summary>
    public bool? TRT188 = null;

    public bool RP_BusinessAndProfessionalInformation_BusinessAndProfessionaltems_ClosingCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_BusinessAndProfessionaltems_ClosingCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems/:Closing
    /// TRT:bafpo7.02.04:Assets.Inventories.Total.Amount
    /// </summary>
    public decimal? TRT168 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems/:Closing
    /// TRT:bafpo7.02.18:Assets.Inventories.ValuationMethod.Code
    /// </summary>
    public string TRT169 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems/:Closing
    /// TRT:bafpo1.02.13:Assets.TradeandReceivablesOther.Amount
    /// </summary>
    public decimal? TRT170 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems/:Closing
    /// TRT:bafpo1.02.13:Liabilities.TradeAndOtherPayablesTotal.Amount
    /// </summary>
    public decimal? TRT171 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:BusinessAndProfessionaltems/:Closing
    /// TRT:rvctc1.02.00:IncomeTax.PrivateCompanyUnpaidPresentEntitlement.Amount
    /// </summary>
    public decimal? TRT186 = null;

    public bool RP_BusinessAndProfessionalInformation_AggregatedTurnoverCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_AggregatedTurnoverCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:AggregatedTurnover
    /// TRT:bafpr1.02.44:Income.AggregatedTurnoverRange.Code
    /// </summary>
    public string TRT563 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:AggregatedTurnover
    /// TRT:bafpr1.02.44:Income.AggregatedTurnover.Amount
    /// </summary>
    public decimal? TRT564 = null;

    public bool RP_BusinessAndProfessionalInformation_CapitalAllowancesCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_CapitalAllowancesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowances
    /// TRT:bafpr3.02.20:Expense.DepreciatingAssets.IntangibleFirstDeducted.Amount
    /// </summary>
    public decimal? TRT175 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowances
    /// TRT:bafpr3.02.20:Expense.DepreciatingAssets.OtherFirstDeducted.Amount
    /// </summary>
    public decimal? TRT176 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowances
    /// TRT:bafpo7.02.22:Assets.PropertyPlantAndEquipment.DepreciatingAssets.FirstDeductedSelfAssessedEffectiveLife.Indicator
    /// </summary>
    public bool? TRT458 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowances
    /// TRT:bafpr1.02.44:Expense.SubsequentYearAcceleratedDepreciationDeductionsForAssets.Amount
    /// </summary>
    public decimal? TRT561 = null;

    public bool RP_BusinessAndProfessionalInformation_CapitalAllowancesDepreciatingAssetsCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_CapitalAllowancesDepreciatingAssetsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpo7.02.22:Assets.PropertyPlantAndEquipment.DepreciatingAssets.EffectiveLifeRecalculation.Indicator
    /// </summary>
    public bool? TRT459 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpo7.02.02:Assets.DepreciatingAssets.AdjustableValuesTotal.Amount
    /// </summary>
    public decimal? TRT460 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpr3.02.11:Income.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
    /// </summary>
    public decimal? TRT461 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpr3.02.11:Expense.DepreciatingAssets.IntangibleBalancingAdjustment.Amount
    /// </summary>
    public decimal? TRT462 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpo7.02.02:Assets.DepreciatingAssets.IntangibleTerminationValue.Amount
    /// </summary>
    public decimal? TRT177 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpo7.02.02:Assets.DepreciatingAssets.OtherTerminationValue.Amount
    /// </summary>
    public decimal? TRT178 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpr1.02.02:Expense.ProjectPoolAllowableDeduction.Amount
    /// </summary>
    public decimal? TRT179 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpr1.02.02:Expense.CapitalExpenditureSpecifiedAllowableDeduction.Amount
    /// </summary>
    public decimal? TRT180 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:CapitalAllowancesDepreciatingAssets
    /// TRT:bafpr1.02.28:Expense.LandcareOperationsAcceleratedDepreciation.Amount
    /// </summary>
    public decimal? TRT184 = null;

    public bool RP_BusinessAndProfessionalInformation_LowCostDeductionCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_LowCostDeductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:LowCostDeduction
    /// TRT:bafpr3.02.11:Expense.DepreciatingAssets.SmallBusinessEntity.Amount
    /// </summary>
    public decimal? TRT189 = null;

    public bool RP_BusinessAndProfessionalInformation_GeneralPoolDeductionCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_GeneralPoolDeductionCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:GeneralPoolDeduction
    /// TRT:bafpr3.02.11:Expense.DepreciatingAssets.SmallBusinessEntity.Amount
    /// </summary>
    public decimal? TRT190 = null;

    public bool RP_BusinessAndProfessionalInformation_SmallBusinessBoostCollectionExists = false;
    public int RP_BusinessAndProfessionalInformation_SmallBusinessBoostCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:SmallBusinessBoost
    /// TRT:bafpr1.02.48:Expense.EmployeeTrainingBonus.Amount
    /// </summary>
    public decimal? TRT567 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BusinessAndProfessionalInformation/:SmallBusinessBoost
    /// TRT:bafpr1.02.50:Expense.EnergyIncentive.Amount
    /// </summary>
    public decimal? TRT576 = null;

    public bool RP_TaxOffsetsCollectionExists = false;
    public int RP_TaxOffsetsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TaxOffsets
    /// TRT:gfati.02.01:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlement.Amount
    /// </summary>
    public decimal? TRT340 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TaxOffsets
    /// TRT:rvctc1.02.17:IncomeTax.TaxOffsetRefundableOther.Amount
    /// </summary>
    public decimal? TRT463 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TaxOffsets
    /// TRT:rvctc1.02.18:IncomeTax.TaxOffsetRefundableOther.Code
    /// </summary>
    public string TRT464 = null;

    public bool RP_TaxOffsets_LimitedPartnershipTaxOffsetCollectionExists = false;
    public int RP_TaxOffsets_LimitedPartnershipTaxOffsetCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TaxOffsets/:LimitedPartnershipTaxOffset
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT500 = null;

    public bool RP_TaxOffsets_InvestorTaxOffsetCollectionExists = false;
    public int RP_TaxOffsets_InvestorTaxOffsetCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TaxOffsets/:InvestorTaxOffset
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT501 = null;

    public bool RP_MedicareLevyCollectionExists = false;
    public int RP_MedicareLevyCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MedicareLevy
    /// TRT:rvctc2.02.00:IncomeTax.MedicareLevy.BeneficiarySpouseTaxableIncome.Amount
    /// </summary>
    public decimal? TRT194 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MedicareLevy
    /// TRT:rvctc2.02.14:IncomeTax.MedicareLevy.DependentChildrenAndStudents.Count
    /// </summary>
    public decimal? TRT195 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MedicareLevy
    /// TRT:rvctc2.02.15:IncomeTax.MedicareLevy.ExemptionFullDays.Count
    /// </summary>
    public decimal? TRT196 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MedicareLevy
    /// TRT:rvctc2.02.00:IncomeTax.MedicareLevy.ExemptionFullDays.Code
    /// </summary>
    public string TRT197 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:MedicareLevy
    /// TRT:rvctc2.02.15:IncomeTax.MedicareLevy.ExemptionHalfDays.Count
    /// </summary>
    public decimal? TRT198 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:bafpr1.02.10:Income.TrustEstateIncome.Amount
    /// </summary>
    public decimal? TRT440 = null;

    public bool RP_StatementOfDistributionToBeneficiaryCollectionExists = false;
    public int RP_StatementOfDistributionToBeneficiaryCollectionCount = 0;
    
    public List<RP_StatementOfDistributionToBeneficiary> RP_StatementOfDistributionToBeneficiaryCollection = null;
    
    public class RP_StatementOfDistributionToBeneficiary 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary
        /// TRT:pyid.02.00:Identifiers.TaxFileNumber.Identifier
        /// </summary>
        public string TRT211 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary
        /// TRT:pyid.02.00:Identifiers.TaxFileNumberTrailingNumeric.Identifier
        /// </summary>
        public string TRT212 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary
        /// TRT:rvctc1.02.04:IncomeTax.BeneficiaryEntityType.Code
        /// </summary>
        public string TRT432 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_NonIndividualNameDetailsCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_NonIndividualNameDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:NonIndividualNameDetails
        /// TRT:pyde.02.50:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string TRT203 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_IndividualNameDetailsCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_IndividualNameDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:IndividualNameDetails
        /// TRT:pyde.02.00:PersonNameDetails.Title.Text
        /// </summary>
        public string TRT378 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:IndividualNameDetails
        /// TRT:pyde.02.00:PersonNameDetails.NameSuffix.Text
        /// </summary>
        public string TRT379 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:IndividualNameDetails
        /// TRT:pyde.02.00:PersonNameDetails.FamilyName.Text
        /// </summary>
        public string TRT200 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:IndividualNameDetails
        /// TRT:pyde.02.00:PersonNameDetails.GivenName.Text
        /// </summary>
        public string TRT201 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:IndividualNameDetails
        /// TRT:pyde.02.00:PersonNameDetails.OtherGivenName.Text
        /// </summary>
        public string TRT202 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary
        /// TRT:pyde.02.00:PersonDemographicDetails.Birth.Date
        /// </summary>
        public DateTime? TRT213 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_BeneficiaryAddressDetailsCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_BeneficiaryAddressDetailsCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.OverseasAddress.Indicator
        /// </summary>
        public bool? TRT320 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.01:AddressDetails.Usage.Code
        /// </summary>
        public string TRT327 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.Line1.Text
        /// </summary>
        public string TRT205 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.Line2.Text
        /// </summary>
        public string TRT206 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.LocalityName.Text
        /// </summary>
        public string TRT207 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.Postcode.Text
        /// </summary>
        public string TRT209 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.00:AddressDetails.StateOrTerritory.Code
        /// </summary>
        public string TRT208 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:BeneficiaryAddressDetails
        /// TRT:pyde.02.08:AddressDetails.Country.Code
        /// </summary>
        public string TRT382 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_InformationCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_InformationCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc1.02.45:IncomeTax.AssessmentCalculation.Code
        /// </summary>
        public string TRT214 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr1.02.10:Income.TrustEstateIncomeShare.Amount
        /// </summary>
        public decimal? TRT441 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.13:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldFromForeignResidents.Amount
        /// </summary>
        public decimal? TRT476 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromNewZealandCompanies.Amount
        /// </summary>
        public decimal? TRT217 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
        /// </summary>
        public decimal? TRT220 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr1.02.41:Income.TaxableMinorBeneficiary.Amount
        /// </summary>
        public decimal? TRT549 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr1.02.09:Income.DistributionFranked.Amount
        /// </summary>
        public decimal? TRT442 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromAustralianCompanies.Amount
        /// </summary>
        public decimal? TRT221 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.04:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldWhereTFNNotQuoted.Amount
        /// </summary>
        public decimal? TRT222 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.03:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldFromCloselyHeldTrust.Amount
        /// </summary>
        public decimal? TRT419 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr1.02.00:Income.CapitalGainsNet.Amount
        /// </summary>
        public decimal? TRT223 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc3.02.11:Capital.Gains.Total.Amount
        /// </summary>
        public decimal? TRT569 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc3.02.11:Capital.Losses.Total.Amount
        /// </summary>
        public decimal? TRT570 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:gfagc.02.06:TaxConcession.CapitalGains.DiscountTotal.Amount
        /// </summary>
        public decimal? TRT571 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:gfagc.02.01:TaxConcession.CapitalGains.DiscountAndSmallBusinessConcessionsTotal.Amount
        /// </summary>
        public decimal? TRT572 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc3.02.49:Capital.Gains.NonConcessionalManagedInvestmentTrustIncome.Amount
        /// </summary>
        public decimal? TRT541 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc3.02.49:Capital.Gains.ExcludedFromNonConcessionalManagedInvestmentTrustIncome.Amount
        /// </summary>
        public decimal? TRT542 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
        /// </summary>
        public decimal? TRT481 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc1.02.00:IncomeTax.AttributedForeignIncome.Amount
        /// </summary>
        public decimal? TRT224 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr3.02.14:Income.InternationalDealings.Net.Amount
        /// </summary>
        public decimal? TRT225 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
        /// </summary>
        public decimal? TRT226 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:gfati.02.01:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlement.Amount
        /// </summary>
        public decimal? TRT342 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:rvctc1.02.32:IncomeTax.ExplorationCreditsDistributed.Amount
        /// </summary>
        public decimal? TRT465 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information
        /// TRT:bafpr1.02.04:Income.SmallBusinessEntityNet.Amount
        /// </summary>
        public decimal? TRT479 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_ShareOfIncomePrimaryProductionCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_ShareOfIncomePrimaryProductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomePrimaryProduction
        /// TRT:bafpr1.02.04:Income.BeneficiaryShare.Amount
        /// </summary>
        public decimal? TRT218 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomePrimaryProduction
        /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? TRT537 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomePrimaryProduction
        /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? TRT538 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_ShareOfIncomeNonPrimaryProductionCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_ShareOfIncomeNonPrimaryProductionCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomeNonPrimaryProduction
        /// TRT:bafpr1.02.04:Income.BeneficiaryShare.Amount
        /// </summary>
        public decimal? TRT219 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomeNonPrimaryProduction
        /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? TRT539 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:ShareOfIncomeNonPrimaryProduction
        /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
        /// </summary>
        public decimal? TRT540 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_EarlyStageVentureTaxOffsetCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_EarlyStageVentureTaxOffsetCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:EarlyStageVentureTaxOffset
        /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
        /// </summary>
        public decimal? TRT502 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_EarlyStageInvestorTaxOffsetCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_EarlyStageInvestorTaxOffsetCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:EarlyStageInvestorTaxOffset
        /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
        /// </summary>
        public decimal? TRT503 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_NonResidentAdditionalInformationCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_NonResidentAdditionalInformationCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:NonResidentAdditionalInformation
        /// TRT:rvctc4.02.00:InternationalDealings.AssessableIncomeNonResidentBeneficiaryNonTrustee.Amount
        /// </summary>
        public decimal? TRT228 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:NonResidentAdditionalInformation
        /// TRT:rvctc4.02.00:InternationalDealings.AssessableIncomeNonResidentBeneficiaryTrustee.Amount
        /// </summary>
        public decimal? TRT229 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_Information_TBStatementInformationCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_Information_TBStatementInformationCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:TBStatementInformation
        /// TRT:rvctc1.02.03:IncomeTax.TrustBeneficiaryStatement.Indicator
        /// </summary>
        public bool? TRT344 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:TBStatementInformation
        /// TRT:rvctc2.02.02:IncomeTax.Superannuation.TrusteeBeneficiaryTaxPreferred.Amount
        /// </summary>
        public decimal? TRT345 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:Information/:TBStatementInformation
        /// TRT:rvctc2.02.02:IncomeTax.Superannuation.TrusteeBeneficiaryUntaxedPartShareOfNetIncome.Amount
        /// </summary>
        public decimal? TRT346 = null;
    
        public bool RP_StatementOfDistributionToBeneficiary_AnnualTrusteePaymentReportInformationCollectionExists = false;
        public int RP_StatementOfDistributionToBeneficiary_AnnualTrusteePaymentReportInformationCollectionCount = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:AnnualTrusteePaymentReportInformation
        /// TRT:bafpr1.02.05:Expense.DistributionBeneficiaryCloselyHeldTrust.Amount
        /// </summary>
        public decimal? TRT433 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:StatementOfDistributionToBeneficiary/:AnnualTrusteePaymentReportInformation
        /// TRT:rvctc2.02.03:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldFromCloselyHeldTrust.Amount
        /// </summary>
        public decimal? TRT434 = null;
    }

    public bool RP_IncomeNoBeneficiaryPresentlyEntitledCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitledCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc1.02.45:IncomeTax.AssessmentCalculation.Code
    /// </summary>
    public string TRT230 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:bafpr1.02.10:Income.TrustEstateIncomeShare.Amount
    /// </summary>
    public decimal? TRT443 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.13:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldFromForeignResidents.Amount
    /// </summary>
    public decimal? TRT477 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromNewZealandCompanies.Amount
    /// </summary>
    public decimal? TRT233 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.00:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldWhereABNNotQuoted.Amount
    /// </summary>
    public decimal? TRT236 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:bafpr1.02.09:Income.DistributionFranked.Amount
    /// </summary>
    public decimal? TRT444 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.00:IncomeTax.FrankingCredits.ReceivedFromAustralianCompanies.Amount
    /// </summary>
    public decimal? TRT237 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.04:IncomeTax.PayAsYouGoWithholding.CreditForAmountsWithheldWhereTFNNotQuoted.Amount
    /// </summary>
    public decimal? TRT238 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.03:IncomeTax.PayAsYouGoWithholding.CreditForTaxWithheldFromCloselyHeldTrust.Amount
    /// </summary>
    public decimal? TRT435 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:bafpr1.02.00:Income.CapitalGainsNet.Amount
    /// </summary>
    public decimal? TRT239 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc3.02.49:Capital.Gains.NonConcessionalManagedInvestmentTrustIncome.Amount
    /// </summary>
    public decimal? TRT547 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc3.02.49:Capital.Gains.ExcludedFromNonConcessionalManagedInvestmentTrustIncome.Amount
    /// </summary>
    public decimal? TRT548 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc2.02.22:IncomeTax.PayAsYouGoWithholding.CreditForCapitalGainsWithheldFromForeignResidents.Amount
    /// </summary>
    public decimal? TRT482 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc1.02.00:IncomeTax.AttributedForeignIncome.Amount
    /// </summary>
    public decimal? TRT240 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:bafpr3.02.14:Income.InternationalDealings.Net.Amount
    /// </summary>
    public decimal? TRT241 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:bafpr3.02.18:Income.InternationalDealings.TaxOffset.Amount
    /// </summary>
    public decimal? TRT242 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:gfati.02.01:TaxOffsetClaim.NationalRentalAffordabilitySchemeEntitlement.Amount
    /// </summary>
    public decimal? TRT343 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled
    /// TRT:rvctc1.02.17:IncomeTax.TaxOffsetRefundableOther.Amount
    /// </summary>
    public decimal? TRT466 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_PrimaryProductionNoBeneficiaryEntitledCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_PrimaryProductionNoBeneficiaryEntitledCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:PrimaryProductionNoBeneficiaryEntitled
    /// TRT:rvctc1.02.00:IncomeTax.IncomeOrLossTaxable.Amount
    /// </summary>
    public decimal? TRT234 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:PrimaryProductionNoBeneficiaryEntitled
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT543 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:PrimaryProductionNoBeneficiaryEntitled
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT544 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_NonPrimaryProductionNoBeneficiaryEntitledCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_NonPrimaryProductionNoBeneficiaryEntitledCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:NonPrimaryProductionNoBeneficiaryEntitled
    /// TRT:rvctc1.02.00:IncomeTax.IncomeOrLossTaxable.Amount
    /// </summary>
    public decimal? TRT235 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:NonPrimaryProductionNoBeneficiaryEntitled
    /// TRT:bafpr1.02.40:Income.NonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT545 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:NonPrimaryProductionNoBeneficiaryEntitled
    /// TRT:bafpr1.02.40:Income.ExcludedFromNonConcessionalManagedInvestmentTrust.Amount
    /// </summary>
    public decimal? TRT546 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_EarlyStageVentureNoBeneficiaryCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_EarlyStageVentureNoBeneficiaryCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:EarlyStageVentureNoBeneficiary
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT504 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_EarlyStageVentureNoBeneficiary_EarlyStageVentureNoBeneficiaryCarriedForwardCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_EarlyStageVentureNoBeneficiary_EarlyStageVentureNoBeneficiaryCarriedForwardCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:EarlyStageVentureNoBeneficiary/:EarlyStageVentureNoBeneficiaryCarriedForward
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT505 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_InvestorNoBeneficiaryCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_InvestorNoBeneficiaryCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:InvestorNoBeneficiary
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT506 = null;

    public bool RP_IncomeNoBeneficiaryPresentlyEntitled_InvestorNoBeneficiary_InvestorNoBeneficiaryCarriedForwardCollectionExists = false;
    public int RP_IncomeNoBeneficiaryPresentlyEntitled_InvestorNoBeneficiary_InvestorNoBeneficiaryCarriedForwardCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:IncomeNoBeneficiaryPresentlyEntitled/:InvestorNoBeneficiary/:InvestorNoBeneficiaryCarriedForward
    /// TRT:gfati.02.06:TaxOffsetClaim.NonRefundableOther.Amount
    /// </summary>
    public decimal? TRT507 = null;

    public bool RP_CapitalGainsAssessedCollectionExists = false;
    public int RP_CapitalGainsAssessedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalGainsAssessed
    /// TRT:rvctc3.02.08:CapitalGainsTax.AssessmentCalculation.Code
    /// </summary>
    public string TRT445 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalGainsAssessed
    /// TRT:rvctc3.02.08:CapitalGainsTax.TrusteeAssessedCapitalGain.Amount
    /// </summary>
    public decimal? TRT446 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// TRT:rvctc1.02.00:IncomeTax.BeneficiaryUnderLegalDisabilityAlsoPresentlyEntitledToIncomeFromAnotherTrust.Indicator
    /// </summary>
    public bool? TRT244 = null;

    public bool RP_NonResidentTrustCollectionExists = false;
    public int RP_NonResidentTrustCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NonResidentTrust
    /// TRT:pyde.02.10:Residency.TaxPurposesOrganisationStatus.Code
    /// </summary>
    public string TRT245 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NonResidentTrust
    /// TRT:rvctc4.02.00:InternationalDealings.NonResidentTrustNonAustralianSourcedIncomeNoPresentEntitlement.Amount
    /// </summary>
    public decimal? TRT246 = null;

    public bool RP_OtherReportingInformationCollectionExists = false;
    public int RP_OtherReportingInformationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:OtherReportingInformation
    /// TRT:bafot.02.00:RegulatoryDisclosures.GeneralInformationAboutFinancialStatements.Text
    /// </summary>
    public string TRT405 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:OtherReportingInformation
    /// TRT:pyin.02.23:Report.CompletionHours.Number
    /// </summary>
    public decimal? TRT247 = null;

    public bool RP_ReportingPartyDeclarationCollectionExists = false;
    public int RP_ReportingPartyDeclarationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyin.02.03:Declaration.StatementType.Code
    /// </summary>
    public string TRT383 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyin.02.28:Declaration.StatementAccepted.Indicator
    /// </summary>
    public bool? TRT384 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyin.02.00:Declaration.Statement.Text
    /// </summary>
    public string TRT385 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyin.02.29:Declaration.Signature.Date
    /// </summary>
    public DateTime? TRT386 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyin.02.56:Declaration.SignatoryIdentifier.Text
    /// </summary>
    public string TRT387 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ReportingPartyDeclaration
    /// TRT:pyde.02.00:PersonUnstructuredName.FullName.Text
    /// </summary>
    public string TRT389 = null;

    public bool IntCollectionExists = false;
    public int IntCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:INT
    /// TRT:pyid.02.00:Identifiers.TaxAgentClientReference.Text
    /// </summary>
    public string TRT251 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT
    /// TRT:pyid.02.00:Identifiers.TaxAgentNumber.Identifier
    /// </summary>
    public string TRT2 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT
    /// TRT:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
    /// </summary>
    public string TRT575 = null;

    public bool InT_DeclarationCollectionExists = false;
    public int InT_DeclarationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:Declaration
    /// TRT:pyin.02.03:Declaration.StatementType.Code
    /// </summary>
    public string TRT390 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:Declaration
    /// TRT:pyin.02.28:Declaration.StatementAccepted.Indicator
    /// </summary>
    public bool? TRT391 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:Declaration
    /// TRT:pyin.02.00:Declaration.Statement.Text
    /// </summary>
    public string TRT392 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:Declaration
    /// TRT:pyin.02.29:Declaration.Signature.Date
    /// </summary>
    public DateTime? TRT393 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:Declaration
    /// TRT:pyin.02.56:Declaration.SignatoryIdentifier.Text
    /// </summary>
    public string TRT394 = null;

    public bool InT_Declaration_IntermediaryContactCollectionExists = false;
    public int InT_Declaration_IntermediaryContactCollectionCount = 0;
    
    public List<InT_Declaration_IntermediaryContact> InT_Declaration_IntermediaryContactCollection = null;
    
    public class InT_Declaration_IntermediaryContact 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:INT/:Declaration/:IntermediaryContact
        /// TRT:pyde.02.37:PersonUnstructuredName.Usage.Code
        /// </summary>
        public string TRT395 = null;

        /// <summary>
        /// /xbrli:xbrl/:INT/:Declaration/:IntermediaryContact
        /// TRT:pyde.02.00:PersonUnstructuredName.FullName.Text
        /// </summary>
        public string TRT396 = null;
    }

    public bool InT_IntermediaryContactTelephoneCollectionExists = false;
    public int InT_IntermediaryContactTelephoneCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:IntermediaryContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.Usage.Code
    /// </summary>
    public string TRT335 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:IntermediaryContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code
    /// </summary>
    public string TRT334 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:IntermediaryContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.Area.Code
    /// </summary>
    public string TRT248 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:INT/:IntermediaryContactTelephone
    /// TRT:pyde.02.00:ElectronicContact.Telephone.Minimal.Number
    /// </summary>
    public string TRT249 = null;

    }
}
