using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationIDS;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using DataContracts;
using System.Collections.Generic;

namespace Ato.CD.Inbound.TRTAMI202402
{
    public class CrossFormValidatorIDS : ICrossFormValidator
    {
        private IDS2024 childDocument { get; set; }
        
        public List<ProcessMessageDocument> response { get; private set; }

        private TRTAMI2024 parentDocument { get; set; }

        public CrossFormValidatorIDS(TRTAMI2024 parent, object child)
        {
            childDocument = (IDS2024)child;
            parentDocument = parent;
            response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOIDS440670();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.IDS.440670

        // IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
        //     RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOIDS440670()
        {
            bool assertion = !childDocument.IDS500.Equals(parentDocument.TRTAMI4);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/tns:IDS/tns:RP/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IDS.440670" } }
                });
            }
        }

        #endregion // VR.ATO.IDS.440670

        #endregion
    }
}
