using Ato.EN.IntegrationServices.CodeGenerationPSS;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using DataContracts;
using System.Collections.Generic;
using System.Linq;

namespace Ato.CD.Inbound.TRTAMI202402
{
    public class CrossFormValidatorPSS : ICrossFormValidator
    {
        private PSS2018 childDocument { get; set; }

        public List<ProcessMessageDocument> response { get; private set; }

        private TRTAMI2024 parentDocument { get; set; }

        public CrossFormValidatorPSS(TRTAMI2024 parent, object child)
        {
            childDocument = (PSS2018)child;
            parentDocument = parent;
            response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOPSS000035();
            VRATOPSS000036();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.PSS.000035

        // IF PARENT RETURN <> “IITR” AND (
        //   [PSS20] <> NULLORBLANK OR 
        //   [PSS21] <> NULLORBLANK OR 
        //   [PSS31] <> NULLORBLANK OR 
        //   [PSS24] <> NULLORBLANK OR 
        //   [PSS25] <> NULLORBLANK OR 
        //   [PSS32] <> NULLORBLANK)
        //     RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOPSS000035()
        {
            bool assertion = childDocument.RPPayerPSSeqNumContextCollection != null && childDocument
                .RPPayerPSSeqNumContextCollection.ToList().Any(p =>
                p.PSS20.HasValue || p.PSS21.HasValue || p.PSS24.HasValue ||
                p.PSS25.HasValue || p.PSS31.HasValue || p.PSS32.HasValue);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.PSS.000035",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payment Type not applicable to Non-individual income tax return",
                    Location = "/xbrli:xbrl/xbrli:context",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000035" } }
                });
            }
        }

        #endregion 

        #region VR.ATO.PSS.000036
        
        // WHERE IN CONTEXT (RP.Payer.{PSSeqNum})
        // IF (RP.Payer.{PSSeqNum}.entity.identifier.TFN <> PARENT RETURN:RP.entity.identifier.TFN)
        //     RETURN VALIDATION MESSAGE
        // END IF
        
        public void VRATOPSS000036()
        {
            bool assertion = childDocument.RPPayerPSSeqNumContextCollection != null && childDocument
                .RPPayerPSSeqNumContextCollection.ToList().Any(p => p.IdentifierTFN != parentDocument.TRTAMI4);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.PSS.000036",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000036" } }
                });
            }
        }

        #endregion

        #endregion
    }
}
