using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMIS;
using DataContracts;
using System.Collections.Generic;
using System.Linq;

namespace Ato.CD.Inbound.TRTAMI202402
{
    public class CrossFormValidatorTRTAMIS : ICrossFormValidator
    {
        private TRTAMIS2022 childDocument { get; set; }

        private List<Context> contexts { get; set; }

        public List<ProcessMessageDocument> response { get; private set; }

        private TRTAMI2024 parentDocument { get; set; }

        public CrossFormValidatorTRTAMIS(TRTAMI2024 parent, object child)
        {
            childDocument = (TRTAMIS2022)child;
            contexts = childDocument.GetContexts();
            parentDocument = parent;
            response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOGEN402009();
            VRATOGEN402010();
            VRATOGEN438000();
            VRATOGEN438001();
            VRATOTRTAMIS000001();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.GEN.402009

        // IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
        //     RETURN VALIDATION MESSAGE
        // END IF 

        public void VRATOGEN402009()
        {
            bool assertion = !parentDocument.TRTAMI4.Equals(childDocument.RPIdentifierTFN);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = "Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009" } }
                });
            }
        }

        #endregion

        #region VR.ATO.GEN.402010

        // IF (RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK)
        //   AND (PARENT RETURN:RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> NULLORBLANK)
        //   AND (RP:tns:Identifiers.AustralianBusinessNumber.Identifier <> PARENT RETURN:RP:tns:Identifiers.AustralianBusinessNumber.Identifier)
        //     RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOGEN402010()
        {
            bool assertion = !string.IsNullOrWhiteSpace(parentDocument.TRTAMI5) &&
                             !string.IsNullOrWhiteSpace(childDocument.TRTAMIS5) &&
                             !parentDocument.TRTAMI5.Equals(childDocument.TRTAMIS5);
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402010",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied ABN does not match the ABN supplied on the form it was submitted with",
                    LongDescription = "Your supplied ABN does not match the ABN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/tns:Identifiers.AustralianBusinessNumber.Identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402010" } }
                });
            }
        }

        #endregion

        #region VR.ATO.GEN.438000

        // IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
        //    RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOGEN438000()
        {
            response.AddRange(from context in contexts
                where context.StartDate.GetValueOrDefault() != parentDocument.TRTAMI2.GetValueOrDefault()
                select new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "The context period start date is incorrect.",
                    LongDescription = "Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = $"/xbrli:xbrl/xbrli:context[{context.Index}]/xbrli:period/xbrli:startDate",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } }
                });
        }

        #endregion

        #region VR.ATO.GEN.438001

        // IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
        //    RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOGEN438001()
        {
            response.AddRange(from context in contexts
                where context.EndDate.GetValueOrDefault() != parentDocument.TRTAMI3.GetValueOrDefault()
                select new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "The context period end date is incorrect.",
                    LongDescription = "Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = $"/xbrli:xbrl/xbrli:context[{context.Index}]/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } }
                });
        }

        #endregion

        #region VR.ATO.TRTAMIS.000001

        // IF [TRTAMIS4] <> NULL AND [TRTAMIS4] <> PARENT RETURN:pyin.xx.xx:Report.TargetFinancial.Year
        //     RETURN VALIDATION MESSAGE
        // END IF

        public void VRATOTRTAMIS000001()
        {
            bool assertion = childDocument.TRTAMIS4 != null && childDocument.TRTAMIS4 != parentDocument.TRTAMI1;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRTAMIS.000001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "The Target Financial Year must match the Year shown on the parent form.",
                    Location = "/xbrli:xbrl/tns:Report.TargetFinancial.Year",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRTAMIS.000001" } }
                });
            }
        }

        #endregion

        #endregion
    }
}
