﻿using Ato.EN.IntegrationServices.CodeGenerationCGTS;
using DataContracts;
using System.Collections.Generic;

using System;
using System.Linq;
using System.Text.RegularExpressions;

namespace Ato.EN.IntegrationServices.CodeGenerationIITR
{
    public partial class IITR2026CrossformValidator
    {
        /// <summary>
        /// Takes a report to validate against all CGTS rules and store the results in the response paramaeter object.
        /// </summary>
        /// <param name="report">Document to be validated with CGTS rules.</param>
        /// <param name="response">Response to add error codes to.</param>
        public static void ValidateCGTS(IITR2026Crossform report, List<ProcessMessageDocument> response)
        {
            AddProcessMessage(VR_ATO_IITR_310066(report), response);
            AddProcessMessage(VR_ATO_IITR_310069(report), response);
            AddProcessMessage(VR_ATO_IITR_310067(report), response);

            #region CGTS Child Present

            if (report.cgtsChildDocuments != null && Count(report.cgtsChildDocuments) == 1)
            {
                CGTS2018 cgtsChildDocument = report.cgtsChildDocuments[0];

                AddProcessMessage(VR_ATO_IITR_402009(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_1(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_2(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_3(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_4(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_5(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_6(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_7(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_8(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_9(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_10(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_11(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_12(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_13(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438000_14(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_1(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_2(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_3(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_4(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_5(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_6(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_7(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_8(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_9(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_10(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_11(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_12(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_13(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_14(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_15(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438001_16(report, cgtsChildDocument), response);

                AddProcessMessage(VR_ATO_IITR_438022(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438023(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438024(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438025(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438026(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_438027(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_402165(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_402226(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_402230(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_402240(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310063(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310068(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310070(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310071(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310085(report, cgtsChildDocument), response);
                AddProcessMessage(VR_ATO_IITR_310087(report, cgtsChildDocument), response);

                #region Repeating RPEarnoutArrangementGroupNumberContext

                if (cgtsChildDocument.RPEarnoutArrangementGroupNumberContextCollection != null)
                {
                    foreach (CGTS2018.RPEarnoutArrangementGroupNumberContext cgtsEarnoutArrangementGroupNumberContext in cgtsChildDocument.RPEarnoutArrangementGroupNumberContextCollection)
                    {
                        AddProcessMessage(VR_ATO_IITR_438000_75(report, cgtsEarnoutArrangementGroupNumberContext), response);
                        AddProcessMessage(VR_ATO_IITR_438001_75(report, cgtsEarnoutArrangementGroupNumberContext), response);
                    }
                }

                #endregion // Repeating RPEarnoutArrangementGroupNumberContext
            }

            #endregion // CGTS Child Present
        }

        # region VR.ATO.IITR.310066

        /* VR.ATO.IITR.310066
        When net capital gain is in excess of $10,000 a Capital Gains Tax schedule must be attached.

        Legacy Rule Format:
            (^IITR311 > 10000) AND (CountDocument('CGTS') = 0)

        Technical Business Rule Format:
                (^IITR311 > 10000) AND (CountDocument('CGTS') = 0)

        Data Elements:
    
        ^IITR311 = RP:Capital.Gains.Net.Amount
        */
        public static ProcessMessageDocument VR_ATO_IITR_310066(IITR2026Crossform report)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR311.GetValueOrDefault() > 10000 && (report.cgtsChildDocuments == null || Count(report.cgtsChildDocuments) == 0));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310066",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital Gains Tax schedule required",
                    LongDescription = @"When Net capital gain is in excess of $10,000, a Capital Gains Tax schedule must be attached",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Net.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310066" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR311", Value = report.iitrParentDocument.IITR311.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310069

        /* VR.ATO.IITR.310069
        The number of Capital Gains Tax schedules must not exceed 1.

        Legacy Rule Format:
            CountDocument('CGTS') > 1

        Technical Business Rule Format:
            CountDocument('CGTS') > 1

        Data Elements:
        */
        public static ProcessMessageDocument VR_ATO_IITR_310069(IITR2026Crossform report)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.cgtsChildDocuments != null && Count(report.cgtsChildDocuments) > 1);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310069",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The number of Capital Gains Tax schedules must not exceed 1",
                    Location = "/xbrli:xbrl/xbrli:context",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310069" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310067

        /* VR.ATO.IITR.310067
        When current year capital gains is in excess of $10,000 a Capital Gains Tax schedule must be attached.

        Legacy Rule Format:
            (^IITR312 > 10000) AND (CountDocument('CGTS') = 0)

        Technical Business Rule Format:
                (^IITR312 > 10000) AND (CountDocument('CGTS') = 0)

        Data Elements:
    
        ^IITR312 = RP:Capital.Gains.Total.Amount
        */
        public static ProcessMessageDocument VR_ATO_IITR_310067(IITR2026Crossform report)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR312.GetValueOrDefault() > 10000 && (report.cgtsChildDocuments == null || Count(report.cgtsChildDocuments) == 0));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310067",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital Gains Tax schedule required",
                    LongDescription = @"When Total current year capital gains is in excess of $10,000, a Capital Gains Tax schedule must be attached",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310067" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR312", Value = report.iitrParentDocument.IITR312.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.402009

        /* VR.ATO.GEN.402009
        Your supplied TFN does not match the TFN supplied on the form it was submitted with

        Legacy Rule Format:
        IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
        RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_402009(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPIdentifierTFN != report.iitrParentDocument.RPIdentifierTFN);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_1(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_2(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedExists && cgtsChildDocument.RPAppliedStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
        RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_3(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedY0Exists && cgtsChildDocument.RPAppliedY0StartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedY0Id + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_4(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedY0MinusExists && cgtsChildDocument.RPAppliedY0MinusStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedY0MinusId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_5(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPListedCompanySharesExists && cgtsChildDocument.RPListedCompanySharesStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPListedCompanySharesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_6(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherSharesExists && cgtsChildDocument.RPOtherSharesStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherSharesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_7(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPListedUnitTrustsExists && cgtsChildDocument.RPListedUnitTrustsStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPListedUnitTrustsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_8(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherUnitsExists && cgtsChildDocument.RPOtherUnitsStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherUnitsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_9(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAustralianRealPropertyExists && cgtsChildDocument.RPAustralianRealPropertyStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAustralianRealPropertyId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_10(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOverseasRealPropertyExists && cgtsChildDocument.RPOverseasRealPropertyStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOverseasRealPropertyId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_11(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCapitalGainsTrustDistributionsExists && cgtsChildDocument.RPCapitalGainsTrustDistributionsStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCapitalGainsTrustDistributionsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */

        public static ProcessMessageDocument VR_ATO_IITR_438000_12(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCollectablesExists && cgtsChildDocument.RPCollectablesStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCollectablesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_13(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherCapitalAssetsExists && cgtsChildDocument.RPOtherCapitalAssetsStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherCapitalAssetsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_14(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPTransfersToOtherClassesExists && cgtsChildDocument.RPTransfersToOtherClassesStartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPTransfersToOtherClassesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_1(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_2(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedExists && cgtsChildDocument.RPAppliedEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_3(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedY0Exists && cgtsChildDocument.RPAppliedY0EndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedY0Id + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_4(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAppliedY0MinusExists && cgtsChildDocument.RPAppliedY0MinusEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAppliedY0MinusId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_5(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPListedCompanySharesExists && cgtsChildDocument.RPListedCompanySharesEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPListedCompanySharesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_6(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherSharesExists && cgtsChildDocument.RPOtherSharesEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherSharesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_7(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPListedUnitTrustsExists && cgtsChildDocument.RPListedUnitTrustsEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPListedUnitTrustsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_8(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherUnitsExists && cgtsChildDocument.RPOtherUnitsEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherUnitsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_9(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPAustralianRealPropertyExists && cgtsChildDocument.RPAustralianRealPropertyEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPAustralianRealPropertyId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_10(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOverseasRealPropertyExists && cgtsChildDocument.RPOverseasRealPropertyEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOverseasRealPropertyId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_11(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCapitalGainsTrustDistributionsExists && cgtsChildDocument.RPCapitalGainsTrustDistributionsEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCapitalGainsTrustDistributionsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_12(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCollectablesExists  && cgtsChildDocument.RPCollectablesEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCollectablesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_13(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPOtherCapitalAssetsExists && cgtsChildDocument.RPOtherCapitalAssetsEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPOtherCapitalAssetsId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_14(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCollectablesUnappliedInstantInstantDate != null && cgtsChildDocument.RPCollectablesUnappliedInstantInstantDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCollectablesUnappliedInstantId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_15(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.RPCGTOtherUnappliedInstantInstantDate != null && cgtsChildDocument.RPCGTOtherUnappliedInstantInstantDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPCGTOtherUnappliedInstantId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_16(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;


            bool assertion = (cgtsChildDocument.RPTransfersToOtherClassesExists && cgtsChildDocument.RPTransfersToOtherClassesEndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsChildDocument.RPTransfersToOtherClassesId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438022

        /* VR.ATO.GEN.438022
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Small business active asset reduction (Subdivision 152-C)", then Small business active asset reduction amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'A - Small business active asset reduction') AND (CountDocument('CGTS') = 1) AND ^CGTS127 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'A - Small business active asset reduction') AND (CountDocument('CGTS') = 1) AND ^CGTS127 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS127 = CGTS127
        */
        public static ProcessMessageDocument VR_ATO_IITR_438022(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("A - Small business active asset reduction") : false) && cgtsChildDocument.CGTS127 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438022",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Small business active asset reduction amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Small business active asset reduction (Subdivision 152-C)"", then Small business active asset reduction amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438022" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS127", Value = cgtsChildDocument.CGTS127.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "A - Small business active asset reduction" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438023

        /* VR.ATO.GEN.438023
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Small business retirement exemption (Subdivision152-D)", then Small business retirement exemption amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'B - Small business retirement exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS128 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'B - Small business retirement exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS128 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS128 = CGTS128
        */
        public static ProcessMessageDocument VR_ATO_IITR_438023(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("B - Small business retirement exemption") : false) && cgtsChildDocument.CGTS128 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438023",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Small business retirement exemption amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Small business retirement exemption (Subdivision152-D)"", then Small business retirement exemption amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438023" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS128", Value = cgtsChildDocument.CGTS128.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "B - Small business retirement exemption" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438024

        /* VR.ATO.GEN.438024
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Small business roll-over (Subdivision 152-E)", then Small business roll-over amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'C - Small business roll-over') AND (CountDocument('CGTS') = 1) AND ^CGTS129 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'C - Small business roll-over') AND (CountDocument('CGTS') = 1) AND ^CGTS129 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS129 = CGTS129
        */
        public static ProcessMessageDocument VR_ATO_IITR_438024(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("C - Small business roll-over") : false) && cgtsChildDocument.CGTS129 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438024",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Small business roll-over amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Small business roll-over (Subdivision 152-E)"", then Small business roll-over amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438024" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS129", Value = cgtsChildDocument.CGTS129.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "C - Small business roll-over" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438025

        /* VR.ATO.GEN.438025
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Small business 15 year exemption (Subdivision152-B)", then Small business 15 year exemption amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'D - Small business 15 year exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS138 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'D - Small business 15 year exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS138 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS138 = CGTS138
        */
        public static ProcessMessageDocument VR_ATO_IITR_438025(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;


            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("D - Small business 15 year exemption") : false) && cgtsChildDocument.CGTS138 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438025",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Small business 15 year exemption amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Small business 15 year exemption (Subdivision152-B)"", then Small business 15 year exemption amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438025" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS138", Value = cgtsChildDocument.CGTS138.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "D - Small business 15 year exemption" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438026

        /* VR.ATO.GEN.438026
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Foreign resident CGT exemption (Division 855)", then Capital gains disregarded by a foreign resident amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'E - Foreign resident CGT exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS140 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'E - Foreign resident CGT exemption') AND (CountDocument('CGTS') = 1) AND ^CGTS140 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS140 = CGTS140
        */
        public static ProcessMessageDocument VR_ATO_IITR_438026(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("E - Foreign resident CGT exemption") : false) && cgtsChildDocument.CGTS140 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438026",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital gains disregarded by a foreign resident amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Foreign resident CGT exemption (Division 855)"", then Capital gains disregarded by a foreign resident amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438026" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS140", Value = cgtsChildDocument.CGTS140.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "E - Foreign resident CGT exemption" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438027

        /* VR.ATO.GEN.438027
        If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is "Scrip for scrip roll-over (Subdivision 124-M)", then Capital gains disregarded as a result of a scrip for scrip roll-over amount on attached CGT schedule must be completed.

        Legacy Rule Format:
            (^IITR310 = 'F - Scrip for scrip roll-over') AND (CountDocument('CGTS') = 1) AND ^CGTS45 = NULL

        Technical Business Rule Format:
            (^IITR310 = 'F - Scrip for scrip roll-over') AND (CountDocument('CGTS') = 1) AND ^CGTS45 = NULL

        Data Elements:
    
        ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
    
        ^CGTS45 = CGTS45
        */
        public static ProcessMessageDocument VR_ATO_IITR_438027(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.iitrParentDocument.IITR310Collection != null ? report.iitrParentDocument.IITR310Collection.Contains("F - Scrip for scrip roll-over") : false) && cgtsChildDocument.CGTS45 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438027",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Capital gains disregarded as a result of a scrip for scrip roll-over amount missing from CGT schedule",
                    LongDescription = @"If taxpayer is required to lodge a CGT schedule and CGT exemption or rollover applied code is ""Scrip for scrip roll-over (Subdivision 124-M)"", then Capital gains disregarded as a result of a scrip for scrip roll-over amount on attached CGT schedule must be completed",
                    Location = "/xbrli:xbrl/tns:CapitalGainsTax.ExemptionOrRolloverApplied.Code[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438027" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS45", Value = cgtsChildDocument.CGTS45.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR310", Value = "F - Scrip for scrip roll-over" });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.402165

        /* VR.ATO.CGTS.402165
        Total losses transferred in applied is only valid for a company

        Legacy Rule Format:
        IF (PARENT RETURN <> "CTR") AND ([CGTS122] <> NULL)  
            RETURN VALIDATION MESSAGE
        ENDIF

        Data Elements:
        CGTS:RP.Applied:^CGTS122 = tns:Capital.Losses.TransferredTotal.Amount
        */
        public static ProcessMessageDocument VR_ATO_IITR_402165(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.CGTS122 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGTS.402165",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total losses transferred in applied is only valid for a company",
                    Location = "/xbrli:xbrl/tns:Capital.Losses.TransferredTotal.Amount[@contextRef='" + cgtsChildDocument.RPAppliedId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGTS.402165" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS122", Value = cgtsChildDocument.CGTS122.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.402226

        /* VR.ATO.CGTS.402226
        If the Amendment indicator on a parent return is set to TRUE, then the Income year earnout right created and Amount to be amended cannot be supplied.

        Legacy Rule Format:
        IF (PARENT RETURN:RP:pyin.xx.xx:Report.Amendment.Indicator = TRUE) AND ([CGTS150] <> NULL AND [CGTS151] <> NULL)
            RETURN VALIDATION MESSAGE
        ENDIF

        Data Elements:
        CGTS:RP.{EarnoutArrangementGroupNumber}:^CGTS150 = tns:Report.TargetFinancial.Year
        CGTS:RP.{EarnoutArrangementGroupNumber}:^CGTS151 = tns:Miscellaneous.RequestedAmendment.Amount
        IITR:RP:^IITR16                                  = tns:Report.Amendment.Indicator
        */
        public static ProcessMessageDocument VR_ATO_IITR_402226(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR16.GetValueOrDefault() && cgtsChildDocument.CGTS150 != null && cgtsChildDocument.CGTS151 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGTS.402226",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income year earnout right created and Amount to be amended cannot be supplied when Parent return Amendment indicator is present.",
                    Location = "/xbrli:xbrl/tns:Report.TargetFinancial.Year[@contextRef='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGTS.402226" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS150", Value = cgtsChildDocument.CGTS150.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS151", Value = cgtsChildDocument.CGTS151.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR16", Value = report.iitrParentDocument.IITR16.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.402230

        /* VR.ATO.CGTS.402230
        A multi-class treatment can only be reported with a Trust Tax Return for Attribution Managed Investments (TRTAMI) when a multi-class election has been made

        Legacy Rule Format:
        IF PARENT RETURN  <> "TRTAMI" AND ([CGTS153] <> NULL OR [CGTS154] <> NULL OR [CGTS155] <> NULL)
            RETURN VALIDATION MESSAGE
        ENDIF

        Data Elements:
        CGTS:RP:^CGTS153                         = tns:IncomeTax.AttributionManagedInvestmentTrustClass.Description
        CGTS:RP.TransfersToOtherClasses:^CGTS154 = tns:Capital.Gains.Total.Amount
        CGTS:RP.TransfersToOtherClasses:^CGTS155 = tns:Capital.Losses.Total.Amount
        */
        public static ProcessMessageDocument VR_ATO_IITR_402230(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.CGTS153 != null || cgtsChildDocument.CGTS154 != null || cgtsChildDocument.CGTS155 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGTS.402230",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Multi-class treatment fields incorrectly supplied",
                    Location = "/xbrli:xbrl/tns:IncomeTax.AttributionManagedInvestmentTrustClass.Description[@contextRef='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGTS.402230" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS153", Value = cgtsChildDocument.CGTS153 });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS154", Value = cgtsChildDocument.CGTS154.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS155", Value = cgtsChildDocument.CGTS155.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.402240

        /* VR.ATO.CGTS.402240
        The year entered at Income year earnout right created cannot be the current year.

        Legacy Rule Format:
        IF ([CGTS150] <> NULL) AND ([CGTS150] = (PARENT RETURN:RP:pyin.xx.xx:Report.TargetFinancial.Year))
            RETURN VALIDATION MESSAGE
        ENDIF

        Data Elements:
        CGTS:RP.{EarnoutArrangementGroupNumber}:^CGTS150 = tns:Report.TargetFinancial.Year
        IITR:RP:^IITR10                                  = tns:Report.TargetFinancial.Year
        */
        public static ProcessMessageDocument VR_ATO_IITR_402240(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;


            bool assertion = (cgtsChildDocument.CGTS150 != null && cgtsChildDocument.CGTS150 == report.iitrParentDocument.IITR10);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CGTS.402240",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income year earnout right created incorrect",
                    LongDescription = @"The year entered at Income year earnout right created cannot be the current year.",
                    Location = "/xbrli:xbrl/tns:Report.TargetFinancial.Year[@contextRef='" + cgtsChildDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CGTS.402240" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS150", Value = cgtsChildDocument.CGTS150.ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR10", Value = report.iitrParentDocument.IITR10.ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310063

        /* VR.ATO.IITR.310063
        For an attached Capital Gains Tax schedule, if Net capital gain is greater than zero, there cannot be an amount at Other net capital losses carried forward to later income years.

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND (^CGTS125 > 0) AND (^CGTS131 > 0)

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND (^CGTS125 > 0) AND (^CGTS131 > 0)

        Data Elements:
    
        ^CGTS125 = CGTS125
    
        ^CGTS131 = CGTS131
        */
        public static ProcessMessageDocument VR_ATO_IITR_310063(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsChildDocument.CGTS125.GetValueOrDefault() > 0 && cgtsChildDocument.CGTS131.GetValueOrDefault() > 0);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310063",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Other net capital losses carried forward to later income years on CGTS schedule is invalid",
                    LongDescription = @"For an attached Capital Gains Tax (CGTS) schedule, when a 'Net capital gain' amount above zero is provided, 'Other net capital losses carried forward to later income years' must be zero or not provided",
                    Location = "/xbrli:xbrl/xbrli:context",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310063" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS125", Value = cgtsChildDocument.CGTS125.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS131", Value = cgtsChildDocument.CGTS131.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310068

        /* VR.ATO.IITR.310068
        The total current year capital gains on the Capital Gains Tax schedule must be equal to the total current year capital gains on the Individual return.

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR312 <> ^CGTS118)

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR312 <> ^CGTS118)

        Data Elements:
    
        ^IITR312 = RP:Capital.Gains.Total.Amount
    
        ^CGTS118 = CGTS118
        */
        public static ProcessMessageDocument VR_ATO_IITR_310068(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR312.GetValueOrDefault() != cgtsChildDocument.CGTS118.GetValueOrDefault());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310068",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total current year capital gains amount invalid",
                    LongDescription = @"The Total current year capital gains on the Capital Gains Tax schedule must be equal to the Total current year capital gains on the Individual return",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Total.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310068" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS118", Value = cgtsChildDocument.CGTS118.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR312", Value = report.iitrParentDocument.IITR312.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310070

        /* VR.ATO.IITR.310070
        The sum of unapplied net capital losses carried forward on the Capital Gains Tax schedule must equal net capital losses carried forward on the main income tax return.

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR313 <> ^CGTS124 + ^CGTS125)

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR313 <> ^CGTS124 + ^CGTS125)

        Data Elements:
    
        ^IITR313 = RP(Instant):Capital.Losses.CarriedForward.Net.Amount
    
        ^CGTS124 = CGTS124
    
        ^CGTS125 = CGTS125
        */
        public static ProcessMessageDocument VR_ATO_IITR_310070(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR313.GetValueOrDefault() != (cgtsChildDocument.CGTS124.GetValueOrDefault() + cgtsChildDocument.CGTS125.GetValueOrDefault()));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310070",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net capital losses carried forward incorrect",
                    LongDescription = @"The sum of unapplied net capital losses carried forward on the Capital Gains Tax schedule must equal Net capital losses carried forward to later income years on the main income tax return",
                    Location = "/xbrli:xbrl/tns:Capital.Losses.CarriedForward.Net.Amount[@contextRef='" + report.iitrParentDocument.RPInstantId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310070" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS124", Value = cgtsChildDocument.CGTS124.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS125", Value = cgtsChildDocument.CGTS125.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR313", Value = report.iitrParentDocument.IITR313.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310071

        /* VR.ATO.IITR.310071
        The net capital gain amount on the main return form must equal the net capital gain amount on the Capital Gains Tax schedule.

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR311 <> ^CGTS131)

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND (^IITR311 <> ^CGTS131)

        Data Elements:
    
        ^IITR311 = RP:Capital.Gains.Net.Amount
    
        ^CGTS131 = CGTS131
        */
        public static ProcessMessageDocument VR_ATO_IITR_310071(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.iitrParentDocument.IITR311.GetValueOrDefault() != cgtsChildDocument.CGTS131.GetValueOrDefault());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310071",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Net capital gain amount in return incorrect",
                    LongDescription = @"The Net capital gain amount on the main return form must equal the Net capital gain amount on the Capital Gains Tax schedule",
                    Location = "/xbrli:xbrl/tns:Capital.Gains.Net.Amount[@contextRef='" + report.iitrParentDocument.RPId + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310071" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS131", Value = cgtsChildDocument.CGTS131.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "IITR311", Value = report.iitrParentDocument.IITR311.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.310085

        /* VR.ATO.IITR.310085
            When the Real estate situated in Australia - capital gains amount and Amount of capital gains from a trust (including a managed fund) are not provided or zero; or Applied exemption, rollover or additional discount code of "W - Affordable housing discount" is not being claimed; the Total CGT discount applied must not exceed 50% of the Total current year capital gains less Total capital losses applied

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND (((^CGTS103 = NULL OR ^CGTS103 = 0) AND (^CGTS113 = NULL OR ^CGTS113 = 0)) OR (CountOccurrence(^IITR310, ^IITR310 = 'W - Affordable housing discount') = 0)) AND (^CGTS126 > (((^CGTS118 - ^CGTS123) * 0.5) + 1))

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND (((^CGTS103 = NULL OR ^CGTS103 = 0) AND (^CGTS113 = NULL OR ^CGTS113 = 0)) OR (CountOccurrence(^IITR310, ^IITR310 = 'W - Affordable housing discount') = 0)) AND (^CGTS126 > (((^CGTS118 - ^CGTS123) * 0.5) + 1))

        Data Elements:
    
            ^CGTS103 = CGTS103
    
            ^CGTS113 = CGTS113
    
            ^CGTS118 = CGTS118
    
            ^CGTS123 = CGTS123
    
            ^CGTS126 = CGTS126
    
            ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
        */

        public static ProcessMessageDocument VR_ATO_IITR_310085(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool CGTS103NotProvidedOrZero = cgtsChildDocument.CGTS103.GetValueOrDefault() == 0;
            bool CGTS113NotProvidedOrZero = cgtsChildDocument.CGTS113.GetValueOrDefault() == 0;
            bool IITR310WhenConditionsMet = (report.IITR.IITR310Collection?.Count(IITR310Repeat => IITR310Repeat == @"W - Affordable housing discount")).GetValueOrDefault() == 0;
            bool CGTS126GreaterThanSum = cgtsChildDocument.CGTS126.GetValueOrDefault() > (((cgtsChildDocument.CGTS118.GetValueOrDefault() - cgtsChildDocument.CGTS123.GetValueOrDefault()) * 0.5m) + 1);

            bool assertion = ((CGTS103NotProvidedOrZero && CGTS113NotProvidedOrZero) || IITR310WhenConditionsMet) && CGTS126GreaterThanSum;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.311085",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total CGT discount applied amount is incorrect",
                    LongDescription = @"When the Real estate situated in Australia - capital gains amount and Amount of capital gains from a trust (including a managed fund) are not provided or zero; or Applied exemption, rollover or additional discount code of ""W - Affordable housing discount"" is not being claimed; the Total CGT discount applied must not exceed 50% of the Total current year capital gains less Total capital losses applied",
                    Location = "/xbrli:xbrl/xbrli:context",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310085" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS103", Value = cgtsChildDocument.CGTS103.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS113", Value = cgtsChildDocument.CGTS113.GetValueOrDefault().ToString() });
                if (report.IITR.IITR310Collection != null)
                {
                    foreach (string IITR310 in report.IITR.IITR310Collection)
                    {
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "IITR310", Value = GetValueOrEmpty(IITR310) });
                    }
                }
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS118", Value = cgtsChildDocument.CGTS118.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS123", Value = cgtsChildDocument.CGTS123.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS126", Value = cgtsChildDocument.CGTS126.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.310085

        #region VR.ATO.IITR.310087

        /* VR.ATO.IITR.310087
            When a positive amount is provided for the Real estate situated in Australia - capital gains, or Amount of capital gains from a trust(including a managed fund); and Applied exemption, rollover or additional discount code of "W - Affordable housing discount" is being claimed; the Total CGT discount applied must not exceed 60% of the Total current year capital gains less Total capital losses applied

        Legacy Rule Format:
            (CountDocument('CGTS') = 1) AND(^CGTS103 > 0 OR ^CGTS113 > 0) AND AnyOccurrence(^IITR310, ^IITR310 = 'W - Affordable housing discount') AND(^CGTS126 > (((^CGTS118 - ^CGTS123) * 0.6) + 1))

        Technical Business Rule Format:
            (CountDocument('CGTS') = 1) AND(^CGTS103 > 0 OR ^CGTS113 > 0) AND AnyOccurrence(^IITR310, ^IITR310 = 'W - Affordable housing discount') AND(^CGTS126 > (((^CGTS118 - ^CGTS123) * 0.6) + 1))

        Data Elements:
    
            ^CGTS103 = CGTS103
    
            ^CGTS113 = CGTS113
    
            ^CGTS118 = CGTS118
    
            ^CGTS123 = CGTS123
    
            ^CGTS126 = CGTS126
    
            ^IITR310 = RP:CapitalGainsTax.ExemptionOrRolloverApplied.Code
        */

        public static ProcessMessageDocument VR_ATO_IITR_310087(IITR2026Crossform report, CGTS2018 cgtsChildDocument)
        {
            ProcessMessageDocument processMessage = null;

            bool CGTS103IsGreaterThan0 = cgtsChildDocument.CGTS103.GetValueOrDefault() > 0;
            bool CGTS113IsGreaterThan0 = cgtsChildDocument.CGTS113.GetValueOrDefault() > 0;
            bool IITR310WhenConditionsMet = report.IITR.IITR310Collection?.Any(IITR310Repeat => IITR310Repeat == @"W - Affordable housing discount") ?? false;
            bool CGTS126GreaterThanSum = cgtsChildDocument.CGTS126.GetValueOrDefault() > (((cgtsChildDocument.CGTS118.GetValueOrDefault() - cgtsChildDocument.CGTS123.GetValueOrDefault()) * 0.6m) + 1);

            bool assertion = (CGTS103IsGreaterThan0 || CGTS113IsGreaterThan0) && IITR310WhenConditionsMet && CGTS126GreaterThanSum;
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.IITR.310087",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Total CGT discount applied amount is incorrect",
                    LongDescription = @"When a positive amount is provided for the Real estate situated in Australia - capital gains, or Amount of capital gains from a trust (including a managed fund); and Applied exemption, rollover or additional discount code of ""W - Affordable housing discount"" is being claimed; the Total CGT discount applied must not exceed 60% of the Total current year capital gains less Total capital losses applied",
                    Location = "/xbrli:xbrl/xbrli:context",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IITR.310087" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS103", Value = cgtsChildDocument.CGTS103.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS113", Value = cgtsChildDocument.CGTS113.GetValueOrDefault().ToString() });
                if (report.IITR.IITR310Collection != null)
                {
                    foreach (string IITR310 in report.IITR.IITR310Collection)
                    {
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "IITR310", Value = GetValueOrEmpty(IITR310) });
                    }
                }
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS118", Value = cgtsChildDocument.CGTS118.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS123", Value = cgtsChildDocument.CGTS123.GetValueOrDefault().ToString() });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CGTS126", Value = cgtsChildDocument.CGTS126.GetValueOrDefault().ToString() });
            }

            return processMessage;
        }

        #endregion VR.ATO.IITR.310087

        #region VR.ATO.IITR.438000

        /* VR.ATO.GEN.438000
        Period start date within context on schedule doesn't match start date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.startDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.startDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438000_75(IITR2026Crossform report, CGTS2018.RPEarnoutArrangementGroupNumberContext cgtsEarnoutArrangementGroupNumberContext)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsEarnoutArrangementGroupNumberContext.StartDate != report.iitrParentDocument.RPStartDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438000",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period start date is incorrect.",
                    LongDescription = @"Period start date within context on the schedule must match period start date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsEarnoutArrangementGroupNumberContext.Id + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438000" } },
                };
            }

            return processMessage;
        }

        #endregion

        #region VR.ATO.IITR.438001

        /* VR.ATO.GEN.438001
        Period end date within context on schedule doesn't match end date within PARENT RETURN:reporting party context

        Legacy Rule Format:
        IF (period.endDate WHERE CONTEXT(ALL)) <> PARENT RETURN:RP:period.endDate
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        public static ProcessMessageDocument VR_ATO_IITR_438001_75(IITR2026Crossform report, CGTS2018.RPEarnoutArrangementGroupNumberContext cgtsEarnoutArrangementGroupNumberContext)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (cgtsEarnoutArrangementGroupNumberContext.EndDate != report.iitrParentDocument.RPEndDate);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.438001",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The context period end date is incorrect.",
                    LongDescription = @"Period end date within context on the schedule must match period end date within the parent return reporting party context",
                    Location = "/xbrli:xbrl/xbrli:context[@id='" + cgtsEarnoutArrangementGroupNumberContext.Id + "']",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.GEN.438001" } },
                };
            }

            return processMessage;
        }

        #endregion
    }
}