﻿using System.Collections.Generic;
using Ato.EN.IntegrationServices.CodeGenerationCGTS;
using Ato.EN.IntegrationServices.CodeGenerationDDCTNS;
using Ato.EN.IntegrationServices.CodeGenerationINCDTLS;
using Ato.EN.IntegrationServices.CodeGenerationNRFI;
using Ato.EN.IntegrationServices.CodeGenerationRNTLPRPTY;

namespace Ato.EN.IntegrationServices.CodeGenerationIITR
{
    public class IITR2026Crossform
    {
        #region Entities

        // Create Variables to store the Consumed Entity objects. 
        // These are required to be lists so that we can validate the cardinality in the event that more than one schedule is submitted.

        // IITR Parent Document
        public IITR2026 iitrParentDocument = null;

        // CGTS Child Documents
        public List<CGTS2018> cgtsChildDocuments = null;

        // DDCTNS Child Documents
        public List<DDCTNS2026> ddctnsChildDocuments = null;

        // INCDTLS Child Documents
        public List<INCDTLS2026> incdtlsChildDocuments = null;

        // NRFI Child Documents
        public List<NRFI2024> nrfiChildDocuments = null;

        // RNTLPRPTY Child Documents
        public List<RNTLPRPTY2019> rntlprptyChildDocuments = null;

        #endregion Entities

        #region Entity Accessor Properties

        // Simplifies the code that uses the crossform Entity so that it does not have to access an array.

        // IITR
        public IITR2026 IITR
        {
            get { return iitrParentDocument; }
        }

        // CGTS
        public CGTS2018 CGTS
        {
            get { return cgtsChildDocuments?[0]; }
        }

        // DDCTNS
        public DDCTNS2026 DDCTNS
        {
            get { return ddctnsChildDocuments?[0]; }
        }

        // INCDTLS
        public INCDTLS2026 INCDTLS
        {
            get { return incdtlsChildDocuments?[0]; }
        }

        // NRFI
        public NRFI2024 NRFI
        {
            get { return nrfiChildDocuments?[0]; }
        }

        // RNTLPRPTY
        public RNTLPRPTY2019 RNTLPRPTY
        {
            get { return rntlprptyChildDocuments?[0]; }
        }

        #endregion Entity Accessor Properties

        #region Constructors

        public IITR2026Crossform()
        {
            // Blank constructor to support construction of object when there is an unknown number of reports.
        }

        /// <summary>
        /// Setup the Child documents with their respective entity objects.
        /// </summary>
        /// <param name="IITR2026">Consumed IITR2026 entity object - This should always be provided.</param>
        /// <param name="ddctns2026">Consumed DDCTNS2026 entity object</param>
        /// <param name="incdtls2026">Consumed INCDTLS2026 entity object</param>
        /// <param name="rntlprpty2019">Consumed RNTLPRPTY2019 entity object</param>
        /// <param name="cgts2018">Consumed CGTS2018 entity object</param>
        /// <param name="nrfi2024">Consumed NRFI entity object</param>
        public IITR2026Crossform(IITR2026 IITR2026, DDCTNS2026 ddctns2026 = null, INCDTLS2026 incdtls2026 = null, RNTLPRPTY2019 rntlprpty2019 = null, CGTS2018 cgts2018 = null, NRFI2024 nrfi2024 = null)
        {
            // Set the IITR Parent Document (This will always be provided)
            iitrParentDocument = IITR2026;

            if (ddctns2026 != null)
            {
                ddctnsChildDocuments = new List<DDCTNS2026>()
                {
                    ddctns2026
                };
            }

            if (incdtls2026 != null)
            {
                incdtlsChildDocuments = new List<INCDTLS2026>()
                {
                    incdtls2026
                };
            }

            if (rntlprpty2019 != null)
            {
                rntlprptyChildDocuments = new List<RNTLPRPTY2019>()
                {
                    rntlprpty2019
                };
            }

            if (cgts2018 != null)
            {
                cgtsChildDocuments = new List<CGTS2018>()
                {
                    cgts2018
                };
            }

            if (nrfi2024 != null)
            {
                nrfiChildDocuments = new List<NRFI2024>()
                {
                    nrfi2024
                };
            }
        }

        #endregion Constructors

    }
}