﻿using System.Linq;
using System.Collections.Generic;
using DataContracts;

namespace Ato.EN.IntegrationServices.CodeGenerationNRFI
{
    public partial class NRFI2024Validator
    {
        #region VR.ATO.NRFI.100018

        public void VRATONRFI100018(List<ProcessMessageDocument> response, NRFI2024 report)
        {
            /*  VR.ATO.NRFI.100018
            Foreign tax return period must be exactly one year when the Foreign income assessment method is "Overseas"

            Legacy Rule Format:
            IF [NRFI8] <> NULL AND [NRFI9] <> NULL AND [NRFI9] <> ConvertToDate(Day([NRFI8]) - 1, MonthAsInt([NRFI8]), Year([NRFI8]) + 1)
                RETURN VALIDATION MESSAGE
            ENDIF

            Technical Business Rule Format:
            ^NRFI8 <> NULL AND ^NRFI9 <> NULL AND ^NRFI9 <> ConvertToDate(Day(^NRFI8) - 1, MonthAsInt(^NRFI8), Year(^NRFI8) + 1)

            Data Elements:

            ^NRFI9 = RP:Period.End.Date

            ^NRFI8 = RP:Period.Start.Date
            */
            bool assertion = (report.NRFI8 != null && report.NRFI9 != null && report.NRFI9.GetValueOrDefault() != report.NRFI8.GetValueOrDefault().AddDays(-1).AddYears(1));

            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.NRFI.100018",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Foreign tax return period must be exactly one year when the Foreign income assessment method is ""Overseas""",
                    Location = "/xbrli:xbrl/tns:Period.End.Date",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.NRFI.100018" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "NRFI8", Value = GetValueOrEmptyDate(report.NRFI8) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "NRFI9", Value = GetValueOrEmptyDate(report.NRFI9) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.NRFI.100018
    }
}