using System;
using System.Collections.Generic;
using Au.Gov.Sbr.Xbrl.Document;
using Au.Gov.Sbr.Xbrl.Metadata;
using System.Linq;
using System.Xml;
using System.Text.RegularExpressions;
using DataContracts;

namespace Ato.EN.IntegrationServices.CodeGenerationRNTLPRPTY
{
    public class RNTLPRPTY2019Consumer
    {

        private static Regex StripWhitespace = new Regex(@"\s*");

        #region Helper/Validation Methods
        private static bool? ToBoolean(string str)
        {
            bool returnValue;
            string value = (str ?? "").Trim();
            if (value == "0" || value == "1")
                return Convert.ToBoolean(Convert.ToInt32(value));

            if (Boolean.TryParse(value, out returnValue))
                return returnValue;
            return null;
        }

        private static string GetValueOrEmpty(bool? val)
        {
            return (val.HasValue) ? val.ToString().ToLower() : string.Empty;
        }

        private static string GetValueOrEmpty(DateTime? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        private static string GetValueOrEmpty(string val)
        {
            return !string.IsNullOrWhiteSpace(val) ? val : string.Empty;
        }

        private static string GetValueOrEmpty(decimal? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        private static string GetValueOrEmpty(int? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        /// <summary>
        /// Derives the SBR element location.
        /// </summary>
        /// <param name="sbrElement">The SBR element.</param>
        /// <param name="addOccurrenceIndex">if set to <c>true</c> [add occurrence the occurrence index to the path].</param>
        /// <returns></returns>
        private static string DeriveSbrElementLocation(SBRElement sbrElement, bool addOccurrenceIndex = false)
        {
            if (sbrElement == null) return "/xbrli:xbrl";
            int xpathOccurrence = sbrElement.OccurrenceIndex + 1;
            string location;

            if (addOccurrenceIndex)
            {
                location = "/" + sbrElement.NamespacePrefix + ":" + sbrElement.Name + "[" +
                           xpathOccurrence + "]";
            }
            else
            {
                location = "/" + sbrElement.NamespacePrefix + ":" + sbrElement.Name;
            }

            if (sbrElement.IsInTuple)
            {
                location = DeriveSbrElementLocation(sbrElement.ParentTuple, true) + location;
            }
            else
            {
                location = "/xbrli:xbrl" + location;
            }

            return location;
        }

        private static bool IsMatch(int? field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(Convert.ToString(field.Value), expression, options);
        }

        private static bool IsMatch(string field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(field, expression, options);
        }

        public DateTime AsDate(string dateAsString)
        {
            DateTime response = DateTime.MinValue;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date;
            }

            return response;
        }

        #endregion

        public RNTLPRPTY2019 Consume(SBRDocument sbrDocument)
        {
            List<ProcessMessageDocument> errors;
            return Consume(sbrDocument, false, out errors);
        }

        /// <summary>
        /// Allows for validation of rules that can not be generated and must run at a lower level.
        /// A sub-class will need to be created with an override for this method - which does nothing in its base implementation.
        /// </summary>
        /// <param name="sbrDocument">The SBR document.</param>
        /// <param name="populatedReportElementsMap">The populated report elements map can be used to find data elements and tuples.</param>
        /// <param name="contextArray">The context array can be used to find context values.</param>
        /// <param name="errors">The errors collection is to be populated with validation results.</param>
        protected virtual void ValidateUnsupportedRules(SBRDocument sbrDocument, IDictionary<string, SBRElement> populatedReportElementsMap, SBRContext[] contextArray, List<ProcessMessageDocument> errors)
        {

        }

        public RNTLPRPTY2019 Consume(SBRDocument sbrDocument, bool validationMode, out List<ProcessMessageDocument> errors)
        {
            RNTLPRPTY2019 report;
            report = new RNTLPRPTY2019();
            errors = new List<ProcessMessageDocument>();

            SBRContext[] contextArray;
            IDictionary<string, SBRElement> populatedReportElementsMap;

            contextArray = sbrDocument.ContextsMap.Values.ToArray();
            populatedReportElementsMap = sbrDocument.PopulatedChildElementsMap ?? new Dictionary<string, SBRElement>();

            if (validationMode) ValidateUnsupportedRules(sbrDocument, populatedReportElementsMap, contextArray, errors);

            /// <summary>
            /// Current element being extracted
            /// </summary>
            SBRElement currentValue = null;
            /// <summary>
            /// Current elements being extracted
            /// </summary>
            IList<SBRElement> currentValues = null;
            /// <summary>
            /// Current occurrences being extracted
            /// </summary>
            IList<SBRElement> currentOccurrences = null;
            /// <summary>
            /// Working Variable for date time variables
            /// </summary>
            DateTime currentDateTimeValue;
            /// <summary>
            /// Working Variable for boolean variables
            /// </summary>
            bool currentBooleanValue;
            /// <summary>
            /// Working Variable for decimal variables
            /// </summary>
            decimal currentDecimalValue;
            /// <summary>
            /// Working Variable for integer variables
            /// </summary>
            int currentIntValue;
            /// <summary>
            /// Working Variable for long variables
            /// </summary>
            long currentLongValue;
            XmlDocumentFragment currentSegment;
            XmlNamespaceManager currentNamespaceManager;
            XmlNode currentNode;

            #region sbrRPPrptySeqNumContext
            IEnumerable<SBRContext> sbrRPPrptySeqNumContexts = null;
            SBRContext sbrRPPrptySeqNumContext = null;

            sbrRPPrptySeqNumContexts = contextArray.Where(
                c => c.Period != null && c.Period.PeriodType == SBRPeriod_PeriodType.DURATION &&
                c.Segment != null && c.Segment.ExplicitOrTypedDimensionDomains.Count == 2 &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}ReportPartyTypeDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}ReportingParty")) &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.TYPED && dd.Dimension.EndsWith("}RentalPropertyFinancialDetailsSequenceDimension")))));
            Dictionary<string, IList<SBRElement>> sbrPopulatedRPPrptySeqNumElementsMap = new Dictionary<string, IList<SBRElement>>();
            if (sbrRPPrptySeqNumContexts != null && sbrRPPrptySeqNumContexts.Count() > 0)
            {

                report.RPPrptySeqNumContextCollection = new List<RNTLPRPTY2019.RPPrptySeqNumContext>();
                for (int i = 0; i < sbrRPPrptySeqNumContexts.Count(); i++)
                {
                    sbrRPPrptySeqNumContext = sbrRPPrptySeqNumContexts.ElementAt(i);
                    RNTLPRPTY2019.RPPrptySeqNumContext rpPrptySeqNumContext = new RNTLPRPTY2019.RPPrptySeqNumContext();
                    report.RPPrptySeqNumContextCollection.Add(rpPrptySeqNumContext);

                    rpPrptySeqNumContext.Id = sbrRPPrptySeqNumContext.Id;
                    rpPrptySeqNumContext.Identifier = sbrRPPrptySeqNumContext.EntityIdentifier;
                    rpPrptySeqNumContext.IdentifierScheme = sbrRPPrptySeqNumContext.EntityScheme;

                    rpPrptySeqNumContext.Count = sbrRPPrptySeqNumContexts.Count();
                    rpPrptySeqNumContext.Exists = true;
                    rpPrptySeqNumContext.OccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumContext) + 1;
                    rpPrptySeqNumContext.LastOccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumContexts.Last()) + 1;


                    if (rpPrptySeqNumContext.IdentifierScheme == "http://www.ato.gov.au/tfn") rpPrptySeqNumContext.IdentifierTFN = rpPrptySeqNumContext.Identifier;

                    rpPrptySeqNumContext.StartDate = ((SBRDurationPeriod)sbrRPPrptySeqNumContext.Period).DurationStartAsDateObject;
                    rpPrptySeqNumContext.EndDate = ((SBRDurationPeriod)sbrRPPrptySeqNumContext.Period).DurationEndAsDateObject;

                    currentSegment = sbrRPPrptySeqNumContext.Segment.Segment;

                    currentNamespaceManager = new XmlNamespaceManager(currentSegment.OwnerDocument.NameTable);
                    currentNamespaceManager.AddNamespace("xbrldi", "http://xbrl.org/2006/xbrldi");

                    currentNode = currentSegment.SelectSingleNode("xbrldi:typedMember[contains(@dimension, 'RentalPropertyFinancialDetailsSequenceDimension')]", currentNamespaceManager);

                    if (currentNode != null)
                    {
                        rpPrptySeqNumContext.RentalPropertyFinancialDetailsSequenceDimensionValue = currentNode.InnerText.Trim();
                    }

                    sbrPopulatedRPPrptySeqNumElementsMap = new System.Collections.Generic.Dictionary<string, IList<SBRElement>>();

                    IList<SBRElement> elements = sbrDocument.ElementsByContextId[sbrRPPrptySeqNumContext.Id];
                    if (elements != null)
                    {
                        for (int e = 0; e < elements.Count(); e++)
                        {
                            SBRElement currentElement = elements[e];
                            if (currentElement == null) continue; // Don't add tuple elements here, they will be found through a different map.
                            if (sbrPopulatedRPPrptySeqNumElementsMap.ContainsKey("{" + currentElement.Namespace + "}" + currentElement.Name))
                            {
                                sbrPopulatedRPPrptySeqNumElementsMap["{" + currentElement.Namespace + "}" + currentElement.Name].Add(currentElement);
                            }
                            else
                            {
                                sbrPopulatedRPPrptySeqNumElementsMap.Add("{" + currentElement.Namespace + "}" + currentElement.Name, new List<SBRElement> { currentElement });
                            }
                        }
                    }
                    rpPrptySeqNumContext.RNTLPRPTY100 = rpPrptySeqNumContext.StartDate;
                    rpPrptySeqNumContext.RNTLPRPTY101 = rpPrptySeqNumContext.EndDate;
                    rpPrptySeqNumContext.RNTLPRPTY102 = rpPrptySeqNumContext.Identifier;
                    rpPrptySeqNumContext.RNTLPRPTY103 = rpPrptySeqNumContext.RentalPropertyFinancialDetailsSequenceDimensionValue;

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.SiteName.Text", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY107 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.Line1.Text", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY108 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.Line2.Text", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY109 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.LocalityName.Text", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY110 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.StateOrTerritory.Code", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY111 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}AddressDetails.Postcode.Text", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY112 = currentValues[0].Value;
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}RealEstateProperty.Ownership.Percent", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY104 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}RealEstateProperty.RentalIncomeFirstEarned.Date", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY105 = DateTime.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}RealEstateProperty.RentalWeeks.Count", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumContext.RNTLPRPTY106 = decimal.Parse(currentValues[0].Value);
                    }
                }
            }
            #endregion End of Context sbrRPPrptySeqNumContext

            #region sbrRPPrptySeqNumTotalContext
            IEnumerable<SBRContext> sbrRPPrptySeqNumTotalContexts = null;
            SBRContext sbrRPPrptySeqNumTotalContext = null;

            sbrRPPrptySeqNumTotalContexts = contextArray.Where(
                c => c.Period != null && c.Period.PeriodType == SBRPeriod_PeriodType.DURATION &&
                c.Segment != null && c.Segment.ExplicitOrTypedDimensionDomains.Count == 3 &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}ReportPartyTypeDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}ReportingParty")) &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.TYPED && dd.Dimension.EndsWith("}RentalPropertyFinancialDetailsSequenceDimension")) &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}RentalPropertyShareDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}Total"))))));
            Dictionary<string, IList<SBRElement>> sbrPopulatedRPPrptySeqNumTotalElementsMap = new Dictionary<string, IList<SBRElement>>();
            if (sbrRPPrptySeqNumTotalContexts != null && sbrRPPrptySeqNumTotalContexts.Count() > 0)
            {

                report.RPPrptySeqNumTotalContextCollection = new List<RNTLPRPTY2019.RPPrptySeqNumTotalContext>();
                for (int i = 0; i < sbrRPPrptySeqNumTotalContexts.Count(); i++)
                {
                    sbrRPPrptySeqNumTotalContext = sbrRPPrptySeqNumTotalContexts.ElementAt(i);
                    RNTLPRPTY2019.RPPrptySeqNumTotalContext rpPrptySeqNumTotalContext = new RNTLPRPTY2019.RPPrptySeqNumTotalContext();
                    report.RPPrptySeqNumTotalContextCollection.Add(rpPrptySeqNumTotalContext);

                    rpPrptySeqNumTotalContext.Id = sbrRPPrptySeqNumTotalContext.Id;
                    rpPrptySeqNumTotalContext.Identifier = sbrRPPrptySeqNumTotalContext.EntityIdentifier;
                    rpPrptySeqNumTotalContext.IdentifierScheme = sbrRPPrptySeqNumTotalContext.EntityScheme;

                    rpPrptySeqNumTotalContext.Count = sbrRPPrptySeqNumTotalContexts.Count();
                    rpPrptySeqNumTotalContext.Exists = true;
                    rpPrptySeqNumTotalContext.OccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumTotalContext) + 1;
                    rpPrptySeqNumTotalContext.LastOccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumTotalContexts.Last()) + 1;


                    if (rpPrptySeqNumTotalContext.IdentifierScheme == "http://www.ato.gov.au/tfn") rpPrptySeqNumTotalContext.IdentifierTFN = rpPrptySeqNumTotalContext.Identifier;

                    rpPrptySeqNumTotalContext.StartDate = ((SBRDurationPeriod)sbrRPPrptySeqNumTotalContext.Period).DurationStartAsDateObject;
                    rpPrptySeqNumTotalContext.EndDate = ((SBRDurationPeriod)sbrRPPrptySeqNumTotalContext.Period).DurationEndAsDateObject;

                    currentSegment = sbrRPPrptySeqNumTotalContext.Segment.Segment;

                    currentNamespaceManager = new XmlNamespaceManager(currentSegment.OwnerDocument.NameTable);
                    currentNamespaceManager.AddNamespace("xbrldi", "http://xbrl.org/2006/xbrldi");

                    currentNode = currentSegment.SelectSingleNode("xbrldi:typedMember[contains(@dimension, 'RentalPropertyFinancialDetailsSequenceDimension')]", currentNamespaceManager);

                    if (currentNode != null)
                    {
                        rpPrptySeqNumTotalContext.RentalPropertyFinancialDetailsSequenceDimensionValue = currentNode.InnerText.Trim();
                    }

                    sbrPopulatedRPPrptySeqNumTotalElementsMap = new System.Collections.Generic.Dictionary<string, IList<SBRElement>>();

                    IList<SBRElement> elements = sbrDocument.ElementsByContextId[sbrRPPrptySeqNumTotalContext.Id];
                    if (elements != null)
                    {
                        for (int e = 0; e < elements.Count(); e++)
                        {
                            SBRElement currentElement = elements[e];
                            if (currentElement == null || currentElement.IsInTuple) continue; // Don't add tuple elements here, they will be found through a different map.
                            if (sbrPopulatedRPPrptySeqNumTotalElementsMap.ContainsKey("{" + currentElement.Namespace + "}" + currentElement.Name))
                            {
                                sbrPopulatedRPPrptySeqNumTotalElementsMap["{" + currentElement.Namespace + "}" + currentElement.Name].Add(currentElement);
                            }
                            else
                            {
                                sbrPopulatedRPPrptySeqNumTotalElementsMap.Add("{" + currentElement.Namespace + "}" + currentElement.Name, new List<SBRElement> { currentElement });
                            }
                        }
                    }
                    rpPrptySeqNumTotalContext.RNTLPRPTY113 = rpPrptySeqNumTotalContext.RentalPropertyFinancialDetailsSequenceDimensionValue;

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Income.RealEstateProperty.Rental.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY114 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Income.RealEstateProperty.RentalRelatedOther.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY115 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Marketing.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY116 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.BodyCorporate.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY117 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Borrowing.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY118 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Cleaning.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY119 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.CouncilRates.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY120 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.DepreciationandAmortisation.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY121 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Gardening.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY122 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Insurance.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY123 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.LoanInterest.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY124 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.LandTax.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY125 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.LegalFees.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY126 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.PestControl.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY127 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.AgentFeesCommission.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY128 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.RepairsAndMaintenance.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY129 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.CapitalWorksDeduction.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY130 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.OfficeSupplies.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY131 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.Travel.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY132 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Water.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY133 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumTotalElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Sundry.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumTotalContext.RNTLPRPTY134 = decimal.Parse(currentValues[0].Value);
                    }
                }
            }
            #endregion End of Context sbrRPPrptySeqNumTotalContext

            #region sbrRPPrptySeqNumPortionContext
            IEnumerable<SBRContext> sbrRPPrptySeqNumPortionContexts = null;
            SBRContext sbrRPPrptySeqNumPortionContext = null;

            sbrRPPrptySeqNumPortionContexts = contextArray.Where(
                c => c.Period != null && c.Period.PeriodType == SBRPeriod_PeriodType.DURATION &&
                c.Segment != null && c.Segment.ExplicitOrTypedDimensionDomains.Count == 3 &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}ReportPartyTypeDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}ReportingParty")) &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.TYPED && dd.Dimension.EndsWith("}RentalPropertyFinancialDetailsSequenceDimension")) &&
                (c.Segment.ExplicitOrTypedDimensionDomains.Any(dd => dd.DimensionType == SBRExplicitOrTypedDimensionDomain_Type.EXPLICIT && dd.Dimension.EndsWith("}RentalPropertyShareDimension") && ((SBRExplicitDimensionDomain)dd).Domain.EndsWith("}Portion"))))));
            Dictionary<string, IList<SBRElement>> sbrPopulatedRPPrptySeqNumPortionElementsMap = new Dictionary<string, IList<SBRElement>>();
            if (sbrRPPrptySeqNumPortionContexts != null && sbrRPPrptySeqNumPortionContexts.Count() > 0)
            {

                report.RPPrptySeqNumPortionContextCollection = new List<RNTLPRPTY2019.RPPrptySeqNumPortionContext>();
                for (int i = 0; i < sbrRPPrptySeqNumPortionContexts.Count(); i++)
                {
                    sbrRPPrptySeqNumPortionContext = sbrRPPrptySeqNumPortionContexts.ElementAt(i);
                    RNTLPRPTY2019.RPPrptySeqNumPortionContext rpPrptySeqNumPortionContext = new RNTLPRPTY2019.RPPrptySeqNumPortionContext();
                    report.RPPrptySeqNumPortionContextCollection.Add(rpPrptySeqNumPortionContext);

                    rpPrptySeqNumPortionContext.Id = sbrRPPrptySeqNumPortionContext.Id;
                    rpPrptySeqNumPortionContext.Identifier = sbrRPPrptySeqNumPortionContext.EntityIdentifier;
                    rpPrptySeqNumPortionContext.IdentifierScheme = sbrRPPrptySeqNumPortionContext.EntityScheme;

                    rpPrptySeqNumPortionContext.Count = sbrRPPrptySeqNumPortionContexts.Count();
                    rpPrptySeqNumPortionContext.Exists = true;
                    rpPrptySeqNumPortionContext.OccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumPortionContext) + 1;
                    rpPrptySeqNumPortionContext.LastOccurrenceIndex = Array.IndexOf(contextArray, sbrRPPrptySeqNumPortionContexts.Last()) + 1;


                    if (rpPrptySeqNumPortionContext.IdentifierScheme == "http://www.ato.gov.au/tfn") rpPrptySeqNumPortionContext.IdentifierTFN = rpPrptySeqNumPortionContext.Identifier;

                    rpPrptySeqNumPortionContext.StartDate = ((SBRDurationPeriod)sbrRPPrptySeqNumPortionContext.Period).DurationStartAsDateObject;
                    rpPrptySeqNumPortionContext.EndDate = ((SBRDurationPeriod)sbrRPPrptySeqNumPortionContext.Period).DurationEndAsDateObject;

                    currentSegment = sbrRPPrptySeqNumPortionContext.Segment.Segment;

                    currentNamespaceManager = new XmlNamespaceManager(currentSegment.OwnerDocument.NameTable);
                    currentNamespaceManager.AddNamespace("xbrldi", "http://xbrl.org/2006/xbrldi");

                    currentNode = currentSegment.SelectSingleNode("xbrldi:typedMember[contains(@dimension, 'RentalPropertyFinancialDetailsSequenceDimension')]", currentNamespaceManager);

                    if (currentNode != null)
                    {
                        rpPrptySeqNumPortionContext.RentalPropertyFinancialDetailsSequenceDimensionValue = currentNode.InnerText.Trim();
                    }

                    sbrPopulatedRPPrptySeqNumPortionElementsMap = new System.Collections.Generic.Dictionary<string, IList<SBRElement>>();

                    IList<SBRElement> elements = sbrDocument.ElementsByContextId[sbrRPPrptySeqNumPortionContext.Id];
                    if (elements != null)
                    {
                        for (int e = 0; e < elements.Count(); e++)
                        {
                            SBRElement currentElement = elements[e];
                            if (currentElement == null || currentElement.IsInTuple) continue; // Don't add tuple elements here, they will be found through a different map.
                            if (sbrPopulatedRPPrptySeqNumPortionElementsMap.ContainsKey("{" + currentElement.Namespace + "}" + currentElement.Name))
                            {
                                sbrPopulatedRPPrptySeqNumPortionElementsMap["{" + currentElement.Namespace + "}" + currentElement.Name].Add(currentElement);
                            }
                            else
                            {
                                sbrPopulatedRPPrptySeqNumPortionElementsMap.Add("{" + currentElement.Namespace + "}" + currentElement.Name, new List<SBRElement> { currentElement });
                            }
                        }
                    }
                    rpPrptySeqNumPortionContext.RNTLPRPTY135 = rpPrptySeqNumPortionContext.RentalPropertyFinancialDetailsSequenceDimensionValue;

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Income.RealEstateProperty.Rental.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY136 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Income.RealEstateProperty.RentalRelatedOther.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY137 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Marketing.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY138 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.BodyCorporate.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY139 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Borrowing.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY140 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Cleaning.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY141 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.CouncilRates.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY142 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.DepreciationandAmortisation.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY143 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Gardening.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY144 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Insurance.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY145 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.LoanInterest.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY146 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.LandTax.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY147 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.LegalFees.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY148 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.PestControl.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY149 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.AgentFeesCommission.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY150 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.RepairsAndMaintenance.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY151 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.CapitalWorksDeduction.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY152 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.OfficeSupplies.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY153 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.Travel.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY154 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Water.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY155 = decimal.Parse(currentValues[0].Value);
                    }

                    if (sbrPopulatedRPPrptySeqNumPortionElementsMap.TryGetValue("{http://www.sbr.gov.au/ato/rntlprpty}Expense.RealEstateProperty.Sundry.Amount", out currentValues))
                    {
                        if (!currentValues[0].IsNil) rpPrptySeqNumPortionContext.RNTLPRPTY156 = decimal.Parse(currentValues[0].Value);
                    }
                }
            }
            #endregion End of Context sbrRPPrptySeqNumPortionContext
            return report;

        } // Of Consume Method
    } // Of Class
} // Of Namespace
