using System;
using System.Collections.Generic;
using DataContracts;
using System.Text.RegularExpressions;

namespace Ato.EN.IntegrationServices.CodeGenerationCTR {
    public partial class CTR2024Validator
    {

        #region Manual Rules - Rules marked for manual coding

        #region VR.ATO.CTR.430216

        /*  VR.ATO.CTR.430216
        Check taxable/net income/loss for the Company, in Reconciliation to taxable income or loss

        Legacy Rule Format:
        IF  ([CTR120] <> 
          (([CTR57]+[CTR58]+[CTR59]+[CTR60]+[CTR61]+[CTR63]+
             [CTR64]+[CTR65]+[CTR66]+
             [CTR67]+[CTR68]+[CTR70]+[CTR71])
             -
             ([CTR72]+[CTR73]+[CTR364]+[CTR75]+[CTR76]+[CTR77]+
              [CTR78]+[CTR79]+[CTR80]+[CTR81]+[CTR365]+[CTR366]+
              [CTR84]+[CTR85]+[CTR86]+[CTR87]+[CTR88])  
            + 
             ([CTR91]+[CTR92]+[CTR93]+[CTR94]+[CTR255]+[CTR95]+
              [CTR96]+[CTR97])
            - 
              ([CTR98]+[CTR99]+[CTR100]+[CTR101]+ 
               [CTR102]+[CTR103]+[CTR104]+[CTR111]+[CTR112]+     
               [CTR114]+[CTR115]+[CTR256]+[CTR452]+[CTR456]+[CTR116]+[CTR117]+   
               [CTR118]) 
            ) +/- 30)
           RETURN VALIDATION MESSAGE
        ENDIF

        Technical Business Rule Format:
        OutsideRange(^CTR120,(^CTR57+^CTR58+^CTR59+^CTR60+^CTR61+^CTR63+^CTR64+^CTR65+^CTR66+^CTR67+^CTR68+^CTR70+^CTR71) - (^CTR72+^CTR73+^CTR364+^CTR75+^CTR76+^CTR77+^CTR78+^CTR79+^CTR80+^CTR81+^CTR365+^CTR366+^CTR84+^CTR85+^CTR86+^CTR87+^CTR88) + (^CTR91+^CTR92+^CTR93+^CTR94+^CTR255+^CTR95+^CTR96+^CTR97) - (^CTR98+^CTR99+^CTR100+^CTR101+^CTR102+^CTR103+^CTR104+^CTR111+^CTR112+^CTR114+^CTR115+^CTR256+^CTR452+^CTR456+^CTR116+^CTR117+^CTR118), 30)

        Data Elements:

        ^CTR120 = RP:Income.Taxable.Amount

        ^CTR57 = RP:Remuneration.PaymentToForeignResidentGross.Amount

        ^CTR58 = RP:Remuneration.ABNNotQuotedPaymentGross.Amount

        ^CTR59 = RP:Income.SaleOfGoodsAndServices.Other.Amount

        ^CTR60 = RP:Income.PartnershipDistributionGross.Amount

        ^CTR61 = RP:TrustDistributionIncome:Income.TrustDistributionGross.Amount

        ^CTR63 = RP:Income.ForestryManagedInvestmentScheme.Amount

        ^CTR64 = RP:Income.Interest.Gross.Amount

        ^CTR65 = RP:Income.RentLeasingHiringGross.Amount

        ^CTR66 = RP:Income.DividendsTotal.Amount

        ^CTR67 = RP:Remuneration.FringeBenefits.EmployeeContribution.Amount

        ^CTR68 = RP:GovernmentFunding.GovernmentIndustryPaymentsAssessable.Amount

        ^CTR70 = RP:Income.AssetRevaluationsUnrealisedGains.Amount

        ^CTR71 = RP:Income.OtherGross.Amount

        ^CTR72 = RP:Expense.ForeignResidentWithholding.Amount

        ^CTR73 = RP:Expense.Operating.CostOfSales.Amount

        ^CTR75 = RP:SuperannuationContribution.EmployerContributions.Amount

        ^CTR76 = RP:Expense.Operating.BadDebts.Amount

        ^CTR77 = RP.JAUS:Expense.Operating.Lease.Amount

        ^CTR78 = RP.JFOREIGN:Expense.Operating.Lease.Amount

        ^CTR79 = RP:Expense.Operating.Rent.Amount

        ^CTR80 = RP.JAUS:Expense.Operating.Interest.Amount

        ^CTR81 = RP.JFOREIGN:Expense.Operating.Interest.Amount

        ^CTR84 = RP:Expense.DepreciationAndAmortisation.Amount

        ^CTR85 = RP:Expense.Operating.MotorVehicle.Amount

        ^CTR86 = RP:Expense.Operating.RepairsAndMaintenance.Amount

        ^CTR87 = RP:Expense.AssetRevaluationsUnrealisedLosses.Amount

        ^CTR88 = RP:Expense.Other.Amount

        ^CTR91 = RP:Income.CapitalGainsNet.Amount

        ^CTR92 = RP:Expense.NonDeductibleExemptIncome.Amount

        ^CTR93 = RP:IncomeTax.FrankingCredits.ReceivedFromAustralianCompanies.Amount

        ^CTR94 = RP:IncomeTax.FrankingCredits.ReceivedFromNewZealandCompanies.Amount

        ^CTR95 = RP:Income.AssessableOther.Amount

        ^CTR96 = RP:Expense.NonDeductible.Amount

        ^CTR97 = RP:TaxConcession.ResearchAndDevelopment.WriteBackOfAccountingExpenditure.Amount

        ^CTR98 = RP:Expense.FlowOnDividendDeduction.Amount

        ^CTR99 = RP:Expense.DepreciationAllowableDeduction.Amount

        ^CTR100 = RP:Expense.ForestryManagedInvestmentSchemeDeduction.Amount

        ^CTR101 = RP:Expense.CapitalExpenditureImmediateDeduction.Amount

        ^CTR102 = RP:Expense.ProjectPoolAllowableDeduction.Amount

        ^CTR103 = RP:Expense.CapitalWorksDeduction.Amount

        ^CTR104 = RP:Expense.CapitalExpenditureSpecifiedAllowableDeduction.Amount

        ^CTR111 = RP.Y0:Expense.LandcareOperationsAcceleratedDepreciation.Amount

        ^CTR112 = RP:Expense.EnvironmentalProtectionDeduction.Amount

        ^CTR114 = RP:Income.Exempt.Amount

        ^CTR115 = RP:Income.NotincludedInAssessableOther.Amount

        ^CTR116 = RP:Expense.DeductibleOther.Amount

        ^CTR117 = RP:IncomeTax.Deduction.TaxLossesDeducted.Amount

        ^CTR118 = RP:IncomeTax.TaxLossesTransferredIn.Amount

        ^CTR255 = RP.TOFA:Income.OtherTotal.Amount

        ^CTR256 = RP.TOFA:Expense.DeductibleOther.Amount

        ^CTR364 = RP:Remuneration.WagesAndSalaries.PaymentsContractorAndConsultant.Amount

        ^CTR365 = RP.JAUS:Expense.Royalties.Amount

        ^CTR366 = RP.JFOREIGN:Expense.Royalties.Amount

        ^CTR452 = RP:Expense.EmployeeTrainingBonus.Amount

        ^CTR456 = RP:tns:Expense.EnergyIncentive.Amount
                
        */

        public void VRATOCTR430216(List<ProcessMessageDocument> response, CTR2024 report)
        {
            ProcessMessageDocument processMessage;
            bool assertion;

            assertion = OutsideRange(report.CTR120.GetValueOrDefault(), report.CTR57.GetValueOrDefault() + report.CTR58.GetValueOrDefault() + report.CTR59.GetValueOrDefault() + report.CTR60.GetValueOrDefault() + report.CTR61.GetValueOrDefault() + report.CTR63.GetValueOrDefault() + report.CTR64.GetValueOrDefault() + report.CTR65.GetValueOrDefault() + report.CTR66.GetValueOrDefault() + report.CTR67.GetValueOrDefault() + report.CTR68.GetValueOrDefault() + report.CTR70.GetValueOrDefault() + report.CTR71.GetValueOrDefault() - (report.CTR72.GetValueOrDefault() + report.CTR73.GetValueOrDefault() + report.CTR364.GetValueOrDefault() + report.CTR75.GetValueOrDefault() + report.CTR76.GetValueOrDefault() + report.CTR77.GetValueOrDefault() + report.CTR78.GetValueOrDefault() + report.CTR79.GetValueOrDefault() + report.CTR80.GetValueOrDefault() + report.CTR81.GetValueOrDefault() + report.CTR365.GetValueOrDefault() + report.CTR366.GetValueOrDefault() + report.CTR84.GetValueOrDefault() + report.CTR85.GetValueOrDefault() + report.CTR86.GetValueOrDefault() + report.CTR87.GetValueOrDefault() + report.CTR88.GetValueOrDefault()) + (report.CTR91.GetValueOrDefault() + report.CTR92.GetValueOrDefault() + report.CTR93.GetValueOrDefault() + report.CTR94.GetValueOrDefault() + report.CTR255.GetValueOrDefault() + report.CTR95.GetValueOrDefault() + report.CTR96.GetValueOrDefault() + report.CTR97.GetValueOrDefault()) - (report.CTR98.GetValueOrDefault() + report.CTR99.GetValueOrDefault() + report.CTR100.GetValueOrDefault() + report.CTR101.GetValueOrDefault() + report.CTR102.GetValueOrDefault() + report.CTR103.GetValueOrDefault() + report.CTR104.GetValueOrDefault() + report.CTR111.GetValueOrDefault() + report.CTR112.GetValueOrDefault() + report.CTR114.GetValueOrDefault() + report.CTR115.GetValueOrDefault() + report.CTR256.GetValueOrDefault() + report.CTR452.GetValueOrDefault() + report.CTR456.GetValueOrDefault() + report.CTR116.GetValueOrDefault() + report.CTR117.GetValueOrDefault() + report.CTR118.GetValueOrDefault()), 30);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.CTR.430216",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Check taxable/net income/loss for the Company, in Reconciliation to taxable income or loss",
                    LongDescription = @"The Taxable/net income/loss must be equal to the sum of all income items less the sum of all expense items plus extraordinary revenue/expenses, total capital gains, non deductible exempt income expenditure, other assessable income and non deductible expenses items less other expense items",
                    Location = "/xbrli:xbrl/tns:Income.Taxable.Amount",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.CTR.430216" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR120", Value = GetValueOrEmpty(report.CTR120) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR57", Value = GetValueOrEmpty(report.CTR57) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR58", Value = GetValueOrEmpty(report.CTR58) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR59", Value = GetValueOrEmpty(report.CTR59) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR60", Value = GetValueOrEmpty(report.CTR60) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR61", Value = GetValueOrEmpty(report.CTR61) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR63", Value = GetValueOrEmpty(report.CTR63) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR64", Value = GetValueOrEmpty(report.CTR64) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR65", Value = GetValueOrEmpty(report.CTR65) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR66", Value = GetValueOrEmpty(report.CTR66) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR67", Value = GetValueOrEmpty(report.CTR67) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR68", Value = GetValueOrEmpty(report.CTR68) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR70", Value = GetValueOrEmpty(report.CTR70) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR71", Value = GetValueOrEmpty(report.CTR71) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR72", Value = GetValueOrEmpty(report.CTR72) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR73", Value = GetValueOrEmpty(report.CTR73) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR364", Value = GetValueOrEmpty(report.CTR364) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR75", Value = GetValueOrEmpty(report.CTR75) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR76", Value = GetValueOrEmpty(report.CTR76) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR77", Value = GetValueOrEmpty(report.CTR77) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR78", Value = GetValueOrEmpty(report.CTR78) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR79", Value = GetValueOrEmpty(report.CTR79) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR80", Value = GetValueOrEmpty(report.CTR80) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR81", Value = GetValueOrEmpty(report.CTR81) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR365", Value = GetValueOrEmpty(report.CTR365) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR366", Value = GetValueOrEmpty(report.CTR366) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR84", Value = GetValueOrEmpty(report.CTR84) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR85", Value = GetValueOrEmpty(report.CTR85) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR86", Value = GetValueOrEmpty(report.CTR86) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR87", Value = GetValueOrEmpty(report.CTR87) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR88", Value = GetValueOrEmpty(report.CTR88) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR91", Value = GetValueOrEmpty(report.CTR91) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR92", Value = GetValueOrEmpty(report.CTR92) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR93", Value = GetValueOrEmpty(report.CTR93) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR94", Value = GetValueOrEmpty(report.CTR94) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR255", Value = GetValueOrEmpty(report.CTR255) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR95", Value = GetValueOrEmpty(report.CTR95) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR96", Value = GetValueOrEmpty(report.CTR96) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR97", Value = GetValueOrEmpty(report.CTR97) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR98", Value = GetValueOrEmpty(report.CTR98) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR99", Value = GetValueOrEmpty(report.CTR99) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR100", Value = GetValueOrEmpty(report.CTR100) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR101", Value = GetValueOrEmpty(report.CTR101) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR102", Value = GetValueOrEmpty(report.CTR102) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR103", Value = GetValueOrEmpty(report.CTR103) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR104", Value = GetValueOrEmpty(report.CTR104) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR111", Value = GetValueOrEmpty(report.CTR111) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR112", Value = GetValueOrEmpty(report.CTR112) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR114", Value = GetValueOrEmpty(report.CTR114) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR115", Value = GetValueOrEmpty(report.CTR115) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR256", Value = GetValueOrEmpty(report.CTR256) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR452", Value = GetValueOrEmpty(report.CTR452) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR456", Value = GetValueOrEmpty(report.CTR456) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR116", Value = GetValueOrEmpty(report.CTR116) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR117", Value = GetValueOrEmpty(report.CTR117) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "CTR118", Value = GetValueOrEmpty(report.CTR118) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.CTR.430216   

        #endregion Manual Rules - Rules marked for manual coding
    }
}
