using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationIDS;
using Ato.EN.IntegrationServices.CodeGenerationPTR;
using VaTS;
using DataContracts;
using System.Collections.Generic;

namespace Ato.CD.Inbound.PTR202402
{
    internal class CrossFormValidatorIDS : ICrossFormValidator
    {
        private PTR2024 ParentDocument { get; }

        private IDS2024 ChildDocument { get; }

        private List<Context> Contexts { get; }

        internal CrossFormValidatorIDS(PTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (IDS2024)childDocument.ConsumedReport;   
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOIDS440670(response);
            VRATOPTR438082(response);

            return response;
        }

        #region VR.ATO.IDS.440670
        /* 
        Rule ID: VR.ATO.IDS.440670

        IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
            RETURN VALIDATION MESSAGE
        ENDIF
        */
        private void VRATOIDS440670(List<ProcessMessageDocument> response)
        {
            bool assertion = !ParentDocument.RPIdentifierTFN.Equals(ChildDocument.IDS500);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = "Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IDS.440670" } }
                });
            }
        }
        #endregion

        #region VR.ATO.PTR.438082
        // IF [PTR355] = TRUE AND (COUNT(SCHEDULE = "IDS") = 1 AND [IDS425] = TRUE)
        //  RETURN VALIDATION MESSAGE
        // ENDIF
        // [IDS425] = IDS:RP:rvctc4.02.16:InternationalDealings.SmallBusinessConcessionsEligibility.Indicator
        // [PTR355] = PTR:RP:pyde.02.31:OrganisationDetails.SignificantGlobalEntityStatus.Indicator
        private void VRATOPTR438082(List<ProcessMessageDocument> response)
        {
            bool assertion = ParentDocument.PTR355.GetValueOrDefault() && ChildDocument.IDS425.GetValueOrDefault();
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.PTR.438082",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Significant Global Entity question on the International Dealings Schedule (IDS) form must not be 'TRUE'.",
                    Location = "/xbrli:xbrl/tns:OrganisationDetails.SignificantGlobalEntityStatus.Indicator",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PTR.438082" } }
                });
            }
        }
        #endregion
    }
}