using System.Linq;
using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationPSS;
using Ato.EN.IntegrationServices.CodeGenerationPTR;
using DataContracts;

namespace Ato.CD.Inbound.PTR202402
{
    internal class CrossFormValidatorPSS : ICrossFormValidator
    {
        private PTR2024 ParentDocument { get; }

        private PSS2018 ChildDocument { get; }

        internal CrossFormValidatorPSS(PTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (PSS2018)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOPSS000035(response);
            VRATOPSS000036(response);

            return response;
        }

        #region VR.ATO.PSS.000036
        /*  VR.ATO.PSS.000036
            WHERE IN CONTEXT (RP.Payer.{PSSeqNum)
            IF (RP.Payer.{PSSeqNum}.entity.identifier.TFN <> PARENT RETURN:RP.entity.identifier.TFN)
               RETURN VALIDATION MESSAGE
            ENDIF
       */
        private void VRATOPSS000036(List<ProcessMessageDocument> response)
        {
            if (ChildDocument.RPPayerPSSeqNumContextCollection != null)
                response.AddRange(ChildDocument.RPPayerPSSeqNumContextCollection
                    .Where(p => p.IdentifierTFN != ParentDocument.RPIdentifierTFN)
                    .Select((p, i) => new { RPPayer = p, Idx = i }).Select(p => new ProcessMessageDocument
                    {
                        Code = "CMN.ATO.PSS.000036",
                        Severity = ProcessMessageSeverity.Error,
                        Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                        Location = p.Idx == 0 ? "xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier" : $"xbrli:xbrl/xbrli:context[{p.Idx + 1}]/xbrli:entity/xbrli:identifier",
                        Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000036" } }
                    }));
        }
        #endregion

        #region VR.ATO.PSS.000035
        /*  VR.ATO.PSS.000035
            IF PARENT RETURN <> “IITR”
               AND ([PSS20] <> NULLORBLANK OR [PSS21] <> NULLORBLANK OR [PSS31] <> NULLORBLANK OR [PSS24] <> NULLORBLANK OR [PSS25] <> NULLORBLANK OR [PSS32] <> NULLORBLANK)
                 RETURN VALIDATION MESSAGE
              ENDIF

              [PSS20] = PSS:RP.Payer.{PSSeqNum}:tns:Remuneration.VoluntaryAgreementGross.Amount
              [PSS21] = PSS:RP.Payer.{PSSeqNum}:tns:Remuneration.LabourHireArrangementPaymentGross.Amount
              [PSS24] = PSS:RP.Payer.{PSSeqNum}:tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount
              [PSS25] = PSS:RP.Payer.{PSSeqNum}:tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount
              [PSS31] = PSS:RP.Payer.{PSSeqNum}:tns:Remuneration.PersonalServicesIncome.AttributedGross.Amount
              [PSS32] = PSS:RP.Payer.{PSSeqNum}:tns:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount   
       */
        private void VRATOPSS000035(List<ProcessMessageDocument> response)
        {
            if (ChildDocument.RPPayerPSSeqNumContextCollection != null)
                response.AddRange(ChildDocument.RPPayerPSSeqNumContextCollection
                    .Where(p => p.PSS20.HasValue || p.PSS21.HasValue || p.PSS24.HasValue || p.PSS25.HasValue ||
                                p.PSS31.HasValue || p.PSS32.HasValue).Select(p =>
                        new ProcessMessageDocument
                        {
                            Code = "CMN.ATO.PSS.000035",
                            Severity = ProcessMessageSeverity.Error,
                            Description = "Payment Type not applicable to Non-individual income tax return",
                            Location = $"/xbrli:xbrl/tns:Remuneration.PaymentToForeignResidentGross.Amount[contextRef=\"{p.Id}\"]",
                            Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000035" } }
                        }
                    ));
        }
        #endregion
    }
}