using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationRS;
using Ato.EN.IntegrationServices.CodeGenerationPTR;
using DataContracts;

namespace Ato.CD.Inbound.PTR202402
{
    internal class CrossFormValidatorRS : ICrossFormValidator
    {
        private PTR2024 ParentDocument { get; }

        private RS2018 ChildDocument { get; }

        internal CrossFormValidatorRS(PTR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (RS2018)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATORS000137(response);
            VRATORS000138(response);
            VRATOPTR430082(response);
            VRATOGEN402009(response);
            VRATORS000150(response);

            return response;
        }
        #region VR.ATO.RS.000137
        /* 
        IF (PARENT RETURN <> "IITR") AND ([RS25] > 52)  
        RETURN VALIDATION MESSAGE
        ENDIF
        */
        private void VRATORS000137(List<ProcessMessageDocument> response)
        {
            bool assertion = ChildDocument.RS25.GetValueOrDefault() > 52;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.RS.000137",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Number of weeks property rented must not exceed 52",
                    Location = "/xbrli:xbrl/tns:RealEstateProperty.RentalWeeks.Count",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000137" } }
                });
            }
        }
        #endregion

        #region VR.ATO.RS.000138
        /* 
        IF (PARENT RETURN <> ""IITR"") AND ([RS27] > 52)  
           RETURN VALIDATION MESSAGE
        ENDIF
        */
        private void VRATORS000138(List<ProcessMessageDocument> response)
        {
            bool assertion = ChildDocument.RS27.GetValueOrDefault() > 52;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.RS.000138",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Number of weeks property was available for rent this year cannot exceed 52 weeks",
                    Location = "/xbrli:xbrl/tns:RealEstateProperty.RentalWeeksAvailable.Count",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000138" } }
                });
            }
        }
        #endregion 

        #region VR.VR.ATO.PTR.430082 
        /*

          IF(COUNT(SCHEDULE = ""RS"") > 0) AND([PTR77] = NULL
            AND ([PTR78] = 0 OR[PTR78] = NULL) AND([PTR79] = 0 OR[PTR79] = NULL) AND([PTR80] = 0 OR[PTR80] = NULL)) 
              RETURN VALIDATION MESSAGE
          ENDIF

          [PTR77] = PTR:RP.JAUS:bafpr2.02.00:Income.Operating.RentalIncomeGross.Amount
          [PTR78] = PTR:RP.JAUS:bafpr1.02.05:Expense.Interest.Amount
          [PTR79] = PTR:RP.JAUS:bafpr1.02.02:Expense.CapitalWorksDeduction.Amount
          [PTR80] = PTR:RP.JAUS:rvctc2.02.00:IncomeTax.Deduction.RentalIncomeDeductionsOtherThanInterestAndCapitalWorks.Amount
          */
        private void VRATOPTR430082(List<ProcessMessageDocument> response)
        {
            bool assertion = ParentDocument.PTR77 == null &&
                    (
                        ParentDocument.PTR77 == null &&
                        (
                        ParentDocument.PTR78.GetValueOrDefault() == 0 && ParentDocument.PTR79.GetValueOrDefault() == 0 && ParentDocument.PTR80.GetValueOrDefault() == 0
                        )
                    );

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430082",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Gross rent and Rental deduction amounts must be present",
                    LongDescription = "If a Rental property schedule is present, Gross rent or rental deductions must be present",
                    Location = "/xbrli:xbrl/tns:Income.Operating.RentalIncomeGross.Amount",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.4030082" } }
                });
            }
        }
        #endregion

        #region VR.ATO.GEN.430086
        //  Rule ID: VR.ATO.GEN.430086

        //IF(COUNT(SCHEDULE = "RS") > 0) AND(SUM(ALL OCCURRENCES OF([RS48]))) <> [PTR78]
        //  RETURN VALIDATION MESSAGE
        //ENDIF

        //[PTR78] = PTR:RP.JAUS:bafpr1.02.05:Expense.Interest.Amount
        //[RS48] = RS:RP:bafpr2.02.04:Expense.RealEstateProperty.LoanInterest.Amount
        private void VRATOGEN430086(List<ProcessMessageDocument> response)
        {
            bool assertion = ParentDocument.PTR78 != ChildDocument.RS48;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.430086",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Rental Interest deductions must equal the total Interest deductions in the Rental Schedules",
                    LongDescription = "The Interest deductions amount in the main form must equal the total of all Interest deductions in the Rental property schedules",
                    Location = "/xbrli:xbrl/tns:Expense.Interest.Amount",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009" } }
                });
            }
        }
        #endregion

        #region VR.ATO.GEN.402009
        /* VR.ATO.GEN.402009
            IF RP:entity.identifier.TFN<> PARENT RETURN:RP:entity.identifier.TFN
                RETURN VALIDATION MESSAGE
            ENDIF
                xbrli:context[@id =$RP.LOS.ContextId]
            RP.LOS.Context
        */
        private void VRATOGEN402009(List<ProcessMessageDocument> response)
        {
            bool assertion = !ParentDocument.RPIdentifierTFN.Equals(ChildDocument.RPIdentifierTFN);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = "Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009" } }
                });
            }
        }
        #endregion

        #region VR.ATO.RS.000150
        /* VR.ATO.RS.000150
            IF (PARENT RETURN <> SET("IITR","TRTAMI") AND [RS14] <> PARENT RETURN(pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text (IN TUPLE(xbrli\organisationame2.xx.xx:OrganisationNameDetails) WHERE (pyde.xx.xx:OrganisationNameDetails.OrganisationalType.Code = "MN") AND (pyde.xx.xx:OrganisationNameDetails.Currency.Code = "C")))) OR (PARENT RETURN = SET("IITR","TRTAMI") AND [RS14] <> PARENT RETURN:RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text)
                RETURN VALIDATION MESSAGE
            ENDIF
        */
        private void VRATORS000150(List<ProcessMessageDocument> response)
        {
            bool assertion = !ParentDocument.PTR6.Equals(ChildDocument.RS14);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.RS.000150",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "The Entity name must be the same as the name on the main form",
                    //LongDescription = "Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/tns:OrganisationNameDetails.OrganisationalName.Text",
                    //Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000150" } }
                });
            }
        }
        #endregion
    }
}