using System;
using System.Collections.Immutable;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationSMSFAR;

namespace Ato.CD.Inbound.SMSFAR202402
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<SMSFAR2024, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            var builder = ImmutableDictionary.CreateBuilder<string, Func<SMSFAR2024, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.CGTS.ToString(), (report, schedule) => new CrossFormValidatorCGTS(report, schedule));
            builder.Add(Schedule.LS.ToString(), (report, schedule) => new CrossFormValidatorLS(report, schedule));
            builder.Add(Schedule.PSS.ToString(), (report, schedule) => new CrossFormValidatorPSS(report, schedule));
            builder.Add(Schedule.FTER.ToString(), (report, schedule) => new CrossFormValidatorFTER(report, schedule));
            builder.Add(Schedule.IEE.ToString(), (report, schedule) => new CrossFormValidatorIEE(report, schedule));
            builder.Add(Schedule.DISTBENTRT.ToString(), (report, schedule) => new CrossFormValidatorDISTBENTRT(report, schedule));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(BusinessDocument schedule, SMSFAR2024 report)
            => CrossFormValidators[schedule.DocumentName](report, schedule);
    }
}