using System;
using System.Collections.Generic;
using Ato.CD.Inbound.Shared;
using VaTS;
using Ato.EN.IntegrationServices.CodeGenerationDISTBENTRT;
using Ato.EN.IntegrationServices.CodeGenerationSMSFAR;
using DataContracts;

namespace Ato.CD.Inbound.SMSFAR202402
{
    internal class CrossFormValidatorDISTBENTRT : ICrossFormValidator
    {
        private SMSFAR2024 ParentDocument { get; }

        private DISTBENTRT2024 ChildDocument { get; }

        internal CrossFormValidatorDISTBENTRT(SMSFAR2024 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (DISTBENTRT2024)childDocument.ConsumedReport;
        }

        public IEnumerable<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOSMSFAR437195(response);
            VRATOSMSFAR437196(response);
            VRATOSMSFAR437197(response);
            VRATOSMSFARW00005(response);


            return response;
        }



        #region VR.ATO.SMSFAR.437195
        /* VR.ATO.SMSFAR.437195
            The Tax File Number (TFN) provided for the Distributions to Beneficiaries of Trust schedule must be the same as the TFN of the parent form

            Legacy Rule Format:
                "IF COUNT(SCHEDULE = ""DISTBENTRT"") = 1 AND RP:entity.identifier.TFN <> [DISTBENTRT3]
                   RETURN VALIDATION MESSAGE
                ENDIF"

            Technical Business Rule Format:
                    DISTBENTRTs.Any(d => d.DISTBENTRT3 != ParentDocument.RPIdentifierTFN)
        */
        protected void VRATOSMSFAR437195(List<ProcessMessageDocument> response)
        {
            bool assertion = (ParentDocument.RPExists == true) && ( ChildDocument.DISTBENTRT3!=null) && (ChildDocument.DISTBENTRT3!= ParentDocument.RPIdentifierTFN);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.SMSFAR.437195",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax File Number for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"The Tax File Number (TFN) provided for the Distributions to Beneficiaries of Trust schedule must be the same as the TFN of the parent form",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.437195" },
                        new ProcessMessageParameter { Name = "RPIdentifierTFN", Value = ParentDocument.RPIdentifierTFN },
                        new ProcessMessageParameter { Name = "DISTBENTRT3", Value = ChildDocument.DISTBENTRT3 },
                    }
                });
            }
        }
        #endregion

        #region VR.ATO.SMSFAR.437196
        /* VR.ATO.SMSFAR.437196
            Reporting period start date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period start date of the parent form

            Legacy Rule Format:
                "IF COUNT(SCHEDULE = ""DISTBENTRT"") = 1 AND RP:period.startDate <> [DISTBENTRT1]
                   RETURN VALIDATION MESSAGE
                ENDIF"

            Technical Business Rule Format:
                DISTBENTRTs.Any(d => d.DISTBENTRT1 != ParentDocument.RPStartDate)
                    
        */
        protected void VRATOSMSFAR437196(List<ProcessMessageDocument> response)
        {
            bool assertion =(ParentDocument.RPExists == true) && (ChildDocument.DISTBENTRT1!=null) && (ChildDocument.DISTBENTRT1 != ParentDocument.RPStartDate);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.SMSFAR.437196",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reporting period start date for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"Reporting period start date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period start date of the parent form",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:period/xbrli:startDate",
                    Parameters = new ProcessMessageParameters {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.437196" },
                        new ProcessMessageParameter { Name = "RPStartDate", Value = ParentDocument.RPStartDate.Value.ToString("yyyy-MM-dd") },
                        new ProcessMessageParameter { Name = "DISTBENTRT1", Value = ChildDocument.DISTBENTRT1.Value.ToString("yyyy-MM-dd") },
                    }
                });
            }
        }
        #endregion

        #region VR.ATO.SMSFAR.437197
        /* VR.ATO.SMSFAR.437197
            Reporting period end date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period end date of the parent form

            Legacy Rule Format:
                "IF COUNT(SCHEDULE = ""DISTBENTRT"") = 1 AND RP:period.endDate <> [DISTBENTRT2]
                   RETURN VALIDATION MESSAGE
                ENDIF"

            Technical Business Rule Format:
                DISTBENTRTs.Any(d => d.DISTBENTRT2 != ParentDocument.RPEndDate)
                    
        */
        protected void VRATOSMSFAR437197(List<ProcessMessageDocument> response)
        {
            bool assertion = (ParentDocument.RPExists == true)&& (ChildDocument.DISTBENTRT2 != null)  &&  (ChildDocument.DISTBENTRT2 != ParentDocument.RPEndDate);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.SMSFAR.437197",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reporting period end date for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"Reporting period end date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period end date of the parent form",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:period/xbrli:endDate",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter {Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.437197"},
                        new ProcessMessageParameter { Name = "RPEndDate", Value = ParentDocument.RPEndDate.Value.ToString("yyyy-MM-dd") },
                        new ProcessMessageParameter { Name = "DISTBENTRT1", Value = ChildDocument.DISTBENTRT1.Value.ToString("yyyy-MM-dd") }
                       
                    }

                   
                });
            }
        }
        #endregion

        #region VR.ATO.SMSFAR.W00005
        /* VR.ATO.SMSFAR.W00005
            Distributions to Beneficiaries of Trust schedule is provided but Gross distributions from trusts income is not declared

            Legacy Rule Format:
                "IF COUNT(SCHEDULE = ""DISTBENTRT"") = 1 AND ([SMSFAR47] = NULL)
                   RETURN VALIDATION MESSAGE
                ENDIF"

            Technical Business Rule Format:
                DISTBENTRTs.Any() &&  !ParentDocument.SMSFAR47.HasValue
                    
        */
        protected void VRATOSMSFARW00005(List<ProcessMessageDocument> response)
        {
            bool assertion = !ParentDocument.SMSFAR47.HasValue;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.SMSFAR.W00005",
                    Severity = ProcessMessageSeverity.Warning,
                    Description = @"Ensure Gross distributions from trusts income is declared",
                    LongDescription = @"Ensure Gross distributions from trusts income is declared when Distributions to Beneficiaries of Trust schedule is provided",
                    Location = "/xbrli:xbrl/Income.TrustDistributionGross.Amount",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.W00005" },
                        new ProcessMessageParameter { Name = "SMSFAR47", Value = ParentDocument.SMSFAR47.HasValue ? ParentDocument.SMSFAR47.Value.ToString() : "null" }
                    }
                });
            }
        }
        #endregion

    }
}