using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationTRT;
using System;
using System.Collections.Immutable;
using VaTS;

namespace Ato.CD.Inbound.TRT202402
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<TRT2024, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            ImmutableDictionary<string, Func<TRT2024, BusinessDocument, ICrossFormValidator>>.Builder builder = ImmutableDictionary.CreateBuilder<string, Func<TRT2024, BusinessDocument, ICrossFormValidator>>();
            
            builder.Add(Schedule.CGTS.ToString(), (parent, schedule) => new CrossFormValidatorCGTS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.DISTBENTRT.ToString(), (report, schedule) => new CrossFormValidatorDISTBENTRT(report, schedule.ConsumedReport));
            builder.Add(Schedule.FTER.ToString(), (parent, schedule) => new CrossFormValidatorFTER(parent, schedule.ConsumedReport));
            builder.Add(Schedule.IDS.ToString(), (parent, schedule) => new CrossFormValidatorIDS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.IEE.ToString(), (parent, schedule) => new CrossFormValidatorIEE(parent, schedule.ConsumedReport));
            builder.Add(Schedule.LS.ToString(), (parent, schedule) => new CrossFormValidatorLS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.PSS.ToString(), (parent, schedule) => new CrossFormValidatorPSS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.RS.ToString(), (parent, schedule) => new CrossFormValidatorRS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.TRTAMIS.ToString(), (parent, schedule) => new CrossFormValidatorTRTAMIS(parent, schedule.ConsumedReport));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(TRT2024 parent, BusinessDocument schedule) => CrossFormValidators[schedule.DocumentName](parent, schedule);
    }
}