using System;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationIDS
{
    public class IDS2024
    {

    public bool RpCollectionExists = false;
    public int RpCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:pyid.02.00:Identifiers.TaxFileNumber.Identifier
    /// </summary>
    public string IDS500 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.13:InternationalDealings.CountryByCountryReportApplicability.Indicator
    /// </summary>
    public bool? IDS330 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.20:InternationalDealings.LocalFilePartAVoluntaryLodgment.Indicator
    /// </summary>
    public bool? IDS331 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.10:InternationalDealings.RelatedPartiesTransactionsExcessAggregateValue.Indicator
    /// </summary>
    public bool? IDS1 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.19:InternationalDealings.SmallBusinessConcessionsEligibility.Indicator
    /// </summary>
    public bool? IDS425 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.RelatedPartiesTransactions.Indicator
    /// </summary>
    public bool? IDS2 = null;

    public bool RP_ForeignCountryCollectionExists = false;
    public int RP_ForeignCountryCollectionCount = 0;
    
    public List<RP_ForeignCountry> RP_ForeignCountryCollection = null;
    
    public class RP_ForeignCountry 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignCountry
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS418 = null;
    
        public bool RP_ForeignCountry_ForeignDealingsCollectionExists = false;
        public int RP_ForeignCountry_ForeignDealingsCollectionCount = 0;

        public List<RP_ForeignCountry_ForeignDealings> RP_ForeignCountry_ForeignDealingsCollection = null;

        public class RP_ForeignCountry_ForeignDealings 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignCountry/:ForeignDealings
            /// IDS:pyde.02.48:OrganisationDetails.InternationalRelatedPartyCountryActivity.Code
            /// </summary>
            public string IDS419 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignCountry/:ForeignDealings
            /// IDS:bafpr1.02.16:Expense.Total.Amount
            /// </summary>
            public decimal? IDS5 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignCountry/:ForeignDealings
            /// IDS:bafpr1.02.26:Revenue.Total.Amount
            /// </summary>
            public decimal? IDS6 = null;
        }

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignCountry
        /// IDS:bafpr1.02.00:Expense.Other.Amount
        /// </summary>
        public decimal? IDS7 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignCountry
        /// IDS:bafpr1.02.12:Revenue.Other.Amount
        /// </summary>
        public decimal? IDS8 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.SpecifiedCountriesTransactions.Indicator
    /// </summary>
    public bool? IDS9 = null;

    public bool RP_SpecifiedCountryCollectionExists = false;
    public int RP_SpecifiedCountryCollectionCount = 0;
    
    public List<RP_SpecifiedCountry> RP_SpecifiedCountryCollection = null;
    
    public class RP_SpecifiedCountry 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:SpecifiedCountry
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS420 = null;
    
        public bool RP_SpecifiedCountry_SpecifiedDealingsCollectionExists = false;
        public int RP_SpecifiedCountry_SpecifiedDealingsCollectionCount = 0;

        public List<RP_SpecifiedCountry_SpecifiedDealings> RP_SpecifiedCountry_SpecifiedDealingsCollection = null;

        public class RP_SpecifiedCountry_SpecifiedDealings 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:SpecifiedCountry/:SpecifiedDealings
            /// IDS:pyde.02.48:OrganisationDetails.InternationalRelatedPartyCountryActivity.Code
            /// </summary>
            public string IDS421 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:SpecifiedCountry/:SpecifiedDealings
            /// IDS:bafpr1.02.16:Expense.Total.Amount
            /// </summary>
            public decimal? IDS12 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:SpecifiedCountry/:SpecifiedDealings
            /// IDS:bafpr1.02.26:Revenue.Total.Amount
            /// </summary>
            public decimal? IDS13 = null;
        }

        /// <summary>
        /// /xbrli:xbrl/:RP/:SpecifiedCountry
        /// IDS:bafpr1.02.00:Expense.Other.Amount
        /// </summary>
        public decimal? IDS14 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:SpecifiedCountry
        /// IDS:bafpr1.02.12:Revenue.Other.Amount
        /// </summary>
        public decimal? IDS15 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TransactionsTangiblePropertyRevenue.Indicator
    /// </summary>
    public bool? IDS16 = null;

    public bool RP_TangiblePropertyRevenueCollectionExists = false;
    public int RP_TangiblePropertyRevenueCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TangiblePropertyRevenue
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS17 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TangiblePropertyRevenue
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS18 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TangiblePropertyRevenue
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS19 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TangiblePropertyRevenue
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS20 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TransactionsRoyaltiesLicenceFees.Indicator
    /// </summary>
    public bool? IDS21 = null;

    public bool RP_RoyaltiesCollectionExists = false;
    public int RP_RoyaltiesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Royalties
    /// IDS:bafpr1.02.12:Expense.DeductionsTotal.Amount
    /// </summary>
    public decimal? IDS22 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Royalties
    /// IDS:bafpr1.02.12:Income.IncludedInAssessableTotal.Amount
    /// </summary>
    public decimal? IDS23 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Royalties
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS24 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Royalties
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS25 = null;

    public bool RP_LicenceFeesCollectionExists = false;
    public int RP_LicenceFeesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:LicenceFees
    /// IDS:bafpr1.02.12:Expense.DeductionsTotal.Amount
    /// </summary>
    public decimal? IDS26 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:LicenceFees
    /// IDS:bafpr1.02.12:Income.IncludedInAssessableTotal.Amount
    /// </summary>
    public decimal? IDS27 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:LicenceFees
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS28 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:LicenceFees
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS29 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TransactionsRentLeasing.Indicator
    /// </summary>
    public bool? IDS30 = null;

    public bool RP_RentOrLeasingCollectionExists = false;
    public int RP_RentOrLeasingCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RentOrLeasing
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS31 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RentOrLeasing
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS32 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RentOrLeasing
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS33 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RentOrLeasing
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS34 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TransactionsServiceArrangements.Indicator
    /// </summary>
    public bool? IDS35 = null;

    public bool RP_ServiceArrangementsCollectionExists = false;
    public int RP_ServiceArrangementsCollectionCount = 0;

    public bool RP_ServiceArrangements_TreasuryServicesCollectionExists = false;
    public int RP_ServiceArrangements_TreasuryServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TreasuryServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS36 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TreasuryServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS37 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TreasuryServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS38 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TreasuryServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS39 = null;

    public bool RP_ServiceArrangements_ManagementAndAdministrationServicesCollectionExists = false;
    public int RP_ServiceArrangements_ManagementAndAdministrationServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ManagementAndAdministrationServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS40 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ManagementAndAdministrationServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS41 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ManagementAndAdministrationServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS42 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ManagementAndAdministrationServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS43 = null;

    public bool RP_ServiceArrangements_InsuranceServicesCollectionExists = false;
    public int RP_ServiceArrangements_InsuranceServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:InsuranceServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS44 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:InsuranceServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS45 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:InsuranceServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS46 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:InsuranceServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS47 = null;

    public bool RP_ServiceArrangements_ReinsuranceServicesCollectionExists = false;
    public int RP_ServiceArrangements_ReinsuranceServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ReinsuranceServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS48 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ReinsuranceServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS49 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ReinsuranceServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS50 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:ReinsuranceServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS51 = null;

    public bool RP_ServiceArrangements_RAndDServicesCollectionExists = false;
    public int RP_ServiceArrangements_RAndDServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:RAndDServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS52 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:RAndDServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS53 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:RAndDServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS54 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:RAndDServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS55 = null;

    public bool RP_ServiceArrangements_SalesAndMarketingServicesCollectionExists = false;
    public int RP_ServiceArrangements_SalesAndMarketingServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SalesAndMarketingServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS56 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SalesAndMarketingServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS57 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SalesAndMarketingServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS58 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SalesAndMarketingServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS59 = null;

    public bool RP_ServiceArrangements_SoftwareAndITServicesCollectionExists = false;
    public int RP_ServiceArrangements_SoftwareAndITServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SoftwareAndITServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS60 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SoftwareAndITServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS61 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SoftwareAndITServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS62 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:SoftwareAndITServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS63 = null;

    public bool RP_ServiceArrangements_TechnicalServicesCollectionExists = false;
    public int RP_ServiceArrangements_TechnicalServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TechnicalServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS64 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TechnicalServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS65 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TechnicalServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS66 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:TechnicalServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS67 = null;

    public bool RP_ServiceArrangements_LogisticsServicesCollectionExists = false;
    public int RP_ServiceArrangements_LogisticsServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:LogisticsServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS68 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:LogisticsServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS69 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:LogisticsServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS70 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:LogisticsServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS71 = null;

    public bool RP_ServiceArrangements_AssetManagementServicesCollectionExists = false;
    public int RP_ServiceArrangements_AssetManagementServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:AssetManagementServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS72 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:AssetManagementServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS73 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:AssetManagementServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS74 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:AssetManagementServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS75 = null;

    public bool RP_ServiceArrangements_OtherServicesCollectionExists = false;
    public int RP_ServiceArrangements_OtherServicesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:OtherServices
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS76 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:OtherServices
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS77 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:OtherServices
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS78 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:OtherServices
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS79 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ServiceArrangements/:OtherServices
    /// IDS:rvctc4.02.05:InternationalDealings.Description.Text
    /// </summary>
    public string IDS80 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.DerivativeTransactions.Indicator
    /// </summary>
    public bool? IDS81 = null;

    public bool RP_DerivativesCollectionExists = false;
    public int RP_DerivativesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS82 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS83 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS84 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS85 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:rvctc4.02.20:InternationalDealings.RelatedPartyTransactionType.Code
    /// </summary>
    public List<string> IDS332Collection = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Derivatives
    /// IDS:rvctc4.02.05:InternationalDealings.DerivativesTradingGlobal.Indicator
    /// </summary>
    public bool? IDS87 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.DebtFactoringSecuritisation.Indicator
    /// </summary>
    public bool? IDS88 = null;

    public bool RP_DebtFactoringCollectionExists = false;
    public int RP_DebtFactoringCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DebtFactoring
    /// IDS:bafpr1.02.12:Expense.BookValue.Amount
    /// </summary>
    public decimal? IDS89 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DebtFactoring
    /// IDS:bafpr1.02.12:Expense.Consideration.Amount
    /// </summary>
    public decimal? IDS90 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DebtFactoring
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS91 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DebtFactoring
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS92 = null;

    public bool RP_SecuritisationCollectionExists = false;
    public int RP_SecuritisationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Securitisation
    /// IDS:bafpr1.02.12:Expense.BookValue.Amount
    /// </summary>
    public decimal? IDS93 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Securitisation
    /// IDS:bafpr1.02.12:Expense.Consideration.Amount
    /// </summary>
    public decimal? IDS94 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Securitisation
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS95 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Securitisation
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS96 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.OtherFinancialDealings.Indicator
    /// </summary>
    public bool? IDS97 = null;

    public bool RP_FinancialDealingsCollectionExists = false;
    public int RP_FinancialDealingsCollectionCount = 0;

    public bool RP_FinancialDealings_InterestBearingLoansCollectionExists = false;
    public int RP_FinancialDealings_InterestBearingLoansCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:InterestBearingLoans
    /// IDS:bafpo1.02.11:Liabilities.BorrowedAverageBalance.Amount
    /// </summary>
    public decimal? IDS98 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:InterestBearingLoans
    /// IDS:bafpo1.02.11:Assets.LoanedAverageBalance.Amount
    /// </summary>
    public decimal? IDS100 = null;

    public bool RP_FinancialDealings_InterestFreeLoansCollectionExists = false;
    public int RP_FinancialDealings_InterestFreeLoansCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:InterestFreeLoans
    /// IDS:bafpo1.02.11:Liabilities.BorrowedAverageBalance.Amount
    /// </summary>
    public decimal? IDS99 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:InterestFreeLoans
    /// IDS:bafpo1.02.11:Assets.LoanedAverageBalance.Amount
    /// </summary>
    public decimal? IDS101 = null;

    public bool RP_FinancialDealings_InterestCollectionExists = false;
    public int RP_FinancialDealings_InterestCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Interest
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS102 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Interest
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS103 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Interest
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS104 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Interest
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS105 = null;

    public bool RP_FinancialDealings_GuaranteesCollectionExists = false;
    public int RP_FinancialDealings_GuaranteesCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Guarantees
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS106 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Guarantees
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS107 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Guarantees
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS108 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Guarantees
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS109 = null;

    public bool RP_FinancialDealings_InsuranceCollectionExists = false;
    public int RP_FinancialDealings_InsuranceCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Insurance
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS110 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Insurance
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS111 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Insurance
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS112 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Insurance
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS113 = null;

    public bool RP_FinancialDealings_ReinsuranceCollectionExists = false;
    public int RP_FinancialDealings_ReinsuranceCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Reinsurance
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS114 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Reinsurance
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS115 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Reinsurance
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS116 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:Reinsurance
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS117 = null;

    public bool RP_FinancialDealings_OtherFinancialCollectionExists = false;
    public int RP_FinancialDealings_OtherFinancialCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:OtherFinancial
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS118 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:OtherFinancial
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS119 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:OtherFinancial
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS120 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:OtherFinancial
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS121 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialDealings/:OtherFinancial
    /// IDS:rvctc4.02.05:InternationalDealings.Description.Text
    /// </summary>
    public string IDS122 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeGainLoss.Indicator
    /// </summary>
    public bool? IDS333 = null;

    public bool RP_ForeignExchangeCollectionExists = false;
    public int RP_ForeignExchangeCollectionCount = 0;
    
    public List<RP_ForeignExchange> RP_ForeignExchangeCollection = null;
    
    public class RP_ForeignExchange 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignExchange
        /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeTransactionType.Code
        /// </summary>
        public string IDS422 = null;
    
        public bool RP_ForeignExchange_GainOrLossCollectionExists = false;
        public int RP_ForeignExchange_GainOrLossCollectionCount = 0;

        public List<RP_ForeignExchange_GainOrLoss> RP_ForeignExchange_GainOrLossCollection = null;

        public class RP_ForeignExchange_GainOrLoss 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignExchange/:GainOrLoss
            /// IDS:bafot.02.55:Miscellaneous.FunctionalCurrency.Code
            /// </summary>
            public string IDS423 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignExchange/:GainOrLoss
            /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeLossesHighestNominal.Amount
            /// </summary>
            public decimal? IDS336 = null;
    
            /// <summary>
            /// /xbrli:xbrl/:RP/:ForeignExchange/:GainOrLoss
            /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeGainsHighestNominal.Amount
            /// </summary>
            public decimal? IDS337 = null;
        }

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignExchange
        /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeLossesOther.Amount
        /// </summary>
        public decimal? IDS338 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ForeignExchange
        /// IDS:rvctc4.02.13:InternationalDealings.ForeignExchangeGainsOther.Amount
        /// </summary>
        public decimal? IDS339 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.OtherRevenue.Indicator
    /// </summary>
    public bool? IDS123 = null;

    public bool RP_RevenueDealingsCollectionExists = false;
    public int RP_RevenueDealingsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueDealings
    /// IDS:bafpr1.02.16:Expense.Total.Amount
    /// </summary>
    public decimal? IDS124 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueDealings
    /// IDS:bafpr1.02.26:Revenue.Total.Amount
    /// </summary>
    public decimal? IDS125 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueDealings
    /// IDS:bafot.02.11:Miscellaneous.ArmsLengthPricingMethod.Code
    /// </summary>
    public string IDS126 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueDealings
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS127 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueDealings
    /// IDS:rvctc4.02.05:InternationalDealings.Description.Text
    /// </summary>
    public string IDS128 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.CapitalNature.Indicator
    /// </summary>
    public bool? IDS129 = null;

    public bool RP_DisposalOrAcquisitionCollectionExists = false;
    public int RP_DisposalOrAcquisitionCollectionCount = 0;

    public bool RP_DisposalOrAcquisition_TangiblePropertyNonRevenueCollectionExists = false;
    public int RP_DisposalOrAcquisition_TangiblePropertyNonRevenueCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:TangiblePropertyNonRevenue
    /// IDS:bafpo1.02.11:Assets.ConsiderationPaid.Amount
    /// </summary>
    public decimal? IDS130 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:TangiblePropertyNonRevenue
    /// IDS:bafpo1.02.11:Assets.ConsiderationReceived.Amount
    /// </summary>
    public decimal? IDS131 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:TangiblePropertyNonRevenue
    /// IDS:bafot.02.11:Miscellaneous.AcquisitionsAndDisposalsPricingMethod.Code
    /// </summary>
    public string IDS132 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:TangiblePropertyNonRevenue
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS133 = null;

    public bool RP_DisposalOrAcquisition_IntellectualPropertyCollectionExists = false;
    public int RP_DisposalOrAcquisition_IntellectualPropertyCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntellectualProperty
    /// IDS:bafpo1.02.11:Assets.ConsiderationPaid.Amount
    /// </summary>
    public decimal? IDS340 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntellectualProperty
    /// IDS:bafpo1.02.11:Assets.ConsiderationReceived.Amount
    /// </summary>
    public decimal? IDS341 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntellectualProperty
    /// IDS:bafot.02.11:Miscellaneous.AcquisitionsAndDisposalsPricingMethod.Code
    /// </summary>
    public string IDS342 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntellectualProperty
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS343 = null;

    public bool RP_DisposalOrAcquisition_SharesOrOtherEquityInterestsCollectionExists = false;
    public int RP_DisposalOrAcquisition_SharesOrOtherEquityInterestsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:SharesOrOtherEquityInterests
    /// IDS:bafpo1.02.11:Assets.ConsiderationPaid.Amount
    /// </summary>
    public decimal? IDS344 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:SharesOrOtherEquityInterests
    /// IDS:bafpo1.02.11:Assets.ConsiderationReceived.Amount
    /// </summary>
    public decimal? IDS345 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:SharesOrOtherEquityInterests
    /// IDS:bafot.02.11:Miscellaneous.AcquisitionsAndDisposalsPricingMethod.Code
    /// </summary>
    public string IDS346 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:SharesOrOtherEquityInterests
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS347 = null;

    public bool RP_DisposalOrAcquisition_LoansOrDebtsCollectionExists = false;
    public int RP_DisposalOrAcquisition_LoansOrDebtsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:LoansOrDebts
    /// IDS:bafpo1.02.11:Assets.ConsiderationPaid.Amount
    /// </summary>
    public decimal? IDS348 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:LoansOrDebts
    /// IDS:bafpo1.02.11:Assets.ConsiderationReceived.Amount
    /// </summary>
    public decimal? IDS349 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:LoansOrDebts
    /// IDS:bafot.02.11:Miscellaneous.AcquisitionsAndDisposalsPricingMethod.Code
    /// </summary>
    public string IDS350 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:LoansOrDebts
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS351 = null;

    public bool RP_DisposalOrAcquisition_IntangiblePropertyCollectionExists = false;
    public int RP_DisposalOrAcquisition_IntangiblePropertyCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntangibleProperty
    /// IDS:bafpo1.02.11:Assets.ConsiderationPaid.Amount
    /// </summary>
    public decimal? IDS134 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntangibleProperty
    /// IDS:bafpo1.02.11:Assets.ConsiderationReceived.Amount
    /// </summary>
    public decimal? IDS135 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntangibleProperty
    /// IDS:bafot.02.11:Miscellaneous.AcquisitionsAndDisposalsPricingMethod.Code
    /// </summary>
    public string IDS136 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:DisposalOrAcquisition/:IntangibleProperty
    /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
    /// </summary>
    public string IDS137 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.ResearchAndDevelopmentCostPlusRemuneration.Indicator
    /// </summary>
    public bool? IDS426 = null;

    public bool RP_ResearchAndDevelopmentCollectionExists = false;
    public int RP_ResearchAndDevelopmentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ResearchAndDevelopment
    /// IDS:bafpr3.02.28:Expense.ResearchAndDevelopment.CostPlusRemuneration.Amount
    /// </summary>
    public decimal? IDS427 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ResearchAndDevelopment
    /// IDS:bafpr3.02.28:Income.ResearchAndDevelopment.CostPlusRemuneration.Amount
    /// </summary>
    public decimal? IDS428 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.ReceivedOrProvidedServicesPropertyProcessesRightsOrObligationsForNonMonetaryConsideration.Indicator
    /// </summary>
    public bool? IDS138 = null;

    public bool RP_CapitalNoPaymentCollectionExists = false;
    public int RP_CapitalNoPaymentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalNoPayment
    /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
    /// </summary>
    public string IDS139 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalNoPayment
    /// IDS:bafot.02.11:Miscellaneous.NatureOfItem.Code
    /// </summary>
    public string IDS140 = null;

    public bool RP_RevenueNoPaymentCollectionExists = false;
    public int RP_RevenueNoPaymentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueNoPayment
    /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
    /// </summary>
    public string IDS141 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueNoPayment
    /// IDS:bafot.02.11:Miscellaneous.NatureOfItem.Code
    /// </summary>
    public string IDS142 = null;

    public bool RP_CapitalNonMonetaryPaymentCollectionExists = false;
    public int RP_CapitalNonMonetaryPaymentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalNonMonetaryPayment
    /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
    /// </summary>
    public string IDS143 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CapitalNonMonetaryPayment
    /// IDS:bafot.02.11:Miscellaneous.NatureOfItem.Code
    /// </summary>
    public string IDS144 = null;

    public bool RP_RevenueNonMonetaryPaymentCollectionExists = false;
    public int RP_RevenueNonMonetaryPaymentCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueNonMonetaryPayment
    /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
    /// </summary>
    public string IDS145 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:RevenueNonMonetaryPayment
    /// IDS:bafot.02.11:Miscellaneous.NatureOfItem.Code
    /// </summary>
    public string IDS146 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.ShareBasedEmployeeRemuneration.Indicator
    /// </summary>
    public bool? IDS147 = null;

    public bool RP_ShareBasedRemunerationCollectionExists = false;
    public int RP_ShareBasedRemunerationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ShareBasedRemuneration
    /// IDS:bafpr1.02.12:Expense.DeductionsTotal.Amount
    /// </summary>
    public decimal? IDS148 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ShareBasedRemuneration
    /// IDS:bafpr1.02.12:Income.IncludedInAssessableTotal.Amount
    /// </summary>
    public decimal? IDS149 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.CostContributionArrangements.Indicator
    /// </summary>
    public bool? IDS150 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.RestructuringEvents.Indicator
    /// </summary>
    public bool? IDS151 = null;

    public bool RP_RestructuringEventCollectionExists = false;
    public int RP_RestructuringEventCollectionCount = 0;
    
    public List<RP_RestructuringEvent> RP_RestructuringEventCollection = null;
    
    public class RP_RestructuringEvent 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:pyde.02.09:OrganisationDetails.RestructuringEventEntity.Code
        /// </summary>
        public string IDS152 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:bafot.02.11:Miscellaneous.CapitalValue.Code
        /// </summary>
        public string IDS153 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:bafot.02.11:Miscellaneous.NatureOfItem.Code
        /// </summary>
        public string IDS154 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS155 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:bafot.02.23:Miscellaneous.PercentageOfDealingsWithDocumentation.Code
        /// </summary>
        public string IDS156 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:rvctc4.02.05:InternationalDealings.Description.Text
        /// </summary>
        public string IDS157 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:RestructuringEvent
        /// IDS:rvctc4.02.05:InternationalDealings.EventAnalysis.Indicator
        /// </summary>
        public bool? IDS158 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TransactionsRestructuringEventsAssetRevaluation.Indicator
    /// </summary>
    public bool? IDS159 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.BranchOperations.Indicator
    /// </summary>
    public bool? IDS160 = null;

    public bool RP_BranchOperationsInterestBearingLoansCollectionExists = false;
    public int RP_BranchOperationsInterestBearingLoansCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestBearingLoans
    /// IDS:bafpo1.02.11:Liabilities.BorrowedAverageBalance.Amount
    /// </summary>
    public decimal? IDS161 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestBearingLoans
    /// IDS:bafpo1.02.11:Assets.LoanedAverageBalance.Amount
    /// </summary>
    public decimal? IDS162 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestBearingLoans
    /// IDS:bafpr1.02.12:Expense.InterestBorrowedTotal.Amount
    /// </summary>
    public decimal? IDS163 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestBearingLoans
    /// IDS:bafpr1.02.12:Income.InterestLoanedTotal.Amount
    /// </summary>
    public decimal? IDS164 = null;

    public bool RP_BranchOperationsInterestFreeLoansCollectionExists = false;
    public int RP_BranchOperationsInterestFreeLoansCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestFreeLoans
    /// IDS:bafpo1.02.11:Liabilities.BorrowedAverageBalance.Amount
    /// </summary>
    public decimal? IDS165 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsInterestFreeLoans
    /// IDS:bafpo1.02.11:Assets.LoanedAverageBalance.Amount
    /// </summary>
    public decimal? IDS166 = null;

    public bool RP_InternalTradingCollectionExists = false;
    public int RP_InternalTradingCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:InternalTrading
    /// IDS:bafpr1.02.12:Expense.TradingStockPurchaseCosts.Amount
    /// </summary>
    public decimal? IDS167 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:InternalTrading
    /// IDS:bafpr1.02.12:Income.TradingStockSalesTotal.Amount
    /// </summary>
    public decimal? IDS168 = null;

    public bool RP_BranchOperationsOtherCollectionExists = false;
    public int RP_BranchOperationsOtherCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsOther
    /// IDS:bafot.02.11:Miscellaneous.InternallyRecordedDealingsAmountsClaimedTotal.Amount
    /// </summary>
    public decimal? IDS169 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsOther
    /// IDS:bafot.02.11:Miscellaneous.InternallyRecordedDealingsAmountsReturnedTotal.Amount
    /// </summary>
    public decimal? IDS170 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:BranchOperationsOther
    /// IDS:bafpr1.02.00:Income.Other.Description
    /// </summary>
    public string IDS171 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.FinancialArrangements.Indicator
    /// </summary>
    public bool? IDS172 = null;

    public bool RP_FinancialArrangementsCollectionExists = false;
    public int RP_FinancialArrangementsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialArrangements
    /// IDS:bafpr2.02.12:Expense.Interest.DebtReceivedAverageBalance.Amount
    /// </summary>
    public decimal? IDS173 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialArrangements
    /// IDS:bafpr2.02.12:Income.Interest.DebtProvidedAverageBalance.Amount
    /// </summary>
    public decimal? IDS174 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialArrangements
    /// IDS:bafpr2.02.12:Expense.Interest.EquityReceivedAverageBalance.Amount
    /// </summary>
    public decimal? IDS175 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:FinancialArrangements
    /// IDS:bafpr2.02.12:Income.Interest.EquityProvidedAverageBalance.Amount
    /// </summary>
    public decimal? IDS176 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.21:InternationalDealings.TaxationOfFinancialArrangements.Indicator
    /// </summary>
    public bool? IDS429 = null;

    public bool RP_TOFACollectionExists = false;
    public int RP_TOFACollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TOFA
    /// IDS:bafpr1.02.47:InternationalDealings.TaxationOfFinancialArrangementsTotalValue.Amount
    /// </summary>
    public decimal? IDS430 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TOFA
    /// IDS:bafpr1.02.47:InternationalDealings.TaxationOfFinancialArrangementsTotalGains.Amount
    /// </summary>
    public decimal? IDS431 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:TOFA
    /// IDS:bafpr1.02.47:InternationalDealings.TaxationOfFinancialArrangementsTotalLosses.Amount
    /// </summary>
    public decimal? IDS432 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TaxationOfFinancialArrangementsRulesApplied.Indicator
    /// </summary>
    public bool? IDS177 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.05:InternationalDealings.TaxTimingMethodElections.Code
    /// </summary>
    public List<string> IDS178Collection = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.InterestInControlledForeignCompaniesAndControlledForeignTrusts.Indicator
    /// </summary>
    public bool? IDS184 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestAcquired.Indicator
    /// </summary>
    public bool? IDS367 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestDisposed.Indicator
    /// </summary>
    public bool? IDS371 = null;

    public bool RP_ListedCollectionExists = false;
    public int RP_ListedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Listed
    /// IDS:bafot.02.29:Miscellaneous.ControlledForeignCompaniesTrustsInterest.Count
    /// </summary>
    public decimal? IDS185 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Listed
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestAcquired.Count
    /// </summary>
    public decimal? IDS368 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Listed
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestDisposed.Count
    /// </summary>
    public decimal? IDS372 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Listed
    /// IDS:bafot.02.38:Miscellaneous.ControlledForeignCompaniesActiveIncomeTestSatisfied.Code
    /// </summary>
    public string IDS375 = null;

    public bool RP_SpecifiedCollectionExists = false;
    public int RP_SpecifiedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Specified
    /// IDS:bafot.02.29:Miscellaneous.ControlledForeignCompaniesTrustsInterest.Count
    /// </summary>
    public decimal? IDS186 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Specified
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestAcquired.Count
    /// </summary>
    public decimal? IDS369 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Specified
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestDisposed.Count
    /// </summary>
    public decimal? IDS373 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Specified
    /// IDS:bafot.02.38:Miscellaneous.ControlledForeignCompaniesActiveIncomeTestSatisfied.Code
    /// </summary>
    public string IDS376 = null;

    public bool RP_UnlistedCollectionExists = false;
    public int RP_UnlistedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unlisted
    /// IDS:bafot.02.29:Miscellaneous.ControlledForeignCompaniesTrustsInterest.Count
    /// </summary>
    public decimal? IDS187 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unlisted
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestAcquired.Count
    /// </summary>
    public decimal? IDS370 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unlisted
    /// IDS:bafot.02.35:Miscellaneous.ControlledForeignCompanyTrustInterestDisposed.Count
    /// </summary>
    public decimal? IDS374 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unlisted
    /// IDS:bafot.02.38:Miscellaneous.ControlledForeignCompaniesActiveIncomeTestSatisfied.Code
    /// </summary>
    public string IDS377 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompaniesExcludedTaintedInterestIncome.Indicator
    /// </summary>
    public bool? IDS433 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompaniesBankingLicences.Indicator
    /// </summary>
    public bool? IDS434 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompaniesIncomeMoneyLending.Indicator
    /// </summary>
    public bool? IDS435 = null;

    public bool RP_ListedCFCAmountsCollectionExists = false;
    public int RP_ListedCFCAmountsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesExcludedTaintedInterestIncome.Amount
    /// </summary>
    public decimal? IDS436 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompanyExcludedTaintedInterestIncome.Count
    /// </summary>
    public decimal? IDS440 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
    /// </summary>
    public decimal? IDS188 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestSatisfied.Amount
    /// </summary>
    public decimal? IDS443 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestNotSatisfied.Amount
    /// </summary>
    public decimal? IDS447 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesAdjustedTaintedConcessionIncome.Amount
    /// </summary>
    public decimal? IDS378 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesAdjustedTaintedIncomeNotDerived.Amount
    /// </summary>
    public decimal? IDS379 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesOtherNotionalAssessableIncome.Amount
    /// </summary>
    public decimal? IDS380 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesNotionalAssessableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS381 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesNotionalAllowableDeductions.Amount
    /// </summary>
    public decimal? IDS451 = null;

    public bool RP_SpecifiedCFCAmountsCollectionExists = false;
    public int RP_SpecifiedCFCAmountsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesExcludedTaintedInterestIncome.Amount
    /// </summary>
    public decimal? IDS437 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompanyExcludedTaintedInterestIncome.Count
    /// </summary>
    public decimal? IDS441 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
    /// </summary>
    public decimal? IDS189 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestSatisfied.Amount
    /// </summary>
    public decimal? IDS444 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestNotSatisfied.Amount
    /// </summary>
    public decimal? IDS448 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesAdjustedTaintedIncome.Amount
    /// </summary>
    public decimal? IDS382 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesOtherNotionalAssessableIncome.Amount
    /// </summary>
    public decimal? IDS383 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesNotionalAssessableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS384 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesNotionalAllowableDeductions.Amount
    /// </summary>
    public decimal? IDS452 = null;

    public bool RP_UnlistedCFCAmountsCollectionExists = false;
    public int RP_UnlistedCFCAmountsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesExcludedTaintedInterestIncome.Amount
    /// </summary>
    public decimal? IDS438 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafot.02.55:Miscellaneous.ControlledForeignCompanyExcludedTaintedInterestIncome.Count
    /// </summary>
    public decimal? IDS442 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncome.Amount
    /// </summary>
    public decimal? IDS190 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestSatisfied.Amount
    /// </summary>
    public decimal? IDS445 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestNotSatisfied.Amount
    /// </summary>
    public decimal? IDS449 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesAdjustedTaintedIncome.Amount
    /// </summary>
    public decimal? IDS385 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesOtherNotionalAssessableIncome.Amount
    /// </summary>
    public decimal? IDS386 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesNotionalAssessableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS387 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedCFCAmounts
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesNotionalAllowableDeductions.Amount
    /// </summary>
    public decimal? IDS453 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesExcludedTaintedInterestIncomeTotal.Amount
    /// </summary>
    public decimal? IDS439 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesAttributableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS191 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesChangeOfResidenceIncome.Amount
    /// </summary>
    public decimal? IDS192 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.12:Income.ControlledForeignCompaniesAndControlledForeignTrustsInterposedAustralianEntitiesAttributableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS193 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestSatisfiedTotal.Amount
    /// </summary>
    public decimal? IDS446 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.GrossRevenueActiveIncomeTestNotSatisfiedTotal.Amount
    /// </summary>
    public decimal? IDS450 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.35:Income.ControlledForeignCompaniesNotionalAssessableIncomeTotal.Amount
    /// </summary>
    public decimal? IDS388 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.ControlledForeignCompaniesNotionalAllowableDeductionsTotal.Amount
    /// </summary>
    public decimal? IDS454 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.12:Income.ForeignBranchOperationsInterestsInForeignCompaniesOrForeignTrusts.Indicator
    /// </summary>
    public bool? IDS195 = null;

    public bool RP_ListedForeignBranchOperationsCollectionExists = false;
    public int RP_ListedForeignBranchOperationsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.ForeignBranchProfitsOfAustralianCompaniesNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS196 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.PaidOutOfAttributedControlledForeignCompanyIncomeNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS200 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ListedForeignBranchOperations
    /// IDS:bafpr1.02.22:Income.NonPortfolioDividendFromForeignCompanyNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS320 = null;

    public bool RP_SpecifiedForeignBranchOperationsCollectionExists = false;
    public int RP_SpecifiedForeignBranchOperationsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.ForeignBranchProfitsOfAustralianCompaniesNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS197 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.PaidOutOfAttributedControlledForeignCompanyIncomeNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS201 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:SpecifiedForeignBranchOperations
    /// IDS:bafpr1.02.22:Income.NonPortfolioDividendFromForeignCompanyNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS321 = null;

    public bool RP_UnlistedForeignBranchOperationsCollectionExists = false;
    public int RP_UnlistedForeignBranchOperationsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.ForeignBranchProfitsOfAustralianCompaniesNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS198 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedForeignBranchOperations
    /// IDS:bafpr1.02.12:Income.PaidOutOfAttributedControlledForeignCompanyIncomeNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS202 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:UnlistedForeignBranchOperations
    /// IDS:bafpr1.02.22:Income.NonPortfolioDividendFromForeignCompanyNonAssessableNonExemptIncome.Amount
    /// </summary>
    public decimal? IDS322 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.12:Expense.NonDeductibleExemptIncome.Amount
    /// </summary>
    public decimal? IDS199 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc2.02.09:IncomeTax.Deduction.DebtEarningNonAssessableNonExemptForeignIncome.Indicator
    /// </summary>
    public bool? IDS206 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc2.02.09:IncomeTax.Deduction.DebtEarningNonAssessableNonExemptForeignIncomeTotal.Amount
    /// </summary>
    public decimal? IDS207 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc3.02.00:CapitalGainsTax.Event.Indicator
    /// </summary>
    public bool? IDS208 = null;

    public bool RP_CGTEventsCollectionExists = false;
    public int RP_CGTEventsCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CGTEvents
    /// IDS:rvctc3.02.10:CapitalGainsTax.ActiveForeignBusinessCapitalGains.Amount
    /// </summary>
    public decimal? IDS209 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CGTEvents
    /// IDS:rvctc1.02.10:IncomeTax.ActiveForeignBusinessCapitalGainsReduction.Amount
    /// </summary>
    public decimal? IDS210 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CGTEvents
    /// IDS:rvctc3.02.10:CapitalGainsTax.ActiveForeignBusinessCapitalLosses.Amount
    /// </summary>
    public decimal? IDS211 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:CGTEvents
    /// IDS:rvctc1.02.10:IncomeTax.ActiveForeignBusinessCapitalLossesReduction.Amount
    /// </summary>
    public decimal? IDS212 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.TransferPropertyMoneyOrServices.Indicator
    /// </summary>
    public bool? IDS213 = null;

    public bool RP_TransferCollectionExists = false;
    public int RP_TransferCollectionCount = 0;
    
    public List<RP_Transfer> RP_TransferCollection = null;
    
    public class RP_Transfer 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:Transfer
        /// IDS:bafot.02.11:Miscellaneous.TransferPropertyMoneyOrServices.Amount
        /// </summary>
        public decimal? IDS214 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:Transfer
        /// IDS:pyin.02.00:Report.ItemOrder.Number
        /// </summary>
        public string IDS215 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.NonResidentTrustInterestEntitlementOrBeneficiary.Indicator
    /// </summary>
    public bool? IDS216 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.35:Miscellaneous.OffshoreDealingsCompliance.Indicator
    /// </summary>
    public bool? IDS393 = null;

    public bool RP_HubArrangementCollectionExists = false;
    public int RP_HubArrangementCollectionCount = 0;
    
    public List<RP_HubArrangement> RP_HubArrangementCollection = null;
    
    public class RP_HubArrangement 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HubArrangement
        /// IDS:bafot.02.38:Miscellaneous.HubArrangement.Code
        /// </summary>
        public string IDS394 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HubArrangement
        /// IDS:bafpr1.02.35:Expense.HubArrangementImports.Amount
        /// </summary>
        public decimal? IDS395 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HubArrangement
        /// IDS:bafpr1.02.35:Revenue.HubArrangementExports.Amount
        /// </summary>
        public decimal? IDS396 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.ForeignHybridLimitedPartnershipOrForeignHybridCompanyShareholder.Indicator
    /// </summary>
    public bool? IDS217 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:Miscellaneous.ForeignHybridLimitedPartnershipOrForeignHybridCompanyInterestIn.Count
    /// </summary>
    public decimal? IDS218 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo7.02.11:Assets.Investment.ForeignHybridLimitedPartnershipOrForeignHybridCompanyNetIncomeProfitTotal.Amount
    /// </summary>
    public decimal? IDS219 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo6.02.15:Liabilities.ThinCapitalisation.ProvisionsApplied.Indicator
    /// </summary>
    public bool? IDS220 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo6.02.21:Liabilities.ThinCapitalisation.2MillionThresholdTest.Indicator
    /// </summary>
    public bool? IDS400 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo6.02.21:Liabilities.ThinCapitalisation.90PercentAssetThresholdTest.Indicator
    /// </summary>
    public bool? IDS401 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo6.02.21:Liabilities.ThinCapitalisation.ExemptionSpecialPurposeEntities.Indicator
    /// </summary>
    public bool? IDS402 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AustralianResidentCompanyElected.Indicator
    /// </summary>
    public bool? IDS221 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
    /// </summary>
    public string IDS222 = null;

    public bool RP_ThinCapitalisationCollectionExists = false;
    public int RP_ThinCapitalisationCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.13:Liabilities.ThinCapitalisation.EntityType.Code
    /// </summary>
    public string IDS223 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.FinancialEntityType.Code
    /// </summary>
    public string IDS560 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.Amendments.Indicator
    /// </summary>
    public bool? IDS561 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.EndOfTheIncomeYearEntityType.Code
    /// </summary>
    public string IDS562 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.GeneralToFinancialStatusChange.Indicator
    /// </summary>
    public bool? IDS224 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AveragingMethodAdopted.Code
    /// </summary>
    public string IDS225 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DeductionDebt.Amount
    /// </summary>
    public decimal? IDS226 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.RelatedNonResidentsDebtDeduction.Amount
    /// </summary>
    public decimal? IDS227 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DeductionDebtDisallowed.Amount
    /// </summary>
    public decimal? IDS228 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DebtAdjustedAverage.Amount
    /// </summary>
    public decimal? IDS229 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Capital.ThinCapitalisation.InterestIncomeAndOtherAmounts.Amount
    /// </summary>
    public decimal? IDS563 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Capital.ThinCapitalisation.DerivedNonResidentInterestIncomeAndOtherAmounts.Amount
    /// </summary>
    public decimal? IDS564 = null;

    public bool RP_ThinCapitalisation_EBITDACollectionExists = false;
    public int RP_ThinCapitalisation_EBITDACollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::IncomeTax.ModifiedTaxableIncomeOrLoss.Amount
    /// </summary>
    public decimal? IDS565 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Liabilities.ThinCapitalisation.NetDeductionDebt.Amount
    /// </summary>
    public decimal? IDS566 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Liabilities.ThinCapitalisation.ModifiedDepreciationAndForestryCosts.Amount
    /// </summary>
    public decimal? IDS567 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Liabilities.ThinCapitalisation.ExcessTaxEBITDA.Amount
    /// </summary>
    public decimal? IDS568 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Liabilities.ThinCapitalisation.EntityTaxEBITDA.Amount
    /// </summary>
    public decimal? IDS569 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Capital.ThinCapitalisation.EarningsLimit.Amount
    /// </summary>
    public decimal? IDS570 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA
    /// IDS::Capital.ThinCapitalisation.TotalDisregardedAmounts.Amount
    /// </summary>
    public decimal? IDS571 = null;

    public bool RP_ThinCapitalisation_EBITDA_HighestExcessEBITDACollectionExists = false;
    public int RP_ThinCapitalisation_EBITDA_HighestExcessEBITDACollectionCount = 0;
    
    public List<RP_ThinCapitalisation_EBITDA_HighestExcessEBITDA> RP_ThinCapitalisation_EBITDA_HighestExcessEBITDACollection = null;
    
    public class RP_ThinCapitalisation_EBITDA_HighestExcessEBITDA 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA/:HighestExcessEBITDA
        /// IDS::OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string IDS572 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA/:HighestExcessEBITDA
        /// IDS::Capital.ThinCapitalisation.ControlledEntity.Amount
        /// </summary>
        public decimal? IDS573 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:EBITDA/:HighestExcessEBITDA
        /// IDS::Capital.ThinCapitalisation.ControlledEntityDividedBy.Amount
        /// </summary>
        public decimal? IDS574 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.GroupRatioTest.Indicator
    /// </summary>
    public bool? IDS575 = null;

    public bool RP_ThinCapitalisation_GroupRatioTestCollectionExists = false;
    public int RP_ThinCapitalisation_GroupRatioTestCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.GroupEntities.Count
    /// </summary>
    public decimal? IDS576 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.GroupMembers.Count
    /// </summary>
    public decimal? IDS577 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.NetThirdPartyInterestExpense.Amount
    /// </summary>
    public decimal? IDS578 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.NetProfit.Amount
    /// </summary>
    public decimal? IDS579 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.NetThirdPartyInterestExpenseAdjusted.Amount
    /// </summary>
    public decimal? IDS580 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.DepreciationAndAmortisationExpenses.Amount
    /// </summary>
    public decimal? IDS581 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.GroupTaxEBITDA.Amount
    /// </summary>
    public decimal? IDS582 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Liabilities.ThinCapitalisation.Ratio.Amount
    /// </summary>
    public decimal? IDS583 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest
    /// IDS::Capital.ThinCapitalisation.GroupRatioEarningsLimit.Amount
    /// </summary>
    public decimal? IDS584 = null;

    public bool RP_ThinCapitalisation_GroupRatioTest_GRGroupMembersCollectionExists = false;
    public int RP_ThinCapitalisation_GroupRatioTest_GRGroupMembersCollectionCount = 0;
    
    public List<RP_ThinCapitalisation_GroupRatioTest_GRGroupMembers> RP_ThinCapitalisation_GroupRatioTest_GRGroupMembersCollection = null;
    
    public class RP_ThinCapitalisation_GroupRatioTest_GRGroupMembers 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest/:GRGroupMembers
        /// IDS::OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string IDS585 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest/:GRGroupMembers
        /// IDS::Liabilities.ThinCapitalisation.GroupMemberEBITDA.Amount
        /// </summary>
        public decimal? IDS586 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest/:GRGroupMembers
        /// IDS::Liabilities.ThinCapitalisation.NetThirdPartyInterestExpenseAdjusted.Amount
        /// </summary>
        public decimal? IDS587 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:ThinCapitalisation/:GroupRatioTest/:GRGroupMembers
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS588 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.ThirdPartyDebtTest.Indicator
    /// </summary>
    public bool? IDS589 = null;

    public bool RP_ThinCapitalisation_ThirdPartyDebtTestCollectionExists = false;
    public int RP_ThinCapitalisation_ThirdPartyDebtTestCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ThirdPartyDebtTestChoice.Code
    /// </summary>
    public string IDS590 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Capital.ThinCapitalisation.EntityThirdPartyEarningsLimit.Amount
    /// </summary>
    public decimal? IDS591 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.Subsections820Dash427A.Indicator
    /// </summary>
    public bool? IDS592 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.AssetsHeldByAnotherMemberOfTheObligorGroup.Indicator
    /// </summary>
    public bool? IDS593 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.MembershipInterests820Dash427A.Indicator
    /// </summary>
    public bool? IDS594 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.MinorOrInsignificantAssetsDisregardedPursuant820Dash427A.Indicator
    /// </summary>
    public bool? IDS595 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ThirdPartyDebtInterest.Amount
    /// </summary>
    public decimal? IDS596 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ConduitFinancingArrangement.Indicator
    /// </summary>
    public bool? IDS597 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ConduitFinancer.Indicator
    /// </summary>
    public bool? IDS598 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS:pyid.02.00:Identifiers.AustralianBusinessNumber.Identifier
    /// </summary>
    public string IDS599 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ConduitFinancerCostsIncurredAndDifferFromTerms.Indicator
    /// </summary>
    public bool? IDS600 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.ConduitFinancerFinancingArrangementType.Code
    /// </summary>
    public string IDS601 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.NotConduitFinancerCostsIncurredAndDifferFromTerms.Indicator
    /// </summary>
    public bool? IDS602 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.NonConduitFinancerFinancingArrangementType.Code
    /// </summary>
    public string IDS603 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.CrossStapleArrangements.Indicator
    /// </summary>
    public bool? IDS604 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ThirdPartyDebtTest
    /// IDS::Liabilities.ThinCapitalisation.MemberOfAnObligorGroupNotIssuedByTheEntity.Indicator
    /// </summary>
    public bool? IDS605 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.SpecialPurposeVehicle.Indicator
    /// </summary>
    public bool? IDS606 = null;

    public bool RP_ThinCapitalisation_SpecialPurposeVehicleCollectionExists = false;
    public int RP_ThinCapitalisation_SpecialPurposeVehicleCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:SpecialPurposeVehicle
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DeductionDebt.Amount
    /// </summary>
    public decimal? IDS607 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:SpecialPurposeVehicle
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.RelatedNonResidentsDebtDeduction.Amount
    /// </summary>
    public decimal? IDS608 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:SpecialPurposeVehicle
    /// IDS::Liabilities.ThinCapitalisation.DebtAverage.Amount
    /// </summary>
    public decimal? IDS609 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:SpecialPurposeVehicle
    /// IDS::Capital.ThinCapitalisation.InterestIncomeAndOtherAmounts.Amount
    /// </summary>
    public decimal? IDS610 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:SpecialPurposeVehicle
    /// IDS::Capital.ThinCapitalisation.DerivedNonResidentInterestIncomeAndOtherAmounts.Amount
    /// </summary>
    public decimal? IDS611 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AuthorisedDepositTakingInstitution.Indicator
    /// </summary>
    public bool? IDS230 = null;

    public bool RP_ThinCapitalisation_AllADICollectionExists = false;
    public int RP_ThinCapitalisation_AllADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:AllADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.EquityCapitalAdjustedAverage.Amount
    /// </summary>
    public decimal? IDS231 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:AllADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.SafeHarbour.Amount
    /// </summary>
    public decimal? IDS232 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:AllADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.EquityShortfall.Amount
    /// </summary>
    public decimal? IDS233 = null;

    public bool RP_ThinCapitalisation_OutwardInvestingADICollectionExists = false;
    public int RP_ThinCapitalisation_OutwardInvestingADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.RiskWeightedAssetsAverageValue.Amount
    /// </summary>
    public decimal? IDS234 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.EquityCapitalAttributableToOverseasPermanentEstablishments.Amount
    /// </summary>
    public decimal? IDS235 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.RiskWeightedAssetsOverseasPermanentEstablishmentsAverageValueTotal.Amount
    /// </summary>
    public decimal? IDS236 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.ControlledForeignADIEntityEquityAverageValue.Amount
    /// </summary>
    public decimal? IDS237 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.Tier1PrudentialCapitalDeduction.Amount
    /// </summary>
    public decimal? IDS238 = null;

    public bool RP_ThinCapitalisation_InwardInvestingADICollectionExists = false;
    public int RP_ThinCapitalisation_InwardInvestingADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InwardInvestingADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.RiskWeightedAssetsAttributableToAustralianPermanentEstablishmentsAverage.Amount
    /// </summary>
    public decimal? IDS239 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InwardInvestingADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.DotationCapitalAverageValue.Amount
    /// </summary>
    public decimal? IDS240 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.NonAuthorisedDepositTakingInstitution.Indicator
    /// </summary>
    public bool? IDS241 = null;

    public bool RP_ThinCapitalisation_NonFinancialEntityAllNonADICollectionExists = false;
    public int RP_ThinCapitalisation_NonFinancialEntityAllNonADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssetsValueAverage.Amount
    /// </summary>
    public decimal? IDS242 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssetRevaluation.Amount
    /// </summary>
    public decimal? IDS243 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DebtMaximumAllowable.Amount
    /// </summary>
    public decimal? IDS244 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.ExcessDebt.Amount
    /// </summary>
    public decimal? IDS245 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.NonDebtLiabilitiesAverageValue.Amount
    /// </summary>
    public decimal? IDS246 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AssociateEntityDebtAverageValue.Amount
    /// </summary>
    public decimal? IDS247 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssociateEntityEquityAverageValue.Amount
    /// </summary>
    public decimal? IDS248 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AssociateEntityExcessAverageValue.Amount
    /// </summary>
    public decimal? IDS249 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonFinancialEntityAllNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ExcludedEquityInterestsAverage.Amount
    /// </summary>
    public decimal? IDS250 = null;

    public bool RP_ThinCapitalisation_FinancialEntityCollectionExists = false;
    public int RP_ThinCapitalisation_FinancialEntityCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:FinancialEntity
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ZeroCapitalAverage.Amount
    /// </summary>
    public decimal? IDS251 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:FinancialEntity
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.OnLentAverage.Amount
    /// </summary>
    public decimal? IDS252 = null;

    public bool RP_ThinCapitalisation_OutwardInvestingEntityCollectionExists = false;
    public int RP_ThinCapitalisation_OutwardInvestingEntityCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingEntity
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ControlledForeignNonAuthorisedDepositTakingInstitutionEntityEquityAverageValue.Amount
    /// </summary>
    public decimal? IDS253 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingEntity
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ControlledForeignEntityDebtAverageValue.Amount
    /// </summary>
    public decimal? IDS254 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.InvestingFinancialEntityNonAuthorisedDepositTakingInstitution.Indicator
    /// </summary>
    public bool? IDS612 = null;

    public bool RP_ThinCapitalisation_InvestingFinancialEntityNonADICollectionExists = false;
    public int RP_ThinCapitalisation_InvestingFinancialEntityNonADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssetsValueAverage.Amount
    /// </summary>
    public decimal? IDS613 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssetRevaluation.Amount
    /// </summary>
    public decimal? IDS614 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.DebtMaximumAllowable.Amount
    /// </summary>
    public decimal? IDS615 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.ExcessDebt.Amount
    /// </summary>
    public decimal? IDS616 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.NonDebtLiabilitiesAverageValue.Amount
    /// </summary>
    public decimal? IDS617 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AssociateEntityDebtAverageValue.Amount
    /// </summary>
    public decimal? IDS618 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.AssociateEntityEquityAverageValue.Amount
    /// </summary>
    public decimal? IDS619 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.AssociateEntityExcessAverageValue.Amount
    /// </summary>
    public decimal? IDS620 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ExcludedEquityInterestsAverage.Amount
    /// </summary>
    public decimal? IDS621 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ZeroCapitalAverage.Amount
    /// </summary>
    public decimal? IDS622 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:InvestingFinancialEntityNonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.OnLentAverage.Amount
    /// </summary>
    public decimal? IDS623 = null;

    public bool RP_ThinCapitalisation_OutwardInvestingFinancialEntityCollectionExists = false;
    public int RP_ThinCapitalisation_OutwardInvestingFinancialEntityCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingFinancialEntity
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ControlledForeignNonAuthorisedDepositTakingInstitutionEntityEquityAverageValue.Amount
    /// </summary>
    public decimal? IDS624 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:OutwardInvestingFinancialEntity
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ControlledForeignEntityDebtAverageValue.Amount
    /// </summary>
    public decimal? IDS625 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.ArmsLengthTests.Indicator
    /// </summary>
    public bool? IDS255 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.ArmsLengthDebt.Amount
    /// </summary>
    public decimal? IDS256 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.ArmsLengthCapitalTest.Indicator
    /// </summary>
    public bool? IDS626 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.ArmsLengthCapitalDebt.Amount
    /// </summary>
    public decimal? IDS627 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.GearingDebtCapitalTest.Indicator
    /// </summary>
    public bool? IDS257 = null;

    public bool RP_ThinCapitalisation_ADICollectionExists = false;
    public int RP_ThinCapitalisation_ADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.WorldwideGroupCapitalRatio.Fraction
    /// </summary>
    public decimal? IDS258 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:ADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.WorldwideCapital.Amount
    /// </summary>
    public decimal? IDS259 = null;

    public bool RP_ThinCapitalisation_NonADICollectionExists = false;
    public int RP_ThinCapitalisation_NonADICollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.WorldwideDebtTotal.Amount
    /// </summary>
    public decimal? IDS260 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonADI
    /// IDS:bafpo6.02.09:Liabilities.ThinCapitalisation.WorldwideEquity.Amount
    /// </summary>
    public decimal? IDS261 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonADI
    /// IDS:bafpo6.02.09:Capital.ThinCapitalisation.WorldwideGearingDebt.Amount
    /// </summary>
    public decimal? IDS262 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonADI
    /// IDS:bafpo6.02.13:Capital.ThinCapitalisation.StatementWorldwideAsset.Amount
    /// </summary>
    public decimal? IDS323 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation/:NonADI
    /// IDS:bafpo6.02.13:Capital.ThinCapitalisation.AverageAustralianAsset.Amount
    /// </summary>
    public decimal? IDS324 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.RestructuringEvents.Indicator
    /// </summary>
    public bool? IDS628 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ThinCapitalisation
    /// IDS::Liabilities.ThinCapitalisation.RestructuringEventsDescription.Text
    /// </summary>
    public string IDS629 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.11:FinancialServices.ForeignBankOrQualifyingFinancialEntity.Indicator
    /// </summary>
    public bool? IDS263 = null;

    public bool RP_NotionalAmountCollectionExists = false;
    public int RP_NotionalAmountCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmount
    /// IDS:bafot.02.11:FinancialServices.NotionalAverageBorrowings.Amount
    /// </summary>
    public decimal? IDS264 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmount
    /// IDS:bafot.02.38:FinancialServices.NotionalAverageBorrowings.Code
    /// </summary>
    public string IDS407 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmount
    /// IDS:bafot.02.11:FinancialServices.NonOffshoreBankingUnitNotionalInterest.Amount
    /// </summary>
    public decimal? IDS265 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmount
    /// IDS:bafot.02.11:FinancialServices.OffshoreBankingUnitNotionalInterest.Amount
    /// </summary>
    public decimal? IDS266 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmount
    /// IDS:bafot.02.11:FinancialServices.NotionalInterestTaxWithholding.Amount
    /// </summary>
    public decimal? IDS267 = null;

    public bool RP_NotionalDerivativeAndForeignExchangeCollectionExists = false;
    public int RP_NotionalDerivativeAndForeignExchangeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalDerivativeAndForeignExchange
    /// IDS:bafot.02.35:FinancialServices.NotionalDerivativePaid.Amount
    /// </summary>
    public decimal? IDS408 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalDerivativeAndForeignExchange
    /// IDS:bafot.02.35:FinancialServices.NotionalDerivativeReceived.Amount
    /// </summary>
    public decimal? IDS409 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalDerivativeAndForeignExchange
    /// IDS:bafot.02.35:FinancialServices.NotionalForeignExchangeTransactionPaid.Amount
    /// </summary>
    public decimal? IDS410 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalDerivativeAndForeignExchange
    /// IDS:bafot.02.35:FinancialServices.NotionalForeignExchangeTransactionReceived.Amount
    /// </summary>
    public decimal? IDS411 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.35:FinancialServices.ForeignBankOrQualifyingFinancialEntityElectedOut.Indicator
    /// </summary>
    public bool? IDS412 = null;

    public bool RP_NotionalAmountElectedOutCollectionExists = false;
    public int RP_NotionalAmountElectedOutCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmountElectedOut
    /// IDS:bafot.02.38:FinancialServices.ElectedOutNotionalAverageBorrowings.Amount
    /// </summary>
    public decimal? IDS413 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmountElectedOut
    /// IDS:bafot.02.35:FinancialServices.ElectedOutNotionalAverageBorrowings.Code
    /// </summary>
    public string IDS414 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmountElectedOut
    /// IDS:bafot.02.35:FinancialServices.ElectedOutNonOffshoreBankingUnitNotionalInterest.Amount
    /// </summary>
    public decimal? IDS415 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmountElectedOut
    /// IDS:bafot.02.35:FinancialServices.ElectedOutOffshoreBankingUnitNotionalInterest.Amount
    /// </summary>
    public decimal? IDS416 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NotionalAmountElectedOut
    /// IDS:bafot.02.35:FinancialServices.ElectedOutNotionalInterestTaxWithholding.Amount
    /// </summary>
    public decimal? IDS417 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.38:FinancialServices.NotionalPaymentDenied.Indicator
    /// </summary>
    public bool? IDS455 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.38:FinancialServices.NotionalPaymentDenied.Amount
    /// </summary>
    public decimal? IDS456 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.06:InternationalDealings.ConduitForeignIncome.Indicator
    /// </summary>
    public bool? IDS309 = null;

    public bool RP_ConduitForeignIncomeCollectionExists = false;
    public int RP_ConduitForeignIncomeCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ConduitForeignIncome
    /// IDS:rvctc4.02.01:InternationalDealings.ConduitForeignIncomeBalance.Amount
    /// </summary>
    public decimal? IDS310 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:ConduitForeignIncome
    /// IDS:rvctc4.02.00:InternationalDealings.ConduitForeignIncomeDistributed.Amount
    /// </summary>
    public decimal? IDS311 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.06:InternationalDealings.UnfrankedNonPortfolioDividendAccount.Indicator
    /// </summary>
    public bool? IDS312 = null;

    public bool RP_UnfrankedCollectionExists = false;
    public int RP_UnfrankedCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unfranked
    /// IDS:rvctc4.02.06:InternationalDealings.UnfrankedNonPortfolioDividendAccount.Amount
    /// </summary>
    public decimal? IDS313 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:Unfranked
    /// IDS:rvctc4.02.06:InternationalDealings.UnfrankedNonPortfolioAccountConduitForeignIncomeIncluded.Indicator
    /// </summary>
    public bool? IDS314 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.06:InternationalDealings.WithholdingTaxExemptNonResidentInterestPaid.Indicator
    /// </summary>
    public bool? IDS315 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.06:InternationalDealings.WithholdingTaxExemptNonResidentInterestPaid.Amount
    /// </summary>
    public decimal? IDS316 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:rvctc4.02.21:InternationalDealings.DoubleTaxAgreementFinancialInstitutionsWithholdingExemptionCountry.Code
    /// </summary>
    public string IDS317 = null;

    public bool RP_128FCollectionExists = false;
    public int RP_128FCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:128F
    /// IDS:rvctc4.02.06:InternationalDealings.WithholdingTaxExemptNonResidentInterestPaid.Amount
    /// </summary>
    public decimal? IDS318 = null;

    public bool RP_128FACollectionExists = false;
    public int RP_128FACollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:128FA
    /// IDS:rvctc4.02.06:InternationalDealings.WithholdingTaxExemptNonResidentInterestPaid.Amount
    /// </summary>
    public decimal? IDS319 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.44:Miscellaneous.HybridMismatch.Indicator
    /// </summary>
    public bool? IDS481 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionNonInclusion.Indicator
    /// </summary>
    public bool? IDS458 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Amount
    /// </summary>
    public decimal? IDS482 = null;

    public bool RP_MaterialArrangementsCollectionExists = false;
    public int RP_MaterialArrangementsCollectionCount = 0;
    
    public List<RP_MaterialArrangements> RP_MaterialArrangementsCollection = null;
    
    public class RP_MaterialArrangements 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchArrangement.Code
        /// </summary>
        public string IDS460 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS461 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Amount
        /// </summary>
        public decimal? IDS462 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionsDeniedOrIncomeInclusion.Amount
        /// </summary>
        public decimal? IDS463 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:bafot.02.51:Miscellaneous.HybridMismatchDifferenceReason.Code
        /// </summary>
        public string IDS464 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialArrangements
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPaymentRecipient.Indicator
        /// </summary>
        public bool? IDS465 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayment.Indicator
    /// </summary>
    public bool? IDS501 = null;

    public bool RP_StructuredArrangementCollectionExists = false;
    public int RP_StructuredArrangementCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:StructuredArrangement
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Amount
    /// </summary>
    public decimal? IDS502 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:StructuredArrangement
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatch.Amount
    /// </summary>
    public decimal? IDS503 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:StructuredArrangement
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionDisallowed.Amount
    /// </summary>
    public decimal? IDS504 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.OffshoreHybridMismatch.Indicator
    /// </summary>
    public bool? IDS505 = null;

    public bool RP_NonStructuredArrangementCollectionExists = false;
    public int RP_NonStructuredArrangementCollectionCount = 0;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NonStructuredArrangement
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatch.Amount
    /// </summary>
    public decimal? IDS506 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP/:NonStructuredArrangement
    /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionDisallowed.Amount
    /// </summary>
    public decimal? IDS507 = null;

    public bool RP_MaterialOffshoreHybridMismatchCollectionExists = false;
    public int RP_MaterialOffshoreHybridMismatchCollectionCount = 0;
    
    public List<RP_MaterialOffshoreHybridMismatch> RP_MaterialOffshoreHybridMismatchCollection = null;
    
    public class RP_MaterialOffshoreHybridMismatch 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchArrangement.Code
        /// </summary>
        public string IDS508 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatch.Amount
        /// </summary>
        public decimal? IDS509 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Code
        /// </summary>
        public string IDS510 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Amount
        /// </summary>
        public decimal? IDS511 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionDisallowed.Amount
        /// </summary>
        public decimal? IDS512 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:MaterialOffshoreHybridMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionDisallowedDifferenceReason.Code
        /// </summary>
        public string IDS513 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.PaymentNotTaxedOrTaxed10PercentOrLess.Indicator
    /// </summary>
    public bool? IDS468 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.44:Miscellaneous.HybridMismatchDeductions.Amount
    /// </summary>
    public decimal? IDS483 = null;

    public bool RP_HybridPayerMismatchCollectionExists = false;
    public int RP_HybridPayerMismatchCollectionCount = 0;
    
    public List<RP_HybridPayerMismatch> RP_HybridPayerMismatchCollection = null;
    
    public class RP_HybridPayerMismatch 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridPayerMismatch
        /// IDS:pyde.02.08:OrganisationDetails.InternationalRelatedPartyCountry.Code
        /// </summary>
        public string IDS470 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridPayerMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchPayments.Amount
        /// </summary>
        public decimal? IDS471 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridPayerMismatch
        /// IDS:bafot.02.55:Miscellaneous.HybridMismatchDeductionsDenied.Amount
        /// </summary>
        public decimal? IDS472 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridPayerMismatch
        /// IDS:bafot.02.51:Miscellaneous.HybridMismatchExceptionReason.Code
        /// </summary>
        public string IDS473 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafot.02.55:Miscellaneous.HybridArrangementRestructureReplacement.Indicator
    /// </summary>
    public bool? IDS474 = null;

    public bool RP_HybridArrangementRestructureCollectionExists = false;
    public int RP_HybridArrangementRestructureCollectionCount = 0;
    
    public List<RP_HybridArrangementRestructure> RP_HybridArrangementRestructureCollection = null;
    
    public class RP_HybridArrangementRestructure 
    {
        public int OccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridArrangementRestructure
        /// IDS:rvctc4.02.05:InternationalDealings.Description.Text
        /// </summary>
        public string IDS475 = null;

        /// <summary>
        /// /xbrli:xbrl/:RP/:HybridArrangementRestructure
        /// IDS:rvctc4.02.21:InternationalDealings.HybridEventAnalysis.Indicator
        /// </summary>
        public bool? IDS476 = null;
    }
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.ForeignEquityDistributionForeignTaxDeduction.Indicator
    /// </summary>
    public bool? IDS477 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.ForeignDeductionNotNonAssessableNonExempt.Amount
    /// </summary>
    public decimal? IDS478 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.DerivedBranchHybridMismatchIncome.Indicator
    /// </summary>
    public bool? IDS479 = null;
    
    /// <summary>
    /// /xbrli:xbrl/:RP
    /// IDS:bafpr1.02.45:Income.ForeignHybridIncomeNotNonAssessableNonExempt.Amount
    /// </summary>
    public decimal? IDS480 = null;

    }
}
