using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationRS;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using VaTS;
using DataContracts;
using System.Collections.Generic;

namespace Ato.CD.Inbound.TRTAMI202402
{
    public class CrossFormValidatorRS : ICrossFormValidator
    {
        private RS2018 childDocument { get; set; }

        public List<ProcessMessageDocument> response { get; private set; }

        private TRTAMI2024 parentDocument { get; set; }

        public CrossFormValidatorRS(TRTAMI2024 parent, object child)
        {
            childDocument = (RS2018)child;
            parentDocument = parent;
            response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOGEN402009();
            VRATORS000137();
            VRATORS000138();
            VRATORS000150();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.GEN.402009

        // IF (RP:entity.identifier.TFN <> PARENT RETURN:RP:entity.identifier.TFN)
        //     RETURN VALIDATION MESSAGE
        // END IF 

        public void VRATOGEN402009()
        {
            bool assertion = !parentDocument.TRTAMI4.Equals(childDocument.RPIdentifierTFN);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = "Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.GEN.402009" } }
                });
            }
        }

        #endregion

        #region VR.ATO.RS.000137
        
        // IF (PARENT RETURN <> "IITR") AND ([RS25] > 52)  
        //     RETURN VALIDATION MESSAGE
        // END IF
        
        public void VRATORS000137()
        {
            bool assertion = childDocument.RS25.GetValueOrDefault() > 52;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.RS.000137",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Number of weeks property rented must not exceed 52",                    
                    Location = "/xbrli:xbrl/tns:RealEstateProperty.RentalWeeks.Count",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000137" } }
                });
            }
        }

        #endregion

        #region VR.ATO.RS.000138
        
        // IF (PARENT RETURN <> "IITR") AND ([RS27] > 52)  
        //    RETURN VALIDATION MESSAGE
        // END IF
        
        public void VRATORS000138()
        {
            bool assertion = childDocument.RS27.GetValueOrDefault() > 52;

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.RS.000138",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Number of weeks property was available for rent this year cannot exceed 52 weeks",
                    Location = "/xbrli:xbrl/tns:RealEstateProperty.RentalWeeksAvailable.Count",
                    Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000138" } }
                });
            }
        }

        #endregion 

        #region VR.ATO.RS.000150
        
        // IF (PARENT RETURN <> "TRTAMI" AND [RS14] <> PARENT RETURN(pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text (IN TUPLE(xbrli\organisationame2.xx.xx:OrganisationNameDetails) WHERE (pyde.xx.xx:OrganisationNameDetails.OrganisationalType.Code = "MN") AND (pyde.xx.xx:OrganisationNameDetails.Currency.Code = "C")))) 
        // OR (PARENT RETURN = "TRTAMI" AND [RS14] <> PARENT RETURN:RP:pyde.xx.xx:OrganisationNameDetails.OrganisationalName.Text)
        //     RETURN VALIDATION MESSAGE
        // END IF
        
        public void VRATORS000150()
        {
            bool? assertion = !childDocument.RS14?.Trim().Equals(parentDocument.TRTAMI10.Trim());
              
            if (assertion.HasValue)
            {
                if (assertion.Value)
                {
                    response.Add(new ProcessMessageDocument
                    {
                        Code = "CMN.ATO.RS.000150",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"The Entity name must be the same as the name on the main form",
                        Location = "/xbrli:xbrl/tns:OrganisationNameDetails.OrganisationalName.Text",
                        Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.RS.000150" } }
                    });
                }
            }
        }

        #endregion

        #endregion
    }
}
