﻿using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationCGTS;
using System.Collections.Generic;

namespace Ato.CD.Inbound.Shared201802
{
    public static class CGTS2018ContextsExtension
    {
        public static List<Context> GetContexts(this CGTS2018 cgts)
        {
            var contexts = new List<Context>();

            contexts.AddContext(cgts.RPStartDate, cgts.RPEndDate, cgts.RPOccurrenceIndex, cgts.RPId).
            AddContext(cgts.RPAppliedStartDate, cgts.RPAppliedEndDate, cgts.RPAppliedOccurrenceIndex, cgts.RPAppliedId).
            AddContext(cgts.RPAppliedY0StartDate, cgts.RPAppliedY0EndDate, cgts.RPAppliedY0OccurrenceIndex, cgts.RPAppliedY0Id).
            AddContext(cgts.RPAppliedY0MinusStartDate, cgts.RPAppliedY0MinusEndDate, cgts.RPAppliedY0MinusOccurrenceIndex, cgts.RPAppliedY0MinusId).
            AddContext(cgts.RPListedCompanySharesStartDate, cgts.RPListedCompanySharesEndDate, cgts.RPListedCompanySharesOccurrenceIndex, cgts.RPListedCompanySharesId).
            AddContext(cgts.RPOtherSharesStartDate, cgts.RPOtherSharesEndDate, cgts.RPOtherSharesOccurrenceIndex, cgts.RPOtherSharesId).
            AddContext(cgts.RPListedUnitTrustsStartDate, cgts.RPListedUnitTrustsEndDate, cgts.RPListedUnitTrustsOccurrenceIndex, cgts.RPListedUnitTrustsId).
            AddContext(cgts.RPOtherUnitsStartDate, cgts.RPOtherUnitsEndDate, cgts.RPOtherUnitsOccurrenceIndex, cgts.RPOtherUnitsId).
            AddContext(cgts.RPAustralianRealPropertyStartDate, cgts.RPAustralianRealPropertyEndDate, cgts.RPAustralianRealPropertyOccurrenceIndex, cgts.RPAustralianRealPropertyId).
            AddContext(cgts.RPOverseasRealPropertyStartDate, cgts.RPOverseasRealPropertyEndDate, cgts.RPOverseasRealPropertyOccurrenceIndex, cgts.RPOverseasRealPropertyId).
            AddContext(cgts.RPCapitalGainsTrustDistributionsStartDate, cgts.RPCapitalGainsTrustDistributionsEndDate, cgts.RPCapitalGainsTrustDistributionsOccurrenceIndex, cgts.RPCapitalGainsTrustDistributionsId).
            AddContext(cgts.RPCollectablesStartDate, cgts.RPCollectablesEndDate, cgts.RPCollectablesOccurrenceIndex, cgts.RPCollectablesId).
            AddContext(cgts.RPOtherCapitalAssetsStartDate, cgts.RPOtherCapitalAssetsEndDate, cgts.RPOtherCapitalAssetsOccurrenceIndex, cgts.RPOtherCapitalAssetsId).
            AddContext(cgts.RPTransfersToOtherClassesStartDate, cgts.RPTransfersToOtherClassesEndDate, cgts.RPTransfersToOtherClassesOccurrenceIndex, cgts.RPTransfersToOtherClassesId);

            if (cgts.RPEarnoutArrangementGroupNumberContextCollection != null)
            {
                foreach (var earnoutArrangementGroupNumberContext in cgts.RPEarnoutArrangementGroupNumberContextCollection)
                {
                    contexts.AddContext(earnoutArrangementGroupNumberContext.StartDate, earnoutArrangementGroupNumberContext.EndDate, earnoutArrangementGroupNumberContext.OccurrenceIndex, earnoutArrangementGroupNumberContext.Id);
                }
            }

            return contexts;
        }
    }
}
