using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationCTR;
using Ato.EN.IntegrationServices.CodeGenerationPSS;
using VaTS;
using DataContracts;
using System.Collections.Generic;
using System.Linq;

namespace Ato.CD.Inbound.CTR202502
{
    internal class CrossFormValidatorPSS : ICrossFormValidator
    {
        private CTR2025 ParentDocument { get; }

        private PSS2018 ChildDocument { get; }

        internal CrossFormValidatorPSS(CTR2025 report, BusinessDocument childDocument)
        {
            ParentDocument = report;
            ChildDocument = (PSS2018)childDocument.ConsumedReport;
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            var response = new List<ProcessMessageDocument>();

            VRATOPSS000036(response);
            VRATOPSS000035(response);

            return response;
        }

        //CTR-PSS
        #region VR.ATO.PSS.000036
        /*
                Rule Id:  VR.ATO.PSS.000036

                WHERE IN CONTEXT(RP.Payer.{
                PSSeqNum)
                IF(RP.Payer.{ PSSeqNum}.entity.identifier.TFN<> PARENT RETURN: RP.entity.identifier.TFN)
                   RETURN VALIDATION MESSAGE
                ENDIF
             */

        private void VRATOPSS000036(List<ProcessMessageDocument> response)
        {
            if (ChildDocument.RPPayerPSSeqNumContextCollection != null)
                response.AddRange(ChildDocument.RPPayerPSSeqNumContextCollection.Select((s, i) => new { RPPayer = s, Index = i })
                .Where(c => c.RPPayer.Identifier != ParentDocument.RPIdentifierTFN).Select(c =>
                 new ProcessMessageDocument
                 {
                     Code = "CMN.ATO.PSS.000036",
                     Severity = ProcessMessageSeverity.Error,
                     Description = "Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                     Location = c.Index == 0 ? "xbrli:xbrl/xbrli:context/xbrli:entity/xbrli:identifier" : $"xbrli:xbrl/xbrli:context[{c.Index + 1}]/xbrli:entity/xbrli:identifier",
                     Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000036" } }
                 }
              ));
        }
        #endregion // VR.ATO.PSS.000036

        #region VR.ATO.PSS.000035 

        /*  VR.ATO.PSS.000035
                     Payment Type not applicable to Non-individual income tax return

                 Legacy Rule Format:
                     IF PARENT RETURN <> “IITR”
                      AND ([PSS20] <> NULLORBLANK OR [PSS21] <> NULLORBLANK OR [PSS31] <> NULLORBLANK OR [PSS24] <> NULLORBLANK OR [PSS25] <> NULLORBLANK OR [PSS32] <> NULLORBLANK)
                        RETURN VALIDATION MESSAGE
                     ENDIF


                     [PSS20] = PSS:RP.Payer.{PSSeqNum}:lrla.02.00:Remuneration.VoluntaryAgreementGross.Amount
                     [PSS21] = PSS:RP.Payer.{PSSeqNum}:lrla.02.00:Remuneration.LabourHireArrangementPaymentGross.Amount
                     [PSS24] = PSS:RP.Payer.{PSSeqNum}:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessVoluntaryAgreement.Amount
                     [PSS25] = PSS:RP.Payer.{PSSeqNum}:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldBusinessLabourHireOrOtherPayments.Amount
                     [PSS31] = PSS:RP.Payer.{PSSeqNum}:lrla.02.17:Remuneration.PersonalServicesIncome.AttributedGross.Amount
                     [PSS32] = PSS:RP.Payer.{PSSeqNum}:rvctc2.02.14:IncomeTax.PayAsYouGoWithholding.CreditTaxWithheldPersonalServicesIncome.Amount

                     */

        private void VRATOPSS000035(List<ProcessMessageDocument> response)
        {

            if (ChildDocument.RPPayerPSSeqNumContextCollection != null)
                response.AddRange(ChildDocument.RPPayerPSSeqNumContextCollection.Select((s) => new { RPPayerPSSeqNumContext = s })
                .Where(c => c.RPPayerPSSeqNumContext.PSS20.HasValue || c.RPPayerPSSeqNumContext.PSS21.HasValue || c.RPPayerPSSeqNumContext.PSS31.HasValue || c.RPPayerPSSeqNumContext.PSS24.HasValue || c.RPPayerPSSeqNumContext.PSS25.HasValue || c.RPPayerPSSeqNumContext.PSS32.HasValue).Select(c =>
                  new ProcessMessageDocument
                  {
                      Code = "CMN.ATO.PSS.000035",
                      Severity = ProcessMessageSeverity.Error,
                      Description = "Payment Type not applicable to Non-individual income tax return",
                      Location = "/xbrli:xbrl/tns:Remuneration.PaymentToForeignResidentGross.Amount[ contextRef=\"" + c.RPPayerPSSeqNumContext.Id + "\"]",
                      Parameters = new ProcessMessageParameters { new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000035" } }
                  }
                ));
        }

        #endregion // VR.ATO.PSS.000035 
    }
}