﻿using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationDISTBENTRT;
using Ato.EN.IntegrationServices.CodeGenerationTRT;
using DataContracts;
using System.Collections.Generic;
using System.Runtime.CompilerServices;

namespace Ato.CD.Inbound.TRT202502
{
    public class CrossFormValidatorDISTBENTRT : ICrossFormValidator
    {
        private TRT2025 parentDocument { get; set; }
        public List<ProcessMessageDocument> response { get; private set; }
        private DISTBENTRT2024 childDocument { get; }

        public CrossFormValidatorDISTBENTRT(TRT2025 report, object child)
        {
            parentDocument = report;
            childDocument = (DISTBENTRT2024)child;
            response = new List<ProcessMessageDocument>();
        }

        //Need add this empty function for Validator -> ValidateAssociatedDocuments calling
        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            //Parent form cross form rules
            VRATOTRT442894();
            VRATOTRT442895();
            VRATOTRT442896();
            VRATOTRTW00021();

            return response;
        }

        #region VR.ATO.TRT.442894
        /*  VR.ATO.TRT.442894
        Reporting period start date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period start date of the parent form

        Legacy Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT573 <> ^DISTBENTRT1

        Technical Business Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT573 <> ^DISTBENTRT1

        Data Elements:

        ^TRT573 = TRT:RP:Period.Start.Date
        
        ^DISTBENTRT1 = DISTBENTRT:RP:StatementOfDistributionToBeneficiary:Information:Income.DistributionFranked.Amount
        */
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public void VRATOTRT442894()
        {
            bool assertion = (childDocument.DISTBENTRT1 != null) && (childDocument.DISTBENTRT1.GetValueOrDefault() != parentDocument.TRT573.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.442894",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reporting period start date for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"Reporting period start date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period start date of the parent form",
                    Location = "/tns:TRT/tns:RP/tns:PeriodStartD",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.442894" } ,
                        new ProcessMessageParameter { Name = "TRT573", Value = parentDocument.TRT573.HasValue ? parentDocument.TRT573.Value.ToString("yyyy-MM-dd"):"Null" },
                        new ProcessMessageParameter { Name = "DISTBENTRT1", Value = childDocument.DISTBENTRT1.HasValue ?  childDocument.DISTBENTRT1.Value.ToString("yyyy-MM-dd"):"Null" },
                    },
                    DocumentSequence = "parent_doc"
                });
            }
        }
        #endregion VR.ATO.TRT.442894

        #region VR.ATO.TRT.442895
        /*  VR.ATO.TRT.442895
        Reporting period end date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period end date of the parent form

        Legacy Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT574 <> ^DISTBENTRT2

        Technical Business Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT574 <> ^DISTBENTRT2

        Data Elements:

        ^TRT574 = TRT:RP:Period.End.Date

        ^DISTBENTRT2 = DISTBENTRT:RP:Identifiers.TaxFileNumber.Identifier
        */
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public void VRATOTRT442895()
        {
            bool assertion = (childDocument.DISTBENTRT2 != null) && (childDocument.DISTBENTRT2.GetValueOrDefault() != parentDocument.TRT574.GetValueOrDefault());

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.442895",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Reporting period end date for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"Reporting period end date for the Distributions to Beneficiaries of Trust schedule must be the same as the Reporting period end date of the parent form",
                    Location = "/tns:TRT/tns:RP/tns:PeriodEndD",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.442895" } ,
                        new ProcessMessageParameter { Name = "TRT574", Value = parentDocument.TRT574.HasValue ? parentDocument.TRT574.Value.ToString("yyyy-MM-dd"):"Null" },
                        new ProcessMessageParameter { Name = "DISTBENTRT1", Value = childDocument.DISTBENTRT2.HasValue ?  childDocument.DISTBENTRT2.Value.ToString("yyyy-MM-dd"):"Null" },
                    },
                    DocumentSequence = "parent_doc"
                });
            }
        }
        #endregion VR.ATO.TRT.442895

        #region VR.ATO.TRT.442896
        /*  VR.ATO.TRT.442896
        The Tax File Number (TFN) provided for the Distributions to Beneficiaries of Trust schedule must be the same as the TFN of the parent form

        Legacy Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT5 <> ^DISTBENTRT3

        Technical Business Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT5 <> ^DISTBENTRT3

        Data Elements:

        ^TRT5 = TRT:RP:Identifiers.TaxFileNumber.Identifier
        
        ^DISTBENTRT3 = DISTBENTRT:RP:Identifiers.TaxFileNumber.Identifier
        */
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public void VRATOTRT442896()
        {
            bool assertion = (childDocument.DISTBENTRT3 != null) && (childDocument.DISTBENTRT3 != null) && (childDocument.DISTBENTRT3 != parentDocument.TRT5);

            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.442896",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax File Number for the Distributions to Beneficiaries of Trust schedule is invalid",
                    LongDescription = @"The Tax File Number (TFN) provided for the Distributions to Beneficiaries of Trust schedule must be the same as the TFN of the parent form",
                    Location = "/tns:TRT/tns:RP/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.442896" } ,
                        new ProcessMessageParameter { Name = "TRT5", Value = parentDocument.TRT574.HasValue ? parentDocument.TRT5.ToString():"Null" },
                        new ProcessMessageParameter { Name = "DISTBENTRT3", Value = childDocument.DISTBENTRT3.ToString() },
                    },
                    DocumentSequence = "parent_doc"
                });
            }
        }
        #endregion VR.ATO.TRT.442896

        #region VR.ATO.TRT.W00021
        /*  VR.ATO.TRT.W00021
        Distributions to Beneficiaries of Trust schedule is provided but Trust distributions - Income amounts or credits are not declared

        Legacy Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT77 = NULL AND ^TRT81 = NULL AND ^TRT437 = NULL AND ^TRT85 = NULL

        Technical Business Rule Format:
        CountDocument('DISTBENTRT') = 1 AND ^TRT77 = NULL AND ^TRT81 = NULL AND ^TRT437 = NULL AND ^TRT85 = NULL

        Data Elements:
    
        ^TRT77 = TRT:RP:BusinessDetails:Income:PartnershipsTrustsPrimaryProduction:Income.TrustShareNet.Amount
    
        ^TRT81 = TRT:RP:BusinessDetails:Income:PartnershipTrustNonPrimaryProduction:Income.TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked.Amount
    
        ^TRT85 = TRT:RP:BusinessDetails:Income:ShareOfCredits:IncomeTax.FrankingCredits.FrankingCreditShareReceivedIndirectly.Amount
    
        ^TRT437 = TRT:RP:BusinessDetails:Income:PartnershipTrustNonPrimaryProduction:Income.TrustDistributionFranked.Amount
        */
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public void VRATOTRTW00021()
        {
            bool assertion = (!parentDocument.TRT77.HasValue) && (!parentDocument.TRT81.HasValue) && (!parentDocument.TRT85.HasValue) && (!parentDocument.TRT437.HasValue);
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.TRT.W00021",
                    Severity = ProcessMessageSeverity.Warning,
                    Description = @"Ensure Trust distributions - Income amounts or credits from trusts income are declared",
                    LongDescription = @"Ensure Trust distributions - Income amounts or credits are declared when Distributions to Beneficiaries of Trust schedule is provided",
                    Location = "/tns:TRT/tns:RP/tns:BusinessDetails/tns:Income/tns:PartnershipsTrustsPrimaryProduction/tns:TrustShareNetA",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.TRT.W00021" },
                        new ProcessMessageParameter { Name = "TRT77", Value = parentDocument.TRT77.HasValue ? parentDocument.TRT77.GetValueOrDefault().ToString(): "null" },
                        new ProcessMessageParameter { Name = "TRT81", Value = parentDocument.TRT81.HasValue ? parentDocument.TRT81.GetValueOrDefault().ToString(): "null" },
                        new ProcessMessageParameter { Name = "TRT85", Value = parentDocument.TRT85.HasValue ? parentDocument.TRT85.GetValueOrDefault().ToString(): "null" },
                        new ProcessMessageParameter { Name = "TRT437", Value = parentDocument.TRT437.HasValue ? parentDocument.TRT437.GetValueOrDefault().ToString(): "null"}
                    },
                    DocumentSequence = "parent_doc"
                });
            }
        }
        #endregion VR.ATO.TRT.W00021

    }
}