using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationPSS;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using DataContracts;
using System.Collections.Generic;
using System.Linq;

namespace Ato.CD.Inbound.TRTAMI202502
{
    public class CrossFormValidatorPSS : ICrossFormValidator
    {
        private PSS2018 childDocument { get; set; }

        public List<ProcessMessageDocument> response { get; private set; }

        private TRTAMI2025 parentDocument { get; set; }

        public CrossFormValidatorPSS(TRTAMI2025 parent, object child)
        {
            childDocument = (PSS2018)child;
            parentDocument = parent;
            response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOPSS000035();
            VRATOPSS000036();

            return response;
        }

        #region Validation Rules

        #region VR.ATO.PSS.000035

        /*  VR.ATO.PSS.000035
        Payment Type not applicable to Non-individual income tax return

        Legacy Rule Format:
            IF PARENT RETURN <> “IITR” AND ([PSS20] <> NULL OR [PSS21] <> NULL OR [PSS31] <> NULL OR [PSS24] <> NULL OR [PSS25] <> NULL OR [PSS32] <> NULL)
              RETURN VALIDATION MESSAGE
            ENDIF

        Technical Business Rule Format:
            PARENT <> 'IITR' AND (^PSS20 <> NULL OR ^PSS21 <> NULL OR ^PSS31 <> NULL OR ^PSS24 <> NULL OR ^PSS25 <> NULL OR ^PSS32 <> NULL)
        */
        public void VRATOPSS000035()
        {
            if (childDocument.RPPayerPSSeqNumContextCollection != null)
            {
                IEnumerable<PSS2018.RPPayerPSSeqNumContext> rpPayerPSSeqNumContexts = childDocument.RPPayerPSSeqNumContextCollection.Where(
                    context => context.PSS20.HasValue || context.PSS21.HasValue || context.PSS24.HasValue || context.PSS25.HasValue || context.PSS31.HasValue || context.PSS32.HasValue );

                IEnumerable<ProcessMessageDocument> processMessages = rpPayerPSSeqNumContexts.Select(context =>
                    new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.PSS.000035",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Payment Type not applicable to Non-individual income tax return",
                        Location = $"/xbrli:xbrl/tns:Remuneration.PaymentToForeignResidentGross.Amount[contextRef=\"{context.Id}\"]",
                        Parameters = new ProcessMessageParameters {
                            new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000035" },
                            new ProcessMessageParameter { Name = "PSS20", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS20)},
                            new ProcessMessageParameter { Name = "PSS21", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS21)},
                            new ProcessMessageParameter { Name = "PSS24", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS24)},
                            new ProcessMessageParameter { Name = "PSS25", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS25)},
                            new ProcessMessageParameter { Name = "PSS31", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS31)},
                            new ProcessMessageParameter { Name = "PSS32", Value = TRTAMI2025Validator.GetValueOrEmpty(context.PSS32)}
                        }
                    }
                );

                response.AddRange(processMessages);
            }
        }

        #endregion

        #region VR.ATO.PSS.000036

        /*  VR.ATO.PSS.000036
        Your supplied TFN does not match the TFN supplied on the form it was submitted with

        Legacy Rule Format:
            WHERE IN CONTEXT (RP.Payer.{PSSeqNum})
              IF (RP.Payer.{PSSeqNum}.entity.identifier.TFN <> PARENT RETURN:RP.entity.identifier.TFN)
              RETURN VALIDATION MESSAGE
            ENDIF

        Technical Business Rule Format:
            (^TFN <> PARENT:RP.^TFN2)
        */
        public void VRATOPSS000036()
        {
            if (childDocument.RPPayerPSSeqNumContextCollection != null)
            {
                IEnumerable<PSS2018.RPPayerPSSeqNumContext> rpPayerPSSeqNumContexts = childDocument.RPPayerPSSeqNumContextCollection.Where(context => context.IdentifierTFN != parentDocument.TRTAMI4);

                IEnumerable<ProcessMessageDocument> processMessages = rpPayerPSSeqNumContexts.Select(context =>
                    new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.PSS.000036",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                        Location = $"/xbrli:xbrl/xbrli:context[{ context.Id }]/xbrli:entity/xbrli:identifier",
                        Parameters = new ProcessMessageParameters {
                            new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.PSS.000036" },
                            new ProcessMessageParameter { Name = "TRTAMI4", Value = TRTAMI2025Validator.GetValueOrEmpty(parentDocument.TRTAMI4) },
                            new ProcessMessageParameter { Name = "PSSTFN", Value =  TRTAMI2025Validator.GetValueOrEmpty(context.IdentifierTFN) }
                        }
                    }
                );

                response.AddRange(processMessages);
            }
        }

        #endregion

        #endregion
    }
}