﻿using DataContracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using static Ato.EN.IntegrationServices.CodeGenerationPAYEVNTEMPRequest2020.PAYEVNTEMP2020;
using static Ato.EN.IntegrationServices.CodeGenerationPAYEVNTEMPRequest2020.PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration;

namespace Ato.EN.IntegrationServices.CodeGenerationPAYEVNTEMPRequest2020
{
    public abstract class PAYEVNTEMP2020RequestValidatorBase
    {
        public abstract List<ProcessMessageDocument> ValidateReport(PAYEVNTEMP2020 report);

        #region Functions
        public static IEnumerable<string> Union(IEnumerable<string> list1, IEnumerable<string> list2)
        {
            IEnumerable<string> response;

            if (list1 == null && list2 == null)
            {
                response = null;
            }
            else if (list1 == null)
            {
                response = list2.Distinct();
            }
            else if (list2 == null)
            {
                response = list1.Distinct();
            }
            else
            {
                response = list1.Union(list2);
            }

            return response;
        }

        public static bool IsMatch(int? field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(Convert.ToString(field.Value), expression, options);
        }

        public static bool IsMatch(string field, string expression, RegexOptions options = RegexOptions.None)
        {
            if (field == null)
                return false;
            else
                return Regex.IsMatch(field, expression, options);
        }

        // This is just context and tuple counts where they are integer values - easier that changing the parsing logic to just return the value
        public static int Count(int count)
        {
            return count;
        }

        public static int Count<T>(IEnumerable<T> values)
        {
            return values == null ? 0 : values.Where(f => f != null).Count();
        }


        public static int Count<T>(ICollection<T> values)
        {
            return values == null ? 0 : values.Where(f => f != null).Count();
        }


        public static bool exists(bool value)
        {
            return value;
        }

        public static string GetValueOrEmpty(bool? val)
        {
            return (val.HasValue) ? val.ToString().ToLower() : string.Empty;
        }

        public static string GetValueOrEmpty(DateTime? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        public static string GetValueOrEmpty(string val)
        {
            return !string.IsNullOrWhiteSpace(val) ? val : string.Empty;
        }

        public static string GetValueOrEmpty(decimal? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        public static string GetValueOrEmpty(int? val)
        {
            return (val.HasValue) ? val.ToString() : string.Empty;
        }

        /// <summary>
        /// Get string value between [first] a and [last] b.
        /// </summary>
        public static string Between(string value, string a, string b)
        {
            int posA = value.IndexOf(a);
            int posB = value.LastIndexOf(b);
            if (posA == -1)
            {
                return "";
            }
            if (posB == -1)
            {
                return "";
            }
            int adjustedPosA = posA + a.Length;
            if (adjustedPosA >= posB)
            {
                return "";
            }
            return value.Substring(adjustedPosA, posB - adjustedPosA);
        }

        /// <summary>
        /// Get string value after [first] a.
        /// </summary>
        public static string Before(string value, string a)
        {
            int posA = value.IndexOf(a);
            if (posA == -1)
            {
                return "";
            }
            return value.Substring(0, posA);
        }

        /// <summary>
        /// Get string value after [last] a.
        /// </summary>
        public static string After(string value, string a)
        {
            int posA = value.LastIndexOf(a);
            if (posA == -1)
            {
                return "";
            }
            int adjustedPosA = posA + a.Length;
            if (adjustedPosA >= value.Length)
            {
                return "";
            }
            return value.Substring(adjustedPosA);
        }

        public static int Length(object field)
        {
            if (field == null)
                return 0;
            else
                return field.ToString().Trim().Length;
        }

        public static bool NotSameValues(IEnumerable<object> nodes)
        {
            if (nodes == null)
                return false;

            object[] nodesArray = nodes.Cast<object>().ToArray();
            return NotSameValues(nodesArray);
        }

        public static bool NotSameValues(params object[] nodes)
        {
            if (nodes == null)
                return false;

            return ((from x in nodes select x).Distinct().Count() == nodes.Count());
        }

        private static bool HasDuplicateValues(IEnumerable<object> nodes)
        {
            if (nodes == null)
                return false;

            object[] nodesArray = nodes.Cast<object>().ToArray();
            return HasDuplicateValues(nodesArray);
        }

        private static bool HasDuplicateValues(params object[] nodes)
        {
            if (nodes == null)
                return false;

            nodes = nodes.Where(x => x != null).ToArray();
            return !((from x in nodes select x).Distinct().Count() == nodes.Count());

        }

        public static int DuplicateValueIndex(IEnumerable<object> values)
        {
            int response = 0;
            var hashset = new HashSet<object>();
            foreach (var value in values)
            {
                if (!hashset.Add(value))
                {
                    return response;
                }
                response++;
            }
            return response;
        }

        public static int DuplicateValueIndex<T>(IEnumerable<T?> values) where T : struct
        {
            int response = 0;
            var hashset = new HashSet<T?>();
            foreach (var value in values)
            {
                if (!hashset.Add(value))
                {
                    return response;
                }
                response++;
            }
            return response;
        }

        public static bool IsDate(object value)
        {
            DateTime dateValue;
            return (value != null && DateTime.TryParse(value.ToString(), out dateValue));
        }

        public static DateTime AsDate(string dateAsString)
        {
            DateTime response = DateTime.MinValue;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date;
            }

            return response;
        }
        //The logic in After function expects "---" for day and "--" for month. 
        //Since hyphen was missing the date always returned null
        public static DateTime? ConvertToDate(int day, int month, int year)
        {
            return ConvertToDate(day == 0 ? null : "---" + day.ToString(), month == 0 ? null : "--" + month.ToString(), year == 0 ? null : year.ToString());
        }

        public static DateTime? ConvertToDate(string day, string month, string year)
        {
            DateTime? response;
            DateTime result;

            if (year == null || month == null || day == null)
            {
                return null;
            }
            string dateAsString = year + "-" + After(month, "--") + "-" + After(day, "---");
            if (DateTime.TryParse(dateAsString, out result))
            {
                response = result;
            }
            else
            {
                response = null;
            }
            return response;
        }


        public static DateTime? ConvertToDate(string day, string month, int year)
        {
            DateTime? response;
            DateTime result;

            if (year == 0 || month == null || day == null)
            {
                return null;
            }
            string dateAsString = year.ToString() + "-" + After(month, "--") + "-" + After(day, "---");
            if (DateTime.TryParse(dateAsString, out result))
            {
                response = result;
            }
            else
            {
                response = null;
            }
            return response;
        }


        public static int Day(string dateAsString)
        {
            int response = 0;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date.Day;
            }

            return response;
        }


        public static int Day(DateTime? date)
        {
            if (date == null)
                return 0;
            else
                return date.Value.Day;

        }


        public static string Month(string dateAsString)
        {
            string response = null;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date.ToString("MMMM");
            }
            else
            {
                return "NotAMonth";
            }

            return response;
        }

        public static string Month(DateTime? date)
        {
            if (date == null)
                return "NotAMonth";
            else
                return date.Value.ToString("MMMM");
        }


        public static int MonthAsInt(string dateAsString)
        {
            int response = 0;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date.Month;
            }

            return response;
        }

        public static int MonthAsInt(DateTime? date)
        {
            if (date == null)
            {
                return 0;
            }
            return date.Value.Month;
        }


        public static int Year(string dateAsString)
        {
            int response = 0;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
            {
                response = date.Year;
            }

            return response;
        }

        public static int Year(DateTime? date)
        {
            if (date == null)
                return 0;
            else
                return date.Value.Year;
        }


        public static int CurrentFinancialYear()
        {
            return DateToFinancialYear(DateTime.Now, 7);
        }

        public static int FinancialYear(string dateAsString)
        {
            return DateToFinancialYear(dateAsString, 7);
        }

        public static int FinancialYear(DateTime? date)
        {
            return DateToFinancialYear(date, 7);
        }

        public static int DateToFinancialYear(string dateAsString, int startingMonth)
        {
            int response = 0;
            DateTime date;
            if (DateTime.TryParse(dateAsString, out date))
            {
                response = DateToFinancialYear(date, startingMonth);
            }

            return response;
        }
        public static int DateToFinancialYear(DateTime? date, int startingMonth)
        {
            int response;
            if (date == null)
            {
                response = 0;
            }
            else
            {
                int year = date.Value.Year;
                int month = date.Value.Month;

                if (startingMonth > month)
                    response = year;
                else
                    response = year + 1;
            }
            return response;
        }


        public static int FBTYear(string dateAsString)
        {
            int response = 0;
            DateTime date;

            if (DateTime.TryParse(dateAsString, out date))
                response = FBTYear(date);
            return response;
        }

        public static int FBTYear(DateTime? date)
        {
            if (date == null)
            {
                return 0;
            }
            else
            {
                if (date.Value.Month > 3)
                    return date.Value.Year + 1;
                else
                    return date.Value.Year;
            }
        }


        public static bool IsNumeric(object value)
        {
            decimal numbervalue;
            return (value != null && decimal.TryParse(value.ToString(), out numbervalue));
        }

        public static bool NotMonetary(decimal? field, string sign, int digits, int decimals)
        {
            if (field == null)
            {
                return false;
            }
            else
            {
                string signExpression;
                string decimalExpression;
                int digitsToUse = digits - decimals;

                if (sign == "U")
                    signExpression = "^";
                else
                    signExpression = "^-?";

                if (decimals > 0)
                    decimalExpression = @"(\.\d{1," + decimals + "})?$";
                else
                    decimalExpression = @"$";

                return !(Regex.IsMatch(field.Value.ToString("0.#########################"), signExpression + @"\d{1," + digitsToUse + "}" + decimalExpression));
            }
        }

        public static bool NotNumeric(decimal? field, string sign, int digits, int decimals)
        {
            if (field == null)
            {
                return false;
            }
            else
            {
                string signExpression;
                string decimalExpression;
                int digitsToUse = digits - decimals;

                if (sign == "U")
                    signExpression = "^";
                else
                    signExpression = "^-?";

                if (decimals > 0)
                    decimalExpression = @"(\.\d{1," + decimals + "})?$";
                else
                    decimalExpression = @"$";

                return !(Regex.IsMatch(field.Value.ToString("0.#########################"), signExpression + @"\d{1," + digitsToUse + "}" + decimalExpression));
            }
        }

        public static bool NotNumeric(int? field, string sign, int digits, int decimals = 0)
        {
            if (field == null)
            {
                return false;
            }
            else
            {
                string signExpression;

                if (sign == "U")
                    signExpression = "^";
                else
                    signExpression = "^-?";

                return !(Regex.IsMatch(field.Value.ToString(), signExpression + @"\d{1," + digits + "}$"));
            }
        }

        public static bool NotNumeric(long? field, string sign, int digits, int decimals = 0)
        {
            if (field == null)
            {
                return false;
            }
            else
            {
                string signExpression;

                if (sign == "U")
                    signExpression = "^";
                else
                    signExpression = "^-?";

                return !(Regex.IsMatch(field.Value.ToString(), signExpression + @"\d{1," + digits + "}$"));
            }
        }


        public static bool OutsideRange(decimal field, decimal expression, int range)
        {
            bool response;

            response = (field < (expression - range)) || (field > (expression + range));

            return response;
        }


        public static bool FailsUSIAlgorithm(string usi, string abn)
        {
            bool response;
            if (usi == null || abn == null)
            {
                response = false;
            }
            else
            {
                usi = usi.Trim();
                abn = abn.Trim();
                if (usi.Length < 13 || abn.Length < 11)
                {
                    response = false;
                }
                else
                {
                    int numeric;
                    if (usi.Substring(0, 11) == abn && int.TryParse(usi.Substring(11, 2), out numeric))
                        response = false;
                    else if (Regex.IsMatch(usi, @"^[a-zA-Z]{3}\d{4}[a-zA-Z]{2}"))
                        response = false;
                    else
                        response = true;
                }
            }
            return response;
        }


        public static bool FailsTANAlgorithm(string tan)
        {
            bool response;
            decimal decimalTan;

            if (tan == null)
                return false;

            tan = tan.Trim();

            if (!decimal.TryParse(tan, out decimalTan))
                return true;

            if (tan.Length != 8)
                return true;

            decimal tanSum =
                7 * int.Parse(tan.Substring(0, 1)) +
                9 * int.Parse(tan.Substring(1, 1)) +
                8 * int.Parse(tan.Substring(2, 1)) +
                4 * int.Parse(tan.Substring(3, 1)) +
                6 * int.Parse(tan.Substring(4, 1)) +
                3 * int.Parse(tan.Substring(5, 1)) +
                5 * int.Parse(tan.Substring(6, 1)) +
                1 * int.Parse(tan.Substring(7, 1));

            if ((tanSum % 11) == 0)
                response = false;
            else
                response = true;

            return response;
        }


        public static bool FailsABNAlgorithm(string abn)
        {
            bool response;
            decimal decimalAbn;

            if (abn == null)
                return false;

            abn = abn.Trim();

            if (!decimal.TryParse(abn, out decimalAbn))
                return true;

            if (abn.Length != 11)
                return true;

            decimal abnSum =
                10 * (int.Parse(abn.Substring(0, 1)) - 1) +
                1 * int.Parse(abn.Substring(1, 1)) +
                3 * int.Parse(abn.Substring(2, 1)) +
                5 * int.Parse(abn.Substring(3, 1)) +
                7 * int.Parse(abn.Substring(4, 1)) +
                9 * int.Parse(abn.Substring(5, 1)) +
                11 * int.Parse(abn.Substring(6, 1)) +
                13 * int.Parse(abn.Substring(7, 1)) +
                15 * int.Parse(abn.Substring(8, 1)) +
                17 * int.Parse(abn.Substring(9, 1)) +
                19 * int.Parse(abn.Substring(10, 1));

            if ((abnSum % 89) == 0)
                response = false;
            else
                response = true;

            return response;
        }
        public static bool FailsACNAlgorithm(string acn)
        {
            bool response;
            decimal decimalAbn;
            if (acn == null)
                return false;

            acn = acn.Trim();

            if (!decimal.TryParse(acn, out decimalAbn))
                return true;

            if (acn.Length != 9)
                return true;

            decimal abnSum =
                8 * int.Parse(acn.Substring(0, 1)) +
                7 * int.Parse(acn.Substring(1, 1)) +
                6 * int.Parse(acn.Substring(2, 1)) +
                5 * int.Parse(acn.Substring(3, 1)) +
                4 * int.Parse(acn.Substring(4, 1)) +
                3 * int.Parse(acn.Substring(5, 1)) +
                2 * int.Parse(acn.Substring(6, 1)) +
                1 * int.Parse(acn.Substring(7, 1));

            decimal checkDigit = int.Parse(acn.Substring(8, 1));
            decimal acnRemainder = abnSum % 10;

            if (((10 - acnRemainder) % 10) == checkDigit)
                response = false;
            else
                response = true;

            return response;
        }


        public static bool FailsTFNAlgorithm(string tfn)
        {
            bool response;
            decimal decimalTfn;

            if (tfn == null)
                return false;

            tfn = tfn.Trim();
            tfn = Regex.Replace(tfn, "^0+", "");

            if (!decimal.TryParse(tfn, out decimalTfn))
                return true;

            if (tfn.Length < 8)
                return true;


            decimal tfn1To7Sum =
                1 * int.Parse(tfn.Substring(0, 1)) +
                4 * int.Parse(tfn.Substring(1, 1)) +
                3 * int.Parse(tfn.Substring(2, 1)) +
                7 * int.Parse(tfn.Substring(3, 1)) +
                5 * int.Parse(tfn.Substring(4, 1)) +
                8 * int.Parse(tfn.Substring(5, 1)) +
                6 * int.Parse(tfn.Substring(6, 1));

            decimal tfn8 = 9 * int.Parse(tfn.Substring(7, 1));

            if (tfn.Length == 8)
            {
                decimal tFNLg8WSum9 = 10 * int.Parse(tfn.Substring(7, 1));
                decimal tFNLg8WSum = tfn1To7Sum + tFNLg8WSum9;

                if ((tFNLg8WSum % 11) == 0)
                    response = false;
                else
                    response = true;
            }
            else if (tfn.Length == 9)
            {
                decimal tfn9 = 10 * int.Parse(tfn.Substring(8, 1));
                decimal tFNLg9WSum = tfn1To7Sum + tfn8 + tfn9;

                if ((tFNLg9WSum % 11) == 0)
                    response = false;
                else
                    response = true;
            }
            else
            {
                response = true;
            }

            return response;
        }


        public static decimal ConditionalValue(bool expression, decimal? trueVal, decimal? falseVal)
        {
            return expression ? trueVal.GetValueOrDefault() : falseVal.GetValueOrDefault();
        }

        public static decimal AsNumeric(string value)
        {
            decimal numberValue;
            decimal.TryParse(value, out numberValue);
            return numberValue;
        }

        public static bool RegexMatch(int? field, string expression, string flags = "")
        {
            return IsMatch(field, expression, GetRegexOption(flags));
        }

        public static bool RegexMatch(string field, string expression, string flags = "")
        {
            return IsMatch(field, expression, GetRegexOption(flags));
        }

        public static RegexOptions GetRegexOption(string flags)
        {
            RegexOptions options = RegexOptions.None;

            char[] characters = flags.ToCharArray();

            foreach (char character in characters)
            {
                switch (character)
                {
                    case 'i':
                        options = options | RegexOptions.IgnoreCase;
                        break;
                    case 'm':
                        options = options | RegexOptions.Multiline;
                        break;
                    case 's':
                        options = options | RegexOptions.Singleline;
                        break;
                    case 'n':
                        options = options | RegexOptions.ExplicitCapture;
                        break;
                    case 'x':
                        options = options | RegexOptions.IgnorePatternWhitespace;
                        break;
                }
            }

            return options;
        }

        public static string Substring(object field, int start, int length)
        {
            return field.ToString().Substring(start, length);
        }

        /// <summary>
        /// Returns an occurrence index as [occurrenceIndex] of occurrenceIndex > 0, otherwise the empty string
        /// </summary>
        /// <param name="occurrenceIndex">Index of the occurrence.</param>
        /// <returns>Occurrence in XPath [#] format</returns>
        public static string OccurrenceIndex(int occurrenceIndex)
        {
            return "[" + occurrenceIndex + "]";
        }
        #endregion

        #region VR.ATO.PAYEVNTEMP.000019

        /*  VR.ATO.PAYEVNTEMP.000019
        The Tax File Number (TFN) has failed the algorithm check.

        Legacy Rule Format:
        (^PAYEVNTEMP13 <> NULL AND NotInSet(^PAYEVNTEMP13,'"000000000","111111111","333333333","444444444"') AND FailsTFNAlgorithm(^PAYEVNTEMP13))

        Technical Business Rule Format:
        (^PAYEVNTEMP13 <> NULL AND NotInSet(^PAYEVNTEMP13,'"000000000","111111111","333333333","444444444"') AND FailsTFNAlgorithm(^PAYEVNTEMP13))

        Data Elements:

        ^PAYEVNTEMP13 = PAYEVNTEMP:Payee:Identifiers:Identifiers.TaxFileNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000019(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP13 != null && !(IsMatch(report.PAYEVNTEMP13, @"^(000000000|111111111|333333333|444444444)$", RegexOptions.IgnoreCase)) && FailsTFNAlgorithm(report.PAYEVNTEMP13));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.402043",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"TFN must be a valid TFN",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000019" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP13", Value = GetValueOrEmpty(report.PAYEVNTEMP13) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000019

        #region VR.ATO.PAYEVNTEMP.000033

        /*  VR.ATO.PAYEVNTEMP.000033
        When the address is in Australia or blank, the State / Territory must be supplied.

        Legacy Rule Format:
        (^PAYEVNTEMP27 = NULL OR ^PAYEVNTEMP27 = "au") AND (^PAYEVNTEMP24 = NULL)

        Technical Business Rule Format:
        (^PAYEVNTEMP27 = NULL OR ^PAYEVNTEMP27 = 'au') AND (^PAYEVNTEMP24 = NULL)

        Data Elements:

        ^PAYEVNTEMP24 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.StateOrTerritory.Code

        ^PAYEVNTEMP27 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000033(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.PAYEVNTEMP27 == null || report.PAYEVNTEMP27 == @"au") && report.PAYEVNTEMP24 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.300006",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"For an Australian address, the state or territory must be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:AddressDetails/tns:StateOrTerritoryC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000033" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP27", Value = GetValueOrEmpty(report.PAYEVNTEMP27) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP24", Value = GetValueOrEmpty(report.PAYEVNTEMP24) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000033

        #region VR.ATO.PAYEVNTEMP.000034

        /*  VR.ATO.PAYEVNTEMP.000034
        The Postcode must be in the range of '0200-9999'.

        Legacy Rule Format:
        (^PAYEVNTEMP25 <> NULL AND (AsNumeric(^PAYEVNTEMP25) < 200 OR AsNumeric(^PAYEVNTEMP25) > 9999))

        Technical Business Rule Format:
        (^PAYEVNTEMP25 <> NULL AND (AsNumeric(^PAYEVNTEMP25) < 200 OR AsNumeric(^PAYEVNTEMP25) > 9999))

        Data Elements:

        ^PAYEVNTEMP25 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Postcode.Text
        */
        public static void VRATOPAYEVNTEMP000034(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP25 != null && (AsNumeric(report.PAYEVNTEMP25) < 200 || AsNumeric(report.PAYEVNTEMP25) > 9999));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000034",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"A valid postcode must be supplied",
                    LongDescription = @"When the address is within Australia, the Postcode must be in the range of '0200-9999'",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:AddressDetails/tns:PostcodeT",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000034" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP25", Value = GetValueOrEmpty(report.PAYEVNTEMP25) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000034

        #region VR.ATO.PAYEVNTEMP.000035

        /*  VR.ATO.PAYEVNTEMP.000035
        When the address is overseas, the Postcode must be blank.

        Legacy Rule Format:
        (^PAYEVNTEMP27 <> NULL AND ^PAYEVNTEMP27 <> "au") AND (^PAYEVNTEMP25 <> NULL)

        Technical Business Rule Format:
        (^PAYEVNTEMP27 <> NULL AND ^PAYEVNTEMP27 <> 'au') AND (^PAYEVNTEMP25 <> NULL)

        Data Elements:

        ^PAYEVNTEMP25 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Postcode.Text

        ^PAYEVNTEMP27 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000035(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP27 != null && report.PAYEVNTEMP27 != @"au" && report.PAYEVNTEMP25 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000035",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"This field must be left blank",
                    LongDescription = @"When the address is overseas, the Postcode must be blank",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:AddressDetails/tns:PostcodeT",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000035" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP27", Value = GetValueOrEmpty(report.PAYEVNTEMP27) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP25", Value = GetValueOrEmpty(report.PAYEVNTEMP25) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000035

        #region VR.ATO.PAYEVNTEMP.000126

        /*  VR.ATO.PAYEVNTEMP.000126
        The Contractor Australian Business Number (ABN) has failed the algorithm check.

        Legacy Rule Format:
        (^PAYEVNTEMP91 <> NULL AND FailsABNAlgorithm(^PAYEVNTEMP91))

        Technical Business Rule Format:
        (^PAYEVNTEMP91 <> NULL AND FailsABNAlgorithm(^PAYEVNTEMP91))

        Data Elements:

        ^PAYEVNTEMP91 = PAYEVNTEMP:Payee:Identifiers:Identifiers.AustralianBusinessNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000126(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP91 != null && FailsABNAlgorithm(report.PAYEVNTEMP91));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.434223",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"ABN is invalid.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:AustralianBusinessNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000126" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP91", Value = GetValueOrEmpty(report.PAYEVNTEMP91) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000126

        #region VR.ATO.PAYEVNTEMP.000130

        /*  VR.ATO.PAYEVNTEMP.000130
        When the address is overseas, the State / Territory must be blank.

        Legacy Rule Format:
        (^PAYEVNTEMP27 <> NULL AND ^PAYEVNTEMP27 <> "au") AND (^PAYEVNTEMP24 <> NULL)

        Technical Business Rule Format:
        (^PAYEVNTEMP27 <> NULL AND ^PAYEVNTEMP27 <> 'au') AND (^PAYEVNTEMP24 <> NULL)

        Data Elements:

        ^PAYEVNTEMP24 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.StateOrTerritory.Code

        ^PAYEVNTEMP27 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000130(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP27 != null && report.PAYEVNTEMP27 != @"au" && report.PAYEVNTEMP24 != null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000130",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"This field must be left blank",
                    LongDescription = @"When the address is overseas, the State / Territory must be blank",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:AddressDetails/tns:StateOrTerritoryC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000130" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP27", Value = GetValueOrEmpty(report.PAYEVNTEMP27) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP24", Value = GetValueOrEmpty(report.PAYEVNTEMP24) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000130

        #region VR.ATO.PAYEVNTEMP.000131

        /*  VR.ATO.PAYEVNTEMP.000131
        The payee contact email address must be a valid email.

        Legacy Rule Format:
        (^PAYEVNTEMP94 <> NULLORBLANK AND NOT IsValidEmail(^PAYEVNTEMP94))

        Technical Business Rule Format:
        (^PAYEVNTEMP94 <> BLANK AND NOT IsValidEmail(^PAYEVNTEMP94))

        Data Elements:

        ^PAYEVNTEMP94 = PAYEVNTEMP:Payee:ElectronicContact:ElectronicContact.ElectronicMail.Address.Text
        */
        public static void VRATOPAYEVNTEMP000131(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (string.IsNullOrWhiteSpace(report.PAYEVNTEMP94) != true && !(IsMatch(report.PAYEVNTEMP94, @"^\S.*@.+\.\S+$")));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.500029",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Email Address contains invalid text",
                    LongDescription = @"A text character must be one of the following: A to Z a to z 0 to 9 ! @ $ % & * ( ) - _ = [ ] ; : ' "" , . ? / or a space character.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:ElectronicContact/tns:ElectronicMailAddressT",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000131" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP94", Value = GetValueOrEmpty(report.PAYEVNTEMP94) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000131

        #region VR.ATO.PAYEVNTEMP.000154

        /*  VR.ATO.PAYEVNTEMP.000154
        When address is within Australia, the Postcode must be supplied.

        Legacy Rule Format:
        ((^PAYEVNTEMP27  = "au" OR ^PAYEVNTEMP27 = NULL) AND ^PAYEVNTEMP25 = NULL)

        Technical Business Rule Format:
        ((^PAYEVNTEMP27  = 'au' OR ^PAYEVNTEMP27 = NULL) AND ^PAYEVNTEMP25 = NULL)

        Data Elements:

        ^PAYEVNTEMP25 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Postcode.Text

        ^PAYEVNTEMP27 = PAYEVNTEMP:Payee:AddressDetails:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000154(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = ((report.PAYEVNTEMP27 == @"au" || report.PAYEVNTEMP27 == null) && report.PAYEVNTEMP25 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.000009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Postcode is required for an Australian address",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:AddressDetails/tns:PostcodeT",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000154" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP27", Value = GetValueOrEmpty(report.PAYEVNTEMP27) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP25", Value = GetValueOrEmpty(report.PAYEVNTEMP25) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000154

        #region VR.ATO.PAYEVNTEMP.000166

        /*  VR.ATO.PAYEVNTEMP.000166
        Payee date of birth cannot be a future date.

        Legacy Rule Format:
        (^PAYEVNTEMP204 > Year(Today()) OR (^PAYEVNTEMP204 = Year(Today()) AND (^PAYEVNTEMP203 > MonthAsInt(Today()) OR (^PAYEVNTEMP203 = MonthAsInt(Today()) AND ^PAYEVNTEMP205 > Day(Today())))))

        Technical Business Rule Format:
        (^PAYEVNTEMP204 > Year(Today()) OR (^PAYEVNTEMP204 = Year(Today()) AND (^PAYEVNTEMP203 > MonthAsInt(Today()) OR (^PAYEVNTEMP203 = MonthAsInt(Today()) AND ^PAYEVNTEMP205 > Day(Today())))))

        Data Elements:

        ^PAYEVNTEMP204 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.Year

        ^PAYEVNTEMP203 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.Month

        ^PAYEVNTEMP205 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.DayofMonth
        */
        public static void VRATOPAYEVNTEMP000166(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP204.GetValueOrDefault() > Year(DateTime.Now.Date) || report.PAYEVNTEMP204.GetValueOrDefault() == Year(DateTime.Now.Date) && (report.PAYEVNTEMP203.GetValueOrDefault() > MonthAsInt(DateTime.Now.Date) || report.PAYEVNTEMP203.GetValueOrDefault() == MonthAsInt(DateTime.Now.Date) && report.PAYEVNTEMP205.GetValueOrDefault() > Day(DateTime.Now.Date)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000166",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Date of birth cannot be a future date",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PersonDemographicDetailsBirth/tns:Y",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000166" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP204", Value = GetValueOrEmpty(report.PAYEVNTEMP204) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP203", Value = GetValueOrEmpty(report.PAYEVNTEMP203) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP205", Value = GetValueOrEmpty(report.PAYEVNTEMP205) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000166

        #region VR.ATO.PAYEVNTEMP.000167

        /*  VR.ATO.PAYEVNTEMP.000167
        Either the Payee TFN or Contractor ABN must be supplied

        Legacy Rule Format:
        (^PAYEVNTEMP13 = NULL AND ^PAYEVNTEMP91 = NULL)

        Technical Business Rule Format:
        ^PAYEVNTEMP13 = NULL AND ^PAYEVNTEMP91 = NULL

        Data Elements:

        ^PAYEVNTEMP13 = PAYEVNTEMP:Payee:Identifiers:Identifiers.TaxFileNumber.Identifier

        ^PAYEVNTEMP91 = PAYEVNTEMP:Payee:Identifiers:Identifiers.AustralianBusinessNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000167(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP13 == null && report.PAYEVNTEMP91 == null);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000167",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"You must provide either an ABN or a TFN",
                    LongDescription = @"Either the Payee TFN or Contractor ABN must be supplied",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000167" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP13", Value = GetValueOrEmpty(report.PAYEVNTEMP13) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP91", Value = GetValueOrEmpty(report.PAYEVNTEMP91) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000167

        #region VR.ATO.PAYEVNTEMP.000168

        /*  VR.ATO.PAYEVNTEMP.000168
        There cannot be more than one of the same Deduction Type in the collection.

        Legacy Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP10))

        Technical Business Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP10))

        Data Elements:

        ^PAYEVNTEMP10 = PAYEVNTEMP:Payee:PayrollPeriod:Deduction:Remuneration.DeductionType.Code
        */
        public static void VRATOPAYEVNTEMP000168(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = HasDuplicateValues(report.Payee_PayrollPeriod_DeductionCollection == null ? null : report.Payee_PayrollPeriod_DeductionCollection.Select(f => f.PAYEVNTEMP10).Cast<object>().ToArray());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000168",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Duplicate deduction types",
                    LongDescription = @"Deduction Type code has occurred more than once.  Delete the duplicate code or replace with an alternative code",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:DeductionCollection/tns:Deduction[" + report.Payee_PayrollPeriod_DeductionCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_DeductionCollection.Select(f => f.PAYEVNTEMP10))].OccurrenceIndex + "]/tns:RemunerationTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000168" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000168

        #region VR.ATO.PAYEVNTEMP.000172

        /*  VR.ATO.PAYEVNTEMP.000172
        There cannot be any occurrence with the same combination of ETP Code and Payee ETP Payment Date.

        Legacy Rule Format:
        AnyOccurrence(^PAYEVNTEMP256, HasDuplicateValues(^PAYEVNTEMP34 + ^PAYEVNTEMP123))

        Technical Business Rule Format:
        AnyOccurrence(^PAYEVNTEMP256, HasDuplicateValues(^PAYEVNTEMP34 + ^PAYEVNTEMP123))

        Data Elements:

        ^PAYEVNTEMP34 = PAYEVNTEMP:Payee:PayrollPeriod:EmploymentTerminationPayment:IncomeTax.PayAsYouGoWithholding.EmploymentTerminationPaymentType.Code

        ^PAYEVNTEMP123 = PAYEVNTEMP:Payee:PayrollPeriod:EmploymentTerminationPayment:PaymentRecord.PaymentEffective.Date

        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        */
        public static void VRATOPAYEVNTEMP000172(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;
            List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment> etpTuples = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment>();

            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment employmentTerminationPayment in remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection)
                        {
                            etpTuples.Add(employmentTerminationPayment);
                        }
                    }
                }
            }

            bool assertion = HasDuplicateValues(etpTuples.Select(f => f.PAYEVNTEMP34 + f.PAYEVNTEMP123).Cast<object>().ToArray());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000172",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Duplicate ETP codes and Payee ETP Payment Dates",
                    LongDescription = @"The combination of ETP code and Payee ETP Payment Date has occurred more than once.  Either replace ETP code or ETP Payment Date with alternative codes",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:EmploymentTerminationPaymentCollection/tns:EmploymentTerminationPayment/tns:IncomeTaxPayAsYouGoWithholdingTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000172" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000172

        #region VR.ATO.PAYEVNTEMP.000183

        /*  VR.ATO.PAYEVNTEMP.000183
        When Payee Day of Birth, Payee Month of Birth and Payee Year of Birth are supplied, it must be a valid date.

        Legacy Rule Format:
        (^PAYEVNTEMP205 <> NULL AND ^PAYEVNTEMP203 <> NULL AND ^PAYEVNTEMP204 <> NULL AND (IsDate(ConvertToDate(^PAYEVNTEMP205, ^PAYEVNTEMP203, ^PAYEVNTEMP204)) = 'FALSE' ))

        Technical Business Rule Format:
        (^PAYEVNTEMP205 <> NULL AND ^PAYEVNTEMP203 <> NULL AND ^PAYEVNTEMP204 <> NULL AND (IsDate(ConvertToDate(^PAYEVNTEMP205, ^PAYEVNTEMP203, ^PAYEVNTEMP204)) = 'FALSE' ))

        Data Elements:

        ^PAYEVNTEMP205 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.DayofMonth

        ^PAYEVNTEMP203 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.Month

        ^PAYEVNTEMP204 = PAYEVNTEMP:Payee:PersonDemographicDetails:PersonDemographicDetails.Birth.Year
        */
        public static void VRATOPAYEVNTEMP000183(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP205 != null && report.PAYEVNTEMP203 != null && report.PAYEVNTEMP204 != null && IsDate(ConvertToDate(report.PAYEVNTEMP205.GetValueOrDefault(), report.PAYEVNTEMP203.GetValueOrDefault(), report.PAYEVNTEMP204.GetValueOrDefault())) == false);
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000169",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Date of birth is invalid",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PersonDemographicDetailsBirth/tns:Dm",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000183" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP205", Value = GetValueOrEmpty(report.PAYEVNTEMP205) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP203", Value = GetValueOrEmpty(report.PAYEVNTEMP203) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP204", Value = GetValueOrEmpty(report.PAYEVNTEMP204) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000183

        #region VR.ATO.PAYEVNTEMP.000201

        /*  VR.ATO.PAYEVNTEMP.000201
        An Salary and Wages Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'SAW', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'SAW', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000201(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"SAW", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000201",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount cannot be supplied for Salary and Wages",
                            LongDescription = @"A Salary and Wages Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000201" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000201

        #region VR.ATO.PAYEVNTEMP.000203

        /*  VR.ATO.PAYEVNTEMP.000203
        A Voluntary Agreement Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000203(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000203",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Tax Paid Amount must not be supplied for Labour Hire Income",
                            LongDescription = @"A Voluntary Agreement Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000203" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000203

        #region VR.ATO.PAYEVNTEMP.000204

        /*  VR.ATO.PAYEVNTEMP.000204
        A Voluntary Agreement Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000204(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000204",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must not be supplied for Voluntary Agreement",
                            LongDescription = @"A Voluntary Agreement Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000204" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000204

        #region VR.ATO.PAYEVNTEMP.000209

        /*  VR.ATO.PAYEVNTEMP.000209
        A Labour Hire Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'LAB', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'LAB', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000209(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    ProcessMessageDocument processMessage = null;

                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"LAB", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000209",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Labour Hire",
                            LongDescription = @"A Labour Hire Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000209" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000209

        #region VR.ATO.PAYEVNTEMP.000210

        /*  VR.ATO.PAYEVNTEMP.000210
        A Labour Hire Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'LAB', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'LAB', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000210(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    ProcessMessageDocument processMessage = null;

                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"LAB", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000210",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must not be supplied for Labour Hire",
                            LongDescription = @"A Labour Hire Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000210" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000210

        #region VR.ATO.PAYEVNTEMP.000211

        /*  VR.ATO.PAYEVNTEMP.000211
        Contractor ABN must be supplied if an Income Stream Collection tuple with a type code Voluntary Agreement contains a Gross Payment or PAYGW Amount that is greater than zero.

        Legacy Rule Format:
        ^PAYEVNTEMP91 = NULL AND AnyOccurrence(^PAYEVNTEMP256, ^PAYEVNTEMP257 = "VOL" AND (^PAYEVNTEMP258 > 0 OR ^PAYEVNTEMP259 > 0))

        Technical Business Rule Format:
        ^PAYEVNTEMP91 = NULL AND AnyOccurrence(^PAYEVNTEMP256, ^PAYEVNTEMP257 = 'VOL' AND (^PAYEVNTEMP258 > 0 OR ^PAYEVNTEMP259 > 0))

        Data Elements:

        ^PAYEVNTEMP91 = PAYEVNTEMP:Payee:Identifiers:Identifiers.AustralianBusinessNumber.Identifier

        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Income

        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Income:IncomeTax.IncomeStreamType.Code

        ^PAYEVNTEMP258 = PAYEVNTEMP:Payee:PayrollPeriod:Income:Income.ComprehensiveIncomeGrossTotal.Amount

        ^PAYEVNTEMP259 = PAYEVNTEMP:Payee:PayrollPeriod:Income:IncomeTax.PayAsYouGoWithholding.TaxWithheld.Amount
        */
        public static void VRATOPAYEVNTEMP000211(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP91 == null && (report.Payee_PayrollPeriod_RemunerationCollection == null ? false : report.Payee_PayrollPeriod_RemunerationCollection.Any(PAYEVNTEMP256Repeat => PAYEVNTEMP256Repeat.PAYEVNTEMP257 == @"VOL" && (PAYEVNTEMP256Repeat.PAYEVNTEMP258.GetValueOrDefault() > 0 || PAYEVNTEMP256Repeat.PAYEVNTEMP259.GetValueOrDefault() > 0))));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000211",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Contractor ABN must be supplied",
                    LongDescription = @"Contractor ABN must be supplied if an Income Stream Collection tuple with a type code Voluntary Agreement contains a Gross Payment or PAYGW Amount that is greater than zero.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:AustralianBusinessNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000211" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP91", Value = GetValueOrEmpty(report.PAYEVNTEMP91) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP257", Value = "PAYEVNTEMP257" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP258", Value = "PAYEVNTEMP258" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP259", Value = "PAYEVNTEMP259" });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000211

        #region VR.ATO.PAYEVNTEMP.000213

        /*  VR.ATO.PAYEVNTEMP.000213
        A Working Holiday Maker Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'WHM', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'WHM', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000213(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"WHM", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000213",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Working Holiday Maker",
                            LongDescription = @"A Working Holiday Maker Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000213" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000213

        #region VR.ATO.PAYEVNTEMP.000214

        /*  VR.ATO.PAYEVNTEMP.000214
        A Working Holiday Maker Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'WHM', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'WHM', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000214(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"WHM", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000214",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must be left blank",
                            LongDescription = @"A Working Holiday Maker Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000214" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000214

        #region VR.ATO.PAYEVNTEMP.000215

        /*  VR.ATO.PAYEVNTEMP.000215
        A Directors' Fees Amount cannot be provided under a Joint Petroleum Development, Working Holiday Maker, Seasonal Worker Program, Voluntary Agreement, Labour Hire, or Other Specified Payments
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'JPD|VOL|WHM|SWP|LAB|OSP', 'i') AND ^PAYEVNTEMP264 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'JPD|VOL|WHM|SWP|LAB|OSP', 'i') AND ^PAYEVNTEMP264 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP264 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.GrossDirectorsFees.Amount
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000215(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"JPD|VOL|WHM|SWP|LAB|OSP", @"i") && remuneration.PAYEVNTEMP264 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000215",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Directors' Fees Amount must be left blank",
                            LongDescription = @"A Directors' Fees Amount cannot be provided under a Joint Petroleum Development, Working Holiday Maker, Seasonal Worker Program, Voluntary Agreement, Labour Hire, or Other Specified Payments",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:GrossDirectorsFeesA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000215" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP264", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP264) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000215

        #region VR.ATO.PAYEVNTEMP.000218

        /*  VR.ATO.PAYEVNTEMP.000218
        A Foreign Employment Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000218(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"FEI", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000218",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Foreign Employment Income",
                            LongDescription = @"A Foreign Employment Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000218" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000218

        #region VR.ATO.PAYEVNTEMP.000219

        /*  VR.ATO.PAYEVNTEMP.000219
        A Foreign Employment Income Type must contain a Foreign Tax Paid Amount

        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND ^PAYEVNTEMP278 = NULL

        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND ^PAYEVNTEMP278 = NULL

        Data Elements:

        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code

        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000219(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"FEI", @"i") && remuneration.PAYEVNTEMP278 == null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000219",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must be supplied for Foreign Employment Income",
                            LongDescription = @"A Foreign Employment Income Type must contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000219" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000219

        #region VR.ATO.PAYEVNTEMP.000222

        /*  VR.ATO.PAYEVNTEMP.000222
        A Joint Petroleum Development Area Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'JPD', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'JPD', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000222(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"JPD", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000222",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Joint Petroleum Development Area",
                            LongDescription = @"A Joint Petroleum Development Area Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000222" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000222

        #region VR.ATO.PAYEVNTEMP.000224

        /*  VR.ATO.PAYEVNTEMP.000224
        Only one of each Exemption Status can be provided

        Legacy Rule Format:
        HasDuplicateValues(^PAYEVNTEMP276)

        Technical Business Rule Format:
        HasDuplicateValues(^PAYEVNTEMP276)

        Data Elements:

        ^PAYEVNTEMP276 = PAYEVNTEMP:Payee:PayrollPeriod:IncomeFringeBenefitsReportable:Income.FringeBenefitsReportableExemption.Indicator
        */
        public static void VRATOPAYEVNTEMP000224(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = HasDuplicateValues(report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection == null ? null : report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection.Select(f => f.PAYEVNTEMP276).Cast<object>().ToArray());
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000224",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Only one of each Exemption Status can be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:IncomeFringeBenefitsReportableCollection/tns:IncomeFringeBenefitsReportable[" + report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection.Select(f => f.PAYEVNTEMP276))].OccurrenceIndex + "]/tns:FringeBenefitsReportableExemptionC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000224" } },
                };
                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000224

        #region VR.ATO.PAYEVNTEMP.000225

        /*  VR.ATO.PAYEVNTEMP.000225
        Termination Payments data cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|OSP|LAB', 'i') AND ^PAYEVNTEMP223 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|OSP|LAB', 'i') AND ^PAYEVNTEMP223 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP223 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:EmploymentTerminationPayment
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000225(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|OSP|LAB", @"i") && remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollectionExists != false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000225",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Termination Payments must be left blank",
                            LongDescription = @"Termination Payments data cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:EmploymentTerminationPaymentCollection/tns:EmploymentTerminationPayment",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000225" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000225

        #region VR.ATO.PAYEVNTEMP.000226

        /*  VR.ATO.PAYEVNTEMP.000226
        ETP Code must be one of the following: B, D, N, O, P, R, S or T
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP34, '^[BDNOPRST]$', 'i') = FALSE
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP34, '^[BDNOPRST]$', 'i') = FALSE
                    
        Data Elements:
                    
        ^PAYEVNTEMP34 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:EmploymentTerminationPayment:IncomeTax.PayAsYouGoWithholding.EmploymentTerminationPaymentType.Code
        */
        public static void VRATOPAYEVNTEMP000226(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment employmentTerminationPayment in remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection)
                        {
                            bool assertion = (RegexMatch(employmentTerminationPayment.PAYEVNTEMP34, @"^[BDNOPRST]$", @"i") == false);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000226",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"ETP Code is invalid",
                                    LongDescription = @"ETP Code must be one of the following: B, D, N, O, P, R, S or T",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:EmploymentTerminationPaymentCollection/tns:EmploymentTerminationPayment" + OccurrenceIndex(employmentTerminationPayment.OccurrenceIndex) + "/tns:IncomeTaxPayAsYouGoWithholdingTypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000226" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP34", Value = employmentTerminationPayment.PAYEVNTEMP34 });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000226

        #region VR.ATO.PAYEVNTEMP.000227

        /*  VR.ATO.PAYEVNTEMP.000227
        Income Stream Type Code must be one of the following values: SAW, CHP, WHM, SWP, JPD, VOL, LAB, OSP, IAA, or FEI
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP|IAA|FEI', 'i') = FALSE
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP|IAA|FEI', 'i') = FALSE
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000227(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP|IAA|FEI", @"i") == false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000227",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Income Stream Type Code is invalid",
                            LongDescription = @"Income Stream Type Code must be one of the following values: SAW, CHP, WHM, SWP, JPD, VOL, LAB, OSP, IAA, or FEI",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000227" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000227

        #region VR.ATO.PAYEVNTEMP.000228

        /*  VR.ATO.PAYEVNTEMP.000228
        Only one of each of the following Income Stream Type Code can be provided: SAW, CHP,  WHM,  SWP, JPD, VOL, LAB, or OSP
    
        Legacy Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP257) AND RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP', 'i'))
        
        Technical Business Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP257) AND RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP', 'i'))
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000228(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (HasDuplicateValues(report.Payee_PayrollPeriod_RemunerationCollection == null ? null : report.Payee_PayrollPeriod_RemunerationCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP257, @"SAW|CHP|WHM|SWP|JPD|VOL|LAB|OSP", @"i")).Select(f => f.PAYEVNTEMP257).Cast<object>().ToArray()));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000228",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Duplicate Income Stream Type",
                    LongDescription = @"Only one of each of the following Income Stream Type Code can be provided: SAW, CHP, WHM, SWP, JPD, VOL, LAB, or OSP",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration[" + report.Payee_PayrollPeriod_RemunerationCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_RemunerationCollection.Select(f => f.PAYEVNTEMP257))].OccurrenceIndex + "]/tns:IncomeStreamTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000228" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP257", Value = report.Payee_PayrollPeriod_RemunerationCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_RemunerationCollection.Select(f => f.PAYEVNTEMP257))].PAYEVNTEMP257 });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000228

        #region VR.ATO.PAYEVNTEMP.000234

        /*  VR.ATO.PAYEVNTEMP.000234
		A Shadow Payroll In-Pat Income Type cannot contain a Exempt Foreign Income Amount

		Legacy Rule Format:
		^PAYEVNTEMP257 = "SHD" AND ^PAYEVNTEMP261 <> NULL

		Technical Business Rule Format:
		^PAYEVNTEMP257 = 'SHD' AND ^PAYEVNTEMP261 <> NULL

		Data Elements:

		^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Income:IncomeTax.IncomeStreamType.Code

		^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Income:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
		*/
        public static void VRATOPAYEVNTEMP000234(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (remuneration.PAYEVNTEMP257 == @"SHD" && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000234",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Inbound Assignees to Australia",
                            LongDescription = @"An Inbound Assignees to Australia Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000234" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000234

        #region VR.ATO.PAYEVNTEMP.000235

        /*  VR.ATO.PAYEVNTEMP.000235
		A Shadow Payroll In-Pat Income Type cannot contain a Foreign Tax Paid Amount

		Legacy Rule Format:
		^PAYEVNTEMP257 = "SHD" AND ^PAYEVNTEMP278 <> NULL

		Technical Business Rule Format:
		^PAYEVNTEMP257 = 'SHD' AND ^PAYEVNTEMP278 <> NULL

		Data Elements:

		^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Income:IncomeTax.IncomeStreamType.Code

		^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Income:IncomeTax.ForeignWithholding.Amount
		*/
        public static void VRATOPAYEVNTEMP000235(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (remuneration.PAYEVNTEMP257 == @"SHD" && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000235",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must must not be supplied for Inbound Assignees to Australia",
                            LongDescription = @"An Inbound Assignees to Australia Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000235" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000235

        #region VR.ATO.PAYEVNTEMP.000236

        /*  VR.ATO.PAYEVNTEMP.000236
        Paid Leave Type Code must be one of the following: C, U, O, P, W, or A
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP269, '^[CUOPWA]$', 'i') = FALSE
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP269, '^[CUOPWA]$', 'i') = FALSE
                    
        Data Elements:
                    
        ^PAYEVNTEMP269 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:PaidLeave:Remuneration.PaidLeaveType.Code
        */
        public static void VRATOPAYEVNTEMP000236(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_PaidLeave paidLeave in remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection)
                        {
                            bool assertion = (RegexMatch(paidLeave.PAYEVNTEMP269, @"^[CUOPWA]$", @"i") == false);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000236",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Paid Leave Type Code is invalid",
                                    LongDescription = @"Paid Leave Type Code must be one of the following: C, U, O, P, W, or A",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:PaidLeaveCollection/tns:PaidLeave" + OccurrenceIndex(paidLeave.OccurrenceIndex) + "/tns:TypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000236" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                {
                                    Name = "PAYEVNTEMP269",
                                    Value = paidLeave.PAYEVNTEMP269
                                });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000236

        #region VR.ATO.PAYEVNTEMP.000237

        /*  VR.ATO.PAYEVNTEMP.000237
        Paid Leave Type Codes must be unique in a Income Stream Collection Tuple

        Legacy Rule Format:
        AnyOccurrence(^PAYEVNTEMP256, HasDuplicateValues(^PAYEVNTEMP269))

        Technical Business Rule Format:
        AnyOccurrence(^PAYEVNTEMP256, HasDuplicateValues(^PAYEVNTEMP269))

        Data Elements:

        ^PAYEVNTEMP269 = PAYEVNTEMP:Payee:PayrollPeriod:Income:PaidLeave:Remuneration.PaidLeaveType.Code

        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Income
        */
        public static void VRATOPAYEVNTEMP000237(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_PaidLeave paidLeave in remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection)
                        {
                            bool assertion = (report.Payee_PayrollPeriod_RemunerationCollection == null ? false : report.Payee_PayrollPeriod_RemunerationCollection.Any(PAYEVNTEMP256Repeat => HasDuplicateValues(remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection == null ? null : remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection.Select(f => f.PAYEVNTEMP269).Cast<object>().ToArray())));
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000237",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Duplicate Paid Leave Type",
                                    LongDescription = @"Paid Leave Type Codes must be unique in a Income Stream Collection Tuple",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:PaidLeaveCollection/tns:PaidLeave" + OccurrenceIndex(paidLeave.OccurrenceIndex) + "/tns:TypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000237" } },
                                };
                                response.Add(processMessage);
                                break;
                            }
                        }
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000237

        #region VR.ATO.PAYEVNTEMP.000240

        /*  VR.ATO.PAYEVNTEMP.000240
        Cessation Reason Code must be one of the following values: V, I, D, R, F, C, or T
    
        Legacy Rule Format:
        ^PAYEVNTEMP253 <> NULL AND RegexMatch(^PAYEVNTEMP253, 'V|I|D|R|F|C|T', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP253 <> NULL AND RegexMatch(^PAYEVNTEMP253, 'V|I|D|R|F|C|T', 'i') = FALSE
    
        Data Elements:
    
        ^PAYEVNTEMP253 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.CessationType.Code
        */
        public static void VRATOPAYEVNTEMP000240(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP253 != null && RegexMatch(report.PAYEVNTEMP253, @"V|I|D|R|F|C|T", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000240",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Cessation Reason Code is invalid",
                    LongDescription = @"Cessation Reason Code must be one of the following values: V, I, D, R, F, C, or T",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:CessationTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000240" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP253", Value = GetValueOrEmpty(report.PAYEVNTEMP253) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000240

        #region VR.ATO.PAYEVNTEMP.000241

        /*  VR.ATO.PAYEVNTEMP.000241
        Deduction Type Code must be one of the following values: F, W, D, or G
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP10, '^[FWDG]$', 'i') = FALSE
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP10, '^[FWDG]$', 'i') = FALSE
            
        Data Elements:
            
        ^PAYEVNTEMP10 = PAYEVNTEMP:Payee:PayrollPeriod:Deduction:Remuneration.DeductionType.Code
        */
        public static void VRATOPAYEVNTEMP000241(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_DeductionCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Deduction deduction in report.Payee_PayrollPeriod_DeductionCollection)
                {
                    bool assertion = (RegexMatch(deduction.PAYEVNTEMP10, @"^[FWDG]$", @"i") == false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000241",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Deduction Type Code is invalid",
                            LongDescription = @"Deduction Type Code must be one of the following values: F, W, D, or G",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:DeductionCollection/tns:Deduction" + OccurrenceIndex(deduction.OccurrenceIndex) + "/tns:RemunerationTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000241" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP10", Value = deduction.PAYEVNTEMP10 });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000241

        #region VR.ATO.PAYEVNTEMP.000244

        /*  VR.ATO.PAYEVNTEMP.000244
        Allowance Type Code must be one of the following values: AD, CD, LD, MD, RD, OD, KN, QN or TD
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'AD|CD|LD|MD|RD|OD|KN|QN|TD', 'i') = FALSE
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'AD|CD|LD|MD|RD|OD|KN|QN|TD', 'i') = FALSE
                    
        Data Elements:
                    
        ^PAYEVNTEMP7 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.AllowanceType.Code
        */
        public static void VRATOPAYEVNTEMP000244(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance allowance in remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection)
                        {
                            bool assertion = (RegexMatch(allowance.PAYEVNTEMP7, @"AD|CD|LD|MD|RD|OD|KN|QN|TD", @"i") == false);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000244",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Allowance Type Code is invalid",
                                    LongDescription = @"Allowance Type Code must be one of the following values: AD, CD, LD, MD, RD, OD, KN, QN or TD",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AllowanceCollection/tns:Allowance" + OccurrenceIndex(allowance.OccurrenceIndex) + "/tns:TypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000244" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP7", Value = allowance.PAYEVNTEMP7 });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000244

        #region VR.ATO.PAYEVNTEMP.000245

        /*  VR.ATO.PAYEVNTEMP.000245
        Salary Sacrifice Tuple must not be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP265 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP265 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP265 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:SalarySacrifice
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000245(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|LAB|OSP", @"i") && remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollectionExists != false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000245",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Salary Sacrifice must be left blank",
                            LongDescription = @"Salary Sacrifice Tuple must not be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:SalarySacrificeCollection/tns:SalarySacrifice",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000245" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000245

        #region VR.ATO.PAYEVNTEMP.000246

        /*  VR.ATO.PAYEVNTEMP.000246
        Salary Sacrifice Type Code in a Salary Sacrifice Tuple must be unique for Income Stream Collection.
    
        Legacy Rule Format:
        HasDuplicateValues(^PAYEVNTEMP266)

        Technical Business Rule Format:
        HasDuplicateValues(^PAYEVNTEMP266)
    
        Data Elements:
    
        ^PAYEVNTEMP266 = PAYEVNTEMP:Payee:PayrollPeriod:Income:SalarySacrifice:Remuneration.SalarySacrificeType.Code
        */
        public static void VRATOPAYEVNTEMP000246(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = HasDuplicateValues(remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection == null ? null : remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection.Select(f => f.PAYEVNTEMP266).Cast<object>().ToArray());
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000246",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Duplicate Salary Sacrifice Type",
                            LongDescription = @"Salary Sacrifice Type Code in a Salary Sacrifice Tuple must be unique for Income Stream Collection.",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:SalarySacrificeCollection/tns:SalarySacrifice/tns:TypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000246" } },
                        };
                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000246

        #region VR.ATO.PAYEVNTEMP.000247

        /*  VR.ATO.PAYEVNTEMP.000247
        Salary Sacrifice Type Code must be one of the following: S or O
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP266, '^[SO]$', 'i') = FALSE
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP266, '^[SO]$', 'i') = FALSE
                    
        Data Elements:
                    
        ^PAYEVNTEMP266 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:SalarySacrifice:Remuneration.SalarySacrificeType.Code
        */
        public static void VRATOPAYEVNTEMP000247(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrifice salarySacrifice in remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection)
                        {
                            bool assertion = (RegexMatch(salarySacrifice.PAYEVNTEMP266, @"^[SO]$", @"i") == false);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000247",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Salary Sacrifice Type Code is invalid",
                                    LongDescription = @"Salary Sacrifice Type Code must be one of the following: S or O",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:SalarySacrificeCollection/tns:SalarySacrifice" + OccurrenceIndex(salarySacrifice.OccurrenceIndex) + "/tns:TypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000247" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP266", Value = salarySacrifice.PAYEVNTEMP266 });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000247

        #region VR.ATO.PAYEVNTEMP.000248

        /*  VR.ATO.PAYEVNTEMP.000248
        Lump Sum Payments data cannot be provided under a Voluntary Agreement, Labour Hire, or Other Specified Payments Income Type
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|OSP|LAB', 'i') AND ^PAYEVNTEMP224 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|OSP|LAB', 'i') AND ^PAYEVNTEMP224 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP224 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000248(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|OSP|LAB", @"i") && remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollectionExists != false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000248",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Lump Sum Payments must be left blank",
                            LongDescription = @"Lump Sum Payments data cannot be provided under a Voluntary Agreement, Labour Hire, or Other Specified Payments Income Type",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000248" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000248

        #region VR.ATO.PAYEVNTEMP.000249

        /*  VR.ATO.PAYEVNTEMP.000249
        Lump Sum Type Code must be one of the following values: R, T, B, D, W, or E

        Legacy Rule Format:
        Length(^PAYEVNTEMP271) > 1 OR RegexMatch(^PAYEVNTEMP271, '^[RTBDWE]$', 'i') = FALSE
                
        Technical Business Rule Format:
        Length(^PAYEVNTEMP271) > 1 OR RegexMatch(^PAYEVNTEMP271, '^[RTBDWE]$', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
        */
        public static void VRATOPAYEVNTEMP000249(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum lumpSum in remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection)
                        {
                            bool assertion = (Length(lumpSum.PAYEVNTEMP271) > 1 || RegexMatch(lumpSum.PAYEVNTEMP271, @"^[RTBDWE]$", @"i") == false);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000249",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Lump Sum Type Code is invalid",
                                    LongDescription = @"Lump Sum Type Code must be one of the following values: R, T, B, D, W, or E",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(lumpSum.OccurrenceIndex) + "/tns:TypeC",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000249" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP271", Value = lumpSum.PAYEVNTEMP271 });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000249

        #region VR.ATO.PAYEVNTEMP.000250

        /*  VR.ATO.PAYEVNTEMP.000250
        Other Allowance Type Description must be entered when Allowance Type Code "OD" is selected
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'OD', 'i') AND ^PAYEVNTEMP8 = NULLORBLANK
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'OD', 'i') AND ^PAYEVNTEMP8 = BLANK
                    
        Data Elements:
                    
        ^PAYEVNTEMP8 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.OtherAllowanceType.Description
                    
        ^PAYEVNTEMP7 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.AllowanceType.Code
        */
        public static void VRATOPAYEVNTEMP000250(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance allowance in remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection)
                        {
                            bool assertion = (RegexMatch(allowance.PAYEVNTEMP7, @"OD", @"i") && string.IsNullOrWhiteSpace(allowance.PAYEVNTEMP8) == true);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000250",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Other Allowance Type Description must be entered when Allowance Type Code ""OD"" is selected",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AllowanceCollection/tns:Allowance" + OccurrenceIndex(allowance.OccurrenceIndex) + "/tns:OtherAllowanceTypeDe",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000250" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP7", Value = allowance.PAYEVNTEMP7 });

                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP8", Value = GetValueOrEmpty(allowance.PAYEVNTEMP8) });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000250

        #region VR.ATO.PAYEVNTEMP.000251

        /*  VR.ATO.PAYEVNTEMP.000251
        There cannot be more than one of the following Lump Sum Type codes in the Income collection: R, T, B, D, or W
            
        Legacy Rule Format:
        HasDuplicateValues(^PAYEVNTEMP271) AND RegexMatch(^PAYEVNTEMP271, '^[RTBDW]$', 'i')
                
        Technical Business Rule Format:
        HasDuplicateValues(^PAYEVNTEMP271) AND RegexMatch(^PAYEVNTEMP271, '^[RTBDW]$', 'i')
                    
        Data Elements:
                    
        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
        */
        public static void VRATOPAYEVNTEMP000251(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection != null)
                    {
                        bool assertion = HasDuplicateValues(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP271, @"^[RTBDW]$", @"i")).Select(f => f.PAYEVNTEMP271).Cast<object>().ToArray());
                        if (assertion)
                        {
                            ProcessMessageDocument processMessage = new ProcessMessageDocument()
                            {
                                Code = "CMN.ATO.PAYEVNTEMP.000251",
                                Severity = ProcessMessageSeverity.Error,
                                Description = @"Duplicate Lump Sum Type",
                                LongDescription = @"There cannot be more than one of the following Lump Sum Type codes in the Income collection: R, T, B, D, or W",
                                Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP271, @"[RTBDW]", @"i")).Select(f => f.PAYEVNTEMP271).Cast<object>().ToArray())) + "/tns:TypeC",
                                Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000251" } },
                            };
                            processMessage.Parameters.Add(new ProcessMessageParameter
                            { Name = "PAYEVNTEMP271", Value = remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection[DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP271, @"[RTBDW]", @"i")).Select(f => f.PAYEVNTEMP271).Cast<object>().ToArray())].PAYEVNTEMP271 });

                            response.Add(processMessage);
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000251

        #region VR.ATO.PAYEVNTEMP.000252

        /*  VR.ATO.PAYEVNTEMP.000252
        When an Income Type other than Voluntary Agreement is provided, Payee TFN must be provided

        Legacy Rule Format:
        ^PAYEVNTEMP13 = NULL AND ^PAYEVNTEMP257 <> "VOL" AND ^PAYEVNTEMP257 <> NULL

        Technical Business Rule Format:
        ^PAYEVNTEMP13 = NULL AND ^PAYEVNTEMP257 <> 'VOL' AND ^PAYEVNTEMP257 <> NULL

        Data Elements:

        ^PAYEVNTEMP13 = PAYEVNTEMP:Payee:Identifiers:Identifiers.TaxFileNumber.Identifier

        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Income
        */
        public static void VRATOPAYEVNTEMP000252(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (report.PAYEVNTEMP13 == null && remuneration.PAYEVNTEMP257 != @"VOL" && remuneration.PAYEVNTEMP257 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000252",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Payee TFN must be supplied",
                            LongDescription = @"When an Income Type other than Voluntary Agreement is provided, Payee TFN must be provided",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:TaxFileNumberId",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000252" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP13", Value = GetValueOrEmpty(report.PAYEVNTEMP13) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000252

        #region VR.ATO.PAYEVNTEMP.000253

        /*  VR.ATO.PAYEVNTEMP.000253
        First two characters of the Tax Treatment Code must be one of the following: RT, RD, RN, AT, AN, AD, AP, SS, SM, SI, HR, HU, CT, CF, HF, WP, FF, NF, NA, DB, DV, DZ, VC, or VO

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >1 AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2), 'RT|RD|RN|AT|AN|AD|AP|SS|SM|SI|HR|HU|CT|CF|HF|WP|FF|NF|NA|DB|DV|DZ|VC|VO', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >1 AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2), 'RT|RD|RN|AT|AN|AD|AP|SS|SM|SI|HR|HU|CT|CF|HF|WP|FF|NF|NA|DB|DV|DZ|VC|VO', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000253(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 1 && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"RT|RD|RN|AT|AN|AD|AP|SS|SM|SI|HR|HU|CT|CF|HF|WP|FF|NF|NA|DB|DV|DZ|VC|VO", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000253",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax Treatment Code is invalid",
                    LongDescription = @"First two characters of the Tax Treatment Code must be one of the following: RT, RD, RN, AT, AN, AD, AP, SS, SM, SI, HR, HU, CT, CF, HF, WP, FF, NF, NA, DB, DV, DZ, VC, or VO",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000253" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000253

        #region VR.ATO.PAYEVNTEMP.000254

        /*  VR.ATO.PAYEVNTEMP.000254
        Third character of the Tax Treatment Code must be either S or X.

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >2 AND RegexMatch(Substring(^PAYEVNTEMP254, 2, 1), 'S|X', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >2 AND RegexMatch(Substring(^PAYEVNTEMP254, 2, 1), 'S|X', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000254(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 2 && RegexMatch(Substring(report.PAYEVNTEMP254, 2, 1), @"S|X", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000254",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Third character of Tax Treatment Code is invalid",
                    LongDescription = @"Third character of the Tax Treatment Code must be either S or X.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000254" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = report.PAYEVNTEMP254 });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000254

        #region VR.ATO.PAYEVNTEMP.000255

        /*  VR.ATO.PAYEVNTEMP.000255
        When Study and Training Support Loan is provided in the third character of the Tax Treatment Code, the first two characters of the Tax Treatment Code must not be one of the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, or VO

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >2 AND RegexMatch(Substring(^PAYEVNTEMP254, 2, 1), 'S', 'i') AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO', 'i')

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >2 AND RegexMatch(Substring(^PAYEVNTEMP254, 2, 1), 'S', 'i') AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO', 'i')

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000255(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 2 && RegexMatch(Substring(report.PAYEVNTEMP254, 2, 1), @"S", @"i") && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO", @"i"));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000255",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax Treatment Code is invalid for STSL",
                    LongDescription = @"When Study and Training Support Loan is provided in the third character of the Tax Treatment Code, the first two characters of the Tax Treatment Code must not be one of the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, or VO",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000255" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000255

        #region VR.ATO.PAYEVNTEMP.000256

        /*  VR.ATO.PAYEVNTEMP.000256
        Fourth character of the Tax Treatment Code must be one of the following: 1, 2, 3 or X.

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >3 AND RegexMatch(Substring(^PAYEVNTEMP254, 3, 1), '1|2|3|X', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >3 AND RegexMatch(Substring(^PAYEVNTEMP254, 3, 1), '1|2|3|X', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000256(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 3 && RegexMatch(Substring(report.PAYEVNTEMP254, 3, 1), @"1|2|3|X", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000256",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Fourth character of the Tax Treatment Code is invalid",
                    LongDescription = @"Fourth character of the Tax Treatment Code must be one of the following: 1, 2, 3 or X.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000256" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000256

        #region VR.ATO.PAYEVNTEMP.000257

        /*  VR.ATO.PAYEVNTEMP.000257
        Fifth character of the Tax Treatment Code must be one of the following: H, F or X.

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >4 AND RegexMatch(Substring(^PAYEVNTEMP254, 4, 1), 'H|F|X', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >4 AND RegexMatch(Substring(^PAYEVNTEMP254, 4, 1), 'H|F|X', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000257(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 4 && RegexMatch(Substring(report.PAYEVNTEMP254, 4, 1), @"H|F|X", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000257",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Fifth character of the Tax Treatment Code invalid",
                    LongDescription = @"Fifth character of the Tax Treatment Code must be one of the following: H, F or X.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000257" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = report.PAYEVNTEMP254 });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000257

        #region VR.ATO.PAYEVNTEMP.000258

        /*  VR.ATO.PAYEVNTEMP.000258
        Sixth character of the Tax Treatment Code must be one of the following: 0-9, A, or X.

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), '[0-9]|A|X', 'i') = FALSE

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), '[0-9]|A|X', 'i') = FALSE

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000258(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 5 && RegexMatch(Substring(report.PAYEVNTEMP254, 5, 1), @"[0-9]|A|X", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000258",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Sixth character of the Tax Treatment Code is invalid",
                    LongDescription = @"Sixth character of the Tax Treatment Code must be one of the following: 0-9, A, or X.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000258" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000258

        #region VR.ATO.PAYEVNTEMP.000267

            /*  VR.ATO.PAYEVNTEMP.000267
            Super Entitlement Type Code must be one of the following values: L (Superannuation Liability), O (Ordinary Time Earnings), Q (Qualifying Earnings - only valid from 01/07/2026) or R (Reportable Employer Superannuation Contribution)
    
            Legacy Rule Format:
            RegexMatch(^PAYEVNTEMP283, '^[LOQR]$', 'i') = FALSE OR (RegexMatch(^PAYEVNTEMP283, 'Q', 'i') AND ^PAYEVNTEMP29 < ConvertToDate(1, 7, 2026))
        
            Technical Business Rule Format:
            RegexMatch(^PAYEVNTEMP283, '^[LOQR]$', 'i') = FALSE OR (RegexMatch(^PAYEVNTEMP283, 'Q', 'i') AND ^PAYEVNTEMP29 < ConvertToDate(1, 7, 2026))
            
            Data Elements:
            
            ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
            
            ^PAYEVNTEMP29 = PAYEVNTEMP:Payee:PayrollPeriod:Period.Start.Date
            */
        public static void VRATOPAYEVNTEMP000267(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_SuperannuationContributionCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_SuperannuationContribution superannuationContribution in report.Payee_PayrollPeriod_SuperannuationContributionCollection)
                {
                    bool assertion = (RegexMatch(superannuationContribution.PAYEVNTEMP283, @"^[LOQR]$", @"i") == false || RegexMatch(superannuationContribution.PAYEVNTEMP283, @"Q", @"i") && report.PAYEVNTEMP29.GetValueOrDefault() < ConvertToDate(1, 7, 2026));
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000267",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Super Entitlement Type Code is Invalid",
                            LongDescription = @"Super Entitlement Type Code must be one of the following values: L (Superannuation Liability), O (Ordinary Time Earnings), Q (Qualifying Earnings - only valid from 01/07/2026) or R (Reportable Employer Superannuation Contribution)",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution" + OccurrenceIndex(superannuationContribution.OccurrenceIndex) + "/tns:EntitlementTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000267" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP283", Value = superannuationContribution.PAYEVNTEMP283 });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP29", Value = GetValueOrEmpty(report.PAYEVNTEMP29) });
                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000267

        #region VR.ATO.PAYEVNTEMP.000268

        /*  VR.ATO.PAYEVNTEMP.000268
        RFB Exemption Status Code must be one of the following values: X, or T
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP276, 'X|T', 'i') = FALSE
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP276, 'X|T', 'i') = FALSE
            
        Data Elements:
            
        ^PAYEVNTEMP276 = PAYEVNTEMP:Payee:PayrollPeriod:IncomeFringeBenefitsReportable:Income.FringeBenefitsReportableExemption.Code
        */
        public static void VRATOPAYEVNTEMP000268(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_IncomeFringeBenefitsReportable incomeFringeBenefitsReportable in report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection)
                {
                    bool assertion = (RegexMatch(incomeFringeBenefitsReportable.PAYEVNTEMP276, @"X|T", @"i") == false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000268",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"RFB Exemption Status Code is invalid",
                            LongDescription = @"RFB Exemption Status Code must be one of the following values: X, or T",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:IncomeFringeBenefitsReportableCollection/tns:IncomeFringeBenefitsReportable" + OccurrenceIndex(incomeFringeBenefitsReportable.OccurrenceIndex) + "/tns:FringeBenefitsReportableExemptionC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000268" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP276", Value = incomeFringeBenefitsReportable.PAYEVNTEMP276 });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000268

        #region VR.ATO.PAYEVNTEMP.000270

        /*  VR.ATO.PAYEVNTEMP.000270
        Payee Year of Birth can't be more than 120 years in the past

        Legacy Rule Format:
        (^PAYEVNTEMP204 < (Year(Today()) - 120))

        Technical Business Rule Format:
        ^PAYEVNTEMP204 < (Year(Today()) - 120)

        Data Elements:

        ^PAYEVNTEMP204 = PAYEVNTEMP:Payee:Identifiers:PersonDemographicDetailsBirth:PersonDemographicDetails.Birth.Year
        */
        public static void VRATOPAYEVNTEMP000270(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = report.PAYEVNTEMP204 < (DateTime.Today.Year - 120);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000270",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payee Year of Birth can't be more than 120 years in the past",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PersonDemographicDetailsBirth/tns:Y",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000270" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                {
                    Name = "PAYEVNTEMP204",
                    Value = report.PAYEVNTEMP204.ToString()
                });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000270

        #region VR.ATO.PAYEVNTEMP.000272

        /*  VR.ATO.PAYEVNTEMP.000272
            Employment Basis Code must be one of the following Values: C, F, P, L, V, D, or N
    
            Legacy Rule Format:
            (^PAYEVNTEMP282 <> NULL AND RegexMatch(^PAYEVNTEMP282, '^[CFPLVDN]$', 'i') = FALSE)

            Technical Business Rule Format:
            (^PAYEVNTEMP282 <> NULL AND RegexMatch(^PAYEVNTEMP282, '^[CFPLVDN]$', 'i') = FALSE)
    
            Data Elements:
    
            ^PAYEVNTEMP282 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.PaymentBasis.Code
        */
        public static void VRATOPAYEVNTEMP000272(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP282 != null && RegexMatch(report.PAYEVNTEMP282, @"^[CFPLVDN]$", @"i") == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000272",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Employment Basis Code is invalid",
                    LongDescription = @"Employment Basis Code must be one of the following Values: C, F, P, L, V, D, or N",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:PaymentBasisC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000272" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP282", Value = GetValueOrEmpty(report.PAYEVNTEMP282) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000272

        #region VR.ATO.PAYEVNTEMP.000274

        /*  VR.ATO.PAYEVNTEMP.000274
        When Employment Basis Code is V, an Income Stream Type Code of VOL must be provided
    
        Legacy Rule Format:
        (^PAYEVNTEMP282 = "V" AND CountOccurrence(^PAYEVNTEMP257, ^PAYEVNTEMP257 = "VOL") = 0)

        Technical Business Rule Format:
        (^PAYEVNTEMP282 = 'V' AND CountOccurrence(^PAYEVNTEMP257, ^PAYEVNTEMP257 = 'VOL') = 0)
    
        Data Elements:
    
        ^PAYEVNTEMP282 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.PaymentBasis.Code
    
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000274(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP282 == @"V" && (report.Payee_PayrollPeriod_RemunerationCollection == null ? 0 : report.Payee_PayrollPeriod_RemunerationCollection.Count(PAYEVNTEMP257Repeat => PAYEVNTEMP257Repeat.PAYEVNTEMP257 == @"VOL")) == 0);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000274",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income Stream code VOL must be provided when Voluntary Agreement Employment Basis used",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:PaymentBasisC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000274" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP282", Value = GetValueOrEmpty(report.PAYEVNTEMP282) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000274

        #region VR.ATO.PAYEVNTEMP.000275

        /*  VR.ATO.PAYEVNTEMP.000275
        When Employment Basis Code is N, a Contractor ABN must be provided
    
        Legacy Rule Format:
        (^PAYEVNTEMP282 = "N" AND ^PAYEVNTEMP91 = NULL)

        Technical Business Rule Format:
        ^PAYEVNTEMP282 = 'N' AND ^PAYEVNTEMP91 = NULL
    
        Data Elements:
    
        ^PAYEVNTEMP282 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.PaymentBasis.Code
    
        ^PAYEVNTEMP91 = PAYEVNTEMP:Payee:Identifiers:Identifiers.AustralianBusinessNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000275(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP282 == @"N" && report.PAYEVNTEMP91 == null);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000275",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"When Employment Basis Code is N, a Contractor ABN must be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:PaymentBasisC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000275" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP282", Value = GetValueOrEmpty(report.PAYEVNTEMP282) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP91", Value = GetValueOrEmpty(report.PAYEVNTEMP91) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000275

        #region VR.ATO.PAYEVNTEMP.000276

        /*  VR.ATO.PAYEVNTEMP.000276
        When Employment Basis Code is N, the Tax Treatment Code must be DZXXXX
    
        Legacy Rule Format:
        (^PAYEVNTEMP282 = "N" AND ^PAYEVNTEMP254 <> "DZXXXX")

        Technical Business Rule Format:
        ^PAYEVNTEMP282 = 'N' AND ^PAYEVNTEMP254 <> 'DZXXXX'
    
        Data Elements:
    
        ^PAYEVNTEMP282 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.PaymentBasis.Code
    
        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000276(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP282 == @"N" && report.PAYEVNTEMP254 != @"DZXXXX");
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000276",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"When Employment Basis Code is N, the Tax Treatment Code must be DZXXXX",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:PaymentBasisC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000276" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP282", Value = GetValueOrEmpty(report.PAYEVNTEMP282) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000276

        #region VR.ATO.PAYEVNTEMP.000277
        
        /*  VR.ATO.PAYEVNTEMP.000277
        When Employment Basis Code is N (Non-Employee), no Income Stream Collections or Reportable Fringe Benefits Amounts can be provided, and Super entitlement year to date details for L (Superannuation Liability) must be provided - Super entitlement year to date details for Q (Qualifying Earnings) only may also be provided

        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP282, 'N', 'i') AND (Count(^PAYEVNTEMP256) <> 0 OR Count(^PAYEVNTEMP281) <> 0 OR CountOccurrence(^PAYEVNTEMP283, RegexMatch(^PAYEVNTEMP283, 'L', 'i')) <> 1 OR AnyOccurrence(^PAYEVNTEMP283, RegexMatch(^PAYEVNTEMP283, '^[LQ]$', 'i') = FALSE))

        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP282, 'N', 'i') AND (Count(^PAYEVNTEMP256) <> 0 OR Count(^PAYEVNTEMP281) <> 0 OR CountOccurrence(^PAYEVNTEMP283, RegexMatch(^PAYEVNTEMP283, 'L', 'i')) <> 1 OR AnyOccurrence(^PAYEVNTEMP283, RegexMatch(^PAYEVNTEMP283, '^[LQ]$', 'i') = FALSE))

        Data Elements:

        ^PAYEVNTEMP282 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.PaymentBasis.Code

        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration

        ^PAYEVNTEMP281 = PAYEVNTEMP:Payee:PayrollPeriod:IncomeFringeBenefitsReportable

        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
        */
        public static void VRATOPAYEVNTEMP000277(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (RegexMatch(report.PAYEVNTEMP282, @"N", @"i") && (Count(report.Payee_PayrollPeriod_RemunerationCollectionCount) != 0 || Count(report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionCount) != 0 || (report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP283Repeat => RegexMatch(PAYEVNTEMP283Repeat.PAYEVNTEMP283, @"L", @"i"))) != 1 || (report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? false : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Any(PAYEVNTEMP283Repeat => RegexMatch(PAYEVNTEMP283Repeat.PAYEVNTEMP283, @"^[LQ]$", @"i") == false))));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000277",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"When Employment Basis Code is N, a Super Entitlement Type Code L must be provided",
                    LongDescription = @"When Employment Basis Code is N (Non-Employee), no Income Stream Collections or Reportable Fringe Benefits Amounts can be provided, and Super entitlement year to date details for L (Superannuation Liability) must be provided - Super entitlement year to date details for Q (Qualifying Earnings) only may also be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:PaymentBasisC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000277" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP282", Value = GetValueOrEmpty(report.PAYEVNTEMP282) });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP283", Value = "Count(PAYEVNTEMP283)" });
                response.Add(processMessage);
            }
        }

        #endregion

        #region VR.ATO.PAYEVNTEMP.000283

        /*  VR.ATO.PAYEVNTEMP.000283
        Payee Cessation Date must not be more than 10 years in the future from the current date
    
        Legacy Rule Format:
        (Year(^PAYEVNTEMP93) > (Year(Today()) + 10))

        Technical Business Rule Format:
        (Year(^PAYEVNTEMP93) > (Year(Today()) + 10))
    
        Data Elements:
    
        ^PAYEVNTEMP93 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.EmploymentEnd.Date
        */
        public static void VRATOPAYEVNTEMP000283(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (Year(report.PAYEVNTEMP93.GetValueOrDefault()) > Year(DateTime.Now.Date) + 10);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000283",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payee Cessation Date cannot be more than 10 years in the future",
                    LongDescription = @"Payee Cessation Date must not be more than 10 years in the future from the current date",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:EmploymentEndD",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000283" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP93", Value = GetValueOrEmpty(report.PAYEVNTEMP93) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000283

        #region VR.ATO.PAYEVNTEMP.000284

        /*  VR.ATO.PAYEVNTEMP.000284
        When Medicare Reduction is provided in the sixth character of the Tax Treatment Code as 0, the first two characters must not be SS

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND (RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), '0', 'i') AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2), 'SS', 'i'))

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND (RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), '0', 'i') AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2), 'SS', 'i'))

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000284(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 5 && (RegexMatch(Substring(report.PAYEVNTEMP254, 5, 1), @"0", @"i") && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"SS", @"i")));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000284",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax Treatment for a single senior must not provide a spouse medicare levy reduction",
                    LongDescription = @"When Medicare Reduction is provided in the sixth character of the Tax Treatment Code as 0, the first two characters must not be SS",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000284" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000284

        #region VR.ATO.PAYEVNTEMP.000297

        /*  VR.ATO.PAYEVNTEMP.000297
        Payee Commencement Date must not be more than one year in the future of the current date
    
        Legacy Rule Format:
        (^PAYEVNTEMP92) > (AddMonthsToDate(Today(), 12))

        Technical Business Rule Format:
        (^PAYEVNTEMP92) > (AddMonthsToDate(Today(), 12))
    
        Data Elements:
    
        ^PAYEVNTEMP92 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.EmploymentStart.Date
        */
        public static void VRATOPAYEVNTEMP000297(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP92.GetValueOrDefault() > DateTime.Today.AddMonths(12));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000297",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payee Commencement Date is invalid",
                    LongDescription = @"Payee Commencement Date must not be more than one year in the future of the current date",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:EmploymentStartD",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000297" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP92", Value = report.PAYEVNTEMP92.GetValueOrDefault().ToString("yyyy-MM-dd") });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000297

        #region VR.ATO.PAYEVNTEMP.000298

        /*  VR.ATO.PAYEVNTEMP.000298
        A Closely Held Payees Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'CHP', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'CHP', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000298(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"CHP", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000298",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Closely Held Payees",
                            LongDescription = @"A Closely Held Payees Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000298" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000298

        #region VR.ATO.PAYEVNTEMP.000299

        /*  VR.ATO.PAYEVNTEMP.000299
        A Closely Held Payees Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'CHP', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'CHP', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000299(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"CHP", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000299",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must not be supplied for Closely Held Payees",
                            LongDescription = @"A Closely Held Payees Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000299" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000299

        #region VR.ATO.PAYEVNTEMP.000300

        /*  VR.ATO.PAYEVNTEMP.000300
        A Other Specified Payments Income Type cannot contain a Exempt Foreign Income Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'OSP', 'i') AND ^PAYEVNTEMP261 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'OSP', 'i') AND ^PAYEVNTEMP261 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP261 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessExemptForeignEmploymentIncome.Amount
        */
        public static void VRATOPAYEVNTEMP000300(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"OSP", @"i") && remuneration.PAYEVNTEMP261 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000300",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Exempt Foreign Income Amount must not be supplied for Other Specified Payments",
                            LongDescription = @"A Other Specified Payments Income Type cannot contain a Exempt Foreign Income Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000300" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP261", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP261) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000300

        #region VR.ATO.PAYEVNTEMP.000301

        /*  VR.ATO.PAYEVNTEMP.000301
        A Other specified payments Income Type cannot contain a Foreign Tax Paid Amount
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'OSP', 'i') AND ^PAYEVNTEMP278 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'OSP', 'i') AND ^PAYEVNTEMP278 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
        */
        public static void VRATOPAYEVNTEMP000301(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"OSP", @"i") && remuneration.PAYEVNTEMP278 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000301",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must not be supplied for Other Specified Payments",
                            LongDescription = @"A Other Specified Payments Income Type cannot contain a Foreign Tax Paid Amount",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeStreamTypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000301" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000301

        #region VR.ATO.PAYEVNTEMP.000302

        /*  VR.ATO.PAYEVNTEMP.000302
        Allowance Items cannot be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP226 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP226 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP226 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000302(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|LAB|OSP", @"i") && remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionExists != false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000302",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Allowance Items must be left blank",
                            LongDescription = @"Allowance Items cannot be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AllowanceCollection/tns:Allowance",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000302" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP226 <> NULL", Value = remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionExists.ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000302

        #region VR.ATO.PAYEVNTEMP.000303

        /*  VR.ATO.PAYEVNTEMP.000303
        Only one of the valid Allowance Type Codes, other than OD, can be provided per Income Type
            
        Legacy Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP7) AND RegexMatch(^PAYEVNTEMP7, 'AD|CD|LD|MD|RD|KN|QN|TD', 'i'))
                
        Technical Business Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP7) AND RegexMatch(^PAYEVNTEMP7, 'AD|CD|LD|MD|RD|KN|QN|TD', 'i'))
                    
        Data Elements:
                    
        ^PAYEVNTEMP7 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.AllowanceType.Code
        */
        public static void VRATOPAYEVNTEMP000303(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (HasDuplicateValues(remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection == null ? null : remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP7, @"AD|CD|LD|MD|RD|KN|QN|TD", @"i")).Select(f => f.PAYEVNTEMP7).Cast<object>().ToArray()));
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000303",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Duplicate Allowance Type",
                            LongDescription = @"Only one of the valid Allowance Type Codes, other than OD, can be provided per Income Type",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AllowanceCollection/tns:Allowance[" + remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection[DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP7, @"AD|CD|LD|MD|RD|KN|QN|TD", @"i")).Select(f => f.PAYEVNTEMP7))].OccurrenceIndex + "]/tns:TypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000303" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP7", Value = remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP7, @"AD|CD|LD|MD|RD|KN|QN|TD", @"i"))[DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP7, @"AD|CD|LD|MD|RD|KN|QN|TD", @"i")).Select(f => f.PAYEVNTEMP7))].PAYEVNTEMP7 });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000303

        #region VR.ATO.PAYEVNTEMP.000304

        /*  VR.ATO.PAYEVNTEMP.000304
        Where multiple Allowance data is provided, only a total of 150 Allowance Type Codes of OD can be provided per income type

        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP7, RegexMatch(^PAYEVNTEMP7, 'OD', 'i')) > 150

        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP7, RegexMatch(^PAYEVNTEMP7, 'OD', 'i')) > 150

        Data Elements:

        ^PAYEVNTEMP7 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.AllowanceType.Code
        */
        public static void VRATOPAYEVNTEMP000304(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = ((remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.Count(PAYEVNTEMP7Repeat => RegexMatch(PAYEVNTEMP7Repeat.PAYEVNTEMP7, @"OD", @"i"))) > 150);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000304",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"More than 150 Other Allowance Types supplied for an Income Type",
                            LongDescription = @"Where multiple Allowance data is provided, only a total of 150 Allowance Type Codes of OD can be provided per income type",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:AllowanceCollection/tns:Allowance/tns:TypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000304" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP7", Value = "OD" });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "Count(PAYEVNTEMP7 = 'OD')", Value = (remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.Count(PAYEVNTEMP7Repeat => RegexMatch(PAYEVNTEMP7Repeat.PAYEVNTEMP7, @"OD", @"i"))).ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000304

        #region VR.ATO.PAYEVNTEMP.000305

        /*  VR.ATO.PAYEVNTEMP.000305
        Reportable Fringe Benefits amount data cannot be provided when Payee TFN isn't provided
    
        Legacy Rule Format:
        ^PAYEVNTEMP281 <> NULL AND ^PAYEVNTEMP13 = NULL
        
        Technical Business Rule Format:
        ^PAYEVNTEMP281 <> NULL AND ^PAYEVNTEMP13 = NULL
            
        Data Elements:
            
        ^PAYEVNTEMP281 = PAYEVNTEMP:Payee:PayrollPeriod:IncomeFringeBenefitsReportable
            
        ^PAYEVNTEMP13 = PAYEVNTEMP:Payee:Identifiers:Identifiers.TaxFileNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000305(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection != null)
            {
                foreach (Payee_PayrollPeriod_IncomeFringeBenefitsReportable incomeFringeBenefitsReportable in report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection)
                {
                    bool assertion = (report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionExists != false && report.PAYEVNTEMP13 == null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000305",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Reportable Fringe Benefits amount is invalid",
                            LongDescription = @"Reportable Fringe Benefits amount data cannot be provided when Payee TFN isn't provided",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:IncomeFringeBenefitsReportableCollection/tns:IncomeFringeBenefitsReportable" + OccurrenceIndex(incomeFringeBenefitsReportable.OccurrenceIndex),
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000305" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP13", Value = GetValueOrEmpty(report.PAYEVNTEMP13) });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "^PAYEVNTEMP281 <> NULL", Value = report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionExists.ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000305

        #region VR.ATO.PAYEVNTEMP.000306

        /*  VR.ATO.PAYEVNTEMP.000306
        Termination Payments data cannot have more than 88 occurrences
    
        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP223, ^PAYEVNTEMP223 <> NULL) > 88
        
        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP223, ^PAYEVNTEMP223 <> NULL) > 88
            
        Data Elements:
            
        ^PAYEVNTEMP223 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:EmploymentTerminationPayment
        */
        public static void VRATOPAYEVNTEMP000306(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                bool assertion = report.Payee_PayrollPeriod_RemunerationCollection.FindAll(f => f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null).Sum(f => f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection.Count()) > 88;
                if (assertion)
                {
                    ProcessMessageDocument processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.PAYEVNTEMP.000306",
                        Severity = ProcessMessageSeverity.Error,
                        Description = @"Termination Payments cannot have more than 88 occurrences",
                        LongDescription = @"Termination Payments data cannot have more than 88 occurrences across all Income Stream Collections",
                        Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(report.Payee_PayrollPeriod_RemunerationCollection.Last(f => f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null && f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection.Count > 0).OccurrenceIndex) + "/tns:EmploymentTerminationPaymentCollection/tns:EmploymentTerminationPayment" + OccurrenceIndex(report.Payee_PayrollPeriod_RemunerationCollection.Last(f => f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null && f.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection.Count > 0).Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection.Last().OccurrenceIndex),
                        Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000306" } },
                    };
                    response.Add(processMessage);
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000306

        #region VR.ATO.PAYEVNTEMP.000352

        /*  VR.ATO.PAYEVNTEMP.000352
        Where an Income Stream Collection is present, the PAYGW Amount must be provided
    
        Legacy Rule Format:
        ^PAYEVNTEMP256 <> NULL AND ^PAYEVNTEMP259 = NULL
        
        Technical Business Rule Format:
        ^PAYEVNTEMP256 <> NULL AND ^PAYEVNTEMP259 = NULL
            
        Data Elements:
            
        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        ^PAYEVNTEMP259 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.PayAsYouGoWithholding.TaxWithheld.Amount
        */
        public static void VRATOPAYEVNTEMP000352(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (remuneration.PAYEVNTEMP259 == null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000352",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"PAYGW Amount must be provided",
                            LongDescription = @"Where an Income Stream Collection is present, the PAYGW Amount must be provided",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeTaxPayAsYouGoWithholdingTaxWithheldA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000352" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP259", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP259) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000352

        #region VR.ATO.PAYEVNTEMP.000353

        /*  VR.ATO.PAYEVNTEMP.000353
        When multiple Income Stream Type Codes with a value of FEI or IAA are provided they must have different Country Codes
    
        Legacy Rule Format:
        (^PAYEVNTEMP260 <> NULL AND HasDuplicateValues(^PAYEVNTEMP257 + ^PAYEVNTEMP260) AND RegexMatch(^PAYEVNTEMP257, 'FEI|IAA', 'i'))
        
        Technical Business Rule Format:
        (^PAYEVNTEMP260 <> NULL AND HasDuplicateValues(^PAYEVNTEMP257 + ^PAYEVNTEMP260) AND RegexMatch(^PAYEVNTEMP257, 'FEI|IAA', 'i'))
            
        Data Elements:
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
            
        ^PAYEVNTEMP260 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000353(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (HasDuplicateValues(report.Payee_PayrollPeriod_RemunerationCollection == null ? null : report.Payee_PayrollPeriod_RemunerationCollection.FindAll(f => f.PAYEVNTEMP260 != null && RegexMatch(f.PAYEVNTEMP257, @"FEI|IAA", @"i")).Select(f => f.PAYEVNTEMP257 + f.PAYEVNTEMP260).Cast<object>().ToArray()));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000353",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Country codes must be different when providing multiple FEI or IAA codes",
                    LongDescription = @"When multiple Income Stream Type Codes with a value of FEI or IAA are provided they must have different Country Codes",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration[" + report.Payee_PayrollPeriod_RemunerationCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_RemunerationCollection.Select(f => f.PAYEVNTEMP257 + f.PAYEVNTEMP260))].OccurrenceIndex + "]/tns:IncomeStreamTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000353" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP257", Value = report.Payee_PayrollPeriod_RemunerationCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_RemunerationCollection.Select(f => f.PAYEVNTEMP257 + f.PAYEVNTEMP260))].PAYEVNTEMP257 });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000353

        #region VR.ATO.PAYEVNTEMP.000356

        /*  VR.ATO.PAYEVNTEMP.000356
        Country Code can't be au, nf, cx, cc, or hm
    
        Legacy Rule Format:
        InSet(^PAYEVNTEMP260, '"au", "nf", "cx", "cc", "hm"')
        
        Technical Business Rule Format:
        InSet(^PAYEVNTEMP260, '"au", "nf", "cx", "cc", "hm"')
            
        Data Elements:
            
        ^PAYEVNTEMP260 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:AddressDetails.Country.Code
        */
        public static void VRATOPAYEVNTEMP000356(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = IsMatch(remuneration.PAYEVNTEMP260, @"^(au|nf|cx|cc|hm)$");
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000356",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Country Code is invalid",
                            LongDescription = @"Country Code can't be au, nf, cx, cc, or hm",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AddressDetailsCountryC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000356" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP260", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP260) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000356

        #region VR.ATO.PAYEVNTEMP.000357

        /*  VR.ATO.PAYEVNTEMP.000357
        Country Code must not be provided when the Income Stream Type Code is one of the following: SAW, CHP, SWP, JPD, VOL, LAB, or OSP
    
        Legacy Rule Format:
        (^PAYEVNTEMP260 <> NULL AND RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|SWP|JPD|VOL|LAB|OSP', 'i'))
        
        Technical Business Rule Format:
        (^PAYEVNTEMP260 <> NULL AND RegexMatch(^PAYEVNTEMP257, 'SAW|CHP|SWP|JPD|VOL|LAB|OSP', 'i'))
            
        Data Elements:
            
        ^PAYEVNTEMP260 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:AddressDetails.Country.Code
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000357(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (remuneration.PAYEVNTEMP260 != null && RegexMatch(remuneration.PAYEVNTEMP257, @"SAW|CHP|SWP|JPD|VOL|LAB|OSP", @"i"));
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000357",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Country Code must be left blank",
                            LongDescription = @"Country Code must not be provided when the Income Stream Type Code is one of the following: SAW, CHP, SWP, JPD, VOL, LAB, or OSP",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AddressDetailsCountryC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000357" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP260", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP260) });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000357

        #region VR.ATO.PAYEVNTEMP.000359

        /*  VR.ATO.PAYEVNTEMP.000359
        When the Final Event Indicator is true, and an Income Stream Type Code of FEI or JPD is provided, Foreign Tax Paid must be greater than 0
    
        Legacy Rule Format:
        (^PAYEVNTEMP110 = TRUE AND RegexMatch(^PAYEVNTEMP257, 'FEI|JPD', 'i') AND (^PAYEVNTEMP278 = NULL OR ^PAYEVNTEMP278 = 0))
        
        Technical Business Rule Format:
        (^PAYEVNTEMP110 = TRUE AND RegexMatch(^PAYEVNTEMP257, 'FEI|JPD', 'i') AND (^PAYEVNTEMP278 = NULL OR ^PAYEVNTEMP278 = 0))
            
        Data Elements:
            
        ^PAYEVNTEMP278 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:IncomeTax.ForeignWithholding.Amount
            
        ^PAYEVNTEMP110 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration.PayrollEventFinal.Indicator
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000359(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (report.PAYEVNTEMP110 == true && RegexMatch(remuneration.PAYEVNTEMP257, @"FEI|JPD", @"i") && (remuneration.PAYEVNTEMP278 == null || remuneration.PAYEVNTEMP278 == 0));
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000359",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Foreign Tax Paid Amount must be greater than zero when Final Event Indicator is True",
                            LongDescription = @"When the Final Event Indicator is true, and an Income Type Code of FEI or JPD is provided, Foreign Tax Paid must be greater than 0",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IncomeTaxForeignWithholdingA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000359" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP110", Value = GetValueOrEmpty(report.PAYEVNTEMP110) });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP278", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP278) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000359

        #region VR.ATO.PAYEVNTEMP.000360

        /*  VR.ATO.PAYEVNTEMP.000360
        Bonuses and Commissions Amount cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP262 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP262 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP262 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.GrossBonusesAndCommissions.Amount
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000360(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|LAB|OSP", @"i") && remuneration.PAYEVNTEMP262 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000360",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Bonuses and Commissions Amount must be left blank",
                            LongDescription = @"Bonuses and Commissions Amount cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:GrossBonusesAndCommissionsA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000360" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP262", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP262) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000360

        #region VR.ATO.PAYEVNTEMP.000361

        /*  VR.ATO.PAYEVNTEMP.000361
        Overtime Amount cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP263 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP263 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP263 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.OvertimePayment.Amount
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000361(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|LAB|OSP", @"i") && remuneration.PAYEVNTEMP263 != null);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000361",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Overtime Amount must be left blank",
                            LongDescription = @"Overtime Amount cannot be provided under Voluntary Agreement, Labour Hire, or Other Specified Payments",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:OvertimePaymentA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000361" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP263", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP263) });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000361

        #region VR.ATO.PAYEVNTEMP.000362

        /*  VR.ATO.PAYEVNTEMP.000362
        Only 10 Lump Sum Type Codes with the value of E can be provided
    
        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP224, RegexMatch(^PAYEVNTEMP271, 'E', 'i')) > 10

        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP224, RegexMatch(^PAYEVNTEMP271, 'E', 'i')) > 10
    
        Data Elements:
    
        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
    
        ^PAYEVNTEMP224 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum
        */
        public static void VRATOPAYEVNTEMP000362(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = ((remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.Count(PAYEVNTEMP224Repeat => RegexMatch(PAYEVNTEMP224Repeat.PAYEVNTEMP271, @"E", @"i"))) > 10);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000362",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Limit of 10 Lump Sum E's reached",
                            LongDescription = @"Only 10 Lump Sum Type Codes with the value of E can be provided per Income Stream Collection",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:LumpSumCollection/tns:LumpSum/tns:TypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000362" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "Count(PAYEVNTEMP271) = 'E')", Value = (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.Count(PAYEVNTEMP224Repeat => RegexMatch(PAYEVNTEMP224Repeat.PAYEVNTEMP271, @"E", @"i"))).ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000362

        #region VR.ATO.PAYEVNTEMP.000363

        /*  VR.ATO.PAYEVNTEMP.000363
        When the Lump Sum Type Code is E, Lump Sum Financial Year must be provided
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP271, 'E', 'i') AND ^PAYEVNTEMP272 = NULL
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP271, 'E', 'i') AND ^PAYEVNTEMP272 = NULL
                    
        Data Elements:
                    
        ^PAYEVNTEMP272 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumFinancial.Year
                    
        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
        */
        public static void VRATOPAYEVNTEMP000363(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum lumpSum in remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection)
                        {
                            bool assertion = (RegexMatch(lumpSum.PAYEVNTEMP271, @"E", @"i") && lumpSum.PAYEVNTEMP272 == null);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000363",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Lump Sum Financial Year must be provided",
                                    LongDescription = @"When the Lump Sum Type Code is E, Lump Sum Financial Year must be provided",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(lumpSum.OccurrenceIndex) + "/tns:FinancialY",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000363" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP271", Value = lumpSum.PAYEVNTEMP271 });

                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP272", Value = lumpSum.PAYEVNTEMP272.ToString() });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000363

        #region VR.ATO.PAYEVNTEMP.000364

        /*  VR.ATO.PAYEVNTEMP.000364
        When a Deduction Items tuple is provided, an Income Stream Collection must be provided
    
        Legacy Rule Format:
        ^PAYEVNTEMP227 <> NULL AND ^PAYEVNTEMP256 = NULL
        
        Technical Business Rule Format:
        ^PAYEVNTEMP227 <> NULL AND ^PAYEVNTEMP256 = NULL
            
        Data Elements:
            
        ^PAYEVNTEMP227 = PAYEVNTEMP:Payee:PayrollPeriod:Deduction
            
        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        */
        public static void VRATOPAYEVNTEMP000364(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.Payee_PayrollPeriod_DeductionCollectionExists != false && report.Payee_PayrollPeriod_RemunerationCollectionExists == false);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000364",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"An Income Type must be supplied with Deductions",
                    LongDescription = @"When a Deduction Items tuple is provided, an Income Stream Collection must be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:DeductionCollection/tns:Deduction",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000364" } },
                };
                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000364

        #region VR.ATO.PAYEVNTEMP.000367

        /*  VR.ATO.PAYEVNTEMP.000367
        There cannot be more than one of the same Super Entitlement Type Code
    
        Legacy Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP283))

        Technical Business Rule Format:
        (HasDuplicateValues(^PAYEVNTEMP283))
    
        Data Elements:
    
        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
        */
        public static void VRATOPAYEVNTEMP000367(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = HasDuplicateValues(report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? null : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Select(f => f.PAYEVNTEMP283).Cast<object>().ToArray());
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000367",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Duplicate Super Entitlement Type",
                    LongDescription = @"There cannot be more than one of the same Super Entitlement Type Code",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution[" + report.Payee_PayrollPeriod_SuperannuationContributionCollection[DuplicateValueIndex(report.Payee_PayrollPeriod_SuperannuationContributionCollection.Select(f => f.PAYEVNTEMP283))].OccurrenceIndex + "]/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000367" } },
                };
                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000367

        #region VR.ATO.PAYEVNTEMP.000368

        /*  VR.ATO.PAYEVNTEMP.000368
        When an Income Stream Collection is provided, a Super Entitlement Type Code of L, or O must be provided
    
        Legacy Rule Format:
        ^PAYEVNTEMP256 <> NULL AND CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '^[LO]$', 'i')) = 0
        
        Technical Business Rule Format:
        ^PAYEVNTEMP256 <> NULL AND CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '^[LO]$', 'i')) = 0
            
        Data Elements:
            
        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
            
        ^PAYEVNTEMP228 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution
            
        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        */
        public static void VRATOPAYEVNTEMP000368(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.Payee_PayrollPeriod_RemunerationCollectionExists != false && (report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"^[LO]$", @"i"))) == 0);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000368",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Super entitlement year to date must be provided",
                    LongDescription = @"Where an Income Stream Collection is provided, an Super Entitlement Type Code of L, or O must be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000368" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP283", Value = report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? "0" : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"[LO]", @"i")).ToString() });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000368

        #region VR.ATO.PAYEVNTEMP.000370

        /*  VR.ATO.PAYEVNTEMP.000370
        Paid Leave Tuple must not be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP268 <> NULL
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257,'VOL|LAB|OSP', 'i') AND ^PAYEVNTEMP268 <> NULL
            
        Data Elements:
            
        ^PAYEVNTEMP268 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:PaidLeave
            
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code
        */
        public static void VRATOPAYEVNTEMP000370(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (RegexMatch(remuneration.PAYEVNTEMP257, @"VOL|LAB|OSP", @"i") && remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionExists != false);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000370",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Paid Leave Must be left blank",
                            LongDescription = @"Paid Leave Tuple must not be provided under Voluntary Agreement, Labour Hire or Other Specified Payments Income Types",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:PaidLeaveCollection/tns:PaidLeave",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000370" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP268 <> NULL", Value = remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionExists.ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000370

        #region VR.ATO.PAYEVNTEMP.000375

        /*  VR.ATO.PAYEVNTEMP.000375
        When Payee Termination Payment Taxable Component is greater than 0, Payee Total ETP PAYGW Amount must be 0 or greater than 0
            
        Legacy Rule Format:
        ^PAYEVNTEMP51 <> NULL AND ^PAYEVNTEMP51 > 0 AND (^PAYEVNTEMP117 = NULL OR ^PAYEVNTEMP117 < 0)
                
        Technical Business Rule Format:
        ^PAYEVNTEMP51 <> NULL AND ^PAYEVNTEMP51 > 0 AND (^PAYEVNTEMP117 = NULL OR ^PAYEVNTEMP117 < 0)
                    
        Data Elements:
                    
        ^PAYEVNTEMP117 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:EmploymentTerminationPayment:Income.EmploymentTerminationPaymentPayAsYouGoWithholding.Amount
                    
        ^PAYEVNTEMP51 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:EmploymentTerminationPayment:Income.EmploymentTerminationPaymentTaxable.Amount
        */
        public static void VRATOPAYEVNTEMP000375(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment employmentTerminationPayment in remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection)
                        {
                            bool assertion = (employmentTerminationPayment.PAYEVNTEMP51 != null && employmentTerminationPayment.PAYEVNTEMP51.GetValueOrDefault() > 0 && (employmentTerminationPayment.PAYEVNTEMP117 == null || employmentTerminationPayment.PAYEVNTEMP117 < 0));
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000375",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Payee Total ETP PAYGW Amount must be provided",
                                    LongDescription = @"When Payee Termination Payment Taxable Component is greater than 0, Payee Total ETP PAYGW Amount must be 0 or greater than 0",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:EmploymentTerminationPaymentCollection/tns:EmploymentTerminationPayment" + OccurrenceIndex(employmentTerminationPayment.OccurrenceIndex) + "/tns:IncomePayAsYouGoWithholdingA",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000375" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP51", Value = GetValueOrEmpty(employmentTerminationPayment.PAYEVNTEMP51) });

                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP117", Value = GetValueOrEmpty(employmentTerminationPayment.PAYEVNTEMP117) });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000375

        #region VR.ATO.PAYEVNTEMP.000380

        /*  VR.ATO.PAYEVNTEMP.000380
        When  Lump Sum Type Code isn't E, Lump Sum Financial Year must not be provided
            
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP271, 'E', 'i') = FALSE AND ^PAYEVNTEMP272 <> NULL
                
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP271, 'E', 'i') = FALSE AND ^PAYEVNTEMP272 <> NULL
                    
        Data Elements:
                    
        ^PAYEVNTEMP272 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumFinancial.Year
                    
        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
        */
        public static void VRATOPAYEVNTEMP000380(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum lumpSum in remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection)
                        {
                            bool assertion = (RegexMatch(lumpSum.PAYEVNTEMP271, @"E", @"i") == false && lumpSum.PAYEVNTEMP272 != null);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000380",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Lump Sum Financial Year must be left blank",
                                    LongDescription = @"When Lump Sum Type Code isn't E, Lump Sum Financial Year must not be provided",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(lumpSum.OccurrenceIndex) + "/tns:FinancialY",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000380" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP271", Value = lumpSum.PAYEVNTEMP271 });

                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP272", Value = lumpSum.PAYEVNTEMP272.Value.ToString() });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000380

        #region VR.ATO.PAYEVNTEMP.000381

        /*  VR.ATO.PAYEVNTEMP.000381
        When a Super Entitlement Type Code of R is provided and no Income Stream Collection is provided, a Payee TFN must be provided and no other Super Entitlements can be reported
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP283, 'R', 'i') AND ^PAYEVNTEMP256 = NULL AND ^PAYEVNTEMP13 = NULL AND CountOccurrence(^PAYEVNTEMP228, ^PAYEVNTEMP228 <> NULL) <> 1
        
        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP283, 'R', 'i') AND ^PAYEVNTEMP256 = NULL AND ^PAYEVNTEMP13 = NULL AND CountOccurrence(^PAYEVNTEMP228, ^PAYEVNTEMP228 <> NULL) <> 1
            
        Data Elements:
            
        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
            
        ^PAYEVNTEMP13 = PAYEVNTEMP:Payee:Identifiers:Identifiers.TaxFileNumber.Identifier
            
        ^PAYEVNTEMP228 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution
            
        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        */
        public static void VRATOPAYEVNTEMP000381(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            List<PAYEVNTEMP2020.Payee_PayrollPeriod_SuperannuationContribution> contributionCollection = report.Payee_PayrollPeriod_SuperannuationContributionCollection;

            bool assertion =
            contributionCollection != null &&
            contributionCollection.Any(superannuationContribution => RegexMatch(superannuationContribution.PAYEVNTEMP283, "R", "i")) &&
            !report.Payee_PayrollPeriod_RemunerationCollectionExists && report.PAYEVNTEMP13 == null &&
            contributionCollection.Count(payevntemp228 => payevntemp228 != null) != 1;

            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000381",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Payee TFN must be provided and no other Super Entitlements can be reported",
                    LongDescription = @"When a Super Entitlement Type Code of R is provided and no Income Stream Collection is provided, a Payee TFN must be provided and no other Super Entitlements can be reported",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution" + OccurrenceIndex(report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : (report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count() == 0 ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Last().OccurrenceIndex)) + "/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters()
                        {
                            new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000381" },
                            new ProcessMessageParameter { Name = "PAYEVNTEMP283", Value = "R" },
                            new ProcessMessageParameter { Name = "PAYEVNTEMP13", Value = "null" }
                        }
                };

                response.Add(processMessage);
            }

        }

        #endregion // VR.ATO.PAYEVNTEMP.000381

        #region VR.ATO.PAYEVNTEMP.000382

        /*  VR.ATO.PAYEVNTEMP.000382
        There cannot be any occurrence of Lump Sum Type E with the same lump sum financial year
            
        Legacy Rule Format:
        (RegexMatch(^PAYEVNTEMP271, 'E', 'i') AND HasDuplicateValues(^PAYEVNTEMP272))
                
        Technical Business Rule Format:
        (RegexMatch(^PAYEVNTEMP271, 'E', 'i') AND HasDuplicateValues(^PAYEVNTEMP272))
                    
        Data Elements:
                    
        ^PAYEVNTEMP272 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumFinancial.Year
                    
        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
        */
        public static void VRATOPAYEVNTEMP000382(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (HasDuplicateValues(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null ? null : remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP271, @"E", @"i")).Select(f => f.PAYEVNTEMP272).Cast<object>().ToArray()));
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000382",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"There cannot be any occurrence of Lump Sum Type E with the same lump sum financial year",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => RegexMatch(f.PAYEVNTEMP271, @"E", @"i")).Select(f => f.PAYEVNTEMP272))) + "/tns:FinancialY",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000382" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP271", Value = remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => f.PAYEVNTEMP272 != null && RegexMatch(f.PAYEVNTEMP271, @"E", @"i"))[DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => f.PAYEVNTEMP272 != null && RegexMatch(f.PAYEVNTEMP271, @"E", @"i")).Select(f => f.PAYEVNTEMP272))].PAYEVNTEMP271 });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP272", Value = remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => f.PAYEVNTEMP272 != null && RegexMatch(f.PAYEVNTEMP271, @"E", @"i"))[DuplicateValueIndex(remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.FindAll(f => f.PAYEVNTEMP272 != null && RegexMatch(f.PAYEVNTEMP271, @"E", @"i")).Select(f => f.PAYEVNTEMP272))].PAYEVNTEMP272.Value.ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000382

        #region VR.ATO.PAYEVNTEMP.000384

        /*  VR.ATO.PAYEVNTEMP.000384
        When Medicare Levy Surcharge is provided in the fourth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, or FF

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >3 AND (RegexMatch(Substring(^PAYEVNTEMP254, 3, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|FF', 'i'))

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >3 AND (RegexMatch(Substring(^PAYEVNTEMP254, 3, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|FF', 'i'))

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000384(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 3 && (RegexMatch(Substring(report.PAYEVNTEMP254, 3, 1), @"X", @"i") == false && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|FF", @"i")));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000384",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Medicare Levy Surcharge not valid for first two characters of Tax Treatment Code",
                    LongDescription = @"When Medicare Levy Surcharge is provided in the fourth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, or FF",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000384" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000384

        #region VR.ATO.PAYEVNTEMP.000385

        /*  VR.ATO.PAYEVNTEMP.000385
        When Medicare Levy Exemption is provided in the fifth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, RN, AN, or FF

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >4 AND RegexMatch(Substring(^PAYEVNTEMP254, 4, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF', 'i')

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >4 AND RegexMatch(Substring(^PAYEVNTEMP254, 4, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF', 'i')

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000385(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 4 && RegexMatch(Substring(report.PAYEVNTEMP254, 4, 1), @"X", @"i") == false && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF", @"i"));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000385",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Medicare Levy Exemption not valid for first two characters of Tax Treatment Code",
                    LongDescription = @"When Medicare Levy Exemption is provided in the fifth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, RN, AN, or FF",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000385" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000385

        #region VR.ATO.PAYEVNTEMP.000386

        /*  VR.ATO.PAYEVNTEMP.000386
        When Medicare Levy Reduction is provided in the Sixth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, RN, AN, or FF

        Legacy Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF', 'i')

        Technical Business Rule Format:
        ^PAYEVNTEMP254 <> NULL AND Length(^PAYEVNTEMP254) >5 AND RegexMatch(Substring(^PAYEVNTEMP254, 5, 1), 'X', 'i') = FALSE AND RegexMatch(Substring(^PAYEVNTEMP254, 0, 2),'RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF', 'i')

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000386(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) > 5 && RegexMatch(Substring(report.PAYEVNTEMP254, 5, 1), @"X", @"i") == false && RegexMatch(Substring(report.PAYEVNTEMP254, 0, 2), @"RD|AD|AP|CT|CF|HR|HU|HF|WP|NF|NA|DB|DV|DZ|VC|VO|RN|AN|FF", @"i"));
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000386",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Medicare Levy Reduction not valid for first two characters of Tax Treatment Code",
                    LongDescription = @"When Medicare Levy Reduction is provided in the Sixth character of the Tax Treatment Code, the first two characters must not be one the following: RD, AD, AP, CT, CF, HR, HU, HF, WP, NF, NA, DB, DV, DZ, VC, VO, RN, AN, or FF",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000386" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000386

        #region VR.ATO.PAYEVNTEMP.000388

        public static void VRATOPAYEVNTEMP000388(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            /*  VR.ATO.PAYEVNTEMP.000388
            Lump Sum Payment Amount may only be negative when Lump Sum Type Code is W

            Legacy Rule Format:
            (^PAYEVNTEMP273 < 0 AND ^PAYEVNTEMP271 <> 'W')

            Technical Business Rule Format:
            ^PAYEVNTEMP273 < 0 AND ^PAYEVNTEMP271 <> 'W'

            Data Elements:

            ^PAYEVNTEMP273 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumPayments.Amount

            ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
            */

            ProcessMessageDocument processMessage;
            bool assertion = false;

            PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration invalidRemuneration = null;
            PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum invalidLumpSum = null;

            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null) continue;
                    foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum lumpSum in remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection)
                    {
                        assertion = lumpSum?.PAYEVNTEMP273 < 0 && lumpSum?.PAYEVNTEMP271?.ToUpper() != "W";
                        if (assertion)
                        {
                            invalidRemuneration = remuneration;
                            invalidLumpSum = lumpSum;
                            break;
                        }
                    }
                    if (assertion) break;
                }
            }

            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000388",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Lump Sum Payment Amount must not be negative",
                    LongDescription = @"Lump Sum Payment Amount may only be negative when Lump Sum Type Code is W",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(invalidRemuneration.OccurrenceIndex) + "/tns:LumpSumCollection/tns:LumpSum" + OccurrenceIndex(invalidLumpSum.OccurrenceIndex) + "/tns:PaymentsA",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000388" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP273", Value = GetValueOrEmpty(invalidLumpSum.PAYEVNTEMP273) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP271", Value = invalidLumpSum.PAYEVNTEMP271 });

                response.Add(processMessage);
            }
        }

        #endregion

        #region VR.ATO.PAYEVNTEMP.000389

        public static void VRATOPAYEVNTEMP000389(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            /*  VR.ATO.PAYEVNTEMP.000389
            Negative YTD values have resulted in a derived aggregated gross YTD amount that is less than zero. Review the negative amounts reported to ensure the derived aggregated gross YTD amount will result in an amount equal to or greater than zero.
    
            Legacy Rule Format:
            AnyOccurrence(^PAYEVNTEMP256, (^PAYEVNTEMP258 + SUM(^PAYEVNTEMP270) + SUM(^PAYEVNTEMP62) + ^PAYEVNTEMP263 + ^PAYEVNTEMP262 + ^PAYEVNTEMP264 + SUM(ConditionalValue(RegexMatch(^PAYEVNTEMP271, 'W', 'i'), ^PAYEVNTEMP273, 0)) - SUM(^PAYEVNTEMP267)) < 0)

            Technical Business Rule Format:
            AnyOccurrence(^PAYEVNTEMP256, (^PAYEVNTEMP258 + SUM(^PAYEVNTEMP270) + SUM(^PAYEVNTEMP62) + ^PAYEVNTEMP263 + ^PAYEVNTEMP262 + ^PAYEVNTEMP264 + SUM(ConditionalValue(RegexMatch(^PAYEVNTEMP271, 'W', 'i'), ^PAYEVNTEMP273, 0)) - SUM(^PAYEVNTEMP267)) < 0)
    
            Data Elements:
    
            ^PAYEVNTEMP258 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.Gross.Amount
    
            ^PAYEVNTEMP62 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.EmploymentAllowances.Amount
    
            ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
    
            ^PAYEVNTEMP262 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.GrossBonusesAndCommissions.Amount
    
            ^PAYEVNTEMP263 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.OvertimePayment.Amount
    
            ^PAYEVNTEMP264 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.GrossDirectorsFees.Amount
    
            ^PAYEVNTEMP267 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:SalarySacrifice:Remuneration.SalarySacrificePayment.Amount
    
            ^PAYEVNTEMP270 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:PaidLeave:Remuneration.PaidLeavePayment.Amount

            ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
    
            ^PAYEVNTEMP273 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumPayments.Amount
            */

            ProcessMessageDocument processMessage;
            bool assertion;

            assertion = report.Payee_PayrollPeriod_RemunerationCollection != null && report.Payee_PayrollPeriod_RemunerationCollection.Any(tuple => tuple.PAYEVNTEMP258.GetValueOrDefault() + (tuple.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection?.Sum(PAYEVNTEMP270Collection => PAYEVNTEMP270Collection.PAYEVNTEMP270) ?? 0) + (tuple.Payee_PayrollPeriod_Remuneration_AllowanceCollection?.Sum(PAYEVNTEMP62Collection => PAYEVNTEMP62Collection.PAYEVNTEMP62) ?? 0) + tuple.PAYEVNTEMP263.GetValueOrDefault() + tuple.PAYEVNTEMP262.GetValueOrDefault() + tuple.PAYEVNTEMP264.GetValueOrDefault() + (tuple.Payee_PayrollPeriod_Remuneration_LumpSumCollection?.FindAll(PAYEVNTEMP271Collection => !string.IsNullOrEmpty(PAYEVNTEMP271Collection.PAYEVNTEMP271) && Regex.IsMatch(PAYEVNTEMP271Collection.PAYEVNTEMP271, "W", RegexOptions.IgnoreCase)).Sum(PAYEVNTEMP273Collection => PAYEVNTEMP273Collection.PAYEVNTEMP273) ?? 0) - (tuple.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection?.Sum(PAYEVNTEMP267Collection => PAYEVNTEMP267Collection.PAYEVNTEMP267) ?? 0) < 0);
            
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000389",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"The derived aggregated gross YTD amount must not be a negative amount",
                    LongDescription = @"Negative YTD values have resulted in a derived aggregated gross YTD amount that is less than zero. Review the negative amounts reported to ensure the derived aggregated gross YTD amount will result in an amount equal to or greater than zero.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:GrossA",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000389" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP258", Value = "PAYEVNTEMP258" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP270", Value = "PAYEVNTEMP270" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP62", Value = "PAYEVNTEMP62" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP263", Value = "PAYEVNTEMP263" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP262", Value = "PAYEVNTEMP262" });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP264", Value = "PAYEVNTEMP264" });
                
                response.Add(processMessage);
            }
        }

        #endregion

        #region VR.ATO.PAYEVNTEMP.000391

        /*  VR.ATO.PAYEVNTEMP.000391
        When a Super Entitlement Type Code of O is provided, an Income Stream Collection must be provided
    
        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '[O]', 'i')) >= 1 AND ^PAYEVNTEMP256 = NULL
        
        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '[O]', 'i')) >= 1 AND ^PAYEVNTEMP256 = NULL
            
        Data Elements:
            
        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code
            
        ^PAYEVNTEMP228 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution
            
        ^PAYEVNTEMP256 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration
        */
        public static void VRATOPAYEVNTEMP000391(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = report.Payee_PayrollPeriod_SuperannuationContributionCollection != null && report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP283Repeat => RegexMatch(PAYEVNTEMP283Repeat.PAYEVNTEMP283, "O", "i")) >= 1 && report.Payee_PayrollPeriod_RemunerationCollectionExists == false;
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000391",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Income Stream Collection must be provided",
                    LongDescription = @"When a Super Entitlement Type Code of O is provided, an Income Stream Collection must be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000391" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP256", Value = "null" });
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "Count(PAYEVNTEMP283 = 'O')", Value = report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? "0" : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"O", @"i")).ToString() });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000391

        #region VR.ATO.PAYEVNTEMP.000392

        /*  VR.ATO.PAYEVNTEMP.000392
        When an Income Stream Type Code is FEI, a Lump Sum Type Code of B cannot be provided
    
        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND CountOccurrence(RegexMatch(^PAYEVNTEMP271, 'B', 'i')) >= 1

        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP257, 'FEI', 'i') AND CountOccurrence(RegexMatch(^PAYEVNTEMP271, 'B', 'i')) >= 1
    
        Data Elements:
    
        ^PAYEVNTEMP257 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IncomeStreamType.Code

        ^PAYEVNTEMP271 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum:Remuneration.LumpSumType.Code
    
        ^PAYEVNTEMP224 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:LumpSum
        */
        public static void VRATOPAYEVNTEMP000392(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = RegexMatch(remuneration.PAYEVNTEMP257, @"FEI", @"i") && ((remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.Count(PAYEVNTEMP224Repeat => RegexMatch(PAYEVNTEMP224Repeat.PAYEVNTEMP271, @"B", @"i"))) >= 1);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000392",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Lump Sum Type Code of B must not be provided",
                            LongDescription = @"When an Income Stream Type Code is FEI, a Lump Sum Type Code of B cannot be provided",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration/tns:LumpSumCollection/tns:LumpSum/tns:TypeC",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000392" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP257", Value = remuneration.PAYEVNTEMP257 });
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "Count(PAYEVNTEMP271 = 'B')", Value = (remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection == null ? 0 : remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.Count(PAYEVNTEMP224Repeat => RegexMatch(PAYEVNTEMP224Repeat.PAYEVNTEMP271, @"B", @"i"))).ToString() });

                        response.Add(processMessage);
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000392

        #region VR.ATO.PAYEVNTEMP.000395

        /*  VR.ATO.PAYEVNTEMP.000395
        CDEP Amount reporting has ceased, CDEP Amount must be 0 or blank.

        Legacy Rule Format:
        ^PAYEVNTEMP279 <> NULL AND ^PAYEVNTEMP279 <> 0

        Technical Business Rule Format:
        ^PAYEVNTEMP279 <> NULL AND ^PAYEVNTEMP279 <> 0

        Data Elements:

        ^PAYEVNTEMP279 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Remuneration.IndividualNonBusinessCommunityDevelopmentEmploymentProject.Amount
        */
        public static void VRATOPAYEVNTEMP000395(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    bool assertion = (remuneration.PAYEVNTEMP279 != null && remuneration.PAYEVNTEMP279 != 0);
                    if (assertion)
                    {
                        ProcessMessageDocument processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.PAYEVNTEMP.000394",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"CDEP Amount reporting has ceased",
                            LongDescription = @"CDEP Amount reporting has ceased, CDEP Amount must be 0 or blank.",
                            Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:IndividualNonBusinessCommunityDevelopmentEmploymentProjectA",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000395" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "PAYEVNTEMP279", Value = GetValueOrEmpty(remuneration.PAYEVNTEMP279) });

                        response.Add(processMessage);
                    }
                }
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000395

        #region VR.ATO.PAYEVNTEMP.000396

        /*  VR.ATO.PAYEVNTEMP.000396
        Other Allowance Type Description must only be entered when Allowance Type Code "OD" is selected

        Legacy Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'OD', 'i') = FALSE AND ^PAYEVNTEMP8 <> NULLORBLANK

        Technical Business Rule Format:
        RegexMatch(^PAYEVNTEMP7, 'OD', 'i') = FALSE AND ^PAYEVNTEMP8 <> BLANK

        Data Elements:

        ^PAYEVNTEMP8 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.OtherAllowanceType.Description

        ^PAYEVNTEMP7 = PAYEVNTEMP:Payee:PayrollPeriod:Remuneration:Allowance:Remuneration.AllowanceType.Code
        */
        public static void VRATOPAYEVNTEMP000396(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            if (report.Payee_PayrollPeriod_RemunerationCollection != null)
            {
                foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration in report.Payee_PayrollPeriod_RemunerationCollection)
                {
                    if (remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection != null)
                    {
                        foreach (PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance allowance in remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection)
                        {
                            bool assertion = (RegexMatch(allowance.PAYEVNTEMP7, @"OD", @"i") == false && string.IsNullOrWhiteSpace(allowance.PAYEVNTEMP8) != true);
                            if (assertion)
                            {
                                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                                {
                                    Code = "CMN.ATO.PAYEVNTEMP.000396",
                                    Severity = ProcessMessageSeverity.Error,
                                    Description = @"Other Allowance Type Description must be blank",
                                    LongDescription = @"Other Allowance Type Description must only be entered when Allowance Type Code ""OD"" is selected",
                                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:RemunerationCollection/tns:Remuneration" + OccurrenceIndex(remuneration.OccurrenceIndex) + "/tns:AllowanceCollection/tns:Allowance" + OccurrenceIndex(allowance.OccurrenceIndex) + "/tns:OtherAllowanceTypeDe",
                                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000396" } },
                                };
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP7", Value = allowance.PAYEVNTEMP7 });
                                processMessage.Parameters.Add(new ProcessMessageParameter
                                { Name = "PAYEVNTEMP8", Value = GetValueOrEmpty(allowance.PAYEVNTEMP8) });

                                response.Add(processMessage);
                            }
                        }
                    }
                }
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000396

        #region VR.ATO.PAYEVNTEMP.000397

        /*  VR.ATO.PAYEVNTEMP.000397
        Tax Treatment Code must have a length of 6 characters.

        Legacy Rule Format:
        Length(^PAYEVNTEMP254) < 6

        Technical Business Rule Format:
        Length(^PAYEVNTEMP254) < 6

        Data Elements:

        ^PAYEVNTEMP254 = PAYEVNTEMP:Payee:EmployerConditions:EmployerConditions.TaxTreatment.Code
        */
        public static void VRATOPAYEVNTEMP000397(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = (report.PAYEVNTEMP254 != null && Length(report.PAYEVNTEMP254) != 6);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000397",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Tax Treatment Code must be 6 characters long",
                    LongDescription = @"Tax Treatment Code must have a length of 6 characters.",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:EmployerConditions/tns:TaxTreatmentC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000397" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP254", Value = GetValueOrEmpty(report.PAYEVNTEMP254) });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000397
		
		#region VR.ATO.PAYEVNTEMP.000400

        /*  VR.ATO.PAYEVNTEMP.000400
        Super Entitlement Type Codes of either O (Ordinary Time Earnings) or Q (Qualifying Earnings) can be provided, not both

        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '^[OQ]$', 'i')) = 2

        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, '^[OQ]$', 'i')) = 2

        Data Elements:

        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code

        ^PAYEVNTEMP228 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution
        */
        public static void VRATOPAYEVNTEMP000400(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
            {
                bool assertion = ((report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"^[OQ]$", @"i"))) == 2);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000400",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Combination of Super Entitlement Type Codes O and Q invalid",
                    LongDescription = @"Super Entitlement Type Codes of either O (Ordinary Time Earnings) or Q (Qualifying Earnings) can be provided, not both",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000400" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP283", Value = "Count(PAYEVNTEMP283)" });
                response.Add(processMessage);
            }
        }
        #endregion

        #region VR.ATO.PAYEVNTEMP.000401

        /*  VR.ATO.PAYEVNTEMP.000401
        When Super entitlement year to date details for Q (Qualifying Earnings) are provided, Super entitlement year to date details for L (Superannuation Liability) must also be provided

        Legacy Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, 'Q', 'i')) = 1 AND CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, 'L', 'i')) = 0

        Technical Business Rule Format:
        CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, 'Q', 'i')) = 1 AND CountOccurrence(^PAYEVNTEMP228, RegexMatch(^PAYEVNTEMP283, 'L', 'i')) = 0

        Data Elements:

        ^PAYEVNTEMP283 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution:SuperannuationContribution.EntitlementType.Code

        ^PAYEVNTEMP228 = PAYEVNTEMP:Payee:PayrollPeriod:SuperannuationContribution
        */
        public static void VRATOPAYEVNTEMP000401(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = ((report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"Q", @"i"))) == 1 && (report.Payee_PayrollPeriod_SuperannuationContributionCollection == null ? 0 : report.Payee_PayrollPeriod_SuperannuationContributionCollection.Count(PAYEVNTEMP228Repeat => RegexMatch(PAYEVNTEMP228Repeat.PAYEVNTEMP283, @"L", @"i"))) == 0);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000401",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Super Entitlement Type Code L must be provided",
                    LongDescription = @"When Super entitlement year to date details for Q (Qualifying Earnings) are provided, Super entitlement year to date details for L (Superannuation Liability) must also be provided",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:SuperannuationContributionCollection/tns:SuperannuationContribution/tns:EntitlementTypeC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000401" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter 
                { Name = "PAYEVNTEMP283", Value = "Count(PAYEVNTEMP283)" });
                response.Add(processMessage);
            }
        }
        #endregion

    }
}