
using System;
using System.Collections.Generic;

namespace Ato.EN.IntegrationServices.CodeGenerationDIS
{
    public class DIS2018
    {
    
    public string RPId = null;
    public bool RPExists = false;
    public int RPCount = 0;
    public int RPOccurrenceIndex = 0;
    public int RPLastOccurrenceIndex = 0;
    public string RPIdentifier = null;
    public string RPIdentifierScheme = null;
        public string RPIdentifierTFN = null;
        public DateTime? RPStartDate = null;
        public DateTime? RPEndDate = null;

        /// <summary>
        /// RP:tns:Identifiers.TaxFileNumber.Identifier
        /// </summary>
        public string DIS22 = null;

        /// <summary>
        /// RP:tns:Report.TargetFinancial.Year
        /// </summary>
        public int? DIS42 = null;

        /// <summary>
        /// RP:tns:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string DIS23 = null;
    
        public bool OrganisationNameDetailsCollectionExists = false;
        public int OrganisationNameDetailsCollectionCount = 0;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
         /// </summary>
        public bool OrganisationNameDetailsCollection_MN_RPExists = false;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_RPCount = 0;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Occurrence Index
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_RPOccurrenceIndex = 0;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Last Occurrence Index
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:OrganisationNameDetails
        /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
        /// RP:tns:OrganisationNameDetails.OrganisationalNameType.Code
        /// </summary>
        public string DIS34 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:OrganisationNameDetails
        /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
        /// RP:tns:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string DIS24 = null;
    
        public bool PersonUnstructuredNameCollectionExists = false;
        public int PersonUnstructuredNameCollectionCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact']
         /// </summary>
        public bool PersonUnstructuredNameCollection_Contact_RPExists = false;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact']
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_RPCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact'] Occurrence Index
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_RPOccurrenceIndex = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact'] Last Occurrence Index
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='Contact']
        /// RP:tns:PersonUnstructuredName.Usage.Code
        /// </summary>
        public string DIS36 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='Contact']
        /// RP:tns:PersonUnstructuredName.FullName.Text
        /// </summary>
        public string DIS25 = null;
    
        public bool ElectronicContactTelephoneCollectionExists = false;
        public int ElectronicContactTelephoneCollectionCount = 0;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03']
         /// </summary>
        public bool ElectronicContactTelephoneCollection_03_RPExists = false;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03']
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_RPCount = 0;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03'] Occurrence Index
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_RPOccurrenceIndex = 0;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03'] Last Occurrence Index
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// RP:tns:ElectronicContact.Telephone.Usage.Code
        /// </summary>
        public string DIS32 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// RP:tns:ElectronicContact.Telephone.ServiceLine.Code
        /// </summary>
        public string DIS33 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// RP:tns:ElectronicContact.Telephone.Area.Code
        /// </summary>
        public string DIS26 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// RP:tns:ElectronicContact.Telephone.Minimal.Number
        /// </summary>
        public string DIS27 = null;
    
        public bool AddressDetailsCollectionExists = false;
        public int AddressDetailsCollectionCount = 0;

         /// <summary>
         /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
         /// </summary>
        public bool AddressDetailsCollection_BUS_C_RPExists = false;

         /// <summary>
         /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
         /// </summary>
        public int AddressDetailsCollection_BUS_C_RPCount = 0;

         /// <summary>
         /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C'] Occurrence Index
         /// </summary>
        public int AddressDetailsCollection_BUS_C_RPOccurrenceIndex = 0;

         /// <summary>
         /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C'] Last Occurrence Index
         /// </summary>
        public int AddressDetailsCollection_BUS_C_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.OverseasAddress.Indicator
        /// </summary>
        public bool? DIS45 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Usage.Code
        /// </summary>
        public string DIS46 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Currency.Code
        /// </summary>
        public string DIS47 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line1.Text
        /// </summary>
        public string DIS48 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line2.Text
        /// </summary>
        public string DIS49 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line3.Text
        /// </summary>
        public string DIS50 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line4.Text
        /// </summary>
        public string DIS51 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.LocalityName.Text
        /// </summary>
        public string DIS52 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Postcode.Text
        /// </summary>
        public string DIS56 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.StateOrTerritory.Code
        /// </summary>
        public string DIS57 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.CountryName.Text
        /// </summary>
        public string DIS58 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='BUS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Country.Code
        /// </summary>
        public string DIS59 = null;

         /// <summary>
         /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
         /// </summary>
        public bool AddressDetailsCollection_POS_C_RPExists = false;

         /// <summary>
         /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
         /// </summary>
        public int AddressDetailsCollection_POS_C_RPCount = 0;

         /// <summary>
         /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C'] Occurrence Index
         /// </summary>
        public int AddressDetailsCollection_POS_C_RPOccurrenceIndex = 0;

         /// <summary>
         /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C'] Last Occurrence Index
         /// </summary>
        public int AddressDetailsCollection_POS_C_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.OverseasAddress.Indicator
        /// </summary>
        public bool? DIS60 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Usage.Code
        /// </summary>
        public string DIS61 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Currency.Code
        /// </summary>
        public string DIS62 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line1.Text
        /// </summary>
        public string DIS64 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line2.Text
        /// </summary>
        public string DIS65 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line3.Text
        /// </summary>
        public string DIS66 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Line4.Text
        /// </summary>
        public string DIS67 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.LocalityName.Text
        /// </summary>
        public string DIS69 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Postcode.Text
        /// </summary>
        public string DIS70 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.StateOrTerritory.Code
        /// </summary>
        public string DIS71 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.CountryName.Text
        /// </summary>
        public string DIS72 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:AddressDetails
        /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
        /// RP:tns:AddressDetails.Country.Code
        /// </summary>
        public string DIS73 = null;
    
        public bool InvestorCollectionExists = false;
        public int InvestorCollectionCount = 0;

        public List<Investor> InvestorCollection = null;

        public class Investor 
        {
            public int OccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:Identifiers.TaxFileNumber.Identifier
            /// </summary>
            public string DIS1 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:Identifiers.AustralianBusinessNumber.Identifier
            /// </summary>
            public string DIS2 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:PersonDemographicDetails.Birth.Date
            /// </summary>
            public DateTime? DIS13 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:IncomeTax.FrankingCredits.ReceivedFromAustralianCompanies.Amount
            /// </summary>
            public decimal? DIS16 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:Equity.Dividends.FrankedPaid.Amount
            /// </summary>
            public decimal? DIS17 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:Expense.Interest.Paid.Amount
            /// </summary>
            public decimal? DIS20 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:Party.Type.Code
            /// </summary>
            public string DIS15 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RP:tns:PersonDemographicDetails.Deceased.Indicator
            /// </summary>
            public bool? DIS44 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RPCFI:tns:Equity.Dividends.UnfrankedPaid.Amount
            /// </summary>
            public decimal? DIS19 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor
            /// RPNONCFI:tns:Equity.Dividends.UnfrankedPaid.Amount
            /// </summary>
            public decimal? DIS18 = null;

            public bool Investor_PersonNameDetailsCollectionExists = false;
            public int Investor_PersonNameDetailsCollectionCount = 0;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:PersonNameDetails
            /// RP:tns:PersonNameDetails.FamilyName.Text
            /// </summary>
            public string DIS4 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:PersonNameDetails
            /// RP:tns:PersonNameDetails.GivenName.Text
            /// </summary>
            public string DIS5 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:PersonNameDetails
            /// RP:tns:PersonNameDetails.OtherGivenName.Text
            /// </summary>
            public string DIS6 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:PersonNameDetails
            /// RP:tns:PersonNameDetails.Position.Text
            /// </summary>
            public string DIS55 = null;

            public bool Investor_OrganisationNameDetailsCollectionExists = false;
            public int Investor_OrganisationNameDetailsCollectionCount = 0;
    
             /// <summary>
             /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
             /// </summary>
            public bool Investor_OrganisationNameDetailsCollection_MN_RPExists = false;
    
             /// <summary>
             /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
             /// </summary>
            public int Investor_OrganisationNameDetailsCollection_MN_RPCount = 0;
    
             /// <summary>
             /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Occurrence Index
             /// </summary>
            public int Investor_OrganisationNameDetailsCollection_MN_RPOccurrenceIndex = 0;
    
             /// <summary>
             /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Last Occurrence Index
             /// </summary>
            public int Investor_OrganisationNameDetailsCollection_MN_RPLastOccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:OrganisationNameDetails
            /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
            /// RP:tns:OrganisationNameDetails.OrganisationalName.Text
            /// </summary>
            public string DIS3 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:OrganisationNameDetails
            /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
            /// RP:tns:OrganisationNameDetails.OrganisationalNameType.Code
            /// </summary>
            public string DIS53 = null;

            public bool Investor_AddressDetailsCollectionExists = false;
            public int Investor_AddressDetailsCollectionCount = 0;
    
             /// <summary>
             /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
             /// </summary>
            public bool Investor_AddressDetailsCollection_POS_C_RPExists = false;
    
             /// <summary>
             /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
             /// </summary>
            public int Investor_AddressDetailsCollection_POS_C_RPCount = 0;
    
             /// <summary>
             /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C'] Occurrence Index
             /// </summary>
            public int Investor_AddressDetailsCollection_POS_C_RPOccurrenceIndex = 0;
    
             /// <summary>
             /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C'] Last Occurrence Index
             /// </summary>
            public int Investor_AddressDetailsCollection_POS_C_RPLastOccurrenceIndex = 0;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.OverseasAddress.Indicator
            /// </summary>
            public bool? DIS41 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Usage.Code
            /// </summary>
            public string DIS37 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Currency.Code
            /// </summary>
            public string DIS54 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Line1.Text
            /// </summary>
            public string DIS7 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Line2.Text
            /// </summary>
            public string DIS8 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Line3.Text
            /// </summary>
            public string DIS38 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Line4.Text
            /// </summary>
            public string DIS39 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.LocalityName.Text
            /// </summary>
            public string DIS9 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Postcode.Text
            /// </summary>
            public string DIS11 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.StateOrTerritory.Code
            /// </summary>
            public string DIS10 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.CountryName.Text
            /// </summary>
            public string DIS12 = null;
    
            /// <summary>
            /// /xbrli:xbrl/tns:Investor/tns:AddressDetails
            /// [AddressDetails.Usage.Code='POS'].[AddressDetails.Currency.Code='C']
            /// RP:tns:AddressDetails.Country.Code
            /// </summary>
            public string DIS40 = null;
        }
    
        public bool DeclarationCollectionExists = false;
        public int DeclarationCollectionCount = 0;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect']
         /// </summary>
        public bool DeclarationCollection_TrueAndCorrect_RPExists = false;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect']
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_RPCount = 0;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect'] Occurrence Index
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_RPOccurrenceIndex = 0;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect'] Last Occurrence Index
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// RP:tns:Declaration.StatementType.Code
        /// </summary>
        public string DIS74 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// RP:tns:Declaration.StatementAccepted.Indicator
        /// </summary>
        public bool? DIS75 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// RP:tns:Declaration.Statement.Text
        /// </summary>
        public string DIS76 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// RP:tns:Declaration.Signature.Date
        /// </summary>
        public DateTime? DIS77 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// RP:tns:Declaration.SignatoryIdentifier.Text
        /// </summary>
        public string DIS78 = null;
    
        public bool Declaration_PersonUnstructuredNameCollectionExists = false;
        public int Declaration_PersonUnstructuredNameCollectionCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
         /// </summary>
        public bool Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_RPExists = false;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_RPCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory'] Occurrence Index
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_RPOccurrenceIndex = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory'] Last Occurrence Index
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_RPLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
        /// RP:tns:PersonUnstructuredName.Usage.Code
        /// </summary>
        public string DIS79 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
        /// RP:tns:PersonUnstructuredName.FullName.Text
        /// </summary>
        public string DIS80 = null;

        public string RPCFIId = null;
        public bool RPCFIExists = false;
        public int RPCFICount = 0;
        public int RPCFIOccurrenceIndex = 0;
        public int RPCFILastOccurrenceIndex = 0;
        public string RPCFIIdentifier = null;
        public string RPCFIIdentifierScheme = null;
        public string RPCFIIdentifierTFN = null;
        public DateTime? RPCFIStartDate = null;
        public DateTime? RPCFIEndDate = null;

        public string RPNONCFIId = null;
        public bool RPNONCFIExists = false;
        public int RPNONCFICount = 0;
        public int RPNONCFIOccurrenceIndex = 0;
        public int RPNONCFILastOccurrenceIndex = 0;
        public string RPNONCFIIdentifier = null;
        public string RPNONCFIIdentifierScheme = null;
        public string RPNONCFIIdentifierTFN = null;
        public DateTime? RPNONCFIStartDate = null;
        public DateTime? RPNONCFIEndDate = null;

        public string INTId = null;
        public bool INTExists = false;
        public int INTCount = 0;
        public int INTOccurrenceIndex = 0;
        public int INTLastOccurrenceIndex = 0;
        public string INTIdentifier = null;
        public string INTIdentifierScheme = null;
        public string INTIdentifierABN = null;
        public DateTime? INTStartDate = null;
        public DateTime? INTEndDate = null;

        /// <summary>
        /// INT:tns:Identifiers.AustralianBusinessNumber.Identifier
        /// </summary>
        public string DIS63 = null;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect']
         /// </summary>
        public bool DeclarationCollection_TrueAndCorrect_INTExists = false;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect']
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_INTCount = 0;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect'] Occurrence Index
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_INTOccurrenceIndex = 0;

         /// <summary>
         /// [Declaration.StatementType.Code='TrueAndCorrect'] Last Occurrence Index
         /// </summary>
        public int DeclarationCollection_TrueAndCorrect_INTLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// INT:tns:Declaration.StatementType.Code
        /// </summary>
        public string DIS81 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// INT:tns:Declaration.StatementAccepted.Indicator
        /// </summary>
        public bool? DIS82 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// INT:tns:Declaration.Statement.Text
        /// </summary>
        public string DIS83 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// INT:tns:Declaration.Signature.Date
        /// </summary>
        public DateTime? DIS84 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration
        /// [Declaration.StatementType.Code='TrueAndCorrect']
        /// INT:tns:Declaration.SignatoryIdentifier.Text
        /// </summary>
        public string DIS85 = null;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
         /// </summary>
        public bool Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_INTExists = false;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_INTCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory'] Occurrence Index
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_INTOccurrenceIndex = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory'] Last Occurrence Index
         /// </summary>
        public int Declaration_PersonUnstructuredNameCollection_DeclarationSignatory_INTLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
        /// INT:tns:PersonUnstructuredName.Usage.Code
        /// </summary>
        public string DIS86 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:Declaration/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='DeclarationSignatory']
        /// INT:tns:PersonUnstructuredName.FullName.Text
        /// </summary>
        public string DIS87 = null;

        /// <summary>
        /// INT:tns:Identifiers.TaxAgentNumber.Identifier
        /// </summary>
        public string DIS68 = null;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
         /// </summary>
        public bool OrganisationNameDetailsCollection_MN_INTExists = false;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_INTCount = 0;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Occurrence Index
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_INTOccurrenceIndex = 0;

         /// <summary>
         /// [OrganisationNameDetails.OrganisationalNameType.Code='MN'] Last Occurrence Index
         /// </summary>
        public int OrganisationNameDetailsCollection_MN_INTLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:OrganisationNameDetails
        /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
        /// INT:tns:OrganisationNameDetails.OrganisationalNameType.Code
        /// </summary>
        public string DIS90 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:OrganisationNameDetails
        /// [OrganisationNameDetails.OrganisationalNameType.Code='MN']
        /// INT:tns:OrganisationNameDetails.OrganisationalName.Text
        /// </summary>
        public string DIS91 = null;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03']
         /// </summary>
        public bool ElectronicContactTelephoneCollection_03_INTExists = false;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03']
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_INTCount = 0;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03'] Occurrence Index
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_INTOccurrenceIndex = 0;

         /// <summary>
         /// [ElectronicContact.Telephone.Usage.Code='03'] Last Occurrence Index
         /// </summary>
        public int ElectronicContactTelephoneCollection_03_INTLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// INT:tns:ElectronicContact.Telephone.Usage.Code
        /// </summary>
        public string DIS92 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// INT:tns:ElectronicContact.Telephone.ServiceLine.Code
        /// </summary>
        public string DIS93 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// INT:tns:ElectronicContact.Telephone.Area.Code
        /// </summary>
        public string DIS94 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:ElectronicContactTelephone
        /// [ElectronicContact.Telephone.Usage.Code='03']
        /// INT:tns:ElectronicContact.Telephone.Minimal.Number
        /// </summary>
        public string DIS95 = null;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact']
         /// </summary>
        public bool PersonUnstructuredNameCollection_Contact_INTExists = false;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact']
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_INTCount = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact'] Occurrence Index
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_INTOccurrenceIndex = 0;

         /// <summary>
         /// [PersonUnstructuredName.Usage.Code='Contact'] Last Occurrence Index
         /// </summary>
        public int PersonUnstructuredNameCollection_Contact_INTLastOccurrenceIndex = 0;

        /// <summary>
        /// /xbrli:xbrl/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='Contact']
        /// INT:tns:PersonUnstructuredName.Usage.Code
        /// </summary>
        public string DIS88 = null;

        /// <summary>
        /// /xbrli:xbrl/tns:PersonUnstructuredName
        /// [PersonUnstructuredName.Usage.Code='Contact']
        /// INT:tns:PersonUnstructuredName.FullName.Text
        /// </summary>
        public string DIS89 = null;

    }
}