using System;
using System.Collections.Generic;
using DataContracts;

namespace Ato.EN.IntegrationServices.CodeGenerationIEE {
    public partial class IEE2021Validator {

        #region Manual Rules - Rules marked for manual coding

        #region VR.ATO.IEE.410497

        /*  VR.ATO.IEE.410497
                    Trustee/partner Declaration Family name and Given name or non individual name must match at least one Trustee or partner Family name and Given name or non individual name.

                Legacy Rule Format:
                    (^IEE116 = 'E') AND ^IEE1030 <> NULL AND ((AnyOccurrence(^IEE28, ^IEE28 <> ^IEE303)) OR (AnyOccurrence(^IEE30, ^IEE30 <> ^IEE304) WHERE ^IEE28 = ^IEE303) OR (^IEE300 <> BLANK AND AnyOccurrence(^IEE32, ^IEE32 <> ^IEE300)))

            Technical Business Rule Format:
                    (^IEE116 = 'E') AND ^IEE1030 <> NULL AND ((AnyOccurrence(^IEE28, ^IEE28 <> ^IEE303)) OR (AnyOccurrence(^IEE30, ^IEE30 <> ^IEE304) WHERE ^IEE28 = ^IEE303) OR (^IEE300 <> BLANK AND AnyOccurrence(^IEE32, ^IEE32 <> ^IEE300)))
                                          
                                     OLD (^IEE203 <> NULL AND (AnyOccurrence(^IEE28, ^IEE28 <> ^IEE203)) OR AnyOccurrence(^IEE30, ^IEE30 <> ^IEE204) WHERE ^IEE28 = ^IEE203))) OR (^IEE88 <> NULL AND AnyOccurrence(^IEE32, ^IEE32 <> ^IEE88))

        Data Elements:
    
            ^IEE303 = IEE:RP:DeclarationOfTrusteeOrPartner:TrusteeOrPartnerIndividualNameDetails:PersonNameDetails.FamilyName.Text
    
            ^IEE28 = IEE:RP:InterposedEntityElectionRevocationDetails:TrusteeOrPartner:IndividualNameDetails:PersonNameDetails.FamilyName.Text
    
            ^IEE30 = IEE:RP:InterposedEntityElectionRevocationDetails:TrusteeOrPartner:IndividualNameDetails:PersonNameDetails.GivenName.Text
    
            ^IEE32 = IEE:RP:InterposedEntityElectionRevocationDetails:TrusteeOrPartner:OrganisationNameDetails.OrganisationalName.Text
    
            ^IEE116 = IEE:RP:InterposedEntityElectionRevocationDetails:Elections.InterposedEntityElectionOrRevocation.Code
    
            ^IEE300 = IEE:RP:DeclarationOfTrusteeOrPartner:OrganisationNameDetails.OrganisationalName.Text
    
            ^IEE304 = IEE:RP:DeclarationOfTrusteeOrPartner:TrusteeOrPartnerIndividualNameDetails:PersonNameDetails.GivenName.Text
    
            ^IEE1030 = IEE:RP:DeclarationOfTrusteeOrPartner:TrusteeOrPartnerIndividualNameDetails
            */
        protected void VRATOIEE410497(List<ProcessMessageDocument> response, IEE2021 report, bool isStandalone)
        {
            ProcessMessageDocument processMessage; 
           //TODO: Write manual rule for VR.ATO.IEE.410497
         if (report.RP_DeclarationOfTrusteeOrPartnerCollection == null) return;

            IEE2021.RP_DeclarationOfTrusteeOrPartner violator = null;
         if (report.IEE116!=null && report.IEE116.Equals("E"))
                {
                 if (report.RP_InterposedEntityElectionRevocationDetails_TrusteeOrPartnerCollection == null)
                 {
                    violator = report.RP_DeclarationOfTrusteeOrPartnerCollection[0];
                 }
                else foreach (IEE2021.RP_DeclarationOfTrusteeOrPartner d in report.RP_DeclarationOfTrusteeOrPartnerCollection)
                    {
                        if (   report.RP_InterposedEntityElectionRevocationDetails_TrusteeOrPartnerCollection.Find(t => t.IEE28 == d.IEE303 && t.IEE30 == d.IEE304) == null || d.IEE300 != null && report.RP_InterposedEntityElectionRevocationDetails_TrusteeOrPartnerCollection.Find(t => t.IEE32 == d.IEE300) == null)
                        {
                            violator = d;
                            break;
                        }
                    }
                if (violator != null)
                {
                    processMessage = new ProcessMessageDocument()
                    {
                        Code = "CMN.ATO.IEE.410269", Severity = ProcessMessageSeverity.Error,
                        Description = @"Invalid Trustee/partner Declaration Family name and Given name or non individual name.",
                        LongDescription = @"Trustee/partner Declaration Family name and Given name or non individual name must match at least one Trustee or partner Family name and Given name or non individual name.",
                        Location = $"/tns:IEE/tns:RP/tns:DeclarationOfTrusteeOrPartnerCollection/tns:DeclarationOfTrusteeOrPartner{OccurrenceIndex(violator.OccurrenceIndex)}/tns:TrusteeOrPartnerIndividualNameDetails/tns:PersonNameDetailsFamilyNameT",
                         Parameters = new ProcessMessageParameters
                         {
                               new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.IEE.410497"},
                               new ProcessMessageParameter { Name = "IEE300", Value = violator.IEE300 },
                                new ProcessMessageParameter { Name = "IEE303", Value = violator.IEE303 },
                                new ProcessMessageParameter { Name = "IEE304", Value = violator.IEE304 }
                        }
                    };
    
                     response.Add(processMessage);
               }
        }
    }


    
    
    #endregion // VR.ATO.IEE.410497


      

        #endregion Manual Rules - Rules marked for manual coding
    }
}
