using System;
using System.Collections.Immutable;
using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationPTR;
using VaTS;

namespace Ato.CD.Inbound.PTR202602
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<PTR2025, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            var builder = ImmutableDictionary.CreateBuilder<string, Func<PTR2025, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.PSS.ToString(), (report, schedule) => new CrossFormValidatorPSS(report, schedule));
            builder.Add(Schedule.RS.ToString(), (report, schedule) => new CrossFormValidatorRS(report, schedule));
            builder.Add(Schedule.IEE.ToString(), (report, schedule) => new CrossFormValidatorIEE(report, schedule));
            builder.Add(Schedule.IDS.ToString(), (report, schedule) => new CrossFormValidatorIDS(report, schedule));
            builder.Add(Schedule.DISTBENTRT.ToString(), (report, schedule) => new CrossFormValidatorDISTBENTRT(report, schedule));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(PTR2025 report, BusinessDocument schedule)
            => CrossFormValidators[schedule.DocumentName](report, schedule);
    }
}