using DataContracts;
using System.Collections.Generic;
using static Ato.CD.Inbound.Shared.ValidatorHelpers;

namespace Ato.EN.IntegrationServices.CodeGenerationSMSFAR
{
    public partial class SMSFAR2026Validator
    {
        #region VR.ATO.SMSFAR.437147

        /*  VR.ATO.SMSFAR.437147
            Subtotal 3 must equal zero.

            Legacy Rule Format:
            IF ([SMSFAR389] >= [SMSFAR304]) AND [SMSFAR390] <> 0
                RETURN VALIDATION MESSAGE
            ENDIF
                    
            [SMSFAR304] = SMSFAR:RP:rvctc1.02.07:IncomeTax.SubtotalTaxPayable.Amount
            [SMSFAR389] = SMSFAR:RP:rvctc1.02.08:IncomeTax.TaxOffsetNonRefundableCarryForward.Amount
            [SMSFAR390] = SMSFAR:RP:rvctc1.02.08:IncomeTax.TaxOffsetCarriedForwardSubTotal.Amount

            Technical Business Rule Format:
            (^SMSFAR389 >= ^SMSFAR304) AND ^SMSFAR390 <> 0

            Data Elements:
            
            RP:^SMSFAR390 = tns:IncomeTax.TaxOffsetCarriedForwardSubTotal.Amount
            
            RP:^SMSFAR304 = tns:IncomeTax.SubtotalTaxPayable.Amount
            
            RP:^SMSFAR389 = tns:IncomeTax.TaxOffsetNonRefundableCarryForward.Amount
        */
        protected void VRATOSMSFAR437147(List<ProcessMessageDocument> response, SMSFAR2026 report)
        {
            bool assertion = report.SMSFAR389.GetValueOrDefault() >= report.SMSFAR304.GetValueOrDefault() &&
                             report.SMSFAR390.GetValueOrDefault() != 0;
            if (assertion)
            {
                response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.SMSFAR.437147",
                    Severity = ProcessMessageSeverity.Error,
                    Description = "Subtotal 3 must equal zero.",
                    LongDescription = "Where non-refundable carry forward tax offsets is greater than or equal to Subtotal 2, Subtotal 3 must equal zero.",
                    Location = "/xbrli:xbrl/tns:IncomeTax.TaxOffsetCarriedForwardSubTotal.Amount",
                    Parameters = new ProcessMessageParameters
                    {
                        new ProcessMessageParameter { Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.437147" },
                        new ProcessMessageParameter { Name = "SMSFAR389", Value = report.SMSFAR389.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter { Name = "SMSFAR304", Value = report.SMSFAR304.GetValueOrDefault().ToString() },
                        new ProcessMessageParameter { Name = "SMSFAR390", Value = report.SMSFAR390.GetValueOrDefault().ToString() }

                    }
                });
            }
        }
        #endregion // VR.ATO.SMSFAR.437147

        #region VR.ATO.SMSFAR.437169

        /*  VR.ATO.SMSFAR.437169
            Member closing account balance must equal the sum of the accumulation phase account balance, the retirement phase account balance - Non-capped defined benefit income stream and retirement phase account balance - Capped defined benefit income stream

            Legacy Rule Format:
            WHERE IN TUPLE(smsfar.0010.lodge.req.xx.xx:MemberInformation)
            IF ([SMSFAR223] = NULL OR [SMSFAR223] >= 0) AND ([SMSFAR223] <> ([SMSFAR393] + [SMSFAR394] + [SMSFAR395]))
                RETURN VALIDATION MESSAGE
            ENDIF

            Technical Business Rule Format:
            (^SMSFAR223 = NULL OR ^SMSFAR223 >= 0) AND (^SMSFAR223 <> (^SMSFAR393 + ^SMSFAR394 + ^SMSFAR395))

            Data Elements:
    
            ^SMSFAR223 = RP.Closing:MemberInformation:SuperannuationBenefit.AccountBalance.Amount
    
            ^SMSFAR393 = RP.Closing.Accumulation:MemberInformation:SuperannuationBenefit.AccountBalance.Amount
    
            ^SMSFAR394 = RP.Closing.Retirement:MemberInformation:SuperannuationBenefit.NonCappedDefinedBenefitIncomeStream.Amount
    
            ^SMSFAR395 = RP.Closing.Retirement:MemberInformation:SuperannuationBenefit.CappedDefinedBenefitIncomeStream.Amount
        */
        protected void VRATOSMSFAR437169(List<ProcessMessageDocument> response, SMSFAR2026 report)
        {
            ProcessMessageDocument processMessage;
            bool assertion; 

            if (report.MemberInformationCollection != null)
                foreach (SMSFAR2026.MemberInformation memberInformation in report.MemberInformationCollection)
                {
                    assertion = ((memberInformation.SMSFAR223 == null || memberInformation.SMSFAR223.GetValueOrDefault() >= 0) && memberInformation.SMSFAR223 != memberInformation.SMSFAR393.GetValueOrDefault() + memberInformation.SMSFAR394.GetValueOrDefault() + memberInformation.SMSFAR395.GetValueOrDefault());
                    if (assertion)
                    {
                        processMessage = new ProcessMessageDocument()
                        {
                            Code = "CMN.ATO.SMSFAR.437169",
                            Severity = ProcessMessageSeverity.Error,
                            Description = @"Invalid amount. Member closing account balance incorrect.",
                            LongDescription = @"Member closing account balance must equal the sum of the accumulation phase account balance, the retirement phase account balance - Non-capped defined benefit income stream and retirement phase account balance - Capped defined benefit income stream.",
                            Location = "/xbrli:xbrl/tns:MemberInformation" + OccurrenceIndex(memberInformation.OccurrenceIndex) + "/tns:SuperannuationBenefit.AccountBalance.Amount[@contextRef='" + report.RPClosingId + "']",
                            Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.SMSFAR.437169" } },
                        };
                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "SMSFAR223", Value = GetValueOrEmpty(memberInformation.SMSFAR223) });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "SMSFAR393", Value = GetValueOrEmpty(memberInformation.SMSFAR393) });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "SMSFAR394", Value = GetValueOrEmpty(memberInformation.SMSFAR394) });

                        processMessage.Parameters.Add(new ProcessMessageParameter
                        { Name = "SMSFAR395", Value = GetValueOrEmpty(memberInformation.SMSFAR395) });

                        response.Add(processMessage);
                    }
                }
        }
        #endregion // VR.ATO.SMSFAR.437169
    }
}