using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using System;
using System.Collections.Immutable;
using VaTS;

namespace Ato.CD.Inbound.TRTAMI202602
{
    internal class CrossFormLocator
    {
        private static readonly ImmutableDictionary<string, Func<TRTAMI2026, BusinessDocument, ICrossFormValidator>> CrossFormValidators;

        static CrossFormLocator()
        {
            ImmutableDictionary<string, Func<TRTAMI2026, BusinessDocument, ICrossFormValidator>>.Builder builder = ImmutableDictionary.CreateBuilder<string, Func<TRTAMI2026, BusinessDocument, ICrossFormValidator>>();

            builder.Add(Schedule.CGTS.ToString(), (parent, schedule) => new CrossFormValidatorCGTS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.IDS.ToString(), (parent, schedule) => new CrossFormValidatorIDS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.PSS.ToString(), (parent, schedule) => new CrossFormValidatorPSS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.RS.ToString(), (parent, schedule) => new CrossFormValidatorRS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.RPTTAXPOS.ToString(), (parent, schedule) => new CrossFormValidatorRPTTAXPOS(parent, schedule.ConsumedReport));
            builder.Add(Schedule.TRTAMIS.ToString(), (parent, schedule) => new CrossFormValidatorTRTAMIS(parent, schedule.ConsumedReport));

            CrossFormValidators = builder.ToImmutable();
        }

        internal static ICrossFormValidator LocateCrossFormValidatorFor(TRTAMI2026 parent, BusinessDocument schedule) => CrossFormValidators[schedule.DocumentName](parent, schedule);
    }
}
