using Ato.CD.Inbound.Shared;
using Ato.EN.IntegrationServices.CodeGenerationIDS;
using Ato.EN.IntegrationServices.CodeGenerationTRTAMI;
using DataContracts;
using System.Collections.Generic;
using System.Runtime.CompilerServices;

namespace Ato.CD.Inbound.TRTAMI202602
{
    public class CrossFormValidatorIDS : ICrossFormValidator
    {
        private IDS2025 ChildDocument { get; set; }
        
        public List<ProcessMessageDocument> Response { get; private set; }

        private TRTAMI2026 ParentDocument { get; set; }

        public CrossFormValidatorIDS(TRTAMI2026 parent, object child)
        {
            ChildDocument = (IDS2025)child;
            ParentDocument = parent;
            Response = new List<ProcessMessageDocument>();
        }

        public List<ProcessMessageDocument> ValidateCrossFormRules()
        {
            VRATOIDS440670();

            return Response;
        }

        #region Validation Rules

        #region VR.ATO.IDS.440670

        /*  VR.ATO.IDS.440670
        Your supplied TFN does not match the TFN supplied on the form it was submitted with

        Technical Business Rule Format:
        ^IDS500 <> ^ParentTFN

        Data Elements:

        ^TRTAMI4 = TRTAMI:RP:Identifiers.TaxFileNumber.Identifier

        ^IDS500 = IDS:RP:Identifiers.TaxFileNumber.Identifier
        */
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public virtual void VRATOIDS440670()
        {
            bool assertion = !ChildDocument.IDS500.Equals(ParentDocument.TRTAMI4);

            if (assertion)
            {
                Response.Add(new ProcessMessageDocument
                {
                    Code = "CMN.ATO.GEN.402009",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Your supplied TFN does not match the TFN supplied on the form it was submitted with",
                    LongDescription = @"Your supplied TFN does not match the TFN supplied on the parent form it was submitted with",
                    Location = "/tns:IDS/tns:RP/tns:TaxFileNumberId",
                    Parameters = new ProcessMessageParameters()
                    {
                        new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.IDS.440670" },
                        new ProcessMessageParameter() { Name = "TRTAMI4", Value = TRTAMI2026Validator.GetValueOrEmpty(ParentDocument.TRTAMI4) },
                        new ProcessMessageParameter() { Name = "IDS500", Value = TRTAMI2026Validator.GetValueOrEmpty(ChildDocument.IDS500) }
                    }
                });
            }
        }

        #endregion // VR.ATO.IDS.440670

        #endregion
    }
}
